/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.io.File;
import java.util.logging.Level;

/**
    Class which contains Meta data for all types of attributes which is present in Validation Descriptor
 *  XML File
 *
 *  Sample
 *      <attribute name=<Name> type="address" />
 *      <attribute name=<Name> type="integer" range="low,high" />
 *      <attribute name=<Name> type="string"  max-length="length" />
    
    @author Srinivas Krishnan
    @version 2.0
*/

/* Class for attribute type file */

public final class AttrClassName extends AttrType {
    
    public AttrClassName(String name, String type, boolean optional) {
        super(name,type, optional);
    }
    
    public void validate(Object o, ValidationContext valCtx) {
        _logger.log(Level.CONFIG, "Testing attr: "+valCtx.attrName);

	super.validate(o, valCtx); // call to common validator first
        if(o == null)
		return;
        if(o.equals(""))
            valCtx.result.failed(valCtx.smh.getLocalString(getClass().getName() + ".nullClassName",
                                        "Attribute({0}=\"\" : ClassName not Valid", new Object[] {valCtx.attrName}));
   
        // Remove the package, extract the identifier alone                                        
        String className = (String)o;                                        
        int classStart = className.lastIndexOf(".");
        if(classStart != -1)
            className = className.substring(classStart+1);
        if(!isValidClassName(className)){
            valCtx.result.failed(valCtx.smh.getLocalString(getClass().getName() + ".invalidClassName",
                                        "Attribute({0}={1}) : ClassName not Valid", new Object[] {valCtx.attrName, (String)o}));
        }
    }
    
    public static boolean isValidClassName(String className) {
        boolean valid = true;
        for(int i=0;i<className.length();i++) {
            if(i == 0) {
                if(!Character.isJavaIdentifierStart(className.charAt(i)))
                    valid = false;
            }
            if(!Character.isJavaIdentifierPart(className.charAt(i)))
                valid = false;
        }
        return valid;
    }
}
