/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.util.List;
import java.util.Collections;

/**
   Class which contains Meta data for all types of attributes which is present in Validation Descriptor
   *  XML File
   *
   *  Sample
   *      <attribute name=<Name> type="address" />
   *      <attribute name=<Name> type="integer" range="low,high" />
   *      <attribute name=<Name> type="string"  max-length="length" />
    
   @author Srinivas Krishnan
   @version 2.0
*/

/* Class for attribute type String */
 
public final class AttrString extends AttrType {
    final int maxLength;
    final List<String> ee;
    final String expr;
    
    public AttrString(
        final String name,
        final String type,
        final boolean optional,
        final int     maxLength,
        final List<String>  enumString,
        final String  regex
        ) {
        super(name,type, optional);
        this.maxLength  = maxLength;
        this.ee         = enumString == null ? null : Collections.unmodifiableList( enumString );
        this.expr       = regex;
    }
    
    
    public int getMaxLength() {
        return maxLength;
    }
    
        public List<String>
    getEnumeration() {
        return ee;
    }
    
    public void validate(Object o, ValidationContext valCtx) {
        super.validate(o, valCtx); // call to common validator first
        if(o == null) {
            return; 
        }
        
        final String str = (String)o;
        if(0 != maxLength && str.length() > maxLength) {
            reportAttributeError(valCtx, "invalidStringLength",
                "Attribute[{0}={1}] : String {2} length is greather than maximum length {3}",
                new Object[] {valCtx.attrName, str, str, String.valueOf(maxLength)});
        }
        if(null != ee && !ee.contains(str) ){
            reportAttributeError(valCtx, "strInvalidEnum",
                "Attribute({0}={1}) : Invalid String - Required {2}",
                new Object[] {valCtx.attrName, str, ee.toString()});
        }
        
        if(null != expr && !str.matches(expr)) 
        {
            String printOwnerName = GenericValidator.getConfigElementPrintName(
                valCtx, getFutureXPathForValidatingAttribute(valCtx), false, false);
            String generic_descr = valCtx.smh.getLocalString(
                "default_pattern_description",
                "Please refer to admin documentation." );
            String descr = valCtx.smh.getLocalString(
                "pattern_description_for_" + (expr.replaceAll("[\\\\=:]", "`")),
                generic_descr );
            
            reportAttributeError(valCtx, "regexpNotMatch",
                "Value \"{1}\" is not valid for attribute \"{0}\" of {2}. {3}", 
                new Object[] {valCtx.attrName, str, printOwnerName, descr});
        }
    }
}

