/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

//jdk imports
import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.io.File;
import java.util.StringTokenizer;
import java.util.HashMap;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

import java.util.StringTokenizer;
import java.lang.Class;
import java.lang.reflect.Constructor;
import java.net.URL;

// Logging
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.admin.AdminValidationException;

// config imports
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.meta.MBeanRegistry;


import com.sun.appserv.management.util.misc.RunnableBase;
import com.sun.appserv.management.util.misc.TimingDelta;
import com.sun.appserv.management.util.misc.Timings;

/**
 *  Class which loads all the validator descriptor information from a xml file into a hash map. 
 *  Validator uses this Hash Map and invokes the particular test case depending on xml tag

    @author Srinivas Krishnan
    @version 2.0
*/

public class DomainMgr implements ConfigContextEventListener {
    private static final Timings    TIMINGS = Timings.newInstance( "DomainMgr" );
    
    // Logging
    static final Logger _logger = LogDomains.getLogger(LogDomains.APPVERIFY_LOGGER);
    final LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    final HashMap<String,GenericValidator> tests = new HashMap<String,GenericValidator>();
    public final NameListMgr _nameListMgr;
    public final MBeanRegistry _mbeanRegistry;
    public DomainMgr() {
        this(MBeanRegistryFactory.getAdminContext().getAdminConfigContext(), false);
    }

    public DomainMgr(ConfigContext ctx, boolean bStaticContext) {
        this(ctx, bStaticContext, null);
    }
   
    public DomainMgr(ConfigContext ctx, boolean bStaticContext, MBeanRegistry registry) {
    final TimingDelta delta = new TimingDelta();
        loadDescriptors();
TIMINGS.add( "DomainMgr-1", delta );
        _nameListMgr = new NameListMgr(ctx, bStaticContext);
TIMINGS.add( "DomainMgr-2", delta );
        if(registry==null)
            _mbeanRegistry = MBeanRegistryFactory.getAdminMBeanRegistry();
        else
            _mbeanRegistry = registry;
TIMINGS.add( "DomainMgr-3", delta );
System.out.println("\n" + TIMINGS.toString() );
    }
    
    MBeanRegistry getMBeanRegistry()
    {
        return _mbeanRegistry;
    }
    
    private DomainMgr   getThis() { return this; }
    
    // Get the path of validation descriptor xml file from System property class path
    private String getTestFile() throws Exception {
        URL propertiesFile = DomainMgr.class.getClassLoader().getResource(
            "com/sun/enterprise/config/serverbeans/validation/config/ServerTestList.xml");
//TODO: for test only
//  URL propertiesFile = (new File("/ias/admin/validator/descr.xml")).toURL();
        return propertiesFile.toString();
    }

    private final class NodeListProcessor extends RunnableBase {
        private final NodeList  mNodeList;
        private final int       mStartIndex;
        private final int       mCount;
        private final HashMap<String,GenericValidator> mTests = new HashMap<String,GenericValidator>();
    
        public NodeListProcessor(final NodeList nodeList, final int startIndex, final int count) {
            mNodeList   = nodeList;
            mStartIndex = startIndex;
            mCount      = count;
        }
        
        public HashMap<String,GenericValidator> getTests()  { return mTests; }
        
        protected void doRun() throws Exception {
        final TimingDelta   delta   = new TimingDelta();
            final NodeList list = mNodeList;
            
            for (int offset  = 0; offset < mCount; ++offset) {
                final Element e = (Element) list.item( mStartIndex + offset );
                final String elementName  =  e.getAttribute("name");
                String elementXPath =  e.getAttribute("xpath");
                String elementCustomClass = e.getAttribute("custom-class") ;
                String testName = e.getAttribute("test-name");
                if(testName==null || testName.length()==0)
                {
                    testName = XPathHelper.convertName(elementName);
                }
                if (null == elementCustomClass || elementCustomClass.length() == 0){
                    elementCustomClass = testName;
                }
                String[] required_children = null;
                String[] exclusive_list    = null;
                String elemList = e.getAttribute("required-children");
                if(elemList!=null && elemList.length()>0)
                {
                    required_children = elemList.split(",");
                }
                elemList = e.getAttribute("exclusive-list");
                if(elemList!=null && elemList.length()>0)
                {
                    exclusive_list = elemList.split(",");
                }
                String key = e.getAttribute("key");
                if(key!=null && key.length()==0)
                    key = null;
                List<AttrType> attributes = new ArrayList<AttrType>();
                final NodeList nl = e.getChildNodes();
                for (int index=0,j=0;j<nl.getLength();j++) {
                    String temp;
                    final String nodeName = nl.item(j).getNodeName().trim();
                    String nameValue=null;
                    String typeValue=null;
                    NamedNodeMap nodeMap=null;
                    AttrType attr=null;
                   
                    final Node n = nl.item(j);
                    
                    if("attribute".equals(nodeName) || "optional-attribute".equals(nodeName)) {
                        nodeMap = n.getAttributes();

                        nameValue   = getAttr(nodeMap, "name");
                        typeValue   = getAttr(nodeMap, "type");
                        if("string".equals(typeValue)) 
                        {
                            temp = getAttr(nodeMap, "max-length");
                            final int maxLength = (temp == null) ? 0 : Integer.parseInt(temp);
                            
                            List<String> enumString = null;
                            temp = getAttr(nodeMap, "enumeration");
                            if ( temp != null )
                            {
                                enumString = new ArrayList<String>();
                                final String[] strs = temp.split(",");
                                for(int k=0; k<strs.length; k++)
                                {
                                    enumString.add(strs[k]);
                                }
                            }
                            final String regex = getAttr(nodeMap, "regex");
                            
                            attr = new AttrString(nameValue, typeValue,
                                        "optional-attribute".equals(nodeName),
                                        maxLength, enumString, regex );
                        }
                        else if("file".equals(typeValue)) 
                        {
                            temp    = getAttr(nodeMap, "exists");
                            final boolean checkExists = (temp == null) ?
                                    false : "true".equalsIgnoreCase(temp);
                            
                            attr = new AttrFile(nameValue, typeValue,
                                    "optional-attribute".equals(nodeName), checkExists );
                        }
                        else if("integer".equals(typeValue))
                        {
                            int lowRange    = AttrInt.IGNORE_LOW;
                            int highRange   = AttrInt.IGNORE_HIGH;
                            temp    = getAttr(nodeMap, "range");
                            if(temp != null) 
                            {
                                final String[] strs = temp.split(",");
                                if(!strs[0].equals("NA"))
                                    lowRange    = Integer.parseInt(strs[0]);
                                if(!strs[1].equals("NA"))
                                    highRange   = Integer.parseInt(strs[1]);
                            }
                            
                            attr = new AttrInt(nameValue,typeValue,
                                    "optional-attribute".equals(nodeName), lowRange, highRange );
                        }
                        else if("classname".equals(typeValue))
                            attr = new AttrClassName(nameValue, typeValue, "optional-attribute".equals(nodeName));
                        else if("address".equals(typeValue)) 
                            attr = new AttrAddress(nameValue,typeValue, "optional-attribute".equals(nodeName));
                        else if("jndi-unique".equals(typeValue)) 
                            attr = new AttrUniqueJNDI(nameValue,typeValue, "optional-attribute".equals(nodeName));

                        if(attr != null) 
                        {
                            attr.addRuleValue("belongs-to",     getAttrAsList(nodeMap, "belongs-to"));
                            attr.addRuleValue("references-to",  getAttrAsList(nodeMap, "references-to"));
                            attr.addRuleValue("le-than", getAttr(nodeMap, "le-than"));
                            attr.addRuleValue("ls-than", getAttr(nodeMap, "ls-than"));
                            attr.addRuleValue("ge-than", getAttr(nodeMap, "ge-than"));
                            attr.addRuleValue("gt-than", getAttr(nodeMap, "gt-than"));

                            attributes.add(index++,attr);
                        }
                    }
                }
                final ValidationDescriptor desc =
                       new ValidationDescriptor( getThis(), elementName, 
                            elementXPath, elementCustomClass, 
                            key, attributes, required_children, exclusive_list);
                final GenericValidator validator= getGenericValidator(desc);
                
                if(validator != null) {
                    mTests.put(testName, validator);
                }
            }
        }
    };
        
        // Loads all validation descriptors from XML file into the Hash Map
    public boolean loadDescriptors() {
        final TimingDelta delta = new TimingDelta();
        boolean allIsWell = true;
       
        try {
            //tests.clear();
            final DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            final InputSource is = new InputSource(getTestFile());
            final Document doc = db.parse(is);
            final NodeList nodeList = doc.getElementsByTagName("element");
            
            // divide the task up if more than two processors are present
            final int numNodes  = nodeList.getLength();
            int numProcessors = Runtime.getRuntime().availableProcessors();
            if ( numProcessors <= 2 ) {
                numProcessors   = 1;    // other threads are running in AdminService
            }
            
            final NodeListProcessor[] processors  = new NodeListProcessor[ numProcessors ];
            final int numPer  = numNodes / numProcessors;
            int offset  = 0;
            for( int i = 0; i < numProcessors - 1; ++i ) {
                processors[i]   = new NodeListProcessor( nodeList, offset, numPer );
                processors[i].submit( RunnableBase.SUBMIT_ASYNC );
                offset  += numPer;
            }
            final int remaining = numNodes - offset;
            processors[numProcessors-1] = new NodeListProcessor(nodeList, offset, remaining);
            processors[numProcessors-1].submit( RunnableBase.SUBMIT_SYNC );  // run on this thread
            
            // wait for each, and take its results
            for (int i=0; i < numProcessors; ++i) {
                processors[i].waitDoneThrow();
                tests.putAll( processors[i].getTests() );
            }
        } catch (ParserConfigurationException e) {
            _logger.log(Level.WARNING, "parser_error", e);
            allIsWell = false;
        } catch (SAXException e) {
            _logger.log(Level.WARNING, "sax_error", e);
            allIsWell = false;     
        } catch (IOException e) {
            _logger.log(Level.WARNING, "error_loading_xmlfile", e);
            allIsWell = false;
        } catch(Exception e) {
            _logger.log(Level.WARNING, "error", e);
            allIsWell = false;
        }
        return allIsWell;
    }


    /*
    // Loads all validation descriptors from XML file into the Hash Map
    public boolean loadDescriptors() {
        boolean allIsWell = true;
       
        try {
            //tests.clear();
            final DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            final InputSource is = new InputSource(getTestFile());
            final Document doc = db.parse(is);
            final NodeList list = doc.getElementsByTagName("element");
            for (int i=0;i<list.getLength();i++) {
                final Element e = (Element) list.item(i);
                final String elementName  =  e.getAttribute("name");
                String elementXPath =  e.getAttribute("xpath");
                String elementCustomClass = e.getAttribute("custom-class") ;
                String testName = e.getAttribute("test-name");
                if(testName==null || testName.length()==0)
                {
                    testName = XPathHelper.convertName(elementName);
                }
                if (null == elementCustomClass || elementCustomClass.length() == 0){
                    elementCustomClass = testName;
                }
                String[] required_children = null;
                String[] exclusive_list    = null;
                String elemList = e.getAttribute("required-children");
                if(elemList!=null && elemList.length()>0)
                {
                    required_children = elemList.split(",");
                }
                elemList = e.getAttribute("exclusive-list");
                if(elemList!=null && elemList.length()>0)
                {
                    exclusive_list = elemList.split(",");
                }
                String key = e.getAttribute("key");
                if(key!=null && key.length()==0)
                    key = null;
                List<AttrType> attributes = new ArrayList<AttrType>();
                NodeList nl = e.getChildNodes();
                for (int index=0,j=0;j<nl.getLength();j++) {
                    String temp;
                    final String nodeName = nl.item(j).getNodeName().trim();
                    String nameValue=null;
                    String typeValue=null;
                    NamedNodeMap nodeMap=null;
                    AttrType attr=null;
                   
                    final Node n = nl.item(j);
                    
                    if("attribute".equals(nodeName) || "optional-attribute".equals(nodeName)) {
                        nodeMap = n.getAttributes();

                        nameValue   = getAttr(nodeMap, "name");
                        typeValue   = getAttr(nodeMap, "type");
                        if("string".equals(typeValue)) 
                        {
                            temp = getAttr(nodeMap, "max-length");
                            final int maxLength = (temp == null) ? 0 : Integer.parseInt(temp);
                            
                            List<String> enumString = null;
                            temp = getAttr(nodeMap, "enumeration");
                            if ( temp != null )
                            {
                                enumString = new ArrayList<String>();
                                final String[] strs = temp.split(",");
                                for(int k=0; k<strs.length; k++)
                                {
                                    enumString.add(strs[k]);
                                }
                            }
                            final String regex = getAttr(nodeMap, "regex");
                            
                            attr = new AttrString(nameValue, typeValue,
                                        "optional-attribute".equals(nodeName),
                                        maxLength, enumString, regex );
                        }
                        else if("file".equals(typeValue)) 
                        {
                            temp    = getAttr(nodeMap, "exists");
                            final boolean checkExists = (temp == null) ?
                                    false : "true".equalsIgnoreCase(temp);
                            
                            attr = new AttrFile(nameValue, typeValue,
                                    "optional-attribute".equals(nodeName), checkExists );
                        }
                        else if("integer".equals(typeValue))
                        {
                            int lowRange    = AttrInt.IGNORE_LOW;
                            int highRange   = AttrInt.IGNORE_HIGH;
                            temp    = getAttr(nodeMap, "range");
                            if(temp != null) 
                            {
                                final String[] strs = temp.split(",");
                                if(!strs[0].equals("NA"))
                                    lowRange    = Integer.parseInt(strs[0]);
                                if(!strs[1].equals("NA"))
                                    highRange   = Integer.parseInt(strs[1]);
                            }
                            
                            attr = new AttrInt(nameValue,typeValue,
                                    "optional-attribute".equals(nodeName), lowRange, highRange );
                        }
                        else if("classname".equals(typeValue))
                            attr = new AttrClassName(nameValue, typeValue, "optional-attribute".equals(nodeName));
                        else if("address".equals(typeValue)) 
                            attr = new AttrAddress(nameValue,typeValue, "optional-attribute".equals(nodeName));
                        else if("jndi-unique".equals(typeValue)) 
                            attr = new AttrUniqueJNDI(nameValue,typeValue, "optional-attribute".equals(nodeName));

                        if(attr != null) 
                        {
                            attr.addRuleValue("belongs-to",     getAttrAsList(nodeMap, "belongs-to"));
                            attr.addRuleValue("references-to",  getAttrAsList(nodeMap, "references-to"));
                            attr.addRuleValue("le-than", getAttr(nodeMap, "le-than"));
                            attr.addRuleValue("ls-than", getAttr(nodeMap, "ls-than"));
                            attr.addRuleValue("ge-than", getAttr(nodeMap, "ge-than"));
                            attr.addRuleValue("gt-than", getAttr(nodeMap, "gt-than"));

                            attributes.add(index++,attr);
                        }
                    }
                }
                final ValidationDescriptor desc =
                       new ValidationDescriptor(this, elementName, 
                            elementXPath, elementCustomClass, 
                            key, attributes, required_children, exclusive_list);
                final GenericValidator validator= getGenericValidator(desc);
                
                if(validator != null) {
                    tests.put(testName, validator);
                }
            }
        } catch (ParserConfigurationException e) {
            _logger.log(Level.WARNING, "parser_error", e);
            allIsWell = false;
        } catch (SAXException e) {
            _logger.log(Level.WARNING, "sax_error", e);
            allIsWell = false;     
        } catch (IOException e) {
            _logger.log(Level.WARNING, "error_loading_xmlfile", e);
            allIsWell = false;
        } catch(Exception e) {
            _logger.log(Level.WARNING, "error", e);
            allIsWell = false;
        }
        return allIsWell;
    }
    */
    
    private String getAttr(NamedNodeMap nodeMap, String attrName)
    {
        Node node = nodeMap.getNamedItem(attrName);
        if(node != null)
            return node.getNodeValue();
        return null;
    }
    
    private String[] getAttrAsList(NamedNodeMap nodeMap, String attrName)
    {
        String attrValue = getAttr(nodeMap, attrName);
        if(attrValue==null)
            return null;
        return attrValue.split(",");
    }
        /**
         * Get the generic validator to be used for the given
         * validation descriptor
         * @param v the validation descriptor
         * @return a GenericValidator instance that is to be used to
         * validate elements which match the ValidationDescription
         */
    GenericValidator getGenericValidator(final ValidationDescriptor v) throws InstantiationException, IllegalAccessException, java.lang.reflect.InvocationTargetException{
        final Class c = getValidatorClass(v.getCustomValidatorClass());
        try {
            final Constructor con = c.getConstructor(new Class[]{ValidationDescriptor.class});
            return (GenericValidator) con.newInstance(new Object[]{v});
        }
        catch (NoSuchMethodException e){
            return null;
        }
        
    }
    
        /**
         * Find a class that will perform validation for the given
         * class name. The class returned is the first that can be
         * loaded from the following ordered list:
         * <ol>
         * <li>The class as specified by the className param</li>
         * <li>The class as specified by the className param,
         * prepended with the TEST_PACKAGE package name. </li>
         * <li>The GenericValidator class</li>
         * Setting the log level to CONFIG will provide logging
         * information as to which class was actually found and loaded.
         * @param className the name of the class for which a
         * validator class is to be found
         * @return the class which is to be used for validation
         **/
    Class getValidatorClass(final String className){
        Class c;
        final String cn = TEST_PACKAGE+className+"Test";
            try {
            c= Class.forName(cn);
        }
        catch (ClassNotFoundException cnfe2){
            c = GenericValidator.class;
        }
        _logger.log(Level.CONFIG, "validator using class \""+c.getName()+"\" to validate \""+cn+"\"");
        return c;
    }
    
    // Method invokes the validation function of the test case
    public Result check(ConfigContextEvent cce) {
        String name = cce.getName();
        String beanName = cce.getBeanName();
        Result result = null;


        if(name == null && beanName == null)
                return result;
        
        DomainCheck validator = (DomainCheck) tests.get(name);
        if(validator == null && beanName != null)
            validator = (DomainCheck) tests.get(beanName);
        try {
            if(validator != null)
                result = validator.validate(cce);
        } catch(Exception e) {
//System.out.println("+++++name="+name + " xpath=" + ((ConfigBean)cce.getObject()).getXPath());
            _logger.log(Level.WARNING, "domainxmlverifier.error_on_validation", e);
        }
        return result;
    }
    
    public void postAccessNotification(ConfigContextEvent ccce) {
    }
    
    public void postChangeNotification(ConfigContextEvent ccce)  {
    }
    
    public void preAccessNotification(ConfigContextEvent ccce) {
    }
    
    // Function invoked by the Config Bean for validation before writing into domain.xml
    // Registered as listeners with ConfigContext while creation
    public void preChangeNotification(ConfigContextEvent cce) {
        Result result = null;
        try{
           result = check(cce);
        } catch(Throwable t)
        {
            _logger.log(Level.WARNING, "Exception during validation ", t);
        }
        
        if(result != null && result.getStatus() == Result.FAILED)
        {
            _logger.log(Level.WARNING, "Validation error: " + result.getErrorDetails().toString());
            throw new AdminValidationException(result.getErrorDetailsAsString());
        }
    }
    ValidationDescriptor findValidationDescriptor(String beanName)
    {
        if(beanName!=null)
        {
            GenericValidator genVal = (GenericValidator)tests.get(beanName);
            if(genVal!=null)
                return genVal.desc;
        }
        return null;
    }

    GenericValidator findConfigBeanValidator(ConfigBean configBean)
    {
        
        if(configBean!=null)
        {
            String className = configBean.getClass().getName();
            int iLastDot = className.lastIndexOf('.');
            if(iLastDot>0)
               return (GenericValidator)tests.get(className.substring(iLastDot+1));
        }
        return null;
    }
    
    public static final String TEST_PACKAGE="com.sun.enterprise.config.serverbeans.validation.tests.";
}
