/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.util.HashMap;
import java.util.Map;


/**
   A class that provides access to a collection of frames
*/


/**
 * FrameHolder.java
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.3 $
 */

class FrameHolder {
    public boolean equals(Object o){
        return o == this ||
        (o != null && o instanceof FrameHolder && this.equals((FrameHolder) o));
    }

    private boolean equals(FrameHolder o){
        return this.domain.equals( o.domain) &&
        this.configFrames.equals(o.configFrames) &&
        this.serverFrames.equals(o.serverFrames) &&
        this.clusterFrames.equals(o.clusterFrames);
    }

    public int hashCode(){
        return getDomainFrame().hashCode();
    }
    
    Frame getDomainFrame(){
        return domain;
    }

    Frame getConfigFrame(String n) {
        return memoizedGet(configFrames, n);
    }

    Frame getServerFrame(String n){
        return memoizedGet(serverFrames, n);
    }

    Frame getClusterFrame(String n){
        return memoizedGet(clusterFrames, n);
    }

    private final Frame memoizedGet(Map m, String n){
        Frame result = (Frame) m.get(n);
        if (result == null) {
            result = Frame.newFrame();
            m.put(n, result);
        }
        return result;
    }


    private final Frame domain = Frame.newFrame();
    private final Map configFrames = new HashMap();
    private final Map serverFrames = new HashMap();
    private final Map clusterFrames = new HashMap();
    
    
    
}
