/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;


import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;

// Logging
import com.sun.enterprise.util.LocalStringManagerImpl;


public class ValidationContext {
    public final Result result;
    public final Object value;
    public final Object classObject;
    public final String beanName;
    public final ConfigContext context;
    public final String name;
    public final String choice;
    public final LocalStringManagerImpl smh;
    public final String primaryKeyName;
    public final ValidationDescriptor validationDescriptor;
    //-------------- prepared in GenericValidator
    public String       attrName;
    public Object       attrValue;


    public ValidationContext(Result result, Object value, Object classObject, String beanName, ConfigContext context, String name, String choice, String primaryKeyName, LocalStringManagerImpl smh, ValidationDescriptor validationDescriptor) {
        this.result =  result;
        this.value = value;
        this.beanName = beanName;
        this.context = context;
        this.name = name;
        this.choice = choice;
        this.smh = smh;
        this.primaryKeyName = primaryKeyName;
        this.classObject = classObject;
        this.validationDescriptor = validationDescriptor;
        attrName = null;
    }
    
    public void setAttrName(String name) {
        attrName = name;
    }
    
    public String getPrimaryKeyName() {
        return primaryKeyName;
    }
    public boolean isUPDATEorSET()
    {
        return (choice != null && choice.equals(StaticTest.UPDATE) || choice.equals(StaticTest.SET));
    }
    public boolean isUPDATE()
    {
        return (choice != null && 
               (choice.equals(StaticTest.UPDATE) ||
                (choice.equals(StaticTest.SET) && 
                 ((value instanceof String)) || (value instanceof String[]))) );
    }
    public boolean isSET()
    {
        return (choice != null && choice.equals(StaticTest.SET) && (value instanceof ConfigBean) );
    }
    public boolean isADD()
    {
        return (choice != null && choice.equals(StaticTest.ADD));
    }
    public boolean isDELETE()
    {
        return (choice != null && choice.equals(StaticTest.DELETE));
    }
    public boolean isVALIDATE()
    {
        return (choice != null && choice.equals(StaticTest.VALIDATE));
    }
    public ConfigBean getTargetBean()
    {
        if ((isSET()||isADD()||isDELETE()||isVALIDATE()) && (value instanceof ConfigBean) )
            return (ConfigBean)value;
        if ((isUPDATE()) && (classObject instanceof ConfigBean))
            return (ConfigBean)classObject;
        return null;
    }
    public ConfigBean getParentBean()
    {
        if ((isSET()||isADD()) && (classObject instanceof ConfigBean) )
            return (ConfigBean)classObject;
        ConfigBean self = getTargetBean();
        try {
            return (ConfigBean)self.parent();
        } catch(Throwable t) {}
        return null;
    }
        
    public NameListMgr getNameListMgr()
    {
        return validationDescriptor.domainMgr._nameListMgr;
    }
}    