/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import java.util.logging.Level;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.connectors.ConnectorRuntime;
import java.util.Set;
import java.util.logging.Level;

/**
    Custom Test for Connector Connection Pool Test which calls the Generic Validation before performing custom tests

    @author Srinivas Krishnan
    @version 2.0
*/

public class ConnectorConnectionPoolTest extends GenericValidator {
    
    int maxPoolSize = 0;
    
    public ConnectorConnectionPoolTest(ValidationDescriptor desc) {
        super(desc);
    } 
    
    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce); // Before doing custom validation do basic validation
        String choice = cce.getChoice();

        if(choice.equals(StaticTest.UPDATE)) {
            validateAttribute(cce.getName(), (String) cce.getObject(), result);
        }
        return result;
    }



        
    
    public void validateAttribute(String name, String value, Result result) {
        if(value == null || value.equals("")) 
            return;
        if(name.equals(ServerTags.CONNECTION_DEFINITION_NAME)) {
        }
    }
    
    public void validateAttribute(String name, String value, String rarName, Result result) {
        try {
            String connDefnNames[] = ConnectorRuntime.getRuntime().getConnectionDefinitionNames(rarName);
            boolean available = false;
            for(int i=0;i<connDefnNames.length;i++) {
                if(value.equals(connDefnNames[i])) {
                    available = true;
                    break;
                }
            }
            if(!available)
                    result.failed(smh.getLocalString(getClass().getName() + ".connDefnNotAvl", 
                        "Attribute(conndefn={0}) : Invalid Connection Definition Name", new Object[]{value}));
        } catch(Exception e) {
            _logger.log(Level.FINE, "domainxmlverifier.exception", e);     
        }
    }

    private final ConnectorConnectionPool getConnectorConnectionPool(final ConfigContextEvent cce) throws ConfigException{
        return (ConnectorConnectionPool) cce.getValidationTarget();
    }
    
}
