/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import java.util.Locale;
import java.util.logging.Level;

import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;

/**
    Custom Test for Ssl Element which calls the Generic Validation before performing custom tests

    @author Srinivas Krishnan
    @version 2.0
*/

public class SslTest extends GenericValidator {
    
    public SslTest(ValidationDescriptor desc) {
        super(desc);
    } 
    
    public Result validate(final ConfigContextEvent cce) {
        _logger.log(Level.CONFIG, "SslTest validation");
        
        final Result result = super.validate(cce); // Before doing custom validation do basic validation
        
        final String choice = cce.getChoice();
        if(choice.equals(StaticTest.UPDATE)) {
            return performUpdateChecks(result, cce);
        } else if (choice.equals(StaticTest.SET)) {
            return performSetChecks(result,cce);
        }
        return result;
    }

    private Result performUpdateChecks(final Result result, final ConfigContextEvent cce){
        final ConfigBean co = (ConfigBean) cce.getClassObject();
        final String parentsDtdName = ((ConfigBean) co.parent()).dtdName();
        _logger.log(Level.FINEST, "SslTest update - parent's DTD name is \""+parentsDtdName+"\"");

        _logger.log(Level.FINEST, "SslTest update - attribute name is \""+cce.getName()+"\"");
        _logger.log(Level.FINEST, "SslTest update - attribute value is \""+cce.getObject()+"\"");

        if (parentsDtdName.equals(ServerTags.IIOP_LISTENER)
            && cce.getName().equals(ServerTags.SSL2_ENABLED)
            && ((String) cce.getObject()).equalsIgnoreCase("true")){
            _logger.log(Level.FINER, "SslTest update check - parent is an iiop-listener, and ssl2enabled attribute is being set to true");
            ssl2NotAllowed(result);
        }
        return result;
    }
    private  Result performSetChecks(final Result result, final ConfigContextEvent cce){
        _logger.log(Level.CONFIG, "SsltTest performing set check");
        _logger.log(Level.FINER, "SsltTest set - parent's class is \""+cce.getClassObject().getClass().getName()+"\"");
        _logger.log(Level.FINER, "SsltTest set - ssl objects ssl2enabled attribute is set: \""+((Ssl) cce.getObject()).isSsl2Enabled()+"\"");
        if (cce.getClassObject() instanceof IiopListener
            && ((Ssl) cce.getObject()).isSsl2Enabled()){
            _logger.log(Level.FINER, "SsltTest set check - parent is an iiop-listener, and ssl2enabled attribute is being set to true");
            ssl2NotAllowed(result);
        }
        return result;
    }

    private  void ssl2NotAllowed(final Result result){
        _logger.log(Level.CONFIG, "SslTest - an invalid attempt to enable ssl2 has been found. Returning an error");
        result.failed(smh.getLocalString(getClass().getName()+".ssl2NotAllowed",
                                         "ssl2 cannot be enabled for an iiop-listener"));
    }
    
}
