/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.AttrString;
import com.sun.enterprise.config.serverbeans.validation.Result;

import com.sun.enterprise.config.serverbeans.J2eeApplication;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;
import java.util.logging.Level;
import java.util.Set;

public class WebServiceEndpointTest extends GenericValidator {
    
    public WebServiceEndpointTest(ValidationDescriptor desc) {
        super(desc);
    } 
    
    public Result validate(ConfigContextEvent cce) {
        return super.validate(cce); 
    }

    // can be overriden by specific element test class
    public void validateAttribute(ConfigBean ownerBean, AttrType attr, Object value, ValidationContext valCtx) 
    {
        if (attr.getName().equals(ServerTags.NAME) && 
            attr instanceof AttrString)
        {
            ConfigBean parent =  valCtx.getParentBean();
            
            String regEx    = null;
            if(parent instanceof J2eeApplication)
            {
                regEx = 
                   "[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_./;]*#[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_./;]*";
            }
            else
            {
                regEx = "[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_./;]*";
            }
            
            final AttrString tempAttr = new AttrString(
                attr.getName(),
                attr.getType(),
                attr.getOptional(),
                ((AttrString)attr).getMaxLength(),
                ((AttrString)attr).getEnumeration(),
                regEx );

            super.validateAttribute(ownerBean, tempAttr, value, valCtx);
        }
        else
        {
           super.validateAttribute(ownerBean, attr, value, valCtx);
        }
    }

}
