import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
/*
 * {START_JAVA_COPYRIGHT_NOTICE
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 * Use is subject to license terms.
 * END_COPYRIGHT_NOTICE}
 */

/*
 * FieldBackingBean.java
 *
 */

/**
 *
 */
public class FieldBackingBean {
    
    
    /**
     * Holds value of property text.
     */
    private String text="textTest";
    
    
    /** Creates a new instance of FieldBackingBean */
    public FieldBackingBean() {
    }
    
    /**
     * Getter for property text.
     * @return Value of property text.
     */
    public String getText() {
        
        return this.text;
    }
    
    /**
     * Setter for property text.
     * @param text New value of property text.
     */
    public void setText(String text) {
        
        this.text = text;
    }
    
    // Card validator
    public void zipCodeLengthValidator(FacesContext context, UIComponent component,
            Object value) {
        if(value == null) {
            return;
        }
        
        String zipCode;
        try {
            zipCode = value.toString();
            
            if (zipCode == null ) {
                throw new RuntimeException("null zip code");
            }
            if (zipCode.length() != 5) {
                throw new RuntimeException("Zip code length must be 5 characters");
            }
        } catch (Exception e)  {
            FacesMessage message = new FacesMessage("Error", e.getMessage());
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(message);
        }
    }
}
