/*
 *  DO NOT EDIT! This is a generated file.
 *
 *  Header file which provides C declarations for VirtualBox Main API
 *  (COM interfaces), generated from XIDL (XML interface definition).
 *  On Windows (which uses COM instead of XPCOM) the native C support
 *  is used, and most of this file is not used.
 *
 *  Source    : src/VBox/Main/idl/VirtualBox.xidl
 *  Generator : src/VBox/Main/cbinding/capiidl.xsl
 *
 *  This file contains portions from the following Mozilla XPCOM files:
 *      xpcom/include/xpcom/nsID.h
 *      xpcom/include/nsIException.h
 *      xpcom/include/nsprpub/prtypes.h
 *      xpcom/include/xpcom/nsISupportsBase.h
 *
 * These files were originally triple-licensed (MPL/GPL2/LGPL2.1). Oracle
 * elects to distribute this derived work under the LGPL2.1 only.
 */

/*
 * Copyright (C) 2008-2025 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the "COPYING.LIB" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

#ifndef ___VirtualBox_CAPI_h
#define ___VirtualBox_CAPI_h

#ifdef _WIN32
# ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable:4668 4255) /* -Wall and windows.h */
#  if _MSC_VER >= 1800 /*RT_MSC_VER_VC120*/
#   pragma warning(disable:4005) /* sdk/v7.1/include/sal_supp.h(57) : warning C4005: '__useHeader' : macro redefinition */
#  endif
#  ifdef __cplusplus
#   if _MSC_VER >= 1900 /*RT_MSC_VER_VC140*/
#    pragma warning(disable:5039) /* winbase.h(13179): warning C5039: 'TpSetCallbackCleanupGroup': pointer or reference to potentially throwing function passed to 'extern "C"' function under -EHc. Undefined behavior may occur if this function throws an exception. */
#   endif
#  endif
# endif
# undef COBJMACROS
# define COBJMACROS
# include "Windows.h"
# pragma warning(pop)
#endif /* _WIN32 */

#ifdef WIN32
# ifdef IN_VBOXCAPI
#  define VBOXCAPI_DECL(type) extern __declspec(dllexport) type
# else /* !IN_VBOXCAPI */
#  define VBOXCAPI_DECL(type) __declspec(dllimport) type
# endif /* !IN_VBOXCAPI */
#endif /* WIN32 */

#ifdef __cplusplus
/* The C++ treatment in this file is not meant for SDK users, it only exists
 * so that this file can be used to produce the VBoxCAPI shared library which
 * has to use C++ as it does all the conversion magic. */
# ifdef IN_VBOXCAPI
#  include "VBox/com/VirtualBox.h"
#  ifndef WIN32
#   include "nsIEventQueue.h"
#  endif /* !WIN32 */
# else /* !IN_VBOXCAPI */
#  error Do not include this header file from C++ code
# endif /* !IN_VBOXCAPI */
#endif /* __cplusplus */

#ifdef __GNUC__
# define VBOX_EXTERN_CONST(type, name) extern const type name __attribute__((nocommon))
#else /* !__GNUC__ */
# define VBOX_EXTERN_CONST(type, name) extern const type name
#endif /* !__GNUC__ */

/* Treat WIN32 completely separately, as on Windows VirtualBox uses COM, not
 * XPCOM like on all other platforms. While the code below would also compile
 * on Windows, we need to switch to the native C support provided by the header
 * files produced by the COM IDL compiler. */
#ifdef WIN32
# include "ObjBase.h"
# include "oaidl.h"
# include "VirtualBox.h"

#ifndef __cplusplus
/* Skip this in the C++ case as there's already a definition for CBSTR. */
typedef const BSTR CBSTR;
#endif /* !__cplusplus */

#define VBOX_WINAPI WINAPI

#define ComSafeArrayAsInParam(f) (f)
#define ComSafeArrayAsOutParam(f) (&(f))
#define ComSafeArrayAsOutTypeParam(f,t) (&(f))
#define ComSafeArrayAsOutIfaceParam(f,t) (&(f))

#else /* !WIN32 */

#include <stddef.h>
#include "wchar.h"

#ifdef IN_VBOXCAPI
# define VBOXCAPI_DECL(type) PR_EXPORT(type)
#else /* !IN_VBOXCAPI */
# define VBOXCAPI_DECL(type) PR_IMPORT(type)
#endif /* !IN_VBOXCAPI */

#ifndef __cplusplus

#if defined(WIN32)

#define PR_EXPORT(__type) extern __declspec(dllexport) __type
#define PR_EXPORT_DATA(__type) extern __declspec(dllexport) __type
#define PR_IMPORT(__type) __declspec(dllimport) __type
#define PR_IMPORT_DATA(__type) __declspec(dllimport) __type

#define PR_EXTERN(__type) extern __declspec(dllexport) __type
#define PR_IMPLEMENT(__type) __declspec(dllexport) __type
#define PR_EXTERN_DATA(__type) extern __declspec(dllexport) __type
#define PR_IMPLEMENT_DATA(__type) __declspec(dllexport) __type

#define PR_CALLBACK
#define PR_CALLBACK_DECL
#define PR_STATIC_CALLBACK(__x) static __x

#elif defined(XP_BEOS)

#define PR_EXPORT(__type) extern __declspec(dllexport) __type
#define PR_EXPORT_DATA(__type) extern __declspec(dllexport) __type
#define PR_IMPORT(__type) extern __declspec(dllexport) __type
#define PR_IMPORT_DATA(__type) extern __declspec(dllexport) __type

#define PR_EXTERN(__type) extern __declspec(dllexport) __type
#define PR_IMPLEMENT(__type) __declspec(dllexport) __type
#define PR_EXTERN_DATA(__type) extern __declspec(dllexport) __type
#define PR_IMPLEMENT_DATA(__type) __declspec(dllexport) __type

#define PR_CALLBACK
#define PR_CALLBACK_DECL
#define PR_STATIC_CALLBACK(__x) static __x

#elif defined(WIN16)

#define PR_CALLBACK_DECL        __cdecl

#if defined(_WINDLL)
#define PR_EXPORT(__type) extern __type _cdecl _export _loadds
#define PR_IMPORT(__type) extern __type _cdecl _export _loadds
#define PR_EXPORT_DATA(__type) extern __type _export
#define PR_IMPORT_DATA(__type) extern __type _export

#define PR_EXTERN(__type) extern __type _cdecl _export _loadds
#define PR_IMPLEMENT(__type) __type _cdecl _export _loadds
#define PR_EXTERN_DATA(__type) extern __type _export
#define PR_IMPLEMENT_DATA(__type) __type _export

#define PR_CALLBACK             __cdecl __loadds
#define PR_STATIC_CALLBACK(__x) static __x PR_CALLBACK

#else /* this must be .EXE */
#define PR_EXPORT(__type) extern __type _cdecl _export
#define PR_IMPORT(__type) extern __type _cdecl _export
#define PR_EXPORT_DATA(__type) extern __type _export
#define PR_IMPORT_DATA(__type) extern __type _export

#define PR_EXTERN(__type) extern __type _cdecl _export
#define PR_IMPLEMENT(__type) __type _cdecl _export
#define PR_EXTERN_DATA(__type) extern __type _export
#define PR_IMPLEMENT_DATA(__type) __type _export

#define PR_CALLBACK             __cdecl __loadds
#define PR_STATIC_CALLBACK(__x) __x PR_CALLBACK
#endif /* _WINDLL */

#elif defined(XP_MAC)

#define PR_EXPORT(__type) extern __declspec(export) __type
#define PR_EXPORT_DATA(__type) extern __declspec(export) __type
#define PR_IMPORT(__type) extern __declspec(export) __type
#define PR_IMPORT_DATA(__type) extern __declspec(export) __type

#define PR_EXTERN(__type) extern __declspec(export) __type
#define PR_IMPLEMENT(__type) __declspec(export) __type
#define PR_EXTERN_DATA(__type) extern __declspec(export) __type
#define PR_IMPLEMENT_DATA(__type) __declspec(export) __type

#define PR_CALLBACK
#define PR_CALLBACK_DECL
#define PR_STATIC_CALLBACK(__x) static __x

#elif defined(XP_OS2) && defined(__declspec)

#define PR_EXPORT(__type) extern __declspec(dllexport) __type
#define PR_EXPORT_DATA(__type) extern __declspec(dllexport) __type
#define PR_IMPORT(__type) __declspec(dllimport) __type
#define PR_IMPORT_DATA(__type) __declspec(dllimport) __type

#define PR_EXTERN(__type) extern __declspec(dllexport) __type
#define PR_IMPLEMENT(__type) __declspec(dllexport) __type
#define PR_EXTERN_DATA(__type) extern __declspec(dllexport) __type
#define PR_IMPLEMENT_DATA(__type) __declspec(dllexport) __type

#define PR_CALLBACK
#define PR_CALLBACK_DECL
#define PR_STATIC_CALLBACK(__x) static __x

#elif defined(XP_OS2_VACPP)

#define PR_EXPORT(__type) extern __type
#define PR_EXPORT_DATA(__type) extern __type
#define PR_IMPORT(__type) extern __type
#define PR_IMPORT_DATA(__type) extern __type

#define PR_EXTERN(__type) extern __type
#define PR_IMPLEMENT(__type) __type
#define PR_EXTERN_DATA(__type) extern __type
#define PR_IMPLEMENT_DATA(__type) __type
#define PR_CALLBACK _Optlink
#define PR_CALLBACK_DECL
#define PR_STATIC_CALLBACK(__x) static __x PR_CALLBACK

#else /* Unix */

# ifdef VBOX_HAVE_VISIBILITY_HIDDEN
#  define PR_EXPORT(__type) __attribute__((visibility("default"))) extern __type
#  define PR_EXPORT_DATA(__type) __attribute__((visibility("default"))) extern __type
#  define PR_IMPORT(__type) extern __type
#  define PR_IMPORT_DATA(__type) extern __type
#  define PR_EXTERN(__type) __attribute__((visibility("default"))) extern __type
#  define PR_IMPLEMENT(__type) __attribute__((visibility("default"))) __type
#  define PR_EXTERN_DATA(__type) __attribute__((visibility("default"))) extern __type
#  define PR_IMPLEMENT_DATA(__type) __attribute__((visibility("default"))) __type
#  define PR_CALLBACK
#  define PR_CALLBACK_DECL
#  define PR_STATIC_CALLBACK(__x) static __x
# else
#  define PR_EXPORT(__type) extern __type
#  define PR_EXPORT_DATA(__type) extern __type
#  define PR_IMPORT(__type) extern __type
#  define PR_IMPORT_DATA(__type) extern __type
#  define PR_EXTERN(__type) extern __type
#  define PR_IMPLEMENT(__type) __type
#  define PR_EXTERN_DATA(__type) extern __type
#  define PR_IMPLEMENT_DATA(__type) __type
#  define PR_CALLBACK
#  define PR_CALLBACK_DECL
#  define PR_STATIC_CALLBACK(__x) static __x
# endif
#endif

#if defined(_NSPR_BUILD_)
#define NSPR_API(__type) PR_EXPORT(__type)
#define NSPR_DATA_API(__type) PR_EXPORT_DATA(__type)
#else
#define NSPR_API(__type) PR_IMPORT(__type)
#define NSPR_DATA_API(__type) PR_IMPORT_DATA(__type)
#endif

typedef unsigned char PRUint8;
#if (defined(HPUX) && defined(__cplusplus) \
        && !defined(__GNUC__) && __cplusplus < 199707L) \
    || (defined(SCO) && defined(__cplusplus) \
        && !defined(__GNUC__) && __cplusplus == 1L)
typedef char PRInt8;
#else
typedef signed char PRInt8;
#endif

#define PR_INT8_MAX 127
#define PR_INT8_MIN (-128)
#define PR_UINT8_MAX 255U

typedef unsigned short PRUint16;
typedef short PRInt16;

#define PR_INT16_MAX 32767
#define PR_INT16_MIN (-32768)
#define PR_UINT16_MAX 65535U

typedef unsigned int PRUint32;
typedef int PRInt32;
#define PR_INT32(x)  x
#define PR_UINT32(x) x ## U

#define PR_INT32_MAX PR_INT32(2147483647)
#define PR_INT32_MIN (-PR_INT32_MAX - 1)
#define PR_UINT32_MAX PR_UINT32(4294967295)

typedef long PRInt64;
typedef unsigned long PRUint64;
typedef int PRIntn;
typedef unsigned int PRUintn;

typedef double          PRFloat64;
typedef size_t PRSize;

typedef ptrdiff_t PRPtrdiff;

typedef unsigned long PRUptrdiff;

typedef PRIntn PRBool;

#define PR_TRUE 1
#define PR_FALSE 0

typedef PRUint8 PRPackedBool;

/*
** Status code used by some routines that have a single point of failure or
** special status return.
*/
typedef enum { PR_FAILURE = -1, PR_SUCCESS = 0 } PRStatus;

#ifndef __PRUNICHAR__
#define __PRUNICHAR__
#if defined(WIN32) || defined(XP_MAC)
typedef wchar_t PRUnichar;
#else
typedef PRUint16 PRUnichar;
#endif
typedef PRUnichar *BSTR;
typedef const PRUnichar *CBSTR;
#endif

typedef long PRWord;
typedef unsigned long PRUword;

#define nsnull 0
typedef PRUint32 nsresult;

#if defined(__GNUC__) && (__GNUC__ > 2)
#define NS_LIKELY(x)    (__builtin_expect((x), 1))
#define NS_UNLIKELY(x)  (__builtin_expect((x), 0))
#else
#define NS_LIKELY(x)    (x)
#define NS_UNLIKELY(x)  (x)
#endif

#define NS_FAILED(_nsresult) (NS_UNLIKELY((_nsresult) & 0x80000000))
#define NS_SUCCEEDED(_nsresult) (NS_LIKELY(!((_nsresult) & 0x80000000)))

#ifdef VBOX_WITH_XPCOM_NAMESPACE_CLEANUP
# define PR_IntervalNow VBoxNsprPR_IntervalNow
# define PR_TicksPerSecond VBoxNsprPR_TicksPerSecond
# define PR_SecondsToInterval VBoxNsprPR_SecondsToInterval
# define PR_MillisecondsToInterval VBoxNsprPR_MillisecondsToInterval
# define PR_MicrosecondsToInterval VBoxNsprPR_MicrosecondsToInterval
# define PR_IntervalToSeconds VBoxNsprPR_IntervalToSeconds
# define PR_IntervalToMilliseconds VBoxNsprPR_IntervalToMilliseconds
# define PR_IntervalToMicroseconds VBoxNsprPR_IntervalToMicroseconds
# define PR_EnterMonitor VBoxNsprPR_EnterMonitor
# define PR_ExitMonitor VBoxNsprPR_ExitMonitor
# define PR_Notify VBoxNsprPR_Notify
# define PR_NotifyAll VBoxNsprPR_NotifyAll
# define PR_Wait VBoxNsprPR_Wait
# define PR_NewMonitor VBoxNsprPR_NewMonitor
# define PR_DestroyMonitor VBoxNsprPR_DestroyMonitor
#endif /* VBOX_WITH_XPCOM_NAMESPACE_CLEANUP */

typedef PRUint32 PRIntervalTime;

#define PR_INTERVAL_MIN 1000UL
#define PR_INTERVAL_MAX 100000UL
#define PR_INTERVAL_NO_WAIT 0UL
#define PR_INTERVAL_NO_TIMEOUT 0xffffffffUL

NSPR_API(PRIntervalTime) PR_IntervalNow(void);
NSPR_API(PRUint32) PR_TicksPerSecond(void);
NSPR_API(PRIntervalTime) PR_SecondsToInterval(PRUint32 seconds);
NSPR_API(PRIntervalTime) PR_MillisecondsToInterval(PRUint32 milli);
NSPR_API(PRIntervalTime) PR_MicrosecondsToInterval(PRUint32 micro);
NSPR_API(PRUint32) PR_IntervalToSeconds(PRIntervalTime ticks);
NSPR_API(PRUint32) PR_IntervalToMilliseconds(PRIntervalTime ticks);
NSPR_API(PRUint32) PR_IntervalToMicroseconds(PRIntervalTime ticks);

typedef struct PRMonitor PRMonitor;

NSPR_API(PRMonitor*) PR_NewMonitor(void);
NSPR_API(void) PR_DestroyMonitor(PRMonitor *mon);
NSPR_API(void) PR_EnterMonitor(PRMonitor *mon);
NSPR_API(PRStatus) PR_ExitMonitor(PRMonitor *mon);
NSPR_API(PRStatus) PR_Wait(PRMonitor *mon, PRIntervalTime ticks);
NSPR_API(PRStatus) PR_Notify(PRMonitor *mon);
NSPR_API(PRStatus) PR_NotifyAll(PRMonitor *mon);

#ifdef VBOX_WITH_XPCOM_NAMESPACE_CLEANUP
# define PR_CreateThread VBoxNsprPR_CreateThread
# define PR_JoinThread VBoxNsprPR_JoinThread
# define PR_Sleep VBoxNsprPR_Sleep
# define PR_GetCurrentThread VBoxNsprPR_GetCurrentThread
# define PR_GetThreadState VBoxNsprPR_GetThreadState
# define PR_SetThreadPrivate VBoxNsprPR_SetThreadPrivate
# define PR_GetThreadPrivate VBoxNsprPR_GetThreadPrivate
# define PR_NewThreadPrivateIndex VBoxNsprPR_NewThreadPrivateIndex
# define PR_GetThreadPriority VBoxNsprPR_GetThreadPriority
# define PR_SetThreadPriority VBoxNsprPR_SetThreadPriority
# define PR_Interrupt VBoxNsprPR_Interrupt
# define PR_ClearInterrupt VBoxNsprPR_ClearInterrupt
# define PR_BlockInterrupt VBoxNsprPR_BlockInterrupt
# define PR_UnblockInterrupt VBoxNsprPR_UnblockInterrupt
# define PR_GetThreadScope VBoxNsprPR_GetThreadScope
# define PR_GetThreadType VBoxNsprPR_GetThreadType
#endif /* VBOX_WITH_XPCOM_NAMESPACE_CLEANUP */

typedef struct PRThread PRThread;
typedef struct PRThreadStack PRThreadStack;

typedef enum PRThreadType {
    PR_USER_THREAD,
    PR_SYSTEM_THREAD
} PRThreadType;

typedef enum PRThreadScope {
    PR_LOCAL_THREAD,
    PR_GLOBAL_THREAD,
    PR_GLOBAL_BOUND_THREAD
} PRThreadScope;

typedef enum PRThreadState {
    PR_JOINABLE_THREAD,
    PR_UNJOINABLE_THREAD
} PRThreadState;

typedef enum PRThreadPriority
{
    PR_PRIORITY_FIRST = 0,      /* just a placeholder */
    PR_PRIORITY_LOW = 0,        /* the lowest possible priority */
    PR_PRIORITY_NORMAL = 1,     /* most common expected priority */
    PR_PRIORITY_HIGH = 2,       /* slightly more aggressive scheduling */
    PR_PRIORITY_URGENT = 3,     /* it does little good to have more than one */
    PR_PRIORITY_LAST = 3        /* this is just a placeholder */
} PRThreadPriority;

NSPR_API(PRThread*) PR_CreateThread(PRThreadType type,
                     void (PR_CALLBACK *start)(void *arg),
                     void *arg,
                     PRThreadPriority priority,
                     PRThreadScope scope,
                     PRThreadState state,
                     PRUint32 stackSize);
NSPR_API(PRStatus) PR_JoinThread(PRThread *thread);
NSPR_API(PRThread*) PR_GetCurrentThread(void);
#ifndef NO_NSPR_10_SUPPORT
#define PR_CurrentThread() PR_GetCurrentThread() /* for nspr1.0 compat. */
#endif /* NO_NSPR_10_SUPPORT */
NSPR_API(PRThreadPriority) PR_GetThreadPriority(const PRThread *thread);
NSPR_API(void) PR_SetThreadPriority(PRThread *thread, PRThreadPriority priority);

typedef void (PR_CALLBACK *PRThreadPrivateDTOR)(void *priv);

NSPR_API(PRStatus) PR_NewThreadPrivateIndex(
    PRUintn *newIndex, PRThreadPrivateDTOR destructor);
NSPR_API(PRStatus) PR_SetThreadPrivate(PRUintn tpdIndex, void *priv);
NSPR_API(void*) PR_GetThreadPrivate(PRUintn tpdIndex);
NSPR_API(PRStatus) PR_Interrupt(PRThread *thread);
NSPR_API(void) PR_ClearInterrupt(void);
NSPR_API(void) PR_BlockInterrupt(void);
NSPR_API(void) PR_UnblockInterrupt(void);
NSPR_API(PRStatus) PR_Sleep(PRIntervalTime ticks);
NSPR_API(PRThreadScope) PR_GetThreadScope(const PRThread *thread);
NSPR_API(PRThreadType) PR_GetThreadType(const PRThread *thread);
NSPR_API(PRThreadState) PR_GetThreadState(const PRThread *thread);

#ifdef VBOX_WITH_XPCOM_NAMESPACE_CLEANUP
# define PR_DestroyLock VBoxNsprPR_DestroyLock
# define PR_Lock VBoxNsprPR_Lock
# define PR_NewLock VBoxNsprPR_NewLock
# define PR_Unlock VBoxNsprPR_Unlock
#endif /* VBOX_WITH_XPCOM_NAMESPACE_CLEANUP */

typedef struct PRLock PRLock;

NSPR_API(PRLock*) PR_NewLock(void);
NSPR_API(void) PR_DestroyLock(PRLock *lock);
NSPR_API(void) PR_Lock(PRLock *lock);
NSPR_API(PRStatus) PR_Unlock(PRLock *lock);

#ifdef VBOX_WITH_XPCOM_NAMESPACE_CLEANUP
# define PR_NewCondVar VBoxNsprPR_NewCondVar
# define PR_DestroyCondVar VBoxNsprPR_DestroyCondVar
# define PR_WaitCondVar VBoxNsprPR_WaitCondVar
# define PR_NotifyCondVar VBoxNsprPR_NotifyCondVar
# define PR_NotifyAllCondVar VBoxNsprPR_NotifyAllCondVar
#endif /* VBOX_WITH_XPCOM_NAMESPACE_CLEANUP */

typedef struct PRCondVar PRCondVar;

NSPR_API(PRCondVar*) PR_NewCondVar(PRLock *lock);
NSPR_API(void) PR_DestroyCondVar(PRCondVar *cvar);
NSPR_API(PRStatus) PR_WaitCondVar(PRCondVar *cvar, PRIntervalTime timeout);
NSPR_API(PRStatus) PR_NotifyCondVar(PRCondVar *cvar);
NSPR_API(PRStatus) PR_NotifyAllCondVar(PRCondVar *cvar);

typedef struct PRCListStr PRCList;

struct PRCListStr {
    PRCList *next;
    PRCList *prev;
};

#ifdef VBOX_WITH_XPCOM_NAMESPACE_CLEANUP
# define PL_DestroyEvent VBoxNsplPL_DestroyEvent
# define PL_HandleEvent VBoxNsplPL_HandleEvent
# define PL_InitEvent VBoxNsplPL_InitEvent
# define PL_CreateEventQueue VBoxNsplPL_CreateEventQueue
# define PL_CreateMonitoredEventQueue VBoxNsplPL_CreateMonitoredEventQueue
# define PL_CreateNativeEventQueue VBoxNsplPL_CreateNativeEventQueue
# define PL_DequeueEvent VBoxNsplPL_DequeueEvent
# define PL_DestroyEventQueue VBoxNsplPL_DestroyEventQueue
# define PL_EventAvailable VBoxNsplPL_EventAvailable
# define PL_EventLoop VBoxNsplPL_EventLoop
# define PL_GetEvent VBoxNsplPL_GetEvent
# define PL_GetEventOwner VBoxNsplPL_GetEventOwner
# define PL_GetEventQueueMonitor VBoxNsplPL_GetEventQueueMonitor
# define PL_GetEventQueueSelectFD VBoxNsplPL_GetEventQueueSelectFD
# define PL_MapEvents VBoxNsplPL_MapEvents
# define PL_PostEvent VBoxNsplPL_PostEvent
# define PL_PostSynchronousEvent VBoxNsplPL_PostSynchronousEvent
# define PL_ProcessEventsBeforeID VBoxNsplPL_ProcessEventsBeforeID
# define PL_ProcessPendingEvents VBoxNsplPL_ProcessPendingEvents
# define PL_RegisterEventIDFunc VBoxNsplPL_RegisterEventIDFunc
# define PL_RevokeEvents VBoxNsplPL_RevokeEvents
# define PL_UnregisterEventIDFunc VBoxNsplPL_UnregisterEventIDFunc
# define PL_WaitForEvent VBoxNsplPL_WaitForEvent
# define PL_IsQueueNative VBoxNsplPL_IsQueueNative
# define PL_IsQueueOnCurrentThread VBoxNsplPL_IsQueueOnCurrentThread
# define PL_FavorPerformanceHint VBoxNsplPL_FavorPerformanceHint
#endif /* VBOX_WITH_XPCOM_NAMESPACE_CLEANUP */

typedef struct PLEvent PLEvent;
typedef struct PLEventQueue PLEventQueue;

PR_EXTERN(PLEventQueue*)
PL_CreateEventQueue(const char* name, PRThread* handlerThread);
PR_EXTERN(PLEventQueue *)
    PL_CreateNativeEventQueue(
        const char *name,
        PRThread *handlerThread
    );
PR_EXTERN(PLEventQueue *)
    PL_CreateMonitoredEventQueue(
        const char *name,
        PRThread *handlerThread
    );
PR_EXTERN(void)
PL_DestroyEventQueue(PLEventQueue* self);
PR_EXTERN(PRMonitor*)
PL_GetEventQueueMonitor(PLEventQueue* self);

#define PL_ENTER_EVENT_QUEUE_MONITOR(queue) \
    PR_EnterMonitor(PL_GetEventQueueMonitor(queue))

#define PL_EXIT_EVENT_QUEUE_MONITOR(queue)  \
    PR_ExitMonitor(PL_GetEventQueueMonitor(queue))

PR_EXTERN(PRStatus) PL_PostEvent(PLEventQueue* self, PLEvent* event);
PR_EXTERN(void*) PL_PostSynchronousEvent(PLEventQueue* self, PLEvent* event);
PR_EXTERN(PLEvent*) PL_GetEvent(PLEventQueue* self);
PR_EXTERN(PRBool) PL_EventAvailable(PLEventQueue* self);

typedef void (PR_CALLBACK *PLEventFunProc)(PLEvent* event, void* data, PLEventQueue* queue);

PR_EXTERN(void) PL_MapEvents(PLEventQueue* self, PLEventFunProc fun, void* data);
PR_EXTERN(void) PL_RevokeEvents(PLEventQueue* self, void* owner);
PR_EXTERN(void) PL_ProcessPendingEvents(PLEventQueue* self);
PR_EXTERN(PLEvent*) PL_WaitForEvent(PLEventQueue* self);
PR_EXTERN(void) PL_EventLoop(PLEventQueue* self);
PR_EXTERN(PRInt32) PL_GetEventQueueSelectFD(PLEventQueue* self);
PR_EXTERN(PRBool) PL_IsQueueOnCurrentThread( PLEventQueue *queue );
PR_EXTERN(PRBool) PL_IsQueueNative(PLEventQueue *queue);

typedef void* (PR_CALLBACK *PLHandleEventProc)(PLEvent* self);
typedef void (PR_CALLBACK *PLDestroyEventProc)(PLEvent* self);
PR_EXTERN(void)
PL_InitEvent(PLEvent* self, void* owner,
             PLHandleEventProc handler,
             PLDestroyEventProc destructor);
PR_EXTERN(void*) PL_GetEventOwner(PLEvent* self);
PR_EXTERN(void) PL_HandleEvent(PLEvent* self);
PR_EXTERN(void) PL_DestroyEvent(PLEvent* self);
PR_EXTERN(void) PL_DequeueEvent(PLEvent* self, PLEventQueue* queue);
PR_EXTERN(void) PL_FavorPerformanceHint(PRBool favorPerformanceOverEventStarvation, PRUint32 starvationDelay);

struct PLEvent {
    PRCList             link;
    PLHandleEventProc   handler;
    PLDestroyEventProc  destructor;
    void*               owner;
    void*               synchronousResult;
    PRLock*             lock;
    PRCondVar*          condVar;
    PRBool              handled;
#ifdef PL_POST_TIMINGS
    PRIntervalTime      postTime;
#endif
#ifdef XP_UNIX
    unsigned long       id;
#endif /* XP_UNIX */
    /* other fields follow... */
};

#if defined(XP_WIN) || defined(XP_OS2)

PR_EXTERN(HWND)
    PL_GetNativeEventReceiverWindow(
        PLEventQueue *eqp
    );
#endif /* XP_WIN || XP_OS2 */

#ifdef XP_UNIX

PR_EXTERN(PRInt32)
PL_ProcessEventsBeforeID(PLEventQueue *aSelf, unsigned long aID);

typedef unsigned long (PR_CALLBACK *PLGetEventIDFunc)(void *aClosure);

PR_EXTERN(void)
PL_RegisterEventIDFunc(PLEventQueue *aSelf, PLGetEventIDFunc aFunc,
                       void *aClosure);
PR_EXTERN(void) PL_UnregisterEventIDFunc(PLEventQueue *aSelf);

#endif /* XP_UNIX */

/* Standard "it worked" return value */
#define NS_OK                              0

#define NS_ERROR_BASE                      ((nsresult) 0xC1F30000)

/* Returned when an instance is not initialized */
#define NS_ERROR_NOT_INITIALIZED           (NS_ERROR_BASE + 1)

/* Returned when an instance is already initialized */
#define NS_ERROR_ALREADY_INITIALIZED       (NS_ERROR_BASE + 2)

/* Returned by a not implemented function */
#define NS_ERROR_NOT_IMPLEMENTED           ((nsresult) 0x80004001L)

/* Returned when a given interface is not supported. */
#define NS_NOINTERFACE                     ((nsresult) 0x80004002L)
#define NS_ERROR_NO_INTERFACE              NS_NOINTERFACE

#define NS_ERROR_INVALID_POINTER           ((nsresult) 0x80004003L)
#define NS_ERROR_NULL_POINTER              NS_ERROR_INVALID_POINTER

/* Returned when a function aborts */
#define NS_ERROR_ABORT                     ((nsresult) 0x80004004L)

/* Returned when a function fails */
#define NS_ERROR_FAILURE                   ((nsresult) 0x80004005L)

/* Returned when an unexpected error occurs */
#define NS_ERROR_UNEXPECTED                ((nsresult) 0x8000ffffL)

/* Returned when a memory allocation fails */
#define NS_ERROR_OUT_OF_MEMORY             ((nsresult) 0x8007000eL)

/* Returned when an illegal value is passed */
#define NS_ERROR_ILLEGAL_VALUE             ((nsresult) 0x80070057L)
#define NS_ERROR_INVALID_ARG               NS_ERROR_ILLEGAL_VALUE

/* Returned when a class doesn't allow aggregation */
#define NS_ERROR_NO_AGGREGATION            ((nsresult) 0x80040110L)

/* Returned when an operation can't complete due to an unavailable resource */
#define NS_ERROR_NOT_AVAILABLE             ((nsresult) 0x80040111L)

/* Returned when a class is not registered */
#define NS_ERROR_FACTORY_NOT_REGISTERED    ((nsresult) 0x80040154L)

/* Returned when a class cannot be registered, but may be tried again later */
#define NS_ERROR_FACTORY_REGISTER_AGAIN    ((nsresult) 0x80040155L)

/* Returned when a dynamically loaded factory couldn't be found */
#define NS_ERROR_FACTORY_NOT_LOADED        ((nsresult) 0x800401f8L)

/* Returned when a factory doesn't support signatures */
#define NS_ERROR_FACTORY_NO_SIGNATURE_SUPPORT \
                                           (NS_ERROR_BASE + 0x101)

/* Returned when a factory already is registered */
#define NS_ERROR_FACTORY_EXISTS            (NS_ERROR_BASE + 0x100)

/**
 * An "interface id" which can be used to uniquely identify a given
 * interface.
 * A "unique identifier". This is modeled after OSF DCE UUIDs.
 */

struct nsID {
    PRUint32 m0;
    PRUint16 m1;
    PRUint16 m2;
    PRUint8 m3[8];
};

typedef struct nsID nsID;
typedef nsID nsIID;
typedef nsID nsCID;

#endif /* __cplusplus */

#define VBOX_WINAPI

/* Various COM types defined by their XPCOM equivalent */
typedef PRInt64 LONG64;
typedef PRInt32 LONG;
typedef PRInt32 DWORD;
typedef PRInt16 SHORT;
typedef PRUint64 ULONG64;
typedef PRUint32 ULONG;
typedef PRUint16 USHORT;

typedef PRBool BOOL;

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

#define HRESULT nsresult
#define SUCCEEDED NS_SUCCEEDED
#define FAILED NS_FAILED

/* OLE error codes */
#define S_OK                ((nsresult)NS_OK)
#define E_UNEXPECTED        NS_ERROR_UNEXPECTED
#define E_NOTIMPL           NS_ERROR_NOT_IMPLEMENTED
#define E_OUTOFMEMORY       NS_ERROR_OUT_OF_MEMORY
#define E_INVALIDARG        NS_ERROR_INVALID_ARG
#define E_NOINTERFACE       NS_ERROR_NO_INTERFACE
#define E_POINTER           NS_ERROR_NULL_POINTER
#define E_ABORT             NS_ERROR_ABORT
#define E_FAIL              NS_ERROR_FAILURE
/* Note: a better analog for E_ACCESSDENIED would probably be
 * NS_ERROR_NOT_AVAILABLE, but we want binary compatibility for now. */
#define E_ACCESSDENIED      ((nsresult)0x80070005L)

/* Basic vartype for COM compatibility. */
typedef enum VARTYPE
{
    VT_I2 = 2,
    VT_I4 = 3,
    VT_BSTR = 8,
    VT_DISPATCH = 9,
    VT_BOOL = 11,
    VT_UNKNOWN = 13,
    VT_I1 = 16,
    VT_UI1 = 17,
    VT_UI2 = 18,
    VT_UI4 = 19,
    VT_I8 = 20,
    VT_UI8 = 21,
    VT_HRESULT = 25
} VARTYPE;

/* Basic safearray type for COM compatibility. */
typedef struct SAFEARRAY
{
    void *pv;
    ULONG c;
} SAFEARRAY;

#define ComSafeArrayAsInParam(f) ((f) ? (f)->c : 0), ((f) ? (f)->pv : NULL)
#define ComSafeArrayAsOutParam(f) (&((f)->c)), (&((f)->pv))
#define ComSafeArrayAsOutTypeParam(f,t) (&((f)->c)), (t**)(&((f)->pv))
#define ComSafeArrayAsOutIfaceParam(f,t) (&((f)->c)), (t**)(&((f)->pv))

/* Glossing over differences between COM and XPCOM */
#define IErrorInfo nsIException
#define IUnknown nsISupports
#define IDispatch nsISupports

/* Make things as COM compatible as possible */
#define interface struct
#ifdef CONST_VTABLE
# define CONST_VTBL const
#else /* !CONST_VTABLE */
# define CONST_VTBL
#endif /* !CONST_VTABLE */

#ifndef __cplusplus

/** @todo this first batch of forward declarations (and the corresponding ones
 * generated for each interface) are 100% redundant, remove eventually. */
interface nsISupports;   /* forward declaration */
interface nsIException;  /* forward declaration */
interface nsIStackFrame; /* forward declaration */
interface nsIEventTarget;/* forward declaration */
interface nsIEventQueue; /* forward declaration */

typedef interface nsISupports nsISupports;     /* forward declaration */
typedef interface nsIException nsIException;   /* forward declaration */
typedef interface nsIStackFrame nsIStackFrame; /* forward declaration */
typedef interface nsIEventTarget nsIEventTarget;/* forward declaration */
typedef interface nsIEventQueue nsIEventQueue; /* forward declaration */

/* starting interface:    nsISupports */
#define NS_ISUPPORTS_IID_STR "00000000-0000-0000-c000-000000000046"

#define NS_ISUPPORTS_IID \
    { 0x00000000, 0x0000, 0x0000, \
      {0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46} }

/**
 * Reference count values
 *
 * This is the return type for AddRef() and Release() in nsISupports.
 * IUnknown of COM returns an unsigned long from equivalent functions.
 * The following ifdef exists to maintain binary compatibility with
 * IUnknown.
 */
#if defined(XP_WIN) && PR_BYTES_PER_LONG == 4
typedef unsigned long nsrefcnt;
#else
typedef PRUint32 nsrefcnt;
#endif

/**
 * Basic component object model interface. Objects which implement
 * this interface support runtime interface discovery (QueryInterface)
 * and a reference counted memory model (AddRef/Release). This is
 * modelled after the win32 IUnknown API.
 */
#ifndef VBOX_WITH_GLUE
struct nsISupports_vtbl
{
    nsresult (*QueryInterface)(nsISupports *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(nsISupports *pThis);
    nsrefcnt (*Release)(nsISupports *pThis);
};
#else /* !VBOX_WITH_GLUE */
struct nsISupportsVtbl
{
    nsresult (*QueryInterface)(nsISupports *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(nsISupports *pThis);
    nsrefcnt (*Release)(nsISupports *pThis);
};
#define nsISupports_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define nsISupports_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define nsISupports_Release(p) ((p)->lpVtbl->Release(p))
#define IUnknown_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IUnknown_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IUnknown_Release(p) ((p)->lpVtbl->Release(p))
#define IDispatch_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDispatch_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDispatch_Release(p) ((p)->lpVtbl->Release(p))
#endif /* !VBOX_WITH_GLUE */

interface nsISupports
{
#ifndef VBOX_WITH_GLUE
    struct nsISupports_vtbl *vtbl;
#else /* !VBOX_WITH_GLUE */
    CONST_VTBL struct nsISupportsVtbl *lpVtbl;
#endif /* !VBOX_WITH_GLUE */
};

/* starting interface:    nsIException */
#define NS_IEXCEPTION_IID_STR "f3a8d3b4-c424-4edc-8bf6-8974c983ba78"

#define NS_IEXCEPTION_IID \
    {0xf3a8d3b4, 0xc424, 0x4edc, \
      { 0x8b, 0xf6, 0x89, 0x74, 0xc9, 0x83, 0xba, 0x78 }}

#ifndef VBOX_WITH_GLUE
struct nsIException_vtbl
{
    /* Methods from the interface nsISupports */
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetMessage)(nsIException *pThis, PRUnichar * *aMessage);
    nsresult (*GetResult)(nsIException *pThis, nsresult *aResult);
    nsresult (*GetName)(nsIException *pThis, PRUnichar * *aName);
    nsresult (*GetFilename)(nsIException *pThis, PRUnichar * *aFilename);
    nsresult (*GetLineNumber)(nsIException *pThis, PRUint32 *aLineNumber);
    nsresult (*GetColumnNumber)(nsIException *pThis, PRUint32 *aColumnNumber);
    nsresult (*GetLocation)(nsIException *pThis, nsIStackFrame * *aLocation);
    nsresult (*GetInner)(nsIException *pThis, nsIException * *aInner);
    nsresult (*GetData)(nsIException *pThis, nsISupports * *aData);
    nsresult (*ToString)(nsIException *pThis, PRUnichar **_retval);
};
#else /* !VBOX_WITH_GLUE */
struct nsIExceptionVtbl
{
    nsresult (*QueryInterface)(nsIException *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(nsIException *pThis);
    nsrefcnt (*Release)(nsIException *pThis);

    nsresult (*GetMessage)(nsIException *pThis, PRUnichar * *aMessage);
    nsresult (*GetResult)(nsIException *pThis, nsresult *aResult);
    nsresult (*GetName)(nsIException *pThis, PRUnichar * *aName);
    nsresult (*GetFilename)(nsIException *pThis, PRUnichar * *aFilename);
    nsresult (*GetLineNumber)(nsIException *pThis, PRUint32 *aLineNumber);
    nsresult (*GetColumnNumber)(nsIException *pThis, PRUint32 *aColumnNumber);
    nsresult (*GetLocation)(nsIException *pThis, nsIStackFrame * *aLocation);
    nsresult (*GetInner)(nsIException *pThis, nsIException * *aInner);
    nsresult (*GetData)(nsIException *pThis, nsISupports * *aData);
    nsresult (*ToString)(nsIException *pThis, PRUnichar **_retval);
};
#define nsIException_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define nsIException_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define nsIException_Release(p) ((p)->lpVtbl->Release(p))
#define nsIException_get_Message(p, aMessage) ((p)->lpVtbl->GetMessage(p, aMessage))
#define nsIException_GetMessage(p, aMessage) ((p)->lpVtbl->GetMessage(p, aMessage))
#define nsIException_get_Result(p, aResult) ((p)->lpVtbl->GetResult(p, aResult))
#define nsIException_GetResult(p, aResult) ((p)->lpVtbl->GetResult(p, aResult))
#define nsIException_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define nsIException_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define nsIException_get_Filename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define nsIException_GetFilename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define nsIException_get_LineNumber(p, aLineNumber) ((p)->lpVtbl->GetLineNumber(p, aLineNumber))
#define nsIException_GetLineNumber(p, aLineNumber) ((p)->lpVtbl->GetLineNumber(p, aLineNumber))
#define nsIException_get_ColumnNumber(p, aColumnNumber) ((p)->lpVtbl->GetColumnNumber(p, aColumnNumber))
#define nsIException_GetColumnNumber(p, aColumnNumber) ((p)->lpVtbl->GetColumnNumber(p, aColumnNumber))
#define nsIException_get_Inner(p, aInner) ((p)->lpVtbl->GetInner(p, aInner))
#define nsIException_GetInner(p, aInner) ((p)->lpVtbl->GetInner(p, aInner))
#define nsIException_get_Data(p, aData) ((p)->lpVtbl->GetData(p, aData))
#define nsIException_GetData(p, aData) ((p)->lpVtbl->GetData(p, aData))
#define nsIException_ToString(p, retval) ((p)->lpVtbl->ToString(p, retval))
#define IErrorInfo_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IErrorInfo_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IErrorInfo_Release(p) ((p)->lpVtbl->Release(p))
#define IErrorInfo_get_Message(p, aMessage) ((p)->lpVtbl->GetMessage(p, aMessage))
#define IErrorInfo_GetMessage(p, aMessage) ((p)->lpVtbl->GetMessage(p, aMessage))
#define IErrorInfo_get_Result(p, aResult) ((p)->lpVtbl->GetResult(p, aResult))
#define IErrorInfo_GetResult(p, aResult) ((p)->lpVtbl->GetResult(p, aResult))
#define IErrorInfo_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IErrorInfo_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IErrorInfo_get_Filename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IErrorInfo_GetFilename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IErrorInfo_get_LineNumber(p, aLineNumber) ((p)->lpVtbl->GetLineNumber(p, aLineNumber))
#define IErrorInfo_GetLineNumber(p, aLineNumber) ((p)->lpVtbl->GetLineNumber(p, aLineNumber))
#define IErrorInfo_get_ColumnNumber(p, aColumnNumber) ((p)->lpVtbl->GetColumnNumber(p, aColumnNumber))
#define IErrorInfo_GetColumnNumber(p, aColumnNumber) ((p)->lpVtbl->GetColumnNumber(p, aColumnNumber))
#define IErrorInfo_get_Inner(p, aInner) ((p)->lpVtbl->GetInner(p, aInner))
#define IErrorInfo_GetInner(p, aInner) ((p)->lpVtbl->GetInner(p, aInner))
#define IErrorInfo_get_Data(p, aData) ((p)->lpVtbl->GetData(p, aData))
#define IErrorInfo_GetData(p, aData) ((p)->lpVtbl->GetData(p, aData))
#define IErrorInfo_ToString(p, retval) ((p)->lpVtbl->ToString(p, retval))
#endif /* !VBOX_WITH_GLUE */

interface nsIException
{
#ifndef VBOX_WITH_GLUE
    struct nsIException_vtbl *vtbl;
#else /* !VBOX_WITH_GLUE */
    CONST_VTBL struct nsIExceptionVtbl *lpVtbl;
#endif /* !VBOX_WITH_GLUE */
};

/* starting interface:    nsIStackFrame */
#define NS_ISTACKFRAME_IID_STR "91d82105-7c62-4f8b-9779-154277c0ee90"

#define NS_ISTACKFRAME_IID \
    {0x91d82105, 0x7c62, 0x4f8b, \
      { 0x97, 0x79, 0x15, 0x42, 0x77, 0xc0, 0xee, 0x90 }}

#ifndef VBOX_WITH_GLUE
struct nsIStackFrame_vtbl
{
    /* Methods from the interface nsISupports */
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetLanguage)(nsIStackFrame *pThis, PRUint32 *aLanguage);
    nsresult (*GetLanguageName)(nsIStackFrame *pThis, PRUnichar * *aLanguageName);
    nsresult (*GetFilename)(nsIStackFrame *pThis, PRUnichar * *aFilename);
    nsresult (*GetName)(nsIStackFrame *pThis, PRUnichar * *aName);
    nsresult (*GetLineNumber)(nsIStackFrame *pThis, PRInt32 *aLineNumber);
    nsresult (*GetSourceLine)(nsIStackFrame *pThis, PRUnichar * *aSourceLine);
    nsresult (*GetCaller)(nsIStackFrame *pThis, nsIStackFrame * *aCaller);
    nsresult (*ToString)(nsIStackFrame *pThis, PRUnichar **_retval);
};
#else /* !VBOX_WITH_GLUE */
struct nsIStackFrameVtbl
{
    nsresult (*QueryInterface)(nsIStackFrame *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(nsIStackFrame *pThis);
    nsrefcnt (*Release)(nsIStackFrame *pThis);

    nsresult (*GetLanguage)(nsIStackFrame *pThis, PRUint32 *aLanguage);
    nsresult (*GetLanguageName)(nsIStackFrame *pThis, PRUnichar * *aLanguageName);
    nsresult (*GetFilename)(nsIStackFrame *pThis, PRUnichar * *aFilename);
    nsresult (*GetName)(nsIStackFrame *pThis, PRUnichar * *aName);
    nsresult (*GetLineNumber)(nsIStackFrame *pThis, PRInt32 *aLineNumber);
    nsresult (*GetSourceLine)(nsIStackFrame *pThis, PRUnichar * *aSourceLine);
    nsresult (*GetCaller)(nsIStackFrame *pThis, nsIStackFrame * *aCaller);
    nsresult (*ToString)(nsIStackFrame *pThis, PRUnichar **_retval);
};
#define nsIStackFrame_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define nsIStackFrame_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define nsIStackFrame_Release(p) ((p)->lpVtbl->Release(p))
#define nsIStackFrame_get_Language(p, aLanguage) ((p)->lpVtbl->GetLanguge(p, aLanguage))
#define nsIStackFrame_GetLanguage(p, aLanguage) ((p)->lpVtbl->GetLanguge(p, aLanguage))
#define nsIStackFrame_get_LanguageName(p, aLanguageName) ((p)->lpVtbl->GetLanguageName(p, aLanguageName))
#define nsIStackFrame_GetLanguageName(p, aLanguageName) ((p)->lpVtbl->GetLanguageName(p, aLanguageName))
#define nsIStackFrame_get_Filename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define nsIStackFrame_GetFilename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define nsIStackFrame_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define nsIStackFrame_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define nsIStackFrame_get_LineNumber(p, aLineNumber) ((p)->lpVtbl->GetLineNumber(p, aLineNumber))
#define nsIStackFrame_GetLineNumber(p, aLineNumber) ((p)->lpVtbl->GetLineNumber(p, aLineNumber))
#define nsIStackFrame_get_SourceLine(p, aSourceLine) ((p)->lpVtbl->GetSourceLine(p, aSourceLine))
#define nsIStackFrame_GetSourceLine(p, aSourceLine) ((p)->lpVtbl->GetSourceLine(p, aSourceLine))
#define nsIStackFrame_get_Caller(p, aCaller) ((p)->lpVtbl->GetCaller(p, aCaller))
#define nsIStackFrame_GetCaller(p, aCaller) ((p)->lpVtbl->GetCaller(p, aCaller))
#define nsIStackFrame_ToString(p, retval) ((p)->lpVtbl->ToString(p, retval))
#endif /* !VBOX_WITH_GLUE */

interface nsIStackFrame
{
#ifndef VBOX_WITH_GLUE
    struct nsIStackFrame_vtbl *vtbl;
#else /* !VBOX_WITH_GLUE */
    CONST_VTBL struct nsIStackFrameVtbl *lpVtbl;
#endif /* !VBOX_WITH_GLUE */
};

/* starting interface:    nsIEventTarget */
#define NS_IEVENTTARGET_IID_STR "ea99ad5b-cc67-4efb-97c9-2ef620a59f2a"

#define NS_IEVENTTARGET_IID \
    {0xea99ad5b, 0xcc67, 0x4efb, \
      { 0x97, 0xc9, 0x2e, 0xf6, 0x20, 0xa5, 0x9f, 0x2a }}

#ifndef VBOX_WITH_GLUE
struct nsIEventTarget_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*PostEvent)(nsIEventTarget *pThis, PLEvent * aEvent);
    nsresult (*IsOnCurrentThread)(nsIEventTarget *pThis, PRBool *_retval);
};
#else /* !VBOX_WITH_GLUE */
struct nsIEventTargetVtbl
{
    nsresult (*QueryInterface)(nsIEventTarget *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(nsIEventTarget *pThis);
    nsrefcnt (*Release)(nsIEventTarget *pThis);

    nsresult (*PostEvent)(nsIEventTarget *pThis, PLEvent * aEvent);
    nsresult (*IsOnCurrentThread)(nsIEventTarget *pThis, PRBool *_retval);
};
#define nsIEventTarget_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define nsIEventTarget_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define nsIEventTarget_Release(p) ((p)->lpVtbl->Release(p))
#define nsIEventTarget_PostEvent(p, aEvent) ((p)->lpVtbl->PostEvent(p, aEvent))
#define nsIEventTarget_IsOnCurrentThread(p, retval) ((p)->lpVtbl->IsOnCurrentThread(p, retval))
#endif /* !VBOX_WITH_GLUE */

interface nsIEventTarget
{
#ifndef VBOX_WITH_GLUE
    struct nsIEventTarget_vtbl *vtbl;
#else /* !VBOX_WITH_GLUE */
    CONST_VTBL struct nsIEventTargetVtbl *lpVtbl;
#endif /* !VBOX_WITH_GLUE */
};

/* starting interface:    nsIEventQueue */
#define NS_IEVENTQUEUE_IID_STR "176afb41-00a4-11d3-9f2a-00400553eef0"

#define NS_IEVENTQUEUE_IID \
  {0x176afb41, 0x00a4, 0x11d3, \
    { 0x9f, 0x2a, 0x00, 0x40, 0x05, 0x53, 0xee, 0xf0 }}

#ifndef VBOX_WITH_GLUE
struct nsIEventQueue_vtbl
{
    struct nsIEventTarget_vtbl nsieventtarget;

    nsresult (*InitEvent)(nsIEventQueue *pThis, PLEvent * aEvent, void * owner, PLHandleEventProc handler, PLDestroyEventProc destructor);
    nsresult (*PostSynchronousEvent)(nsIEventQueue *pThis, PLEvent * aEvent, void * *aResult);
    nsresult (*PendingEvents)(nsIEventQueue *pThis, PRBool *_retval);
    nsresult (*ProcessPendingEvents)(nsIEventQueue *pThis);
    nsresult (*EventLoop)(nsIEventQueue *pThis);
    nsresult (*EventAvailable)(nsIEventQueue *pThis, PRBool *aResult);
    nsresult (*GetEvent)(nsIEventQueue *pThis, PLEvent * *_retval);
    nsresult (*HandleEvent)(nsIEventQueue *pThis, PLEvent * aEvent);
    nsresult (*WaitForEvent)(nsIEventQueue *pThis, PLEvent * *_retval);
    PRInt32 (*GetEventQueueSelectFD)(nsIEventQueue *pThis);
    nsresult (*Init)(nsIEventQueue *pThis, PRBool aNative);
    nsresult (*InitFromPRThread)(nsIEventQueue *pThis, PRThread * thread, PRBool aNative);
    nsresult (*InitFromPLQueue)(nsIEventQueue *pThis, PLEventQueue * aQueue);
    nsresult (*EnterMonitor)(nsIEventQueue *pThis);
    nsresult (*ExitMonitor)(nsIEventQueue *pThis);
    nsresult (*RevokeEvents)(nsIEventQueue *pThis, void * owner);
    nsresult (*GetPLEventQueue)(nsIEventQueue *pThis, PLEventQueue * *_retval);
    nsresult (*IsQueueNative)(nsIEventQueue *pThis, PRBool *_retval);
    nsresult (*StopAcceptingEvents)(nsIEventQueue *pThis);
};
#else /* !VBOX_WITH_GLUE */
struct nsIEventQueueVtbl
{
    nsresult (*QueryInterface)(nsIEventQueue *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(nsIEventQueue *pThis);
    nsrefcnt (*Release)(nsIEventQueue *pThis);

    nsresult (*PostEvent)(nsIEventQueue *pThis, PLEvent * aEvent);
    nsresult (*IsOnCurrentThread)(nsIEventQueue *pThis, PRBool *_retval);

    nsresult (*InitEvent)(nsIEventQueue *pThis, PLEvent * aEvent, void * owner, PLHandleEventProc handler, PLDestroyEventProc destructor);
    nsresult (*PostSynchronousEvent)(nsIEventQueue *pThis, PLEvent * aEvent, void * *aResult);
    nsresult (*PendingEvents)(nsIEventQueue *pThis, PRBool *_retval);
    nsresult (*ProcessPendingEvents)(nsIEventQueue *pThis);
    nsresult (*EventLoop)(nsIEventQueue *pThis);
    nsresult (*EventAvailable)(nsIEventQueue *pThis, PRBool *aResult);
    nsresult (*GetEvent)(nsIEventQueue *pThis, PLEvent * *_retval);
    nsresult (*HandleEvent)(nsIEventQueue *pThis, PLEvent * aEvent);
    nsresult (*WaitForEvent)(nsIEventQueue *pThis, PLEvent * *_retval);
    PRInt32 (*GetEventQueueSelectFD)(nsIEventQueue *pThis);
    nsresult (*Init)(nsIEventQueue *pThis, PRBool aNative);
    nsresult (*InitFromPRThread)(nsIEventQueue *pThis, PRThread * thread, PRBool aNative);
    nsresult (*InitFromPLQueue)(nsIEventQueue *pThis, PLEventQueue * aQueue);
    nsresult (*EnterMonitor)(nsIEventQueue *pThis);
    nsresult (*ExitMonitor)(nsIEventQueue *pThis);
    nsresult (*RevokeEvents)(nsIEventQueue *pThis, void * owner);
    nsresult (*GetPLEventQueue)(nsIEventQueue *pThis, PLEventQueue * *_retval);
    nsresult (*IsQueueNative)(nsIEventQueue *pThis, PRBool *_retval);
    nsresult (*StopAcceptingEvents)(nsIEventQueue *pThis);
};
#define nsIEventQueue_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define nsIEventQueue_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define nsIEventQueue_Release(p) ((p)->lpVtbl->Release(p))
#define nsIEventQueue_PostEvent(p, aEvent) ((p)->lpVtbl->PostEvent(p, aEvent))
#define nsIEventQueue_IsOnCurrentThread(p, retval) ((p)->lpVtbl->IsOnCurrentThread(p, retval))
#define nsIEventQueue_InitEvent(p, aEvent, owner, handler, destructor) ((p)->lpVtbl->InitEvent(p, aEvent, owner, handler, destructor))
#define nsIEventQueue_PostSynchronousEvent(p, aEvent, aResult) ((p)->lpVtbl->PostSynchronousEvent(p, aEvent, aResult))
#define nsIEventQueue_ProcessPendingEvents(p) ((p)->lpVtbl->ProcessPendingEvents(p))
#define nsIEventQueue_EventLoop(p) ((p)->lpVtbl->EventLoop(p))
#define nsIEventQueue_EventAvailable(p, aResult) ((p)->lpVtbl->EventAvailable(p, aResult))
#define nsIEventQueue_get_Event(p, aEvent) ((p)->lpVtbl->GetEvent(p, aEvent))
#define nsIEventQueue_GetEvent(p, aEvent) ((p)->lpVtbl->GetEvent(p, aEvent))
#define nsIEventQueue_HandleEvent(p, aEvent) ((p)->lpVtbl->HandleEvent(p, aEvent))
#define nsIEventQueue_WaitForEvent(p, aEvent) ((p)->lpVtbl->WaitForEvent(p, aEvent))
#define nsIEventQueue_GetEventQueueSelectFD(p) ((p)->lpVtbl->GetEventQueueSelectFD(p))
#define nsIEventQueue_Init(p, aNative) ((p)->lpVtbl->Init(p, aNative))
#define nsIEventQueue_InitFromPLQueue(p, aQueue) ((p)->lpVtbl->InitFromPLQueue(p, aQueue))
#define nsIEventQueue_EnterMonitor(p) ((p)->lpVtbl->EnterMonitor(p))
#define nsIEventQueue_ExitMonitor(p) ((p)->lpVtbl->ExitMonitor(p))
#define nsIEventQueue_RevokeEvents(p, owner) ((p)->lpVtbl->RevokeEvents(p, owner))
#define nsIEventQueue_GetPLEventQueue(p, retval) ((p)->lpVtbl->GetPLEventQueue(p, retval))
#define nsIEventQueue_IsQueueNative(p, retval) ((p)->lpVtbl->IsQueueNative(p, retval))
#define nsIEventQueue_StopAcceptingEvents(p) ((p)->lpVtbl->StopAcceptingEvents(p))
#endif /* !VBOX_WITH_GLUE */

interface nsIEventQueue
{
#ifndef VBOX_WITH_GLUE
    struct nsIEventQueue_vtbl *vtbl;
#else /* !VBOX_WITH_GLUE */
    CONST_VTBL struct nsIEventQueueVtbl *lpVtbl;
#endif /* !VBOX_WITH_GLUE */
};


#define VBOX_E_OBJECT_NOT_FOUND ((HRESULT)0x80BB0001)
#define VBOX_E_INVALID_VM_STATE ((HRESULT)0x80BB0002)
#define VBOX_E_VM_ERROR ((HRESULT)0x80BB0003)
#define VBOX_E_FILE_ERROR ((HRESULT)0x80BB0004)
#define VBOX_E_IPRT_ERROR ((HRESULT)0x80BB0005)
#define VBOX_E_PDM_ERROR ((HRESULT)0x80BB0006)
#define VBOX_E_INVALID_OBJECT_STATE ((HRESULT)0x80BB0007)
#define VBOX_E_HOST_ERROR ((HRESULT)0x80BB0008)
#define VBOX_E_NOT_SUPPORTED ((HRESULT)0x80BB0009)
#define VBOX_E_XML_ERROR ((HRESULT)0x80BB000A)
#define VBOX_E_INVALID_SESSION_STATE ((HRESULT)0x80BB000B)
#define VBOX_E_OBJECT_IN_USE ((HRESULT)0x80BB000C)
#define VBOX_E_PASSWORD_INCORRECT ((HRESULT)0x80BB000D)
#define VBOX_E_MAXIMUM_REACHED ((HRESULT)0x80BB000E)
#define VBOX_E_GSTCTL_GUEST_ERROR ((HRESULT)0x80BB000F)
#define VBOX_E_TIMEOUT ((HRESULT)0x80BB0010)
#define VBOX_E_DND_ERROR ((HRESULT)0x80BB0011)
#define VBOX_E_PLATFORM_ARCH_NOT_SUPPORTED ((HRESULT)0x80BB0012)
#define VBOX_E_RECORDING_ERROR ((HRESULT)0x80BB0013)


interface IVirtualBoxErrorInfo;
interface INATNetwork;
interface ICloudNetwork;
interface IHostOnlyNetwork;
interface IDHCPServer;
interface IDHCPConfig;
interface IDHCPGlobalConfig;
interface IDHCPGroupCondition;
interface IDHCPGroupConfig;
interface IDHCPIndividualConfig;
interface IVirtualBox;
interface IVFSExplorer;
interface ICertificate;
interface IAppliance;
interface IVirtualSystemDescription;
interface IUnattended;
interface IGraphicsAdapter;
interface IFirmwareSettings;
interface ITrustedPlatformModule;
interface IRecordingScreenSettings;
interface IRecordingSettings;
interface IPCIAddress;
interface IPCIDeviceAttachment;
interface IUefiVariableStore;
interface INvramStore;
interface IResourceStore;
interface IPlatform;
interface IPlatformX86;
interface IPlatformARM;
interface IMachine;
interface IEmulatedUSB;
interface IVRDEServerInfo;
interface IConsole;
interface IHostNetworkInterface;
interface IHostVideoInputDevice;
interface IUpdateAgent;
interface IHostUpdateAgent;
interface IHostDrivePartition;
interface IHostDrive;
interface IHostX86;
interface IHost;
interface ICPUProfile;
interface IPlatformProperties;
interface ISystemProperties;
interface IGuestOSType;
interface IAdditionsFacility;
interface IDnDBase;
interface IDnDSource;
interface IGuestDnDSource;
interface IDnDTarget;
interface IGuestDnDTarget;
interface IGuestSession;
interface IProcess;
interface IGuestProcess;
interface IDirectory;
interface IGuestDirectory;
interface IFile;
interface IGuestFile;
interface IFsInfo;
interface IFsObjInfo;
interface IGuestFsInfo;
interface IGuestFsObjInfo;
interface IGuest;
interface IProgress;
interface ISnapshot;
interface IMediumAttachment;
interface IMedium;
interface IMediumFormat;
interface IDataStream;
interface IMediumIO;
interface IToken;
interface IKeyboard;
interface IMousePointerShape;
interface IMouse;
interface IDisplaySourceBitmap;
interface IFramebuffer;
interface IFramebufferOverlay;
interface IGuestScreenInfo;
interface IDisplay;
interface INetworkAdapter;
interface ISerialPort;
interface IParallelPort;
interface IMachineDebugger;
interface IUSBDeviceFilters;
interface IUSBController;
interface IUSBDevice;
interface IUSBDeviceFilter;
interface IHostUSBDevice;
interface IHostUSBDeviceFilter;
interface IUSBProxyBackend;
interface IAudioAdapter;
interface IHostAudioDevice;
interface IAudioSettings;
interface IVRDEServer;
interface ISharedFolder;
interface ISession;
interface IStorageController;
interface IPerformanceMetric;
interface IPerformanceCollector;
interface INATEngine;
interface IExtPackPlugIn;
interface IExtPackBase;
interface IExtPack;
interface IExtPackFile;
interface IExtPackManager;
interface IBandwidthGroup;
interface IBandwidthControl;
interface IGuestDebugControl;
interface IVirtualBoxClient;
interface IEventSource;
interface IEventListener;
interface IEvent;
interface IReusableEvent;
interface IMachineEvent;
interface IMachineStateChangedEvent;
interface IExtPackInstalledEvent;
interface IExtPackUninstalledEvent;
interface IMachineDataChangedEvent;
interface IMediumRegisteredEvent;
interface IMediumConfigChangedEvent;
interface IMachineRegisteredEvent;
interface ISessionStateChangedEvent;
interface IGuestPropertyChangedEvent;
interface ISnapshotEvent;
interface ISnapshotTakenEvent;
interface ISnapshotDeletedEvent;
interface ISnapshotRestoredEvent;
interface ISnapshotChangedEvent;
interface IMousePointerShapeChangedEvent;
interface IMouseCapabilityChangedEvent;
interface IKeyboardLedsChangedEvent;
interface IStateChangedEvent;
interface IAdditionsStateChangedEvent;
interface INetworkAdapterChangedEvent;
interface IAudioAdapterChangedEvent;
interface ISerialPortChangedEvent;
interface IParallelPortChangedEvent;
interface IStorageControllerChangedEvent;
interface IMediumChangedEvent;
interface IClipboardModeChangedEvent;
interface IClipboardFileTransferModeChangedEvent;
interface IClipboardEvent;
interface IClipboardErrorEvent;
interface IDnDModeChangedEvent;
interface ICPUChangedEvent;
interface ICPUExecutionCapChangedEvent;
interface IGuestKeyboardEvent;
interface IGuestMouseEvent;
interface IGuestMultiTouchEvent;
interface IGuestSessionEvent;
interface IGuestSessionStateChangedEvent;
interface IGuestSessionRegisteredEvent;
interface IGuestProcessEvent;
interface IGuestProcessRegisteredEvent;
interface IGuestProcessStateChangedEvent;
interface IGuestProcessIOEvent;
interface IGuestProcessInputNotifyEvent;
interface IGuestProcessOutputEvent;
interface IGuestDirectoryEvent;
interface IGuestDirectoryRegisteredEvent;
interface IGuestDirectoryStateChangedEvent;
interface IGuestDirectoryReadEvent;
interface IGuestFileEvent;
interface IGuestFileRegisteredEvent;
interface IGuestFileStateChangedEvent;
interface IGuestFileIOEvent;
interface IGuestFileOffsetChangedEvent;
interface IGuestFileSizeChangedEvent;
interface IGuestFileReadEvent;
interface IGuestFileWriteEvent;
interface IVRDEServerChangedEvent;
interface IVRDEServerInfoChangedEvent;
interface IRecordingStateChangedEvent;
interface IRecordingScreenStateChangedEvent;
interface IUSBControllerChangedEvent;
interface IUSBDeviceStateChangedEvent;
interface ISharedFolderChangedEvent;
interface IRuntimeErrorEvent;
interface IEventSourceChangedEvent;
interface IExtraDataChangedEvent;
interface IVetoEvent;
interface IExtraDataCanChangeEvent;
interface ICanShowWindowEvent;
interface IShowWindowEvent;
interface INATRedirectEvent;
interface IHostAudioDeviceChangedEvent;
interface IHostPCIDevicePlugEvent;
interface IVBoxSVCAvailabilityChangedEvent;
interface IBandwidthGroupChangedEvent;
interface IGuestMonitorChangedEvent;
interface IGuestUserStateChangedEvent;
interface IStorageDeviceChangedEvent;
interface INATNetworkChangedEvent;
interface INATNetworkStartStopEvent;
interface INATNetworkAlterEvent;
interface INATNetworkCreationDeletionEvent;
interface INATNetworkSettingEvent;
interface INATNetworkPortForwardEvent;
interface IHostNameResolutionConfigurationChangeEvent;
interface IProgressEvent;
interface IProgressCreatedEvent;
interface IProgressPercentageChangedEvent;
interface IProgressTaskCompletedEvent;
interface ICursorPositionChangedEvent;
interface IGuestAdditionsStatusChangedEvent;
interface IGuestMonitorInfoChangedEvent;
interface IUpdateAgentEvent;
interface IUpdateAgentSettingsChangedEvent;
interface IUpdateAgentErrorEvent;
interface IUpdateAgentAvailableEvent;
interface IUpdateAgentStateChangedEvent;
interface IGuestDebugControlChangedEvent;
interface IMachineGroupsChangedEvent;
interface IStringArray;
interface IFormValue;
interface IBooleanFormValue;
interface IRangedIntegerFormValue;
interface IRangedInteger64FormValue;
interface IStringFormValue;
interface IChoiceFormValue;
interface IForm;
interface IVirtualSystemDescriptionForm;
interface ICloudNetworkGatewayInfo;
interface ICloudNetworkEnvironmentInfo;
interface ICloudMachine;
interface ICloudClient;
interface ICloudProfile;
interface ICloudProvider;
interface ICloudProviderManager;
interface ICloudProviderListChangedEvent;
interface ICloudProviderRegisteredEvent;
interface ICloudProviderUninstallEvent;
interface ICloudProfileRegisteredEvent;
interface ICloudProfileChangedEvent;
interface ILanguageChangedEvent;

typedef interface IVirtualBoxErrorInfo IVirtualBoxErrorInfo;
typedef interface INATNetwork INATNetwork;
typedef interface ICloudNetwork ICloudNetwork;
typedef interface IHostOnlyNetwork IHostOnlyNetwork;
typedef interface IDHCPServer IDHCPServer;
typedef interface IDHCPConfig IDHCPConfig;
typedef interface IDHCPGlobalConfig IDHCPGlobalConfig;
typedef interface IDHCPGroupCondition IDHCPGroupCondition;
typedef interface IDHCPGroupConfig IDHCPGroupConfig;
typedef interface IDHCPIndividualConfig IDHCPIndividualConfig;
typedef interface IVirtualBox IVirtualBox;
typedef interface IVFSExplorer IVFSExplorer;
typedef interface ICertificate ICertificate;
typedef interface IAppliance IAppliance;
typedef interface IVirtualSystemDescription IVirtualSystemDescription;
typedef interface IUnattended IUnattended;
typedef interface IGraphicsAdapter IGraphicsAdapter;
typedef interface IFirmwareSettings IFirmwareSettings;
typedef interface ITrustedPlatformModule ITrustedPlatformModule;
typedef interface IRecordingScreenSettings IRecordingScreenSettings;
typedef interface IRecordingSettings IRecordingSettings;
typedef interface IPCIAddress IPCIAddress;
typedef interface IPCIDeviceAttachment IPCIDeviceAttachment;
typedef interface IUefiVariableStore IUefiVariableStore;
typedef interface INvramStore INvramStore;
typedef interface IResourceStore IResourceStore;
typedef interface IPlatform IPlatform;
typedef interface IPlatformX86 IPlatformX86;
typedef interface IPlatformARM IPlatformARM;
typedef interface IMachine IMachine;
typedef interface IEmulatedUSB IEmulatedUSB;
typedef interface IVRDEServerInfo IVRDEServerInfo;
typedef interface IConsole IConsole;
typedef interface IHostNetworkInterface IHostNetworkInterface;
typedef interface IHostVideoInputDevice IHostVideoInputDevice;
typedef interface IUpdateAgent IUpdateAgent;
typedef interface IHostUpdateAgent IHostUpdateAgent;
typedef interface IHostDrivePartition IHostDrivePartition;
typedef interface IHostDrive IHostDrive;
typedef interface IHostX86 IHostX86;
typedef interface IHost IHost;
typedef interface ICPUProfile ICPUProfile;
typedef interface IPlatformProperties IPlatformProperties;
typedef interface ISystemProperties ISystemProperties;
typedef interface IGuestOSType IGuestOSType;
typedef interface IAdditionsFacility IAdditionsFacility;
typedef interface IDnDBase IDnDBase;
typedef interface IDnDSource IDnDSource;
typedef interface IGuestDnDSource IGuestDnDSource;
typedef interface IDnDTarget IDnDTarget;
typedef interface IGuestDnDTarget IGuestDnDTarget;
typedef interface IGuestSession IGuestSession;
typedef interface IProcess IProcess;
typedef interface IGuestProcess IGuestProcess;
typedef interface IDirectory IDirectory;
typedef interface IGuestDirectory IGuestDirectory;
typedef interface IFile IFile;
typedef interface IGuestFile IGuestFile;
typedef interface IFsInfo IFsInfo;
typedef interface IFsObjInfo IFsObjInfo;
typedef interface IGuestFsInfo IGuestFsInfo;
typedef interface IGuestFsObjInfo IGuestFsObjInfo;
typedef interface IGuest IGuest;
typedef interface IProgress IProgress;
typedef interface ISnapshot ISnapshot;
typedef interface IMediumAttachment IMediumAttachment;
typedef interface IMedium IMedium;
typedef interface IMediumFormat IMediumFormat;
typedef interface IDataStream IDataStream;
typedef interface IMediumIO IMediumIO;
typedef interface IToken IToken;
typedef interface IKeyboard IKeyboard;
typedef interface IMousePointerShape IMousePointerShape;
typedef interface IMouse IMouse;
typedef interface IDisplaySourceBitmap IDisplaySourceBitmap;
typedef interface IFramebuffer IFramebuffer;
typedef interface IFramebufferOverlay IFramebufferOverlay;
typedef interface IGuestScreenInfo IGuestScreenInfo;
typedef interface IDisplay IDisplay;
typedef interface INetworkAdapter INetworkAdapter;
typedef interface ISerialPort ISerialPort;
typedef interface IParallelPort IParallelPort;
typedef interface IMachineDebugger IMachineDebugger;
typedef interface IUSBDeviceFilters IUSBDeviceFilters;
typedef interface IUSBController IUSBController;
typedef interface IUSBDevice IUSBDevice;
typedef interface IUSBDeviceFilter IUSBDeviceFilter;
typedef interface IHostUSBDevice IHostUSBDevice;
typedef interface IHostUSBDeviceFilter IHostUSBDeviceFilter;
typedef interface IUSBProxyBackend IUSBProxyBackend;
typedef interface IAudioAdapter IAudioAdapter;
typedef interface IHostAudioDevice IHostAudioDevice;
typedef interface IAudioSettings IAudioSettings;
typedef interface IVRDEServer IVRDEServer;
typedef interface ISharedFolder ISharedFolder;
typedef interface ISession ISession;
typedef interface IStorageController IStorageController;
typedef interface IPerformanceMetric IPerformanceMetric;
typedef interface IPerformanceCollector IPerformanceCollector;
typedef interface INATEngine INATEngine;
typedef interface IExtPackPlugIn IExtPackPlugIn;
typedef interface IExtPackBase IExtPackBase;
typedef interface IExtPack IExtPack;
typedef interface IExtPackFile IExtPackFile;
typedef interface IExtPackManager IExtPackManager;
typedef interface IBandwidthGroup IBandwidthGroup;
typedef interface IBandwidthControl IBandwidthControl;
typedef interface IGuestDebugControl IGuestDebugControl;
typedef interface IVirtualBoxClient IVirtualBoxClient;
typedef interface IEventSource IEventSource;
typedef interface IEventListener IEventListener;
typedef interface IEvent IEvent;
typedef interface IReusableEvent IReusableEvent;
typedef interface IMachineEvent IMachineEvent;
typedef interface IMachineStateChangedEvent IMachineStateChangedEvent;
typedef interface IExtPackInstalledEvent IExtPackInstalledEvent;
typedef interface IExtPackUninstalledEvent IExtPackUninstalledEvent;
typedef interface IMachineDataChangedEvent IMachineDataChangedEvent;
typedef interface IMediumRegisteredEvent IMediumRegisteredEvent;
typedef interface IMediumConfigChangedEvent IMediumConfigChangedEvent;
typedef interface IMachineRegisteredEvent IMachineRegisteredEvent;
typedef interface ISessionStateChangedEvent ISessionStateChangedEvent;
typedef interface IGuestPropertyChangedEvent IGuestPropertyChangedEvent;
typedef interface ISnapshotEvent ISnapshotEvent;
typedef interface ISnapshotTakenEvent ISnapshotTakenEvent;
typedef interface ISnapshotDeletedEvent ISnapshotDeletedEvent;
typedef interface ISnapshotRestoredEvent ISnapshotRestoredEvent;
typedef interface ISnapshotChangedEvent ISnapshotChangedEvent;
typedef interface IMousePointerShapeChangedEvent IMousePointerShapeChangedEvent;
typedef interface IMouseCapabilityChangedEvent IMouseCapabilityChangedEvent;
typedef interface IKeyboardLedsChangedEvent IKeyboardLedsChangedEvent;
typedef interface IStateChangedEvent IStateChangedEvent;
typedef interface IAdditionsStateChangedEvent IAdditionsStateChangedEvent;
typedef interface INetworkAdapterChangedEvent INetworkAdapterChangedEvent;
typedef interface IAudioAdapterChangedEvent IAudioAdapterChangedEvent;
typedef interface ISerialPortChangedEvent ISerialPortChangedEvent;
typedef interface IParallelPortChangedEvent IParallelPortChangedEvent;
typedef interface IStorageControllerChangedEvent IStorageControllerChangedEvent;
typedef interface IMediumChangedEvent IMediumChangedEvent;
typedef interface IClipboardModeChangedEvent IClipboardModeChangedEvent;
typedef interface IClipboardFileTransferModeChangedEvent IClipboardFileTransferModeChangedEvent;
typedef interface IClipboardEvent IClipboardEvent;
typedef interface IClipboardErrorEvent IClipboardErrorEvent;
typedef interface IDnDModeChangedEvent IDnDModeChangedEvent;
typedef interface ICPUChangedEvent ICPUChangedEvent;
typedef interface ICPUExecutionCapChangedEvent ICPUExecutionCapChangedEvent;
typedef interface IGuestKeyboardEvent IGuestKeyboardEvent;
typedef interface IGuestMouseEvent IGuestMouseEvent;
typedef interface IGuestMultiTouchEvent IGuestMultiTouchEvent;
typedef interface IGuestSessionEvent IGuestSessionEvent;
typedef interface IGuestSessionStateChangedEvent IGuestSessionStateChangedEvent;
typedef interface IGuestSessionRegisteredEvent IGuestSessionRegisteredEvent;
typedef interface IGuestProcessEvent IGuestProcessEvent;
typedef interface IGuestProcessRegisteredEvent IGuestProcessRegisteredEvent;
typedef interface IGuestProcessStateChangedEvent IGuestProcessStateChangedEvent;
typedef interface IGuestProcessIOEvent IGuestProcessIOEvent;
typedef interface IGuestProcessInputNotifyEvent IGuestProcessInputNotifyEvent;
typedef interface IGuestProcessOutputEvent IGuestProcessOutputEvent;
typedef interface IGuestDirectoryEvent IGuestDirectoryEvent;
typedef interface IGuestDirectoryRegisteredEvent IGuestDirectoryRegisteredEvent;
typedef interface IGuestDirectoryStateChangedEvent IGuestDirectoryStateChangedEvent;
typedef interface IGuestDirectoryReadEvent IGuestDirectoryReadEvent;
typedef interface IGuestFileEvent IGuestFileEvent;
typedef interface IGuestFileRegisteredEvent IGuestFileRegisteredEvent;
typedef interface IGuestFileStateChangedEvent IGuestFileStateChangedEvent;
typedef interface IGuestFileIOEvent IGuestFileIOEvent;
typedef interface IGuestFileOffsetChangedEvent IGuestFileOffsetChangedEvent;
typedef interface IGuestFileSizeChangedEvent IGuestFileSizeChangedEvent;
typedef interface IGuestFileReadEvent IGuestFileReadEvent;
typedef interface IGuestFileWriteEvent IGuestFileWriteEvent;
typedef interface IVRDEServerChangedEvent IVRDEServerChangedEvent;
typedef interface IVRDEServerInfoChangedEvent IVRDEServerInfoChangedEvent;
typedef interface IRecordingStateChangedEvent IRecordingStateChangedEvent;
typedef interface IRecordingScreenStateChangedEvent IRecordingScreenStateChangedEvent;
typedef interface IUSBControllerChangedEvent IUSBControllerChangedEvent;
typedef interface IUSBDeviceStateChangedEvent IUSBDeviceStateChangedEvent;
typedef interface ISharedFolderChangedEvent ISharedFolderChangedEvent;
typedef interface IRuntimeErrorEvent IRuntimeErrorEvent;
typedef interface IEventSourceChangedEvent IEventSourceChangedEvent;
typedef interface IExtraDataChangedEvent IExtraDataChangedEvent;
typedef interface IVetoEvent IVetoEvent;
typedef interface IExtraDataCanChangeEvent IExtraDataCanChangeEvent;
typedef interface ICanShowWindowEvent ICanShowWindowEvent;
typedef interface IShowWindowEvent IShowWindowEvent;
typedef interface INATRedirectEvent INATRedirectEvent;
typedef interface IHostAudioDeviceChangedEvent IHostAudioDeviceChangedEvent;
typedef interface IHostPCIDevicePlugEvent IHostPCIDevicePlugEvent;
typedef interface IVBoxSVCAvailabilityChangedEvent IVBoxSVCAvailabilityChangedEvent;
typedef interface IBandwidthGroupChangedEvent IBandwidthGroupChangedEvent;
typedef interface IGuestMonitorChangedEvent IGuestMonitorChangedEvent;
typedef interface IGuestUserStateChangedEvent IGuestUserStateChangedEvent;
typedef interface IStorageDeviceChangedEvent IStorageDeviceChangedEvent;
typedef interface INATNetworkChangedEvent INATNetworkChangedEvent;
typedef interface INATNetworkStartStopEvent INATNetworkStartStopEvent;
typedef interface INATNetworkAlterEvent INATNetworkAlterEvent;
typedef interface INATNetworkCreationDeletionEvent INATNetworkCreationDeletionEvent;
typedef interface INATNetworkSettingEvent INATNetworkSettingEvent;
typedef interface INATNetworkPortForwardEvent INATNetworkPortForwardEvent;
typedef interface IHostNameResolutionConfigurationChangeEvent IHostNameResolutionConfigurationChangeEvent;
typedef interface IProgressEvent IProgressEvent;
typedef interface IProgressCreatedEvent IProgressCreatedEvent;
typedef interface IProgressPercentageChangedEvent IProgressPercentageChangedEvent;
typedef interface IProgressTaskCompletedEvent IProgressTaskCompletedEvent;
typedef interface ICursorPositionChangedEvent ICursorPositionChangedEvent;
typedef interface IGuestAdditionsStatusChangedEvent IGuestAdditionsStatusChangedEvent;
typedef interface IGuestMonitorInfoChangedEvent IGuestMonitorInfoChangedEvent;
typedef interface IUpdateAgentEvent IUpdateAgentEvent;
typedef interface IUpdateAgentSettingsChangedEvent IUpdateAgentSettingsChangedEvent;
typedef interface IUpdateAgentErrorEvent IUpdateAgentErrorEvent;
typedef interface IUpdateAgentAvailableEvent IUpdateAgentAvailableEvent;
typedef interface IUpdateAgentStateChangedEvent IUpdateAgentStateChangedEvent;
typedef interface IGuestDebugControlChangedEvent IGuestDebugControlChangedEvent;
typedef interface IMachineGroupsChangedEvent IMachineGroupsChangedEvent;
typedef interface IStringArray IStringArray;
typedef interface IFormValue IFormValue;
typedef interface IBooleanFormValue IBooleanFormValue;
typedef interface IRangedIntegerFormValue IRangedIntegerFormValue;
typedef interface IRangedInteger64FormValue IRangedInteger64FormValue;
typedef interface IStringFormValue IStringFormValue;
typedef interface IChoiceFormValue IChoiceFormValue;
typedef interface IForm IForm;
typedef interface IVirtualSystemDescriptionForm IVirtualSystemDescriptionForm;
typedef interface ICloudNetworkGatewayInfo ICloudNetworkGatewayInfo;
typedef interface ICloudNetworkEnvironmentInfo ICloudNetworkEnvironmentInfo;
typedef interface ICloudMachine ICloudMachine;
typedef interface ICloudClient ICloudClient;
typedef interface ICloudProfile ICloudProfile;
typedef interface ICloudProvider ICloudProvider;
typedef interface ICloudProviderManager ICloudProviderManager;
typedef interface ICloudProviderListChangedEvent ICloudProviderListChangedEvent;
typedef interface ICloudProviderRegisteredEvent ICloudProviderRegisteredEvent;
typedef interface ICloudProviderUninstallEvent ICloudProviderUninstallEvent;
typedef interface ICloudProfileRegisteredEvent ICloudProfileRegisteredEvent;
typedef interface ICloudProfileChangedEvent ICloudProfileChangedEvent;
typedef interface ILanguageChangedEvent ILanguageChangedEvent;

/* Start of enum SettingsVersion declaration */
#define SETTINGSVERSION_IID_STR "6ad3da60-5ed2-49cd-b882-96a72308ebf6"
#define SETTINGSVERSION_IID { \
    0x6ad3da60, 0x5ed2, 0x49cd, \
    { 0xb8, 0x82, 0x96, 0xa7, 0x23, 0x08, 0xeb, 0xf6 } \
}
typedef enum SettingsVersion
{
    SettingsVersion_Null = 0,
    SettingsVersion_v1_0 = 1,
    SettingsVersion_v1_1 = 2,
    SettingsVersion_v1_2 = 3,
    SettingsVersion_v1_3pre = 4,
    SettingsVersion_v1_3 = 5,
    SettingsVersion_v1_4 = 6,
    SettingsVersion_v1_5 = 7,
    SettingsVersion_v1_6 = 8,
    SettingsVersion_v1_7 = 9,
    SettingsVersion_v1_8 = 10,
    SettingsVersion_v1_9 = 11,
    SettingsVersion_v1_10 = 12,
    SettingsVersion_v1_11 = 13,
    SettingsVersion_v1_12 = 14,
    SettingsVersion_v1_13 = 15,
    SettingsVersion_v1_14 = 16,
    SettingsVersion_v1_15 = 17,
    SettingsVersion_v1_16 = 18,
    SettingsVersion_v1_17 = 19,
    SettingsVersion_v1_18 = 20,
    SettingsVersion_v1_19 = 21,
    SettingsVersion_v1_20 = 22,
    SettingsVersion_Future = 99999
} SettingsVersion;
/* End of enum SettingsVersion declaration */
#define SettingsVersion_T PRUint32


/* Start of enum AccessMode declaration */
#define ACCESSMODE_IID_STR "1da0007c-ddf7-4be8-bcac-d84a1558785f"
#define ACCESSMODE_IID { \
    0x1da0007c, 0xddf7, 0x4be8, \
    { 0xbc, 0xac, 0xd8, 0x4a, 0x15, 0x58, 0x78, 0x5f } \
}
typedef enum AccessMode
{
    AccessMode_ReadOnly = 1,
    AccessMode_ReadWrite = 2
} AccessMode;
/* End of enum AccessMode declaration */
#define AccessMode_T PRUint32


/* Start of enum MachineState declaration */
#define MACHINESTATE_IID_STR "00bc01b5-00a4-48db-000a-9061008357aa"
#define MACHINESTATE_IID { \
    0x00bc01b5, 0x00a4, 0x48db, \
    { 0x00, 0x0a, 0x90, 0x61, 0x00, 0x83, 0x57, 0xaa } \
}
typedef enum MachineState
{
    MachineState_Null = 0,
    MachineState_PoweredOff = 1,
    MachineState_Saved = 2,
    MachineState_Teleported = 3,
    MachineState_Aborted = 4,
    MachineState_AbortedSaved = 5,
    MachineState_Running = 6,
    MachineState_Paused = 7,
    MachineState_Stuck = 8,
    MachineState_Teleporting = 9,
    MachineState_LiveSnapshotting = 10,
    MachineState_Starting = 11,
    MachineState_Stopping = 12,
    MachineState_Saving = 13,
    MachineState_Restoring = 14,
    MachineState_TeleportingPausedVM = 15,
    MachineState_TeleportingIn = 16,
    MachineState_DeletingSnapshotOnline = 17,
    MachineState_DeletingSnapshotPaused = 18,
    MachineState_OnlineSnapshotting = 19,
    MachineState_RestoringSnapshot = 20,
    MachineState_DeletingSnapshot = 21,
    MachineState_SettingUp = 22,
    MachineState_Snapshotting = 23,
    MachineState_FirstOnline = 6,
    MachineState_LastOnline = 19,
    MachineState_FirstTransient = 9,
    MachineState_LastTransient = 23
} MachineState;
/* End of enum MachineState declaration */
#define MachineState_T PRUint32


/* Start of enum SessionState declaration */
#define SESSIONSTATE_IID_STR "cf2700c0-ea4b-47ae-9725-7810114b94d8"
#define SESSIONSTATE_IID { \
    0xcf2700c0, 0xea4b, 0x47ae, \
    { 0x97, 0x25, 0x78, 0x10, 0x11, 0x4b, 0x94, 0xd8 } \
}
typedef enum SessionState
{
    SessionState_Null = 0,
    SessionState_Unlocked = 1,
    SessionState_Locked = 2,
    SessionState_Spawning = 3,
    SessionState_Unlocking = 4
} SessionState;
/* End of enum SessionState declaration */
#define SessionState_T PRUint32


/* Start of enum PlatformArchitecture declaration */
#define PLATFORMARCHITECTURE_IID_STR "36e21926-1713-413d-8cf5-2f169b2cbcf3"
#define PLATFORMARCHITECTURE_IID { \
    0x36e21926, 0x1713, 0x413d, \
    { 0x8c, 0xf5, 0x2f, 0x16, 0x9b, 0x2c, 0xbc, 0xf3 } \
}
typedef enum PlatformArchitecture
{
    PlatformArchitecture_None = 0,
    PlatformArchitecture_x86 = 1,
    PlatformArchitecture_ARM = 2
} PlatformArchitecture;
/* End of enum PlatformArchitecture declaration */
#define PlatformArchitecture_T PRUint32


/* Start of enum CPUArchitecture declaration */
#define CPUARCHITECTURE_IID_STR "12906c63-9967-49c8-ba5a-6521adaf0185"
#define CPUARCHITECTURE_IID { \
    0x12906c63, 0x9967, 0x49c8, \
    { 0xba, 0x5a, 0x65, 0x21, 0xad, 0xaf, 0x01, 0x85 } \
}
typedef enum CPUArchitecture
{
    CPUArchitecture_Any = 0,
    CPUArchitecture_x86 = 1,
    CPUArchitecture_AMD64 = 2,
    CPUArchitecture_ARMv8_32 = 3,
    CPUArchitecture_ARMv8_64 = 4
} CPUArchitecture;
/* End of enum CPUArchitecture declaration */
#define CPUArchitecture_T PRUint32


/* Start of enum CPUPropertyTypeX86 declaration */
#define CPUPROPERTYTYPEX86_IID_STR "a754b765-3687-4a68-abb9-78dcf4c07d5f"
#define CPUPROPERTYTYPEX86_IID { \
    0xa754b765, 0x3687, 0x4a68, \
    { 0xab, 0xb9, 0x78, 0xdc, 0xf4, 0xc0, 0x7d, 0x5f } \
}
typedef enum CPUPropertyTypeX86
{
    CPUPropertyTypeX86_Null = 0,
    CPUPropertyTypeX86_PAE = 1,
    CPUPropertyTypeX86_LongMode = 2,
    CPUPropertyTypeX86_TripleFaultReset = 3,
    CPUPropertyTypeX86_APIC = 4,
    CPUPropertyTypeX86_X2APIC = 5,
    CPUPropertyTypeX86_IBPBOnVMExit = 6,
    CPUPropertyTypeX86_IBPBOnVMEntry = 7,
    CPUPropertyTypeX86_HWVirt = 8,
    CPUPropertyTypeX86_SpecCtrl = 9,
    CPUPropertyTypeX86_SpecCtrlByHost = 10,
    CPUPropertyTypeX86_L1DFlushOnEMTScheduling = 11,
    CPUPropertyTypeX86_L1DFlushOnVMEntry = 12,
    CPUPropertyTypeX86_MDSClearOnEMTScheduling = 13,
    CPUPropertyTypeX86_MDSClearOnVMEntry = 14
} CPUPropertyTypeX86;
/* End of enum CPUPropertyTypeX86 declaration */
#define CPUPropertyTypeX86_T PRUint32


/* Start of enum HWVirtExPropertyType declaration */
#define HWVIRTEXPROPERTYTYPE_IID_STR "00069d9c-00b5-460c-00dd-64250024f7aa"
#define HWVIRTEXPROPERTYTYPE_IID { \
    0x00069d9c, 0x00b5, 0x460c, \
    { 0x00, 0xdd, 0x64, 0x25, 0x00, 0x24, 0xf7, 0xaa } \
}
typedef enum HWVirtExPropertyType
{
    HWVirtExPropertyType_Null = 0,
    HWVirtExPropertyType_Enabled = 1,
    HWVirtExPropertyType_VPID = 2,
    HWVirtExPropertyType_NestedPaging = 3,
    HWVirtExPropertyType_UnrestrictedExecution = 4,
    HWVirtExPropertyType_LargePages = 5,
    HWVirtExPropertyType_Force = 6,
    HWVirtExPropertyType_UseNativeApi = 7,
    HWVirtExPropertyType_VirtVmsaveVmload = 8
} HWVirtExPropertyType;
/* End of enum HWVirtExPropertyType declaration */
#define HWVirtExPropertyType_T PRUint32


/* Start of enum ParavirtProvider declaration */
#define PARAVIRTPROVIDER_IID_STR "696453ec-3742-4a05-bead-658ccbf2c944"
#define PARAVIRTPROVIDER_IID { \
    0x696453ec, 0x3742, 0x4a05, \
    { 0xbe, 0xad, 0x65, 0x8c, 0xcb, 0xf2, 0xc9, 0x44 } \
}
typedef enum ParavirtProvider
{
    ParavirtProvider_None = 0,
    ParavirtProvider_Default = 1,
    ParavirtProvider_Legacy = 2,
    ParavirtProvider_Minimal = 3,
    ParavirtProvider_HyperV = 4,
    ParavirtProvider_KVM = 5
} ParavirtProvider;
/* End of enum ParavirtProvider declaration */
#define ParavirtProvider_T PRUint32


/* Start of enum LockType declaration */
#define LOCKTYPE_IID_STR "678aaf14-2815-4c3e-b20a-e86ed0216498"
#define LOCKTYPE_IID { \
    0x678aaf14, 0x2815, 0x4c3e, \
    { 0xb2, 0x0a, 0xe8, 0x6e, 0xd0, 0x21, 0x64, 0x98 } \
}
typedef enum LockType
{
    LockType_Null = 0,
    LockType_Shared = 1,
    LockType_Write = 2,
    LockType_VM = 3
} LockType;
/* End of enum LockType declaration */
#define LockType_T PRUint32


/* Start of enum SessionType declaration */
#define SESSIONTYPE_IID_STR "A13C02CB-0C2C-421E-8317-AC0E8AAA153A"
#define SESSIONTYPE_IID { \
    0xA13C02CB, 0x0C2C, 0x421E, \
    { 0x83, 0x17, 0xAC, 0x0E, 0x8A, 0xAA, 0x15, 0x3A } \
}
typedef enum SessionType
{
    SessionType_Null = 0,
    SessionType_WriteLock = 1,
    SessionType_Remote = 2,
    SessionType_Shared = 3
} SessionType;
/* End of enum SessionType declaration */
#define SessionType_T PRUint32


/* Start of enum DeviceType declaration */
#define DEVICETYPE_IID_STR "cb977be1-d1fb-41f8-ad7e-951736c6cb3e"
#define DEVICETYPE_IID { \
    0xcb977be1, 0xd1fb, 0x41f8, \
    { 0xad, 0x7e, 0x95, 0x17, 0x36, 0xc6, 0xcb, 0x3e } \
}
typedef enum DeviceType
{
    DeviceType_Null = 0,
    DeviceType_Floppy = 1,
    DeviceType_DVD = 2,
    DeviceType_HardDisk = 3,
    DeviceType_Network = 4,
    DeviceType_USB = 5,
    DeviceType_SharedFolder = 6,
    DeviceType_Graphics3D = 7,
    DeviceType_End = 8
} DeviceType;
/* End of enum DeviceType declaration */
#define DeviceType_T PRUint32


/* Start of enum DeviceActivity declaration */
#define DEVICEACTIVITY_IID_STR "6FC8AEAA-130A-4eb5-8954-3F921422D707"
#define DEVICEACTIVITY_IID { \
    0x6FC8AEAA, 0x130A, 0x4eb5, \
    { 0x89, 0x54, 0x3F, 0x92, 0x14, 0x22, 0xD7, 0x07 } \
}
typedef enum DeviceActivity
{
    DeviceActivity_Null = 0,
    DeviceActivity_Idle = 1,
    DeviceActivity_Reading = 2,
    DeviceActivity_Writing = 3
} DeviceActivity;
/* End of enum DeviceActivity declaration */
#define DeviceActivity_T PRUint32


/* Start of enum ClipboardMode declaration */
#define CLIPBOARDMODE_IID_STR "33364716-4008-4701-8f14-be0fa3d62950"
#define CLIPBOARDMODE_IID { \
    0x33364716, 0x4008, 0x4701, \
    { 0x8f, 0x14, 0xbe, 0x0f, 0xa3, 0xd6, 0x29, 0x50 } \
}
typedef enum ClipboardMode
{
    ClipboardMode_Disabled = 0,
    ClipboardMode_HostToGuest = 1,
    ClipboardMode_GuestToHost = 2,
    ClipboardMode_Bidirectional = 3
} ClipboardMode;
/* End of enum ClipboardMode declaration */
#define ClipboardMode_T PRUint32


/* Start of enum DnDMode declaration */
#define DNDMODE_IID_STR "07af8800-f936-4b33-9172-cd400e83c148"
#define DNDMODE_IID { \
    0x07af8800, 0xf936, 0x4b33, \
    { 0x91, 0x72, 0xcd, 0x40, 0x0e, 0x83, 0xc1, 0x48 } \
}
typedef enum DnDMode
{
    DnDMode_Disabled = 0,
    DnDMode_HostToGuest = 1,
    DnDMode_GuestToHost = 2,
    DnDMode_Bidirectional = 3
} DnDMode;
/* End of enum DnDMode declaration */
#define DnDMode_T PRUint32


/* Start of enum Scope declaration */
#define SCOPE_IID_STR "7c91096e-499e-4eca-9f9b-9001438d7855"
#define SCOPE_IID { \
    0x7c91096e, 0x499e, 0x4eca, \
    { 0x9f, 0x9b, 0x90, 0x01, 0x43, 0x8d, 0x78, 0x55 } \
}
typedef enum Scope
{
    Scope_Global = 0,
    Scope_Machine = 1,
    Scope_Session = 2
} Scope;
/* End of enum Scope declaration */
#define Scope_T PRUint32


/* Start of enum FirmwareBootMenuMode declaration */
#define FIRMWAREBOOTMENUMODE_IID_STR "bf88ec90-7fbb-4c78-bd71-5f8751d71450"
#define FIRMWAREBOOTMENUMODE_IID { \
    0xbf88ec90, 0x7fbb, 0x4c78, \
    { 0xbd, 0x71, 0x5f, 0x87, 0x51, 0xd7, 0x14, 0x50 } \
}
typedef enum FirmwareBootMenuMode
{
    FirmwareBootMenuMode_Disabled = 0,
    FirmwareBootMenuMode_MenuOnly = 1,
    FirmwareBootMenuMode_MessageAndMenu = 2
} FirmwareBootMenuMode;
/* End of enum FirmwareBootMenuMode declaration */
#define FirmwareBootMenuMode_T PRUint32


/* Start of enum APICMode declaration */
#define APICMODE_IID_STR "c6884ba5-3cc4-4a92-a7f6-4410f9fd894e"
#define APICMODE_IID { \
    0xc6884ba5, 0x3cc4, 0x4a92, \
    { 0xa7, 0xf6, 0x44, 0x10, 0xf9, 0xfd, 0x89, 0x4e } \
}
typedef enum APICMode
{
    APICMode_Disabled = 0,
    APICMode_APIC = 1,
    APICMode_X2APIC = 2
} APICMode;
/* End of enum APICMode declaration */
#define APICMode_T PRUint32


/* Start of enum ProcessorFeature declaration */
#define PROCESSORFEATURE_IID_STR "0064dece-000e-4963-00f8-eb9b00674c8a"
#define PROCESSORFEATURE_IID { \
    0x0064dece, 0x000e, 0x4963, \
    { 0x00, 0xf8, 0xeb, 0x9b, 0x00, 0x67, 0x4c, 0x8a } \
}
typedef enum ProcessorFeature
{
    ProcessorFeature_HWVirtEx = 0,
    ProcessorFeature_PAE = 1,
    ProcessorFeature_LongMode = 2,
    ProcessorFeature_NestedPaging = 3,
    ProcessorFeature_UnrestrictedGuest = 4,
    ProcessorFeature_NestedHWVirt = 5,
    ProcessorFeature_VirtVmsaveVmload = 6
} ProcessorFeature;
/* End of enum ProcessorFeature declaration */
#define ProcessorFeature_T PRUint32


/* Start of enum FirmwareType declaration */
#define FIRMWARETYPE_IID_STR "b903f264-c230-483e-ac74-2b37ce60d371"
#define FIRMWARETYPE_IID { \
    0xb903f264, 0xc230, 0x483e, \
    { 0xac, 0x74, 0x2b, 0x37, 0xce, 0x60, 0xd3, 0x71 } \
}
typedef enum FirmwareType
{
    FirmwareType_BIOS = 1,
    FirmwareType_EFI = 2,
    FirmwareType_EFI32 = 3,
    FirmwareType_EFI64 = 4,
    FirmwareType_EFIDUAL = 5
} FirmwareType;
/* End of enum FirmwareType declaration */
#define FirmwareType_T PRUint32


/* Start of enum PointingHIDType declaration */
#define POINTINGHIDTYPE_IID_STR "b3fd8215-6870-4e61-b6d9-2998fa625de0"
#define POINTINGHIDTYPE_IID { \
    0xb3fd8215, 0x6870, 0x4e61, \
    { 0xb6, 0xd9, 0x29, 0x98, 0xfa, 0x62, 0x5d, 0xe0 } \
}
typedef enum PointingHIDType
{
    PointingHIDType_None = 1,
    PointingHIDType_PS2Mouse = 2,
    PointingHIDType_USBMouse = 3,
    PointingHIDType_USBTablet = 4,
    PointingHIDType_ComboMouse = 5,
    PointingHIDType_USBMultiTouch = 6,
    PointingHIDType_USBMultiTouchScreenPlusPad = 7
} PointingHIDType;
/* End of enum PointingHIDType declaration */
#define PointingHIDType_T PRUint32


/* Start of enum KeyboardHIDType declaration */
#define KEYBOARDHIDTYPE_IID_STR "383e43d7-5c7c-4ec8-9cb8-eda1bccd6699"
#define KEYBOARDHIDTYPE_IID { \
    0x383e43d7, 0x5c7c, 0x4ec8, \
    { 0x9c, 0xb8, 0xed, 0xa1, 0xbc, 0xcd, 0x66, 0x99 } \
}
typedef enum KeyboardHIDType
{
    KeyboardHIDType_None = 1,
    KeyboardHIDType_PS2Keyboard = 2,
    KeyboardHIDType_USBKeyboard = 3,
    KeyboardHIDType_ComboKeyboard = 4
} KeyboardHIDType;
/* End of enum KeyboardHIDType declaration */
#define KeyboardHIDType_T PRUint32


/* Start of enum BitmapFormat declaration */
#define BITMAPFORMAT_IID_STR "afb2bf39-8b1e-4f9f-8948-d1b887f83eb0"
#define BITMAPFORMAT_IID { \
    0xafb2bf39, 0x8b1e, 0x4f9f, \
    { 0x89, 0x48, 0xd1, 0xb8, 0x87, 0xf8, 0x3e, 0xb0 } \
}
typedef enum BitmapFormat
{
    BitmapFormat_Opaque = 0,
    BitmapFormat_BGR = 0x20524742,
    BitmapFormat_BGR0 = 0x30524742,
    BitmapFormat_BGRA = 0x41524742,
    BitmapFormat_RGBA = 0x41424752,
    BitmapFormat_PNG = 0x20474E50,
    BitmapFormat_JPEG = 0x4745504A
} BitmapFormat;
/* End of enum BitmapFormat declaration */
#define BitmapFormat_T PRUint32


/* Start of enum PartitioningType declaration */
#define PARTITIONINGTYPE_IID_STR "64c4c806-8908-4c0b-9a51-2d7a0151321f"
#define PARTITIONINGTYPE_IID { \
    0x64c4c806, 0x8908, 0x4c0b, \
    { 0x9a, 0x51, 0x2d, 0x7a, 0x01, 0x51, 0x32, 0x1f } \
}
typedef enum PartitioningType
{
    PartitioningType_MBR = 0,
    PartitioningType_GPT = 1
} PartitioningType;
/* End of enum PartitioningType declaration */
#define PartitioningType_T PRUint32


/* Start of enum PartitionType declaration */
#define PARTITIONTYPE_IID_STR "84a6629c-8e9c-474c-adbb-21995671597f"
#define PARTITIONTYPE_IID { \
    0x84a6629c, 0x8e9c, 0x474c, \
    { 0xad, 0xbb, 0x21, 0x99, 0x56, 0x71, 0x59, 0x7f } \
}
typedef enum PartitionType
{
    PartitionType_Empty = 0,
    PartitionType_FAT12 = 1,
    PartitionType_FAT16 = 4,
    PartitionType_FAT = 6,
    PartitionType_IFS = 7,
    PartitionType_FAT32CHS = 11,
    PartitionType_FAT32LBA = 12,
    PartitionType_FAT16B = 14,
    PartitionType_Extended = 15,
    PartitionType_WindowsRE = 39,
    PartitionType_LinuxSwapOld = 66,
    PartitionType_LinuxOld = 67,
    PartitionType_DragonFlyBSDSlice = 108,
    PartitionType_LinuxSwap = 130,
    PartitionType_Linux = 131,
    PartitionType_LinuxExtended = 133,
    PartitionType_LinuxLVM = 142,
    PartitionType_BSDSlice = 165,
    PartitionType_AppleUFS = 168,
    PartitionType_AppleHFS = 175,
    PartitionType_Solaris = 191,
    PartitionType_GPT = 238,
    PartitionType_EFI = 239,
    PartitionType_Unknown = 256,
    PartitionType_MBR = 257,
    PartitionType_iFFS = 258,
    PartitionType_SonyBoot = 259,
    PartitionType_LenovoBoot = 260,
    PartitionType_WindowsMSR = 270,
    PartitionType_WindowsBasicData = 271,
    PartitionType_WindowsLDMMeta = 272,
    PartitionType_WindowsLDMData = 273,
    PartitionType_WindowsRecovery = 274,
    PartitionType_WindowsStorageSpaces = 276,
    PartitionType_WindowsStorageReplica = 277,
    PartitionType_IBMGPFS = 275,
    PartitionType_LinuxData = 300,
    PartitionType_LinuxRAID = 301,
    PartitionType_LinuxRootX86 = 302,
    PartitionType_LinuxRootAMD64 = 303,
    PartitionType_LinuxRootARM32 = 304,
    PartitionType_LinuxRootARM64 = 305,
    PartitionType_LinuxHome = 306,
    PartitionType_LinuxSrv = 307,
    PartitionType_LinuxPlainDmCrypt = 308,
    PartitionType_LinuxLUKS = 309,
    PartitionType_LinuxReserved = 310,
    PartitionType_FreeBSDBoot = 330,
    PartitionType_FreeBSDData = 331,
    PartitionType_FreeBSDSwap = 332,
    PartitionType_FreeBSDUFS = 333,
    PartitionType_FreeBSDVinum = 334,
    PartitionType_FreeBSDZFS = 335,
    PartitionType_FreeBSDUnknown = 359,
    PartitionType_AppleHFSPlus = 360,
    PartitionType_AppleAPFS = 361,
    PartitionType_AppleRAID = 362,
    PartitionType_AppleRAIDOffline = 363,
    PartitionType_AppleBoot = 364,
    PartitionType_AppleLabel = 365,
    PartitionType_AppleTvRecovery = 366,
    PartitionType_AppleCoreStorage = 367,
    PartitionType_SoftRAIDStatus = 370,
    PartitionType_SoftRAIDScratch = 371,
    PartitionType_SoftRAIDVolume = 372,
    PartitionType_SoftRAIDCache = 373,
    PartitionType_AppleUnknown = 389,
    PartitionType_SolarisBoot = 390,
    PartitionType_SolarisRoot = 391,
    PartitionType_SolarisSwap = 392,
    PartitionType_SolarisBackup = 393,
    PartitionType_SolarisUsr = 394,
    PartitionType_SolarisVar = 395,
    PartitionType_SolarisHome = 396,
    PartitionType_SolarisAltSector = 397,
    PartitionType_SolarisReserved = 398,
    PartitionType_SolarisUnknown = 419,
    PartitionType_NetBSDSwap = 420,
    PartitionType_NetBSDFFS = 421,
    PartitionType_NetBSDLFS = 422,
    PartitionType_NetBSDRAID = 423,
    PartitionType_NetBSDConcatenated = 424,
    PartitionType_NetBSDEncrypted = 425,
    PartitionType_NetBSDUnknown = 449,
    PartitionType_ChromeOSKernel = 450,
    PartitionType_ChromeOSRootFS = 451,
    PartitionType_ChromeOSFuture = 452,
    PartitionType_ContLnxUsr = 480,
    PartitionType_ContLnxRoot = 481,
    PartitionType_ContLnxReserved = 482,
    PartitionType_ContLnxRootRAID = 483,
    PartitionType_HaikuBFS = 510,
    PartitionType_MidntBSDBoot = 540,
    PartitionType_MidntBSDData = 541,
    PartitionType_MidntBSDSwap = 542,
    PartitionType_MidntBSDUFS = 543,
    PartitionType_MidntBSDVium = 544,
    PartitionType_MidntBSDZFS = 545,
    PartitionType_MidntBSDUnknown = 569,
    PartitionType_OpenBSDData = 570,
    PartitionType_QNXPowerSafeFS = 600,
    PartitionType_Plan9 = 630,
    PartitionType_VMWareVMKCore = 660,
    PartitionType_VMWareVMFS = 661,
    PartitionType_VMWareReserved = 662,
    PartitionType_VMWareUnknown = 689,
    PartitionType_AndroidX86Bootloader = 690,
    PartitionType_AndroidX86Bootloader2 = 691,
    PartitionType_AndroidX86Boot = 692,
    PartitionType_AndroidX86Recovery = 693,
    PartitionType_AndroidX86Misc = 694,
    PartitionType_AndroidX86Metadata = 695,
    PartitionType_AndroidX86System = 696,
    PartitionType_AndroidX86Cache = 697,
    PartitionType_AndroidX86Data = 698,
    PartitionType_AndroidX86Persistent = 699,
    PartitionType_AndroidX86Vendor = 700,
    PartitionType_AndroidX86Config = 701,
    PartitionType_AndroidX86Factory = 702,
    PartitionType_AndroidX86FactoryAlt = 703,
    PartitionType_AndroidX86Fastboot = 704,
    PartitionType_AndroidX86OEM = 705,
    PartitionType_AndroidARMMeta = 720,
    PartitionType_AndroidARMExt = 721,
    PartitionType_ONIEBoot = 750,
    PartitionType_ONIEConfig = 751,
    PartitionType_PowerPCPrep = 780,
    PartitionType_XDGShrBootConfig = 810,
    PartitionType_CephBlock = 830,
    PartitionType_CephBlockDB = 831,
    PartitionType_CephBlockDBDmc = 832,
    PartitionType_CephBlockDBDmcLUKS = 833,
    PartitionType_CephBlockDmc = 834,
    PartitionType_CephBlockDmcLUKS = 835,
    PartitionType_CephBlockWALog = 836,
    PartitionType_CephBlockWALogDmc = 837,
    PartitionType_CephBlockWALogDmcLUKS = 838,
    PartitionType_CephDisk = 839,
    PartitionType_CephDiskDmc = 840,
    PartitionType_CephJournal = 841,
    PartitionType_CephJournalDmc = 842,
    PartitionType_CephJournalDmcLUKS = 843,
    PartitionType_CephLockbox = 844,
    PartitionType_CephMultipathBlock1 = 845,
    PartitionType_CephMultipathBlock2 = 846,
    PartitionType_CephMultipathBlockDB = 847,
    PartitionType_CephMultipathBLockWALog = 848,
    PartitionType_CephMultipathJournal = 849,
    PartitionType_CephMultipathOSD = 851,
    PartitionType_CephOSD = 852,
    PartitionType_CephOSDDmc = 853,
    PartitionType_CephOSDDmcLUKS = 854
} PartitionType;
/* End of enum PartitionType declaration */
#define PartitionType_T PRUint32


/* Start of enum DHCPOption declaration */
#define DHCPOPTION_IID_STR "00f5b10f-0021-4513-00f7-5bf4000982bf"
#define DHCPOPTION_IID { \
    0x00f5b10f, 0x0021, 0x4513, \
    { 0x00, 0xf7, 0x5b, 0xf4, 0x00, 0x09, 0x82, 0xbf } \
}
typedef enum DHCPOption
{
    DHCPOption_SubnetMask = 1,
    DHCPOption_TimeOffset = 2,
    DHCPOption_Routers = 3,
    DHCPOption_TimeServers = 4,
    DHCPOption_NameServers = 5,
    DHCPOption_DomainNameServers = 6,
    DHCPOption_LogServers = 7,
    DHCPOption_CookieServers = 8,
    DHCPOption_LPRServers = 9,
    DHCPOption_ImpressServers = 10,
    DHCPOption_ResourseLocationServers = 11,
    DHCPOption_HostName = 12,
    DHCPOption_BootFileSize = 13,
    DHCPOption_MeritDumpFile = 14,
    DHCPOption_DomainName = 15,
    DHCPOption_SwapServer = 16,
    DHCPOption_RootPath = 17,
    DHCPOption_ExtensionPath = 18,
    DHCPOption_IPForwarding = 19,
    DHCPOption_OptNonLocalSourceRouting = 20,
    DHCPOption_PolicyFilter = 21,
    DHCPOption_MaxDgramReassemblySize = 22,
    DHCPOption_DefaultIPTTL = 23,
    DHCPOption_PathMTUAgingTimeout = 24,
    DHCPOption_PathMTUPlateauTable = 25,
    DHCPOption_InterfaceMTU = 26,
    DHCPOption_AllSubnetsAreLocal = 27,
    DHCPOption_BroadcastAddress = 28,
    DHCPOption_PerformMaskDiscovery = 29,
    DHCPOption_MaskSupplier = 30,
    DHCPOption_PerformRouterDiscovery = 31,
    DHCPOption_RouterSolicitationAddress = 32,
    DHCPOption_StaticRoute = 33,
    DHCPOption_TrailerEncapsulation = 34,
    DHCPOption_ARPCacheTimeout = 35,
    DHCPOption_EthernetEncapsulation = 36,
    DHCPOption_TCPDefaultTTL = 37,
    DHCPOption_TCPKeepaliveInterval = 38,
    DHCPOption_TCPKeepaliveGarbage = 39,
    DHCPOption_NISDomain = 40,
    DHCPOption_NISServers = 41,
    DHCPOption_NTPServers = 42,
    DHCPOption_VendorSpecificInfo = 43,
    DHCPOption_NetBIOSNameServers = 44,
    DHCPOption_NetBIOSDatagramServers = 45,
    DHCPOption_NetBIOSNodeType = 46,
    DHCPOption_NetBIOSScope = 47,
    DHCPOption_XWindowsFontServers = 48,
    DHCPOption_XWindowsDisplayManager = 49,
    DHCPOption_NetWareIPDomainName = 62,
    DHCPOption_NetWareIPInformation = 63,
    DHCPOption_NISPlusDomain = 64,
    DHCPOption_NISPlusServers = 65,
    DHCPOption_TFTPServerName = 66,
    DHCPOption_BootfileName = 67,
    DHCPOption_MobileIPHomeAgents = 68,
    DHCPOption_SMTPServers = 69,
    DHCPOption_POP3Servers = 70,
    DHCPOption_NNTPServers = 71,
    DHCPOption_WWWServers = 72,
    DHCPOption_FingerServers = 73,
    DHCPOption_IRCServers = 74,
    DHCPOption_StreetTalkServers = 75,
    DHCPOption_STDAServers = 76,
    DHCPOption_SLPDirectoryAgent = 78,
    DHCPOption_SLPServiceScope = 79,
    DHCPOption_DomainSearch = 119
} DHCPOption;
/* End of enum DHCPOption declaration */
#define DHCPOption_T PRUint32


/* Start of enum DHCPOptionEncoding declaration */
#define DHCPOPTIONENCODING_IID_STR "84b6d460-2838-4682-c0d6-ef5b573ef28a"
#define DHCPOPTIONENCODING_IID { \
    0x84b6d460, 0x2838, 0x4682, \
    { 0xc0, 0xd6, 0xef, 0x5b, 0x57, 0x3e, 0xf2, 0x8a } \
}
typedef enum DHCPOptionEncoding
{
    DHCPOptionEncoding_Normal = 0,
    DHCPOptionEncoding_Hex = 1
} DHCPOptionEncoding;
/* End of enum DHCPOptionEncoding declaration */
#define DHCPOptionEncoding_T PRUint32


/* Start of enum DHCPConfigScope declaration */
#define DHCPCONFIGSCOPE_IID_STR "469c42e4-b9ec-43f2-bdcb-9e9d1eb434ae"
#define DHCPCONFIGSCOPE_IID { \
    0x469c42e4, 0xb9ec, 0x43f2, \
    { 0xbd, 0xcb, 0x9e, 0x9d, 0x1e, 0xb4, 0x34, 0xae } \
}
typedef enum DHCPConfigScope
{
    DHCPConfigScope_Global = 0,
    DHCPConfigScope_Group = 1,
    DHCPConfigScope_MachineNIC = 2,
    DHCPConfigScope_MAC = 3
} DHCPConfigScope;
/* End of enum DHCPConfigScope declaration */
#define DHCPConfigScope_T PRUint32


/* Start of enum DHCPGroupConditionType declaration */
#define DHCPGROUPCONDITIONTYPE_IID_STR "2cb9280f-ada2-4194-dee8-bfb8ad77119d"
#define DHCPGROUPCONDITIONTYPE_IID { \
    0x2cb9280f, 0xada2, 0x4194, \
    { 0xde, 0xe8, 0xbf, 0xb8, 0xad, 0x77, 0x11, 0x9d } \
}
typedef enum DHCPGroupConditionType
{
    DHCPGroupConditionType_MAC = 0,
    DHCPGroupConditionType_MACWildcard = 1,
    DHCPGroupConditionType_vendorClassID = 2,
    DHCPGroupConditionType_vendorClassIDWildcard = 3,
    DHCPGroupConditionType_userClassID = 4,
    DHCPGroupConditionType_userClassIDWildcard = 5
} DHCPGroupConditionType;
/* End of enum DHCPGroupConditionType declaration */
#define DHCPGroupConditionType_T PRUint32


/* Start of enum VFSType declaration */
#define VFSTYPE_IID_STR "813999ba-b949-48a8-9230-aadc6285e2f2"
#define VFSTYPE_IID { \
    0x813999ba, 0xb949, 0x48a8, \
    { 0x92, 0x30, 0xaa, 0xdc, 0x62, 0x85, 0xe2, 0xf2 } \
}
typedef enum VFSType
{
    VFSType_File = 1,
    VFSType_Cloud = 2,
    VFSType_S3 = 3,
    VFSType_WebDav = 4
} VFSType;
/* End of enum VFSType declaration */
#define VFSType_T PRUint32


/* Start of enum ImportOptions declaration */
#define IMPORTOPTIONS_IID_STR "0a981523-3b20-4004-8ee3-dfd322202ace"
#define IMPORTOPTIONS_IID { \
    0x0a981523, 0x3b20, 0x4004, \
    { 0x8e, 0xe3, 0xdf, 0xd3, 0x22, 0x20, 0x2a, 0xce } \
}
typedef enum ImportOptions
{
    ImportOptions_KeepAllMACs = 1,
    ImportOptions_KeepNATMACs = 2,
    ImportOptions_ImportToVDI = 3
} ImportOptions;
/* End of enum ImportOptions declaration */
#define ImportOptions_T PRUint32


/* Start of enum ExportOptions declaration */
#define EXPORTOPTIONS_IID_STR "8f45eb08-fd34-41ee-af95-a880bdee5554"
#define EXPORTOPTIONS_IID { \
    0x8f45eb08, 0xfd34, 0x41ee, \
    { 0xaf, 0x95, 0xa8, 0x80, 0xbd, 0xee, 0x55, 0x54 } \
}
typedef enum ExportOptions
{
    ExportOptions_CreateManifest = 1,
    ExportOptions_ExportDVDImages = 2,
    ExportOptions_StripAllMACs = 3,
    ExportOptions_StripAllNonNATMACs = 4
} ExportOptions;
/* End of enum ExportOptions declaration */
#define ExportOptions_T PRUint32


/* Start of enum CertificateVersion declaration */
#define CERTIFICATEVERSION_IID_STR "9e232a99-51d0-4dbd-96a0-ffac4bc3e2a8"
#define CERTIFICATEVERSION_IID { \
    0x9e232a99, 0x51d0, 0x4dbd, \
    { 0x96, 0xa0, 0xff, 0xac, 0x4b, 0xc3, 0xe2, 0xa8 } \
}
typedef enum CertificateVersion
{
    CertificateVersion_V1 = 1,
    CertificateVersion_V2 = 2,
    CertificateVersion_V3 = 3,
    CertificateVersion_Unknown = 99
} CertificateVersion;
/* End of enum CertificateVersion declaration */
#define CertificateVersion_T PRUint32


/* Start of enum VirtualSystemDescriptionType declaration */
#define VIRTUALSYSTEMDESCRIPTIONTYPE_IID_STR "d171d08c-f7bf-4bee-932f-ffbf998f7ac4"
#define VIRTUALSYSTEMDESCRIPTIONTYPE_IID { \
    0xd171d08c, 0xf7bf, 0x4bee, \
    { 0x93, 0x2f, 0xff, 0xbf, 0x99, 0x8f, 0x7a, 0xc4 } \
}
typedef enum VirtualSystemDescriptionType
{
    VirtualSystemDescriptionType_Ignore = 1,
    VirtualSystemDescriptionType_OS = 2,
    VirtualSystemDescriptionType_Name = 3,
    VirtualSystemDescriptionType_Product = 4,
    VirtualSystemDescriptionType_Vendor = 5,
    VirtualSystemDescriptionType_Version = 6,
    VirtualSystemDescriptionType_ProductUrl = 7,
    VirtualSystemDescriptionType_VendorUrl = 8,
    VirtualSystemDescriptionType_Description = 9,
    VirtualSystemDescriptionType_License = 10,
    VirtualSystemDescriptionType_Miscellaneous = 11,
    VirtualSystemDescriptionType_CPU = 12,
    VirtualSystemDescriptionType_Memory = 13,
    VirtualSystemDescriptionType_HardDiskControllerIDE = 14,
    VirtualSystemDescriptionType_HardDiskControllerSATA = 15,
    VirtualSystemDescriptionType_HardDiskControllerSCSI = 16,
    VirtualSystemDescriptionType_HardDiskControllerSAS = 17,
    VirtualSystemDescriptionType_HardDiskImage = 18,
    VirtualSystemDescriptionType_Floppy = 19,
    VirtualSystemDescriptionType_CDROM = 20,
    VirtualSystemDescriptionType_NetworkAdapter = 21,
    VirtualSystemDescriptionType_USBController = 22,
    VirtualSystemDescriptionType_SoundCard = 23,
    VirtualSystemDescriptionType_SettingsFile = 24,
    VirtualSystemDescriptionType_BaseFolder = 25,
    VirtualSystemDescriptionType_PrimaryGroup = 26,
    VirtualSystemDescriptionType_CloudInstanceShape = 27,
    VirtualSystemDescriptionType_CloudDomain = 28,
    VirtualSystemDescriptionType_CloudBootDiskSize = 29,
    VirtualSystemDescriptionType_CloudBucket = 30,
    VirtualSystemDescriptionType_CloudOCIVCN = 31,
    VirtualSystemDescriptionType_CloudPublicIP = 32,
    VirtualSystemDescriptionType_CloudProfileName = 33,
    VirtualSystemDescriptionType_CloudOCISubnet = 34,
    VirtualSystemDescriptionType_CloudKeepObject = 35,
    VirtualSystemDescriptionType_CloudLaunchInstance = 36,
    VirtualSystemDescriptionType_CloudInstanceId = 37,
    VirtualSystemDescriptionType_CloudImageId = 38,
    VirtualSystemDescriptionType_CloudInstanceState = 39,
    VirtualSystemDescriptionType_CloudImageState = 40,
    VirtualSystemDescriptionType_CloudInstanceDisplayName = 41,
    VirtualSystemDescriptionType_CloudImageDisplayName = 42,
    VirtualSystemDescriptionType_CloudOCILaunchMode = 43,
    VirtualSystemDescriptionType_CloudPrivateIP = 44,
    VirtualSystemDescriptionType_CloudBootVolumeId = 45,
    VirtualSystemDescriptionType_CloudOCIVCNCompartment = 46,
    VirtualSystemDescriptionType_CloudOCISubnetCompartment = 47,
    VirtualSystemDescriptionType_CloudPublicSSHKey = 48,
    VirtualSystemDescriptionType_BootingFirmware = 49,
    VirtualSystemDescriptionType_CloudInitScriptPath = 50,
    VirtualSystemDescriptionType_CloudCompartmentId = 51,
    VirtualSystemDescriptionType_CloudShapeCpus = 52,
    VirtualSystemDescriptionType_CloudShapeMemory = 53,
    VirtualSystemDescriptionType_CloudInstanceMetadata = 54,
    VirtualSystemDescriptionType_CloudInstanceFreeFormTags = 55,
    VirtualSystemDescriptionType_CloudImageFreeFormTags = 56,
    VirtualSystemDescriptionType_HardDiskControllerVirtioSCSI = 60,
    VirtualSystemDescriptionType_HardDiskControllerNVMe = 61,
    VirtualSystemDescriptionType_NVRAM = 0x8000
} VirtualSystemDescriptionType;
/* End of enum VirtualSystemDescriptionType declaration */
#define VirtualSystemDescriptionType_T PRUint32


/* Start of enum VirtualSystemDescriptionValueType declaration */
#define VIRTUALSYSTEMDESCRIPTIONVALUETYPE_IID_STR "56d9403f-3425-4118-9919-36f2a9b8c77c"
#define VIRTUALSYSTEMDESCRIPTIONVALUETYPE_IID { \
    0x56d9403f, 0x3425, 0x4118, \
    { 0x99, 0x19, 0x36, 0xf2, 0xa9, 0xb8, 0xc7, 0x7c } \
}
typedef enum VirtualSystemDescriptionValueType
{
    VirtualSystemDescriptionValueType_Reference = 1,
    VirtualSystemDescriptionValueType_Original = 2,
    VirtualSystemDescriptionValueType_Auto = 3,
    VirtualSystemDescriptionValueType_ExtraConfig = 4
} VirtualSystemDescriptionValueType;
/* End of enum VirtualSystemDescriptionValueType declaration */
#define VirtualSystemDescriptionValueType_T PRUint32


/* Start of enum TpmType declaration */
#define TPMTYPE_IID_STR "c669b9f7-a547-42b6-8464-636aa53401eb"
#define TPMTYPE_IID { \
    0xc669b9f7, 0xa547, 0x42b6, \
    { 0x84, 0x64, 0x63, 0x6a, 0xa5, 0x34, 0x01, 0xeb } \
}
typedef enum TpmType
{
    TpmType_None = 0,
    TpmType_v1_2 = 1,
    TpmType_v2_0 = 2,
    TpmType_Host = 3,
    TpmType_Swtpm = 4
} TpmType;
/* End of enum TpmType declaration */
#define TpmType_T PRUint32


/* Start of enum RecordingDestination declaration */
#define RECORDINGDESTINATION_IID_STR "11E3F06B-DEC1-48B9-BDC4-1E618D72893C"
#define RECORDINGDESTINATION_IID { \
    0x11E3F06B, 0xDEC1, 0x48B9, \
    { 0xBD, 0xC4, 0x1E, 0x61, 0x8D, 0x72, 0x89, 0x3C } \
}
typedef enum RecordingDestination
{
    RecordingDestination_None = 0,
    RecordingDestination_File = 1
} RecordingDestination;
/* End of enum RecordingDestination declaration */
#define RecordingDestination_T PRUint32


/* Start of enum RecordingFeature declaration */
#define RECORDINGFEATURE_IID_STR "A7DDC6A5-DAA8-4485-B860-E9F2E98A7794"
#define RECORDINGFEATURE_IID { \
    0xA7DDC6A5, 0xDAA8, 0x4485, \
    { 0xB8, 0x60, 0xE9, 0xF2, 0xE9, 0x8A, 0x77, 0x94 } \
}
typedef enum RecordingFeature
{
    RecordingFeature_None = 0x0,
    RecordingFeature_Video = 0x1,
    RecordingFeature_Audio = 0x2
} RecordingFeature;
/* End of enum RecordingFeature declaration */
#define RecordingFeature_T PRUint32


/* Start of enum RecordingAudioCodec declaration */
#define RECORDINGAUDIOCODEC_IID_STR "16c42be8-1713-4717-a8b9-c65a6549fbcd"
#define RECORDINGAUDIOCODEC_IID { \
    0x16c42be8, 0x1713, 0x4717, \
    { 0xa8, 0xb9, 0xc6, 0x5a, 0x65, 0x49, 0xfb, 0xcd } \
}
typedef enum RecordingAudioCodec
{
    RecordingAudioCodec_None = 0,
    RecordingAudioCodec_WavPCM = 1,
    RecordingAudioCodec_MP3 = 2,
    RecordingAudioCodec_OggVorbis = 3,
    RecordingAudioCodec_Opus = 4,
    RecordingAudioCodec_Other = 5
} RecordingAudioCodec;
/* End of enum RecordingAudioCodec declaration */
#define RecordingAudioCodec_T PRUint32


/* Start of enum RecordingCodecDeadline declaration */
#define RECORDINGCODECDEADLINE_IID_STR "53627ae1-31cf-4303-9cd5-0c22fd2637cf"
#define RECORDINGCODECDEADLINE_IID { \
    0x53627ae1, 0x31cf, 0x4303, \
    { 0x9c, 0xd5, 0x0c, 0x22, 0xfd, 0x26, 0x37, 0xcf } \
}
typedef enum RecordingCodecDeadline
{
    RecordingCodecDeadline_Default = 0,
    RecordingCodecDeadline_Realtime = 1,
    RecordingCodecDeadline_Good = 2,
    RecordingCodecDeadline_Best = 3
} RecordingCodecDeadline;
/* End of enum RecordingCodecDeadline declaration */
#define RecordingCodecDeadline_T PRUint32


/* Start of enum RecordingVideoCodec declaration */
#define RECORDINGVIDEOCODEC_IID_STR "93791063-3e8c-4310-987c-ddb43ff03ffe"
#define RECORDINGVIDEOCODEC_IID { \
    0x93791063, 0x3e8c, 0x4310, \
    { 0x98, 0x7c, 0xdd, 0xb4, 0x3f, 0xf0, 0x3f, 0xfe } \
}
typedef enum RecordingVideoCodec
{
    RecordingVideoCodec_None = 0,
    RecordingVideoCodec_MJPEG = 1,
    RecordingVideoCodec_H262 = 2,
    RecordingVideoCodec_H264 = 3,
    RecordingVideoCodec_H265 = 4,
    RecordingVideoCodec_H266 = 5,
    RecordingVideoCodec_VP8 = 6,
    RecordingVideoCodec_VP9 = 7,
    RecordingVideoCodec_AV1 = 8,
    RecordingVideoCodec_Other = 9
} RecordingVideoCodec;
/* End of enum RecordingVideoCodec declaration */
#define RecordingVideoCodec_T PRUint32


/* Start of enum RecordingVideoScalingMode declaration */
#define RECORDINGVIDEOSCALINGMODE_IID_STR "0dd1127d-4f62-4b82-beee-91086a9f1d24"
#define RECORDINGVIDEOSCALINGMODE_IID { \
    0x0dd1127d, 0x4f62, 0x4b82, \
    { 0xbe, 0xee, 0x91, 0x08, 0x6a, 0x9f, 0x1d, 0x24 } \
}
typedef enum RecordingVideoScalingMode
{
    RecordingVideoScalingMode_None = 0,
    RecordingVideoScalingMode_NearestNeighbor = 1,
    RecordingVideoScalingMode_Bilinear = 2,
    RecordingVideoScalingMode_Bicubic = 3
} RecordingVideoScalingMode;
/* End of enum RecordingVideoScalingMode declaration */
#define RecordingVideoScalingMode_T PRUint32


/* Start of enum RecordingRateControlMode declaration */
#define RECORDINGRATECONTROLMODE_IID_STR "d07a33ac-b4ea-4917-942d-c03be14fbe2f"
#define RECORDINGRATECONTROLMODE_IID { \
    0xd07a33ac, 0xb4ea, 0x4917, \
    { 0x94, 0x2d, 0xc0, 0x3b, 0xe1, 0x4f, 0xbe, 0x2f } \
}
typedef enum RecordingRateControlMode
{
    RecordingRateControlMode_ABR = 0,
    RecordingRateControlMode_CBR = 1,
    RecordingRateControlMode_VBR = 2
} RecordingRateControlMode;
/* End of enum RecordingRateControlMode declaration */
#define RecordingRateControlMode_T PRUint32


/* Start of enum SignatureType declaration */
#define SIGNATURETYPE_IID_STR "6f6e67ef-9a32-4084-af84-5702679f882a"
#define SIGNATURETYPE_IID { \
    0x6f6e67ef, 0x9a32, 0x4084, \
    { 0xaf, 0x84, 0x57, 0x02, 0x67, 0x9f, 0x88, 0x2a } \
}
typedef enum SignatureType
{
    SignatureType_X509 = 0,
    SignatureType_Sha256 = 1
} SignatureType;
/* End of enum SignatureType declaration */
#define SignatureType_T PRUint32


/* Start of enum UefiVariableAttributes declaration */
#define UEFIVARIABLEATTRIBUTES_IID_STR "cda505ec-b444-4aef-b55c-b687717bdac5"
#define UEFIVARIABLEATTRIBUTES_IID { \
    0xcda505ec, 0xb444, 0x4aef, \
    { 0xb5, 0x5c, 0xb6, 0x87, 0x71, 0x7b, 0xda, 0xc5 } \
}
typedef enum UefiVariableAttributes
{
    UefiVariableAttributes_None = 0,
    UefiVariableAttributes_NonVolatile = 0x01,
    UefiVariableAttributes_BootServiceAccess = 0x02,
    UefiVariableAttributes_RuntimeAccess = 0x04,
    UefiVariableAttributes_HwErrorRecord = 0x08,
    UefiVariableAttributes_AuthWriteAccess = 0x100,
    UefiVariableAttributes_AuthTimeBasedWriteAccess = 0x200,
    UefiVariableAttributes_AuthAppendWrite = 0x400
} UefiVariableAttributes;
/* End of enum UefiVariableAttributes declaration */
#define UefiVariableAttributes_T PRUint32


/* Start of enum GraphicsControllerType declaration */
#define GRAPHICSCONTROLLERTYPE_IID_STR "e1379bad-ae01-493d-abf5-740a95c41676"
#define GRAPHICSCONTROLLERTYPE_IID { \
    0xe1379bad, 0xae01, 0x493d, \
    { 0xab, 0xf5, 0x74, 0x0a, 0x95, 0xc4, 0x16, 0x76 } \
}
typedef enum GraphicsControllerType
{
    GraphicsControllerType_Null = 0,
    GraphicsControllerType_VBoxVGA = 1,
    GraphicsControllerType_VMSVGA = 2,
    GraphicsControllerType_VBoxSVGA = 3,
    GraphicsControllerType_QemuRamFB = 4
} GraphicsControllerType;
/* End of enum GraphicsControllerType declaration */
#define GraphicsControllerType_T PRUint32


/* Start of enum GraphicsFeature declaration */
#define GRAPHICSFEATURE_IID_STR "5cd900a5-ec77-4a08-8f8d-c0a36f462a7c"
#define GRAPHICSFEATURE_IID { \
    0x5cd900a5, 0xec77, 0x4a08, \
    { 0x8f, 0x8d, 0xc0, 0xa3, 0x6f, 0x46, 0x2a, 0x7c } \
}
typedef enum GraphicsFeature
{
    GraphicsFeature_None = 0,
    GraphicsFeature_Acceleration2DVideo = 1,
    GraphicsFeature_Acceleration3D = 2
} GraphicsFeature;
/* End of enum GraphicsFeature declaration */
#define GraphicsFeature_T PRUint32


/* Start of enum CleanupMode declaration */
#define CLEANUPMODE_IID_STR "67897c50-7cca-47a9-83f6-ce8fd8eb5441"
#define CLEANUPMODE_IID { \
    0x67897c50, 0x7cca, 0x47a9, \
    { 0x83, 0xf6, 0xce, 0x8f, 0xd8, 0xeb, 0x54, 0x41 } \
}
typedef enum CleanupMode
{
    CleanupMode_UnregisterOnly = 1,
    CleanupMode_DetachAllReturnNone = 2,
    CleanupMode_DetachAllReturnHardDisksOnly = 3,
    CleanupMode_Full = 4,
    CleanupMode_DetachAllReturnHardDisksAndVMRemovable = 5
} CleanupMode;
/* End of enum CleanupMode declaration */
#define CleanupMode_T PRUint32


/* Start of enum CloneMode declaration */
#define CLONEMODE_IID_STR "A7A159FE-5096-4B8D-8C3C-D033CB0B35A8"
#define CLONEMODE_IID { \
    0xA7A159FE, 0x5096, 0x4B8D, \
    { 0x8C, 0x3C, 0xD0, 0x33, 0xCB, 0x0B, 0x35, 0xA8 } \
}
typedef enum CloneMode
{
    CloneMode_MachineState = 1,
    CloneMode_MachineAndChildStates = 2,
    CloneMode_AllStates = 3
} CloneMode;
/* End of enum CloneMode declaration */
#define CloneMode_T PRUint32


/* Start of enum CloneOptions declaration */
#define CLONEOPTIONS_IID_STR "22243f8e-96ab-497c-8cf0-f40a566c630b"
#define CLONEOPTIONS_IID { \
    0x22243f8e, 0x96ab, 0x497c, \
    { 0x8c, 0xf0, 0xf4, 0x0a, 0x56, 0x6c, 0x63, 0x0b } \
}
typedef enum CloneOptions
{
    CloneOptions_Link = 1,
    CloneOptions_KeepAllMACs = 2,
    CloneOptions_KeepNATMACs = 3,
    CloneOptions_KeepDiskNames = 4,
    CloneOptions_KeepHwUUIDs = 5
} CloneOptions;
/* End of enum CloneOptions declaration */
#define CloneOptions_T PRUint32


/* Start of enum AutostopType declaration */
#define AUTOSTOPTYPE_IID_STR "6bb96740-cf34-470d-aab2-2cd48ea2e10e"
#define AUTOSTOPTYPE_IID { \
    0x6bb96740, 0xcf34, 0x470d, \
    { 0xaa, 0xb2, 0x2c, 0xd4, 0x8e, 0xa2, 0xe1, 0x0e } \
}
typedef enum AutostopType
{
    AutostopType_Disabled = 1,
    AutostopType_SaveState = 2,
    AutostopType_PowerOff = 3,
    AutostopType_AcpiShutdown = 4
} AutostopType;
/* End of enum AutostopType declaration */
#define AutostopType_T PRUint32


/* Start of enum VMProcPriority declaration */
#define VMPROCPRIORITY_IID_STR "6fa72dd5-19b7-46ba-bc52-f223c98c7d80"
#define VMPROCPRIORITY_IID { \
    0x6fa72dd5, 0x19b7, 0x46ba, \
    { 0xbc, 0x52, 0xf2, 0x23, 0xc9, 0x8c, 0x7d, 0x80 } \
}
typedef enum VMProcPriority
{
    VMProcPriority_Invalid = 0,
    VMProcPriority_Default = 1,
    VMProcPriority_Flat = 2,
    VMProcPriority_Low = 3,
    VMProcPriority_Normal = 5,
    VMProcPriority_High = 6
} VMProcPriority;
/* End of enum VMProcPriority declaration */
#define VMProcPriority_T PRUint32


/* Start of enum IommuType declaration */
#define IOMMUTYPE_IID_STR "f47339cb-b94e-48fe-b507-2900103d7b9f"
#define IOMMUTYPE_IID { \
    0xf47339cb, 0xb94e, 0x48fe, \
    { 0xb5, 0x07, 0x29, 0x00, 0x10, 0x3d, 0x7b, 0x9f } \
}
typedef enum IommuType
{
    IommuType_None = 0,
    IommuType_Automatic = 1,
    IommuType_AMD = 2,
    IommuType_Intel = 3
} IommuType;
/* End of enum IommuType declaration */
#define IommuType_T PRUint32


/* Start of enum VMExecutionEngine declaration */
#define VMEXECUTIONENGINE_IID_STR "69485f52-5cd3-40c9-946f-ae7d5c50798b"
#define VMEXECUTIONENGINE_IID { \
    0x69485f52, 0x5cd3, 0x40c9, \
    { 0x94, 0x6f, 0xae, 0x7d, 0x5c, 0x50, 0x79, 0x8b } \
}
typedef enum VMExecutionEngine
{
    VMExecutionEngine_NotSet = 0,
    VMExecutionEngine_Default = 1,
    VMExecutionEngine_HwVirt = 2,
    VMExecutionEngine_NativeApi = 3,
    VMExecutionEngine_Interpreter = 4,
    VMExecutionEngine_Recompiler = 5
} VMExecutionEngine;
/* End of enum VMExecutionEngine declaration */
#define VMExecutionEngine_T PRUint32


/* Start of enum HostNetworkInterfaceMediumType declaration */
#define HOSTNETWORKINTERFACEMEDIUMTYPE_IID_STR "1aa54aaf-2497-45a2-bfb1-8eb225e93d5b"
#define HOSTNETWORKINTERFACEMEDIUMTYPE_IID { \
    0x1aa54aaf, 0x2497, 0x45a2, \
    { 0xbf, 0xb1, 0x8e, 0xb2, 0x25, 0xe9, 0x3d, 0x5b } \
}
typedef enum HostNetworkInterfaceMediumType
{
    HostNetworkInterfaceMediumType_Unknown = 0,
    HostNetworkInterfaceMediumType_Ethernet = 1,
    HostNetworkInterfaceMediumType_PPP = 2,
    HostNetworkInterfaceMediumType_SLIP = 3
} HostNetworkInterfaceMediumType;
/* End of enum HostNetworkInterfaceMediumType declaration */
#define HostNetworkInterfaceMediumType_T PRUint32


/* Start of enum HostNetworkInterfaceStatus declaration */
#define HOSTNETWORKINTERFACESTATUS_IID_STR "CC474A69-2710-434B-8D99-C38E5D5A6F41"
#define HOSTNETWORKINTERFACESTATUS_IID { \
    0xCC474A69, 0x2710, 0x434B, \
    { 0x8D, 0x99, 0xC3, 0x8E, 0x5D, 0x5A, 0x6F, 0x41 } \
}
typedef enum HostNetworkInterfaceStatus
{
    HostNetworkInterfaceStatus_Unknown = 0,
    HostNetworkInterfaceStatus_Up = 1,
    HostNetworkInterfaceStatus_Down = 2
} HostNetworkInterfaceStatus;
/* End of enum HostNetworkInterfaceStatus declaration */
#define HostNetworkInterfaceStatus_T PRUint32


/* Start of enum HostNetworkInterfaceType declaration */
#define HOSTNETWORKINTERFACETYPE_IID_STR "67431b00-9946-48a2-bc02-b25c5919f4f3"
#define HOSTNETWORKINTERFACETYPE_IID { \
    0x67431b00, 0x9946, 0x48a2, \
    { 0xbc, 0x02, 0xb2, 0x5c, 0x59, 0x19, 0xf4, 0xf3 } \
}
typedef enum HostNetworkInterfaceType
{
    HostNetworkInterfaceType_Bridged = 1,
    HostNetworkInterfaceType_HostOnly = 2
} HostNetworkInterfaceType;
/* End of enum HostNetworkInterfaceType declaration */
#define HostNetworkInterfaceType_T PRUint32


/* Start of enum UpdateChannel declaration */
#define UPDATECHANNEL_IID_STR "9f1562a5-e47a-496b-a818-66776f06ce40"
#define UPDATECHANNEL_IID { \
    0x9f1562a5, 0xe47a, 0x496b, \
    { 0xa8, 0x18, 0x66, 0x77, 0x6f, 0x06, 0xce, 0x40 } \
}
typedef enum UpdateChannel
{
    UpdateChannel_Invalid = 0,
    UpdateChannel_Stable = 1,
    UpdateChannel_All = 2,
    UpdateChannel_WithBetas = 3,
    UpdateChannel_WithTesting = 4
} UpdateChannel;
/* End of enum UpdateChannel declaration */
#define UpdateChannel_T PRUint32


/* Start of enum UpdateSeverity declaration */
#define UPDATESEVERITY_IID_STR "359a5fee-8a06-4306-8068-2f2dd5cde06f"
#define UPDATESEVERITY_IID { \
    0x359a5fee, 0x8a06, 0x4306, \
    { 0x80, 0x68, 0x2f, 0x2d, 0xd5, 0xcd, 0xe0, 0x6f } \
}
typedef enum UpdateSeverity
{
    UpdateSeverity_Invalid = 0,
    UpdateSeverity_Critical = 1,
    UpdateSeverity_Major = 2,
    UpdateSeverity_Minor = 3,
    UpdateSeverity_Testing = 4
} UpdateSeverity;
/* End of enum UpdateSeverity declaration */
#define UpdateSeverity_T PRUint32


/* Start of enum UpdateState declaration */
#define UPDATESTATE_IID_STR "6623e363-c892-45f8-80cb-4e8ffd9b4e60"
#define UPDATESTATE_IID { \
    0x6623e363, 0xc892, 0x45f8, \
    { 0x80, 0xcb, 0x4e, 0x8f, 0xfd, 0x9b, 0x4e, 0x60 } \
}
typedef enum UpdateState
{
    UpdateState_Invalid = 0,
    UpdateState_Available = 1,
    UpdateState_NotAvailable = 2,
    UpdateState_Downloading = 3,
    UpdateState_Downloaded = 4,
    UpdateState_Installing = 5,
    UpdateState_Installed = 6,
    UpdateState_UserInteraction = 7,
    UpdateState_Canceled = 8,
    UpdateState_Maintenance = 9,
    UpdateState_Error = 10
} UpdateState;
/* End of enum UpdateState declaration */
#define UpdateState_T PRUint32


/* Start of enum ProxyMode declaration */
#define PROXYMODE_IID_STR "885264b3-b517-40fc-ce46-36e3bae895a4"
#define PROXYMODE_IID { \
    0x885264b3, 0xb517, 0x40fc, \
    { 0xce, 0x46, 0x36, 0xe3, 0xba, 0xe8, 0x95, 0xa4 } \
}
typedef enum ProxyMode
{
    ProxyMode_System = 0,
    ProxyMode_NoProxy = 1,
    ProxyMode_Manual = 2
} ProxyMode;
/* End of enum ProxyMode declaration */
#define ProxyMode_T PRUint32


/* Start of enum AdditionsFacilityType declaration */
#define ADDITIONSFACILITYTYPE_IID_STR "c4b10d74-dd48-4ff4-9a40-785a2a389ade"
#define ADDITIONSFACILITYTYPE_IID { \
    0xc4b10d74, 0xdd48, 0x4ff4, \
    { 0x9a, 0x40, 0x78, 0x5a, 0x2a, 0x38, 0x9a, 0xde } \
}
typedef enum AdditionsFacilityType
{
    AdditionsFacilityType_None = 0,
    AdditionsFacilityType_VBoxGuestDriver = 20,
    AdditionsFacilityType_AutoLogon = 90,
    AdditionsFacilityType_VBoxService = 100,
    AdditionsFacilityType_VBoxTrayClient = 101,
    AdditionsFacilityType_Seamless = 1000,
    AdditionsFacilityType_Graphics = 1100,
    AdditionsFacilityType_MonitorAttach = 1101,
    AdditionsFacilityType_All = 2147483646
} AdditionsFacilityType;
/* End of enum AdditionsFacilityType declaration */
#define AdditionsFacilityType_T PRUint32


/* Start of enum AdditionsFacilityClass declaration */
#define ADDITIONSFACILITYCLASS_IID_STR "446451b2-c88d-4e5d-84c9-91bc7f533f5f"
#define ADDITIONSFACILITYCLASS_IID { \
    0x446451b2, 0xc88d, 0x4e5d, \
    { 0x84, 0xc9, 0x91, 0xbc, 0x7f, 0x53, 0x3f, 0x5f } \
}
typedef enum AdditionsFacilityClass
{
    AdditionsFacilityClass_None = 0,
    AdditionsFacilityClass_Driver = 10,
    AdditionsFacilityClass_Service = 30,
    AdditionsFacilityClass_Program = 50,
    AdditionsFacilityClass_Feature = 100,
    AdditionsFacilityClass_ThirdParty = 999,
    AdditionsFacilityClass_All = 2147483646
} AdditionsFacilityClass;
/* End of enum AdditionsFacilityClass declaration */
#define AdditionsFacilityClass_T PRUint32


/* Start of enum AdditionsFacilityStatus declaration */
#define ADDITIONSFACILITYSTATUS_IID_STR "ce06f9e1-394e-4fe9-9368-5a88c567dbde"
#define ADDITIONSFACILITYSTATUS_IID { \
    0xce06f9e1, 0x394e, 0x4fe9, \
    { 0x93, 0x68, 0x5a, 0x88, 0xc5, 0x67, 0xdb, 0xde } \
}
typedef enum AdditionsFacilityStatus
{
    AdditionsFacilityStatus_Inactive = 0,
    AdditionsFacilityStatus_Paused = 1,
    AdditionsFacilityStatus_PreInit = 20,
    AdditionsFacilityStatus_Init = 30,
    AdditionsFacilityStatus_Active = 50,
    AdditionsFacilityStatus_Terminating = 100,
    AdditionsFacilityStatus_Terminated = 101,
    AdditionsFacilityStatus_Failed = 800,
    AdditionsFacilityStatus_Unknown = 999
} AdditionsFacilityStatus;
/* End of enum AdditionsFacilityStatus declaration */
#define AdditionsFacilityStatus_T PRUint32


/* Start of enum AdditionsRunLevelType declaration */
#define ADDITIONSRUNLEVELTYPE_IID_STR "a25417ee-a9dd-4f5b-b0dc-377860087754"
#define ADDITIONSRUNLEVELTYPE_IID { \
    0xa25417ee, 0xa9dd, 0x4f5b, \
    { 0xb0, 0xdc, 0x37, 0x78, 0x60, 0x08, 0x77, 0x54 } \
}
typedef enum AdditionsRunLevelType
{
    AdditionsRunLevelType_None = 0,
    AdditionsRunLevelType_System = 1,
    AdditionsRunLevelType_Userland = 2,
    AdditionsRunLevelType_Desktop = 3
} AdditionsRunLevelType;
/* End of enum AdditionsRunLevelType declaration */
#define AdditionsRunLevelType_T PRUint32


/* Start of enum AdditionsUpdateFlag declaration */
#define ADDITIONSUPDATEFLAG_IID_STR "726a818d-18d6-4389-94e8-3e9e6826171a"
#define ADDITIONSUPDATEFLAG_IID { \
    0x726a818d, 0x18d6, 0x4389, \
    { 0x94, 0xe8, 0x3e, 0x9e, 0x68, 0x26, 0x17, 0x1a } \
}
typedef enum AdditionsUpdateFlag
{
    AdditionsUpdateFlag_None = 0,
    AdditionsUpdateFlag_WaitForUpdateStartOnly = 1
} AdditionsUpdateFlag;
/* End of enum AdditionsUpdateFlag declaration */
#define AdditionsUpdateFlag_T PRUint32


/* Start of enum GuestShutdownFlag declaration */
#define GUESTSHUTDOWNFLAG_IID_STR "28D19C9C-5862-4930-B29A-F117712B4864"
#define GUESTSHUTDOWNFLAG_IID { \
    0x28D19C9C, 0x5862, 0x4930, \
    { 0xB2, 0x9A, 0xF1, 0x17, 0x71, 0x2B, 0x48, 0x64 } \
}
typedef enum GuestShutdownFlag
{
    GuestShutdownFlag_None = 0,
    GuestShutdownFlag_PowerOff = 1,
    GuestShutdownFlag_Reboot = 2,
    GuestShutdownFlag_Force = 4
} GuestShutdownFlag;
/* End of enum GuestShutdownFlag declaration */
#define GuestShutdownFlag_T PRUint32


/* Start of enum GuestSessionStatus declaration */
#define GUESTSESSIONSTATUS_IID_STR "ac2669da-4624-44f2-85b5-0b0bfb8d8673"
#define GUESTSESSIONSTATUS_IID { \
    0xac2669da, 0x4624, 0x44f2, \
    { 0x85, 0xb5, 0x0b, 0x0b, 0xfb, 0x8d, 0x86, 0x73 } \
}
typedef enum GuestSessionStatus
{
    GuestSessionStatus_Undefined = 0,
    GuestSessionStatus_Starting = 10,
    GuestSessionStatus_Started = 100,
    GuestSessionStatus_Terminating = 480,
    GuestSessionStatus_Terminated = 500,
    GuestSessionStatus_TimedOutKilled = 512,
    GuestSessionStatus_TimedOutAbnormally = 513,
    GuestSessionStatus_Down = 600,
    GuestSessionStatus_Error = 800
} GuestSessionStatus;
/* End of enum GuestSessionStatus declaration */
#define GuestSessionStatus_T PRUint32


/* Start of enum GuestSessionWaitForFlag declaration */
#define GUESTSESSIONWAITFORFLAG_IID_STR "bb7a372a-f635-4e11-a81a-e707f3a52ef5"
#define GUESTSESSIONWAITFORFLAG_IID { \
    0xbb7a372a, 0xf635, 0x4e11, \
    { 0xa8, 0x1a, 0xe7, 0x07, 0xf3, 0xa5, 0x2e, 0xf5 } \
}
typedef enum GuestSessionWaitForFlag
{
    GuestSessionWaitForFlag_None = 0,
    GuestSessionWaitForFlag_Start = 1,
    GuestSessionWaitForFlag_Terminate = 2,
    GuestSessionWaitForFlag_Status = 4
} GuestSessionWaitForFlag;
/* End of enum GuestSessionWaitForFlag declaration */
#define GuestSessionWaitForFlag_T PRUint32


/* Start of enum GuestSessionWaitResult declaration */
#define GUESTSESSIONWAITRESULT_IID_STR "c0f6a8a5-fdb6-42bf-a582-56c6f82bcd2d"
#define GUESTSESSIONWAITRESULT_IID { \
    0xc0f6a8a5, 0xfdb6, 0x42bf, \
    { 0xa5, 0x82, 0x56, 0xc6, 0xf8, 0x2b, 0xcd, 0x2d } \
}
typedef enum GuestSessionWaitResult
{
    GuestSessionWaitResult_None = 0,
    GuestSessionWaitResult_Start = 1,
    GuestSessionWaitResult_Terminate = 2,
    GuestSessionWaitResult_Status = 3,
    GuestSessionWaitResult_Error = 4,
    GuestSessionWaitResult_Timeout = 5,
    GuestSessionWaitResult_WaitFlagNotSupported = 6
} GuestSessionWaitResult;
/* End of enum GuestSessionWaitResult declaration */
#define GuestSessionWaitResult_T PRUint32


/* Start of enum GuestUserState declaration */
#define GUESTUSERSTATE_IID_STR "b2a82b02-fd3d-4fc2-ba84-6ba5ac8be198"
#define GUESTUSERSTATE_IID { \
    0xb2a82b02, 0xfd3d, 0x4fc2, \
    { 0xba, 0x84, 0x6b, 0xa5, 0xac, 0x8b, 0xe1, 0x98 } \
}
typedef enum GuestUserState
{
    GuestUserState_Unknown = 0,
    GuestUserState_LoggedIn = 1,
    GuestUserState_LoggedOut = 2,
    GuestUserState_Locked = 3,
    GuestUserState_Unlocked = 4,
    GuestUserState_Disabled = 5,
    GuestUserState_Idle = 6,
    GuestUserState_InUse = 7,
    GuestUserState_Created = 8,
    GuestUserState_Deleted = 9,
    GuestUserState_SessionChanged = 10,
    GuestUserState_CredentialsChanged = 11,
    GuestUserState_RoleChanged = 12,
    GuestUserState_GroupAdded = 13,
    GuestUserState_GroupRemoved = 14,
    GuestUserState_Elevated = 15
} GuestUserState;
/* End of enum GuestUserState declaration */
#define GuestUserState_T PRUint32


/* Start of enum FileSeekOrigin declaration */
#define FILESEEKORIGIN_IID_STR "ad32f789-4279-4530-979c-f16892e1c263"
#define FILESEEKORIGIN_IID { \
    0xad32f789, 0x4279, 0x4530, \
    { 0x97, 0x9c, 0xf1, 0x68, 0x92, 0xe1, 0xc2, 0x63 } \
}
typedef enum FileSeekOrigin
{
    FileSeekOrigin_Begin = 0,
    FileSeekOrigin_Current = 1,
    FileSeekOrigin_End = 2
} FileSeekOrigin;
/* End of enum FileSeekOrigin declaration */
#define FileSeekOrigin_T PRUint32


/* Start of enum ProcessInputFlag declaration */
#define PROCESSINPUTFLAG_IID_STR "5d38c1dd-2604-4ddf-92e5-0c0cdd3bdbd5"
#define PROCESSINPUTFLAG_IID { \
    0x5d38c1dd, 0x2604, 0x4ddf, \
    { 0x92, 0xe5, 0x0c, 0x0c, 0xdd, 0x3b, 0xdb, 0xd5 } \
}
typedef enum ProcessInputFlag
{
    ProcessInputFlag_None = 0,
    ProcessInputFlag_EndOfFile = 1
} ProcessInputFlag;
/* End of enum ProcessInputFlag declaration */
#define ProcessInputFlag_T PRUint32


/* Start of enum ProcessOutputFlag declaration */
#define PROCESSOUTPUTFLAG_IID_STR "9979e85a-52bb-40b7-870c-57115e27e0f1"
#define PROCESSOUTPUTFLAG_IID { \
    0x9979e85a, 0x52bb, 0x40b7, \
    { 0x87, 0x0c, 0x57, 0x11, 0x5e, 0x27, 0xe0, 0xf1 } \
}
typedef enum ProcessOutputFlag
{
    ProcessOutputFlag_None = 0,
    ProcessOutputFlag_StdErr = 1
} ProcessOutputFlag;
/* End of enum ProcessOutputFlag declaration */
#define ProcessOutputFlag_T PRUint32


/* Start of enum ProcessWaitForFlag declaration */
#define PROCESSWAITFORFLAG_IID_STR "23b550c7-78e1-437e-98f0-65fd9757bcd2"
#define PROCESSWAITFORFLAG_IID { \
    0x23b550c7, 0x78e1, 0x437e, \
    { 0x98, 0xf0, 0x65, 0xfd, 0x97, 0x57, 0xbc, 0xd2 } \
}
typedef enum ProcessWaitForFlag
{
    ProcessWaitForFlag_None = 0,
    ProcessWaitForFlag_Start = 1,
    ProcessWaitForFlag_Terminate = 2,
    ProcessWaitForFlag_StdIn = 4,
    ProcessWaitForFlag_StdOut = 8,
    ProcessWaitForFlag_StdErr = 16
} ProcessWaitForFlag;
/* End of enum ProcessWaitForFlag declaration */
#define ProcessWaitForFlag_T PRUint32


/* Start of enum ProcessWaitResult declaration */
#define PROCESSWAITRESULT_IID_STR "40719cbe-f192-4fe9-a231-6697b3c8e2b4"
#define PROCESSWAITRESULT_IID { \
    0x40719cbe, 0xf192, 0x4fe9, \
    { 0xa2, 0x31, 0x66, 0x97, 0xb3, 0xc8, 0xe2, 0xb4 } \
}
typedef enum ProcessWaitResult
{
    ProcessWaitResult_None = 0,
    ProcessWaitResult_Start = 1,
    ProcessWaitResult_Terminate = 2,
    ProcessWaitResult_Status = 3,
    ProcessWaitResult_Error = 4,
    ProcessWaitResult_Timeout = 5,
    ProcessWaitResult_StdIn = 6,
    ProcessWaitResult_StdOut = 7,
    ProcessWaitResult_StdErr = 8,
    ProcessWaitResult_WaitFlagNotSupported = 9
} ProcessWaitResult;
/* End of enum ProcessWaitResult declaration */
#define ProcessWaitResult_T PRUint32


/* Start of enum FileCopyFlag declaration */
#define FILECOPYFLAG_IID_STR "791909d7-4c64-2fa4-4303-adb10658d347"
#define FILECOPYFLAG_IID { \
    0x791909d7, 0x4c64, 0x2fa4, \
    { 0x43, 0x03, 0xad, 0xb1, 0x06, 0x58, 0xd3, 0x47 } \
}
typedef enum FileCopyFlag
{
    FileCopyFlag_None = 0,
    FileCopyFlag_NoReplace = 1,
    FileCopyFlag_FollowLinks = 2,
    FileCopyFlag_Update = 4
} FileCopyFlag;
/* End of enum FileCopyFlag declaration */
#define FileCopyFlag_T PRUint32


/* Start of enum FsObjMoveFlag declaration */
#define FSOBJMOVEFLAG_IID_STR "2450a05d-80c6-4c96-9a17-94d73293ff86"
#define FSOBJMOVEFLAG_IID { \
    0x2450a05d, 0x80c6, 0x4c96, \
    { 0x9a, 0x17, 0x94, 0xd7, 0x32, 0x93, 0xff, 0x86 } \
}
typedef enum FsObjMoveFlag
{
    FsObjMoveFlag_None = 0,
    FsObjMoveFlag_Replace = 1,
    FsObjMoveFlag_FollowLinks = 2,
    FsObjMoveFlag_AllowDirectoryMoves = 4
} FsObjMoveFlag;
/* End of enum FsObjMoveFlag declaration */
#define FsObjMoveFlag_T PRUint32


/* Start of enum DirectoryCreateFlag declaration */
#define DIRECTORYCREATEFLAG_IID_STR "bd721b0e-ced5-4f79-b368-249897c32a36"
#define DIRECTORYCREATEFLAG_IID { \
    0xbd721b0e, 0xced5, 0x4f79, \
    { 0xb3, 0x68, 0x24, 0x98, 0x97, 0xc3, 0x2a, 0x36 } \
}
typedef enum DirectoryCreateFlag
{
    DirectoryCreateFlag_None = 0,
    DirectoryCreateFlag_Parents = 1
} DirectoryCreateFlag;
/* End of enum DirectoryCreateFlag declaration */
#define DirectoryCreateFlag_T PRUint32


/* Start of enum DirectoryCopyFlag declaration */
#define DIRECTORYCOPYFLAG_IID_STR "20108C67-B1EB-4EF6-869B-25539A47A18E"
#define DIRECTORYCOPYFLAG_IID { \
    0x20108C67, 0xB1EB, 0x4EF6, \
    { 0x86, 0x9B, 0x25, 0x53, 0x9A, 0x47, 0xA1, 0x8E } \
}
typedef enum DirectoryCopyFlag
{
    DirectoryCopyFlag_None = 0,
    DirectoryCopyFlag_CopyIntoExisting = 1,
    DirectoryCopyFlag_Recursive = 2,
    DirectoryCopyFlag_FollowLinks = 4
} DirectoryCopyFlag;
/* End of enum DirectoryCopyFlag declaration */
#define DirectoryCopyFlag_T PRUint32


/* Start of enum DirectoryRemoveRecFlag declaration */
#define DIRECTORYREMOVERECFLAG_IID_STR "455aabf0-7692-48f6-9061-f21579b65769"
#define DIRECTORYREMOVERECFLAG_IID { \
    0x455aabf0, 0x7692, 0x48f6, \
    { 0x90, 0x61, 0xf2, 0x15, 0x79, 0xb6, 0x57, 0x69 } \
}
typedef enum DirectoryRemoveRecFlag
{
    DirectoryRemoveRecFlag_None = 0,
    DirectoryRemoveRecFlag_ContentAndDir = 1,
    DirectoryRemoveRecFlag_ContentOnly = 2
} DirectoryRemoveRecFlag;
/* End of enum DirectoryRemoveRecFlag declaration */
#define DirectoryRemoveRecFlag_T PRUint32


/* Start of enum FsObjRenameFlag declaration */
#define FSOBJRENAMEFLAG_IID_STR "59bbf3a1-4e23-d7cf-05d5-ccae32080ed2"
#define FSOBJRENAMEFLAG_IID { \
    0x59bbf3a1, 0x4e23, 0xd7cf, \
    { 0x05, 0xd5, 0xcc, 0xae, 0x32, 0x08, 0x0e, 0xd2 } \
}
typedef enum FsObjRenameFlag
{
    FsObjRenameFlag_NoReplace = 0,
    FsObjRenameFlag_Replace = 1
} FsObjRenameFlag;
/* End of enum FsObjRenameFlag declaration */
#define FsObjRenameFlag_T PRUint32


/* Start of enum ProcessCreateFlag declaration */
#define PROCESSCREATEFLAG_IID_STR "C544CD2B-F02D-4886-9901-71C523DB8DC5"
#define PROCESSCREATEFLAG_IID { \
    0xC544CD2B, 0xF02D, 0x4886, \
    { 0x99, 0x01, 0x71, 0xC5, 0x23, 0xDB, 0x8D, 0xC5 } \
}
typedef enum ProcessCreateFlag
{
    ProcessCreateFlag_None = 0,
    ProcessCreateFlag_WaitForProcessStartOnly = 1,
    ProcessCreateFlag_IgnoreOrphanedProcesses = 2,
    ProcessCreateFlag_Hidden = 4,
    ProcessCreateFlag_Profile = 8,
    ProcessCreateFlag_WaitForStdOut = 16,
    ProcessCreateFlag_WaitForStdErr = 32,
    ProcessCreateFlag_ExpandArguments = 64,
    ProcessCreateFlag_UnquotedArguments = 128
} ProcessCreateFlag;
/* End of enum ProcessCreateFlag declaration */
#define ProcessCreateFlag_T PRUint32


/* Start of enum ProcessPriority declaration */
#define PROCESSPRIORITY_IID_STR "ee8cac50-e232-49fe-806b-d1214d9c2e49"
#define PROCESSPRIORITY_IID { \
    0xee8cac50, 0xe232, 0x49fe, \
    { 0x80, 0x6b, 0xd1, 0x21, 0x4d, 0x9c, 0x2e, 0x49 } \
}
typedef enum ProcessPriority
{
    ProcessPriority_Invalid = 0,
    ProcessPriority_Default = 1
} ProcessPriority;
/* End of enum ProcessPriority declaration */
#define ProcessPriority_T PRUint32


/* Start of enum SymlinkType declaration */
#define SYMLINKTYPE_IID_STR "37794668-f8f1-4714-98a5-6f8fa2ed0118"
#define SYMLINKTYPE_IID { \
    0x37794668, 0xf8f1, 0x4714, \
    { 0x98, 0xa5, 0x6f, 0x8f, 0xa2, 0xed, 0x01, 0x18 } \
}
typedef enum SymlinkType
{
    SymlinkType_Unknown = 0,
    SymlinkType_Directory = 1,
    SymlinkType_File = 2
} SymlinkType;
/* End of enum SymlinkType declaration */
#define SymlinkType_T PRUint32


/* Start of enum SymlinkReadFlag declaration */
#define SYMLINKREADFLAG_IID_STR "b7fe2b9d-790e-4b25-8adf-1ca33026931f"
#define SYMLINKREADFLAG_IID { \
    0xb7fe2b9d, 0x790e, 0x4b25, \
    { 0x8a, 0xdf, 0x1c, 0xa3, 0x30, 0x26, 0x93, 0x1f } \
}
typedef enum SymlinkReadFlag
{
    SymlinkReadFlag_None = 0,
    SymlinkReadFlag_NoSymlinks = 1
} SymlinkReadFlag;
/* End of enum SymlinkReadFlag declaration */
#define SymlinkReadFlag_T PRUint32


/* Start of enum ProcessStatus declaration */
#define PROCESSSTATUS_IID_STR "4d52368f-5b48-4bfe-b486-acf89139b52f"
#define PROCESSSTATUS_IID { \
    0x4d52368f, 0x5b48, 0x4bfe, \
    { 0xb4, 0x86, 0xac, 0xf8, 0x91, 0x39, 0xb5, 0x2f } \
}
typedef enum ProcessStatus
{
    ProcessStatus_Undefined = 0,
    ProcessStatus_Starting = 10,
    ProcessStatus_Started = 100,
    ProcessStatus_Paused = 110,
    ProcessStatus_Terminating = 480,
    ProcessStatus_TerminatedNormally = 500,
    ProcessStatus_TerminatedSignal = 510,
    ProcessStatus_TerminatedAbnormally = 511,
    ProcessStatus_TimedOutKilled = 512,
    ProcessStatus_TimedOutAbnormally = 513,
    ProcessStatus_Down = 600,
    ProcessStatus_Error = 800
} ProcessStatus;
/* End of enum ProcessStatus declaration */
#define ProcessStatus_T PRUint32


/* Start of enum ProcessInputStatus declaration */
#define PROCESSINPUTSTATUS_IID_STR "a4a0ef9c-29cc-4805-9803-c8215ae9da6c"
#define PROCESSINPUTSTATUS_IID { \
    0xa4a0ef9c, 0x29cc, 0x4805, \
    { 0x98, 0x03, 0xc8, 0x21, 0x5a, 0xe9, 0xda, 0x6c } \
}
typedef enum ProcessInputStatus
{
    ProcessInputStatus_Undefined = 0,
    ProcessInputStatus_Broken = 1,
    ProcessInputStatus_Available = 10,
    ProcessInputStatus_Written = 50,
    ProcessInputStatus_Overflow = 100
} ProcessInputStatus;
/* End of enum ProcessInputStatus declaration */
#define ProcessInputStatus_T PRUint32


/* Start of enum PathStyle declaration */
#define PATHSTYLE_IID_STR "97303a5b-42e8-0a55-d16f-d2a92c295261"
#define PATHSTYLE_IID { \
    0x97303a5b, 0x42e8, 0x0a55, \
    { 0xd1, 0x6f, 0xd2, 0xa9, 0x2c, 0x29, 0x52, 0x61 } \
}
typedef enum PathStyle
{
    PathStyle_DOS = 1,
    PathStyle_UNIX = 2,
    PathStyle_Unknown = 8
} PathStyle;
/* End of enum PathStyle declaration */
#define PathStyle_T PRUint32


/* Start of enum DirectoryStatus declaration */
#define DIRECTORYSTATUS_IID_STR "a50ca1fc-85a9-4a7a-b755-68c3db01caf1"
#define DIRECTORYSTATUS_IID { \
    0xa50ca1fc, 0x85a9, 0x4a7a, \
    { 0xb7, 0x55, 0x68, 0xc3, 0xdb, 0x01, 0xca, 0xf1 } \
}
typedef enum DirectoryStatus
{
    DirectoryStatus_Undefined = 0,
    DirectoryStatus_Open = 1,
    DirectoryStatus_Close = 2,
    DirectoryStatus_Rewind = 3,
    DirectoryStatus_Down = 4,
    DirectoryStatus_Error = 5
} DirectoryStatus;
/* End of enum DirectoryStatus declaration */
#define DirectoryStatus_T PRUint32


/* Start of enum FileAccessMode declaration */
#define FILEACCESSMODE_IID_STR "231a578f-47fb-ea30-3b3e-8489558227f0"
#define FILEACCESSMODE_IID { \
    0x231a578f, 0x47fb, 0xea30, \
    { 0x3b, 0x3e, 0x84, 0x89, 0x55, 0x82, 0x27, 0xf0 } \
}
typedef enum FileAccessMode
{
    FileAccessMode_ReadOnly = 1,
    FileAccessMode_WriteOnly = 2,
    FileAccessMode_ReadWrite = 3,
    FileAccessMode_AppendOnly = 4,
    FileAccessMode_AppendRead = 5
} FileAccessMode;
/* End of enum FileAccessMode declaration */
#define FileAccessMode_T PRUint32


/* Start of enum FileOpenAction declaration */
#define FILEOPENACTION_IID_STR "12bc97e2-4fc6-a8b4-4f84-0cbf4ab970d2"
#define FILEOPENACTION_IID { \
    0x12bc97e2, 0x4fc6, 0xa8b4, \
    { 0x4f, 0x84, 0x0c, 0xbf, 0x4a, 0xb9, 0x70, 0xd2 } \
}
typedef enum FileOpenAction
{
    FileOpenAction_OpenExisting = 1,
    FileOpenAction_OpenOrCreate = 2,
    FileOpenAction_CreateNew = 3,
    FileOpenAction_CreateOrReplace = 4,
    FileOpenAction_OpenExistingTruncated = 5,
    FileOpenAction_AppendOrCreate = 99
} FileOpenAction;
/* End of enum FileOpenAction declaration */
#define FileOpenAction_T PRUint32


/* Start of enum FileSharingMode declaration */
#define FILESHARINGMODE_IID_STR "f87dfe58-425b-c5ba-7d6d-22adeea25de1"
#define FILESHARINGMODE_IID { \
    0xf87dfe58, 0x425b, 0xc5ba, \
    { 0x7d, 0x6d, 0x22, 0xad, 0xee, 0xa2, 0x5d, 0xe1 } \
}
typedef enum FileSharingMode
{
    FileSharingMode_Read = 1,
    FileSharingMode_Write = 2,
    FileSharingMode_ReadWrite = 3,
    FileSharingMode_Delete = 4,
    FileSharingMode_ReadDelete = 5,
    FileSharingMode_WriteDelete = 6,
    FileSharingMode_All = 7
} FileSharingMode;
/* End of enum FileSharingMode declaration */
#define FileSharingMode_T PRUint32


/* Start of enum FileOpenExFlag declaration */
#define FILEOPENEXFLAG_IID_STR "4671abd4-f70c-42aa-8542-6c169cb87a5c"
#define FILEOPENEXFLAG_IID { \
    0x4671abd4, 0xf70c, 0x42aa, \
    { 0x85, 0x42, 0x6c, 0x16, 0x9c, 0xb8, 0x7a, 0x5c } \
}
typedef enum FileOpenExFlag
{
    FileOpenExFlag_None = 0
} FileOpenExFlag;
/* End of enum FileOpenExFlag declaration */
#define FileOpenExFlag_T PRUint32


/* Start of enum FileStatus declaration */
#define FILESTATUS_IID_STR "8c86468b-b97b-4080-8914-e29f5b0abd2c"
#define FILESTATUS_IID { \
    0x8c86468b, 0xb97b, 0x4080, \
    { 0x89, 0x14, 0xe2, 0x9f, 0x5b, 0x0a, 0xbd, 0x2c } \
}
typedef enum FileStatus
{
    FileStatus_Undefined = 0,
    FileStatus_Opening = 10,
    FileStatus_Open = 100,
    FileStatus_Closing = 150,
    FileStatus_Closed = 200,
    FileStatus_Down = 600,
    FileStatus_Error = 800
} FileStatus;
/* End of enum FileStatus declaration */
#define FileStatus_T PRUint32


/* Start of enum FsObjType declaration */
#define FSOBJTYPE_IID_STR "34a0d1aa-491e-e209-e150-84964d6cee5f"
#define FSOBJTYPE_IID { \
    0x34a0d1aa, 0x491e, 0xe209, \
    { 0xe1, 0x50, 0x84, 0x96, 0x4d, 0x6c, 0xee, 0x5f } \
}
typedef enum FsObjType
{
    FsObjType_Unknown = 1,
    FsObjType_Fifo = 2,
    FsObjType_DevChar = 3,
    FsObjType_Directory = 4,
    FsObjType_DevBlock = 5,
    FsObjType_File = 6,
    FsObjType_Symlink = 7,
    FsObjType_Socket = 8,
    FsObjType_WhiteOut = 9
} FsObjType;
/* End of enum FsObjType declaration */
#define FsObjType_T PRUint32


/* Start of enum DnDAction declaration */
#define DNDACTION_IID_STR "17609e74-778e-4d0e-8827-35f5230f287b"
#define DNDACTION_IID { \
    0x17609e74, 0x778e, 0x4d0e, \
    { 0x88, 0x27, 0x35, 0xf5, 0x23, 0x0f, 0x28, 0x7b } \
}
typedef enum DnDAction
{
    DnDAction_Ignore = 0,
    DnDAction_Copy = 1,
    DnDAction_Move = 2,
    DnDAction_Link = 3
} DnDAction;
/* End of enum DnDAction declaration */
#define DnDAction_T PRUint32


/* Start of enum DirectoryOpenFlag declaration */
#define DIRECTORYOPENFLAG_IID_STR "92f838f6-cbf9-4760-bb63-92c567773366"
#define DIRECTORYOPENFLAG_IID { \
    0x92f838f6, 0xcbf9, 0x4760, \
    { 0xbb, 0x63, 0x92, 0xc5, 0x67, 0x77, 0x33, 0x66 } \
}
typedef enum DirectoryOpenFlag
{
    DirectoryOpenFlag_None = 0,
    DirectoryOpenFlag_NoSymlinks = 1,
    DirectoryOpenFlag_DenyAscent = 2,
    DirectoryOpenFlag_NoFollowSymlinks = 4
} DirectoryOpenFlag;
/* End of enum DirectoryOpenFlag declaration */
#define DirectoryOpenFlag_T PRUint32


/* Start of enum MediumState declaration */
#define MEDIUMSTATE_IID_STR "ef41e980-e012-43cd-9dea-479d4ef14d13"
#define MEDIUMSTATE_IID { \
    0xef41e980, 0xe012, 0x43cd, \
    { 0x9d, 0xea, 0x47, 0x9d, 0x4e, 0xf1, 0x4d, 0x13 } \
}
typedef enum MediumState
{
    MediumState_NotCreated = 0,
    MediumState_Created = 1,
    MediumState_LockedRead = 2,
    MediumState_LockedWrite = 3,
    MediumState_Inaccessible = 4,
    MediumState_Creating = 5,
    MediumState_Deleting = 6
} MediumState;
/* End of enum MediumState declaration */
#define MediumState_T PRUint32


/* Start of enum MediumType declaration */
#define MEDIUMTYPE_IID_STR "fe663fb5-c244-4e1b-9d81-c628b417dd04"
#define MEDIUMTYPE_IID { \
    0xfe663fb5, 0xc244, 0x4e1b, \
    { 0x9d, 0x81, 0xc6, 0x28, 0xb4, 0x17, 0xdd, 0x04 } \
}
typedef enum MediumType
{
    MediumType_Normal = 0,
    MediumType_Immutable = 1,
    MediumType_Writethrough = 2,
    MediumType_Shareable = 3,
    MediumType_Readonly = 4,
    MediumType_MultiAttach = 5
} MediumType;
/* End of enum MediumType declaration */
#define MediumType_T PRUint32


/* Start of enum MediumVariant declaration */
#define MEDIUMVARIANT_IID_STR "0282e97f-4ef3-4411-a8e0-47c384803cb6"
#define MEDIUMVARIANT_IID { \
    0x0282e97f, 0x4ef3, 0x4411, \
    { 0xa8, 0xe0, 0x47, 0xc3, 0x84, 0x80, 0x3c, 0xb6 } \
}
typedef enum MediumVariant
{
    MediumVariant_Standard = 0,
    MediumVariant_VmdkSplit2G = 0x01,
    MediumVariant_VmdkRawDisk = 0x02,
    MediumVariant_VmdkStreamOptimized = 0x04,
    MediumVariant_VmdkESX = 0x08,
    MediumVariant_VdiZeroExpand = 0x100,
    MediumVariant_Fixed = 0x10000,
    MediumVariant_Diff = 0x20000,
    MediumVariant_Formatted = 0x20000000,
    MediumVariant_NoCreateDir = 0x40000000
} MediumVariant;
/* End of enum MediumVariant declaration */
#define MediumVariant_T PRUint32


/* Start of enum DataType declaration */
#define DATATYPE_IID_STR "d90ea51e-a3f1-4a01-beb1-c1723c0d3ba7"
#define DATATYPE_IID { \
    0xd90ea51e, 0xa3f1, 0x4a01, \
    { 0xbe, 0xb1, 0xc1, 0x72, 0x3c, 0x0d, 0x3b, 0xa7 } \
}
typedef enum DataType
{
    DataType_Int32 = 0,
    DataType_Int8 = 1,
    DataType_String = 2
} DataType;
/* End of enum DataType declaration */
#define DataType_T PRUint32


/* Start of enum DataFlags declaration */
#define DATAFLAGS_IID_STR "86884dcf-1d6b-4f1b-b4bf-f5aa44959d60"
#define DATAFLAGS_IID { \
    0x86884dcf, 0x1d6b, 0x4f1b, \
    { 0xb4, 0xbf, 0xf5, 0xaa, 0x44, 0x95, 0x9d, 0x60 } \
}
typedef enum DataFlags
{
    DataFlags_None = 0x00,
    DataFlags_Mandatory = 0x01,
    DataFlags_Expert = 0x02,
    DataFlags_Array = 0x04,
    DataFlags_FlagMask = 0x07
} DataFlags;
/* End of enum DataFlags declaration */
#define DataFlags_T PRUint32


/* Start of enum MediumFormatCapabilities declaration */
#define MEDIUMFORMATCAPABILITIES_IID_STR "7342ba79-7ce0-4d94-8f86-5ed5a185d9bd"
#define MEDIUMFORMATCAPABILITIES_IID { \
    0x7342ba79, 0x7ce0, 0x4d94, \
    { 0x8f, 0x86, 0x5e, 0xd5, 0xa1, 0x85, 0xd9, 0xbd } \
}
typedef enum MediumFormatCapabilities
{
    MediumFormatCapabilities_Uuid = 0x01,
    MediumFormatCapabilities_CreateFixed = 0x02,
    MediumFormatCapabilities_CreateDynamic = 0x04,
    MediumFormatCapabilities_CreateSplit2G = 0x08,
    MediumFormatCapabilities_Differencing = 0x10,
    MediumFormatCapabilities_Asynchronous = 0x20,
    MediumFormatCapabilities_File = 0x40,
    MediumFormatCapabilities_Properties = 0x80,
    MediumFormatCapabilities_TcpNetworking = 0x100,
    MediumFormatCapabilities_VFS = 0x200,
    MediumFormatCapabilities_Discard = 0x400,
    MediumFormatCapabilities_Preferred = 0x800,
    MediumFormatCapabilities_CapabilityMask = 0xFFF
} MediumFormatCapabilities;
/* End of enum MediumFormatCapabilities declaration */
#define MediumFormatCapabilities_T PRUint32


/* Start of enum PartitionTableType declaration */
#define PARTITIONTABLETYPE_IID_STR "360066eb-d19e-4fa1-57ef-fed434fbe2a9"
#define PARTITIONTABLETYPE_IID { \
    0x360066eb, 0xd19e, 0x4fa1, \
    { 0x57, 0xef, 0xfe, 0xd4, 0x34, 0xfb, 0xe2, 0xa9 } \
}
typedef enum PartitionTableType
{
    PartitionTableType_MBR = 1,
    PartitionTableType_GPT = 2
} PartitionTableType;
/* End of enum PartitionTableType declaration */
#define PartitionTableType_T PRUint32


/* Start of enum KeyboardLED declaration */
#define KEYBOARDLED_IID_STR "ef29ea38-409b-49c7-a817-c858d426dfba"
#define KEYBOARDLED_IID { \
    0xef29ea38, 0x409b, 0x49c7, \
    { 0xa8, 0x17, 0xc8, 0x58, 0xd4, 0x26, 0xdf, 0xba } \
}
typedef enum KeyboardLED
{
    KeyboardLED_NumLock = 0x01,
    KeyboardLED_CapsLock = 0x02,
    KeyboardLED_ScrollLock = 0x04
} KeyboardLED;
/* End of enum KeyboardLED declaration */
#define KeyboardLED_T PRUint32


/* Start of enum MouseButtonState declaration */
#define MOUSEBUTTONSTATE_IID_STR "9ee094b8-b28a-4d56-a166-973cb588d7f8"
#define MOUSEBUTTONSTATE_IID { \
    0x9ee094b8, 0xb28a, 0x4d56, \
    { 0xa1, 0x66, 0x97, 0x3c, 0xb5, 0x88, 0xd7, 0xf8 } \
}
typedef enum MouseButtonState
{
    MouseButtonState_LeftButton = 0x01,
    MouseButtonState_RightButton = 0x02,
    MouseButtonState_MiddleButton = 0x04,
    MouseButtonState_WheelUp = 0x08,
    MouseButtonState_WheelDown = 0x10,
    MouseButtonState_XButton1 = 0x20,
    MouseButtonState_XButton2 = 0x40,
    MouseButtonState_MouseStateMask = 0x7F
} MouseButtonState;
/* End of enum MouseButtonState declaration */
#define MouseButtonState_T PRUint32


/* Start of enum TouchContactState declaration */
#define TOUCHCONTACTSTATE_IID_STR "3f942686-2506-421c-927c-90d4b45f4a38"
#define TOUCHCONTACTSTATE_IID { \
    0x3f942686, 0x2506, 0x421c, \
    { 0x92, 0x7c, 0x90, 0xd4, 0xb4, 0x5f, 0x4a, 0x38 } \
}
typedef enum TouchContactState
{
    TouchContactState_None = 0x00,
    TouchContactState_InContact = 0x01,
    TouchContactState_InRange = 0x02,
    TouchContactState_ContactStateMask = 0x03
} TouchContactState;
/* End of enum TouchContactState declaration */
#define TouchContactState_T PRUint32


/* Start of enum FramebufferCapabilities declaration */
#define FRAMEBUFFERCAPABILITIES_IID_STR "cc395839-30fa-4ca5-ae65-e6360e3edd7a"
#define FRAMEBUFFERCAPABILITIES_IID { \
    0xcc395839, 0x30fa, 0x4ca5, \
    { 0xae, 0x65, 0xe6, 0x36, 0x0e, 0x3e, 0xdd, 0x7a } \
}
typedef enum FramebufferCapabilities
{
    FramebufferCapabilities_UpdateImage = 0x01,
    FramebufferCapabilities_VHWA = 0x02,
    FramebufferCapabilities_VisibleRegion = 0x04,
    FramebufferCapabilities_RenderCursor = 0x08,
    FramebufferCapabilities_MoveCursor = 0x10
} FramebufferCapabilities;
/* End of enum FramebufferCapabilities declaration */
#define FramebufferCapabilities_T PRUint32


/* Start of enum GuestMonitorStatus declaration */
#define GUESTMONITORSTATUS_IID_STR "6b8d3f71-39cb-459e-a916-48917ed43e19"
#define GUESTMONITORSTATUS_IID { \
    0x6b8d3f71, 0x39cb, 0x459e, \
    { 0xa9, 0x16, 0x48, 0x91, 0x7e, 0xd4, 0x3e, 0x19 } \
}
typedef enum GuestMonitorStatus
{
    GuestMonitorStatus_Disabled = 0,
    GuestMonitorStatus_Enabled = 1,
    GuestMonitorStatus_Blank = 2
} GuestMonitorStatus;
/* End of enum GuestMonitorStatus declaration */
#define GuestMonitorStatus_T PRUint32


/* Start of enum ScreenLayoutMode declaration */
#define SCREENLAYOUTMODE_IID_STR "8fa1964c-8774-11e9-ae5d-1f419105e68d"
#define SCREENLAYOUTMODE_IID { \
    0x8fa1964c, 0x8774, 0x11e9, \
    { 0xae, 0x5d, 0x1f, 0x41, 0x91, 0x05, 0xe6, 0x8d } \
}
typedef enum ScreenLayoutMode
{
    ScreenLayoutMode_Apply = 0,
    ScreenLayoutMode_Reset = 1,
    ScreenLayoutMode_Attach = 2,
    ScreenLayoutMode_Silent = 3
} ScreenLayoutMode;
/* End of enum ScreenLayoutMode declaration */
#define ScreenLayoutMode_T PRUint32


/* Start of enum NetworkAttachmentType declaration */
#define NETWORKATTACHMENTTYPE_IID_STR "cbfd17fa-fdc3-4d1c-97ec-4674da8d2a5d"
#define NETWORKATTACHMENTTYPE_IID { \
    0xcbfd17fa, 0xfdc3, 0x4d1c, \
    { 0x97, 0xec, 0x46, 0x74, 0xda, 0x8d, 0x2a, 0x5d } \
}
typedef enum NetworkAttachmentType
{
    NetworkAttachmentType_Null = 0,
    NetworkAttachmentType_NAT = 1,
    NetworkAttachmentType_Bridged = 2,
    NetworkAttachmentType_Internal = 3,
    NetworkAttachmentType_HostOnly = 4,
    NetworkAttachmentType_Generic = 5,
    NetworkAttachmentType_NATNetwork = 6,
    NetworkAttachmentType_Cloud = 7,
    NetworkAttachmentType_HostOnlyNetwork = 8
} NetworkAttachmentType;
/* End of enum NetworkAttachmentType declaration */
#define NetworkAttachmentType_T PRUint32


/* Start of enum NetworkAdapterType declaration */
#define NETWORKADAPTERTYPE_IID_STR "3c2281e4-d952-4e87-8c7d-24379cb6a81c"
#define NETWORKADAPTERTYPE_IID { \
    0x3c2281e4, 0xd952, 0x4e87, \
    { 0x8c, 0x7d, 0x24, 0x37, 0x9c, 0xb6, 0xa8, 0x1c } \
}
typedef enum NetworkAdapterType
{
    NetworkAdapterType_Null = 0,
    NetworkAdapterType_Am79C970A = 1,
    NetworkAdapterType_Am79C973 = 2,
    NetworkAdapterType_I82540EM = 3,
    NetworkAdapterType_I82543GC = 4,
    NetworkAdapterType_I82545EM = 5,
    NetworkAdapterType_Virtio = 6,
    NetworkAdapterType_Am79C960 = 7,
    NetworkAdapterType_NE2000 = 8,
    NetworkAdapterType_NE1000 = 9,
    NetworkAdapterType_WD8013 = 10,
    NetworkAdapterType_WD8003 = 11,
    NetworkAdapterType_ELNK2 = 12,
    NetworkAdapterType_ELNK1 = 13
} NetworkAdapterType;
/* End of enum NetworkAdapterType declaration */
#define NetworkAdapterType_T PRUint32


/* Start of enum NetworkAdapterPromiscModePolicy declaration */
#define NETWORKADAPTERPROMISCMODEPOLICY_IID_STR "c963768a-376f-4c85-8d84-d8ced4b7269e"
#define NETWORKADAPTERPROMISCMODEPOLICY_IID { \
    0xc963768a, 0x376f, 0x4c85, \
    { 0x8d, 0x84, 0xd8, 0xce, 0xd4, 0xb7, 0x26, 0x9e } \
}
typedef enum NetworkAdapterPromiscModePolicy
{
    NetworkAdapterPromiscModePolicy_Deny = 1,
    NetworkAdapterPromiscModePolicy_AllowNetwork = 2,
    NetworkAdapterPromiscModePolicy_AllowAll = 3
} NetworkAdapterPromiscModePolicy;
/* End of enum NetworkAdapterPromiscModePolicy declaration */
#define NetworkAdapterPromiscModePolicy_T PRUint32


/* Start of enum PortMode declaration */
#define PORTMODE_IID_STR "7485fcfd-d603-470a-87af-26d33beb7de9"
#define PORTMODE_IID { \
    0x7485fcfd, 0xd603, 0x470a, \
    { 0x87, 0xaf, 0x26, 0xd3, 0x3b, 0xeb, 0x7d, 0xe9 } \
}
typedef enum PortMode
{
    PortMode_Disconnected = 0,
    PortMode_HostPipe = 1,
    PortMode_HostDevice = 2,
    PortMode_RawFile = 3,
    PortMode_TCP = 4
} PortMode;
/* End of enum PortMode declaration */
#define PortMode_T PRUint32


/* Start of enum UartType declaration */
#define UARTTYPE_IID_STR "c8899d39-0b90-4265-9d02-1e38bd4d1b39"
#define UARTTYPE_IID { \
    0xc8899d39, 0x0b90, 0x4265, \
    { 0x9d, 0x02, 0x1e, 0x38, 0xbd, 0x4d, 0x1b, 0x39 } \
}
typedef enum UartType
{
    UartType_U16450 = 0,
    UartType_U16550A = 1,
    UartType_U16750 = 2
} UartType;
/* End of enum UartType declaration */
#define UartType_T PRUint32


/* Start of enum USBControllerType declaration */
#define USBCONTROLLERTYPE_IID_STR "8fdd1c6a-5412-41da-ab07-7baed7d6e18e"
#define USBCONTROLLERTYPE_IID { \
    0x8fdd1c6a, 0x5412, 0x41da, \
    { 0xab, 0x07, 0x7b, 0xae, 0xd7, 0xd6, 0xe1, 0x8e } \
}
typedef enum USBControllerType
{
    USBControllerType_Null = 0,
    USBControllerType_OHCI = 1,
    USBControllerType_EHCI = 2,
    USBControllerType_XHCI = 3,
    USBControllerType_Last = 4
} USBControllerType;
/* End of enum USBControllerType declaration */
#define USBControllerType_T PRUint32


/* Start of enum USBConnectionSpeed declaration */
#define USBCONNECTIONSPEED_IID_STR "d2915840-ea26-4fb4-b72a-21eaf6b888ff"
#define USBCONNECTIONSPEED_IID { \
    0xd2915840, 0xea26, 0x4fb4, \
    { 0xb7, 0x2a, 0x21, 0xea, 0xf6, 0xb8, 0x88, 0xff } \
}
typedef enum USBConnectionSpeed
{
    USBConnectionSpeed_Null = 0,
    USBConnectionSpeed_Low = 1,
    USBConnectionSpeed_Full = 2,
    USBConnectionSpeed_High = 3,
    USBConnectionSpeed_Super = 4,
    USBConnectionSpeed_SuperPlus = 5
} USBConnectionSpeed;
/* End of enum USBConnectionSpeed declaration */
#define USBConnectionSpeed_T PRUint32


/* Start of enum USBDeviceState declaration */
#define USBDEVICESTATE_IID_STR "b99a2e65-67fb-4882-82fd-f3e5e8193ab4"
#define USBDEVICESTATE_IID { \
    0xb99a2e65, 0x67fb, 0x4882, \
    { 0x82, 0xfd, 0xf3, 0xe5, 0xe8, 0x19, 0x3a, 0xb4 } \
}
typedef enum USBDeviceState
{
    USBDeviceState_NotSupported = 0,
    USBDeviceState_Unavailable = 1,
    USBDeviceState_Busy = 2,
    USBDeviceState_Available = 3,
    USBDeviceState_Held = 4,
    USBDeviceState_Captured = 5
} USBDeviceState;
/* End of enum USBDeviceState declaration */
#define USBDeviceState_T PRUint32


/* Start of enum USBDeviceFilterAction declaration */
#define USBDEVICEFILTERACTION_IID_STR "cbc30a49-2f4e-43b5-9da6-121320475933"
#define USBDEVICEFILTERACTION_IID { \
    0xcbc30a49, 0x2f4e, 0x43b5, \
    { 0x9d, 0xa6, 0x12, 0x13, 0x20, 0x47, 0x59, 0x33 } \
}
typedef enum USBDeviceFilterAction
{
    USBDeviceFilterAction_Null = 0,
    USBDeviceFilterAction_Ignore = 1,
    USBDeviceFilterAction_Hold = 2
} USBDeviceFilterAction;
/* End of enum USBDeviceFilterAction declaration */
#define USBDeviceFilterAction_T PRUint32


/* Start of enum AudioDriverType declaration */
#define AUDIODRIVERTYPE_IID_STR "32b4acfd-79ab-4b7e-9a1c-92e99f4e000b"
#define AUDIODRIVERTYPE_IID { \
    0x32b4acfd, 0x79ab, 0x4b7e, \
    { 0x9a, 0x1c, 0x92, 0xe9, 0x9f, 0x4e, 0x00, 0x0b } \
}
typedef enum AudioDriverType
{
    AudioDriverType_Default = 0,
    AudioDriverType_Null = 1,
    AudioDriverType_OSS = 2,
    AudioDriverType_ALSA = 3,
    AudioDriverType_Pulse = 4,
    AudioDriverType_WinMM = 5,
    AudioDriverType_DirectSound = 6,
    AudioDriverType_WAS = 7,
    AudioDriverType_CoreAudio = 8,
    AudioDriverType_MMPM = 9,
    AudioDriverType_SolAudio = 10
} AudioDriverType;
/* End of enum AudioDriverType declaration */
#define AudioDriverType_T PRUint32


/* Start of enum AudioControllerType declaration */
#define AUDIOCONTROLLERTYPE_IID_STR "6389dcc9-4e60-4983-9418-299e602efafc"
#define AUDIOCONTROLLERTYPE_IID { \
    0x6389dcc9, 0x4e60, 0x4983, \
    { 0x94, 0x18, 0x29, 0x9e, 0x60, 0x2e, 0xfa, 0xfc } \
}
typedef enum AudioControllerType
{
    AudioControllerType_AC97 = 0,
    AudioControllerType_SB16 = 1,
    AudioControllerType_HDA = 2,
    AudioControllerType_VirtioSound = 3
} AudioControllerType;
/* End of enum AudioControllerType declaration */
#define AudioControllerType_T PRUint32


/* Start of enum AudioCodecType declaration */
#define AUDIOCODECTYPE_IID_STR "7b406301-f520-420c-9805-8ce11c086370"
#define AUDIOCODECTYPE_IID { \
    0x7b406301, 0xf520, 0x420c, \
    { 0x98, 0x05, 0x8c, 0xe1, 0x1c, 0x08, 0x63, 0x70 } \
}
typedef enum AudioCodecType
{
    AudioCodecType_Null = 0,
    AudioCodecType_SB16 = 1,
    AudioCodecType_STAC9700 = 2,
    AudioCodecType_AD1980 = 3,
    AudioCodecType_STAC9221 = 4
} AudioCodecType;
/* End of enum AudioCodecType declaration */
#define AudioCodecType_T PRUint32


/* Start of enum AudioDirection declaration */
#define AUDIODIRECTION_IID_STR "f27d209b-040c-4ae9-beae-85f9693ca07a"
#define AUDIODIRECTION_IID { \
    0xf27d209b, 0x040c, 0x4ae9, \
    { 0xbe, 0xae, 0x85, 0xf9, 0x69, 0x3c, 0xa0, 0x7a } \
}
typedef enum AudioDirection
{
    AudioDirection_Unknown = 0,
    AudioDirection_In = 1,
    AudioDirection_Out = 2,
    AudioDirection_Duplex = 3
} AudioDirection;
/* End of enum AudioDirection declaration */
#define AudioDirection_T PRUint32


/* Start of enum AudioDeviceType declaration */
#define AUDIODEVICETYPE_IID_STR "95457071-ef88-45a9-8416-fc05b08731d2"
#define AUDIODEVICETYPE_IID { \
    0x95457071, 0xef88, 0x45a9, \
    { 0x84, 0x16, 0xfc, 0x05, 0xb0, 0x87, 0x31, 0xd2 } \
}
typedef enum AudioDeviceType
{
    AudioDeviceType_Unknown = 0,
    AudioDeviceType_BuiltLin = 1,
    AudioDeviceType_ExternalUSB = 2,
    AudioDeviceType_ExternalOther = 3
} AudioDeviceType;
/* End of enum AudioDeviceType declaration */
#define AudioDeviceType_T PRUint32


/* Start of enum AudioDeviceState declaration */
#define AUDIODEVICESTATE_IID_STR "45c1b969-556a-4277-8570-b438d2ef5ebe"
#define AUDIODEVICESTATE_IID { \
    0x45c1b969, 0x556a, 0x4277, \
    { 0x85, 0x70, 0xb4, 0x38, 0xd2, 0xef, 0x5e, 0xbe } \
}
typedef enum AudioDeviceState
{
    AudioDeviceState_Unknown = 0,
    AudioDeviceState_Active = 1,
    AudioDeviceState_Disabled = 2,
    AudioDeviceState_NotPresent = 3,
    AudioDeviceState_Unplugged = 4
} AudioDeviceState;
/* End of enum AudioDeviceState declaration */
#define AudioDeviceState_T PRUint32


/* Start of enum AuthType declaration */
#define AUTHTYPE_IID_STR "7eef6ef6-98c2-4dc2-ab35-10d2b292028d"
#define AUTHTYPE_IID { \
    0x7eef6ef6, 0x98c2, 0x4dc2, \
    { 0xab, 0x35, 0x10, 0xd2, 0xb2, 0x92, 0x02, 0x8d } \
}
typedef enum AuthType
{
    AuthType_Null = 0,
    AuthType_External = 1,
    AuthType_Guest = 2
} AuthType;
/* End of enum AuthType declaration */
#define AuthType_T PRUint32


/* Start of enum Reason declaration */
#define REASON_IID_STR "e7e8e097-299d-4e98-8bbc-c31c2d47d0cc"
#define REASON_IID { \
    0xe7e8e097, 0x299d, 0x4e98, \
    { 0x8b, 0xbc, 0xc3, 0x1c, 0x2d, 0x47, 0xd0, 0xcc } \
}
typedef enum Reason
{
    Reason_Unspecified = 0,
    Reason_HostSuspend = 1,
    Reason_HostResume = 2,
    Reason_HostBatteryLow = 3,
    Reason_Snapshot = 4
} Reason;
/* End of enum Reason declaration */
#define Reason_T PRUint32


/* Start of enum StorageBus declaration */
#define STORAGEBUS_IID_STR "f9510869-7d07-46ba-96a6-6728fbf4adee"
#define STORAGEBUS_IID { \
    0xf9510869, 0x7d07, 0x46ba, \
    { 0x96, 0xa6, 0x67, 0x28, 0xfb, 0xf4, 0xad, 0xee } \
}
typedef enum StorageBus
{
    StorageBus_Null = 0,
    StorageBus_IDE = 1,
    StorageBus_SATA = 2,
    StorageBus_SCSI = 3,
    StorageBus_Floppy = 4,
    StorageBus_SAS = 5,
    StorageBus_USB = 6,
    StorageBus_PCIe = 7,
    StorageBus_VirtioSCSI = 8
} StorageBus;
/* End of enum StorageBus declaration */
#define StorageBus_T PRUint32


/* Start of enum StorageControllerType declaration */
#define STORAGECONTROLLERTYPE_IID_STR "a77d457d-66a3-4368-b24c-293d0f562a9f"
#define STORAGECONTROLLERTYPE_IID { \
    0xa77d457d, 0x66a3, 0x4368, \
    { 0xb2, 0x4c, 0x29, 0x3d, 0x0f, 0x56, 0x2a, 0x9f } \
}
typedef enum StorageControllerType
{
    StorageControllerType_Null = 0,
    StorageControllerType_LsiLogic = 1,
    StorageControllerType_BusLogic = 2,
    StorageControllerType_IntelAhci = 3,
    StorageControllerType_PIIX3 = 4,
    StorageControllerType_PIIX4 = 5,
    StorageControllerType_ICH6 = 6,
    StorageControllerType_I82078 = 7,
    StorageControllerType_LsiLogicSas = 8,
    StorageControllerType_USB = 9,
    StorageControllerType_NVMe = 10,
    StorageControllerType_VirtioSCSI = 11
} StorageControllerType;
/* End of enum StorageControllerType declaration */
#define StorageControllerType_T PRUint32


/* Start of enum ChipsetType declaration */
#define CHIPSETTYPE_IID_STR "733d5f16-1f47-4e25-b272-d7c138bc2e3d"
#define CHIPSETTYPE_IID { \
    0x733d5f16, 0x1f47, 0x4e25, \
    { 0xb2, 0x72, 0xd7, 0xc1, 0x38, 0xbc, 0x2e, 0x3d } \
}
typedef enum ChipsetType
{
    ChipsetType_Null = 0,
    ChipsetType_PIIX3 = 1,
    ChipsetType_ICH9 = 2,
    ChipsetType_ARMv8Virtual = 3
} ChipsetType;
/* End of enum ChipsetType declaration */
#define ChipsetType_T PRUint32


/* Start of enum NATAliasMode declaration */
#define NATALIASMODE_IID_STR "67772168-50d9-11df-9669-7fb714ee4fa1"
#define NATALIASMODE_IID { \
    0x67772168, 0x50d9, 0x11df, \
    { 0x96, 0x69, 0x7f, 0xb7, 0x14, 0xee, 0x4f, 0xa1 } \
}
typedef enum NATAliasMode
{
    NATAliasMode_AliasLog = 0x1,
    NATAliasMode_AliasProxyOnly = 0x02,
    NATAliasMode_AliasUseSamePorts = 0x04
} NATAliasMode;
/* End of enum NATAliasMode declaration */
#define NATAliasMode_T PRUint32


/* Start of enum NATProtocol declaration */
#define NATPROTOCOL_IID_STR "e90164be-eb03-11de-94af-fff9b1c1b19f"
#define NATPROTOCOL_IID { \
    0xe90164be, 0xeb03, 0x11de, \
    { 0x94, 0xaf, 0xff, 0xf9, 0xb1, 0xc1, 0xb1, 0x9f } \
}
typedef enum NATProtocol
{
    NATProtocol_UDP = 0,
    NATProtocol_TCP = 1
} NATProtocol;
/* End of enum NATProtocol declaration */
#define NATProtocol_T PRUint32


/* Start of enum BandwidthGroupType declaration */
#define BANDWIDTHGROUPTYPE_IID_STR "1d92b67d-dc69-4be9-ad4c-93a01e1e0c8e"
#define BANDWIDTHGROUPTYPE_IID { \
    0x1d92b67d, 0xdc69, 0x4be9, \
    { 0xad, 0x4c, 0x93, 0xa0, 0x1e, 0x1e, 0x0c, 0x8e } \
}
typedef enum BandwidthGroupType
{
    BandwidthGroupType_Null = 0,
    BandwidthGroupType_Disk = 1,
    BandwidthGroupType_Network = 2
} BandwidthGroupType;
/* End of enum BandwidthGroupType declaration */
#define BandwidthGroupType_T PRUint32


/* Start of enum GuestDebugProvider declaration */
#define GUESTDEBUGPROVIDER_IID_STR "acdaddc5-aa0f-4f2e-be1f-a9be2828d24a"
#define GUESTDEBUGPROVIDER_IID { \
    0xacdaddc5, 0xaa0f, 0x4f2e, \
    { 0xbe, 0x1f, 0xa9, 0xbe, 0x28, 0x28, 0xd2, 0x4a } \
}
typedef enum GuestDebugProvider
{
    GuestDebugProvider_None = 0,
    GuestDebugProvider_Native = 1,
    GuestDebugProvider_GDB = 2,
    GuestDebugProvider_KD = 3
} GuestDebugProvider;
/* End of enum GuestDebugProvider declaration */
#define GuestDebugProvider_T PRUint32


/* Start of enum GuestDebugIoProvider declaration */
#define GUESTDEBUGIOPROVIDER_IID_STR "0cf00b1b-2ff7-414c-81c6-6cf410eaec4a"
#define GUESTDEBUGIOPROVIDER_IID { \
    0x0cf00b1b, 0x2ff7, 0x414c, \
    { 0x81, 0xc6, 0x6c, 0xf4, 0x10, 0xea, 0xec, 0x4a } \
}
typedef enum GuestDebugIoProvider
{
    GuestDebugIoProvider_None = 0,
    GuestDebugIoProvider_TCP = 1,
    GuestDebugIoProvider_UDP = 2,
    GuestDebugIoProvider_IPC = 3
} GuestDebugIoProvider;
/* End of enum GuestDebugIoProvider declaration */
#define GuestDebugIoProvider_T PRUint32


/* Start of enum VBoxEventType declaration */
#define VBOXEVENTTYPE_IID_STR "0c8f8bd7-c5d8-4085-83c2-558a4025b215"
#define VBOXEVENTTYPE_IID { \
    0x0c8f8bd7, 0xc5d8, 0x4085, \
    { 0x83, 0xc2, 0x55, 0x8a, 0x40, 0x25, 0xb2, 0x15 } \
}
typedef enum VBoxEventType
{
    VBoxEventType_Invalid = 0,
    VBoxEventType_Any = 1,
    VBoxEventType_Vetoable = 2,
    VBoxEventType_MachineEvent = 3,
    VBoxEventType_SnapshotEvent = 4,
    VBoxEventType_InputEvent = 5,
    VBoxEventType_LastWildcard = 31,
    VBoxEventType_OnMachineStateChanged = 32,
    VBoxEventType_OnMachineDataChanged = 33,
    VBoxEventType_OnExtraDataChanged = 34,
    VBoxEventType_OnExtraDataCanChange = 35,
    VBoxEventType_OnMediumRegistered = 36,
    VBoxEventType_OnMachineRegistered = 37,
    VBoxEventType_OnSessionStateChanged = 38,
    VBoxEventType_OnSnapshotTaken = 39,
    VBoxEventType_OnSnapshotDeleted = 40,
    VBoxEventType_OnSnapshotChanged = 41,
    VBoxEventType_OnGuestPropertyChanged = 42,
    VBoxEventType_OnMousePointerShapeChanged = 43,
    VBoxEventType_OnMouseCapabilityChanged = 44,
    VBoxEventType_OnKeyboardLedsChanged = 45,
    VBoxEventType_OnStateChanged = 46,
    VBoxEventType_OnAdditionsStateChanged = 47,
    VBoxEventType_OnNetworkAdapterChanged = 48,
    VBoxEventType_OnSerialPortChanged = 49,
    VBoxEventType_OnParallelPortChanged = 50,
    VBoxEventType_OnStorageControllerChanged = 51,
    VBoxEventType_OnMediumChanged = 52,
    VBoxEventType_OnVRDEServerChanged = 53,
    VBoxEventType_OnUSBControllerChanged = 54,
    VBoxEventType_OnUSBDeviceStateChanged = 55,
    VBoxEventType_OnSharedFolderChanged = 56,
    VBoxEventType_OnRuntimeError = 57,
    VBoxEventType_OnCanShowWindow = 58,
    VBoxEventType_OnShowWindow = 59,
    VBoxEventType_OnCPUChanged = 60,
    VBoxEventType_OnVRDEServerInfoChanged = 61,
    VBoxEventType_OnEventSourceChanged = 62,
    VBoxEventType_OnCPUExecutionCapChanged = 63,
    VBoxEventType_OnGuestKeyboard = 64,
    VBoxEventType_OnGuestMouse = 65,
    VBoxEventType_OnNATRedirect = 66,
    VBoxEventType_OnHostPCIDevicePlug = 67,
    VBoxEventType_OnVBoxSVCAvailabilityChanged = 68,
    VBoxEventType_OnBandwidthGroupChanged = 69,
    VBoxEventType_OnGuestMonitorChanged = 70,
    VBoxEventType_OnStorageDeviceChanged = 71,
    VBoxEventType_OnClipboardModeChanged = 72,
    VBoxEventType_OnDnDModeChanged = 73,
    VBoxEventType_OnNATNetworkChanged = 74,
    VBoxEventType_OnNATNetworkStartStop = 75,
    VBoxEventType_OnNATNetworkAlter = 76,
    VBoxEventType_OnNATNetworkCreationDeletion = 77,
    VBoxEventType_OnNATNetworkSetting = 78,
    VBoxEventType_OnNATNetworkPortForward = 79,
    VBoxEventType_OnGuestSessionStateChanged = 80,
    VBoxEventType_OnGuestSessionRegistered = 81,
    VBoxEventType_OnGuestProcessRegistered = 82,
    VBoxEventType_OnGuestProcessStateChanged = 83,
    VBoxEventType_OnGuestProcessInputNotify = 84,
    VBoxEventType_OnGuestProcessOutput = 85,
    VBoxEventType_OnGuestFileRegistered = 86,
    VBoxEventType_OnGuestFileStateChanged = 87,
    VBoxEventType_OnGuestFileOffsetChanged = 88,
    VBoxEventType_OnGuestFileRead = 89,
    VBoxEventType_OnGuestFileWrite = 90,
    VBoxEventType_OnRecordingStateChanged = 91,
    VBoxEventType_OnGuestUserStateChanged = 92,
    VBoxEventType_OnGuestMultiTouch = 93,
    VBoxEventType_OnHostNameResolutionConfigurationChange = 94,
    VBoxEventType_OnSnapshotRestored = 95,
    VBoxEventType_OnMediumConfigChanged = 96,
    VBoxEventType_OnAudioAdapterChanged = 97,
    VBoxEventType_OnProgressPercentageChanged = 98,
    VBoxEventType_OnProgressTaskCompleted = 99,
    VBoxEventType_OnCursorPositionChanged = 100,
    VBoxEventType_OnGuestAdditionsStatusChanged = 101,
    VBoxEventType_OnGuestMonitorInfoChanged = 102,
    VBoxEventType_OnGuestFileSizeChanged = 103,
    VBoxEventType_OnClipboardFileTransferModeChanged = 104,
    VBoxEventType_OnCloudProviderListChanged = 105,
    VBoxEventType_OnCloudProviderRegistered = 106,
    VBoxEventType_OnCloudProviderUninstall = 107,
    VBoxEventType_OnCloudProfileRegistered = 108,
    VBoxEventType_OnCloudProfileChanged = 109,
    VBoxEventType_OnProgressCreated = 110,
    VBoxEventType_OnLanguageChanged = 111,
    VBoxEventType_OnUpdateAgentAvailable = 112,
    VBoxEventType_OnUpdateAgentError = 113,
    VBoxEventType_OnUpdateAgentSettingsChanged = 114,
    VBoxEventType_OnUpdateAgentStateChanged = 115,
    VBoxEventType_OnHostAudioDeviceChanged = 116,
    VBoxEventType_OnGuestDebugControlChanged = 117,
    VBoxEventType_OnMachineGroupsChanged = 118,
    VBoxEventType_OnGuestDirectoryRegistered = 119,
    VBoxEventType_OnGuestDirectoryStateChanged = 120,
    VBoxEventType_OnGuestDirectoryRead = 121,
    VBoxEventType_OnClipboardError = 122,
    VBoxEventType_OnExtPackInstalled = 123,
    VBoxEventType_OnExtPackUninstalled = 124,
    VBoxEventType_OnRecordingScreenStateChanged = 125,
    VBoxEventType_End = 126
} VBoxEventType;
/* End of enum VBoxEventType declaration */
#define VBoxEventType_T PRUint32


/* Start of enum GuestMouseEventMode declaration */
#define GUESTMOUSEEVENTMODE_IID_STR "4b500146-ebba-4b7c-bc29-69c2d57a5caf"
#define GUESTMOUSEEVENTMODE_IID { \
    0x4b500146, 0xebba, 0x4b7c, \
    { 0xbc, 0x29, 0x69, 0xc2, 0xd5, 0x7a, 0x5c, 0xaf } \
}
typedef enum GuestMouseEventMode
{
    GuestMouseEventMode_Relative = 0,
    GuestMouseEventMode_Absolute = 1
} GuestMouseEventMode;
/* End of enum GuestMouseEventMode declaration */
#define GuestMouseEventMode_T PRUint32


/* Start of enum GuestMonitorChangedEventType declaration */
#define GUESTMONITORCHANGEDEVENTTYPE_IID_STR "ef172985-7e36-4297-95be-e46396968d66"
#define GUESTMONITORCHANGEDEVENTTYPE_IID { \
    0xef172985, 0x7e36, 0x4297, \
    { 0x95, 0xbe, 0xe4, 0x63, 0x96, 0x96, 0x8d, 0x66 } \
}
typedef enum GuestMonitorChangedEventType
{
    GuestMonitorChangedEventType_Enabled = 0,
    GuestMonitorChangedEventType_Disabled = 1,
    GuestMonitorChangedEventType_NewOrigin = 2
} GuestMonitorChangedEventType;
/* End of enum GuestMonitorChangedEventType declaration */
#define GuestMonitorChangedEventType_T PRUint32


/* Start of enum FormValueType declaration */
#define FORMVALUETYPE_IID_STR "5f10e2f2-911f-4f55-8afb-39c790f7dc42"
#define FORMVALUETYPE_IID { \
    0x5f10e2f2, 0x911f, 0x4f55, \
    { 0x8a, 0xfb, 0x39, 0xc7, 0x90, 0xf7, 0xdc, 0x42 } \
}
typedef enum FormValueType
{
    FormValueType_Boolean = 0,
    FormValueType_String = 1,
    FormValueType_Choice = 2,
    FormValueType_RangedInteger = 3,
    FormValueType_RangedInteger64 = 4
} FormValueType;
/* End of enum FormValueType declaration */
#define FormValueType_T PRUint32


/* Start of enum CloudMachineState declaration */
#define CLOUDMACHINESTATE_IID_STR "67b6d054-0154-4f5d-b71b-6ac406e1ff78"
#define CLOUDMACHINESTATE_IID { \
    0x67b6d054, 0x0154, 0x4f5d, \
    { 0xb7, 0x1b, 0x6a, 0xc4, 0x06, 0xe1, 0xff, 0x78 } \
}
typedef enum CloudMachineState
{
    CloudMachineState_Invalid = 0,
    CloudMachineState_Provisioning = 1,
    CloudMachineState_Running = 2,
    CloudMachineState_Starting = 3,
    CloudMachineState_Stopping = 4,
    CloudMachineState_Stopped = 5,
    CloudMachineState_CreatingImage = 6,
    CloudMachineState_Terminating = 7,
    CloudMachineState_Terminated = 8
} CloudMachineState;
/* End of enum CloudMachineState declaration */
#define CloudMachineState_T PRUint32


/* Start of enum CloudImageState declaration */
#define CLOUDIMAGESTATE_IID_STR "6e5d6762-eea2-4f2c-b104-2952d0aa8a0a"
#define CLOUDIMAGESTATE_IID { \
    0x6e5d6762, 0xeea2, 0x4f2c, \
    { 0xb1, 0x04, 0x29, 0x52, 0xd0, 0xaa, 0x8a, 0x0a } \
}
typedef enum CloudImageState
{
    CloudImageState_Invalid = 0,
    CloudImageState_Provisioning = 1,
    CloudImageState_Importing = 2,
    CloudImageState_Available = 3,
    CloudImageState_Exporting = 4,
    CloudImageState_Disabled = 5,
    CloudImageState_Deleted = 6
} CloudImageState;
/* End of enum CloudImageState declaration */
#define CloudImageState_T PRUint32


/* Start of enum MetricType declaration */
#define METRICTYPE_IID_STR "adf26edc-7e32-11ee-b962-0242ac120002"
#define METRICTYPE_IID { \
    0xadf26edc, 0x7e32, 0x11ee, \
    { 0xb9, 0x62, 0x02, 0x42, 0xac, 0x12, 0x00, 0x02 } \
}
typedef enum MetricType
{
    MetricType_Invalid = 0,
    MetricType_CpuUtilization = 1,
    MetricType_MemoryUtilization = 2,
    MetricType_DiskBytesRead = 3,
    MetricType_DiskBytesWritten = 4,
    MetricType_NetworksBytesIn = 5,
    MetricType_NetworksBytesOut = 6
} MetricType;
/* End of enum MetricType declaration */
#define MetricType_T PRUint32


/* Start of enum SymlinkPolicy declaration */
#define SYMLINKPOLICY_IID_STR "a818472e-215d-4279-8af8-eac4c0517bcc"
#define SYMLINKPOLICY_IID { \
    0xa818472e, 0x215d, 0x4279, \
    { 0x8a, 0xf8, 0xea, 0xc4, 0xc0, 0x51, 0x7b, 0xcc } \
}
typedef enum SymlinkPolicy
{
    SymlinkPolicy_None = 0,
    SymlinkPolicy_Forbidden = 1,
    SymlinkPolicy_AllowedInShareSubtree = 2,
    SymlinkPolicy_AllowedToRelativeTargets = 3,
    SymlinkPolicy_AllowedToAnyTarget = 4
} SymlinkPolicy;
/* End of enum SymlinkPolicy declaration */
#define SymlinkPolicy_T PRUint32


/* Start of struct IVirtualBoxErrorInfo declaration */
#define IVIRTUALBOXERRORINFO_IID_STR "c1bcc6d5-7966-481d-ab0b-d0ed73e28135"
#define IVIRTUALBOXERRORINFO_IID { \
    0xc1bcc6d5, 0x7966, 0x481d, \
    { 0xab, 0x0b, 0xd0, 0xed, 0x73, 0xe2, 0x81, 0x35 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IVirtualBoxErrorInfo);
#ifndef VBOX_WITH_GLUE
struct IVirtualBoxErrorInfo_vtbl
{
    struct nsIException_vtbl nsiexception;

    nsresult (*GetResultCode)(IVirtualBoxErrorInfo *pThis, PRInt32 *resultCode);

    nsresult (*GetResultDetail)(IVirtualBoxErrorInfo *pThis, PRInt32 *resultDetail);

    nsresult (*GetInterfaceID)(IVirtualBoxErrorInfo *pThis, PRUnichar * *interfaceID);

    nsresult (*GetComponent)(IVirtualBoxErrorInfo *pThis, PRUnichar * *component);

    nsresult (*GetText)(IVirtualBoxErrorInfo *pThis, PRUnichar * *text);

    nsresult (*GetNext)(IVirtualBoxErrorInfo *pThis, IVirtualBoxErrorInfo * *next);

};
#else /* VBOX_WITH_GLUE */
struct IVirtualBoxErrorInfoVtbl
{
    nsresult (*QueryInterface)(IVirtualBoxErrorInfo *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IVirtualBoxErrorInfo *pThis);
    nsrefcnt (*Release)(IVirtualBoxErrorInfo *pThis);
    nsresult (*GetMessage)(IVirtualBoxErrorInfo *pThis, PRUnichar * *aMessage);
    nsresult (*GetResult)(IVirtualBoxErrorInfo *pThis, nsresult *aResult);
    nsresult (*GetName)(IVirtualBoxErrorInfo*pThis, PRUnichar * *aName);
    nsresult (*GetFilename)(IVirtualBoxErrorInfo *pThis, PRUnichar * *aFilename);
    nsresult (*GetLineNumber)(IVirtualBoxErrorInfo *pThis, PRUint32 *aLineNumber);
    nsresult (*GetColumnNumber)(IVirtualBoxErrorInfo *pThis, PRUint32 *aColumnNumber);
    nsresult (*GetLocation)(IVirtualBoxErrorInfo *pThis, nsIStackFrame * *aLocation);
    nsresult (*GetInner)(IVirtualBoxErrorInfo *pThis, nsIException * *aInner);
    nsresult (*GetData)(IVirtualBoxErrorInfo *pThis, nsISupports * *aData);
    nsresult (*ToString)(IVirtualBoxErrorInfo *pThis, PRUnichar **_retval);
    nsresult (*GetResultCode)(IVirtualBoxErrorInfo *pThis, PRInt32 *resultCode);

    nsresult (*GetResultDetail)(IVirtualBoxErrorInfo *pThis, PRInt32 *resultDetail);

    nsresult (*GetInterfaceID)(IVirtualBoxErrorInfo *pThis, PRUnichar * *interfaceID);

    nsresult (*GetComponent)(IVirtualBoxErrorInfo *pThis, PRUnichar * *component);

    nsresult (*GetText)(IVirtualBoxErrorInfo *pThis, PRUnichar * *text);

    nsresult (*GetNext)(IVirtualBoxErrorInfo *pThis, IVirtualBoxErrorInfo * *next);

};
#define IVirtualBoxErrorInfo_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IVirtualBoxErrorInfo_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IVirtualBoxErrorInfo_Release(p) ((p)->lpVtbl->Release(p))
#define IVirtualBoxErrorInfo_get_Message(p, aMessage) ((p)->lpVtbl->GetMessage(p, aMessage))
#define IVirtualBoxErrorInfo_GetMessage(p, aMessage) ((p)->lpVtbl->GetMessage(p, aMessage))
#define IVirtualBoxErrorInfo_get_Result(p, aResult) ((p)->lpVtbl->GetResult(p, aResult))
#define IVirtualBoxErrorInfo_GetResult(p, aResult) ((p)->lpVtbl->GetResult(p, aResult))
#define IVirtualBoxErrorInfo_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IVirtualBoxErrorInfo_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IVirtualBoxErrorInfo_get_Filename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IVirtualBoxErrorInfo_GetFilename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IVirtualBoxErrorInfo_get_LineNumber(p, aLineNumber) ((p)->lpVtbl->GetLineNumber(p, aLineNumber))
#define IVirtualBoxErrorInfo_GetLineNumber(p, aLineNumber) ((p)->lpVtbl->GetLineNumber(p, aLineNumber))
#define IVirtualBoxErrorInfo_get_ColumnNumber(p, aColumnNumber) ((p)->lpVtbl->GetColumnNumber(p, aColumnNumber))
#define IVirtualBoxErrorInfo_GetColumnNumber(p, aColumnNumber) ((p)->lpVtbl->GetColumnNumber(p, aColumnNumber))
#define IVirtualBoxErrorInfo_get_Location(p, aLocation) ((p)->lpVtbl->GetLocation(p, aLocation))
#define IVirtualBoxErrorInfo_GetLocation(p, aLocation) ((p)->lpVtbl->GetLocation(p, aLocation))
#define IVirtualBoxErrorInfo_get_Inner(p, aInner) ((p)->lpVtbl->GetInner(p, aInner))
#define IVirtualBoxErrorInfo_GetInner(p, aInner) ((p)->lpVtbl->GetInner(p, aInner))
#define IVirtualBoxErrorInfo_get_Data(p, aData) ((p)->lpVtbl->GetData(p, aData))
#define IVirtualBoxErrorInfo_GetData(p, aData) ((p)->lpVtbl->GetData(p, aData))
#define IVirtualBoxErrorInfo_ToString(p, retval) ((p)->lpVtbl->ToString(p, retval))
#define IVirtualBoxErrorInfo_get_ResultCode(p, aResultCode) ((p)->lpVtbl->GetResultCode(p, aResultCode))
#define IVirtualBoxErrorInfo_GetResultCode(p, aResultCode) ((p)->lpVtbl->GetResultCode(p, aResultCode))
#define IVirtualBoxErrorInfo_get_ResultDetail(p, aResultDetail) ((p)->lpVtbl->GetResultDetail(p, aResultDetail))
#define IVirtualBoxErrorInfo_GetResultDetail(p, aResultDetail) ((p)->lpVtbl->GetResultDetail(p, aResultDetail))
#define IVirtualBoxErrorInfo_get_InterfaceID(p, aInterfaceID) ((p)->lpVtbl->GetInterfaceID(p, aInterfaceID))
#define IVirtualBoxErrorInfo_GetInterfaceID(p, aInterfaceID) ((p)->lpVtbl->GetInterfaceID(p, aInterfaceID))
#define IVirtualBoxErrorInfo_get_Component(p, aComponent) ((p)->lpVtbl->GetComponent(p, aComponent))
#define IVirtualBoxErrorInfo_GetComponent(p, aComponent) ((p)->lpVtbl->GetComponent(p, aComponent))
#define IVirtualBoxErrorInfo_get_Text(p, aText) ((p)->lpVtbl->GetText(p, aText))
#define IVirtualBoxErrorInfo_GetText(p, aText) ((p)->lpVtbl->GetText(p, aText))
#define IVirtualBoxErrorInfo_get_Next(p, aNext) ((p)->lpVtbl->GetNext(p, aNext))
#define IVirtualBoxErrorInfo_GetNext(p, aNext) ((p)->lpVtbl->GetNext(p, aNext))
#endif /* VBOX_WITH_GLUE */

interface IVirtualBoxErrorInfo
{
#ifndef VBOX_WITH_GLUE
    struct IVirtualBoxErrorInfo_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IVirtualBoxErrorInfoVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IVirtualBoxErrorInfo declaration */


/* Start of struct INATNetwork declaration */
#define INATNETWORK_IID_STR "4fdebbf0-be30-49c0-b315-e9749e1bded1"
#define INATNETWORK_IID { \
    0x4fdebbf0, 0xbe30, 0x49c0, \
    { 0xb3, 0x15, 0xe9, 0x74, 0x9e, 0x1b, 0xde, 0xd1 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_INATNetwork);
#ifndef VBOX_WITH_GLUE
struct INATNetwork_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetNetworkName)(INATNetwork *pThis, PRUnichar * *networkName);
    nsresult (*SetNetworkName)(INATNetwork *pThis, PRUnichar * networkName);

    nsresult (*GetEnabled)(INATNetwork *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(INATNetwork *pThis, PRBool enabled);

    nsresult (*GetNetwork)(INATNetwork *pThis, PRUnichar * *network);
    nsresult (*SetNetwork)(INATNetwork *pThis, PRUnichar * network);

    nsresult (*GetGateway)(INATNetwork *pThis, PRUnichar * *gateway);

    nsresult (*GetIPv6Enabled)(INATNetwork *pThis, PRBool *IPv6Enabled);
    nsresult (*SetIPv6Enabled)(INATNetwork *pThis, PRBool IPv6Enabled);

    nsresult (*GetIPv6Prefix)(INATNetwork *pThis, PRUnichar * *IPv6Prefix);
    nsresult (*SetIPv6Prefix)(INATNetwork *pThis, PRUnichar * IPv6Prefix);

    nsresult (*GetAdvertiseDefaultIPv6RouteEnabled)(INATNetwork *pThis, PRBool *advertiseDefaultIPv6RouteEnabled);
    nsresult (*SetAdvertiseDefaultIPv6RouteEnabled)(INATNetwork *pThis, PRBool advertiseDefaultIPv6RouteEnabled);

    nsresult (*GetNeedDhcpServer)(INATNetwork *pThis, PRBool *needDhcpServer);
    nsresult (*SetNeedDhcpServer)(INATNetwork *pThis, PRBool needDhcpServer);

    nsresult (*GetEventSource)(INATNetwork *pThis, IEventSource * *eventSource);

    nsresult (*GetPortForwardRules4)(INATNetwork *pThis, PRUint32 *portForwardRules4Size, PRUnichar * **portForwardRules4);

    nsresult (*GetLocalMappings)(INATNetwork *pThis, PRUint32 *localMappingsSize, PRUnichar * **localMappings);

    nsresult (*GetLoopbackIp6)(INATNetwork *pThis, PRInt32 *loopbackIp6);
    nsresult (*SetLoopbackIp6)(INATNetwork *pThis, PRInt32 loopbackIp6);

    nsresult (*GetPortForwardRules6)(INATNetwork *pThis, PRUint32 *portForwardRules6Size, PRUnichar * **portForwardRules6);

    nsresult (*GetInternalAndReservedAttribute1INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*AddLocalMapping)(
        INATNetwork *pThis,
        PRUnichar * hostid,
        PRInt32 offset
    );

    nsresult (*AddPortForwardRule)(
        INATNetwork *pThis,
        PRBool isIpv6,
        PRUnichar * ruleName,
        PRUint32 proto,
        PRUnichar * hostIP,
        PRUint16 hostPort,
        PRUnichar * guestIP,
        PRUint16 guestPort
    );

    nsresult (*RemovePortForwardRule)(
        INATNetwork *pThis,
        PRBool isIpv6,
        PRUnichar * ruleName
    );

    nsresult (*Start)(INATNetwork *pThis );

    nsresult (*Stop)(INATNetwork *pThis );

    nsresult (*InternalAndReservedMethod1INATNetwork)(INATNetwork *pThis);

    nsresult (*InternalAndReservedMethod2INATNetwork)(INATNetwork *pThis);

};
#else /* VBOX_WITH_GLUE */
struct INATNetworkVtbl
{
    nsresult (*QueryInterface)(INATNetwork *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(INATNetwork *pThis);
    nsrefcnt (*Release)(INATNetwork *pThis);
    nsresult (*GetNetworkName)(INATNetwork *pThis, PRUnichar * *networkName);
    nsresult (*SetNetworkName)(INATNetwork *pThis, PRUnichar * networkName);

    nsresult (*GetEnabled)(INATNetwork *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(INATNetwork *pThis, PRBool enabled);

    nsresult (*GetNetwork)(INATNetwork *pThis, PRUnichar * *network);
    nsresult (*SetNetwork)(INATNetwork *pThis, PRUnichar * network);

    nsresult (*GetGateway)(INATNetwork *pThis, PRUnichar * *gateway);

    nsresult (*GetIPv6Enabled)(INATNetwork *pThis, PRBool *IPv6Enabled);
    nsresult (*SetIPv6Enabled)(INATNetwork *pThis, PRBool IPv6Enabled);

    nsresult (*GetIPv6Prefix)(INATNetwork *pThis, PRUnichar * *IPv6Prefix);
    nsresult (*SetIPv6Prefix)(INATNetwork *pThis, PRUnichar * IPv6Prefix);

    nsresult (*GetAdvertiseDefaultIPv6RouteEnabled)(INATNetwork *pThis, PRBool *advertiseDefaultIPv6RouteEnabled);
    nsresult (*SetAdvertiseDefaultIPv6RouteEnabled)(INATNetwork *pThis, PRBool advertiseDefaultIPv6RouteEnabled);

    nsresult (*GetNeedDhcpServer)(INATNetwork *pThis, PRBool *needDhcpServer);
    nsresult (*SetNeedDhcpServer)(INATNetwork *pThis, PRBool needDhcpServer);

    nsresult (*GetEventSource)(INATNetwork *pThis, IEventSource * *eventSource);

    nsresult (*GetPortForwardRules4)(INATNetwork *pThis, PRUint32 *portForwardRules4Size, PRUnichar * **portForwardRules4);

    nsresult (*GetLocalMappings)(INATNetwork *pThis, PRUint32 *localMappingsSize, PRUnichar * **localMappings);

    nsresult (*GetLoopbackIp6)(INATNetwork *pThis, PRInt32 *loopbackIp6);
    nsresult (*SetLoopbackIp6)(INATNetwork *pThis, PRInt32 loopbackIp6);

    nsresult (*GetPortForwardRules6)(INATNetwork *pThis, PRUint32 *portForwardRules6Size, PRUnichar * **portForwardRules6);

    nsresult (*GetInternalAndReservedAttribute1INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8INATNetwork)(INATNetwork *pThis, PRUint32 *reserved);

    nsresult (*AddLocalMapping)(
        INATNetwork *pThis,
        PRUnichar * hostid,
        PRInt32 offset
    );

    nsresult (*AddPortForwardRule)(
        INATNetwork *pThis,
        PRBool isIpv6,
        PRUnichar * ruleName,
        PRUint32 proto,
        PRUnichar * hostIP,
        PRUint16 hostPort,
        PRUnichar * guestIP,
        PRUint16 guestPort
    );

    nsresult (*RemovePortForwardRule)(
        INATNetwork *pThis,
        PRBool isIpv6,
        PRUnichar * ruleName
    );

    nsresult (*Start)(INATNetwork *pThis );

    nsresult (*Stop)(INATNetwork *pThis );

    nsresult (*InternalAndReservedMethod1INATNetwork)(INATNetwork *pThis);

    nsresult (*InternalAndReservedMethod2INATNetwork)(INATNetwork *pThis);

};
#define INATNetwork_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define INATNetwork_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define INATNetwork_Release(p) ((p)->lpVtbl->Release(p))
#define INATNetwork_get_NetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define INATNetwork_GetNetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define INATNetwork_put_NetworkName(p, aNetworkName) ((p)->lpVtbl->SetNetworkName(p, aNetworkName))
#define INATNetwork_SetNetworkName(p, aNetworkName) ((p)->lpVtbl->SetNetworkName(p, aNetworkName))
#define INATNetwork_get_Enabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define INATNetwork_GetEnabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define INATNetwork_put_Enabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define INATNetwork_SetEnabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define INATNetwork_get_Network(p, aNetwork) ((p)->lpVtbl->GetNetwork(p, aNetwork))
#define INATNetwork_GetNetwork(p, aNetwork) ((p)->lpVtbl->GetNetwork(p, aNetwork))
#define INATNetwork_put_Network(p, aNetwork) ((p)->lpVtbl->SetNetwork(p, aNetwork))
#define INATNetwork_SetNetwork(p, aNetwork) ((p)->lpVtbl->SetNetwork(p, aNetwork))
#define INATNetwork_get_Gateway(p, aGateway) ((p)->lpVtbl->GetGateway(p, aGateway))
#define INATNetwork_GetGateway(p, aGateway) ((p)->lpVtbl->GetGateway(p, aGateway))
#define INATNetwork_get_IPv6Enabled(p, aIPv6Enabled) ((p)->lpVtbl->GetIPv6Enabled(p, aIPv6Enabled))
#define INATNetwork_GetIPv6Enabled(p, aIPv6Enabled) ((p)->lpVtbl->GetIPv6Enabled(p, aIPv6Enabled))
#define INATNetwork_put_IPv6Enabled(p, aIPv6Enabled) ((p)->lpVtbl->SetIPv6Enabled(p, aIPv6Enabled))
#define INATNetwork_SetIPv6Enabled(p, aIPv6Enabled) ((p)->lpVtbl->SetIPv6Enabled(p, aIPv6Enabled))
#define INATNetwork_get_IPv6Prefix(p, aIPv6Prefix) ((p)->lpVtbl->GetIPv6Prefix(p, aIPv6Prefix))
#define INATNetwork_GetIPv6Prefix(p, aIPv6Prefix) ((p)->lpVtbl->GetIPv6Prefix(p, aIPv6Prefix))
#define INATNetwork_put_IPv6Prefix(p, aIPv6Prefix) ((p)->lpVtbl->SetIPv6Prefix(p, aIPv6Prefix))
#define INATNetwork_SetIPv6Prefix(p, aIPv6Prefix) ((p)->lpVtbl->SetIPv6Prefix(p, aIPv6Prefix))
#define INATNetwork_get_AdvertiseDefaultIPv6RouteEnabled(p, aAdvertiseDefaultIPv6RouteEnabled) ((p)->lpVtbl->GetAdvertiseDefaultIPv6RouteEnabled(p, aAdvertiseDefaultIPv6RouteEnabled))
#define INATNetwork_GetAdvertiseDefaultIPv6RouteEnabled(p, aAdvertiseDefaultIPv6RouteEnabled) ((p)->lpVtbl->GetAdvertiseDefaultIPv6RouteEnabled(p, aAdvertiseDefaultIPv6RouteEnabled))
#define INATNetwork_put_AdvertiseDefaultIPv6RouteEnabled(p, aAdvertiseDefaultIPv6RouteEnabled) ((p)->lpVtbl->SetAdvertiseDefaultIPv6RouteEnabled(p, aAdvertiseDefaultIPv6RouteEnabled))
#define INATNetwork_SetAdvertiseDefaultIPv6RouteEnabled(p, aAdvertiseDefaultIPv6RouteEnabled) ((p)->lpVtbl->SetAdvertiseDefaultIPv6RouteEnabled(p, aAdvertiseDefaultIPv6RouteEnabled))
#define INATNetwork_get_NeedDhcpServer(p, aNeedDhcpServer) ((p)->lpVtbl->GetNeedDhcpServer(p, aNeedDhcpServer))
#define INATNetwork_GetNeedDhcpServer(p, aNeedDhcpServer) ((p)->lpVtbl->GetNeedDhcpServer(p, aNeedDhcpServer))
#define INATNetwork_put_NeedDhcpServer(p, aNeedDhcpServer) ((p)->lpVtbl->SetNeedDhcpServer(p, aNeedDhcpServer))
#define INATNetwork_SetNeedDhcpServer(p, aNeedDhcpServer) ((p)->lpVtbl->SetNeedDhcpServer(p, aNeedDhcpServer))
#define INATNetwork_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define INATNetwork_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define INATNetwork_get_PortForwardRules4(p, aPortForwardRules4) ((p)->lpVtbl->GetPortForwardRules4(p, aPortForwardRules4))
#define INATNetwork_GetPortForwardRules4(p, aPortForwardRules4) ((p)->lpVtbl->GetPortForwardRules4(p, aPortForwardRules4))
#define INATNetwork_get_LocalMappings(p, aLocalMappings) ((p)->lpVtbl->GetLocalMappings(p, aLocalMappings))
#define INATNetwork_GetLocalMappings(p, aLocalMappings) ((p)->lpVtbl->GetLocalMappings(p, aLocalMappings))
#define INATNetwork_get_LoopbackIp6(p, aLoopbackIp6) ((p)->lpVtbl->GetLoopbackIp6(p, aLoopbackIp6))
#define INATNetwork_GetLoopbackIp6(p, aLoopbackIp6) ((p)->lpVtbl->GetLoopbackIp6(p, aLoopbackIp6))
#define INATNetwork_put_LoopbackIp6(p, aLoopbackIp6) ((p)->lpVtbl->SetLoopbackIp6(p, aLoopbackIp6))
#define INATNetwork_SetLoopbackIp6(p, aLoopbackIp6) ((p)->lpVtbl->SetLoopbackIp6(p, aLoopbackIp6))
#define INATNetwork_get_PortForwardRules6(p, aPortForwardRules6) ((p)->lpVtbl->GetPortForwardRules6(p, aPortForwardRules6))
#define INATNetwork_GetPortForwardRules6(p, aPortForwardRules6) ((p)->lpVtbl->GetPortForwardRules6(p, aPortForwardRules6))
#define INATNetwork_AddLocalMapping(p, aHostid, aOffset) ((p)->lpVtbl->AddLocalMapping(p, aHostid, aOffset))
#define INATNetwork_AddPortForwardRule(p, aIsIpv6, aRuleName, aProto, aHostIP, aHostPort, aGuestIP, aGuestPort) ((p)->lpVtbl->AddPortForwardRule(p, aIsIpv6, aRuleName, aProto, aHostIP, aHostPort, aGuestIP, aGuestPort))
#define INATNetwork_RemovePortForwardRule(p, aIsIpv6, aRuleName) ((p)->lpVtbl->RemovePortForwardRule(p, aIsIpv6, aRuleName))
#define INATNetwork_Start(p) ((p)->lpVtbl->Start(p))
#define INATNetwork_Stop(p) ((p)->lpVtbl->Stop(p))
#endif /* VBOX_WITH_GLUE */

interface INATNetwork
{
#ifndef VBOX_WITH_GLUE
    struct INATNetwork_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct INATNetworkVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct INATNetwork declaration */


/* Start of struct ICloudNetwork declaration */
#define ICLOUDNETWORK_IID_STR "d8e3496e-735f-4fde-8a54-427d49409b5f"
#define ICLOUDNETWORK_IID { \
    0xd8e3496e, 0x735f, 0x4fde, \
    { 0x8a, 0x54, 0x42, 0x7d, 0x49, 0x40, 0x9b, 0x5f } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_ICloudNetwork);
#ifndef VBOX_WITH_GLUE
struct ICloudNetwork_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetNetworkName)(ICloudNetwork *pThis, PRUnichar * *networkName);
    nsresult (*SetNetworkName)(ICloudNetwork *pThis, PRUnichar * networkName);

    nsresult (*GetEnabled)(ICloudNetwork *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(ICloudNetwork *pThis, PRBool enabled);

    nsresult (*GetProvider)(ICloudNetwork *pThis, PRUnichar * *provider);
    nsresult (*SetProvider)(ICloudNetwork *pThis, PRUnichar * provider);

    nsresult (*GetProfile)(ICloudNetwork *pThis, PRUnichar * *profile);
    nsresult (*SetProfile)(ICloudNetwork *pThis, PRUnichar * profile);

    nsresult (*GetNetworkId)(ICloudNetwork *pThis, PRUnichar * *networkId);
    nsresult (*SetNetworkId)(ICloudNetwork *pThis, PRUnichar * networkId);

    nsresult (*GetInternalAndReservedAttribute1ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1ICloudNetwork)(ICloudNetwork *pThis);

    nsresult (*InternalAndReservedMethod2ICloudNetwork)(ICloudNetwork *pThis);

    nsresult (*InternalAndReservedMethod3ICloudNetwork)(ICloudNetwork *pThis);

    nsresult (*InternalAndReservedMethod4ICloudNetwork)(ICloudNetwork *pThis);

};
#else /* VBOX_WITH_GLUE */
struct ICloudNetworkVtbl
{
    nsresult (*QueryInterface)(ICloudNetwork *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(ICloudNetwork *pThis);
    nsrefcnt (*Release)(ICloudNetwork *pThis);
    nsresult (*GetNetworkName)(ICloudNetwork *pThis, PRUnichar * *networkName);
    nsresult (*SetNetworkName)(ICloudNetwork *pThis, PRUnichar * networkName);

    nsresult (*GetEnabled)(ICloudNetwork *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(ICloudNetwork *pThis, PRBool enabled);

    nsresult (*GetProvider)(ICloudNetwork *pThis, PRUnichar * *provider);
    nsresult (*SetProvider)(ICloudNetwork *pThis, PRUnichar * provider);

    nsresult (*GetProfile)(ICloudNetwork *pThis, PRUnichar * *profile);
    nsresult (*SetProfile)(ICloudNetwork *pThis, PRUnichar * profile);

    nsresult (*GetNetworkId)(ICloudNetwork *pThis, PRUnichar * *networkId);
    nsresult (*SetNetworkId)(ICloudNetwork *pThis, PRUnichar * networkId);

    nsresult (*GetInternalAndReservedAttribute1ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12ICloudNetwork)(ICloudNetwork *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1ICloudNetwork)(ICloudNetwork *pThis);

    nsresult (*InternalAndReservedMethod2ICloudNetwork)(ICloudNetwork *pThis);

    nsresult (*InternalAndReservedMethod3ICloudNetwork)(ICloudNetwork *pThis);

    nsresult (*InternalAndReservedMethod4ICloudNetwork)(ICloudNetwork *pThis);

};
#define ICloudNetwork_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define ICloudNetwork_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define ICloudNetwork_Release(p) ((p)->lpVtbl->Release(p))
#define ICloudNetwork_get_NetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define ICloudNetwork_GetNetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define ICloudNetwork_put_NetworkName(p, aNetworkName) ((p)->lpVtbl->SetNetworkName(p, aNetworkName))
#define ICloudNetwork_SetNetworkName(p, aNetworkName) ((p)->lpVtbl->SetNetworkName(p, aNetworkName))
#define ICloudNetwork_get_Enabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define ICloudNetwork_GetEnabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define ICloudNetwork_put_Enabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define ICloudNetwork_SetEnabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define ICloudNetwork_get_Provider(p, aProvider) ((p)->lpVtbl->GetProvider(p, aProvider))
#define ICloudNetwork_GetProvider(p, aProvider) ((p)->lpVtbl->GetProvider(p, aProvider))
#define ICloudNetwork_put_Provider(p, aProvider) ((p)->lpVtbl->SetProvider(p, aProvider))
#define ICloudNetwork_SetProvider(p, aProvider) ((p)->lpVtbl->SetProvider(p, aProvider))
#define ICloudNetwork_get_Profile(p, aProfile) ((p)->lpVtbl->GetProfile(p, aProfile))
#define ICloudNetwork_GetProfile(p, aProfile) ((p)->lpVtbl->GetProfile(p, aProfile))
#define ICloudNetwork_put_Profile(p, aProfile) ((p)->lpVtbl->SetProfile(p, aProfile))
#define ICloudNetwork_SetProfile(p, aProfile) ((p)->lpVtbl->SetProfile(p, aProfile))
#define ICloudNetwork_get_NetworkId(p, aNetworkId) ((p)->lpVtbl->GetNetworkId(p, aNetworkId))
#define ICloudNetwork_GetNetworkId(p, aNetworkId) ((p)->lpVtbl->GetNetworkId(p, aNetworkId))
#define ICloudNetwork_put_NetworkId(p, aNetworkId) ((p)->lpVtbl->SetNetworkId(p, aNetworkId))
#define ICloudNetwork_SetNetworkId(p, aNetworkId) ((p)->lpVtbl->SetNetworkId(p, aNetworkId))
#endif /* VBOX_WITH_GLUE */

interface ICloudNetwork
{
#ifndef VBOX_WITH_GLUE
    struct ICloudNetwork_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct ICloudNetworkVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct ICloudNetwork declaration */


/* Start of struct IHostOnlyNetwork declaration */
#define IHOSTONLYNETWORK_IID_STR "6eb5de7d-9a67-4fde-83be-f768084d03b5"
#define IHOSTONLYNETWORK_IID { \
    0x6eb5de7d, 0x9a67, 0x4fde, \
    { 0x83, 0xbe, 0xf7, 0x68, 0x08, 0x4d, 0x03, 0xb5 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IHostOnlyNetwork);
#ifndef VBOX_WITH_GLUE
struct IHostOnlyNetwork_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetNetworkName)(IHostOnlyNetwork *pThis, PRUnichar * *networkName);
    nsresult (*SetNetworkName)(IHostOnlyNetwork *pThis, PRUnichar * networkName);

    nsresult (*GetEnabled)(IHostOnlyNetwork *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IHostOnlyNetwork *pThis, PRBool enabled);

    nsresult (*GetNetworkMask)(IHostOnlyNetwork *pThis, PRUnichar * *networkMask);
    nsresult (*SetNetworkMask)(IHostOnlyNetwork *pThis, PRUnichar * networkMask);

    nsresult (*GetHostIP)(IHostOnlyNetwork *pThis, PRUnichar * *hostIP);

    nsresult (*GetLowerIP)(IHostOnlyNetwork *pThis, PRUnichar * *lowerIP);
    nsresult (*SetLowerIP)(IHostOnlyNetwork *pThis, PRUnichar * lowerIP);

    nsresult (*GetUpperIP)(IHostOnlyNetwork *pThis, PRUnichar * *upperIP);
    nsresult (*SetUpperIP)(IHostOnlyNetwork *pThis, PRUnichar * upperIP);

    nsresult (*GetId)(IHostOnlyNetwork *pThis, PRUnichar * *id);
    nsresult (*SetId)(IHostOnlyNetwork *pThis, PRUnichar * id);

    nsresult (*GetInternalAndReservedAttribute1IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IHostOnlyNetwork)(IHostOnlyNetwork *pThis);

    nsresult (*InternalAndReservedMethod2IHostOnlyNetwork)(IHostOnlyNetwork *pThis);

    nsresult (*InternalAndReservedMethod3IHostOnlyNetwork)(IHostOnlyNetwork *pThis);

    nsresult (*InternalAndReservedMethod4IHostOnlyNetwork)(IHostOnlyNetwork *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IHostOnlyNetworkVtbl
{
    nsresult (*QueryInterface)(IHostOnlyNetwork *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IHostOnlyNetwork *pThis);
    nsrefcnt (*Release)(IHostOnlyNetwork *pThis);
    nsresult (*GetNetworkName)(IHostOnlyNetwork *pThis, PRUnichar * *networkName);
    nsresult (*SetNetworkName)(IHostOnlyNetwork *pThis, PRUnichar * networkName);

    nsresult (*GetEnabled)(IHostOnlyNetwork *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IHostOnlyNetwork *pThis, PRBool enabled);

    nsresult (*GetNetworkMask)(IHostOnlyNetwork *pThis, PRUnichar * *networkMask);
    nsresult (*SetNetworkMask)(IHostOnlyNetwork *pThis, PRUnichar * networkMask);

    nsresult (*GetHostIP)(IHostOnlyNetwork *pThis, PRUnichar * *hostIP);

    nsresult (*GetLowerIP)(IHostOnlyNetwork *pThis, PRUnichar * *lowerIP);
    nsresult (*SetLowerIP)(IHostOnlyNetwork *pThis, PRUnichar * lowerIP);

    nsresult (*GetUpperIP)(IHostOnlyNetwork *pThis, PRUnichar * *upperIP);
    nsresult (*SetUpperIP)(IHostOnlyNetwork *pThis, PRUnichar * upperIP);

    nsresult (*GetId)(IHostOnlyNetwork *pThis, PRUnichar * *id);
    nsresult (*SetId)(IHostOnlyNetwork *pThis, PRUnichar * id);

    nsresult (*GetInternalAndReservedAttribute1IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IHostOnlyNetwork)(IHostOnlyNetwork *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IHostOnlyNetwork)(IHostOnlyNetwork *pThis);

    nsresult (*InternalAndReservedMethod2IHostOnlyNetwork)(IHostOnlyNetwork *pThis);

    nsresult (*InternalAndReservedMethod3IHostOnlyNetwork)(IHostOnlyNetwork *pThis);

    nsresult (*InternalAndReservedMethod4IHostOnlyNetwork)(IHostOnlyNetwork *pThis);

};
#define IHostOnlyNetwork_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IHostOnlyNetwork_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IHostOnlyNetwork_Release(p) ((p)->lpVtbl->Release(p))
#define IHostOnlyNetwork_get_NetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define IHostOnlyNetwork_GetNetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define IHostOnlyNetwork_put_NetworkName(p, aNetworkName) ((p)->lpVtbl->SetNetworkName(p, aNetworkName))
#define IHostOnlyNetwork_SetNetworkName(p, aNetworkName) ((p)->lpVtbl->SetNetworkName(p, aNetworkName))
#define IHostOnlyNetwork_get_Enabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IHostOnlyNetwork_GetEnabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IHostOnlyNetwork_put_Enabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IHostOnlyNetwork_SetEnabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IHostOnlyNetwork_get_NetworkMask(p, aNetworkMask) ((p)->lpVtbl->GetNetworkMask(p, aNetworkMask))
#define IHostOnlyNetwork_GetNetworkMask(p, aNetworkMask) ((p)->lpVtbl->GetNetworkMask(p, aNetworkMask))
#define IHostOnlyNetwork_put_NetworkMask(p, aNetworkMask) ((p)->lpVtbl->SetNetworkMask(p, aNetworkMask))
#define IHostOnlyNetwork_SetNetworkMask(p, aNetworkMask) ((p)->lpVtbl->SetNetworkMask(p, aNetworkMask))
#define IHostOnlyNetwork_get_HostIP(p, aHostIP) ((p)->lpVtbl->GetHostIP(p, aHostIP))
#define IHostOnlyNetwork_GetHostIP(p, aHostIP) ((p)->lpVtbl->GetHostIP(p, aHostIP))
#define IHostOnlyNetwork_get_LowerIP(p, aLowerIP) ((p)->lpVtbl->GetLowerIP(p, aLowerIP))
#define IHostOnlyNetwork_GetLowerIP(p, aLowerIP) ((p)->lpVtbl->GetLowerIP(p, aLowerIP))
#define IHostOnlyNetwork_put_LowerIP(p, aLowerIP) ((p)->lpVtbl->SetLowerIP(p, aLowerIP))
#define IHostOnlyNetwork_SetLowerIP(p, aLowerIP) ((p)->lpVtbl->SetLowerIP(p, aLowerIP))
#define IHostOnlyNetwork_get_UpperIP(p, aUpperIP) ((p)->lpVtbl->GetUpperIP(p, aUpperIP))
#define IHostOnlyNetwork_GetUpperIP(p, aUpperIP) ((p)->lpVtbl->GetUpperIP(p, aUpperIP))
#define IHostOnlyNetwork_put_UpperIP(p, aUpperIP) ((p)->lpVtbl->SetUpperIP(p, aUpperIP))
#define IHostOnlyNetwork_SetUpperIP(p, aUpperIP) ((p)->lpVtbl->SetUpperIP(p, aUpperIP))
#define IHostOnlyNetwork_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IHostOnlyNetwork_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IHostOnlyNetwork_put_Id(p, aId) ((p)->lpVtbl->SetId(p, aId))
#define IHostOnlyNetwork_SetId(p, aId) ((p)->lpVtbl->SetId(p, aId))
#endif /* VBOX_WITH_GLUE */

interface IHostOnlyNetwork
{
#ifndef VBOX_WITH_GLUE
    struct IHostOnlyNetwork_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IHostOnlyNetworkVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IHostOnlyNetwork declaration */


/* Start of struct IDHCPServer declaration */
#define IDHCPSERVER_IID_STR "cadef0a2-a1a9-4ac2-8e80-c049af69dac8"
#define IDHCPSERVER_IID { \
    0xcadef0a2, 0xa1a9, 0x4ac2, \
    { 0x8e, 0x80, 0xc0, 0x49, 0xaf, 0x69, 0xda, 0xc8 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDHCPServer);
#ifndef VBOX_WITH_GLUE
struct IDHCPServer_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetEventSource)(IDHCPServer *pThis, IEventSource * *eventSource);

    nsresult (*GetEnabled)(IDHCPServer *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IDHCPServer *pThis, PRBool enabled);

    nsresult (*GetIPAddress)(IDHCPServer *pThis, PRUnichar * *IPAddress);

    nsresult (*GetNetworkMask)(IDHCPServer *pThis, PRUnichar * *networkMask);

    nsresult (*GetNetworkName)(IDHCPServer *pThis, PRUnichar * *networkName);

    nsresult (*GetLowerIP)(IDHCPServer *pThis, PRUnichar * *lowerIP);

    nsresult (*GetUpperIP)(IDHCPServer *pThis, PRUnichar * *upperIP);

    nsresult (*GetGlobalConfig)(IDHCPServer *pThis, IDHCPGlobalConfig * *globalConfig);

    nsresult (*GetGroupConfigs)(IDHCPServer *pThis, PRUint32 *groupConfigsSize, IDHCPGroupConfig * **groupConfigs);

    nsresult (*GetIndividualConfigs)(IDHCPServer *pThis, PRUint32 *individualConfigsSize, IDHCPIndividualConfig * **individualConfigs);

    nsresult (*GetInternalAndReservedAttribute1IDHCPServer)(IDHCPServer *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPServer)(IDHCPServer *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPServer)(IDHCPServer *pThis, PRUint32 *reserved);

    nsresult (*SetConfiguration)(
        IDHCPServer *pThis,
        PRUnichar * IPAddress,
        PRUnichar * networkMask,
        PRUnichar * FromIPAddress,
        PRUnichar * ToIPAddress
    );

    nsresult (*Start)(
        IDHCPServer *pThis,
        PRUnichar * trunkName,
        PRUnichar * trunkType
    );

    nsresult (*Stop)(IDHCPServer *pThis );

    nsresult (*Restart)(IDHCPServer *pThis );

    nsresult (*FindLeaseByMAC)(
        IDHCPServer *pThis,
        PRUnichar * mac,
        PRInt32 type,
        PRUnichar * * address,
        PRUnichar * * state,
        PRInt64 * issued,
        PRInt64 * expire
    );

    nsresult (*GetConfig)(
        IDHCPServer *pThis,
        PRUint32 scope,
        PRUnichar * name,
        PRUint32 slot,
        PRBool mayAdd,
        IDHCPConfig * * config
    );

};
#else /* VBOX_WITH_GLUE */
struct IDHCPServerVtbl
{
    nsresult (*QueryInterface)(IDHCPServer *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDHCPServer *pThis);
    nsrefcnt (*Release)(IDHCPServer *pThis);
    nsresult (*GetEventSource)(IDHCPServer *pThis, IEventSource * *eventSource);

    nsresult (*GetEnabled)(IDHCPServer *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IDHCPServer *pThis, PRBool enabled);

    nsresult (*GetIPAddress)(IDHCPServer *pThis, PRUnichar * *IPAddress);

    nsresult (*GetNetworkMask)(IDHCPServer *pThis, PRUnichar * *networkMask);

    nsresult (*GetNetworkName)(IDHCPServer *pThis, PRUnichar * *networkName);

    nsresult (*GetLowerIP)(IDHCPServer *pThis, PRUnichar * *lowerIP);

    nsresult (*GetUpperIP)(IDHCPServer *pThis, PRUnichar * *upperIP);

    nsresult (*GetGlobalConfig)(IDHCPServer *pThis, IDHCPGlobalConfig * *globalConfig);

    nsresult (*GetGroupConfigs)(IDHCPServer *pThis, PRUint32 *groupConfigsSize, IDHCPGroupConfig * **groupConfigs);

    nsresult (*GetIndividualConfigs)(IDHCPServer *pThis, PRUint32 *individualConfigsSize, IDHCPIndividualConfig * **individualConfigs);

    nsresult (*GetInternalAndReservedAttribute1IDHCPServer)(IDHCPServer *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPServer)(IDHCPServer *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPServer)(IDHCPServer *pThis, PRUint32 *reserved);

    nsresult (*SetConfiguration)(
        IDHCPServer *pThis,
        PRUnichar * IPAddress,
        PRUnichar * networkMask,
        PRUnichar * FromIPAddress,
        PRUnichar * ToIPAddress
    );

    nsresult (*Start)(
        IDHCPServer *pThis,
        PRUnichar * trunkName,
        PRUnichar * trunkType
    );

    nsresult (*Stop)(IDHCPServer *pThis );

    nsresult (*Restart)(IDHCPServer *pThis );

    nsresult (*FindLeaseByMAC)(
        IDHCPServer *pThis,
        PRUnichar * mac,
        PRInt32 type,
        PRUnichar * * address,
        PRUnichar * * state,
        PRInt64 * issued,
        PRInt64 * expire
    );

    nsresult (*GetConfig)(
        IDHCPServer *pThis,
        PRUint32 scope,
        PRUnichar * name,
        PRUint32 slot,
        PRBool mayAdd,
        IDHCPConfig * * config
    );

};
#define IDHCPServer_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDHCPServer_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDHCPServer_Release(p) ((p)->lpVtbl->Release(p))
#define IDHCPServer_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IDHCPServer_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IDHCPServer_get_Enabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IDHCPServer_GetEnabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IDHCPServer_put_Enabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IDHCPServer_SetEnabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IDHCPServer_get_IPAddress(p, aIPAddress) ((p)->lpVtbl->GetIPAddress(p, aIPAddress))
#define IDHCPServer_GetIPAddress(p, aIPAddress) ((p)->lpVtbl->GetIPAddress(p, aIPAddress))
#define IDHCPServer_get_NetworkMask(p, aNetworkMask) ((p)->lpVtbl->GetNetworkMask(p, aNetworkMask))
#define IDHCPServer_GetNetworkMask(p, aNetworkMask) ((p)->lpVtbl->GetNetworkMask(p, aNetworkMask))
#define IDHCPServer_get_NetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define IDHCPServer_GetNetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define IDHCPServer_get_LowerIP(p, aLowerIP) ((p)->lpVtbl->GetLowerIP(p, aLowerIP))
#define IDHCPServer_GetLowerIP(p, aLowerIP) ((p)->lpVtbl->GetLowerIP(p, aLowerIP))
#define IDHCPServer_get_UpperIP(p, aUpperIP) ((p)->lpVtbl->GetUpperIP(p, aUpperIP))
#define IDHCPServer_GetUpperIP(p, aUpperIP) ((p)->lpVtbl->GetUpperIP(p, aUpperIP))
#define IDHCPServer_get_GlobalConfig(p, aGlobalConfig) ((p)->lpVtbl->GetGlobalConfig(p, aGlobalConfig))
#define IDHCPServer_GetGlobalConfig(p, aGlobalConfig) ((p)->lpVtbl->GetGlobalConfig(p, aGlobalConfig))
#define IDHCPServer_get_GroupConfigs(p, aGroupConfigs) ((p)->lpVtbl->GetGroupConfigs(p, aGroupConfigs))
#define IDHCPServer_GetGroupConfigs(p, aGroupConfigs) ((p)->lpVtbl->GetGroupConfigs(p, aGroupConfigs))
#define IDHCPServer_get_IndividualConfigs(p, aIndividualConfigs) ((p)->lpVtbl->GetIndividualConfigs(p, aIndividualConfigs))
#define IDHCPServer_GetIndividualConfigs(p, aIndividualConfigs) ((p)->lpVtbl->GetIndividualConfigs(p, aIndividualConfigs))
#define IDHCPServer_SetConfiguration(p, aIPAddress, aNetworkMask, aFromIPAddress, aToIPAddress) ((p)->lpVtbl->SetConfiguration(p, aIPAddress, aNetworkMask, aFromIPAddress, aToIPAddress))
#define IDHCPServer_Start(p, aTrunkName, aTrunkType) ((p)->lpVtbl->Start(p, aTrunkName, aTrunkType))
#define IDHCPServer_Stop(p) ((p)->lpVtbl->Stop(p))
#define IDHCPServer_Restart(p) ((p)->lpVtbl->Restart(p))
#define IDHCPServer_FindLeaseByMAC(p, aMac, aType, aAddress, aState, aIssued, aExpire) ((p)->lpVtbl->FindLeaseByMAC(p, aMac, aType, aAddress, aState, aIssued, aExpire))
#define IDHCPServer_GetConfig(p, aScope, aName, aSlot, aMayAdd, aConfig) ((p)->lpVtbl->GetConfig(p, aScope, aName, aSlot, aMayAdd, aConfig))
#endif /* VBOX_WITH_GLUE */

interface IDHCPServer
{
#ifndef VBOX_WITH_GLUE
    struct IDHCPServer_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDHCPServerVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDHCPServer declaration */


/* Start of struct IDHCPConfig declaration */
#define IDHCPCONFIG_IID_STR "00f4a8dc-0002-4b81-0077-1dcb004571ba"
#define IDHCPCONFIG_IID { \
    0x00f4a8dc, 0x0002, 0x4b81, \
    { 0x00, 0x77, 0x1d, 0xcb, 0x00, 0x45, 0x71, 0xba } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDHCPConfig);
#ifndef VBOX_WITH_GLUE
struct IDHCPConfig_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetScope)(IDHCPConfig *pThis, PRUint32 *scope);

    nsresult (*GetMinLeaseTime)(IDHCPConfig *pThis, PRUint32 *minLeaseTime);
    nsresult (*SetMinLeaseTime)(IDHCPConfig *pThis, PRUint32 minLeaseTime);

    nsresult (*GetDefaultLeaseTime)(IDHCPConfig *pThis, PRUint32 *defaultLeaseTime);
    nsresult (*SetDefaultLeaseTime)(IDHCPConfig *pThis, PRUint32 defaultLeaseTime);

    nsresult (*GetMaxLeaseTime)(IDHCPConfig *pThis, PRUint32 *maxLeaseTime);
    nsresult (*SetMaxLeaseTime)(IDHCPConfig *pThis, PRUint32 maxLeaseTime);

    nsresult (*GetForcedOptions)(IDHCPConfig *pThis, PRUint32 *forcedOptionsSize, PRUint32 **forcedOptions);
    nsresult (*SetForcedOptions)(IDHCPConfig *pThis, PRUint32 forcedOptionsSize, PRUint32 *forcedOptions);

    nsresult (*GetSuppressedOptions)(IDHCPConfig *pThis, PRUint32 *suppressedOptionsSize, PRUint32 **suppressedOptions);
    nsresult (*SetSuppressedOptions)(IDHCPConfig *pThis, PRUint32 suppressedOptionsSize, PRUint32 *suppressedOptions);

    nsresult (*GetInternalAndReservedAttribute1IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*SetOption)(
        IDHCPConfig *pThis,
        PRUint32 option,
        PRUint32 encoding,
        PRUnichar * value
    );

    nsresult (*RemoveOption)(
        IDHCPConfig *pThis,
        PRUint32 option
    );

    nsresult (*RemoveAllOptions)(IDHCPConfig *pThis );

    nsresult (*GetOption)(
        IDHCPConfig *pThis,
        PRUint32 option,
        PRUint32 * encoding,
        PRUnichar * * value
    );

    nsresult (*GetAllOptions)(
        IDHCPConfig *pThis,
        PRUint32 *optionsSize,
        PRUint32** options,
        PRUint32 *encodingsSize,
        PRUint32** encodings,
        PRUint32 *valuesSize,
        PRUnichar *** values
    );

    nsresult (*Remove)(IDHCPConfig *pThis );

    nsresult (*InternalAndReservedMethod1IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod5IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod6IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod7IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod8IDHCPConfig)(IDHCPConfig *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDHCPConfigVtbl
{
    nsresult (*QueryInterface)(IDHCPConfig *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDHCPConfig *pThis);
    nsrefcnt (*Release)(IDHCPConfig *pThis);
    nsresult (*GetScope)(IDHCPConfig *pThis, PRUint32 *scope);

    nsresult (*GetMinLeaseTime)(IDHCPConfig *pThis, PRUint32 *minLeaseTime);
    nsresult (*SetMinLeaseTime)(IDHCPConfig *pThis, PRUint32 minLeaseTime);

    nsresult (*GetDefaultLeaseTime)(IDHCPConfig *pThis, PRUint32 *defaultLeaseTime);
    nsresult (*SetDefaultLeaseTime)(IDHCPConfig *pThis, PRUint32 defaultLeaseTime);

    nsresult (*GetMaxLeaseTime)(IDHCPConfig *pThis, PRUint32 *maxLeaseTime);
    nsresult (*SetMaxLeaseTime)(IDHCPConfig *pThis, PRUint32 maxLeaseTime);

    nsresult (*GetForcedOptions)(IDHCPConfig *pThis, PRUint32 *forcedOptionsSize, PRUint32 **forcedOptions);
    nsresult (*SetForcedOptions)(IDHCPConfig *pThis, PRUint32 forcedOptionsSize, PRUint32 *forcedOptions);

    nsresult (*GetSuppressedOptions)(IDHCPConfig *pThis, PRUint32 *suppressedOptionsSize, PRUint32 **suppressedOptions);
    nsresult (*SetSuppressedOptions)(IDHCPConfig *pThis, PRUint32 suppressedOptionsSize, PRUint32 *suppressedOptions);

    nsresult (*GetInternalAndReservedAttribute1IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IDHCPConfig)(IDHCPConfig *pThis, PRUint32 *reserved);

    nsresult (*SetOption)(
        IDHCPConfig *pThis,
        PRUint32 option,
        PRUint32 encoding,
        PRUnichar * value
    );

    nsresult (*RemoveOption)(
        IDHCPConfig *pThis,
        PRUint32 option
    );

    nsresult (*RemoveAllOptions)(IDHCPConfig *pThis );

    nsresult (*GetOption)(
        IDHCPConfig *pThis,
        PRUint32 option,
        PRUint32 * encoding,
        PRUnichar * * value
    );

    nsresult (*GetAllOptions)(
        IDHCPConfig *pThis,
        PRUint32 *optionsSize,
        PRUint32** options,
        PRUint32 *encodingsSize,
        PRUint32** encodings,
        PRUint32 *valuesSize,
        PRUnichar *** values
    );

    nsresult (*Remove)(IDHCPConfig *pThis );

    nsresult (*InternalAndReservedMethod1IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod5IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod6IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod7IDHCPConfig)(IDHCPConfig *pThis);

    nsresult (*InternalAndReservedMethod8IDHCPConfig)(IDHCPConfig *pThis);

};
#define IDHCPConfig_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDHCPConfig_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDHCPConfig_Release(p) ((p)->lpVtbl->Release(p))
#define IDHCPConfig_get_Scope(p, aScope) ((p)->lpVtbl->GetScope(p, aScope))
#define IDHCPConfig_GetScope(p, aScope) ((p)->lpVtbl->GetScope(p, aScope))
#define IDHCPConfig_get_MinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->GetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPConfig_GetMinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->GetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPConfig_put_MinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->SetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPConfig_SetMinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->SetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPConfig_get_DefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->GetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPConfig_GetDefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->GetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPConfig_put_DefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->SetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPConfig_SetDefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->SetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPConfig_get_MaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->GetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPConfig_GetMaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->GetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPConfig_put_MaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->SetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPConfig_SetMaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->SetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPConfig_get_ForcedOptions(p, aForcedOptions) ((p)->lpVtbl->GetForcedOptions(p, aForcedOptions))
#define IDHCPConfig_GetForcedOptions(p, aForcedOptions) ((p)->lpVtbl->GetForcedOptions(p, aForcedOptions))
#define IDHCPConfig_put_ForcedOptions(p, aForcedOptions) ((p)->lpVtbl->SetForcedOptions(p, aForcedOptions))
#define IDHCPConfig_SetForcedOptions(p, aForcedOptions) ((p)->lpVtbl->SetForcedOptions(p, aForcedOptions))
#define IDHCPConfig_get_SuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->GetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPConfig_GetSuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->GetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPConfig_put_SuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->SetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPConfig_SetSuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->SetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPConfig_SetOption(p, aOption, aEncoding, aValue) ((p)->lpVtbl->SetOption(p, aOption, aEncoding, aValue))
#define IDHCPConfig_RemoveOption(p, aOption) ((p)->lpVtbl->RemoveOption(p, aOption))
#define IDHCPConfig_RemoveAllOptions(p) ((p)->lpVtbl->RemoveAllOptions(p))
#define IDHCPConfig_GetOption(p, aOption, aEncoding, aValue) ((p)->lpVtbl->GetOption(p, aOption, aEncoding, aValue))
#define IDHCPConfig_GetAllOptions(p, aOptions, aEncodings, aValues) ((p)->lpVtbl->GetAllOptions(p, aOptions, aEncodings, aValues))
#define IDHCPConfig_Remove(p) ((p)->lpVtbl->Remove(p))
#endif /* VBOX_WITH_GLUE */

interface IDHCPConfig
{
#ifndef VBOX_WITH_GLUE
    struct IDHCPConfig_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDHCPConfigVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDHCPConfig declaration */


/* Start of struct IDHCPGlobalConfig declaration */
#define IDHCPGLOBALCONFIG_IID_STR "46735de7-f4c4-4020-a185-0d2881bcfa8b"
#define IDHCPGLOBALCONFIG_IID { \
    0x46735de7, 0xf4c4, 0x4020, \
    { 0xa1, 0x85, 0x0d, 0x28, 0x81, 0xbc, 0xfa, 0x8b } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDHCPGlobalConfig);
#ifndef VBOX_WITH_GLUE
struct IDHCPGlobalConfig_vtbl
{
    struct IDHCPConfig_vtbl idhcpconfig;

    nsresult (*GetInternalAndReservedAttribute1IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDHCPGlobalConfigVtbl
{
    nsresult (*QueryInterface)(IDHCPGlobalConfig *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDHCPGlobalConfig *pThis);
    nsrefcnt (*Release)(IDHCPGlobalConfig *pThis);
    nsresult (*GetScope)(IDHCPGlobalConfig *pThis, PRUint32 *scope);

    nsresult (*GetMinLeaseTime)(IDHCPGlobalConfig *pThis, PRUint32 *minLeaseTime);
    nsresult (*SetMinLeaseTime)(IDHCPGlobalConfig *pThis, PRUint32 minLeaseTime);

    nsresult (*GetDefaultLeaseTime)(IDHCPGlobalConfig *pThis, PRUint32 *defaultLeaseTime);
    nsresult (*SetDefaultLeaseTime)(IDHCPGlobalConfig *pThis, PRUint32 defaultLeaseTime);

    nsresult (*GetMaxLeaseTime)(IDHCPGlobalConfig *pThis, PRUint32 *maxLeaseTime);
    nsresult (*SetMaxLeaseTime)(IDHCPGlobalConfig *pThis, PRUint32 maxLeaseTime);

    nsresult (*GetForcedOptions)(IDHCPGlobalConfig *pThis, PRUint32 *forcedOptionsSize, PRUint32 **forcedOptions);
    nsresult (*SetForcedOptions)(IDHCPGlobalConfig *pThis, PRUint32 forcedOptionsSize, PRUint32 *forcedOptions);

    nsresult (*GetSuppressedOptions)(IDHCPGlobalConfig *pThis, PRUint32 *suppressedOptionsSize, PRUint32 **suppressedOptions);
    nsresult (*SetSuppressedOptions)(IDHCPGlobalConfig *pThis, PRUint32 suppressedOptionsSize, PRUint32 *suppressedOptions);

    nsresult (*GetInternalAndReservedAttribute1IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IDHCPConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*SetOption)(
        IDHCPGlobalConfig *pThis,
        PRUint32 option,
        PRUint32 encoding,
        PRUnichar * value
    );

    nsresult (*RemoveOption)(
        IDHCPGlobalConfig *pThis,
        PRUint32 option
    );

    nsresult (*RemoveAllOptions)(IDHCPGlobalConfig *pThis );

    nsresult (*GetOption)(
        IDHCPGlobalConfig *pThis,
        PRUint32 option,
        PRUint32 * encoding,
        PRUnichar * * value
    );

    nsresult (*GetAllOptions)(
        IDHCPGlobalConfig *pThis,
        PRUint32 *optionsSize,
        PRUint32** options,
        PRUint32 *encodingsSize,
        PRUint32** encodings,
        PRUint32 *valuesSize,
        PRUnichar *** values
    );

    nsresult (*Remove)(IDHCPGlobalConfig *pThis );

    nsresult (*InternalAndReservedMethod1IDHCPConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod5IDHCPConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod6IDHCPConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod7IDHCPConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod8IDHCPConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*GetInternalAndReservedAttribute1IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPGlobalConfig)(IDHCPGlobalConfig *pThis);

};
#define IDHCPGlobalConfig_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDHCPGlobalConfig_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDHCPGlobalConfig_Release(p) ((p)->lpVtbl->Release(p))
#define IDHCPGlobalConfig_get_Scope(p, aScope) ((p)->lpVtbl->GetScope(p, aScope))
#define IDHCPGlobalConfig_GetScope(p, aScope) ((p)->lpVtbl->GetScope(p, aScope))
#define IDHCPGlobalConfig_get_MinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->GetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPGlobalConfig_GetMinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->GetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPGlobalConfig_put_MinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->SetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPGlobalConfig_SetMinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->SetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPGlobalConfig_get_DefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->GetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPGlobalConfig_GetDefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->GetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPGlobalConfig_put_DefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->SetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPGlobalConfig_SetDefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->SetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPGlobalConfig_get_MaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->GetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPGlobalConfig_GetMaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->GetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPGlobalConfig_put_MaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->SetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPGlobalConfig_SetMaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->SetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPGlobalConfig_get_ForcedOptions(p, aForcedOptions) ((p)->lpVtbl->GetForcedOptions(p, aForcedOptions))
#define IDHCPGlobalConfig_GetForcedOptions(p, aForcedOptions) ((p)->lpVtbl->GetForcedOptions(p, aForcedOptions))
#define IDHCPGlobalConfig_put_ForcedOptions(p, aForcedOptions) ((p)->lpVtbl->SetForcedOptions(p, aForcedOptions))
#define IDHCPGlobalConfig_SetForcedOptions(p, aForcedOptions) ((p)->lpVtbl->SetForcedOptions(p, aForcedOptions))
#define IDHCPGlobalConfig_get_SuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->GetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPGlobalConfig_GetSuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->GetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPGlobalConfig_put_SuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->SetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPGlobalConfig_SetSuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->SetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPGlobalConfig_SetOption(p, aOption, aEncoding, aValue) ((p)->lpVtbl->SetOption(p, aOption, aEncoding, aValue))
#define IDHCPGlobalConfig_RemoveOption(p, aOption) ((p)->lpVtbl->RemoveOption(p, aOption))
#define IDHCPGlobalConfig_RemoveAllOptions(p) ((p)->lpVtbl->RemoveAllOptions(p))
#define IDHCPGlobalConfig_GetOption(p, aOption, aEncoding, aValue) ((p)->lpVtbl->GetOption(p, aOption, aEncoding, aValue))
#define IDHCPGlobalConfig_GetAllOptions(p, aOptions, aEncodings, aValues) ((p)->lpVtbl->GetAllOptions(p, aOptions, aEncodings, aValues))
#define IDHCPGlobalConfig_Remove(p) ((p)->lpVtbl->Remove(p))
#endif /* VBOX_WITH_GLUE */

interface IDHCPGlobalConfig
{
#ifndef VBOX_WITH_GLUE
    struct IDHCPGlobalConfig_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDHCPGlobalConfigVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDHCPGlobalConfig declaration */


/* Start of struct IDHCPGroupCondition declaration */
#define IDHCPGROUPCONDITION_IID_STR "5ca9e537-5a1d-43f1-6f27-6a0db298a9a8"
#define IDHCPGROUPCONDITION_IID { \
    0x5ca9e537, 0x5a1d, 0x43f1, \
    { 0x6f, 0x27, 0x6a, 0x0d, 0xb2, 0x98, 0xa9, 0xa8 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDHCPGroupCondition);
#ifndef VBOX_WITH_GLUE
struct IDHCPGroupCondition_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetInclusive)(IDHCPGroupCondition *pThis, PRBool *inclusive);
    nsresult (*SetInclusive)(IDHCPGroupCondition *pThis, PRBool inclusive);

    nsresult (*GetType)(IDHCPGroupCondition *pThis, PRUint32 *type);
    nsresult (*SetType)(IDHCPGroupCondition *pThis, PRUint32 type);

    nsresult (*GetValue)(IDHCPGroupCondition *pThis, PRUnichar * *value);
    nsresult (*SetValue)(IDHCPGroupCondition *pThis, PRUnichar * value);

    nsresult (*GetInternalAndReservedAttribute1IDHCPGroupCondition)(IDHCPGroupCondition *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPGroupCondition)(IDHCPGroupCondition *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPGroupCondition)(IDHCPGroupCondition *pThis, PRUint32 *reserved);

    nsresult (*Remove)(IDHCPGroupCondition *pThis );

    nsresult (*InternalAndReservedMethod1IDHCPGroupCondition)(IDHCPGroupCondition *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPGroupCondition)(IDHCPGroupCondition *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPGroupCondition)(IDHCPGroupCondition *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDHCPGroupConditionVtbl
{
    nsresult (*QueryInterface)(IDHCPGroupCondition *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDHCPGroupCondition *pThis);
    nsrefcnt (*Release)(IDHCPGroupCondition *pThis);
    nsresult (*GetInclusive)(IDHCPGroupCondition *pThis, PRBool *inclusive);
    nsresult (*SetInclusive)(IDHCPGroupCondition *pThis, PRBool inclusive);

    nsresult (*GetType)(IDHCPGroupCondition *pThis, PRUint32 *type);
    nsresult (*SetType)(IDHCPGroupCondition *pThis, PRUint32 type);

    nsresult (*GetValue)(IDHCPGroupCondition *pThis, PRUnichar * *value);
    nsresult (*SetValue)(IDHCPGroupCondition *pThis, PRUnichar * value);

    nsresult (*GetInternalAndReservedAttribute1IDHCPGroupCondition)(IDHCPGroupCondition *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPGroupCondition)(IDHCPGroupCondition *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPGroupCondition)(IDHCPGroupCondition *pThis, PRUint32 *reserved);

    nsresult (*Remove)(IDHCPGroupCondition *pThis );

    nsresult (*InternalAndReservedMethod1IDHCPGroupCondition)(IDHCPGroupCondition *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPGroupCondition)(IDHCPGroupCondition *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPGroupCondition)(IDHCPGroupCondition *pThis);

};
#define IDHCPGroupCondition_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDHCPGroupCondition_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDHCPGroupCondition_Release(p) ((p)->lpVtbl->Release(p))
#define IDHCPGroupCondition_get_Inclusive(p, aInclusive) ((p)->lpVtbl->GetInclusive(p, aInclusive))
#define IDHCPGroupCondition_GetInclusive(p, aInclusive) ((p)->lpVtbl->GetInclusive(p, aInclusive))
#define IDHCPGroupCondition_put_Inclusive(p, aInclusive) ((p)->lpVtbl->SetInclusive(p, aInclusive))
#define IDHCPGroupCondition_SetInclusive(p, aInclusive) ((p)->lpVtbl->SetInclusive(p, aInclusive))
#define IDHCPGroupCondition_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IDHCPGroupCondition_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IDHCPGroupCondition_put_Type(p, aType) ((p)->lpVtbl->SetType(p, aType))
#define IDHCPGroupCondition_SetType(p, aType) ((p)->lpVtbl->SetType(p, aType))
#define IDHCPGroupCondition_get_Value(p, aValue) ((p)->lpVtbl->GetValue(p, aValue))
#define IDHCPGroupCondition_GetValue(p, aValue) ((p)->lpVtbl->GetValue(p, aValue))
#define IDHCPGroupCondition_put_Value(p, aValue) ((p)->lpVtbl->SetValue(p, aValue))
#define IDHCPGroupCondition_SetValue(p, aValue) ((p)->lpVtbl->SetValue(p, aValue))
#define IDHCPGroupCondition_Remove(p) ((p)->lpVtbl->Remove(p))
#endif /* VBOX_WITH_GLUE */

interface IDHCPGroupCondition
{
#ifndef VBOX_WITH_GLUE
    struct IDHCPGroupCondition_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDHCPGroupConditionVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDHCPGroupCondition declaration */


/* Start of struct IDHCPGroupConfig declaration */
#define IDHCPGROUPCONFIG_IID_STR "537707f7-ebf9-4d5c-7aea-877bfc4256ba"
#define IDHCPGROUPCONFIG_IID { \
    0x537707f7, 0xebf9, 0x4d5c, \
    { 0x7a, 0xea, 0x87, 0x7b, 0xfc, 0x42, 0x56, 0xba } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDHCPGroupConfig);
#ifndef VBOX_WITH_GLUE
struct IDHCPGroupConfig_vtbl
{
    struct IDHCPConfig_vtbl idhcpconfig;

    nsresult (*GetName)(IDHCPGroupConfig *pThis, PRUnichar * *name);
    nsresult (*SetName)(IDHCPGroupConfig *pThis, PRUnichar * name);

    nsresult (*GetConditions)(IDHCPGroupConfig *pThis, PRUint32 *conditionsSize, IDHCPGroupCondition * **conditions);

    nsresult (*GetInternalAndReservedAttribute1IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*AddCondition)(
        IDHCPGroupConfig *pThis,
        PRBool inclusive,
        PRUint32 type,
        PRUnichar * value,
        IDHCPGroupCondition * * condition
    );

    nsresult (*RemoveAllConditions)(IDHCPGroupConfig *pThis );

    nsresult (*InternalAndReservedMethod1IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod5IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod6IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod7IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod8IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDHCPGroupConfigVtbl
{
    nsresult (*QueryInterface)(IDHCPGroupConfig *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDHCPGroupConfig *pThis);
    nsrefcnt (*Release)(IDHCPGroupConfig *pThis);
    nsresult (*GetScope)(IDHCPGroupConfig *pThis, PRUint32 *scope);

    nsresult (*GetMinLeaseTime)(IDHCPGroupConfig *pThis, PRUint32 *minLeaseTime);
    nsresult (*SetMinLeaseTime)(IDHCPGroupConfig *pThis, PRUint32 minLeaseTime);

    nsresult (*GetDefaultLeaseTime)(IDHCPGroupConfig *pThis, PRUint32 *defaultLeaseTime);
    nsresult (*SetDefaultLeaseTime)(IDHCPGroupConfig *pThis, PRUint32 defaultLeaseTime);

    nsresult (*GetMaxLeaseTime)(IDHCPGroupConfig *pThis, PRUint32 *maxLeaseTime);
    nsresult (*SetMaxLeaseTime)(IDHCPGroupConfig *pThis, PRUint32 maxLeaseTime);

    nsresult (*GetForcedOptions)(IDHCPGroupConfig *pThis, PRUint32 *forcedOptionsSize, PRUint32 **forcedOptions);
    nsresult (*SetForcedOptions)(IDHCPGroupConfig *pThis, PRUint32 forcedOptionsSize, PRUint32 *forcedOptions);

    nsresult (*GetSuppressedOptions)(IDHCPGroupConfig *pThis, PRUint32 *suppressedOptionsSize, PRUint32 **suppressedOptions);
    nsresult (*SetSuppressedOptions)(IDHCPGroupConfig *pThis, PRUint32 suppressedOptionsSize, PRUint32 *suppressedOptions);

    nsresult (*GetInternalAndReservedAttribute1IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IDHCPConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*SetOption)(
        IDHCPGroupConfig *pThis,
        PRUint32 option,
        PRUint32 encoding,
        PRUnichar * value
    );

    nsresult (*RemoveOption)(
        IDHCPGroupConfig *pThis,
        PRUint32 option
    );

    nsresult (*RemoveAllOptions)(IDHCPGroupConfig *pThis );

    nsresult (*GetOption)(
        IDHCPGroupConfig *pThis,
        PRUint32 option,
        PRUint32 * encoding,
        PRUnichar * * value
    );

    nsresult (*GetAllOptions)(
        IDHCPGroupConfig *pThis,
        PRUint32 *optionsSize,
        PRUint32** options,
        PRUint32 *encodingsSize,
        PRUint32** encodings,
        PRUint32 *valuesSize,
        PRUnichar *** values
    );

    nsresult (*Remove)(IDHCPGroupConfig *pThis );

    nsresult (*InternalAndReservedMethod1IDHCPConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod5IDHCPConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod6IDHCPConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod7IDHCPConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod8IDHCPConfig)(IDHCPGroupConfig *pThis);

    nsresult (*GetName)(IDHCPGroupConfig *pThis, PRUnichar * *name);
    nsresult (*SetName)(IDHCPGroupConfig *pThis, PRUnichar * name);

    nsresult (*GetConditions)(IDHCPGroupConfig *pThis, PRUint32 *conditionsSize, IDHCPGroupCondition * **conditions);

    nsresult (*GetInternalAndReservedAttribute1IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDHCPGroupConfig)(IDHCPGroupConfig *pThis, PRUint32 *reserved);

    nsresult (*AddCondition)(
        IDHCPGroupConfig *pThis,
        PRBool inclusive,
        PRUint32 type,
        PRUnichar * value,
        IDHCPGroupCondition * * condition
    );

    nsresult (*RemoveAllConditions)(IDHCPGroupConfig *pThis );

    nsresult (*InternalAndReservedMethod1IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod5IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod6IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod7IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

    nsresult (*InternalAndReservedMethod8IDHCPGroupConfig)(IDHCPGroupConfig *pThis);

};
#define IDHCPGroupConfig_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDHCPGroupConfig_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDHCPGroupConfig_Release(p) ((p)->lpVtbl->Release(p))
#define IDHCPGroupConfig_get_Scope(p, aScope) ((p)->lpVtbl->GetScope(p, aScope))
#define IDHCPGroupConfig_GetScope(p, aScope) ((p)->lpVtbl->GetScope(p, aScope))
#define IDHCPGroupConfig_get_MinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->GetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPGroupConfig_GetMinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->GetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPGroupConfig_put_MinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->SetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPGroupConfig_SetMinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->SetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPGroupConfig_get_DefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->GetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPGroupConfig_GetDefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->GetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPGroupConfig_put_DefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->SetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPGroupConfig_SetDefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->SetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPGroupConfig_get_MaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->GetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPGroupConfig_GetMaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->GetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPGroupConfig_put_MaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->SetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPGroupConfig_SetMaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->SetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPGroupConfig_get_ForcedOptions(p, aForcedOptions) ((p)->lpVtbl->GetForcedOptions(p, aForcedOptions))
#define IDHCPGroupConfig_GetForcedOptions(p, aForcedOptions) ((p)->lpVtbl->GetForcedOptions(p, aForcedOptions))
#define IDHCPGroupConfig_put_ForcedOptions(p, aForcedOptions) ((p)->lpVtbl->SetForcedOptions(p, aForcedOptions))
#define IDHCPGroupConfig_SetForcedOptions(p, aForcedOptions) ((p)->lpVtbl->SetForcedOptions(p, aForcedOptions))
#define IDHCPGroupConfig_get_SuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->GetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPGroupConfig_GetSuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->GetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPGroupConfig_put_SuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->SetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPGroupConfig_SetSuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->SetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPGroupConfig_SetOption(p, aOption, aEncoding, aValue) ((p)->lpVtbl->SetOption(p, aOption, aEncoding, aValue))
#define IDHCPGroupConfig_RemoveOption(p, aOption) ((p)->lpVtbl->RemoveOption(p, aOption))
#define IDHCPGroupConfig_RemoveAllOptions(p) ((p)->lpVtbl->RemoveAllOptions(p))
#define IDHCPGroupConfig_GetOption(p, aOption, aEncoding, aValue) ((p)->lpVtbl->GetOption(p, aOption, aEncoding, aValue))
#define IDHCPGroupConfig_GetAllOptions(p, aOptions, aEncodings, aValues) ((p)->lpVtbl->GetAllOptions(p, aOptions, aEncodings, aValues))
#define IDHCPGroupConfig_Remove(p) ((p)->lpVtbl->Remove(p))
#define IDHCPGroupConfig_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IDHCPGroupConfig_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IDHCPGroupConfig_put_Name(p, aName) ((p)->lpVtbl->SetName(p, aName))
#define IDHCPGroupConfig_SetName(p, aName) ((p)->lpVtbl->SetName(p, aName))
#define IDHCPGroupConfig_get_Conditions(p, aConditions) ((p)->lpVtbl->GetConditions(p, aConditions))
#define IDHCPGroupConfig_GetConditions(p, aConditions) ((p)->lpVtbl->GetConditions(p, aConditions))
#define IDHCPGroupConfig_AddCondition(p, aInclusive, aType, aValue, aCondition) ((p)->lpVtbl->AddCondition(p, aInclusive, aType, aValue, aCondition))
#define IDHCPGroupConfig_RemoveAllConditions(p) ((p)->lpVtbl->RemoveAllConditions(p))
#endif /* VBOX_WITH_GLUE */

interface IDHCPGroupConfig
{
#ifndef VBOX_WITH_GLUE
    struct IDHCPGroupConfig_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDHCPGroupConfigVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDHCPGroupConfig declaration */


/* Start of struct IDHCPIndividualConfig declaration */
#define IDHCPINDIVIDUALCONFIG_IID_STR "c40c2b86-73a5-46cc-8227-93fe57d006a6"
#define IDHCPINDIVIDUALCONFIG_IID { \
    0xc40c2b86, 0x73a5, 0x46cc, \
    { 0x82, 0x27, 0x93, 0xfe, 0x57, 0xd0, 0x06, 0xa6 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDHCPIndividualConfig);
#ifndef VBOX_WITH_GLUE
struct IDHCPIndividualConfig_vtbl
{
    struct IDHCPConfig_vtbl idhcpconfig;

    nsresult (*GetMACAddress)(IDHCPIndividualConfig *pThis, PRUnichar * *MACAddress);

    nsresult (*GetMachineId)(IDHCPIndividualConfig *pThis, PRUnichar * *machineId);

    nsresult (*GetSlot)(IDHCPIndividualConfig *pThis, PRUint32 *slot);

    nsresult (*GetFixedAddress)(IDHCPIndividualConfig *pThis, PRUnichar * *fixedAddress);
    nsresult (*SetFixedAddress)(IDHCPIndividualConfig *pThis, PRUnichar * fixedAddress);

    nsresult (*GetInternalAndReservedAttribute1IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod5IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod6IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod7IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod8IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDHCPIndividualConfigVtbl
{
    nsresult (*QueryInterface)(IDHCPIndividualConfig *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDHCPIndividualConfig *pThis);
    nsrefcnt (*Release)(IDHCPIndividualConfig *pThis);
    nsresult (*GetScope)(IDHCPIndividualConfig *pThis, PRUint32 *scope);

    nsresult (*GetMinLeaseTime)(IDHCPIndividualConfig *pThis, PRUint32 *minLeaseTime);
    nsresult (*SetMinLeaseTime)(IDHCPIndividualConfig *pThis, PRUint32 minLeaseTime);

    nsresult (*GetDefaultLeaseTime)(IDHCPIndividualConfig *pThis, PRUint32 *defaultLeaseTime);
    nsresult (*SetDefaultLeaseTime)(IDHCPIndividualConfig *pThis, PRUint32 defaultLeaseTime);

    nsresult (*GetMaxLeaseTime)(IDHCPIndividualConfig *pThis, PRUint32 *maxLeaseTime);
    nsresult (*SetMaxLeaseTime)(IDHCPIndividualConfig *pThis, PRUint32 maxLeaseTime);

    nsresult (*GetForcedOptions)(IDHCPIndividualConfig *pThis, PRUint32 *forcedOptionsSize, PRUint32 **forcedOptions);
    nsresult (*SetForcedOptions)(IDHCPIndividualConfig *pThis, PRUint32 forcedOptionsSize, PRUint32 *forcedOptions);

    nsresult (*GetSuppressedOptions)(IDHCPIndividualConfig *pThis, PRUint32 *suppressedOptionsSize, PRUint32 **suppressedOptions);
    nsresult (*SetSuppressedOptions)(IDHCPIndividualConfig *pThis, PRUint32 suppressedOptionsSize, PRUint32 *suppressedOptions);

    nsresult (*GetInternalAndReservedAttribute1IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IDHCPConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*SetOption)(
        IDHCPIndividualConfig *pThis,
        PRUint32 option,
        PRUint32 encoding,
        PRUnichar * value
    );

    nsresult (*RemoveOption)(
        IDHCPIndividualConfig *pThis,
        PRUint32 option
    );

    nsresult (*RemoveAllOptions)(IDHCPIndividualConfig *pThis );

    nsresult (*GetOption)(
        IDHCPIndividualConfig *pThis,
        PRUint32 option,
        PRUint32 * encoding,
        PRUnichar * * value
    );

    nsresult (*GetAllOptions)(
        IDHCPIndividualConfig *pThis,
        PRUint32 *optionsSize,
        PRUint32** options,
        PRUint32 *encodingsSize,
        PRUint32** encodings,
        PRUint32 *valuesSize,
        PRUnichar *** values
    );

    nsresult (*Remove)(IDHCPIndividualConfig *pThis );

    nsresult (*InternalAndReservedMethod1IDHCPConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod5IDHCPConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod6IDHCPConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod7IDHCPConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod8IDHCPConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*GetMACAddress)(IDHCPIndividualConfig *pThis, PRUnichar * *MACAddress);

    nsresult (*GetMachineId)(IDHCPIndividualConfig *pThis, PRUnichar * *machineId);

    nsresult (*GetSlot)(IDHCPIndividualConfig *pThis, PRUint32 *slot);

    nsresult (*GetFixedAddress)(IDHCPIndividualConfig *pThis, PRUnichar * *fixedAddress);
    nsresult (*SetFixedAddress)(IDHCPIndividualConfig *pThis, PRUnichar * fixedAddress);

    nsresult (*GetInternalAndReservedAttribute1IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod2IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod3IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod4IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod5IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod6IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod7IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

    nsresult (*InternalAndReservedMethod8IDHCPIndividualConfig)(IDHCPIndividualConfig *pThis);

};
#define IDHCPIndividualConfig_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDHCPIndividualConfig_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDHCPIndividualConfig_Release(p) ((p)->lpVtbl->Release(p))
#define IDHCPIndividualConfig_get_Scope(p, aScope) ((p)->lpVtbl->GetScope(p, aScope))
#define IDHCPIndividualConfig_GetScope(p, aScope) ((p)->lpVtbl->GetScope(p, aScope))
#define IDHCPIndividualConfig_get_MinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->GetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPIndividualConfig_GetMinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->GetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPIndividualConfig_put_MinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->SetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPIndividualConfig_SetMinLeaseTime(p, aMinLeaseTime) ((p)->lpVtbl->SetMinLeaseTime(p, aMinLeaseTime))
#define IDHCPIndividualConfig_get_DefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->GetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPIndividualConfig_GetDefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->GetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPIndividualConfig_put_DefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->SetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPIndividualConfig_SetDefaultLeaseTime(p, aDefaultLeaseTime) ((p)->lpVtbl->SetDefaultLeaseTime(p, aDefaultLeaseTime))
#define IDHCPIndividualConfig_get_MaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->GetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPIndividualConfig_GetMaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->GetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPIndividualConfig_put_MaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->SetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPIndividualConfig_SetMaxLeaseTime(p, aMaxLeaseTime) ((p)->lpVtbl->SetMaxLeaseTime(p, aMaxLeaseTime))
#define IDHCPIndividualConfig_get_ForcedOptions(p, aForcedOptions) ((p)->lpVtbl->GetForcedOptions(p, aForcedOptions))
#define IDHCPIndividualConfig_GetForcedOptions(p, aForcedOptions) ((p)->lpVtbl->GetForcedOptions(p, aForcedOptions))
#define IDHCPIndividualConfig_put_ForcedOptions(p, aForcedOptions) ((p)->lpVtbl->SetForcedOptions(p, aForcedOptions))
#define IDHCPIndividualConfig_SetForcedOptions(p, aForcedOptions) ((p)->lpVtbl->SetForcedOptions(p, aForcedOptions))
#define IDHCPIndividualConfig_get_SuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->GetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPIndividualConfig_GetSuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->GetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPIndividualConfig_put_SuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->SetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPIndividualConfig_SetSuppressedOptions(p, aSuppressedOptions) ((p)->lpVtbl->SetSuppressedOptions(p, aSuppressedOptions))
#define IDHCPIndividualConfig_SetOption(p, aOption, aEncoding, aValue) ((p)->lpVtbl->SetOption(p, aOption, aEncoding, aValue))
#define IDHCPIndividualConfig_RemoveOption(p, aOption) ((p)->lpVtbl->RemoveOption(p, aOption))
#define IDHCPIndividualConfig_RemoveAllOptions(p) ((p)->lpVtbl->RemoveAllOptions(p))
#define IDHCPIndividualConfig_GetOption(p, aOption, aEncoding, aValue) ((p)->lpVtbl->GetOption(p, aOption, aEncoding, aValue))
#define IDHCPIndividualConfig_GetAllOptions(p, aOptions, aEncodings, aValues) ((p)->lpVtbl->GetAllOptions(p, aOptions, aEncodings, aValues))
#define IDHCPIndividualConfig_Remove(p) ((p)->lpVtbl->Remove(p))
#define IDHCPIndividualConfig_get_MACAddress(p, aMACAddress) ((p)->lpVtbl->GetMACAddress(p, aMACAddress))
#define IDHCPIndividualConfig_GetMACAddress(p, aMACAddress) ((p)->lpVtbl->GetMACAddress(p, aMACAddress))
#define IDHCPIndividualConfig_get_MachineId(p, aMachineId) ((p)->lpVtbl->GetMachineId(p, aMachineId))
#define IDHCPIndividualConfig_GetMachineId(p, aMachineId) ((p)->lpVtbl->GetMachineId(p, aMachineId))
#define IDHCPIndividualConfig_get_Slot(p, aSlot) ((p)->lpVtbl->GetSlot(p, aSlot))
#define IDHCPIndividualConfig_GetSlot(p, aSlot) ((p)->lpVtbl->GetSlot(p, aSlot))
#define IDHCPIndividualConfig_get_FixedAddress(p, aFixedAddress) ((p)->lpVtbl->GetFixedAddress(p, aFixedAddress))
#define IDHCPIndividualConfig_GetFixedAddress(p, aFixedAddress) ((p)->lpVtbl->GetFixedAddress(p, aFixedAddress))
#define IDHCPIndividualConfig_put_FixedAddress(p, aFixedAddress) ((p)->lpVtbl->SetFixedAddress(p, aFixedAddress))
#define IDHCPIndividualConfig_SetFixedAddress(p, aFixedAddress) ((p)->lpVtbl->SetFixedAddress(p, aFixedAddress))
#endif /* VBOX_WITH_GLUE */

interface IDHCPIndividualConfig
{
#ifndef VBOX_WITH_GLUE
    struct IDHCPIndividualConfig_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDHCPIndividualConfigVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDHCPIndividualConfig declaration */


/* Start of struct IVirtualBox declaration */
#define IVIRTUALBOX_IID_STR "d644ad1e-c501-4fc7-9ab6-aa6d763bc540"
#define IVIRTUALBOX_IID { \
    0xd644ad1e, 0xc501, 0x4fc7, \
    { 0x9a, 0xb6, 0xaa, 0x6d, 0x76, 0x3b, 0xc5, 0x40 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IVirtualBox);
#ifndef VBOX_WITH_GLUE
struct IVirtualBox_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetVersion)(IVirtualBox *pThis, PRUnichar * *version);

    nsresult (*GetVersionNormalized)(IVirtualBox *pThis, PRUnichar * *versionNormalized);

    nsresult (*GetRevision)(IVirtualBox *pThis, PRUint32 *revision);

    nsresult (*GetPackageType)(IVirtualBox *pThis, PRUnichar * *packageType);

    nsresult (*GetAPIVersion)(IVirtualBox *pThis, PRUnichar * *APIVersion);

    nsresult (*GetAPIRevision)(IVirtualBox *pThis, PRInt64 *APIRevision);

    nsresult (*GetHomeFolder)(IVirtualBox *pThis, PRUnichar * *homeFolder);

    nsresult (*GetSettingsFilePath)(IVirtualBox *pThis, PRUnichar * *settingsFilePath);

    nsresult (*GetHost)(IVirtualBox *pThis, IHost * *host);

    nsresult (*GetSystemProperties)(IVirtualBox *pThis, ISystemProperties * *systemProperties);

    nsresult (*GetMachines)(IVirtualBox *pThis, PRUint32 *machinesSize, IMachine * **machines);

    nsresult (*GetMachineGroups)(IVirtualBox *pThis, PRUint32 *machineGroupsSize, PRUnichar * **machineGroups);

    nsresult (*GetHardDisks)(IVirtualBox *pThis, PRUint32 *hardDisksSize, IMedium * **hardDisks);

    nsresult (*GetDVDImages)(IVirtualBox *pThis, PRUint32 *DVDImagesSize, IMedium * **DVDImages);

    nsresult (*GetFloppyImages)(IVirtualBox *pThis, PRUint32 *floppyImagesSize, IMedium * **floppyImages);

    nsresult (*GetProgressOperations)(IVirtualBox *pThis, PRUint32 *progressOperationsSize, IProgress * **progressOperations);

    nsresult (*GetGuestOSTypes)(IVirtualBox *pThis, PRUint32 *guestOSTypesSize, IGuestOSType * **guestOSTypes);

    nsresult (*GetGuestOSFamilies)(IVirtualBox *pThis, PRUint32 *guestOSFamiliesSize, PRUnichar * **guestOSFamilies);

    nsresult (*GetSharedFolders)(IVirtualBox *pThis, PRUint32 *sharedFoldersSize, ISharedFolder * **sharedFolders);

    nsresult (*GetPerformanceCollector)(IVirtualBox *pThis, IPerformanceCollector * *performanceCollector);

    nsresult (*GetDHCPServers)(IVirtualBox *pThis, PRUint32 *DHCPServersSize, IDHCPServer * **DHCPServers);

    nsresult (*GetNATNetworks)(IVirtualBox *pThis, PRUint32 *NATNetworksSize, INATNetwork * **NATNetworks);

    nsresult (*GetEventSource)(IVirtualBox *pThis, IEventSource * *eventSource);

    nsresult (*GetExtensionPackManager)(IVirtualBox *pThis, IExtPackManager * *extensionPackManager);

    nsresult (*GetInternalNetworks)(IVirtualBox *pThis, PRUint32 *internalNetworksSize, PRUnichar * **internalNetworks);

    nsresult (*GetHostOnlyNetworks)(IVirtualBox *pThis, PRUint32 *hostOnlyNetworksSize, IHostOnlyNetwork * **hostOnlyNetworks);

    nsresult (*GetGenericNetworkDrivers)(IVirtualBox *pThis, PRUint32 *genericNetworkDriversSize, PRUnichar * **genericNetworkDrivers);

    nsresult (*GetCloudNetworks)(IVirtualBox *pThis, PRUint32 *cloudNetworksSize, ICloudNetwork * **cloudNetworks);

    nsresult (*GetCloudProviderManager)(IVirtualBox *pThis, ICloudProviderManager * *cloudProviderManager);

    nsresult (*GetInternalAndReservedAttribute1IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*ComposeMachineFilename)(
        IVirtualBox *pThis,
        PRUnichar * name,
        PRUnichar * group,
        PRUnichar * createFlags,
        PRUnichar * baseFolder,
        PRUnichar * * file
    );

    nsresult (*GetPlatformProperties)(
        IVirtualBox *pThis,
        PRUint32 architecture,
        IPlatformProperties * * properties
    );

    nsresult (*CreateMachine)(
        IVirtualBox *pThis,
        PRUnichar * settingsFile,
        PRUnichar * name,
        PRUint32 platform,
        PRUint32 groupsSize,
        PRUnichar ** groups,
        PRUnichar * osTypeId,
        PRUnichar * flags,
        PRUnichar * cipher,
        PRUnichar * passwordId,
        PRUnichar * password,
        IMachine * * machine
    );

    nsresult (*OpenMachine)(
        IVirtualBox *pThis,
        PRUnichar * settingsFile,
        PRUnichar * password,
        IMachine * * machine
    );

    nsresult (*RegisterMachine)(
        IVirtualBox *pThis,
        IMachine * machine
    );

    nsresult (*FindMachine)(
        IVirtualBox *pThis,
        PRUnichar * nameOrId,
        IMachine * * machine
    );

    nsresult (*GetMachinesByGroups)(
        IVirtualBox *pThis,
        PRUint32 groupsSize,
        PRUnichar ** groups,
        PRUint32 *machinesSize,
        IMachine *** machines
    );

    nsresult (*GetMachineStates)(
        IVirtualBox *pThis,
        PRUint32 machinesSize,
        IMachine ** machines,
        PRUint32 *statesSize,
        PRUint32** states
    );

    nsresult (*CreateAppliance)(
        IVirtualBox *pThis,
        IAppliance * * appliance
    );

    nsresult (*CreateUnattendedInstaller)(
        IVirtualBox *pThis,
        IUnattended * * unattended
    );

    nsresult (*CreateMedium)(
        IVirtualBox *pThis,
        PRUnichar * format,
        PRUnichar * location,
        PRUint32 accessMode,
        PRUint32 aDeviceTypeType,
        IMedium * * medium
    );

    nsresult (*OpenMedium)(
        IVirtualBox *pThis,
        PRUnichar * location,
        PRUint32 deviceType,
        PRUint32 accessMode,
        PRBool forceNewUuid,
        IMedium * * medium
    );

    nsresult (*GetGuestOSType)(
        IVirtualBox *pThis,
        PRUnichar * id,
        IGuestOSType * * type
    );

    nsresult (*GetGuestOSSubtypesByFamilyId)(
        IVirtualBox *pThis,
        PRUnichar * family,
        PRUint32 *OSsubtypesSize,
        PRUnichar *** OSsubtypes
    );

    nsresult (*GetGuestOSDescsBySubtype)(
        IVirtualBox *pThis,
        PRUnichar * OSSubtype,
        PRUint32 *GuestOSDescsSize,
        PRUnichar *** GuestOSDescs
    );

    nsresult (*CreateSharedFolder)(
        IVirtualBox *pThis,
        PRUnichar * name,
        PRUnichar * hostPath,
        PRBool writable,
        PRBool automount,
        PRUnichar * autoMountPoint
    );

    nsresult (*RemoveSharedFolder)(
        IVirtualBox *pThis,
        PRUnichar * name
    );

    nsresult (*GetExtraDataKeys)(
        IVirtualBox *pThis,
        PRUint32 *keysSize,
        PRUnichar *** keys
    );

    nsresult (*GetExtraData)(
        IVirtualBox *pThis,
        PRUnichar * key,
        PRUnichar * * value
    );

    nsresult (*SetExtraData)(
        IVirtualBox *pThis,
        PRUnichar * key,
        PRUnichar * value
    );

    nsresult (*SetSettingsSecret)(
        IVirtualBox *pThis,
        PRUnichar * password
    );

    nsresult (*CreateDHCPServer)(
        IVirtualBox *pThis,
        PRUnichar * name,
        IDHCPServer * * server
    );

    nsresult (*FindDHCPServerByNetworkName)(
        IVirtualBox *pThis,
        PRUnichar * name,
        IDHCPServer * * server
    );

    nsresult (*RemoveDHCPServer)(
        IVirtualBox *pThis,
        IDHCPServer * server
    );

    nsresult (*CreateNATNetwork)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        INATNetwork * * network
    );

    nsresult (*FindNATNetworkByName)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        INATNetwork * * network
    );

    nsresult (*RemoveNATNetwork)(
        IVirtualBox *pThis,
        INATNetwork * network
    );

    nsresult (*CreateHostOnlyNetwork)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        IHostOnlyNetwork * * network
    );

    nsresult (*FindHostOnlyNetworkByName)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        IHostOnlyNetwork * * network
    );

    nsresult (*FindHostOnlyNetworkById)(
        IVirtualBox *pThis,
        PRUnichar * id,
        IHostOnlyNetwork * * network
    );

    nsresult (*RemoveHostOnlyNetwork)(
        IVirtualBox *pThis,
        IHostOnlyNetwork * network
    );

    nsresult (*CreateCloudNetwork)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        ICloudNetwork * * network
    );

    nsresult (*FindCloudNetworkByName)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        ICloudNetwork * * network
    );

    nsresult (*RemoveCloudNetwork)(
        IVirtualBox *pThis,
        ICloudNetwork * network
    );

    nsresult (*CheckFirmwarePresent)(
        IVirtualBox *pThis,
        PRUint32 platformArchitecture,
        PRUint32 firmwareType,
        PRUnichar * version,
        PRUnichar * * url,
        PRUnichar * * file,
        PRBool * result
    );

    nsresult (*FindProgressById)(
        IVirtualBox *pThis,
        PRUnichar * id,
        IProgress * * progressObject
    );

    nsresult (*InternalAndReservedMethod1IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod2IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod3IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod4IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod5IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod6IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod7IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod8IVirtualBox)(IVirtualBox *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IVirtualBoxVtbl
{
    nsresult (*QueryInterface)(IVirtualBox *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IVirtualBox *pThis);
    nsrefcnt (*Release)(IVirtualBox *pThis);
    nsresult (*GetVersion)(IVirtualBox *pThis, PRUnichar * *version);

    nsresult (*GetVersionNormalized)(IVirtualBox *pThis, PRUnichar * *versionNormalized);

    nsresult (*GetRevision)(IVirtualBox *pThis, PRUint32 *revision);

    nsresult (*GetPackageType)(IVirtualBox *pThis, PRUnichar * *packageType);

    nsresult (*GetAPIVersion)(IVirtualBox *pThis, PRUnichar * *APIVersion);

    nsresult (*GetAPIRevision)(IVirtualBox *pThis, PRInt64 *APIRevision);

    nsresult (*GetHomeFolder)(IVirtualBox *pThis, PRUnichar * *homeFolder);

    nsresult (*GetSettingsFilePath)(IVirtualBox *pThis, PRUnichar * *settingsFilePath);

    nsresult (*GetHost)(IVirtualBox *pThis, IHost * *host);

    nsresult (*GetSystemProperties)(IVirtualBox *pThis, ISystemProperties * *systemProperties);

    nsresult (*GetMachines)(IVirtualBox *pThis, PRUint32 *machinesSize, IMachine * **machines);

    nsresult (*GetMachineGroups)(IVirtualBox *pThis, PRUint32 *machineGroupsSize, PRUnichar * **machineGroups);

    nsresult (*GetHardDisks)(IVirtualBox *pThis, PRUint32 *hardDisksSize, IMedium * **hardDisks);

    nsresult (*GetDVDImages)(IVirtualBox *pThis, PRUint32 *DVDImagesSize, IMedium * **DVDImages);

    nsresult (*GetFloppyImages)(IVirtualBox *pThis, PRUint32 *floppyImagesSize, IMedium * **floppyImages);

    nsresult (*GetProgressOperations)(IVirtualBox *pThis, PRUint32 *progressOperationsSize, IProgress * **progressOperations);

    nsresult (*GetGuestOSTypes)(IVirtualBox *pThis, PRUint32 *guestOSTypesSize, IGuestOSType * **guestOSTypes);

    nsresult (*GetGuestOSFamilies)(IVirtualBox *pThis, PRUint32 *guestOSFamiliesSize, PRUnichar * **guestOSFamilies);

    nsresult (*GetSharedFolders)(IVirtualBox *pThis, PRUint32 *sharedFoldersSize, ISharedFolder * **sharedFolders);

    nsresult (*GetPerformanceCollector)(IVirtualBox *pThis, IPerformanceCollector * *performanceCollector);

    nsresult (*GetDHCPServers)(IVirtualBox *pThis, PRUint32 *DHCPServersSize, IDHCPServer * **DHCPServers);

    nsresult (*GetNATNetworks)(IVirtualBox *pThis, PRUint32 *NATNetworksSize, INATNetwork * **NATNetworks);

    nsresult (*GetEventSource)(IVirtualBox *pThis, IEventSource * *eventSource);

    nsresult (*GetExtensionPackManager)(IVirtualBox *pThis, IExtPackManager * *extensionPackManager);

    nsresult (*GetInternalNetworks)(IVirtualBox *pThis, PRUint32 *internalNetworksSize, PRUnichar * **internalNetworks);

    nsresult (*GetHostOnlyNetworks)(IVirtualBox *pThis, PRUint32 *hostOnlyNetworksSize, IHostOnlyNetwork * **hostOnlyNetworks);

    nsresult (*GetGenericNetworkDrivers)(IVirtualBox *pThis, PRUint32 *genericNetworkDriversSize, PRUnichar * **genericNetworkDrivers);

    nsresult (*GetCloudNetworks)(IVirtualBox *pThis, PRUint32 *cloudNetworksSize, ICloudNetwork * **cloudNetworks);

    nsresult (*GetCloudProviderManager)(IVirtualBox *pThis, ICloudProviderManager * *cloudProviderManager);

    nsresult (*GetInternalAndReservedAttribute1IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IVirtualBox)(IVirtualBox *pThis, PRUint32 *reserved);

    nsresult (*ComposeMachineFilename)(
        IVirtualBox *pThis,
        PRUnichar * name,
        PRUnichar * group,
        PRUnichar * createFlags,
        PRUnichar * baseFolder,
        PRUnichar * * file
    );

    nsresult (*GetPlatformProperties)(
        IVirtualBox *pThis,
        PRUint32 architecture,
        IPlatformProperties * * properties
    );

    nsresult (*CreateMachine)(
        IVirtualBox *pThis,
        PRUnichar * settingsFile,
        PRUnichar * name,
        PRUint32 platform,
        PRUint32 groupsSize,
        PRUnichar ** groups,
        PRUnichar * osTypeId,
        PRUnichar * flags,
        PRUnichar * cipher,
        PRUnichar * passwordId,
        PRUnichar * password,
        IMachine * * machine
    );

    nsresult (*OpenMachine)(
        IVirtualBox *pThis,
        PRUnichar * settingsFile,
        PRUnichar * password,
        IMachine * * machine
    );

    nsresult (*RegisterMachine)(
        IVirtualBox *pThis,
        IMachine * machine
    );

    nsresult (*FindMachine)(
        IVirtualBox *pThis,
        PRUnichar * nameOrId,
        IMachine * * machine
    );

    nsresult (*GetMachinesByGroups)(
        IVirtualBox *pThis,
        PRUint32 groupsSize,
        PRUnichar ** groups,
        PRUint32 *machinesSize,
        IMachine *** machines
    );

    nsresult (*GetMachineStates)(
        IVirtualBox *pThis,
        PRUint32 machinesSize,
        IMachine ** machines,
        PRUint32 *statesSize,
        PRUint32** states
    );

    nsresult (*CreateAppliance)(
        IVirtualBox *pThis,
        IAppliance * * appliance
    );

    nsresult (*CreateUnattendedInstaller)(
        IVirtualBox *pThis,
        IUnattended * * unattended
    );

    nsresult (*CreateMedium)(
        IVirtualBox *pThis,
        PRUnichar * format,
        PRUnichar * location,
        PRUint32 accessMode,
        PRUint32 aDeviceTypeType,
        IMedium * * medium
    );

    nsresult (*OpenMedium)(
        IVirtualBox *pThis,
        PRUnichar * location,
        PRUint32 deviceType,
        PRUint32 accessMode,
        PRBool forceNewUuid,
        IMedium * * medium
    );

    nsresult (*GetGuestOSType)(
        IVirtualBox *pThis,
        PRUnichar * id,
        IGuestOSType * * type
    );

    nsresult (*GetGuestOSSubtypesByFamilyId)(
        IVirtualBox *pThis,
        PRUnichar * family,
        PRUint32 *OSsubtypesSize,
        PRUnichar *** OSsubtypes
    );

    nsresult (*GetGuestOSDescsBySubtype)(
        IVirtualBox *pThis,
        PRUnichar * OSSubtype,
        PRUint32 *GuestOSDescsSize,
        PRUnichar *** GuestOSDescs
    );

    nsresult (*CreateSharedFolder)(
        IVirtualBox *pThis,
        PRUnichar * name,
        PRUnichar * hostPath,
        PRBool writable,
        PRBool automount,
        PRUnichar * autoMountPoint
    );

    nsresult (*RemoveSharedFolder)(
        IVirtualBox *pThis,
        PRUnichar * name
    );

    nsresult (*GetExtraDataKeys)(
        IVirtualBox *pThis,
        PRUint32 *keysSize,
        PRUnichar *** keys
    );

    nsresult (*GetExtraData)(
        IVirtualBox *pThis,
        PRUnichar * key,
        PRUnichar * * value
    );

    nsresult (*SetExtraData)(
        IVirtualBox *pThis,
        PRUnichar * key,
        PRUnichar * value
    );

    nsresult (*SetSettingsSecret)(
        IVirtualBox *pThis,
        PRUnichar * password
    );

    nsresult (*CreateDHCPServer)(
        IVirtualBox *pThis,
        PRUnichar * name,
        IDHCPServer * * server
    );

    nsresult (*FindDHCPServerByNetworkName)(
        IVirtualBox *pThis,
        PRUnichar * name,
        IDHCPServer * * server
    );

    nsresult (*RemoveDHCPServer)(
        IVirtualBox *pThis,
        IDHCPServer * server
    );

    nsresult (*CreateNATNetwork)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        INATNetwork * * network
    );

    nsresult (*FindNATNetworkByName)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        INATNetwork * * network
    );

    nsresult (*RemoveNATNetwork)(
        IVirtualBox *pThis,
        INATNetwork * network
    );

    nsresult (*CreateHostOnlyNetwork)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        IHostOnlyNetwork * * network
    );

    nsresult (*FindHostOnlyNetworkByName)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        IHostOnlyNetwork * * network
    );

    nsresult (*FindHostOnlyNetworkById)(
        IVirtualBox *pThis,
        PRUnichar * id,
        IHostOnlyNetwork * * network
    );

    nsresult (*RemoveHostOnlyNetwork)(
        IVirtualBox *pThis,
        IHostOnlyNetwork * network
    );

    nsresult (*CreateCloudNetwork)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        ICloudNetwork * * network
    );

    nsresult (*FindCloudNetworkByName)(
        IVirtualBox *pThis,
        PRUnichar * networkName,
        ICloudNetwork * * network
    );

    nsresult (*RemoveCloudNetwork)(
        IVirtualBox *pThis,
        ICloudNetwork * network
    );

    nsresult (*CheckFirmwarePresent)(
        IVirtualBox *pThis,
        PRUint32 platformArchitecture,
        PRUint32 firmwareType,
        PRUnichar * version,
        PRUnichar * * url,
        PRUnichar * * file,
        PRBool * result
    );

    nsresult (*FindProgressById)(
        IVirtualBox *pThis,
        PRUnichar * id,
        IProgress * * progressObject
    );

    nsresult (*InternalAndReservedMethod1IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod2IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod3IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod4IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod5IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod6IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod7IVirtualBox)(IVirtualBox *pThis);

    nsresult (*InternalAndReservedMethod8IVirtualBox)(IVirtualBox *pThis);

};
#define IVirtualBox_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IVirtualBox_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IVirtualBox_Release(p) ((p)->lpVtbl->Release(p))
#define IVirtualBox_get_Version(p, aVersion) ((p)->lpVtbl->GetVersion(p, aVersion))
#define IVirtualBox_GetVersion(p, aVersion) ((p)->lpVtbl->GetVersion(p, aVersion))
#define IVirtualBox_get_VersionNormalized(p, aVersionNormalized) ((p)->lpVtbl->GetVersionNormalized(p, aVersionNormalized))
#define IVirtualBox_GetVersionNormalized(p, aVersionNormalized) ((p)->lpVtbl->GetVersionNormalized(p, aVersionNormalized))
#define IVirtualBox_get_Revision(p, aRevision) ((p)->lpVtbl->GetRevision(p, aRevision))
#define IVirtualBox_GetRevision(p, aRevision) ((p)->lpVtbl->GetRevision(p, aRevision))
#define IVirtualBox_get_PackageType(p, aPackageType) ((p)->lpVtbl->GetPackageType(p, aPackageType))
#define IVirtualBox_GetPackageType(p, aPackageType) ((p)->lpVtbl->GetPackageType(p, aPackageType))
#define IVirtualBox_get_APIVersion(p, aAPIVersion) ((p)->lpVtbl->GetAPIVersion(p, aAPIVersion))
#define IVirtualBox_GetAPIVersion(p, aAPIVersion) ((p)->lpVtbl->GetAPIVersion(p, aAPIVersion))
#define IVirtualBox_get_APIRevision(p, aAPIRevision) ((p)->lpVtbl->GetAPIRevision(p, aAPIRevision))
#define IVirtualBox_GetAPIRevision(p, aAPIRevision) ((p)->lpVtbl->GetAPIRevision(p, aAPIRevision))
#define IVirtualBox_get_HomeFolder(p, aHomeFolder) ((p)->lpVtbl->GetHomeFolder(p, aHomeFolder))
#define IVirtualBox_GetHomeFolder(p, aHomeFolder) ((p)->lpVtbl->GetHomeFolder(p, aHomeFolder))
#define IVirtualBox_get_SettingsFilePath(p, aSettingsFilePath) ((p)->lpVtbl->GetSettingsFilePath(p, aSettingsFilePath))
#define IVirtualBox_GetSettingsFilePath(p, aSettingsFilePath) ((p)->lpVtbl->GetSettingsFilePath(p, aSettingsFilePath))
#define IVirtualBox_get_Host(p, aHost) ((p)->lpVtbl->GetHost(p, aHost))
#define IVirtualBox_GetHost(p, aHost) ((p)->lpVtbl->GetHost(p, aHost))
#define IVirtualBox_get_SystemProperties(p, aSystemProperties) ((p)->lpVtbl->GetSystemProperties(p, aSystemProperties))
#define IVirtualBox_GetSystemProperties(p, aSystemProperties) ((p)->lpVtbl->GetSystemProperties(p, aSystemProperties))
#define IVirtualBox_get_Machines(p, aMachines) ((p)->lpVtbl->GetMachines(p, aMachines))
#define IVirtualBox_GetMachines(p, aMachines) ((p)->lpVtbl->GetMachines(p, aMachines))
#define IVirtualBox_get_MachineGroups(p, aMachineGroups) ((p)->lpVtbl->GetMachineGroups(p, aMachineGroups))
#define IVirtualBox_GetMachineGroups(p, aMachineGroups) ((p)->lpVtbl->GetMachineGroups(p, aMachineGroups))
#define IVirtualBox_get_HardDisks(p, aHardDisks) ((p)->lpVtbl->GetHardDisks(p, aHardDisks))
#define IVirtualBox_GetHardDisks(p, aHardDisks) ((p)->lpVtbl->GetHardDisks(p, aHardDisks))
#define IVirtualBox_get_DVDImages(p, aDVDImages) ((p)->lpVtbl->GetDVDImages(p, aDVDImages))
#define IVirtualBox_GetDVDImages(p, aDVDImages) ((p)->lpVtbl->GetDVDImages(p, aDVDImages))
#define IVirtualBox_get_FloppyImages(p, aFloppyImages) ((p)->lpVtbl->GetFloppyImages(p, aFloppyImages))
#define IVirtualBox_GetFloppyImages(p, aFloppyImages) ((p)->lpVtbl->GetFloppyImages(p, aFloppyImages))
#define IVirtualBox_get_ProgressOperations(p, aProgressOperations) ((p)->lpVtbl->GetProgressOperations(p, aProgressOperations))
#define IVirtualBox_GetProgressOperations(p, aProgressOperations) ((p)->lpVtbl->GetProgressOperations(p, aProgressOperations))
#define IVirtualBox_get_GuestOSTypes(p, aGuestOSTypes) ((p)->lpVtbl->GetGuestOSTypes(p, aGuestOSTypes))
#define IVirtualBox_GetGuestOSTypes(p, aGuestOSTypes) ((p)->lpVtbl->GetGuestOSTypes(p, aGuestOSTypes))
#define IVirtualBox_get_GuestOSFamilies(p, aGuestOSFamilies) ((p)->lpVtbl->GetGuestOSFamilies(p, aGuestOSFamilies))
#define IVirtualBox_GetGuestOSFamilies(p, aGuestOSFamilies) ((p)->lpVtbl->GetGuestOSFamilies(p, aGuestOSFamilies))
#define IVirtualBox_get_SharedFolders(p, aSharedFolders) ((p)->lpVtbl->GetSharedFolders(p, aSharedFolders))
#define IVirtualBox_GetSharedFolders(p, aSharedFolders) ((p)->lpVtbl->GetSharedFolders(p, aSharedFolders))
#define IVirtualBox_get_PerformanceCollector(p, aPerformanceCollector) ((p)->lpVtbl->GetPerformanceCollector(p, aPerformanceCollector))
#define IVirtualBox_GetPerformanceCollector(p, aPerformanceCollector) ((p)->lpVtbl->GetPerformanceCollector(p, aPerformanceCollector))
#define IVirtualBox_get_DHCPServers(p, aDHCPServers) ((p)->lpVtbl->GetDHCPServers(p, aDHCPServers))
#define IVirtualBox_GetDHCPServers(p, aDHCPServers) ((p)->lpVtbl->GetDHCPServers(p, aDHCPServers))
#define IVirtualBox_get_NATNetworks(p, aNATNetworks) ((p)->lpVtbl->GetNATNetworks(p, aNATNetworks))
#define IVirtualBox_GetNATNetworks(p, aNATNetworks) ((p)->lpVtbl->GetNATNetworks(p, aNATNetworks))
#define IVirtualBox_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IVirtualBox_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IVirtualBox_get_ExtensionPackManager(p, aExtensionPackManager) ((p)->lpVtbl->GetExtensionPackManager(p, aExtensionPackManager))
#define IVirtualBox_GetExtensionPackManager(p, aExtensionPackManager) ((p)->lpVtbl->GetExtensionPackManager(p, aExtensionPackManager))
#define IVirtualBox_get_InternalNetworks(p, aInternalNetworks) ((p)->lpVtbl->GetInternalNetworks(p, aInternalNetworks))
#define IVirtualBox_GetInternalNetworks(p, aInternalNetworks) ((p)->lpVtbl->GetInternalNetworks(p, aInternalNetworks))
#define IVirtualBox_get_HostOnlyNetworks(p, aHostOnlyNetworks) ((p)->lpVtbl->GetHostOnlyNetworks(p, aHostOnlyNetworks))
#define IVirtualBox_GetHostOnlyNetworks(p, aHostOnlyNetworks) ((p)->lpVtbl->GetHostOnlyNetworks(p, aHostOnlyNetworks))
#define IVirtualBox_get_GenericNetworkDrivers(p, aGenericNetworkDrivers) ((p)->lpVtbl->GetGenericNetworkDrivers(p, aGenericNetworkDrivers))
#define IVirtualBox_GetGenericNetworkDrivers(p, aGenericNetworkDrivers) ((p)->lpVtbl->GetGenericNetworkDrivers(p, aGenericNetworkDrivers))
#define IVirtualBox_get_CloudNetworks(p, aCloudNetworks) ((p)->lpVtbl->GetCloudNetworks(p, aCloudNetworks))
#define IVirtualBox_GetCloudNetworks(p, aCloudNetworks) ((p)->lpVtbl->GetCloudNetworks(p, aCloudNetworks))
#define IVirtualBox_get_CloudProviderManager(p, aCloudProviderManager) ((p)->lpVtbl->GetCloudProviderManager(p, aCloudProviderManager))
#define IVirtualBox_GetCloudProviderManager(p, aCloudProviderManager) ((p)->lpVtbl->GetCloudProviderManager(p, aCloudProviderManager))
#define IVirtualBox_ComposeMachineFilename(p, aName, aGroup, aCreateFlags, aBaseFolder, aFile) ((p)->lpVtbl->ComposeMachineFilename(p, aName, aGroup, aCreateFlags, aBaseFolder, aFile))
#define IVirtualBox_GetPlatformProperties(p, aArchitecture, aProperties) ((p)->lpVtbl->GetPlatformProperties(p, aArchitecture, aProperties))
#define IVirtualBox_CreateMachine(p, aSettingsFile, aName, aPlatform, aGroups, aOsTypeId, aFlags, aCipher, aPasswordId, aPassword, aMachine) ((p)->lpVtbl->CreateMachine(p, aSettingsFile, aName, aPlatform, aGroups, aOsTypeId, aFlags, aCipher, aPasswordId, aPassword, aMachine))
#define IVirtualBox_OpenMachine(p, aSettingsFile, aPassword, aMachine) ((p)->lpVtbl->OpenMachine(p, aSettingsFile, aPassword, aMachine))
#define IVirtualBox_RegisterMachine(p, aMachine) ((p)->lpVtbl->RegisterMachine(p, aMachine))
#define IVirtualBox_FindMachine(p, aNameOrId, aMachine) ((p)->lpVtbl->FindMachine(p, aNameOrId, aMachine))
#define IVirtualBox_GetMachinesByGroups(p, aGroups, aMachines) ((p)->lpVtbl->GetMachinesByGroups(p, aGroups, aMachines))
#define IVirtualBox_GetMachineStates(p, aMachines, aStates) ((p)->lpVtbl->GetMachineStates(p, aMachines, aStates))
#define IVirtualBox_CreateAppliance(p, aAppliance) ((p)->lpVtbl->CreateAppliance(p, aAppliance))
#define IVirtualBox_CreateUnattendedInstaller(p, aUnattended) ((p)->lpVtbl->CreateUnattendedInstaller(p, aUnattended))
#define IVirtualBox_CreateMedium(p, aFormat, aLocation, aAccessMode, aADeviceTypeType, aMedium) ((p)->lpVtbl->CreateMedium(p, aFormat, aLocation, aAccessMode, aADeviceTypeType, aMedium))
#define IVirtualBox_OpenMedium(p, aLocation, aDeviceType, aAccessMode, aForceNewUuid, aMedium) ((p)->lpVtbl->OpenMedium(p, aLocation, aDeviceType, aAccessMode, aForceNewUuid, aMedium))
#define IVirtualBox_GetGuestOSType(p, aId, aType) ((p)->lpVtbl->GetGuestOSType(p, aId, aType))
#define IVirtualBox_GetGuestOSSubtypesByFamilyId(p, aFamily, aOSsubtypes) ((p)->lpVtbl->GetGuestOSSubtypesByFamilyId(p, aFamily, aOSsubtypes))
#define IVirtualBox_GetGuestOSDescsBySubtype(p, aOSSubtype, aGuestOSDescs) ((p)->lpVtbl->GetGuestOSDescsBySubtype(p, aOSSubtype, aGuestOSDescs))
#define IVirtualBox_CreateSharedFolder(p, aName, aHostPath, aWritable, aAutomount, aAutoMountPoint) ((p)->lpVtbl->CreateSharedFolder(p, aName, aHostPath, aWritable, aAutomount, aAutoMountPoint))
#define IVirtualBox_RemoveSharedFolder(p, aName) ((p)->lpVtbl->RemoveSharedFolder(p, aName))
#define IVirtualBox_GetExtraDataKeys(p, aKeys) ((p)->lpVtbl->GetExtraDataKeys(p, aKeys))
#define IVirtualBox_GetExtraData(p, aKey, aValue) ((p)->lpVtbl->GetExtraData(p, aKey, aValue))
#define IVirtualBox_SetExtraData(p, aKey, aValue) ((p)->lpVtbl->SetExtraData(p, aKey, aValue))
#define IVirtualBox_SetSettingsSecret(p, aPassword) ((p)->lpVtbl->SetSettingsSecret(p, aPassword))
#define IVirtualBox_CreateDHCPServer(p, aName, aServer) ((p)->lpVtbl->CreateDHCPServer(p, aName, aServer))
#define IVirtualBox_FindDHCPServerByNetworkName(p, aName, aServer) ((p)->lpVtbl->FindDHCPServerByNetworkName(p, aName, aServer))
#define IVirtualBox_RemoveDHCPServer(p, aServer) ((p)->lpVtbl->RemoveDHCPServer(p, aServer))
#define IVirtualBox_CreateNATNetwork(p, aNetworkName, aNetwork) ((p)->lpVtbl->CreateNATNetwork(p, aNetworkName, aNetwork))
#define IVirtualBox_FindNATNetworkByName(p, aNetworkName, aNetwork) ((p)->lpVtbl->FindNATNetworkByName(p, aNetworkName, aNetwork))
#define IVirtualBox_RemoveNATNetwork(p, aNetwork) ((p)->lpVtbl->RemoveNATNetwork(p, aNetwork))
#define IVirtualBox_CreateHostOnlyNetwork(p, aNetworkName, aNetwork) ((p)->lpVtbl->CreateHostOnlyNetwork(p, aNetworkName, aNetwork))
#define IVirtualBox_FindHostOnlyNetworkByName(p, aNetworkName, aNetwork) ((p)->lpVtbl->FindHostOnlyNetworkByName(p, aNetworkName, aNetwork))
#define IVirtualBox_FindHostOnlyNetworkById(p, aId, aNetwork) ((p)->lpVtbl->FindHostOnlyNetworkById(p, aId, aNetwork))
#define IVirtualBox_RemoveHostOnlyNetwork(p, aNetwork) ((p)->lpVtbl->RemoveHostOnlyNetwork(p, aNetwork))
#define IVirtualBox_CreateCloudNetwork(p, aNetworkName, aNetwork) ((p)->lpVtbl->CreateCloudNetwork(p, aNetworkName, aNetwork))
#define IVirtualBox_FindCloudNetworkByName(p, aNetworkName, aNetwork) ((p)->lpVtbl->FindCloudNetworkByName(p, aNetworkName, aNetwork))
#define IVirtualBox_RemoveCloudNetwork(p, aNetwork) ((p)->lpVtbl->RemoveCloudNetwork(p, aNetwork))
#define IVirtualBox_CheckFirmwarePresent(p, aPlatformArchitecture, aFirmwareType, aVersion, aUrl, aFile, aResult) ((p)->lpVtbl->CheckFirmwarePresent(p, aPlatformArchitecture, aFirmwareType, aVersion, aUrl, aFile, aResult))
#define IVirtualBox_FindProgressById(p, aId, aProgressObject) ((p)->lpVtbl->FindProgressById(p, aId, aProgressObject))
#endif /* VBOX_WITH_GLUE */

interface IVirtualBox
{
#ifndef VBOX_WITH_GLUE
    struct IVirtualBox_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IVirtualBoxVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IVirtualBox declaration */


/* Start of struct IVFSExplorer declaration */
#define IVFSEXPLORER_IID_STR "fb220201-2fd3-47e2-a5dc-2c2431d833cc"
#define IVFSEXPLORER_IID { \
    0xfb220201, 0x2fd3, 0x47e2, \
    { 0xa5, 0xdc, 0x2c, 0x24, 0x31, 0xd8, 0x33, 0xcc } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IVFSExplorer);
#ifndef VBOX_WITH_GLUE
struct IVFSExplorer_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetPath)(IVFSExplorer *pThis, PRUnichar * *path);

    nsresult (*GetType)(IVFSExplorer *pThis, PRUint32 *type);

    nsresult (*Update)(
        IVFSExplorer *pThis,
        IProgress * * progress
    );

    nsresult (*Cd)(
        IVFSExplorer *pThis,
        PRUnichar * dir,
        IProgress * * progress
    );

    nsresult (*CdUp)(
        IVFSExplorer *pThis,
        IProgress * * progress
    );

    nsresult (*EntryList)(
        IVFSExplorer *pThis,
        PRUint32 *namesSize,
        PRUnichar *** names,
        PRUint32 *typesSize,
        PRUint32** types,
        PRUint32 *sizesSize,
        PRInt64** sizes,
        PRUint32 *modesSize,
        PRUint32** modes
    );

    nsresult (*Exists)(
        IVFSExplorer *pThis,
        PRUint32 namesSize,
        PRUnichar ** names,
        PRUint32 *existsSize,
        PRUnichar *** exists
    );

    nsresult (*Remove)(
        IVFSExplorer *pThis,
        PRUint32 namesSize,
        PRUnichar ** names,
        IProgress * * progress
    );

};
#else /* VBOX_WITH_GLUE */
struct IVFSExplorerVtbl
{
    nsresult (*QueryInterface)(IVFSExplorer *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IVFSExplorer *pThis);
    nsrefcnt (*Release)(IVFSExplorer *pThis);
    nsresult (*GetPath)(IVFSExplorer *pThis, PRUnichar * *path);

    nsresult (*GetType)(IVFSExplorer *pThis, PRUint32 *type);

    nsresult (*Update)(
        IVFSExplorer *pThis,
        IProgress * * progress
    );

    nsresult (*Cd)(
        IVFSExplorer *pThis,
        PRUnichar * dir,
        IProgress * * progress
    );

    nsresult (*CdUp)(
        IVFSExplorer *pThis,
        IProgress * * progress
    );

    nsresult (*EntryList)(
        IVFSExplorer *pThis,
        PRUint32 *namesSize,
        PRUnichar *** names,
        PRUint32 *typesSize,
        PRUint32** types,
        PRUint32 *sizesSize,
        PRInt64** sizes,
        PRUint32 *modesSize,
        PRUint32** modes
    );

    nsresult (*Exists)(
        IVFSExplorer *pThis,
        PRUint32 namesSize,
        PRUnichar ** names,
        PRUint32 *existsSize,
        PRUnichar *** exists
    );

    nsresult (*Remove)(
        IVFSExplorer *pThis,
        PRUint32 namesSize,
        PRUnichar ** names,
        IProgress * * progress
    );

};
#define IVFSExplorer_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IVFSExplorer_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IVFSExplorer_Release(p) ((p)->lpVtbl->Release(p))
#define IVFSExplorer_get_Path(p, aPath) ((p)->lpVtbl->GetPath(p, aPath))
#define IVFSExplorer_GetPath(p, aPath) ((p)->lpVtbl->GetPath(p, aPath))
#define IVFSExplorer_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IVFSExplorer_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IVFSExplorer_Update(p, aProgress) ((p)->lpVtbl->Update(p, aProgress))
#define IVFSExplorer_Cd(p, aDir, aProgress) ((p)->lpVtbl->Cd(p, aDir, aProgress))
#define IVFSExplorer_CdUp(p, aProgress) ((p)->lpVtbl->CdUp(p, aProgress))
#define IVFSExplorer_EntryList(p, aNames, aTypes, aSizes, aModes) ((p)->lpVtbl->EntryList(p, aNames, aTypes, aSizes, aModes))
#define IVFSExplorer_Exists(p, aNames, aExists) ((p)->lpVtbl->Exists(p, aNames, aExists))
#define IVFSExplorer_Remove(p, aNames, aProgress) ((p)->lpVtbl->Remove(p, aNames, aProgress))
#endif /* VBOX_WITH_GLUE */

interface IVFSExplorer
{
#ifndef VBOX_WITH_GLUE
    struct IVFSExplorer_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IVFSExplorerVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IVFSExplorer declaration */


/* Start of struct ICertificate declaration */
#define ICERTIFICATE_IID_STR "392f1de4-80e1-4a8a-93a1-67c5f92a838a"
#define ICERTIFICATE_IID { \
    0x392f1de4, 0x80e1, 0x4a8a, \
    { 0x93, 0xa1, 0x67, 0xc5, 0xf9, 0x2a, 0x83, 0x8a } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_ICertificate);
#ifndef VBOX_WITH_GLUE
struct ICertificate_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetVersionNumber)(ICertificate *pThis, PRUint32 *versionNumber);

    nsresult (*GetSerialNumber)(ICertificate *pThis, PRUnichar * *serialNumber);

    nsresult (*GetSignatureAlgorithmOID)(ICertificate *pThis, PRUnichar * *signatureAlgorithmOID);

    nsresult (*GetSignatureAlgorithmName)(ICertificate *pThis, PRUnichar * *signatureAlgorithmName);

    nsresult (*GetIssuerName)(ICertificate *pThis, PRUint32 *issuerNameSize, PRUnichar * **issuerName);

    nsresult (*GetSubjectName)(ICertificate *pThis, PRUint32 *subjectNameSize, PRUnichar * **subjectName);

    nsresult (*GetFriendlyName)(ICertificate *pThis, PRUnichar * *friendlyName);

    nsresult (*GetValidityPeriodNotBefore)(ICertificate *pThis, PRUnichar * *validityPeriodNotBefore);

    nsresult (*GetValidityPeriodNotAfter)(ICertificate *pThis, PRUnichar * *validityPeriodNotAfter);

    nsresult (*GetPublicKeyAlgorithmOID)(ICertificate *pThis, PRUnichar * *publicKeyAlgorithmOID);

    nsresult (*GetPublicKeyAlgorithm)(ICertificate *pThis, PRUnichar * *publicKeyAlgorithm);

    nsresult (*GetSubjectPublicKey)(ICertificate *pThis, PRUint32 *subjectPublicKeySize, PRUint8 **subjectPublicKey);

    nsresult (*GetIssuerUniqueIdentifier)(ICertificate *pThis, PRUnichar * *issuerUniqueIdentifier);

    nsresult (*GetSubjectUniqueIdentifier)(ICertificate *pThis, PRUnichar * *subjectUniqueIdentifier);

    nsresult (*GetCertificateAuthority)(ICertificate *pThis, PRBool *certificateAuthority);

    nsresult (*GetKeyUsage)(ICertificate *pThis, PRUint32 *keyUsage);

    nsresult (*GetExtendedKeyUsage)(ICertificate *pThis, PRUint32 *extendedKeyUsageSize, PRUnichar * **extendedKeyUsage);

    nsresult (*GetRawCertData)(ICertificate *pThis, PRUint32 *rawCertDataSize, PRUint8 **rawCertData);

    nsresult (*GetSelfSigned)(ICertificate *pThis, PRBool *selfSigned);

    nsresult (*GetTrusted)(ICertificate *pThis, PRBool *trusted);

    nsresult (*GetExpired)(ICertificate *pThis, PRBool *expired);

    nsresult (*GetInternalAndReservedAttribute1ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*IsCurrentlyExpired)(
        ICertificate *pThis,
        PRBool * result
    );

    nsresult (*QueryInfo)(
        ICertificate *pThis,
        PRInt32 what,
        PRUnichar * * result
    );

    nsresult (*InternalAndReservedMethod1ICertificate)(ICertificate *pThis);

    nsresult (*InternalAndReservedMethod2ICertificate)(ICertificate *pThis);

};
#else /* VBOX_WITH_GLUE */
struct ICertificateVtbl
{
    nsresult (*QueryInterface)(ICertificate *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(ICertificate *pThis);
    nsrefcnt (*Release)(ICertificate *pThis);
    nsresult (*GetVersionNumber)(ICertificate *pThis, PRUint32 *versionNumber);

    nsresult (*GetSerialNumber)(ICertificate *pThis, PRUnichar * *serialNumber);

    nsresult (*GetSignatureAlgorithmOID)(ICertificate *pThis, PRUnichar * *signatureAlgorithmOID);

    nsresult (*GetSignatureAlgorithmName)(ICertificate *pThis, PRUnichar * *signatureAlgorithmName);

    nsresult (*GetIssuerName)(ICertificate *pThis, PRUint32 *issuerNameSize, PRUnichar * **issuerName);

    nsresult (*GetSubjectName)(ICertificate *pThis, PRUint32 *subjectNameSize, PRUnichar * **subjectName);

    nsresult (*GetFriendlyName)(ICertificate *pThis, PRUnichar * *friendlyName);

    nsresult (*GetValidityPeriodNotBefore)(ICertificate *pThis, PRUnichar * *validityPeriodNotBefore);

    nsresult (*GetValidityPeriodNotAfter)(ICertificate *pThis, PRUnichar * *validityPeriodNotAfter);

    nsresult (*GetPublicKeyAlgorithmOID)(ICertificate *pThis, PRUnichar * *publicKeyAlgorithmOID);

    nsresult (*GetPublicKeyAlgorithm)(ICertificate *pThis, PRUnichar * *publicKeyAlgorithm);

    nsresult (*GetSubjectPublicKey)(ICertificate *pThis, PRUint32 *subjectPublicKeySize, PRUint8 **subjectPublicKey);

    nsresult (*GetIssuerUniqueIdentifier)(ICertificate *pThis, PRUnichar * *issuerUniqueIdentifier);

    nsresult (*GetSubjectUniqueIdentifier)(ICertificate *pThis, PRUnichar * *subjectUniqueIdentifier);

    nsresult (*GetCertificateAuthority)(ICertificate *pThis, PRBool *certificateAuthority);

    nsresult (*GetKeyUsage)(ICertificate *pThis, PRUint32 *keyUsage);

    nsresult (*GetExtendedKeyUsage)(ICertificate *pThis, PRUint32 *extendedKeyUsageSize, PRUnichar * **extendedKeyUsage);

    nsresult (*GetRawCertData)(ICertificate *pThis, PRUint32 *rawCertDataSize, PRUint8 **rawCertData);

    nsresult (*GetSelfSigned)(ICertificate *pThis, PRBool *selfSigned);

    nsresult (*GetTrusted)(ICertificate *pThis, PRBool *trusted);

    nsresult (*GetExpired)(ICertificate *pThis, PRBool *expired);

    nsresult (*GetInternalAndReservedAttribute1ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12ICertificate)(ICertificate *pThis, PRUint32 *reserved);

    nsresult (*IsCurrentlyExpired)(
        ICertificate *pThis,
        PRBool * result
    );

    nsresult (*QueryInfo)(
        ICertificate *pThis,
        PRInt32 what,
        PRUnichar * * result
    );

    nsresult (*InternalAndReservedMethod1ICertificate)(ICertificate *pThis);

    nsresult (*InternalAndReservedMethod2ICertificate)(ICertificate *pThis);

};
#define ICertificate_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define ICertificate_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define ICertificate_Release(p) ((p)->lpVtbl->Release(p))
#define ICertificate_get_VersionNumber(p, aVersionNumber) ((p)->lpVtbl->GetVersionNumber(p, aVersionNumber))
#define ICertificate_GetVersionNumber(p, aVersionNumber) ((p)->lpVtbl->GetVersionNumber(p, aVersionNumber))
#define ICertificate_get_SerialNumber(p, aSerialNumber) ((p)->lpVtbl->GetSerialNumber(p, aSerialNumber))
#define ICertificate_GetSerialNumber(p, aSerialNumber) ((p)->lpVtbl->GetSerialNumber(p, aSerialNumber))
#define ICertificate_get_SignatureAlgorithmOID(p, aSignatureAlgorithmOID) ((p)->lpVtbl->GetSignatureAlgorithmOID(p, aSignatureAlgorithmOID))
#define ICertificate_GetSignatureAlgorithmOID(p, aSignatureAlgorithmOID) ((p)->lpVtbl->GetSignatureAlgorithmOID(p, aSignatureAlgorithmOID))
#define ICertificate_get_SignatureAlgorithmName(p, aSignatureAlgorithmName) ((p)->lpVtbl->GetSignatureAlgorithmName(p, aSignatureAlgorithmName))
#define ICertificate_GetSignatureAlgorithmName(p, aSignatureAlgorithmName) ((p)->lpVtbl->GetSignatureAlgorithmName(p, aSignatureAlgorithmName))
#define ICertificate_get_IssuerName(p, aIssuerName) ((p)->lpVtbl->GetIssuerName(p, aIssuerName))
#define ICertificate_GetIssuerName(p, aIssuerName) ((p)->lpVtbl->GetIssuerName(p, aIssuerName))
#define ICertificate_get_SubjectName(p, aSubjectName) ((p)->lpVtbl->GetSubjectName(p, aSubjectName))
#define ICertificate_GetSubjectName(p, aSubjectName) ((p)->lpVtbl->GetSubjectName(p, aSubjectName))
#define ICertificate_get_FriendlyName(p, aFriendlyName) ((p)->lpVtbl->GetFriendlyName(p, aFriendlyName))
#define ICertificate_GetFriendlyName(p, aFriendlyName) ((p)->lpVtbl->GetFriendlyName(p, aFriendlyName))
#define ICertificate_get_ValidityPeriodNotBefore(p, aValidityPeriodNotBefore) ((p)->lpVtbl->GetValidityPeriodNotBefore(p, aValidityPeriodNotBefore))
#define ICertificate_GetValidityPeriodNotBefore(p, aValidityPeriodNotBefore) ((p)->lpVtbl->GetValidityPeriodNotBefore(p, aValidityPeriodNotBefore))
#define ICertificate_get_ValidityPeriodNotAfter(p, aValidityPeriodNotAfter) ((p)->lpVtbl->GetValidityPeriodNotAfter(p, aValidityPeriodNotAfter))
#define ICertificate_GetValidityPeriodNotAfter(p, aValidityPeriodNotAfter) ((p)->lpVtbl->GetValidityPeriodNotAfter(p, aValidityPeriodNotAfter))
#define ICertificate_get_PublicKeyAlgorithmOID(p, aPublicKeyAlgorithmOID) ((p)->lpVtbl->GetPublicKeyAlgorithmOID(p, aPublicKeyAlgorithmOID))
#define ICertificate_GetPublicKeyAlgorithmOID(p, aPublicKeyAlgorithmOID) ((p)->lpVtbl->GetPublicKeyAlgorithmOID(p, aPublicKeyAlgorithmOID))
#define ICertificate_get_PublicKeyAlgorithm(p, aPublicKeyAlgorithm) ((p)->lpVtbl->GetPublicKeyAlgorithm(p, aPublicKeyAlgorithm))
#define ICertificate_GetPublicKeyAlgorithm(p, aPublicKeyAlgorithm) ((p)->lpVtbl->GetPublicKeyAlgorithm(p, aPublicKeyAlgorithm))
#define ICertificate_get_SubjectPublicKey(p, aSubjectPublicKey) ((p)->lpVtbl->GetSubjectPublicKey(p, aSubjectPublicKey))
#define ICertificate_GetSubjectPublicKey(p, aSubjectPublicKey) ((p)->lpVtbl->GetSubjectPublicKey(p, aSubjectPublicKey))
#define ICertificate_get_IssuerUniqueIdentifier(p, aIssuerUniqueIdentifier) ((p)->lpVtbl->GetIssuerUniqueIdentifier(p, aIssuerUniqueIdentifier))
#define ICertificate_GetIssuerUniqueIdentifier(p, aIssuerUniqueIdentifier) ((p)->lpVtbl->GetIssuerUniqueIdentifier(p, aIssuerUniqueIdentifier))
#define ICertificate_get_SubjectUniqueIdentifier(p, aSubjectUniqueIdentifier) ((p)->lpVtbl->GetSubjectUniqueIdentifier(p, aSubjectUniqueIdentifier))
#define ICertificate_GetSubjectUniqueIdentifier(p, aSubjectUniqueIdentifier) ((p)->lpVtbl->GetSubjectUniqueIdentifier(p, aSubjectUniqueIdentifier))
#define ICertificate_get_CertificateAuthority(p, aCertificateAuthority) ((p)->lpVtbl->GetCertificateAuthority(p, aCertificateAuthority))
#define ICertificate_GetCertificateAuthority(p, aCertificateAuthority) ((p)->lpVtbl->GetCertificateAuthority(p, aCertificateAuthority))
#define ICertificate_get_KeyUsage(p, aKeyUsage) ((p)->lpVtbl->GetKeyUsage(p, aKeyUsage))
#define ICertificate_GetKeyUsage(p, aKeyUsage) ((p)->lpVtbl->GetKeyUsage(p, aKeyUsage))
#define ICertificate_get_ExtendedKeyUsage(p, aExtendedKeyUsage) ((p)->lpVtbl->GetExtendedKeyUsage(p, aExtendedKeyUsage))
#define ICertificate_GetExtendedKeyUsage(p, aExtendedKeyUsage) ((p)->lpVtbl->GetExtendedKeyUsage(p, aExtendedKeyUsage))
#define ICertificate_get_RawCertData(p, aRawCertData) ((p)->lpVtbl->GetRawCertData(p, aRawCertData))
#define ICertificate_GetRawCertData(p, aRawCertData) ((p)->lpVtbl->GetRawCertData(p, aRawCertData))
#define ICertificate_get_SelfSigned(p, aSelfSigned) ((p)->lpVtbl->GetSelfSigned(p, aSelfSigned))
#define ICertificate_GetSelfSigned(p, aSelfSigned) ((p)->lpVtbl->GetSelfSigned(p, aSelfSigned))
#define ICertificate_get_Trusted(p, aTrusted) ((p)->lpVtbl->GetTrusted(p, aTrusted))
#define ICertificate_GetTrusted(p, aTrusted) ((p)->lpVtbl->GetTrusted(p, aTrusted))
#define ICertificate_get_Expired(p, aExpired) ((p)->lpVtbl->GetExpired(p, aExpired))
#define ICertificate_GetExpired(p, aExpired) ((p)->lpVtbl->GetExpired(p, aExpired))
#define ICertificate_IsCurrentlyExpired(p, aResult) ((p)->lpVtbl->IsCurrentlyExpired(p, aResult))
#define ICertificate_QueryInfo(p, aWhat, aResult) ((p)->lpVtbl->QueryInfo(p, aWhat, aResult))
#endif /* VBOX_WITH_GLUE */

interface ICertificate
{
#ifndef VBOX_WITH_GLUE
    struct ICertificate_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct ICertificateVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct ICertificate declaration */


/* Start of struct IAppliance declaration */
#define IAPPLIANCE_IID_STR "86a98347-7619-41aa-aece-b21ac5c1a7e6"
#define IAPPLIANCE_IID { \
    0x86a98347, 0x7619, 0x41aa, \
    { 0xae, 0xce, 0xb2, 0x1a, 0xc5, 0xc1, 0xa7, 0xe6 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IAppliance);
#ifndef VBOX_WITH_GLUE
struct IAppliance_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetPath)(IAppliance *pThis, PRUnichar * *path);

    nsresult (*GetDisks)(IAppliance *pThis, PRUint32 *disksSize, PRUnichar * **disks);

    nsresult (*GetVirtualSystemDescriptions)(IAppliance *pThis, PRUint32 *virtualSystemDescriptionsSize, IVirtualSystemDescription * **virtualSystemDescriptions);

    nsresult (*GetMachines)(IAppliance *pThis, PRUint32 *machinesSize, PRUnichar * **machines);

    nsresult (*GetCertificate)(IAppliance *pThis, ICertificate * *certificate);

    nsresult (*GetInternalAndReservedAttribute1IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*Read)(
        IAppliance *pThis,
        PRUnichar * file,
        IProgress * * progress
    );

    nsresult (*Interpret)(IAppliance *pThis );

    nsresult (*ImportMachines)(
        IAppliance *pThis,
        PRUint32 optionsSize,
        PRUint32* options,
        IProgress * * progress
    );

    nsresult (*CreateVFSExplorer)(
        IAppliance *pThis,
        PRUnichar * URI,
        IVFSExplorer * * explorer
    );

    nsresult (*Write)(
        IAppliance *pThis,
        PRUnichar * format,
        PRUint32 optionsSize,
        PRUint32* options,
        PRUnichar * path,
        IProgress * * progress
    );

    nsresult (*GetWarnings)(
        IAppliance *pThis,
        PRUint32 *warningsSize,
        PRUnichar *** warnings
    );

    nsresult (*GetPasswordIds)(
        IAppliance *pThis,
        PRUint32 *identifiersSize,
        PRUnichar *** identifiers
    );

    nsresult (*GetMediumIdsForPasswordId)(
        IAppliance *pThis,
        PRUnichar * passwordId,
        PRUint32 *identifiersSize,
        PRUnichar *** identifiers
    );

    nsresult (*AddPasswords)(
        IAppliance *pThis,
        PRUint32 identifiersSize,
        PRUnichar ** identifiers,
        PRUint32 passwordsSize,
        PRUnichar ** passwords
    );

    nsresult (*CreateVirtualSystemDescriptions)(
        IAppliance *pThis,
        PRUint32 requested,
        PRUint32 * created
    );

    nsresult (*InternalAndReservedMethod1IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod2IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod3IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod4IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod5IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod6IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod7IAppliance)(IAppliance *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IApplianceVtbl
{
    nsresult (*QueryInterface)(IAppliance *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IAppliance *pThis);
    nsrefcnt (*Release)(IAppliance *pThis);
    nsresult (*GetPath)(IAppliance *pThis, PRUnichar * *path);

    nsresult (*GetDisks)(IAppliance *pThis, PRUint32 *disksSize, PRUnichar * **disks);

    nsresult (*GetVirtualSystemDescriptions)(IAppliance *pThis, PRUint32 *virtualSystemDescriptionsSize, IVirtualSystemDescription * **virtualSystemDescriptions);

    nsresult (*GetMachines)(IAppliance *pThis, PRUint32 *machinesSize, PRUnichar * **machines);

    nsresult (*GetCertificate)(IAppliance *pThis, ICertificate * *certificate);

    nsresult (*GetInternalAndReservedAttribute1IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IAppliance)(IAppliance *pThis, PRUint32 *reserved);

    nsresult (*Read)(
        IAppliance *pThis,
        PRUnichar * file,
        IProgress * * progress
    );

    nsresult (*Interpret)(IAppliance *pThis );

    nsresult (*ImportMachines)(
        IAppliance *pThis,
        PRUint32 optionsSize,
        PRUint32* options,
        IProgress * * progress
    );

    nsresult (*CreateVFSExplorer)(
        IAppliance *pThis,
        PRUnichar * URI,
        IVFSExplorer * * explorer
    );

    nsresult (*Write)(
        IAppliance *pThis,
        PRUnichar * format,
        PRUint32 optionsSize,
        PRUint32* options,
        PRUnichar * path,
        IProgress * * progress
    );

    nsresult (*GetWarnings)(
        IAppliance *pThis,
        PRUint32 *warningsSize,
        PRUnichar *** warnings
    );

    nsresult (*GetPasswordIds)(
        IAppliance *pThis,
        PRUint32 *identifiersSize,
        PRUnichar *** identifiers
    );

    nsresult (*GetMediumIdsForPasswordId)(
        IAppliance *pThis,
        PRUnichar * passwordId,
        PRUint32 *identifiersSize,
        PRUnichar *** identifiers
    );

    nsresult (*AddPasswords)(
        IAppliance *pThis,
        PRUint32 identifiersSize,
        PRUnichar ** identifiers,
        PRUint32 passwordsSize,
        PRUnichar ** passwords
    );

    nsresult (*CreateVirtualSystemDescriptions)(
        IAppliance *pThis,
        PRUint32 requested,
        PRUint32 * created
    );

    nsresult (*InternalAndReservedMethod1IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod2IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod3IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod4IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod5IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod6IAppliance)(IAppliance *pThis);

    nsresult (*InternalAndReservedMethod7IAppliance)(IAppliance *pThis);

};
#define IAppliance_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IAppliance_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IAppliance_Release(p) ((p)->lpVtbl->Release(p))
#define IAppliance_get_Path(p, aPath) ((p)->lpVtbl->GetPath(p, aPath))
#define IAppliance_GetPath(p, aPath) ((p)->lpVtbl->GetPath(p, aPath))
#define IAppliance_get_Disks(p, aDisks) ((p)->lpVtbl->GetDisks(p, aDisks))
#define IAppliance_GetDisks(p, aDisks) ((p)->lpVtbl->GetDisks(p, aDisks))
#define IAppliance_get_VirtualSystemDescriptions(p, aVirtualSystemDescriptions) ((p)->lpVtbl->GetVirtualSystemDescriptions(p, aVirtualSystemDescriptions))
#define IAppliance_GetVirtualSystemDescriptions(p, aVirtualSystemDescriptions) ((p)->lpVtbl->GetVirtualSystemDescriptions(p, aVirtualSystemDescriptions))
#define IAppliance_get_Machines(p, aMachines) ((p)->lpVtbl->GetMachines(p, aMachines))
#define IAppliance_GetMachines(p, aMachines) ((p)->lpVtbl->GetMachines(p, aMachines))
#define IAppliance_get_Certificate(p, aCertificate) ((p)->lpVtbl->GetCertificate(p, aCertificate))
#define IAppliance_GetCertificate(p, aCertificate) ((p)->lpVtbl->GetCertificate(p, aCertificate))
#define IAppliance_Read(p, aFile, aProgress) ((p)->lpVtbl->Read(p, aFile, aProgress))
#define IAppliance_Interpret(p) ((p)->lpVtbl->Interpret(p))
#define IAppliance_ImportMachines(p, aOptions, aProgress) ((p)->lpVtbl->ImportMachines(p, aOptions, aProgress))
#define IAppliance_CreateVFSExplorer(p, aURI, aExplorer) ((p)->lpVtbl->CreateVFSExplorer(p, aURI, aExplorer))
#define IAppliance_Write(p, aFormat, aOptions, aPath, aProgress) ((p)->lpVtbl->Write(p, aFormat, aOptions, aPath, aProgress))
#define IAppliance_GetWarnings(p, aWarnings) ((p)->lpVtbl->GetWarnings(p, aWarnings))
#define IAppliance_GetPasswordIds(p, aIdentifiers) ((p)->lpVtbl->GetPasswordIds(p, aIdentifiers))
#define IAppliance_GetMediumIdsForPasswordId(p, aPasswordId, aIdentifiers) ((p)->lpVtbl->GetMediumIdsForPasswordId(p, aPasswordId, aIdentifiers))
#define IAppliance_AddPasswords(p, aIdentifiers, aPasswords) ((p)->lpVtbl->AddPasswords(p, aIdentifiers, aPasswords))
#define IAppliance_CreateVirtualSystemDescriptions(p, aRequested, aCreated) ((p)->lpVtbl->CreateVirtualSystemDescriptions(p, aRequested, aCreated))
#endif /* VBOX_WITH_GLUE */

interface IAppliance
{
#ifndef VBOX_WITH_GLUE
    struct IAppliance_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IApplianceVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IAppliance declaration */


/* Start of struct IVirtualSystemDescription declaration */
#define IVIRTUALSYSTEMDESCRIPTION_IID_STR "01510f40-c196-4d26-b8db-4c8c389f1f82"
#define IVIRTUALSYSTEMDESCRIPTION_IID { \
    0x01510f40, 0xc196, 0x4d26, \
    { 0xb8, 0xdb, 0x4c, 0x8c, 0x38, 0x9f, 0x1f, 0x82 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IVirtualSystemDescription);
#ifndef VBOX_WITH_GLUE
struct IVirtualSystemDescription_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetCount)(IVirtualSystemDescription *pThis, PRUint32 *count);

    nsresult (*GetInternalAndReservedAttribute1IVirtualSystemDescription)(IVirtualSystemDescription *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IVirtualSystemDescription)(IVirtualSystemDescription *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IVirtualSystemDescription)(IVirtualSystemDescription *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IVirtualSystemDescription)(IVirtualSystemDescription *pThis, PRUint32 *reserved);

    nsresult (*GetDescription)(
        IVirtualSystemDescription *pThis,
        PRUint32 *typesSize,
        PRUint32** types,
        PRUint32 *refsSize,
        PRUnichar *** refs,
        PRUint32 *OVFValuesSize,
        PRUnichar *** OVFValues,
        PRUint32 *VBoxValuesSize,
        PRUnichar *** VBoxValues,
        PRUint32 *extraConfigValuesSize,
        PRUnichar *** extraConfigValues
    );

    nsresult (*GetDescriptionByType)(
        IVirtualSystemDescription *pThis,
        PRUint32 type,
        PRUint32 *typesSize,
        PRUint32** types,
        PRUint32 *refsSize,
        PRUnichar *** refs,
        PRUint32 *OVFValuesSize,
        PRUnichar *** OVFValues,
        PRUint32 *VBoxValuesSize,
        PRUnichar *** VBoxValues,
        PRUint32 *extraConfigValuesSize,
        PRUnichar *** extraConfigValues
    );

    nsresult (*RemoveDescriptionByType)(
        IVirtualSystemDescription *pThis,
        PRUint32 type
    );

    nsresult (*GetValuesByType)(
        IVirtualSystemDescription *pThis,
        PRUint32 type,
        PRUint32 which,
        PRUint32 *valuesSize,
        PRUnichar *** values
    );

    nsresult (*SetFinalValues)(
        IVirtualSystemDescription *pThis,
        PRUint32 enabledSize,
        PRBool* enabled,
        PRUint32 VBoxValuesSize,
        PRUnichar ** VBoxValues,
        PRUint32 extraConfigValuesSize,
        PRUnichar ** extraConfigValues
    );

    nsresult (*AddDescription)(
        IVirtualSystemDescription *pThis,
        PRUint32 type,
        PRUnichar * VBoxValue,
        PRUnichar * extraConfigValue
    );

    nsresult (*InternalAndReservedMethod1IVirtualSystemDescription)(IVirtualSystemDescription *pThis);

    nsresult (*InternalAndReservedMethod2IVirtualSystemDescription)(IVirtualSystemDescription *pThis);

    nsresult (*InternalAndReservedMethod3IVirtualSystemDescription)(IVirtualSystemDescription *pThis);

    nsresult (*InternalAndReservedMethod4IVirtualSystemDescription)(IVirtualSystemDescription *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IVirtualSystemDescriptionVtbl
{
    nsresult (*QueryInterface)(IVirtualSystemDescription *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IVirtualSystemDescription *pThis);
    nsrefcnt (*Release)(IVirtualSystemDescription *pThis);
    nsresult (*GetCount)(IVirtualSystemDescription *pThis, PRUint32 *count);

    nsresult (*GetInternalAndReservedAttribute1IVirtualSystemDescription)(IVirtualSystemDescription *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IVirtualSystemDescription)(IVirtualSystemDescription *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IVirtualSystemDescription)(IVirtualSystemDescription *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IVirtualSystemDescription)(IVirtualSystemDescription *pThis, PRUint32 *reserved);

    nsresult (*GetDescription)(
        IVirtualSystemDescription *pThis,
        PRUint32 *typesSize,
        PRUint32** types,
        PRUint32 *refsSize,
        PRUnichar *** refs,
        PRUint32 *OVFValuesSize,
        PRUnichar *** OVFValues,
        PRUint32 *VBoxValuesSize,
        PRUnichar *** VBoxValues,
        PRUint32 *extraConfigValuesSize,
        PRUnichar *** extraConfigValues
    );

    nsresult (*GetDescriptionByType)(
        IVirtualSystemDescription *pThis,
        PRUint32 type,
        PRUint32 *typesSize,
        PRUint32** types,
        PRUint32 *refsSize,
        PRUnichar *** refs,
        PRUint32 *OVFValuesSize,
        PRUnichar *** OVFValues,
        PRUint32 *VBoxValuesSize,
        PRUnichar *** VBoxValues,
        PRUint32 *extraConfigValuesSize,
        PRUnichar *** extraConfigValues
    );

    nsresult (*RemoveDescriptionByType)(
        IVirtualSystemDescription *pThis,
        PRUint32 type
    );

    nsresult (*GetValuesByType)(
        IVirtualSystemDescription *pThis,
        PRUint32 type,
        PRUint32 which,
        PRUint32 *valuesSize,
        PRUnichar *** values
    );

    nsresult (*SetFinalValues)(
        IVirtualSystemDescription *pThis,
        PRUint32 enabledSize,
        PRBool* enabled,
        PRUint32 VBoxValuesSize,
        PRUnichar ** VBoxValues,
        PRUint32 extraConfigValuesSize,
        PRUnichar ** extraConfigValues
    );

    nsresult (*AddDescription)(
        IVirtualSystemDescription *pThis,
        PRUint32 type,
        PRUnichar * VBoxValue,
        PRUnichar * extraConfigValue
    );

    nsresult (*InternalAndReservedMethod1IVirtualSystemDescription)(IVirtualSystemDescription *pThis);

    nsresult (*InternalAndReservedMethod2IVirtualSystemDescription)(IVirtualSystemDescription *pThis);

    nsresult (*InternalAndReservedMethod3IVirtualSystemDescription)(IVirtualSystemDescription *pThis);

    nsresult (*InternalAndReservedMethod4IVirtualSystemDescription)(IVirtualSystemDescription *pThis);

};
#define IVirtualSystemDescription_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IVirtualSystemDescription_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IVirtualSystemDescription_Release(p) ((p)->lpVtbl->Release(p))
#define IVirtualSystemDescription_get_Count(p, aCount) ((p)->lpVtbl->GetCount(p, aCount))
#define IVirtualSystemDescription_GetCount(p, aCount) ((p)->lpVtbl->GetCount(p, aCount))
#define IVirtualSystemDescription_GetDescription(p, aTypes, aRefs, aOVFValues, aVBoxValues, aExtraConfigValues) ((p)->lpVtbl->GetDescription(p, aTypes, aRefs, aOVFValues, aVBoxValues, aExtraConfigValues))
#define IVirtualSystemDescription_GetDescriptionByType(p, aType, aTypes, aRefs, aOVFValues, aVBoxValues, aExtraConfigValues) ((p)->lpVtbl->GetDescriptionByType(p, aType, aTypes, aRefs, aOVFValues, aVBoxValues, aExtraConfigValues))
#define IVirtualSystemDescription_RemoveDescriptionByType(p, aType) ((p)->lpVtbl->RemoveDescriptionByType(p, aType))
#define IVirtualSystemDescription_GetValuesByType(p, aType, aWhich, aValues) ((p)->lpVtbl->GetValuesByType(p, aType, aWhich, aValues))
#define IVirtualSystemDescription_SetFinalValues(p, aEnabled, aVBoxValues, aExtraConfigValues) ((p)->lpVtbl->SetFinalValues(p, aEnabled, aVBoxValues, aExtraConfigValues))
#define IVirtualSystemDescription_AddDescription(p, aType, aVBoxValue, aExtraConfigValue) ((p)->lpVtbl->AddDescription(p, aType, aVBoxValue, aExtraConfigValue))
#endif /* VBOX_WITH_GLUE */

interface IVirtualSystemDescription
{
#ifndef VBOX_WITH_GLUE
    struct IVirtualSystemDescription_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IVirtualSystemDescriptionVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IVirtualSystemDescription declaration */


/* Start of struct IUnattended declaration */
#define IUNATTENDED_IID_STR "a71e5822-365b-49ba-bd14-c8d616e6740d"
#define IUNATTENDED_IID { \
    0xa71e5822, 0x365b, 0x49ba, \
    { 0xbd, 0x14, 0xc8, 0xd6, 0x16, 0xe6, 0x74, 0x0d } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IUnattended);
#ifndef VBOX_WITH_GLUE
struct IUnattended_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetIsoPath)(IUnattended *pThis, PRUnichar * *isoPath);
    nsresult (*SetIsoPath)(IUnattended *pThis, PRUnichar * isoPath);

    nsresult (*GetMachine)(IUnattended *pThis, IMachine * *machine);
    nsresult (*SetMachine)(IUnattended *pThis, IMachine * machine);

    nsresult (*GetUser)(IUnattended *pThis, PRUnichar * *user);
    nsresult (*SetUser)(IUnattended *pThis, PRUnichar * user);

    nsresult (*GetUserPassword)(IUnattended *pThis, PRUnichar * *userPassword);
    nsresult (*SetUserPassword)(IUnattended *pThis, PRUnichar * userPassword);

    nsresult (*GetAdminPassword)(IUnattended *pThis, PRUnichar * *adminPassword);
    nsresult (*SetAdminPassword)(IUnattended *pThis, PRUnichar * adminPassword);

    nsresult (*GetFullUserName)(IUnattended *pThis, PRUnichar * *fullUserName);
    nsresult (*SetFullUserName)(IUnattended *pThis, PRUnichar * fullUserName);

    nsresult (*GetProductKey)(IUnattended *pThis, PRUnichar * *productKey);
    nsresult (*SetProductKey)(IUnattended *pThis, PRUnichar * productKey);

    nsresult (*GetAdditionsIsoPath)(IUnattended *pThis, PRUnichar * *additionsIsoPath);
    nsresult (*SetAdditionsIsoPath)(IUnattended *pThis, PRUnichar * additionsIsoPath);

    nsresult (*GetInstallGuestAdditions)(IUnattended *pThis, PRBool *installGuestAdditions);
    nsresult (*SetInstallGuestAdditions)(IUnattended *pThis, PRBool installGuestAdditions);

    nsresult (*GetValidationKitIsoPath)(IUnattended *pThis, PRUnichar * *validationKitIsoPath);
    nsresult (*SetValidationKitIsoPath)(IUnattended *pThis, PRUnichar * validationKitIsoPath);

    nsresult (*GetInstallTestExecService)(IUnattended *pThis, PRBool *installTestExecService);
    nsresult (*SetInstallTestExecService)(IUnattended *pThis, PRBool installTestExecService);

    nsresult (*GetUserPayloadIsoPath)(IUnattended *pThis, PRUnichar * *userPayloadIsoPath);
    nsresult (*SetUserPayloadIsoPath)(IUnattended *pThis, PRUnichar * userPayloadIsoPath);

    nsresult (*GetInstallUserPayload)(IUnattended *pThis, PRBool *installUserPayload);
    nsresult (*SetInstallUserPayload)(IUnattended *pThis, PRBool installUserPayload);

    nsresult (*GetTimeZone)(IUnattended *pThis, PRUnichar * *timeZone);
    nsresult (*SetTimeZone)(IUnattended *pThis, PRUnichar * timeZone);

    nsresult (*GetKeyboardLayout)(IUnattended *pThis, PRUnichar * *keyboardLayout);
    nsresult (*SetKeyboardLayout)(IUnattended *pThis, PRUnichar * keyboardLayout);

    nsresult (*GetKeyboardVariant)(IUnattended *pThis, PRUnichar * *keyboardVariant);
    nsresult (*SetKeyboardVariant)(IUnattended *pThis, PRUnichar * keyboardVariant);

    nsresult (*GetLocale)(IUnattended *pThis, PRUnichar * *locale);
    nsresult (*SetLocale)(IUnattended *pThis, PRUnichar * locale);

    nsresult (*GetLanguage)(IUnattended *pThis, PRUnichar * *language);
    nsresult (*SetLanguage)(IUnattended *pThis, PRUnichar * language);

    nsresult (*GetCountry)(IUnattended *pThis, PRUnichar * *country);
    nsresult (*SetCountry)(IUnattended *pThis, PRUnichar * country);

    nsresult (*GetProxy)(IUnattended *pThis, PRUnichar * *proxy);
    nsresult (*SetProxy)(IUnattended *pThis, PRUnichar * proxy);

    nsresult (*GetPackageSelectionAdjustments)(IUnattended *pThis, PRUnichar * *packageSelectionAdjustments);
    nsresult (*SetPackageSelectionAdjustments)(IUnattended *pThis, PRUnichar * packageSelectionAdjustments);

    nsresult (*GetHostname)(IUnattended *pThis, PRUnichar * *hostname);
    nsresult (*SetHostname)(IUnattended *pThis, PRUnichar * hostname);

    nsresult (*GetAuxiliaryBasePath)(IUnattended *pThis, PRUnichar * *auxiliaryBasePath);
    nsresult (*SetAuxiliaryBasePath)(IUnattended *pThis, PRUnichar * auxiliaryBasePath);

    nsresult (*GetImageIndex)(IUnattended *pThis, PRUint32 *imageIndex);
    nsresult (*SetImageIndex)(IUnattended *pThis, PRUint32 imageIndex);

    nsresult (*GetScriptTemplatePath)(IUnattended *pThis, PRUnichar * *scriptTemplatePath);
    nsresult (*SetScriptTemplatePath)(IUnattended *pThis, PRUnichar * scriptTemplatePath);

    nsresult (*GetPostInstallScriptTemplatePath)(IUnattended *pThis, PRUnichar * *postInstallScriptTemplatePath);
    nsresult (*SetPostInstallScriptTemplatePath)(IUnattended *pThis, PRUnichar * postInstallScriptTemplatePath);

    nsresult (*GetPostInstallCommand)(IUnattended *pThis, PRUnichar * *postInstallCommand);
    nsresult (*SetPostInstallCommand)(IUnattended *pThis, PRUnichar * postInstallCommand);

    nsresult (*GetExtraInstallKernelParameters)(IUnattended *pThis, PRUnichar * *extraInstallKernelParameters);
    nsresult (*SetExtraInstallKernelParameters)(IUnattended *pThis, PRUnichar * extraInstallKernelParameters);

    nsresult (*GetDetectedOSTypeId)(IUnattended *pThis, PRUnichar * *detectedOSTypeId);

    nsresult (*GetDetectedOSVersion)(IUnattended *pThis, PRUnichar * *detectedOSVersion);

    nsresult (*GetDetectedOSFlavor)(IUnattended *pThis, PRUnichar * *detectedOSFlavor);

    nsresult (*GetDetectedOSLanguages)(IUnattended *pThis, PRUnichar * *detectedOSLanguages);

    nsresult (*GetDetectedOSHints)(IUnattended *pThis, PRUnichar * *detectedOSHints);

    nsresult (*GetDetectedImageNames)(IUnattended *pThis, PRUint32 *detectedImageNamesSize, PRUnichar * **detectedImageNames);

    nsresult (*GetDetectedImageIndices)(IUnattended *pThis, PRUint32 *detectedImageIndicesSize, PRUint32 **detectedImageIndices);

    nsresult (*GetIsUnattendedInstallSupported)(IUnattended *pThis, PRBool *isUnattendedInstallSupported);

    nsresult (*GetAvoidUpdatesOverNetwork)(IUnattended *pThis, PRBool *avoidUpdatesOverNetwork);
    nsresult (*SetAvoidUpdatesOverNetwork)(IUnattended *pThis, PRBool avoidUpdatesOverNetwork);

    nsresult (*GetInternalAndReservedAttribute1IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*DetectIsoOS)(IUnattended *pThis );

    nsresult (*Prepare)(IUnattended *pThis );

    nsresult (*ConstructMedia)(IUnattended *pThis );

    nsresult (*ReconfigureVM)(IUnattended *pThis );

    nsresult (*Done)(IUnattended *pThis );

    nsresult (*InternalAndReservedMethod1IUnattended)(IUnattended *pThis);

    nsresult (*InternalAndReservedMethod2IUnattended)(IUnattended *pThis);

    nsresult (*InternalAndReservedMethod3IUnattended)(IUnattended *pThis);

    nsresult (*InternalAndReservedMethod4IUnattended)(IUnattended *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IUnattendedVtbl
{
    nsresult (*QueryInterface)(IUnattended *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IUnattended *pThis);
    nsrefcnt (*Release)(IUnattended *pThis);
    nsresult (*GetIsoPath)(IUnattended *pThis, PRUnichar * *isoPath);
    nsresult (*SetIsoPath)(IUnattended *pThis, PRUnichar * isoPath);

    nsresult (*GetMachine)(IUnattended *pThis, IMachine * *machine);
    nsresult (*SetMachine)(IUnattended *pThis, IMachine * machine);

    nsresult (*GetUser)(IUnattended *pThis, PRUnichar * *user);
    nsresult (*SetUser)(IUnattended *pThis, PRUnichar * user);

    nsresult (*GetUserPassword)(IUnattended *pThis, PRUnichar * *userPassword);
    nsresult (*SetUserPassword)(IUnattended *pThis, PRUnichar * userPassword);

    nsresult (*GetAdminPassword)(IUnattended *pThis, PRUnichar * *adminPassword);
    nsresult (*SetAdminPassword)(IUnattended *pThis, PRUnichar * adminPassword);

    nsresult (*GetFullUserName)(IUnattended *pThis, PRUnichar * *fullUserName);
    nsresult (*SetFullUserName)(IUnattended *pThis, PRUnichar * fullUserName);

    nsresult (*GetProductKey)(IUnattended *pThis, PRUnichar * *productKey);
    nsresult (*SetProductKey)(IUnattended *pThis, PRUnichar * productKey);

    nsresult (*GetAdditionsIsoPath)(IUnattended *pThis, PRUnichar * *additionsIsoPath);
    nsresult (*SetAdditionsIsoPath)(IUnattended *pThis, PRUnichar * additionsIsoPath);

    nsresult (*GetInstallGuestAdditions)(IUnattended *pThis, PRBool *installGuestAdditions);
    nsresult (*SetInstallGuestAdditions)(IUnattended *pThis, PRBool installGuestAdditions);

    nsresult (*GetValidationKitIsoPath)(IUnattended *pThis, PRUnichar * *validationKitIsoPath);
    nsresult (*SetValidationKitIsoPath)(IUnattended *pThis, PRUnichar * validationKitIsoPath);

    nsresult (*GetInstallTestExecService)(IUnattended *pThis, PRBool *installTestExecService);
    nsresult (*SetInstallTestExecService)(IUnattended *pThis, PRBool installTestExecService);

    nsresult (*GetUserPayloadIsoPath)(IUnattended *pThis, PRUnichar * *userPayloadIsoPath);
    nsresult (*SetUserPayloadIsoPath)(IUnattended *pThis, PRUnichar * userPayloadIsoPath);

    nsresult (*GetInstallUserPayload)(IUnattended *pThis, PRBool *installUserPayload);
    nsresult (*SetInstallUserPayload)(IUnattended *pThis, PRBool installUserPayload);

    nsresult (*GetTimeZone)(IUnattended *pThis, PRUnichar * *timeZone);
    nsresult (*SetTimeZone)(IUnattended *pThis, PRUnichar * timeZone);

    nsresult (*GetKeyboardLayout)(IUnattended *pThis, PRUnichar * *keyboardLayout);
    nsresult (*SetKeyboardLayout)(IUnattended *pThis, PRUnichar * keyboardLayout);

    nsresult (*GetKeyboardVariant)(IUnattended *pThis, PRUnichar * *keyboardVariant);
    nsresult (*SetKeyboardVariant)(IUnattended *pThis, PRUnichar * keyboardVariant);

    nsresult (*GetLocale)(IUnattended *pThis, PRUnichar * *locale);
    nsresult (*SetLocale)(IUnattended *pThis, PRUnichar * locale);

    nsresult (*GetLanguage)(IUnattended *pThis, PRUnichar * *language);
    nsresult (*SetLanguage)(IUnattended *pThis, PRUnichar * language);

    nsresult (*GetCountry)(IUnattended *pThis, PRUnichar * *country);
    nsresult (*SetCountry)(IUnattended *pThis, PRUnichar * country);

    nsresult (*GetProxy)(IUnattended *pThis, PRUnichar * *proxy);
    nsresult (*SetProxy)(IUnattended *pThis, PRUnichar * proxy);

    nsresult (*GetPackageSelectionAdjustments)(IUnattended *pThis, PRUnichar * *packageSelectionAdjustments);
    nsresult (*SetPackageSelectionAdjustments)(IUnattended *pThis, PRUnichar * packageSelectionAdjustments);

    nsresult (*GetHostname)(IUnattended *pThis, PRUnichar * *hostname);
    nsresult (*SetHostname)(IUnattended *pThis, PRUnichar * hostname);

    nsresult (*GetAuxiliaryBasePath)(IUnattended *pThis, PRUnichar * *auxiliaryBasePath);
    nsresult (*SetAuxiliaryBasePath)(IUnattended *pThis, PRUnichar * auxiliaryBasePath);

    nsresult (*GetImageIndex)(IUnattended *pThis, PRUint32 *imageIndex);
    nsresult (*SetImageIndex)(IUnattended *pThis, PRUint32 imageIndex);

    nsresult (*GetScriptTemplatePath)(IUnattended *pThis, PRUnichar * *scriptTemplatePath);
    nsresult (*SetScriptTemplatePath)(IUnattended *pThis, PRUnichar * scriptTemplatePath);

    nsresult (*GetPostInstallScriptTemplatePath)(IUnattended *pThis, PRUnichar * *postInstallScriptTemplatePath);
    nsresult (*SetPostInstallScriptTemplatePath)(IUnattended *pThis, PRUnichar * postInstallScriptTemplatePath);

    nsresult (*GetPostInstallCommand)(IUnattended *pThis, PRUnichar * *postInstallCommand);
    nsresult (*SetPostInstallCommand)(IUnattended *pThis, PRUnichar * postInstallCommand);

    nsresult (*GetExtraInstallKernelParameters)(IUnattended *pThis, PRUnichar * *extraInstallKernelParameters);
    nsresult (*SetExtraInstallKernelParameters)(IUnattended *pThis, PRUnichar * extraInstallKernelParameters);

    nsresult (*GetDetectedOSTypeId)(IUnattended *pThis, PRUnichar * *detectedOSTypeId);

    nsresult (*GetDetectedOSVersion)(IUnattended *pThis, PRUnichar * *detectedOSVersion);

    nsresult (*GetDetectedOSFlavor)(IUnattended *pThis, PRUnichar * *detectedOSFlavor);

    nsresult (*GetDetectedOSLanguages)(IUnattended *pThis, PRUnichar * *detectedOSLanguages);

    nsresult (*GetDetectedOSHints)(IUnattended *pThis, PRUnichar * *detectedOSHints);

    nsresult (*GetDetectedImageNames)(IUnattended *pThis, PRUint32 *detectedImageNamesSize, PRUnichar * **detectedImageNames);

    nsresult (*GetDetectedImageIndices)(IUnattended *pThis, PRUint32 *detectedImageIndicesSize, PRUint32 **detectedImageIndices);

    nsresult (*GetIsUnattendedInstallSupported)(IUnattended *pThis, PRBool *isUnattendedInstallSupported);

    nsresult (*GetAvoidUpdatesOverNetwork)(IUnattended *pThis, PRBool *avoidUpdatesOverNetwork);
    nsresult (*SetAvoidUpdatesOverNetwork)(IUnattended *pThis, PRBool avoidUpdatesOverNetwork);

    nsresult (*GetInternalAndReservedAttribute1IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IUnattended)(IUnattended *pThis, PRUint32 *reserved);

    nsresult (*DetectIsoOS)(IUnattended *pThis );

    nsresult (*Prepare)(IUnattended *pThis );

    nsresult (*ConstructMedia)(IUnattended *pThis );

    nsresult (*ReconfigureVM)(IUnattended *pThis );

    nsresult (*Done)(IUnattended *pThis );

    nsresult (*InternalAndReservedMethod1IUnattended)(IUnattended *pThis);

    nsresult (*InternalAndReservedMethod2IUnattended)(IUnattended *pThis);

    nsresult (*InternalAndReservedMethod3IUnattended)(IUnattended *pThis);

    nsresult (*InternalAndReservedMethod4IUnattended)(IUnattended *pThis);

};
#define IUnattended_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IUnattended_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IUnattended_Release(p) ((p)->lpVtbl->Release(p))
#define IUnattended_get_IsoPath(p, aIsoPath) ((p)->lpVtbl->GetIsoPath(p, aIsoPath))
#define IUnattended_GetIsoPath(p, aIsoPath) ((p)->lpVtbl->GetIsoPath(p, aIsoPath))
#define IUnattended_put_IsoPath(p, aIsoPath) ((p)->lpVtbl->SetIsoPath(p, aIsoPath))
#define IUnattended_SetIsoPath(p, aIsoPath) ((p)->lpVtbl->SetIsoPath(p, aIsoPath))
#define IUnattended_get_Machine(p, aMachine) ((p)->lpVtbl->GetMachine(p, aMachine))
#define IUnattended_GetMachine(p, aMachine) ((p)->lpVtbl->GetMachine(p, aMachine))
#define IUnattended_put_Machine(p, aMachine) ((p)->lpVtbl->SetMachine(p, aMachine))
#define IUnattended_SetMachine(p, aMachine) ((p)->lpVtbl->SetMachine(p, aMachine))
#define IUnattended_get_User(p, aUser) ((p)->lpVtbl->GetUser(p, aUser))
#define IUnattended_GetUser(p, aUser) ((p)->lpVtbl->GetUser(p, aUser))
#define IUnattended_put_User(p, aUser) ((p)->lpVtbl->SetUser(p, aUser))
#define IUnattended_SetUser(p, aUser) ((p)->lpVtbl->SetUser(p, aUser))
#define IUnattended_get_UserPassword(p, aUserPassword) ((p)->lpVtbl->GetUserPassword(p, aUserPassword))
#define IUnattended_GetUserPassword(p, aUserPassword) ((p)->lpVtbl->GetUserPassword(p, aUserPassword))
#define IUnattended_put_UserPassword(p, aUserPassword) ((p)->lpVtbl->SetUserPassword(p, aUserPassword))
#define IUnattended_SetUserPassword(p, aUserPassword) ((p)->lpVtbl->SetUserPassword(p, aUserPassword))
#define IUnattended_get_AdminPassword(p, aAdminPassword) ((p)->lpVtbl->GetAdminPassword(p, aAdminPassword))
#define IUnattended_GetAdminPassword(p, aAdminPassword) ((p)->lpVtbl->GetAdminPassword(p, aAdminPassword))
#define IUnattended_put_AdminPassword(p, aAdminPassword) ((p)->lpVtbl->SetAdminPassword(p, aAdminPassword))
#define IUnattended_SetAdminPassword(p, aAdminPassword) ((p)->lpVtbl->SetAdminPassword(p, aAdminPassword))
#define IUnattended_get_FullUserName(p, aFullUserName) ((p)->lpVtbl->GetFullUserName(p, aFullUserName))
#define IUnattended_GetFullUserName(p, aFullUserName) ((p)->lpVtbl->GetFullUserName(p, aFullUserName))
#define IUnattended_put_FullUserName(p, aFullUserName) ((p)->lpVtbl->SetFullUserName(p, aFullUserName))
#define IUnattended_SetFullUserName(p, aFullUserName) ((p)->lpVtbl->SetFullUserName(p, aFullUserName))
#define IUnattended_get_ProductKey(p, aProductKey) ((p)->lpVtbl->GetProductKey(p, aProductKey))
#define IUnattended_GetProductKey(p, aProductKey) ((p)->lpVtbl->GetProductKey(p, aProductKey))
#define IUnattended_put_ProductKey(p, aProductKey) ((p)->lpVtbl->SetProductKey(p, aProductKey))
#define IUnattended_SetProductKey(p, aProductKey) ((p)->lpVtbl->SetProductKey(p, aProductKey))
#define IUnattended_get_AdditionsIsoPath(p, aAdditionsIsoPath) ((p)->lpVtbl->GetAdditionsIsoPath(p, aAdditionsIsoPath))
#define IUnattended_GetAdditionsIsoPath(p, aAdditionsIsoPath) ((p)->lpVtbl->GetAdditionsIsoPath(p, aAdditionsIsoPath))
#define IUnattended_put_AdditionsIsoPath(p, aAdditionsIsoPath) ((p)->lpVtbl->SetAdditionsIsoPath(p, aAdditionsIsoPath))
#define IUnattended_SetAdditionsIsoPath(p, aAdditionsIsoPath) ((p)->lpVtbl->SetAdditionsIsoPath(p, aAdditionsIsoPath))
#define IUnattended_get_InstallGuestAdditions(p, aInstallGuestAdditions) ((p)->lpVtbl->GetInstallGuestAdditions(p, aInstallGuestAdditions))
#define IUnattended_GetInstallGuestAdditions(p, aInstallGuestAdditions) ((p)->lpVtbl->GetInstallGuestAdditions(p, aInstallGuestAdditions))
#define IUnattended_put_InstallGuestAdditions(p, aInstallGuestAdditions) ((p)->lpVtbl->SetInstallGuestAdditions(p, aInstallGuestAdditions))
#define IUnattended_SetInstallGuestAdditions(p, aInstallGuestAdditions) ((p)->lpVtbl->SetInstallGuestAdditions(p, aInstallGuestAdditions))
#define IUnattended_get_ValidationKitIsoPath(p, aValidationKitIsoPath) ((p)->lpVtbl->GetValidationKitIsoPath(p, aValidationKitIsoPath))
#define IUnattended_GetValidationKitIsoPath(p, aValidationKitIsoPath) ((p)->lpVtbl->GetValidationKitIsoPath(p, aValidationKitIsoPath))
#define IUnattended_put_ValidationKitIsoPath(p, aValidationKitIsoPath) ((p)->lpVtbl->SetValidationKitIsoPath(p, aValidationKitIsoPath))
#define IUnattended_SetValidationKitIsoPath(p, aValidationKitIsoPath) ((p)->lpVtbl->SetValidationKitIsoPath(p, aValidationKitIsoPath))
#define IUnattended_get_InstallTestExecService(p, aInstallTestExecService) ((p)->lpVtbl->GetInstallTestExecService(p, aInstallTestExecService))
#define IUnattended_GetInstallTestExecService(p, aInstallTestExecService) ((p)->lpVtbl->GetInstallTestExecService(p, aInstallTestExecService))
#define IUnattended_put_InstallTestExecService(p, aInstallTestExecService) ((p)->lpVtbl->SetInstallTestExecService(p, aInstallTestExecService))
#define IUnattended_SetInstallTestExecService(p, aInstallTestExecService) ((p)->lpVtbl->SetInstallTestExecService(p, aInstallTestExecService))
#define IUnattended_get_UserPayloadIsoPath(p, aUserPayloadIsoPath) ((p)->lpVtbl->GetUserPayloadIsoPath(p, aUserPayloadIsoPath))
#define IUnattended_GetUserPayloadIsoPath(p, aUserPayloadIsoPath) ((p)->lpVtbl->GetUserPayloadIsoPath(p, aUserPayloadIsoPath))
#define IUnattended_put_UserPayloadIsoPath(p, aUserPayloadIsoPath) ((p)->lpVtbl->SetUserPayloadIsoPath(p, aUserPayloadIsoPath))
#define IUnattended_SetUserPayloadIsoPath(p, aUserPayloadIsoPath) ((p)->lpVtbl->SetUserPayloadIsoPath(p, aUserPayloadIsoPath))
#define IUnattended_get_InstallUserPayload(p, aInstallUserPayload) ((p)->lpVtbl->GetInstallUserPayload(p, aInstallUserPayload))
#define IUnattended_GetInstallUserPayload(p, aInstallUserPayload) ((p)->lpVtbl->GetInstallUserPayload(p, aInstallUserPayload))
#define IUnattended_put_InstallUserPayload(p, aInstallUserPayload) ((p)->lpVtbl->SetInstallUserPayload(p, aInstallUserPayload))
#define IUnattended_SetInstallUserPayload(p, aInstallUserPayload) ((p)->lpVtbl->SetInstallUserPayload(p, aInstallUserPayload))
#define IUnattended_get_TimeZone(p, aTimeZone) ((p)->lpVtbl->GetTimeZone(p, aTimeZone))
#define IUnattended_GetTimeZone(p, aTimeZone) ((p)->lpVtbl->GetTimeZone(p, aTimeZone))
#define IUnattended_put_TimeZone(p, aTimeZone) ((p)->lpVtbl->SetTimeZone(p, aTimeZone))
#define IUnattended_SetTimeZone(p, aTimeZone) ((p)->lpVtbl->SetTimeZone(p, aTimeZone))
#define IUnattended_get_KeyboardLayout(p, aKeyboardLayout) ((p)->lpVtbl->GetKeyboardLayout(p, aKeyboardLayout))
#define IUnattended_GetKeyboardLayout(p, aKeyboardLayout) ((p)->lpVtbl->GetKeyboardLayout(p, aKeyboardLayout))
#define IUnattended_put_KeyboardLayout(p, aKeyboardLayout) ((p)->lpVtbl->SetKeyboardLayout(p, aKeyboardLayout))
#define IUnattended_SetKeyboardLayout(p, aKeyboardLayout) ((p)->lpVtbl->SetKeyboardLayout(p, aKeyboardLayout))
#define IUnattended_get_KeyboardVariant(p, aKeyboardVariant) ((p)->lpVtbl->GetKeyboardVariant(p, aKeyboardVariant))
#define IUnattended_GetKeyboardVariant(p, aKeyboardVariant) ((p)->lpVtbl->GetKeyboardVariant(p, aKeyboardVariant))
#define IUnattended_put_KeyboardVariant(p, aKeyboardVariant) ((p)->lpVtbl->SetKeyboardVariant(p, aKeyboardVariant))
#define IUnattended_SetKeyboardVariant(p, aKeyboardVariant) ((p)->lpVtbl->SetKeyboardVariant(p, aKeyboardVariant))
#define IUnattended_get_Locale(p, aLocale) ((p)->lpVtbl->GetLocale(p, aLocale))
#define IUnattended_GetLocale(p, aLocale) ((p)->lpVtbl->GetLocale(p, aLocale))
#define IUnattended_put_Locale(p, aLocale) ((p)->lpVtbl->SetLocale(p, aLocale))
#define IUnattended_SetLocale(p, aLocale) ((p)->lpVtbl->SetLocale(p, aLocale))
#define IUnattended_get_Language(p, aLanguage) ((p)->lpVtbl->GetLanguage(p, aLanguage))
#define IUnattended_GetLanguage(p, aLanguage) ((p)->lpVtbl->GetLanguage(p, aLanguage))
#define IUnattended_put_Language(p, aLanguage) ((p)->lpVtbl->SetLanguage(p, aLanguage))
#define IUnattended_SetLanguage(p, aLanguage) ((p)->lpVtbl->SetLanguage(p, aLanguage))
#define IUnattended_get_Country(p, aCountry) ((p)->lpVtbl->GetCountry(p, aCountry))
#define IUnattended_GetCountry(p, aCountry) ((p)->lpVtbl->GetCountry(p, aCountry))
#define IUnattended_put_Country(p, aCountry) ((p)->lpVtbl->SetCountry(p, aCountry))
#define IUnattended_SetCountry(p, aCountry) ((p)->lpVtbl->SetCountry(p, aCountry))
#define IUnattended_get_Proxy(p, aProxy) ((p)->lpVtbl->GetProxy(p, aProxy))
#define IUnattended_GetProxy(p, aProxy) ((p)->lpVtbl->GetProxy(p, aProxy))
#define IUnattended_put_Proxy(p, aProxy) ((p)->lpVtbl->SetProxy(p, aProxy))
#define IUnattended_SetProxy(p, aProxy) ((p)->lpVtbl->SetProxy(p, aProxy))
#define IUnattended_get_PackageSelectionAdjustments(p, aPackageSelectionAdjustments) ((p)->lpVtbl->GetPackageSelectionAdjustments(p, aPackageSelectionAdjustments))
#define IUnattended_GetPackageSelectionAdjustments(p, aPackageSelectionAdjustments) ((p)->lpVtbl->GetPackageSelectionAdjustments(p, aPackageSelectionAdjustments))
#define IUnattended_put_PackageSelectionAdjustments(p, aPackageSelectionAdjustments) ((p)->lpVtbl->SetPackageSelectionAdjustments(p, aPackageSelectionAdjustments))
#define IUnattended_SetPackageSelectionAdjustments(p, aPackageSelectionAdjustments) ((p)->lpVtbl->SetPackageSelectionAdjustments(p, aPackageSelectionAdjustments))
#define IUnattended_get_Hostname(p, aHostname) ((p)->lpVtbl->GetHostname(p, aHostname))
#define IUnattended_GetHostname(p, aHostname) ((p)->lpVtbl->GetHostname(p, aHostname))
#define IUnattended_put_Hostname(p, aHostname) ((p)->lpVtbl->SetHostname(p, aHostname))
#define IUnattended_SetHostname(p, aHostname) ((p)->lpVtbl->SetHostname(p, aHostname))
#define IUnattended_get_AuxiliaryBasePath(p, aAuxiliaryBasePath) ((p)->lpVtbl->GetAuxiliaryBasePath(p, aAuxiliaryBasePath))
#define IUnattended_GetAuxiliaryBasePath(p, aAuxiliaryBasePath) ((p)->lpVtbl->GetAuxiliaryBasePath(p, aAuxiliaryBasePath))
#define IUnattended_put_AuxiliaryBasePath(p, aAuxiliaryBasePath) ((p)->lpVtbl->SetAuxiliaryBasePath(p, aAuxiliaryBasePath))
#define IUnattended_SetAuxiliaryBasePath(p, aAuxiliaryBasePath) ((p)->lpVtbl->SetAuxiliaryBasePath(p, aAuxiliaryBasePath))
#define IUnattended_get_ImageIndex(p, aImageIndex) ((p)->lpVtbl->GetImageIndex(p, aImageIndex))
#define IUnattended_GetImageIndex(p, aImageIndex) ((p)->lpVtbl->GetImageIndex(p, aImageIndex))
#define IUnattended_put_ImageIndex(p, aImageIndex) ((p)->lpVtbl->SetImageIndex(p, aImageIndex))
#define IUnattended_SetImageIndex(p, aImageIndex) ((p)->lpVtbl->SetImageIndex(p, aImageIndex))
#define IUnattended_get_ScriptTemplatePath(p, aScriptTemplatePath) ((p)->lpVtbl->GetScriptTemplatePath(p, aScriptTemplatePath))
#define IUnattended_GetScriptTemplatePath(p, aScriptTemplatePath) ((p)->lpVtbl->GetScriptTemplatePath(p, aScriptTemplatePath))
#define IUnattended_put_ScriptTemplatePath(p, aScriptTemplatePath) ((p)->lpVtbl->SetScriptTemplatePath(p, aScriptTemplatePath))
#define IUnattended_SetScriptTemplatePath(p, aScriptTemplatePath) ((p)->lpVtbl->SetScriptTemplatePath(p, aScriptTemplatePath))
#define IUnattended_get_PostInstallScriptTemplatePath(p, aPostInstallScriptTemplatePath) ((p)->lpVtbl->GetPostInstallScriptTemplatePath(p, aPostInstallScriptTemplatePath))
#define IUnattended_GetPostInstallScriptTemplatePath(p, aPostInstallScriptTemplatePath) ((p)->lpVtbl->GetPostInstallScriptTemplatePath(p, aPostInstallScriptTemplatePath))
#define IUnattended_put_PostInstallScriptTemplatePath(p, aPostInstallScriptTemplatePath) ((p)->lpVtbl->SetPostInstallScriptTemplatePath(p, aPostInstallScriptTemplatePath))
#define IUnattended_SetPostInstallScriptTemplatePath(p, aPostInstallScriptTemplatePath) ((p)->lpVtbl->SetPostInstallScriptTemplatePath(p, aPostInstallScriptTemplatePath))
#define IUnattended_get_PostInstallCommand(p, aPostInstallCommand) ((p)->lpVtbl->GetPostInstallCommand(p, aPostInstallCommand))
#define IUnattended_GetPostInstallCommand(p, aPostInstallCommand) ((p)->lpVtbl->GetPostInstallCommand(p, aPostInstallCommand))
#define IUnattended_put_PostInstallCommand(p, aPostInstallCommand) ((p)->lpVtbl->SetPostInstallCommand(p, aPostInstallCommand))
#define IUnattended_SetPostInstallCommand(p, aPostInstallCommand) ((p)->lpVtbl->SetPostInstallCommand(p, aPostInstallCommand))
#define IUnattended_get_ExtraInstallKernelParameters(p, aExtraInstallKernelParameters) ((p)->lpVtbl->GetExtraInstallKernelParameters(p, aExtraInstallKernelParameters))
#define IUnattended_GetExtraInstallKernelParameters(p, aExtraInstallKernelParameters) ((p)->lpVtbl->GetExtraInstallKernelParameters(p, aExtraInstallKernelParameters))
#define IUnattended_put_ExtraInstallKernelParameters(p, aExtraInstallKernelParameters) ((p)->lpVtbl->SetExtraInstallKernelParameters(p, aExtraInstallKernelParameters))
#define IUnattended_SetExtraInstallKernelParameters(p, aExtraInstallKernelParameters) ((p)->lpVtbl->SetExtraInstallKernelParameters(p, aExtraInstallKernelParameters))
#define IUnattended_get_DetectedOSTypeId(p, aDetectedOSTypeId) ((p)->lpVtbl->GetDetectedOSTypeId(p, aDetectedOSTypeId))
#define IUnattended_GetDetectedOSTypeId(p, aDetectedOSTypeId) ((p)->lpVtbl->GetDetectedOSTypeId(p, aDetectedOSTypeId))
#define IUnattended_get_DetectedOSVersion(p, aDetectedOSVersion) ((p)->lpVtbl->GetDetectedOSVersion(p, aDetectedOSVersion))
#define IUnattended_GetDetectedOSVersion(p, aDetectedOSVersion) ((p)->lpVtbl->GetDetectedOSVersion(p, aDetectedOSVersion))
#define IUnattended_get_DetectedOSFlavor(p, aDetectedOSFlavor) ((p)->lpVtbl->GetDetectedOSFlavor(p, aDetectedOSFlavor))
#define IUnattended_GetDetectedOSFlavor(p, aDetectedOSFlavor) ((p)->lpVtbl->GetDetectedOSFlavor(p, aDetectedOSFlavor))
#define IUnattended_get_DetectedOSLanguages(p, aDetectedOSLanguages) ((p)->lpVtbl->GetDetectedOSLanguages(p, aDetectedOSLanguages))
#define IUnattended_GetDetectedOSLanguages(p, aDetectedOSLanguages) ((p)->lpVtbl->GetDetectedOSLanguages(p, aDetectedOSLanguages))
#define IUnattended_get_DetectedOSHints(p, aDetectedOSHints) ((p)->lpVtbl->GetDetectedOSHints(p, aDetectedOSHints))
#define IUnattended_GetDetectedOSHints(p, aDetectedOSHints) ((p)->lpVtbl->GetDetectedOSHints(p, aDetectedOSHints))
#define IUnattended_get_DetectedImageNames(p, aDetectedImageNames) ((p)->lpVtbl->GetDetectedImageNames(p, aDetectedImageNames))
#define IUnattended_GetDetectedImageNames(p, aDetectedImageNames) ((p)->lpVtbl->GetDetectedImageNames(p, aDetectedImageNames))
#define IUnattended_get_DetectedImageIndices(p, aDetectedImageIndices) ((p)->lpVtbl->GetDetectedImageIndices(p, aDetectedImageIndices))
#define IUnattended_GetDetectedImageIndices(p, aDetectedImageIndices) ((p)->lpVtbl->GetDetectedImageIndices(p, aDetectedImageIndices))
#define IUnattended_get_IsUnattendedInstallSupported(p, aIsUnattendedInstallSupported) ((p)->lpVtbl->GetIsUnattendedInstallSupported(p, aIsUnattendedInstallSupported))
#define IUnattended_GetIsUnattendedInstallSupported(p, aIsUnattendedInstallSupported) ((p)->lpVtbl->GetIsUnattendedInstallSupported(p, aIsUnattendedInstallSupported))
#define IUnattended_get_AvoidUpdatesOverNetwork(p, aAvoidUpdatesOverNetwork) ((p)->lpVtbl->GetAvoidUpdatesOverNetwork(p, aAvoidUpdatesOverNetwork))
#define IUnattended_GetAvoidUpdatesOverNetwork(p, aAvoidUpdatesOverNetwork) ((p)->lpVtbl->GetAvoidUpdatesOverNetwork(p, aAvoidUpdatesOverNetwork))
#define IUnattended_put_AvoidUpdatesOverNetwork(p, aAvoidUpdatesOverNetwork) ((p)->lpVtbl->SetAvoidUpdatesOverNetwork(p, aAvoidUpdatesOverNetwork))
#define IUnattended_SetAvoidUpdatesOverNetwork(p, aAvoidUpdatesOverNetwork) ((p)->lpVtbl->SetAvoidUpdatesOverNetwork(p, aAvoidUpdatesOverNetwork))
#define IUnattended_DetectIsoOS(p) ((p)->lpVtbl->DetectIsoOS(p))
#define IUnattended_Prepare(p) ((p)->lpVtbl->Prepare(p))
#define IUnattended_ConstructMedia(p) ((p)->lpVtbl->ConstructMedia(p))
#define IUnattended_ReconfigureVM(p) ((p)->lpVtbl->ReconfigureVM(p))
#define IUnattended_Done(p) ((p)->lpVtbl->Done(p))
#endif /* VBOX_WITH_GLUE */

interface IUnattended
{
#ifndef VBOX_WITH_GLUE
    struct IUnattended_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IUnattendedVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IUnattended declaration */


/* Start of struct IGraphicsAdapter declaration */
#define IGRAPHICSADAPTER_IID_STR "13ee6eb4-06fe-406b-ad69-f6e08b0587a3"
#define IGRAPHICSADAPTER_IID { \
    0x13ee6eb4, 0x06fe, 0x406b, \
    { 0xad, 0x69, 0xf6, 0xe0, 0x8b, 0x05, 0x87, 0xa3 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGraphicsAdapter);
#ifndef VBOX_WITH_GLUE
struct IGraphicsAdapter_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetGraphicsControllerType)(IGraphicsAdapter *pThis, PRUint32 *graphicsControllerType);
    nsresult (*SetGraphicsControllerType)(IGraphicsAdapter *pThis, PRUint32 graphicsControllerType);

    nsresult (*GetVRAMSize)(IGraphicsAdapter *pThis, PRUint32 *VRAMSize);
    nsresult (*SetVRAMSize)(IGraphicsAdapter *pThis, PRUint32 VRAMSize);

    nsresult (*GetMonitorCount)(IGraphicsAdapter *pThis, PRUint32 *monitorCount);
    nsresult (*SetMonitorCount)(IGraphicsAdapter *pThis, PRUint32 monitorCount);

    nsresult (*GetInternalAndReservedAttribute1IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*SetFeature)(
        IGraphicsAdapter *pThis,
        PRUint32 feature,
        PRBool enabled
    );

    nsresult (*IsFeatureEnabled)(
        IGraphicsAdapter *pThis,
        PRUint32 feature,
        PRBool * enabled
    );

    nsresult (*InternalAndReservedMethod1IGraphicsAdapter)(IGraphicsAdapter *pThis);

    nsresult (*InternalAndReservedMethod2IGraphicsAdapter)(IGraphicsAdapter *pThis);

    nsresult (*InternalAndReservedMethod3IGraphicsAdapter)(IGraphicsAdapter *pThis);

    nsresult (*InternalAndReservedMethod4IGraphicsAdapter)(IGraphicsAdapter *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IGraphicsAdapterVtbl
{
    nsresult (*QueryInterface)(IGraphicsAdapter *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGraphicsAdapter *pThis);
    nsrefcnt (*Release)(IGraphicsAdapter *pThis);
    nsresult (*GetGraphicsControllerType)(IGraphicsAdapter *pThis, PRUint32 *graphicsControllerType);
    nsresult (*SetGraphicsControllerType)(IGraphicsAdapter *pThis, PRUint32 graphicsControllerType);

    nsresult (*GetVRAMSize)(IGraphicsAdapter *pThis, PRUint32 *VRAMSize);
    nsresult (*SetVRAMSize)(IGraphicsAdapter *pThis, PRUint32 VRAMSize);

    nsresult (*GetMonitorCount)(IGraphicsAdapter *pThis, PRUint32 *monitorCount);
    nsresult (*SetMonitorCount)(IGraphicsAdapter *pThis, PRUint32 monitorCount);

    nsresult (*GetInternalAndReservedAttribute1IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IGraphicsAdapter)(IGraphicsAdapter *pThis, PRUint32 *reserved);

    nsresult (*SetFeature)(
        IGraphicsAdapter *pThis,
        PRUint32 feature,
        PRBool enabled
    );

    nsresult (*IsFeatureEnabled)(
        IGraphicsAdapter *pThis,
        PRUint32 feature,
        PRBool * enabled
    );

    nsresult (*InternalAndReservedMethod1IGraphicsAdapter)(IGraphicsAdapter *pThis);

    nsresult (*InternalAndReservedMethod2IGraphicsAdapter)(IGraphicsAdapter *pThis);

    nsresult (*InternalAndReservedMethod3IGraphicsAdapter)(IGraphicsAdapter *pThis);

    nsresult (*InternalAndReservedMethod4IGraphicsAdapter)(IGraphicsAdapter *pThis);

};
#define IGraphicsAdapter_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGraphicsAdapter_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGraphicsAdapter_Release(p) ((p)->lpVtbl->Release(p))
#define IGraphicsAdapter_get_GraphicsControllerType(p, aGraphicsControllerType) ((p)->lpVtbl->GetGraphicsControllerType(p, aGraphicsControllerType))
#define IGraphicsAdapter_GetGraphicsControllerType(p, aGraphicsControllerType) ((p)->lpVtbl->GetGraphicsControllerType(p, aGraphicsControllerType))
#define IGraphicsAdapter_put_GraphicsControllerType(p, aGraphicsControllerType) ((p)->lpVtbl->SetGraphicsControllerType(p, aGraphicsControllerType))
#define IGraphicsAdapter_SetGraphicsControllerType(p, aGraphicsControllerType) ((p)->lpVtbl->SetGraphicsControllerType(p, aGraphicsControllerType))
#define IGraphicsAdapter_get_VRAMSize(p, aVRAMSize) ((p)->lpVtbl->GetVRAMSize(p, aVRAMSize))
#define IGraphicsAdapter_GetVRAMSize(p, aVRAMSize) ((p)->lpVtbl->GetVRAMSize(p, aVRAMSize))
#define IGraphicsAdapter_put_VRAMSize(p, aVRAMSize) ((p)->lpVtbl->SetVRAMSize(p, aVRAMSize))
#define IGraphicsAdapter_SetVRAMSize(p, aVRAMSize) ((p)->lpVtbl->SetVRAMSize(p, aVRAMSize))
#define IGraphicsAdapter_get_MonitorCount(p, aMonitorCount) ((p)->lpVtbl->GetMonitorCount(p, aMonitorCount))
#define IGraphicsAdapter_GetMonitorCount(p, aMonitorCount) ((p)->lpVtbl->GetMonitorCount(p, aMonitorCount))
#define IGraphicsAdapter_put_MonitorCount(p, aMonitorCount) ((p)->lpVtbl->SetMonitorCount(p, aMonitorCount))
#define IGraphicsAdapter_SetMonitorCount(p, aMonitorCount) ((p)->lpVtbl->SetMonitorCount(p, aMonitorCount))
#define IGraphicsAdapter_SetFeature(p, aFeature, aEnabled) ((p)->lpVtbl->SetFeature(p, aFeature, aEnabled))
#define IGraphicsAdapter_IsFeatureEnabled(p, aFeature, aEnabled) ((p)->lpVtbl->IsFeatureEnabled(p, aFeature, aEnabled))
#endif /* VBOX_WITH_GLUE */

interface IGraphicsAdapter
{
#ifndef VBOX_WITH_GLUE
    struct IGraphicsAdapter_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGraphicsAdapterVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGraphicsAdapter declaration */


/* Start of struct IFirmwareSettings declaration */
#define IFIRMWARESETTINGS_IID_STR "426EF1B8-DE91-49FB-ABC3-0E2BAE654FF2"
#define IFIRMWARESETTINGS_IID { \
    0x426EF1B8, 0xDE91, 0x49FB, \
    { 0xAB, 0xC3, 0x0E, 0x2B, 0xAE, 0x65, 0x4F, 0xF2 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IFirmwareSettings);
#ifndef VBOX_WITH_GLUE
struct IFirmwareSettings_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetFirmwareType)(IFirmwareSettings *pThis, PRUint32 *firmwareType);
    nsresult (*SetFirmwareType)(IFirmwareSettings *pThis, PRUint32 firmwareType);

    nsresult (*GetLogoFadeIn)(IFirmwareSettings *pThis, PRBool *logoFadeIn);
    nsresult (*SetLogoFadeIn)(IFirmwareSettings *pThis, PRBool logoFadeIn);

    nsresult (*GetLogoFadeOut)(IFirmwareSettings *pThis, PRBool *logoFadeOut);
    nsresult (*SetLogoFadeOut)(IFirmwareSettings *pThis, PRBool logoFadeOut);

    nsresult (*GetLogoDisplayTime)(IFirmwareSettings *pThis, PRUint32 *logoDisplayTime);
    nsresult (*SetLogoDisplayTime)(IFirmwareSettings *pThis, PRUint32 logoDisplayTime);

    nsresult (*GetLogoImagePath)(IFirmwareSettings *pThis, PRUnichar * *logoImagePath);
    nsresult (*SetLogoImagePath)(IFirmwareSettings *pThis, PRUnichar * logoImagePath);

    nsresult (*GetBootMenuMode)(IFirmwareSettings *pThis, PRUint32 *bootMenuMode);
    nsresult (*SetBootMenuMode)(IFirmwareSettings *pThis, PRUint32 bootMenuMode);

    nsresult (*GetACPIEnabled)(IFirmwareSettings *pThis, PRBool *ACPIEnabled);
    nsresult (*SetACPIEnabled)(IFirmwareSettings *pThis, PRBool ACPIEnabled);

    nsresult (*GetIOAPICEnabled)(IFirmwareSettings *pThis, PRBool *IOAPICEnabled);
    nsresult (*SetIOAPICEnabled)(IFirmwareSettings *pThis, PRBool IOAPICEnabled);

    nsresult (*GetAPICMode)(IFirmwareSettings *pThis, PRUint32 *APICMode);
    nsresult (*SetAPICMode)(IFirmwareSettings *pThis, PRUint32 APICMode);

    nsresult (*GetTimeOffset)(IFirmwareSettings *pThis, PRInt64 *timeOffset);
    nsresult (*SetTimeOffset)(IFirmwareSettings *pThis, PRInt64 timeOffset);

    nsresult (*GetPXEDebugEnabled)(IFirmwareSettings *pThis, PRBool *PXEDebugEnabled);
    nsresult (*SetPXEDebugEnabled)(IFirmwareSettings *pThis, PRBool PXEDebugEnabled);

    nsresult (*GetSMBIOSUuidLittleEndian)(IFirmwareSettings *pThis, PRBool *SMBIOSUuidLittleEndian);
    nsresult (*SetSMBIOSUuidLittleEndian)(IFirmwareSettings *pThis, PRBool SMBIOSUuidLittleEndian);

    nsresult (*GetAutoSerialNumGen)(IFirmwareSettings *pThis, PRBool *AutoSerialNumGen);
    nsresult (*SetAutoSerialNumGen)(IFirmwareSettings *pThis, PRBool AutoSerialNumGen);

    nsresult (*GetInternalAndReservedAttribute1IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IFirmwareSettings)(IFirmwareSettings *pThis);

    nsresult (*InternalAndReservedMethod2IFirmwareSettings)(IFirmwareSettings *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IFirmwareSettingsVtbl
{
    nsresult (*QueryInterface)(IFirmwareSettings *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IFirmwareSettings *pThis);
    nsrefcnt (*Release)(IFirmwareSettings *pThis);
    nsresult (*GetFirmwareType)(IFirmwareSettings *pThis, PRUint32 *firmwareType);
    nsresult (*SetFirmwareType)(IFirmwareSettings *pThis, PRUint32 firmwareType);

    nsresult (*GetLogoFadeIn)(IFirmwareSettings *pThis, PRBool *logoFadeIn);
    nsresult (*SetLogoFadeIn)(IFirmwareSettings *pThis, PRBool logoFadeIn);

    nsresult (*GetLogoFadeOut)(IFirmwareSettings *pThis, PRBool *logoFadeOut);
    nsresult (*SetLogoFadeOut)(IFirmwareSettings *pThis, PRBool logoFadeOut);

    nsresult (*GetLogoDisplayTime)(IFirmwareSettings *pThis, PRUint32 *logoDisplayTime);
    nsresult (*SetLogoDisplayTime)(IFirmwareSettings *pThis, PRUint32 logoDisplayTime);

    nsresult (*GetLogoImagePath)(IFirmwareSettings *pThis, PRUnichar * *logoImagePath);
    nsresult (*SetLogoImagePath)(IFirmwareSettings *pThis, PRUnichar * logoImagePath);

    nsresult (*GetBootMenuMode)(IFirmwareSettings *pThis, PRUint32 *bootMenuMode);
    nsresult (*SetBootMenuMode)(IFirmwareSettings *pThis, PRUint32 bootMenuMode);

    nsresult (*GetACPIEnabled)(IFirmwareSettings *pThis, PRBool *ACPIEnabled);
    nsresult (*SetACPIEnabled)(IFirmwareSettings *pThis, PRBool ACPIEnabled);

    nsresult (*GetIOAPICEnabled)(IFirmwareSettings *pThis, PRBool *IOAPICEnabled);
    nsresult (*SetIOAPICEnabled)(IFirmwareSettings *pThis, PRBool IOAPICEnabled);

    nsresult (*GetAPICMode)(IFirmwareSettings *pThis, PRUint32 *APICMode);
    nsresult (*SetAPICMode)(IFirmwareSettings *pThis, PRUint32 APICMode);

    nsresult (*GetTimeOffset)(IFirmwareSettings *pThis, PRInt64 *timeOffset);
    nsresult (*SetTimeOffset)(IFirmwareSettings *pThis, PRInt64 timeOffset);

    nsresult (*GetPXEDebugEnabled)(IFirmwareSettings *pThis, PRBool *PXEDebugEnabled);
    nsresult (*SetPXEDebugEnabled)(IFirmwareSettings *pThis, PRBool PXEDebugEnabled);

    nsresult (*GetSMBIOSUuidLittleEndian)(IFirmwareSettings *pThis, PRBool *SMBIOSUuidLittleEndian);
    nsresult (*SetSMBIOSUuidLittleEndian)(IFirmwareSettings *pThis, PRBool SMBIOSUuidLittleEndian);

    nsresult (*GetAutoSerialNumGen)(IFirmwareSettings *pThis, PRBool *AutoSerialNumGen);
    nsresult (*SetAutoSerialNumGen)(IFirmwareSettings *pThis, PRBool AutoSerialNumGen);

    nsresult (*GetInternalAndReservedAttribute1IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFirmwareSettings)(IFirmwareSettings *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IFirmwareSettings)(IFirmwareSettings *pThis);

    nsresult (*InternalAndReservedMethod2IFirmwareSettings)(IFirmwareSettings *pThis);

};
#define IFirmwareSettings_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IFirmwareSettings_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IFirmwareSettings_Release(p) ((p)->lpVtbl->Release(p))
#define IFirmwareSettings_get_FirmwareType(p, aFirmwareType) ((p)->lpVtbl->GetFirmwareType(p, aFirmwareType))
#define IFirmwareSettings_GetFirmwareType(p, aFirmwareType) ((p)->lpVtbl->GetFirmwareType(p, aFirmwareType))
#define IFirmwareSettings_put_FirmwareType(p, aFirmwareType) ((p)->lpVtbl->SetFirmwareType(p, aFirmwareType))
#define IFirmwareSettings_SetFirmwareType(p, aFirmwareType) ((p)->lpVtbl->SetFirmwareType(p, aFirmwareType))
#define IFirmwareSettings_get_LogoFadeIn(p, aLogoFadeIn) ((p)->lpVtbl->GetLogoFadeIn(p, aLogoFadeIn))
#define IFirmwareSettings_GetLogoFadeIn(p, aLogoFadeIn) ((p)->lpVtbl->GetLogoFadeIn(p, aLogoFadeIn))
#define IFirmwareSettings_put_LogoFadeIn(p, aLogoFadeIn) ((p)->lpVtbl->SetLogoFadeIn(p, aLogoFadeIn))
#define IFirmwareSettings_SetLogoFadeIn(p, aLogoFadeIn) ((p)->lpVtbl->SetLogoFadeIn(p, aLogoFadeIn))
#define IFirmwareSettings_get_LogoFadeOut(p, aLogoFadeOut) ((p)->lpVtbl->GetLogoFadeOut(p, aLogoFadeOut))
#define IFirmwareSettings_GetLogoFadeOut(p, aLogoFadeOut) ((p)->lpVtbl->GetLogoFadeOut(p, aLogoFadeOut))
#define IFirmwareSettings_put_LogoFadeOut(p, aLogoFadeOut) ((p)->lpVtbl->SetLogoFadeOut(p, aLogoFadeOut))
#define IFirmwareSettings_SetLogoFadeOut(p, aLogoFadeOut) ((p)->lpVtbl->SetLogoFadeOut(p, aLogoFadeOut))
#define IFirmwareSettings_get_LogoDisplayTime(p, aLogoDisplayTime) ((p)->lpVtbl->GetLogoDisplayTime(p, aLogoDisplayTime))
#define IFirmwareSettings_GetLogoDisplayTime(p, aLogoDisplayTime) ((p)->lpVtbl->GetLogoDisplayTime(p, aLogoDisplayTime))
#define IFirmwareSettings_put_LogoDisplayTime(p, aLogoDisplayTime) ((p)->lpVtbl->SetLogoDisplayTime(p, aLogoDisplayTime))
#define IFirmwareSettings_SetLogoDisplayTime(p, aLogoDisplayTime) ((p)->lpVtbl->SetLogoDisplayTime(p, aLogoDisplayTime))
#define IFirmwareSettings_get_LogoImagePath(p, aLogoImagePath) ((p)->lpVtbl->GetLogoImagePath(p, aLogoImagePath))
#define IFirmwareSettings_GetLogoImagePath(p, aLogoImagePath) ((p)->lpVtbl->GetLogoImagePath(p, aLogoImagePath))
#define IFirmwareSettings_put_LogoImagePath(p, aLogoImagePath) ((p)->lpVtbl->SetLogoImagePath(p, aLogoImagePath))
#define IFirmwareSettings_SetLogoImagePath(p, aLogoImagePath) ((p)->lpVtbl->SetLogoImagePath(p, aLogoImagePath))
#define IFirmwareSettings_get_BootMenuMode(p, aBootMenuMode) ((p)->lpVtbl->GetBootMenuMode(p, aBootMenuMode))
#define IFirmwareSettings_GetBootMenuMode(p, aBootMenuMode) ((p)->lpVtbl->GetBootMenuMode(p, aBootMenuMode))
#define IFirmwareSettings_put_BootMenuMode(p, aBootMenuMode) ((p)->lpVtbl->SetBootMenuMode(p, aBootMenuMode))
#define IFirmwareSettings_SetBootMenuMode(p, aBootMenuMode) ((p)->lpVtbl->SetBootMenuMode(p, aBootMenuMode))
#define IFirmwareSettings_get_ACPIEnabled(p, aACPIEnabled) ((p)->lpVtbl->GetACPIEnabled(p, aACPIEnabled))
#define IFirmwareSettings_GetACPIEnabled(p, aACPIEnabled) ((p)->lpVtbl->GetACPIEnabled(p, aACPIEnabled))
#define IFirmwareSettings_put_ACPIEnabled(p, aACPIEnabled) ((p)->lpVtbl->SetACPIEnabled(p, aACPIEnabled))
#define IFirmwareSettings_SetACPIEnabled(p, aACPIEnabled) ((p)->lpVtbl->SetACPIEnabled(p, aACPIEnabled))
#define IFirmwareSettings_get_IOAPICEnabled(p, aIOAPICEnabled) ((p)->lpVtbl->GetIOAPICEnabled(p, aIOAPICEnabled))
#define IFirmwareSettings_GetIOAPICEnabled(p, aIOAPICEnabled) ((p)->lpVtbl->GetIOAPICEnabled(p, aIOAPICEnabled))
#define IFirmwareSettings_put_IOAPICEnabled(p, aIOAPICEnabled) ((p)->lpVtbl->SetIOAPICEnabled(p, aIOAPICEnabled))
#define IFirmwareSettings_SetIOAPICEnabled(p, aIOAPICEnabled) ((p)->lpVtbl->SetIOAPICEnabled(p, aIOAPICEnabled))
#define IFirmwareSettings_get_APICMode(p, aAPICMode) ((p)->lpVtbl->GetAPICMode(p, aAPICMode))
#define IFirmwareSettings_GetAPICMode(p, aAPICMode) ((p)->lpVtbl->GetAPICMode(p, aAPICMode))
#define IFirmwareSettings_put_APICMode(p, aAPICMode) ((p)->lpVtbl->SetAPICMode(p, aAPICMode))
#define IFirmwareSettings_SetAPICMode(p, aAPICMode) ((p)->lpVtbl->SetAPICMode(p, aAPICMode))
#define IFirmwareSettings_get_TimeOffset(p, aTimeOffset) ((p)->lpVtbl->GetTimeOffset(p, aTimeOffset))
#define IFirmwareSettings_GetTimeOffset(p, aTimeOffset) ((p)->lpVtbl->GetTimeOffset(p, aTimeOffset))
#define IFirmwareSettings_put_TimeOffset(p, aTimeOffset) ((p)->lpVtbl->SetTimeOffset(p, aTimeOffset))
#define IFirmwareSettings_SetTimeOffset(p, aTimeOffset) ((p)->lpVtbl->SetTimeOffset(p, aTimeOffset))
#define IFirmwareSettings_get_PXEDebugEnabled(p, aPXEDebugEnabled) ((p)->lpVtbl->GetPXEDebugEnabled(p, aPXEDebugEnabled))
#define IFirmwareSettings_GetPXEDebugEnabled(p, aPXEDebugEnabled) ((p)->lpVtbl->GetPXEDebugEnabled(p, aPXEDebugEnabled))
#define IFirmwareSettings_put_PXEDebugEnabled(p, aPXEDebugEnabled) ((p)->lpVtbl->SetPXEDebugEnabled(p, aPXEDebugEnabled))
#define IFirmwareSettings_SetPXEDebugEnabled(p, aPXEDebugEnabled) ((p)->lpVtbl->SetPXEDebugEnabled(p, aPXEDebugEnabled))
#define IFirmwareSettings_get_SMBIOSUuidLittleEndian(p, aSMBIOSUuidLittleEndian) ((p)->lpVtbl->GetSMBIOSUuidLittleEndian(p, aSMBIOSUuidLittleEndian))
#define IFirmwareSettings_GetSMBIOSUuidLittleEndian(p, aSMBIOSUuidLittleEndian) ((p)->lpVtbl->GetSMBIOSUuidLittleEndian(p, aSMBIOSUuidLittleEndian))
#define IFirmwareSettings_put_SMBIOSUuidLittleEndian(p, aSMBIOSUuidLittleEndian) ((p)->lpVtbl->SetSMBIOSUuidLittleEndian(p, aSMBIOSUuidLittleEndian))
#define IFirmwareSettings_SetSMBIOSUuidLittleEndian(p, aSMBIOSUuidLittleEndian) ((p)->lpVtbl->SetSMBIOSUuidLittleEndian(p, aSMBIOSUuidLittleEndian))
#define IFirmwareSettings_get_AutoSerialNumGen(p, aAutoSerialNumGen) ((p)->lpVtbl->GetAutoSerialNumGen(p, aAutoSerialNumGen))
#define IFirmwareSettings_GetAutoSerialNumGen(p, aAutoSerialNumGen) ((p)->lpVtbl->GetAutoSerialNumGen(p, aAutoSerialNumGen))
#define IFirmwareSettings_put_AutoSerialNumGen(p, aAutoSerialNumGen) ((p)->lpVtbl->SetAutoSerialNumGen(p, aAutoSerialNumGen))
#define IFirmwareSettings_SetAutoSerialNumGen(p, aAutoSerialNumGen) ((p)->lpVtbl->SetAutoSerialNumGen(p, aAutoSerialNumGen))
#endif /* VBOX_WITH_GLUE */

interface IFirmwareSettings
{
#ifndef VBOX_WITH_GLUE
    struct IFirmwareSettings_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IFirmwareSettingsVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IFirmwareSettings declaration */


/* Start of struct ITrustedPlatformModule declaration */
#define ITRUSTEDPLATFORMMODULE_IID_STR "cf11d345-0241-4ea9-ac4c-c69ed3d674e3"
#define ITRUSTEDPLATFORMMODULE_IID { \
    0xcf11d345, 0x0241, 0x4ea9, \
    { 0xac, 0x4c, 0xc6, 0x9e, 0xd3, 0xd6, 0x74, 0xe3 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_ITrustedPlatformModule);
#ifndef VBOX_WITH_GLUE
struct ITrustedPlatformModule_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetType)(ITrustedPlatformModule *pThis, PRUint32 *type);
    nsresult (*SetType)(ITrustedPlatformModule *pThis, PRUint32 type);

    nsresult (*GetLocation)(ITrustedPlatformModule *pThis, PRUnichar * *location);
    nsresult (*SetLocation)(ITrustedPlatformModule *pThis, PRUnichar * location);

    nsresult (*GetInternalAndReservedAttribute1ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1ITrustedPlatformModule)(ITrustedPlatformModule *pThis);

    nsresult (*InternalAndReservedMethod2ITrustedPlatformModule)(ITrustedPlatformModule *pThis);

};
#else /* VBOX_WITH_GLUE */
struct ITrustedPlatformModuleVtbl
{
    nsresult (*QueryInterface)(ITrustedPlatformModule *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(ITrustedPlatformModule *pThis);
    nsrefcnt (*Release)(ITrustedPlatformModule *pThis);
    nsresult (*GetType)(ITrustedPlatformModule *pThis, PRUint32 *type);
    nsresult (*SetType)(ITrustedPlatformModule *pThis, PRUint32 type);

    nsresult (*GetLocation)(ITrustedPlatformModule *pThis, PRUnichar * *location);
    nsresult (*SetLocation)(ITrustedPlatformModule *pThis, PRUnichar * location);

    nsresult (*GetInternalAndReservedAttribute1ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ITrustedPlatformModule)(ITrustedPlatformModule *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1ITrustedPlatformModule)(ITrustedPlatformModule *pThis);

    nsresult (*InternalAndReservedMethod2ITrustedPlatformModule)(ITrustedPlatformModule *pThis);

};
#define ITrustedPlatformModule_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define ITrustedPlatformModule_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define ITrustedPlatformModule_Release(p) ((p)->lpVtbl->Release(p))
#define ITrustedPlatformModule_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define ITrustedPlatformModule_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define ITrustedPlatformModule_put_Type(p, aType) ((p)->lpVtbl->SetType(p, aType))
#define ITrustedPlatformModule_SetType(p, aType) ((p)->lpVtbl->SetType(p, aType))
#define ITrustedPlatformModule_get_Location(p, aLocation) ((p)->lpVtbl->GetLocation(p, aLocation))
#define ITrustedPlatformModule_GetLocation(p, aLocation) ((p)->lpVtbl->GetLocation(p, aLocation))
#define ITrustedPlatformModule_put_Location(p, aLocation) ((p)->lpVtbl->SetLocation(p, aLocation))
#define ITrustedPlatformModule_SetLocation(p, aLocation) ((p)->lpVtbl->SetLocation(p, aLocation))
#endif /* VBOX_WITH_GLUE */

interface ITrustedPlatformModule
{
#ifndef VBOX_WITH_GLUE
    struct ITrustedPlatformModule_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct ITrustedPlatformModuleVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct ITrustedPlatformModule declaration */


/* Start of struct IRecordingScreenSettings declaration */
#define IRECORDINGSCREENSETTINGS_IID_STR "c1844087-ec6b-488d-afbb-c90f6452a04b"
#define IRECORDINGSCREENSETTINGS_IID { \
    0xc1844087, 0xec6b, 0x488d, \
    { 0xaf, 0xbb, 0xc9, 0x0f, 0x64, 0x52, 0xa0, 0x4b } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IRecordingScreenSettings);
#ifndef VBOX_WITH_GLUE
struct IRecordingScreenSettings_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetId)(IRecordingScreenSettings *pThis, PRUint32 *id);

    nsresult (*GetEnabled)(IRecordingScreenSettings *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IRecordingScreenSettings *pThis, PRBool enabled);

    nsresult (*GetFeatures)(IRecordingScreenSettings *pThis, PRUint32 *featuresSize, PRUint32 **features);
    nsresult (*SetFeatures)(IRecordingScreenSettings *pThis, PRUint32 featuresSize, PRUint32 *features);

    nsresult (*GetDestination)(IRecordingScreenSettings *pThis, PRUint32 *destination);
    nsresult (*SetDestination)(IRecordingScreenSettings *pThis, PRUint32 destination);

    nsresult (*GetFilename)(IRecordingScreenSettings *pThis, PRUnichar * *filename);
    nsresult (*SetFilename)(IRecordingScreenSettings *pThis, PRUnichar * filename);

    nsresult (*GetMaxTime)(IRecordingScreenSettings *pThis, PRUint32 *maxTime);
    nsresult (*SetMaxTime)(IRecordingScreenSettings *pThis, PRUint32 maxTime);

    nsresult (*GetMaxFileSize)(IRecordingScreenSettings *pThis, PRUint32 *maxFileSize);
    nsresult (*SetMaxFileSize)(IRecordingScreenSettings *pThis, PRUint32 maxFileSize);

    nsresult (*GetOptions)(IRecordingScreenSettings *pThis, PRUnichar * *options);
    nsresult (*SetOptions)(IRecordingScreenSettings *pThis, PRUnichar * options);

    nsresult (*GetAudioCodec)(IRecordingScreenSettings *pThis, PRUint32 *audioCodec);
    nsresult (*SetAudioCodec)(IRecordingScreenSettings *pThis, PRUint32 audioCodec);

    nsresult (*GetAudioRateControlMode)(IRecordingScreenSettings *pThis, PRUint32 *audioRateControlMode);
    nsresult (*SetAudioRateControlMode)(IRecordingScreenSettings *pThis, PRUint32 audioRateControlMode);

    nsresult (*GetAudioDeadline)(IRecordingScreenSettings *pThis, PRUint32 *audioDeadline);
    nsresult (*SetAudioDeadline)(IRecordingScreenSettings *pThis, PRUint32 audioDeadline);

    nsresult (*GetAudioHz)(IRecordingScreenSettings *pThis, PRUint32 *audioHz);
    nsresult (*SetAudioHz)(IRecordingScreenSettings *pThis, PRUint32 audioHz);

    nsresult (*GetAudioBits)(IRecordingScreenSettings *pThis, PRUint32 *audioBits);
    nsresult (*SetAudioBits)(IRecordingScreenSettings *pThis, PRUint32 audioBits);

    nsresult (*GetAudioChannels)(IRecordingScreenSettings *pThis, PRUint32 *audioChannels);
    nsresult (*SetAudioChannels)(IRecordingScreenSettings *pThis, PRUint32 audioChannels);

    nsresult (*GetVideoCodec)(IRecordingScreenSettings *pThis, PRUint32 *videoCodec);
    nsresult (*SetVideoCodec)(IRecordingScreenSettings *pThis, PRUint32 videoCodec);

    nsresult (*GetVideoDeadline)(IRecordingScreenSettings *pThis, PRUint32 *videoDeadline);
    nsresult (*SetVideoDeadline)(IRecordingScreenSettings *pThis, PRUint32 videoDeadline);

    nsresult (*GetVideoWidth)(IRecordingScreenSettings *pThis, PRUint32 *videoWidth);
    nsresult (*SetVideoWidth)(IRecordingScreenSettings *pThis, PRUint32 videoWidth);

    nsresult (*GetVideoHeight)(IRecordingScreenSettings *pThis, PRUint32 *videoHeight);
    nsresult (*SetVideoHeight)(IRecordingScreenSettings *pThis, PRUint32 videoHeight);

    nsresult (*GetVideoRate)(IRecordingScreenSettings *pThis, PRUint32 *videoRate);
    nsresult (*SetVideoRate)(IRecordingScreenSettings *pThis, PRUint32 videoRate);

    nsresult (*GetVideoRateControlMode)(IRecordingScreenSettings *pThis, PRUint32 *videoRateControlMode);
    nsresult (*SetVideoRateControlMode)(IRecordingScreenSettings *pThis, PRUint32 videoRateControlMode);

    nsresult (*GetVideoFPS)(IRecordingScreenSettings *pThis, PRUint32 *videoFPS);
    nsresult (*SetVideoFPS)(IRecordingScreenSettings *pThis, PRUint32 videoFPS);

    nsresult (*GetVideoScalingMode)(IRecordingScreenSettings *pThis, PRUint32 *videoScalingMode);
    nsresult (*SetVideoScalingMode)(IRecordingScreenSettings *pThis, PRUint32 videoScalingMode);

    nsresult (*IsFeatureEnabled)(
        IRecordingScreenSettings *pThis,
        PRUint32 feature,
        PRBool * enabled
    );

};
#else /* VBOX_WITH_GLUE */
struct IRecordingScreenSettingsVtbl
{
    nsresult (*QueryInterface)(IRecordingScreenSettings *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IRecordingScreenSettings *pThis);
    nsrefcnt (*Release)(IRecordingScreenSettings *pThis);
    nsresult (*GetId)(IRecordingScreenSettings *pThis, PRUint32 *id);

    nsresult (*GetEnabled)(IRecordingScreenSettings *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IRecordingScreenSettings *pThis, PRBool enabled);

    nsresult (*GetFeatures)(IRecordingScreenSettings *pThis, PRUint32 *featuresSize, PRUint32 **features);
    nsresult (*SetFeatures)(IRecordingScreenSettings *pThis, PRUint32 featuresSize, PRUint32 *features);

    nsresult (*GetDestination)(IRecordingScreenSettings *pThis, PRUint32 *destination);
    nsresult (*SetDestination)(IRecordingScreenSettings *pThis, PRUint32 destination);

    nsresult (*GetFilename)(IRecordingScreenSettings *pThis, PRUnichar * *filename);
    nsresult (*SetFilename)(IRecordingScreenSettings *pThis, PRUnichar * filename);

    nsresult (*GetMaxTime)(IRecordingScreenSettings *pThis, PRUint32 *maxTime);
    nsresult (*SetMaxTime)(IRecordingScreenSettings *pThis, PRUint32 maxTime);

    nsresult (*GetMaxFileSize)(IRecordingScreenSettings *pThis, PRUint32 *maxFileSize);
    nsresult (*SetMaxFileSize)(IRecordingScreenSettings *pThis, PRUint32 maxFileSize);

    nsresult (*GetOptions)(IRecordingScreenSettings *pThis, PRUnichar * *options);
    nsresult (*SetOptions)(IRecordingScreenSettings *pThis, PRUnichar * options);

    nsresult (*GetAudioCodec)(IRecordingScreenSettings *pThis, PRUint32 *audioCodec);
    nsresult (*SetAudioCodec)(IRecordingScreenSettings *pThis, PRUint32 audioCodec);

    nsresult (*GetAudioRateControlMode)(IRecordingScreenSettings *pThis, PRUint32 *audioRateControlMode);
    nsresult (*SetAudioRateControlMode)(IRecordingScreenSettings *pThis, PRUint32 audioRateControlMode);

    nsresult (*GetAudioDeadline)(IRecordingScreenSettings *pThis, PRUint32 *audioDeadline);
    nsresult (*SetAudioDeadline)(IRecordingScreenSettings *pThis, PRUint32 audioDeadline);

    nsresult (*GetAudioHz)(IRecordingScreenSettings *pThis, PRUint32 *audioHz);
    nsresult (*SetAudioHz)(IRecordingScreenSettings *pThis, PRUint32 audioHz);

    nsresult (*GetAudioBits)(IRecordingScreenSettings *pThis, PRUint32 *audioBits);
    nsresult (*SetAudioBits)(IRecordingScreenSettings *pThis, PRUint32 audioBits);

    nsresult (*GetAudioChannels)(IRecordingScreenSettings *pThis, PRUint32 *audioChannels);
    nsresult (*SetAudioChannels)(IRecordingScreenSettings *pThis, PRUint32 audioChannels);

    nsresult (*GetVideoCodec)(IRecordingScreenSettings *pThis, PRUint32 *videoCodec);
    nsresult (*SetVideoCodec)(IRecordingScreenSettings *pThis, PRUint32 videoCodec);

    nsresult (*GetVideoDeadline)(IRecordingScreenSettings *pThis, PRUint32 *videoDeadline);
    nsresult (*SetVideoDeadline)(IRecordingScreenSettings *pThis, PRUint32 videoDeadline);

    nsresult (*GetVideoWidth)(IRecordingScreenSettings *pThis, PRUint32 *videoWidth);
    nsresult (*SetVideoWidth)(IRecordingScreenSettings *pThis, PRUint32 videoWidth);

    nsresult (*GetVideoHeight)(IRecordingScreenSettings *pThis, PRUint32 *videoHeight);
    nsresult (*SetVideoHeight)(IRecordingScreenSettings *pThis, PRUint32 videoHeight);

    nsresult (*GetVideoRate)(IRecordingScreenSettings *pThis, PRUint32 *videoRate);
    nsresult (*SetVideoRate)(IRecordingScreenSettings *pThis, PRUint32 videoRate);

    nsresult (*GetVideoRateControlMode)(IRecordingScreenSettings *pThis, PRUint32 *videoRateControlMode);
    nsresult (*SetVideoRateControlMode)(IRecordingScreenSettings *pThis, PRUint32 videoRateControlMode);

    nsresult (*GetVideoFPS)(IRecordingScreenSettings *pThis, PRUint32 *videoFPS);
    nsresult (*SetVideoFPS)(IRecordingScreenSettings *pThis, PRUint32 videoFPS);

    nsresult (*GetVideoScalingMode)(IRecordingScreenSettings *pThis, PRUint32 *videoScalingMode);
    nsresult (*SetVideoScalingMode)(IRecordingScreenSettings *pThis, PRUint32 videoScalingMode);

    nsresult (*IsFeatureEnabled)(
        IRecordingScreenSettings *pThis,
        PRUint32 feature,
        PRBool * enabled
    );

};
#define IRecordingScreenSettings_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IRecordingScreenSettings_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IRecordingScreenSettings_Release(p) ((p)->lpVtbl->Release(p))
#define IRecordingScreenSettings_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IRecordingScreenSettings_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IRecordingScreenSettings_get_Enabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IRecordingScreenSettings_GetEnabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IRecordingScreenSettings_put_Enabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IRecordingScreenSettings_SetEnabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IRecordingScreenSettings_get_Features(p, aFeatures) ((p)->lpVtbl->GetFeatures(p, aFeatures))
#define IRecordingScreenSettings_GetFeatures(p, aFeatures) ((p)->lpVtbl->GetFeatures(p, aFeatures))
#define IRecordingScreenSettings_put_Features(p, aFeatures) ((p)->lpVtbl->SetFeatures(p, aFeatures))
#define IRecordingScreenSettings_SetFeatures(p, aFeatures) ((p)->lpVtbl->SetFeatures(p, aFeatures))
#define IRecordingScreenSettings_get_Destination(p, aDestination) ((p)->lpVtbl->GetDestination(p, aDestination))
#define IRecordingScreenSettings_GetDestination(p, aDestination) ((p)->lpVtbl->GetDestination(p, aDestination))
#define IRecordingScreenSettings_put_Destination(p, aDestination) ((p)->lpVtbl->SetDestination(p, aDestination))
#define IRecordingScreenSettings_SetDestination(p, aDestination) ((p)->lpVtbl->SetDestination(p, aDestination))
#define IRecordingScreenSettings_get_Filename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IRecordingScreenSettings_GetFilename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IRecordingScreenSettings_put_Filename(p, aFilename) ((p)->lpVtbl->SetFilename(p, aFilename))
#define IRecordingScreenSettings_SetFilename(p, aFilename) ((p)->lpVtbl->SetFilename(p, aFilename))
#define IRecordingScreenSettings_get_MaxTime(p, aMaxTime) ((p)->lpVtbl->GetMaxTime(p, aMaxTime))
#define IRecordingScreenSettings_GetMaxTime(p, aMaxTime) ((p)->lpVtbl->GetMaxTime(p, aMaxTime))
#define IRecordingScreenSettings_put_MaxTime(p, aMaxTime) ((p)->lpVtbl->SetMaxTime(p, aMaxTime))
#define IRecordingScreenSettings_SetMaxTime(p, aMaxTime) ((p)->lpVtbl->SetMaxTime(p, aMaxTime))
#define IRecordingScreenSettings_get_MaxFileSize(p, aMaxFileSize) ((p)->lpVtbl->GetMaxFileSize(p, aMaxFileSize))
#define IRecordingScreenSettings_GetMaxFileSize(p, aMaxFileSize) ((p)->lpVtbl->GetMaxFileSize(p, aMaxFileSize))
#define IRecordingScreenSettings_put_MaxFileSize(p, aMaxFileSize) ((p)->lpVtbl->SetMaxFileSize(p, aMaxFileSize))
#define IRecordingScreenSettings_SetMaxFileSize(p, aMaxFileSize) ((p)->lpVtbl->SetMaxFileSize(p, aMaxFileSize))
#define IRecordingScreenSettings_get_Options(p, aOptions) ((p)->lpVtbl->GetOptions(p, aOptions))
#define IRecordingScreenSettings_GetOptions(p, aOptions) ((p)->lpVtbl->GetOptions(p, aOptions))
#define IRecordingScreenSettings_put_Options(p, aOptions) ((p)->lpVtbl->SetOptions(p, aOptions))
#define IRecordingScreenSettings_SetOptions(p, aOptions) ((p)->lpVtbl->SetOptions(p, aOptions))
#define IRecordingScreenSettings_get_AudioCodec(p, aAudioCodec) ((p)->lpVtbl->GetAudioCodec(p, aAudioCodec))
#define IRecordingScreenSettings_GetAudioCodec(p, aAudioCodec) ((p)->lpVtbl->GetAudioCodec(p, aAudioCodec))
#define IRecordingScreenSettings_put_AudioCodec(p, aAudioCodec) ((p)->lpVtbl->SetAudioCodec(p, aAudioCodec))
#define IRecordingScreenSettings_SetAudioCodec(p, aAudioCodec) ((p)->lpVtbl->SetAudioCodec(p, aAudioCodec))
#define IRecordingScreenSettings_get_AudioRateControlMode(p, aAudioRateControlMode) ((p)->lpVtbl->GetAudioRateControlMode(p, aAudioRateControlMode))
#define IRecordingScreenSettings_GetAudioRateControlMode(p, aAudioRateControlMode) ((p)->lpVtbl->GetAudioRateControlMode(p, aAudioRateControlMode))
#define IRecordingScreenSettings_put_AudioRateControlMode(p, aAudioRateControlMode) ((p)->lpVtbl->SetAudioRateControlMode(p, aAudioRateControlMode))
#define IRecordingScreenSettings_SetAudioRateControlMode(p, aAudioRateControlMode) ((p)->lpVtbl->SetAudioRateControlMode(p, aAudioRateControlMode))
#define IRecordingScreenSettings_get_AudioDeadline(p, aAudioDeadline) ((p)->lpVtbl->GetAudioDeadline(p, aAudioDeadline))
#define IRecordingScreenSettings_GetAudioDeadline(p, aAudioDeadline) ((p)->lpVtbl->GetAudioDeadline(p, aAudioDeadline))
#define IRecordingScreenSettings_put_AudioDeadline(p, aAudioDeadline) ((p)->lpVtbl->SetAudioDeadline(p, aAudioDeadline))
#define IRecordingScreenSettings_SetAudioDeadline(p, aAudioDeadline) ((p)->lpVtbl->SetAudioDeadline(p, aAudioDeadline))
#define IRecordingScreenSettings_get_AudioHz(p, aAudioHz) ((p)->lpVtbl->GetAudioHz(p, aAudioHz))
#define IRecordingScreenSettings_GetAudioHz(p, aAudioHz) ((p)->lpVtbl->GetAudioHz(p, aAudioHz))
#define IRecordingScreenSettings_put_AudioHz(p, aAudioHz) ((p)->lpVtbl->SetAudioHz(p, aAudioHz))
#define IRecordingScreenSettings_SetAudioHz(p, aAudioHz) ((p)->lpVtbl->SetAudioHz(p, aAudioHz))
#define IRecordingScreenSettings_get_AudioBits(p, aAudioBits) ((p)->lpVtbl->GetAudioBits(p, aAudioBits))
#define IRecordingScreenSettings_GetAudioBits(p, aAudioBits) ((p)->lpVtbl->GetAudioBits(p, aAudioBits))
#define IRecordingScreenSettings_put_AudioBits(p, aAudioBits) ((p)->lpVtbl->SetAudioBits(p, aAudioBits))
#define IRecordingScreenSettings_SetAudioBits(p, aAudioBits) ((p)->lpVtbl->SetAudioBits(p, aAudioBits))
#define IRecordingScreenSettings_get_AudioChannels(p, aAudioChannels) ((p)->lpVtbl->GetAudioChannels(p, aAudioChannels))
#define IRecordingScreenSettings_GetAudioChannels(p, aAudioChannels) ((p)->lpVtbl->GetAudioChannels(p, aAudioChannels))
#define IRecordingScreenSettings_put_AudioChannels(p, aAudioChannels) ((p)->lpVtbl->SetAudioChannels(p, aAudioChannels))
#define IRecordingScreenSettings_SetAudioChannels(p, aAudioChannels) ((p)->lpVtbl->SetAudioChannels(p, aAudioChannels))
#define IRecordingScreenSettings_get_VideoCodec(p, aVideoCodec) ((p)->lpVtbl->GetVideoCodec(p, aVideoCodec))
#define IRecordingScreenSettings_GetVideoCodec(p, aVideoCodec) ((p)->lpVtbl->GetVideoCodec(p, aVideoCodec))
#define IRecordingScreenSettings_put_VideoCodec(p, aVideoCodec) ((p)->lpVtbl->SetVideoCodec(p, aVideoCodec))
#define IRecordingScreenSettings_SetVideoCodec(p, aVideoCodec) ((p)->lpVtbl->SetVideoCodec(p, aVideoCodec))
#define IRecordingScreenSettings_get_VideoDeadline(p, aVideoDeadline) ((p)->lpVtbl->GetVideoDeadline(p, aVideoDeadline))
#define IRecordingScreenSettings_GetVideoDeadline(p, aVideoDeadline) ((p)->lpVtbl->GetVideoDeadline(p, aVideoDeadline))
#define IRecordingScreenSettings_put_VideoDeadline(p, aVideoDeadline) ((p)->lpVtbl->SetVideoDeadline(p, aVideoDeadline))
#define IRecordingScreenSettings_SetVideoDeadline(p, aVideoDeadline) ((p)->lpVtbl->SetVideoDeadline(p, aVideoDeadline))
#define IRecordingScreenSettings_get_VideoWidth(p, aVideoWidth) ((p)->lpVtbl->GetVideoWidth(p, aVideoWidth))
#define IRecordingScreenSettings_GetVideoWidth(p, aVideoWidth) ((p)->lpVtbl->GetVideoWidth(p, aVideoWidth))
#define IRecordingScreenSettings_put_VideoWidth(p, aVideoWidth) ((p)->lpVtbl->SetVideoWidth(p, aVideoWidth))
#define IRecordingScreenSettings_SetVideoWidth(p, aVideoWidth) ((p)->lpVtbl->SetVideoWidth(p, aVideoWidth))
#define IRecordingScreenSettings_get_VideoHeight(p, aVideoHeight) ((p)->lpVtbl->GetVideoHeight(p, aVideoHeight))
#define IRecordingScreenSettings_GetVideoHeight(p, aVideoHeight) ((p)->lpVtbl->GetVideoHeight(p, aVideoHeight))
#define IRecordingScreenSettings_put_VideoHeight(p, aVideoHeight) ((p)->lpVtbl->SetVideoHeight(p, aVideoHeight))
#define IRecordingScreenSettings_SetVideoHeight(p, aVideoHeight) ((p)->lpVtbl->SetVideoHeight(p, aVideoHeight))
#define IRecordingScreenSettings_get_VideoRate(p, aVideoRate) ((p)->lpVtbl->GetVideoRate(p, aVideoRate))
#define IRecordingScreenSettings_GetVideoRate(p, aVideoRate) ((p)->lpVtbl->GetVideoRate(p, aVideoRate))
#define IRecordingScreenSettings_put_VideoRate(p, aVideoRate) ((p)->lpVtbl->SetVideoRate(p, aVideoRate))
#define IRecordingScreenSettings_SetVideoRate(p, aVideoRate) ((p)->lpVtbl->SetVideoRate(p, aVideoRate))
#define IRecordingScreenSettings_get_VideoRateControlMode(p, aVideoRateControlMode) ((p)->lpVtbl->GetVideoRateControlMode(p, aVideoRateControlMode))
#define IRecordingScreenSettings_GetVideoRateControlMode(p, aVideoRateControlMode) ((p)->lpVtbl->GetVideoRateControlMode(p, aVideoRateControlMode))
#define IRecordingScreenSettings_put_VideoRateControlMode(p, aVideoRateControlMode) ((p)->lpVtbl->SetVideoRateControlMode(p, aVideoRateControlMode))
#define IRecordingScreenSettings_SetVideoRateControlMode(p, aVideoRateControlMode) ((p)->lpVtbl->SetVideoRateControlMode(p, aVideoRateControlMode))
#define IRecordingScreenSettings_get_VideoFPS(p, aVideoFPS) ((p)->lpVtbl->GetVideoFPS(p, aVideoFPS))
#define IRecordingScreenSettings_GetVideoFPS(p, aVideoFPS) ((p)->lpVtbl->GetVideoFPS(p, aVideoFPS))
#define IRecordingScreenSettings_put_VideoFPS(p, aVideoFPS) ((p)->lpVtbl->SetVideoFPS(p, aVideoFPS))
#define IRecordingScreenSettings_SetVideoFPS(p, aVideoFPS) ((p)->lpVtbl->SetVideoFPS(p, aVideoFPS))
#define IRecordingScreenSettings_get_VideoScalingMode(p, aVideoScalingMode) ((p)->lpVtbl->GetVideoScalingMode(p, aVideoScalingMode))
#define IRecordingScreenSettings_GetVideoScalingMode(p, aVideoScalingMode) ((p)->lpVtbl->GetVideoScalingMode(p, aVideoScalingMode))
#define IRecordingScreenSettings_put_VideoScalingMode(p, aVideoScalingMode) ((p)->lpVtbl->SetVideoScalingMode(p, aVideoScalingMode))
#define IRecordingScreenSettings_SetVideoScalingMode(p, aVideoScalingMode) ((p)->lpVtbl->SetVideoScalingMode(p, aVideoScalingMode))
#define IRecordingScreenSettings_IsFeatureEnabled(p, aFeature, aEnabled) ((p)->lpVtbl->IsFeatureEnabled(p, aFeature, aEnabled))
#endif /* VBOX_WITH_GLUE */

interface IRecordingScreenSettings
{
#ifndef VBOX_WITH_GLUE
    struct IRecordingScreenSettings_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IRecordingScreenSettingsVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IRecordingScreenSettings declaration */


/* Start of struct IRecordingSettings declaration */
#define IRECORDINGSETTINGS_IID_STR "bea3ef5c-de2f-4b74-aa3a-15d6249371a0"
#define IRECORDINGSETTINGS_IID { \
    0xbea3ef5c, 0xde2f, 0x4b74, \
    { 0xaa, 0x3a, 0x15, 0xd6, 0x24, 0x93, 0x71, 0xa0 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IRecordingSettings);
#ifndef VBOX_WITH_GLUE
struct IRecordingSettings_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetEnabled)(IRecordingSettings *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IRecordingSettings *pThis, PRBool enabled);

    nsresult (*GetScreens)(IRecordingSettings *pThis, PRUint32 *screensSize, IRecordingScreenSettings * **screens);

    nsresult (*GetProgress)(IRecordingSettings *pThis, IProgress * *progress);

    nsresult (*GetScreenSettings)(
        IRecordingSettings *pThis,
        PRUint32 screenId,
        IRecordingScreenSettings * * recordScreenSettings
    );

    nsresult (*Start)(
        IRecordingSettings *pThis,
        IProgress * * progress
    );

};
#else /* VBOX_WITH_GLUE */
struct IRecordingSettingsVtbl
{
    nsresult (*QueryInterface)(IRecordingSettings *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IRecordingSettings *pThis);
    nsrefcnt (*Release)(IRecordingSettings *pThis);
    nsresult (*GetEnabled)(IRecordingSettings *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IRecordingSettings *pThis, PRBool enabled);

    nsresult (*GetScreens)(IRecordingSettings *pThis, PRUint32 *screensSize, IRecordingScreenSettings * **screens);

    nsresult (*GetProgress)(IRecordingSettings *pThis, IProgress * *progress);

    nsresult (*GetScreenSettings)(
        IRecordingSettings *pThis,
        PRUint32 screenId,
        IRecordingScreenSettings * * recordScreenSettings
    );

    nsresult (*Start)(
        IRecordingSettings *pThis,
        IProgress * * progress
    );

};
#define IRecordingSettings_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IRecordingSettings_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IRecordingSettings_Release(p) ((p)->lpVtbl->Release(p))
#define IRecordingSettings_get_Enabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IRecordingSettings_GetEnabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IRecordingSettings_put_Enabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IRecordingSettings_SetEnabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IRecordingSettings_get_Screens(p, aScreens) ((p)->lpVtbl->GetScreens(p, aScreens))
#define IRecordingSettings_GetScreens(p, aScreens) ((p)->lpVtbl->GetScreens(p, aScreens))
#define IRecordingSettings_get_Progress(p, aProgress) ((p)->lpVtbl->GetProgress(p, aProgress))
#define IRecordingSettings_GetProgress(p, aProgress) ((p)->lpVtbl->GetProgress(p, aProgress))
#define IRecordingSettings_GetScreenSettings(p, aScreenId, aRecordScreenSettings) ((p)->lpVtbl->GetScreenSettings(p, aScreenId, aRecordScreenSettings))
#define IRecordingSettings_Start(p, aProgress) ((p)->lpVtbl->Start(p, aProgress))
#endif /* VBOX_WITH_GLUE */

interface IRecordingSettings
{
#ifndef VBOX_WITH_GLUE
    struct IRecordingSettings_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IRecordingSettingsVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IRecordingSettings declaration */


/* Start of struct IPCIAddress declaration */
#define IPCIADDRESS_IID_STR "c984d15f-e191-400b-840e-970f3dad7296"
#define IPCIADDRESS_IID { \
    0xc984d15f, 0xe191, 0x400b, \
    { 0x84, 0x0e, 0x97, 0x0f, 0x3d, 0xad, 0x72, 0x96 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IPCIAddress);
#ifndef VBOX_WITH_GLUE
struct IPCIAddress_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetBus)(IPCIAddress *pThis, PRInt16 *bus);
    nsresult (*SetBus)(IPCIAddress *pThis, PRInt16 bus);

    nsresult (*GetDevice)(IPCIAddress *pThis, PRInt16 *device);
    nsresult (*SetDevice)(IPCIAddress *pThis, PRInt16 device);

    nsresult (*GetDevFunction)(IPCIAddress *pThis, PRInt16 *devFunction);
    nsresult (*SetDevFunction)(IPCIAddress *pThis, PRInt16 devFunction);

    nsresult (*AsLong)(
        IPCIAddress *pThis,
        PRInt32 * result
    );

    nsresult (*FromLong)(
        IPCIAddress *pThis,
        PRInt32 number
    );

};
#else /* VBOX_WITH_GLUE */
struct IPCIAddressVtbl
{
    nsresult (*QueryInterface)(IPCIAddress *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IPCIAddress *pThis);
    nsrefcnt (*Release)(IPCIAddress *pThis);
    nsresult (*GetBus)(IPCIAddress *pThis, PRInt16 *bus);
    nsresult (*SetBus)(IPCIAddress *pThis, PRInt16 bus);

    nsresult (*GetDevice)(IPCIAddress *pThis, PRInt16 *device);
    nsresult (*SetDevice)(IPCIAddress *pThis, PRInt16 device);

    nsresult (*GetDevFunction)(IPCIAddress *pThis, PRInt16 *devFunction);
    nsresult (*SetDevFunction)(IPCIAddress *pThis, PRInt16 devFunction);

    nsresult (*AsLong)(
        IPCIAddress *pThis,
        PRInt32 * result
    );

    nsresult (*FromLong)(
        IPCIAddress *pThis,
        PRInt32 number
    );

};
#define IPCIAddress_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IPCIAddress_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IPCIAddress_Release(p) ((p)->lpVtbl->Release(p))
#define IPCIAddress_get_Bus(p, aBus) ((p)->lpVtbl->GetBus(p, aBus))
#define IPCIAddress_GetBus(p, aBus) ((p)->lpVtbl->GetBus(p, aBus))
#define IPCIAddress_put_Bus(p, aBus) ((p)->lpVtbl->SetBus(p, aBus))
#define IPCIAddress_SetBus(p, aBus) ((p)->lpVtbl->SetBus(p, aBus))
#define IPCIAddress_get_Device(p, aDevice) ((p)->lpVtbl->GetDevice(p, aDevice))
#define IPCIAddress_GetDevice(p, aDevice) ((p)->lpVtbl->GetDevice(p, aDevice))
#define IPCIAddress_put_Device(p, aDevice) ((p)->lpVtbl->SetDevice(p, aDevice))
#define IPCIAddress_SetDevice(p, aDevice) ((p)->lpVtbl->SetDevice(p, aDevice))
#define IPCIAddress_get_DevFunction(p, aDevFunction) ((p)->lpVtbl->GetDevFunction(p, aDevFunction))
#define IPCIAddress_GetDevFunction(p, aDevFunction) ((p)->lpVtbl->GetDevFunction(p, aDevFunction))
#define IPCIAddress_put_DevFunction(p, aDevFunction) ((p)->lpVtbl->SetDevFunction(p, aDevFunction))
#define IPCIAddress_SetDevFunction(p, aDevFunction) ((p)->lpVtbl->SetDevFunction(p, aDevFunction))
#define IPCIAddress_AsLong(p, aResult) ((p)->lpVtbl->AsLong(p, aResult))
#define IPCIAddress_FromLong(p, aNumber) ((p)->lpVtbl->FromLong(p, aNumber))
#endif /* VBOX_WITH_GLUE */

interface IPCIAddress
{
#ifndef VBOX_WITH_GLUE
    struct IPCIAddress_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IPCIAddressVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IPCIAddress declaration */


/* Start of struct IPCIDeviceAttachment declaration */
#define IPCIDEVICEATTACHMENT_IID_STR "91f33d6f-e621-4f70-a77e-15f0e3c714d5"
#define IPCIDEVICEATTACHMENT_IID { \
    0x91f33d6f, 0xe621, 0x4f70, \
    { 0xa7, 0x7e, 0x15, 0xf0, 0xe3, 0xc7, 0x14, 0xd5 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IPCIDeviceAttachment);
#ifndef VBOX_WITH_GLUE
struct IPCIDeviceAttachment_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetName)(IPCIDeviceAttachment *pThis, PRUnichar * *name);

    nsresult (*GetIsPhysicalDevice)(IPCIDeviceAttachment *pThis, PRBool *isPhysicalDevice);

    nsresult (*GetHostAddress)(IPCIDeviceAttachment *pThis, PRInt32 *hostAddress);

    nsresult (*GetGuestAddress)(IPCIDeviceAttachment *pThis, PRInt32 *guestAddress);

};
#else /* VBOX_WITH_GLUE */
struct IPCIDeviceAttachmentVtbl
{
    nsresult (*QueryInterface)(IPCIDeviceAttachment *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IPCIDeviceAttachment *pThis);
    nsrefcnt (*Release)(IPCIDeviceAttachment *pThis);
    nsresult (*GetName)(IPCIDeviceAttachment *pThis, PRUnichar * *name);

    nsresult (*GetIsPhysicalDevice)(IPCIDeviceAttachment *pThis, PRBool *isPhysicalDevice);

    nsresult (*GetHostAddress)(IPCIDeviceAttachment *pThis, PRInt32 *hostAddress);

    nsresult (*GetGuestAddress)(IPCIDeviceAttachment *pThis, PRInt32 *guestAddress);

};
#define IPCIDeviceAttachment_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IPCIDeviceAttachment_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IPCIDeviceAttachment_Release(p) ((p)->lpVtbl->Release(p))
#define IPCIDeviceAttachment_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IPCIDeviceAttachment_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IPCIDeviceAttachment_get_IsPhysicalDevice(p, aIsPhysicalDevice) ((p)->lpVtbl->GetIsPhysicalDevice(p, aIsPhysicalDevice))
#define IPCIDeviceAttachment_GetIsPhysicalDevice(p, aIsPhysicalDevice) ((p)->lpVtbl->GetIsPhysicalDevice(p, aIsPhysicalDevice))
#define IPCIDeviceAttachment_get_HostAddress(p, aHostAddress) ((p)->lpVtbl->GetHostAddress(p, aHostAddress))
#define IPCIDeviceAttachment_GetHostAddress(p, aHostAddress) ((p)->lpVtbl->GetHostAddress(p, aHostAddress))
#define IPCIDeviceAttachment_get_GuestAddress(p, aGuestAddress) ((p)->lpVtbl->GetGuestAddress(p, aGuestAddress))
#define IPCIDeviceAttachment_GetGuestAddress(p, aGuestAddress) ((p)->lpVtbl->GetGuestAddress(p, aGuestAddress))
#endif /* VBOX_WITH_GLUE */

interface IPCIDeviceAttachment
{
#ifndef VBOX_WITH_GLUE
    struct IPCIDeviceAttachment_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IPCIDeviceAttachmentVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IPCIDeviceAttachment declaration */


/* Start of struct IUefiVariableStore declaration */
#define IUEFIVARIABLESTORE_IID_STR "d134c6b6-4479-430d-bb73-68a452ba3e67"
#define IUEFIVARIABLESTORE_IID { \
    0xd134c6b6, 0x4479, 0x430d, \
    { 0xbb, 0x73, 0x68, 0xa4, 0x52, 0xba, 0x3e, 0x67 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IUefiVariableStore);
#ifndef VBOX_WITH_GLUE
struct IUefiVariableStore_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetSecureBootEnabled)(IUefiVariableStore *pThis, PRBool *secureBootEnabled);
    nsresult (*SetSecureBootEnabled)(IUefiVariableStore *pThis, PRBool secureBootEnabled);

    nsresult (*GetInternalAndReservedAttribute1IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*AddVariable)(
        IUefiVariableStore *pThis,
        PRUnichar * name,
        PRUnichar * owner,
        PRUint32 attributesSize,
        PRUint32* attributes,
        PRUint32 dataSize,
        PRUint8* data
    );

    nsresult (*DeleteVariable)(
        IUefiVariableStore *pThis,
        PRUnichar * name,
        PRUnichar * owner
    );

    nsresult (*ChangeVariable)(
        IUefiVariableStore *pThis,
        PRUnichar * name,
        PRUint32 dataSize,
        PRUint8* data
    );

    nsresult (*QueryVariableByName)(
        IUefiVariableStore *pThis,
        PRUnichar * name,
        PRUnichar * * owner,
        PRUint32 *attributesSize,
        PRUint32** attributes,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*QueryVariables)(
        IUefiVariableStore *pThis,
        PRUint32 *namesSize,
        PRUnichar *** names,
        PRUint32 *ownersSize,
        PRUnichar *** owners
    );

    nsresult (*EnrollOraclePlatformKey)(IUefiVariableStore *pThis );

    nsresult (*EnrollPlatformKey)(
        IUefiVariableStore *pThis,
        PRUint32 platformKeySize,
        PRUint8* platformKey,
        PRUnichar * owner
    );

    nsresult (*AddKek)(
        IUefiVariableStore *pThis,
        PRUint32 keyEncryptionKeySize,
        PRUint8* keyEncryptionKey,
        PRUnichar * owner,
        PRUint32 signatureType
    );

    nsresult (*AddSignatureToDb)(
        IUefiVariableStore *pThis,
        PRUint32 signatureSize,
        PRUint8* signature,
        PRUnichar * owner,
        PRUint32 signatureType
    );

    nsresult (*AddSignatureToDbx)(
        IUefiVariableStore *pThis,
        PRUint32 signatureSize,
        PRUint8* signature,
        PRUnichar * owner,
        PRUint32 signatureType
    );

    nsresult (*EnrollDefaultMsSignatures)(IUefiVariableStore *pThis );

    nsresult (*AddSignatureToMok)(
        IUefiVariableStore *pThis,
        PRUint32 signatureSize,
        PRUint8* signature,
        PRUnichar * owner,
        PRUint32 signatureType
    );

    nsresult (*InternalAndReservedMethod1IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod2IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod3IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod4IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod5IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod6IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod7IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod8IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod9IUefiVariableStore)(IUefiVariableStore *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IUefiVariableStoreVtbl
{
    nsresult (*QueryInterface)(IUefiVariableStore *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IUefiVariableStore *pThis);
    nsrefcnt (*Release)(IUefiVariableStore *pThis);
    nsresult (*GetSecureBootEnabled)(IUefiVariableStore *pThis, PRBool *secureBootEnabled);
    nsresult (*SetSecureBootEnabled)(IUefiVariableStore *pThis, PRBool secureBootEnabled);

    nsresult (*GetInternalAndReservedAttribute1IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IUefiVariableStore)(IUefiVariableStore *pThis, PRUint32 *reserved);

    nsresult (*AddVariable)(
        IUefiVariableStore *pThis,
        PRUnichar * name,
        PRUnichar * owner,
        PRUint32 attributesSize,
        PRUint32* attributes,
        PRUint32 dataSize,
        PRUint8* data
    );

    nsresult (*DeleteVariable)(
        IUefiVariableStore *pThis,
        PRUnichar * name,
        PRUnichar * owner
    );

    nsresult (*ChangeVariable)(
        IUefiVariableStore *pThis,
        PRUnichar * name,
        PRUint32 dataSize,
        PRUint8* data
    );

    nsresult (*QueryVariableByName)(
        IUefiVariableStore *pThis,
        PRUnichar * name,
        PRUnichar * * owner,
        PRUint32 *attributesSize,
        PRUint32** attributes,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*QueryVariables)(
        IUefiVariableStore *pThis,
        PRUint32 *namesSize,
        PRUnichar *** names,
        PRUint32 *ownersSize,
        PRUnichar *** owners
    );

    nsresult (*EnrollOraclePlatformKey)(IUefiVariableStore *pThis );

    nsresult (*EnrollPlatformKey)(
        IUefiVariableStore *pThis,
        PRUint32 platformKeySize,
        PRUint8* platformKey,
        PRUnichar * owner
    );

    nsresult (*AddKek)(
        IUefiVariableStore *pThis,
        PRUint32 keyEncryptionKeySize,
        PRUint8* keyEncryptionKey,
        PRUnichar * owner,
        PRUint32 signatureType
    );

    nsresult (*AddSignatureToDb)(
        IUefiVariableStore *pThis,
        PRUint32 signatureSize,
        PRUint8* signature,
        PRUnichar * owner,
        PRUint32 signatureType
    );

    nsresult (*AddSignatureToDbx)(
        IUefiVariableStore *pThis,
        PRUint32 signatureSize,
        PRUint8* signature,
        PRUnichar * owner,
        PRUint32 signatureType
    );

    nsresult (*EnrollDefaultMsSignatures)(IUefiVariableStore *pThis );

    nsresult (*AddSignatureToMok)(
        IUefiVariableStore *pThis,
        PRUint32 signatureSize,
        PRUint8* signature,
        PRUnichar * owner,
        PRUint32 signatureType
    );

    nsresult (*InternalAndReservedMethod1IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod2IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod3IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod4IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod5IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod6IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod7IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod8IUefiVariableStore)(IUefiVariableStore *pThis);

    nsresult (*InternalAndReservedMethod9IUefiVariableStore)(IUefiVariableStore *pThis);

};
#define IUefiVariableStore_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IUefiVariableStore_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IUefiVariableStore_Release(p) ((p)->lpVtbl->Release(p))
#define IUefiVariableStore_get_SecureBootEnabled(p, aSecureBootEnabled) ((p)->lpVtbl->GetSecureBootEnabled(p, aSecureBootEnabled))
#define IUefiVariableStore_GetSecureBootEnabled(p, aSecureBootEnabled) ((p)->lpVtbl->GetSecureBootEnabled(p, aSecureBootEnabled))
#define IUefiVariableStore_put_SecureBootEnabled(p, aSecureBootEnabled) ((p)->lpVtbl->SetSecureBootEnabled(p, aSecureBootEnabled))
#define IUefiVariableStore_SetSecureBootEnabled(p, aSecureBootEnabled) ((p)->lpVtbl->SetSecureBootEnabled(p, aSecureBootEnabled))
#define IUefiVariableStore_AddVariable(p, aName, aOwner, aAttributes, aData) ((p)->lpVtbl->AddVariable(p, aName, aOwner, aAttributes, aData))
#define IUefiVariableStore_DeleteVariable(p, aName, aOwner) ((p)->lpVtbl->DeleteVariable(p, aName, aOwner))
#define IUefiVariableStore_ChangeVariable(p, aName, aData) ((p)->lpVtbl->ChangeVariable(p, aName, aData))
#define IUefiVariableStore_QueryVariableByName(p, aName, aOwner, aAttributes, aData) ((p)->lpVtbl->QueryVariableByName(p, aName, aOwner, aAttributes, aData))
#define IUefiVariableStore_QueryVariables(p, aNames, aOwners) ((p)->lpVtbl->QueryVariables(p, aNames, aOwners))
#define IUefiVariableStore_EnrollOraclePlatformKey(p) ((p)->lpVtbl->EnrollOraclePlatformKey(p))
#define IUefiVariableStore_EnrollPlatformKey(p, aPlatformKey, aOwner) ((p)->lpVtbl->EnrollPlatformKey(p, aPlatformKey, aOwner))
#define IUefiVariableStore_AddKek(p, aKeyEncryptionKey, aOwner, aSignatureType) ((p)->lpVtbl->AddKek(p, aKeyEncryptionKey, aOwner, aSignatureType))
#define IUefiVariableStore_AddSignatureToDb(p, aSignature, aOwner, aSignatureType) ((p)->lpVtbl->AddSignatureToDb(p, aSignature, aOwner, aSignatureType))
#define IUefiVariableStore_AddSignatureToDbx(p, aSignature, aOwner, aSignatureType) ((p)->lpVtbl->AddSignatureToDbx(p, aSignature, aOwner, aSignatureType))
#define IUefiVariableStore_EnrollDefaultMsSignatures(p) ((p)->lpVtbl->EnrollDefaultMsSignatures(p))
#define IUefiVariableStore_AddSignatureToMok(p, aSignature, aOwner, aSignatureType) ((p)->lpVtbl->AddSignatureToMok(p, aSignature, aOwner, aSignatureType))
#endif /* VBOX_WITH_GLUE */

interface IUefiVariableStore
{
#ifndef VBOX_WITH_GLUE
    struct IUefiVariableStore_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IUefiVariableStoreVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IUefiVariableStore declaration */


/* Start of struct INvramStore declaration */
#define INVRAMSTORE_IID_STR "5bfd8965-b81b-469f-8649-f717ce97a5d5"
#define INVRAMSTORE_IID { \
    0x5bfd8965, 0xb81b, 0x469f, \
    { 0x86, 0x49, 0xf7, 0x17, 0xce, 0x97, 0xa5, 0xd5 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_INvramStore);
#ifndef VBOX_WITH_GLUE
struct INvramStore_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetNonVolatileStorageFile)(INvramStore *pThis, PRUnichar * *nonVolatileStorageFile);

    nsresult (*GetUefiVariableStore)(INvramStore *pThis, IUefiVariableStore * *uefiVariableStore);

    nsresult (*GetKeyId)(INvramStore *pThis, PRUnichar * *keyId);

    nsresult (*GetKeyStore)(INvramStore *pThis, PRUnichar * *keyStore);

    nsresult (*InitUefiVariableStore)(
        INvramStore *pThis,
        PRUint32 size
    );

};
#else /* VBOX_WITH_GLUE */
struct INvramStoreVtbl
{
    nsresult (*QueryInterface)(INvramStore *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(INvramStore *pThis);
    nsrefcnt (*Release)(INvramStore *pThis);
    nsresult (*GetNonVolatileStorageFile)(INvramStore *pThis, PRUnichar * *nonVolatileStorageFile);

    nsresult (*GetUefiVariableStore)(INvramStore *pThis, IUefiVariableStore * *uefiVariableStore);

    nsresult (*GetKeyId)(INvramStore *pThis, PRUnichar * *keyId);

    nsresult (*GetKeyStore)(INvramStore *pThis, PRUnichar * *keyStore);

    nsresult (*InitUefiVariableStore)(
        INvramStore *pThis,
        PRUint32 size
    );

};
#define INvramStore_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define INvramStore_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define INvramStore_Release(p) ((p)->lpVtbl->Release(p))
#define INvramStore_get_NonVolatileStorageFile(p, aNonVolatileStorageFile) ((p)->lpVtbl->GetNonVolatileStorageFile(p, aNonVolatileStorageFile))
#define INvramStore_GetNonVolatileStorageFile(p, aNonVolatileStorageFile) ((p)->lpVtbl->GetNonVolatileStorageFile(p, aNonVolatileStorageFile))
#define INvramStore_get_UefiVariableStore(p, aUefiVariableStore) ((p)->lpVtbl->GetUefiVariableStore(p, aUefiVariableStore))
#define INvramStore_GetUefiVariableStore(p, aUefiVariableStore) ((p)->lpVtbl->GetUefiVariableStore(p, aUefiVariableStore))
#define INvramStore_get_KeyId(p, aKeyId) ((p)->lpVtbl->GetKeyId(p, aKeyId))
#define INvramStore_GetKeyId(p, aKeyId) ((p)->lpVtbl->GetKeyId(p, aKeyId))
#define INvramStore_get_KeyStore(p, aKeyStore) ((p)->lpVtbl->GetKeyStore(p, aKeyStore))
#define INvramStore_GetKeyStore(p, aKeyStore) ((p)->lpVtbl->GetKeyStore(p, aKeyStore))
#define INvramStore_InitUefiVariableStore(p, aSize) ((p)->lpVtbl->InitUefiVariableStore(p, aSize))
#endif /* VBOX_WITH_GLUE */

interface INvramStore
{
#ifndef VBOX_WITH_GLUE
    struct INvramStore_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct INvramStoreVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct INvramStore declaration */


/* Start of struct IResourceStore declaration */
#define IRESOURCESTORE_IID_STR "d96a2540-8aab-4c71-8af9-95379f23b23d"
#define IRESOURCESTORE_IID { \
    0xd96a2540, 0x8aab, 0x4c71, \
    { 0x8a, 0xf9, 0x95, 0x37, 0x9f, 0x23, 0xb2, 0x3d } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IResourceStore);
#ifndef VBOX_WITH_GLUE
struct IResourceStore_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IResourceStore *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#else /* VBOX_WITH_GLUE */
struct IResourceStoreVtbl
{
    nsresult (*QueryInterface)(IResourceStore *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IResourceStore *pThis);
    nsrefcnt (*Release)(IResourceStore *pThis);
    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IResourceStore *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#define IResourceStore_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IResourceStore_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IResourceStore_Release(p) ((p)->lpVtbl->Release(p))
#define IResourceStore_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IResourceStore_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IResourceStore
{
#ifndef VBOX_WITH_GLUE
    struct IResourceStore_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IResourceStoreVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IResourceStore declaration */


/* Start of struct IPlatform declaration */
#define IPLATFORM_IID_STR "a670a023-e172-452c-b731-14ef855f4da6"
#define IPLATFORM_IID { \
    0xa670a023, 0xe172, 0x452c, \
    { 0xb7, 0x31, 0x14, 0xef, 0x85, 0x5f, 0x4d, 0xa6 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IPlatform);
#ifndef VBOX_WITH_GLUE
struct IPlatform_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetArchitecture)(IPlatform *pThis, PRUint32 *architecture);
    nsresult (*SetArchitecture)(IPlatform *pThis, PRUint32 architecture);

    nsresult (*GetProperties)(IPlatform *pThis, IPlatformProperties * *properties);

    nsresult (*GetX86)(IPlatform *pThis, IPlatformX86 * *x86);

    nsresult (*GetARM)(IPlatform *pThis, IPlatformARM * *ARM);

    nsresult (*GetChipsetType)(IPlatform *pThis, PRUint32 *chipsetType);
    nsresult (*SetChipsetType)(IPlatform *pThis, PRUint32 chipsetType);

    nsresult (*GetIommuType)(IPlatform *pThis, PRUint32 *iommuType);
    nsresult (*SetIommuType)(IPlatform *pThis, PRUint32 iommuType);

    nsresult (*GetRTCUseUTC)(IPlatform *pThis, PRBool *RTCUseUTC);
    nsresult (*SetRTCUseUTC)(IPlatform *pThis, PRBool RTCUseUTC);

    nsresult (*GetInternalAndReservedAttribute1IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod2IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod3IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod4IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod5IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod6IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod7IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod8IPlatform)(IPlatform *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IPlatformVtbl
{
    nsresult (*QueryInterface)(IPlatform *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IPlatform *pThis);
    nsrefcnt (*Release)(IPlatform *pThis);
    nsresult (*GetArchitecture)(IPlatform *pThis, PRUint32 *architecture);
    nsresult (*SetArchitecture)(IPlatform *pThis, PRUint32 architecture);

    nsresult (*GetProperties)(IPlatform *pThis, IPlatformProperties * *properties);

    nsresult (*GetX86)(IPlatform *pThis, IPlatformX86 * *x86);

    nsresult (*GetARM)(IPlatform *pThis, IPlatformARM * *ARM);

    nsresult (*GetChipsetType)(IPlatform *pThis, PRUint32 *chipsetType);
    nsresult (*SetChipsetType)(IPlatform *pThis, PRUint32 chipsetType);

    nsresult (*GetIommuType)(IPlatform *pThis, PRUint32 *iommuType);
    nsresult (*SetIommuType)(IPlatform *pThis, PRUint32 iommuType);

    nsresult (*GetRTCUseUTC)(IPlatform *pThis, PRBool *RTCUseUTC);
    nsresult (*SetRTCUseUTC)(IPlatform *pThis, PRBool RTCUseUTC);

    nsresult (*GetInternalAndReservedAttribute1IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IPlatform)(IPlatform *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod2IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod3IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod4IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod5IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod6IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod7IPlatform)(IPlatform *pThis);

    nsresult (*InternalAndReservedMethod8IPlatform)(IPlatform *pThis);

};
#define IPlatform_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IPlatform_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IPlatform_Release(p) ((p)->lpVtbl->Release(p))
#define IPlatform_get_Architecture(p, aArchitecture) ((p)->lpVtbl->GetArchitecture(p, aArchitecture))
#define IPlatform_GetArchitecture(p, aArchitecture) ((p)->lpVtbl->GetArchitecture(p, aArchitecture))
#define IPlatform_put_Architecture(p, aArchitecture) ((p)->lpVtbl->SetArchitecture(p, aArchitecture))
#define IPlatform_SetArchitecture(p, aArchitecture) ((p)->lpVtbl->SetArchitecture(p, aArchitecture))
#define IPlatform_get_Properties(p, aProperties) ((p)->lpVtbl->GetProperties(p, aProperties))
#define IPlatform_GetProperties(p, aProperties) ((p)->lpVtbl->GetProperties(p, aProperties))
#define IPlatform_get_X86(p, aX86) ((p)->lpVtbl->GetX86(p, aX86))
#define IPlatform_GetX86(p, aX86) ((p)->lpVtbl->GetX86(p, aX86))
#define IPlatform_get_ARM(p, aARM) ((p)->lpVtbl->GetARM(p, aARM))
#define IPlatform_GetARM(p, aARM) ((p)->lpVtbl->GetARM(p, aARM))
#define IPlatform_get_ChipsetType(p, aChipsetType) ((p)->lpVtbl->GetChipsetType(p, aChipsetType))
#define IPlatform_GetChipsetType(p, aChipsetType) ((p)->lpVtbl->GetChipsetType(p, aChipsetType))
#define IPlatform_put_ChipsetType(p, aChipsetType) ((p)->lpVtbl->SetChipsetType(p, aChipsetType))
#define IPlatform_SetChipsetType(p, aChipsetType) ((p)->lpVtbl->SetChipsetType(p, aChipsetType))
#define IPlatform_get_IommuType(p, aIommuType) ((p)->lpVtbl->GetIommuType(p, aIommuType))
#define IPlatform_GetIommuType(p, aIommuType) ((p)->lpVtbl->GetIommuType(p, aIommuType))
#define IPlatform_put_IommuType(p, aIommuType) ((p)->lpVtbl->SetIommuType(p, aIommuType))
#define IPlatform_SetIommuType(p, aIommuType) ((p)->lpVtbl->SetIommuType(p, aIommuType))
#define IPlatform_get_RTCUseUTC(p, aRTCUseUTC) ((p)->lpVtbl->GetRTCUseUTC(p, aRTCUseUTC))
#define IPlatform_GetRTCUseUTC(p, aRTCUseUTC) ((p)->lpVtbl->GetRTCUseUTC(p, aRTCUseUTC))
#define IPlatform_put_RTCUseUTC(p, aRTCUseUTC) ((p)->lpVtbl->SetRTCUseUTC(p, aRTCUseUTC))
#define IPlatform_SetRTCUseUTC(p, aRTCUseUTC) ((p)->lpVtbl->SetRTCUseUTC(p, aRTCUseUTC))
#endif /* VBOX_WITH_GLUE */

interface IPlatform
{
#ifndef VBOX_WITH_GLUE
    struct IPlatform_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IPlatformVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IPlatform declaration */


/* Start of struct IPlatformX86 declaration */
#define IPLATFORMX86_IID_STR "5ada589f-09c9-4604-b700-9ab3a5572e3a"
#define IPLATFORMX86_IID { \
    0x5ada589f, 0x09c9, 0x4604, \
    { 0xb7, 0x00, 0x9a, 0xb3, 0xa5, 0x57, 0x2e, 0x3a } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IPlatformX86);
#ifndef VBOX_WITH_GLUE
struct IPlatformX86_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetHPETEnabled)(IPlatformX86 *pThis, PRBool *HPETEnabled);
    nsresult (*SetHPETEnabled)(IPlatformX86 *pThis, PRBool HPETEnabled);

    nsresult (*GetInternalAndReservedAttribute1IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetCPUProperty)(
        IPlatformX86 *pThis,
        PRUint32 property,
        PRBool * value
    );

    nsresult (*SetCPUProperty)(
        IPlatformX86 *pThis,
        PRUint32 property,
        PRBool value
    );

    nsresult (*GetCPUIDLeafByOrdinal)(
        IPlatformX86 *pThis,
        PRUint32 ordinal,
        PRUint32 * idx,
        PRUint32 * idxSub,
        PRUint32 * valEax,
        PRUint32 * valEbx,
        PRUint32 * valEcx,
        PRUint32 * valEdx
    );

    nsresult (*GetCPUIDLeaf)(
        IPlatformX86 *pThis,
        PRUint32 idx,
        PRUint32 idxSub,
        PRUint32 * valEax,
        PRUint32 * valEbx,
        PRUint32 * valEcx,
        PRUint32 * valEdx
    );

    nsresult (*SetCPUIDLeaf)(
        IPlatformX86 *pThis,
        PRUint32 idx,
        PRUint32 idxSub,
        PRUint32 valEax,
        PRUint32 valEbx,
        PRUint32 valEcx,
        PRUint32 valEdx
    );

    nsresult (*RemoveCPUIDLeaf)(
        IPlatformX86 *pThis,
        PRUint32 idx,
        PRUint32 idxSub
    );

    nsresult (*RemoveAllCPUIDLeaves)(IPlatformX86 *pThis );

    nsresult (*GetHWVirtExProperty)(
        IPlatformX86 *pThis,
        PRUint32 property,
        PRBool * value
    );

    nsresult (*SetHWVirtExProperty)(
        IPlatformX86 *pThis,
        PRUint32 property,
        PRBool value
    );

    nsresult (*InternalAndReservedMethod1IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod2IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod3IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod4IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod5IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod6IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod7IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod8IPlatformX86)(IPlatformX86 *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IPlatformX86Vtbl
{
    nsresult (*QueryInterface)(IPlatformX86 *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IPlatformX86 *pThis);
    nsrefcnt (*Release)(IPlatformX86 *pThis);
    nsresult (*GetHPETEnabled)(IPlatformX86 *pThis, PRBool *HPETEnabled);
    nsresult (*SetHPETEnabled)(IPlatformX86 *pThis, PRBool HPETEnabled);

    nsresult (*GetInternalAndReservedAttribute1IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IPlatformX86)(IPlatformX86 *pThis, PRUint32 *reserved);

    nsresult (*GetCPUProperty)(
        IPlatformX86 *pThis,
        PRUint32 property,
        PRBool * value
    );

    nsresult (*SetCPUProperty)(
        IPlatformX86 *pThis,
        PRUint32 property,
        PRBool value
    );

    nsresult (*GetCPUIDLeafByOrdinal)(
        IPlatformX86 *pThis,
        PRUint32 ordinal,
        PRUint32 * idx,
        PRUint32 * idxSub,
        PRUint32 * valEax,
        PRUint32 * valEbx,
        PRUint32 * valEcx,
        PRUint32 * valEdx
    );

    nsresult (*GetCPUIDLeaf)(
        IPlatformX86 *pThis,
        PRUint32 idx,
        PRUint32 idxSub,
        PRUint32 * valEax,
        PRUint32 * valEbx,
        PRUint32 * valEcx,
        PRUint32 * valEdx
    );

    nsresult (*SetCPUIDLeaf)(
        IPlatformX86 *pThis,
        PRUint32 idx,
        PRUint32 idxSub,
        PRUint32 valEax,
        PRUint32 valEbx,
        PRUint32 valEcx,
        PRUint32 valEdx
    );

    nsresult (*RemoveCPUIDLeaf)(
        IPlatformX86 *pThis,
        PRUint32 idx,
        PRUint32 idxSub
    );

    nsresult (*RemoveAllCPUIDLeaves)(IPlatformX86 *pThis );

    nsresult (*GetHWVirtExProperty)(
        IPlatformX86 *pThis,
        PRUint32 property,
        PRBool * value
    );

    nsresult (*SetHWVirtExProperty)(
        IPlatformX86 *pThis,
        PRUint32 property,
        PRBool value
    );

    nsresult (*InternalAndReservedMethod1IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod2IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod3IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod4IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod5IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod6IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod7IPlatformX86)(IPlatformX86 *pThis);

    nsresult (*InternalAndReservedMethod8IPlatformX86)(IPlatformX86 *pThis);

};
#define IPlatformX86_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IPlatformX86_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IPlatformX86_Release(p) ((p)->lpVtbl->Release(p))
#define IPlatformX86_get_HPETEnabled(p, aHPETEnabled) ((p)->lpVtbl->GetHPETEnabled(p, aHPETEnabled))
#define IPlatformX86_GetHPETEnabled(p, aHPETEnabled) ((p)->lpVtbl->GetHPETEnabled(p, aHPETEnabled))
#define IPlatformX86_put_HPETEnabled(p, aHPETEnabled) ((p)->lpVtbl->SetHPETEnabled(p, aHPETEnabled))
#define IPlatformX86_SetHPETEnabled(p, aHPETEnabled) ((p)->lpVtbl->SetHPETEnabled(p, aHPETEnabled))
#define IPlatformX86_GetCPUProperty(p, aProperty, aValue) ((p)->lpVtbl->GetCPUProperty(p, aProperty, aValue))
#define IPlatformX86_SetCPUProperty(p, aProperty, aValue) ((p)->lpVtbl->SetCPUProperty(p, aProperty, aValue))
#define IPlatformX86_GetCPUIDLeafByOrdinal(p, aOrdinal, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx) ((p)->lpVtbl->GetCPUIDLeafByOrdinal(p, aOrdinal, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx))
#define IPlatformX86_GetCPUIDLeaf(p, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx) ((p)->lpVtbl->GetCPUIDLeaf(p, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx))
#define IPlatformX86_SetCPUIDLeaf(p, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx) ((p)->lpVtbl->SetCPUIDLeaf(p, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx))
#define IPlatformX86_RemoveCPUIDLeaf(p, aIdx, aIdxSub) ((p)->lpVtbl->RemoveCPUIDLeaf(p, aIdx, aIdxSub))
#define IPlatformX86_RemoveAllCPUIDLeaves(p) ((p)->lpVtbl->RemoveAllCPUIDLeaves(p))
#define IPlatformX86_GetHWVirtExProperty(p, aProperty, aValue) ((p)->lpVtbl->GetHWVirtExProperty(p, aProperty, aValue))
#define IPlatformX86_SetHWVirtExProperty(p, aProperty, aValue) ((p)->lpVtbl->SetHWVirtExProperty(p, aProperty, aValue))
#endif /* VBOX_WITH_GLUE */

interface IPlatformX86
{
#ifndef VBOX_WITH_GLUE
    struct IPlatformX86_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IPlatformX86Vtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IPlatformX86 declaration */


/* Start of struct IPlatformARM declaration */
#define IPLATFORMARM_IID_STR "75dff9be-6cb3-4857-bde6-2faf82ed9a8d"
#define IPLATFORMARM_IID { \
    0x75dff9be, 0x6cb3, 0x4857, \
    { 0xbd, 0xe6, 0x2f, 0xaf, 0x82, 0xed, 0x9a, 0x8d } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IPlatformARM);
#ifndef VBOX_WITH_GLUE
struct IPlatformARM_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IPlatformARM *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

    nsresult (*GetInternalAndReservedAttribute1IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod2IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod3IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod4IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod5IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod6IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod7IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod8IPlatformARM)(IPlatformARM *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IPlatformARMVtbl
{
    nsresult (*QueryInterface)(IPlatformARM *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IPlatformARM *pThis);
    nsrefcnt (*Release)(IPlatformARM *pThis);
    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IPlatformARM *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

    nsresult (*GetInternalAndReservedAttribute1IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IPlatformARM)(IPlatformARM *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod2IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod3IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod4IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod5IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod6IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod7IPlatformARM)(IPlatformARM *pThis);

    nsresult (*InternalAndReservedMethod8IPlatformARM)(IPlatformARM *pThis);

};
#define IPlatformARM_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IPlatformARM_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IPlatformARM_Release(p) ((p)->lpVtbl->Release(p))
#define IPlatformARM_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IPlatformARM_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IPlatformARM
{
#ifndef VBOX_WITH_GLUE
    struct IPlatformARM_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IPlatformARMVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IPlatformARM declaration */


/* Start of struct IMachine declaration */
#define IMACHINE_IID_STR "e36a5081-a82a-40bd-9e4e-42a44d6ce50f"
#define IMACHINE_IID { \
    0xe36a5081, 0xa82a, 0x40bd, \
    { 0x9e, 0x4e, 0x42, 0xa4, 0x4d, 0x6c, 0xe5, 0x0f } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IMachine);
#ifndef VBOX_WITH_GLUE
struct IMachine_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetParent)(IMachine *pThis, IVirtualBox * *parent);

    nsresult (*GetIcon)(IMachine *pThis, PRUint32 *iconSize, PRUint8 **icon);
    nsresult (*SetIcon)(IMachine *pThis, PRUint32 iconSize, PRUint8 *icon);

    nsresult (*GetAccessible)(IMachine *pThis, PRBool *accessible);

    nsresult (*GetAccessError)(IMachine *pThis, IVirtualBoxErrorInfo * *accessError);

    nsresult (*GetName)(IMachine *pThis, PRUnichar * *name);
    nsresult (*SetName)(IMachine *pThis, PRUnichar * name);

    nsresult (*GetDescription)(IMachine *pThis, PRUnichar * *description);
    nsresult (*SetDescription)(IMachine *pThis, PRUnichar * description);

    nsresult (*GetId)(IMachine *pThis, PRUnichar * *id);

    nsresult (*GetGroups)(IMachine *pThis, PRUint32 *groupsSize, PRUnichar * **groups);
    nsresult (*SetGroups)(IMachine *pThis, PRUint32 groupsSize, PRUnichar * *groups);

    nsresult (*GetOSTypeId)(IMachine *pThis, PRUnichar * *OSTypeId);
    nsresult (*SetOSTypeId)(IMachine *pThis, PRUnichar * OSTypeId);

    nsresult (*GetHardwareVersion)(IMachine *pThis, PRUnichar * *hardwareVersion);
    nsresult (*SetHardwareVersion)(IMachine *pThis, PRUnichar * hardwareVersion);

    nsresult (*GetHardwareUUID)(IMachine *pThis, PRUnichar * *hardwareUUID);
    nsresult (*SetHardwareUUID)(IMachine *pThis, PRUnichar * hardwareUUID);

    nsresult (*GetCPUCount)(IMachine *pThis, PRUint32 *CPUCount);
    nsresult (*SetCPUCount)(IMachine *pThis, PRUint32 CPUCount);

    nsresult (*GetCPUHotPlugEnabled)(IMachine *pThis, PRBool *CPUHotPlugEnabled);
    nsresult (*SetCPUHotPlugEnabled)(IMachine *pThis, PRBool CPUHotPlugEnabled);

    nsresult (*GetCPUExecutionCap)(IMachine *pThis, PRUint32 *CPUExecutionCap);
    nsresult (*SetCPUExecutionCap)(IMachine *pThis, PRUint32 CPUExecutionCap);

    nsresult (*GetCPUIDPortabilityLevel)(IMachine *pThis, PRUint32 *CPUIDPortabilityLevel);
    nsresult (*SetCPUIDPortabilityLevel)(IMachine *pThis, PRUint32 CPUIDPortabilityLevel);

    nsresult (*GetMemorySize)(IMachine *pThis, PRUint32 *memorySize);
    nsresult (*SetMemorySize)(IMachine *pThis, PRUint32 memorySize);

    nsresult (*GetMemoryBalloonSize)(IMachine *pThis, PRUint32 *memoryBalloonSize);
    nsresult (*SetMemoryBalloonSize)(IMachine *pThis, PRUint32 memoryBalloonSize);

    nsresult (*GetPageFusionEnabled)(IMachine *pThis, PRBool *pageFusionEnabled);
    nsresult (*SetPageFusionEnabled)(IMachine *pThis, PRBool pageFusionEnabled);

    nsresult (*GetGraphicsAdapter)(IMachine *pThis, IGraphicsAdapter * *graphicsAdapter);

    nsresult (*GetPlatform)(IMachine *pThis, IPlatform * *platform);

    nsresult (*GetFirmwareSettings)(IMachine *pThis, IFirmwareSettings * *firmwareSettings);

    nsresult (*GetTrustedPlatformModule)(IMachine *pThis, ITrustedPlatformModule * *trustedPlatformModule);

    nsresult (*GetNonVolatileStore)(IMachine *pThis, INvramStore * *nonVolatileStore);

    nsresult (*GetRecordingSettings)(IMachine *pThis, IRecordingSettings * *recordingSettings);

    nsresult (*GetPointingHIDType)(IMachine *pThis, PRUint32 *pointingHIDType);
    nsresult (*SetPointingHIDType)(IMachine *pThis, PRUint32 pointingHIDType);

    nsresult (*GetKeyboardHIDType)(IMachine *pThis, PRUint32 *keyboardHIDType);
    nsresult (*SetKeyboardHIDType)(IMachine *pThis, PRUint32 keyboardHIDType);

    nsresult (*GetSnapshotFolder)(IMachine *pThis, PRUnichar * *snapshotFolder);
    nsresult (*SetSnapshotFolder)(IMachine *pThis, PRUnichar * snapshotFolder);

    nsresult (*GetVRDEServer)(IMachine *pThis, IVRDEServer * *VRDEServer);

    nsresult (*GetEmulatedUSBCardReaderEnabled)(IMachine *pThis, PRBool *emulatedUSBCardReaderEnabled);
    nsresult (*SetEmulatedUSBCardReaderEnabled)(IMachine *pThis, PRBool emulatedUSBCardReaderEnabled);

    nsresult (*GetMediumAttachments)(IMachine *pThis, PRUint32 *mediumAttachmentsSize, IMediumAttachment * **mediumAttachments);

    nsresult (*GetUSBControllers)(IMachine *pThis, PRUint32 *USBControllersSize, IUSBController * **USBControllers);

    nsresult (*GetUSBDeviceFilters)(IMachine *pThis, IUSBDeviceFilters * *USBDeviceFilters);

    nsresult (*GetAudioSettings)(IMachine *pThis, IAudioSettings * *audioSettings);

    nsresult (*GetStorageControllers)(IMachine *pThis, PRUint32 *storageControllersSize, IStorageController * **storageControllers);

    nsresult (*GetSettingsFilePath)(IMachine *pThis, PRUnichar * *settingsFilePath);

    nsresult (*GetSettingsAuxFilePath)(IMachine *pThis, PRUnichar * *settingsAuxFilePath);

    nsresult (*GetSettingsModified)(IMachine *pThis, PRBool *settingsModified);

    nsresult (*GetSessionState)(IMachine *pThis, PRUint32 *sessionState);

    nsresult (*GetSessionName)(IMachine *pThis, PRUnichar * *sessionName);

    nsresult (*GetSessionPID)(IMachine *pThis, PRUint32 *sessionPID);

    nsresult (*GetState)(IMachine *pThis, PRUint32 *state);

    nsresult (*GetLastStateChange)(IMachine *pThis, PRInt64 *lastStateChange);

    nsresult (*GetStateFilePath)(IMachine *pThis, PRUnichar * *stateFilePath);

    nsresult (*GetLogFolder)(IMachine *pThis, PRUnichar * *logFolder);

    nsresult (*GetCurrentSnapshot)(IMachine *pThis, ISnapshot * *currentSnapshot);

    nsresult (*GetSnapshotCount)(IMachine *pThis, PRUint32 *snapshotCount);

    nsresult (*GetCurrentStateModified)(IMachine *pThis, PRBool *currentStateModified);

    nsresult (*GetSharedFolders)(IMachine *pThis, PRUint32 *sharedFoldersSize, ISharedFolder * **sharedFolders);

    nsresult (*GetClipboardMode)(IMachine *pThis, PRUint32 *clipboardMode);
    nsresult (*SetClipboardMode)(IMachine *pThis, PRUint32 clipboardMode);

    nsresult (*GetClipboardFileTransfersEnabled)(IMachine *pThis, PRBool *clipboardFileTransfersEnabled);
    nsresult (*SetClipboardFileTransfersEnabled)(IMachine *pThis, PRBool clipboardFileTransfersEnabled);

    nsresult (*GetDnDMode)(IMachine *pThis, PRUint32 *dnDMode);
    nsresult (*SetDnDMode)(IMachine *pThis, PRUint32 dnDMode);

    nsresult (*GetTeleporterEnabled)(IMachine *pThis, PRBool *teleporterEnabled);
    nsresult (*SetTeleporterEnabled)(IMachine *pThis, PRBool teleporterEnabled);

    nsresult (*GetTeleporterPort)(IMachine *pThis, PRUint32 *teleporterPort);
    nsresult (*SetTeleporterPort)(IMachine *pThis, PRUint32 teleporterPort);

    nsresult (*GetTeleporterAddress)(IMachine *pThis, PRUnichar * *teleporterAddress);
    nsresult (*SetTeleporterAddress)(IMachine *pThis, PRUnichar * teleporterAddress);

    nsresult (*GetTeleporterPassword)(IMachine *pThis, PRUnichar * *teleporterPassword);
    nsresult (*SetTeleporterPassword)(IMachine *pThis, PRUnichar * teleporterPassword);

    nsresult (*GetParavirtProvider)(IMachine *pThis, PRUint32 *paravirtProvider);
    nsresult (*SetParavirtProvider)(IMachine *pThis, PRUint32 paravirtProvider);

    nsresult (*GetIOCacheEnabled)(IMachine *pThis, PRBool *IOCacheEnabled);
    nsresult (*SetIOCacheEnabled)(IMachine *pThis, PRBool IOCacheEnabled);

    nsresult (*GetIOCacheSize)(IMachine *pThis, PRUint32 *IOCacheSize);
    nsresult (*SetIOCacheSize)(IMachine *pThis, PRUint32 IOCacheSize);

    nsresult (*GetPCIDeviceAssignments)(IMachine *pThis, PRUint32 *PCIDeviceAssignmentsSize, IPCIDeviceAttachment * **PCIDeviceAssignments);

    nsresult (*GetBandwidthControl)(IMachine *pThis, IBandwidthControl * *bandwidthControl);

    nsresult (*GetTracingEnabled)(IMachine *pThis, PRBool *tracingEnabled);
    nsresult (*SetTracingEnabled)(IMachine *pThis, PRBool tracingEnabled);

    nsresult (*GetTracingConfig)(IMachine *pThis, PRUnichar * *tracingConfig);
    nsresult (*SetTracingConfig)(IMachine *pThis, PRUnichar * tracingConfig);

    nsresult (*GetAllowTracingToAccessVM)(IMachine *pThis, PRBool *allowTracingToAccessVM);
    nsresult (*SetAllowTracingToAccessVM)(IMachine *pThis, PRBool allowTracingToAccessVM);

    nsresult (*GetAutostartEnabled)(IMachine *pThis, PRBool *autostartEnabled);
    nsresult (*SetAutostartEnabled)(IMachine *pThis, PRBool autostartEnabled);

    nsresult (*GetAutostartDelay)(IMachine *pThis, PRUint32 *autostartDelay);
    nsresult (*SetAutostartDelay)(IMachine *pThis, PRUint32 autostartDelay);

    nsresult (*GetAutostopType)(IMachine *pThis, PRUint32 *autostopType);
    nsresult (*SetAutostopType)(IMachine *pThis, PRUint32 autostopType);

    nsresult (*GetDefaultFrontend)(IMachine *pThis, PRUnichar * *defaultFrontend);
    nsresult (*SetDefaultFrontend)(IMachine *pThis, PRUnichar * defaultFrontend);

    nsresult (*GetUSBProxyAvailable)(IMachine *pThis, PRBool *USBProxyAvailable);

    nsresult (*GetVMProcessPriority)(IMachine *pThis, PRUint32 *VMProcessPriority);
    nsresult (*SetVMProcessPriority)(IMachine *pThis, PRUint32 VMProcessPriority);

    nsresult (*GetVMExecutionEngine)(IMachine *pThis, PRUint32 *VMExecutionEngine);
    nsresult (*SetVMExecutionEngine)(IMachine *pThis, PRUint32 VMExecutionEngine);

    nsresult (*GetParavirtDebug)(IMachine *pThis, PRUnichar * *paravirtDebug);
    nsresult (*SetParavirtDebug)(IMachine *pThis, PRUnichar * paravirtDebug);

    nsresult (*GetCPUProfile)(IMachine *pThis, PRUnichar * *CPUProfile);
    nsresult (*SetCPUProfile)(IMachine *pThis, PRUnichar * CPUProfile);

    nsresult (*GetStateKeyId)(IMachine *pThis, PRUnichar * *stateKeyId);

    nsresult (*GetStateKeyStore)(IMachine *pThis, PRUnichar * *stateKeyStore);

    nsresult (*GetLogKeyId)(IMachine *pThis, PRUnichar * *logKeyId);

    nsresult (*GetLogKeyStore)(IMachine *pThis, PRUnichar * *logKeyStore);

    nsresult (*GetGuestDebugControl)(IMachine *pThis, IGuestDebugControl * *guestDebugControl);

    nsresult (*GetInternalAndReservedAttribute1IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*LockMachine)(
        IMachine *pThis,
        ISession * session,
        PRUint32 lockType
    );

    nsresult (*LaunchVMProcess)(
        IMachine *pThis,
        ISession * session,
        PRUnichar * name,
        PRUint32 environmentChangesSize,
        PRUnichar ** environmentChanges,
        IProgress * * progress
    );

    nsresult (*SetBootOrder)(
        IMachine *pThis,
        PRUint32 position,
        PRUint32 device
    );

    nsresult (*GetBootOrder)(
        IMachine *pThis,
        PRUint32 position,
        PRUint32 * device
    );

    nsresult (*AttachDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRUint32 type,
        IMedium * medium
    );

    nsresult (*AttachDeviceWithoutMedium)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRUint32 type
    );

    nsresult (*DetachDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device
    );

    nsresult (*PassthroughDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool passthrough
    );

    nsresult (*TemporaryEjectDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool temporaryEject
    );

    nsresult (*NonRotationalDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool nonRotational
    );

    nsresult (*SetAutoDiscardForDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool discard
    );

    nsresult (*SetHotPluggableForDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool hotPluggable
    );

    nsresult (*SetBandwidthGroupForDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        IBandwidthGroup * bandwidthGroup
    );

    nsresult (*SetNoBandwidthGroupForDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device
    );

    nsresult (*UnmountMedium)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool force
    );

    nsresult (*MountMedium)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        IMedium * medium,
        PRBool force
    );

    nsresult (*GetMedium)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        IMedium * * medium
    );

    nsresult (*GetMediumAttachmentsOfController)(
        IMachine *pThis,
        PRUnichar * name,
        PRUint32 *mediumAttachmentsSize,
        IMediumAttachment *** mediumAttachments
    );

    nsresult (*GetMediumAttachment)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        IMediumAttachment * * attachment
    );

    nsresult (*AttachHostPCIDevice)(
        IMachine *pThis,
        PRInt32 hostAddress,
        PRInt32 desiredGuestAddress,
        PRBool tryToUnbind
    );

    nsresult (*DetachHostPCIDevice)(
        IMachine *pThis,
        PRInt32 hostAddress
    );

    nsresult (*GetNetworkAdapter)(
        IMachine *pThis,
        PRUint32 slot,
        INetworkAdapter * * adapter
    );

    nsresult (*AddStorageController)(
        IMachine *pThis,
        PRUnichar * name,
        PRUint32 connectionType,
        IStorageController * * controller
    );

    nsresult (*GetStorageControllerByName)(
        IMachine *pThis,
        PRUnichar * name,
        IStorageController * * storageController
    );

    nsresult (*GetStorageControllerByInstance)(
        IMachine *pThis,
        PRUint32 connectionType,
        PRUint32 instance,
        IStorageController * * storageController
    );

    nsresult (*RemoveStorageController)(
        IMachine *pThis,
        PRUnichar * name
    );

    nsresult (*SetStorageControllerBootable)(
        IMachine *pThis,
        PRUnichar * name,
        PRBool bootable
    );

    nsresult (*AddUSBController)(
        IMachine *pThis,
        PRUnichar * name,
        PRUint32 type,
        IUSBController * * controller
    );

    nsresult (*RemoveUSBController)(
        IMachine *pThis,
        PRUnichar * name
    );

    nsresult (*GetUSBControllerByName)(
        IMachine *pThis,
        PRUnichar * name,
        IUSBController * * controller
    );

    nsresult (*GetUSBControllerCountByType)(
        IMachine *pThis,
        PRUint32 type,
        PRUint32 * controllers
    );

    nsresult (*GetSerialPort)(
        IMachine *pThis,
        PRUint32 slot,
        ISerialPort * * port
    );

    nsresult (*GetParallelPort)(
        IMachine *pThis,
        PRUint32 slot,
        IParallelPort * * port
    );

    nsresult (*GetExtraDataKeys)(
        IMachine *pThis,
        PRUint32 *keysSize,
        PRUnichar *** keys
    );

    nsresult (*GetExtraData)(
        IMachine *pThis,
        PRUnichar * key,
        PRUnichar * * value
    );

    nsresult (*SetExtraData)(
        IMachine *pThis,
        PRUnichar * key,
        PRUnichar * value
    );

    nsresult (*SetSettingsFilePath)(
        IMachine *pThis,
        PRUnichar * settingsFilePath,
        IProgress * * progress
    );

    nsresult (*SaveSettings)(IMachine *pThis );

    nsresult (*DiscardSettings)(IMachine *pThis );

    nsresult (*Unregister)(
        IMachine *pThis,
        PRUint32 cleanupMode,
        PRUint32 *mediaSize,
        IMedium *** media
    );

    nsresult (*DeleteConfig)(
        IMachine *pThis,
        PRUint32 mediaSize,
        IMedium ** media,
        IProgress * * progress
    );

    nsresult (*ExportTo)(
        IMachine *pThis,
        IAppliance * appliance,
        PRUnichar * location,
        IVirtualSystemDescription * * description
    );

    nsresult (*FindSnapshot)(
        IMachine *pThis,
        PRUnichar * nameOrId,
        ISnapshot * * snapshot
    );

    nsresult (*CreateSharedFolder)(
        IMachine *pThis,
        PRUnichar * name,
        PRUnichar * hostPath,
        PRBool writable,
        PRBool automount,
        PRUnichar * autoMountPoint
    );

    nsresult (*RemoveSharedFolder)(
        IMachine *pThis,
        PRUnichar * name
    );

    nsresult (*CanShowConsoleWindow)(
        IMachine *pThis,
        PRBool * canShow
    );

    nsresult (*ShowConsoleWindow)(
        IMachine *pThis,
        PRInt64 * winId
    );

    nsresult (*GetGuestProperty)(
        IMachine *pThis,
        PRUnichar * name,
        PRUnichar * * value,
        PRInt64 * timestamp,
        PRUnichar * * flags
    );

    nsresult (*GetGuestPropertyValue)(
        IMachine *pThis,
        PRUnichar * property,
        PRUnichar * * value
    );

    nsresult (*GetGuestPropertyTimestamp)(
        IMachine *pThis,
        PRUnichar * property,
        PRInt64 * value
    );

    nsresult (*SetGuestProperty)(
        IMachine *pThis,
        PRUnichar * property,
        PRUnichar * value,
        PRUnichar * flags
    );

    nsresult (*SetGuestPropertyValue)(
        IMachine *pThis,
        PRUnichar * property,
        PRUnichar * value
    );

    nsresult (*DeleteGuestProperty)(
        IMachine *pThis,
        PRUnichar * name
    );

    nsresult (*EnumerateGuestProperties)(
        IMachine *pThis,
        PRUnichar * patterns,
        PRUint32 *namesSize,
        PRUnichar *** names,
        PRUint32 *valuesSize,
        PRUnichar *** values,
        PRUint32 *timestampsSize,
        PRInt64** timestamps,
        PRUint32 *flagsSize,
        PRUnichar *** flags
    );

    nsresult (*QuerySavedGuestScreenInfo)(
        IMachine *pThis,
        PRUint32 screenId,
        PRUint32 * originX,
        PRUint32 * originY,
        PRUint32 * width,
        PRUint32 * height,
        PRBool * enabled
    );

    nsresult (*ReadSavedThumbnailToArray)(
        IMachine *pThis,
        PRUint32 screenId,
        PRUint32 bitmapFormat,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*QuerySavedScreenshotInfo)(
        IMachine *pThis,
        PRUint32 screenId,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 *bitmapFormatsSize,
        PRUint32** bitmapFormats
    );

    nsresult (*ReadSavedScreenshotToArray)(
        IMachine *pThis,
        PRUint32 screenId,
        PRUint32 bitmapFormat,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*HotPlugCPU)(
        IMachine *pThis,
        PRUint32 cpu
    );

    nsresult (*HotUnplugCPU)(
        IMachine *pThis,
        PRUint32 cpu
    );

    nsresult (*GetCPUStatus)(
        IMachine *pThis,
        PRUint32 cpu,
        PRBool * attached
    );

    nsresult (*GetEffectiveParavirtProvider)(
        IMachine *pThis,
        PRUint32 * paravirtProvider
    );

    nsresult (*QueryLogFilename)(
        IMachine *pThis,
        PRUint32 idx,
        PRUnichar * * filename
    );

    nsresult (*ReadLog)(
        IMachine *pThis,
        PRUint32 idx,
        PRInt64 offset,
        PRInt64 size,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*CloneTo)(
        IMachine *pThis,
        IMachine * target,
        PRUint32 mode,
        PRUint32 optionsSize,
        PRUint32* options,
        IProgress * * progress
    );

    nsresult (*MoveTo)(
        IMachine *pThis,
        PRUnichar * folder,
        PRUnichar * type,
        IProgress * * progress
    );

    nsresult (*SaveState)(
        IMachine *pThis,
        IProgress * * progress
    );

    nsresult (*AdoptSavedState)(
        IMachine *pThis,
        PRUnichar * savedStateFile
    );

    nsresult (*DiscardSavedState)(
        IMachine *pThis,
        PRBool fRemoveFile
    );

    nsresult (*TakeSnapshot)(
        IMachine *pThis,
        PRUnichar * name,
        PRUnichar * description,
        PRBool pause,
        PRUnichar * * id,
        IProgress * * progress
    );

    nsresult (*DeleteSnapshot)(
        IMachine *pThis,
        PRUnichar * id,
        IProgress * * progress
    );

    nsresult (*DeleteSnapshotAndAllChildren)(
        IMachine *pThis,
        PRUnichar * id,
        IProgress * * progress
    );

    nsresult (*DeleteSnapshotRange)(
        IMachine *pThis,
        PRUnichar * startId,
        PRUnichar * endId,
        IProgress * * progress
    );

    nsresult (*RestoreSnapshot)(
        IMachine *pThis,
        ISnapshot * snapshot,
        IProgress * * progress
    );

    nsresult (*ApplyDefaults)(
        IMachine *pThis,
        PRUnichar * flags
    );

    nsresult (*ChangeEncryption)(
        IMachine *pThis,
        PRUnichar * currentPassword,
        PRUnichar * cipher,
        PRUnichar * newPassword,
        PRUnichar * newPasswordId,
        PRBool force,
        IProgress * * progress
    );

    nsresult (*GetEncryptionSettings)(
        IMachine *pThis,
        PRUnichar * * cipher,
        PRUnichar * * passwordId
    );

    nsresult (*CheckEncryptionPassword)(
        IMachine *pThis,
        PRUnichar * password
    );

    nsresult (*AddEncryptionPassword)(
        IMachine *pThis,
        PRUnichar * id,
        PRUnichar * password
    );

    nsresult (*AddEncryptionPasswords)(
        IMachine *pThis,
        PRUint32 idsSize,
        PRUnichar ** ids,
        PRUint32 passwordsSize,
        PRUnichar ** passwords
    );

    nsresult (*RemoveEncryptionPassword)(
        IMachine *pThis,
        PRUnichar * id
    );

    nsresult (*ClearAllEncryptionPasswords)(IMachine *pThis );

    nsresult (*InternalAndReservedMethod1IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod2IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod3IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod4IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod5IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod6IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod7IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod8IMachine)(IMachine *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IMachineVtbl
{
    nsresult (*QueryInterface)(IMachine *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IMachine *pThis);
    nsrefcnt (*Release)(IMachine *pThis);
    nsresult (*GetParent)(IMachine *pThis, IVirtualBox * *parent);

    nsresult (*GetIcon)(IMachine *pThis, PRUint32 *iconSize, PRUint8 **icon);
    nsresult (*SetIcon)(IMachine *pThis, PRUint32 iconSize, PRUint8 *icon);

    nsresult (*GetAccessible)(IMachine *pThis, PRBool *accessible);

    nsresult (*GetAccessError)(IMachine *pThis, IVirtualBoxErrorInfo * *accessError);

    nsresult (*GetName)(IMachine *pThis, PRUnichar * *name);
    nsresult (*SetName)(IMachine *pThis, PRUnichar * name);

    nsresult (*GetDescription)(IMachine *pThis, PRUnichar * *description);
    nsresult (*SetDescription)(IMachine *pThis, PRUnichar * description);

    nsresult (*GetId)(IMachine *pThis, PRUnichar * *id);

    nsresult (*GetGroups)(IMachine *pThis, PRUint32 *groupsSize, PRUnichar * **groups);
    nsresult (*SetGroups)(IMachine *pThis, PRUint32 groupsSize, PRUnichar * *groups);

    nsresult (*GetOSTypeId)(IMachine *pThis, PRUnichar * *OSTypeId);
    nsresult (*SetOSTypeId)(IMachine *pThis, PRUnichar * OSTypeId);

    nsresult (*GetHardwareVersion)(IMachine *pThis, PRUnichar * *hardwareVersion);
    nsresult (*SetHardwareVersion)(IMachine *pThis, PRUnichar * hardwareVersion);

    nsresult (*GetHardwareUUID)(IMachine *pThis, PRUnichar * *hardwareUUID);
    nsresult (*SetHardwareUUID)(IMachine *pThis, PRUnichar * hardwareUUID);

    nsresult (*GetCPUCount)(IMachine *pThis, PRUint32 *CPUCount);
    nsresult (*SetCPUCount)(IMachine *pThis, PRUint32 CPUCount);

    nsresult (*GetCPUHotPlugEnabled)(IMachine *pThis, PRBool *CPUHotPlugEnabled);
    nsresult (*SetCPUHotPlugEnabled)(IMachine *pThis, PRBool CPUHotPlugEnabled);

    nsresult (*GetCPUExecutionCap)(IMachine *pThis, PRUint32 *CPUExecutionCap);
    nsresult (*SetCPUExecutionCap)(IMachine *pThis, PRUint32 CPUExecutionCap);

    nsresult (*GetCPUIDPortabilityLevel)(IMachine *pThis, PRUint32 *CPUIDPortabilityLevel);
    nsresult (*SetCPUIDPortabilityLevel)(IMachine *pThis, PRUint32 CPUIDPortabilityLevel);

    nsresult (*GetMemorySize)(IMachine *pThis, PRUint32 *memorySize);
    nsresult (*SetMemorySize)(IMachine *pThis, PRUint32 memorySize);

    nsresult (*GetMemoryBalloonSize)(IMachine *pThis, PRUint32 *memoryBalloonSize);
    nsresult (*SetMemoryBalloonSize)(IMachine *pThis, PRUint32 memoryBalloonSize);

    nsresult (*GetPageFusionEnabled)(IMachine *pThis, PRBool *pageFusionEnabled);
    nsresult (*SetPageFusionEnabled)(IMachine *pThis, PRBool pageFusionEnabled);

    nsresult (*GetGraphicsAdapter)(IMachine *pThis, IGraphicsAdapter * *graphicsAdapter);

    nsresult (*GetPlatform)(IMachine *pThis, IPlatform * *platform);

    nsresult (*GetFirmwareSettings)(IMachine *pThis, IFirmwareSettings * *firmwareSettings);

    nsresult (*GetTrustedPlatformModule)(IMachine *pThis, ITrustedPlatformModule * *trustedPlatformModule);

    nsresult (*GetNonVolatileStore)(IMachine *pThis, INvramStore * *nonVolatileStore);

    nsresult (*GetRecordingSettings)(IMachine *pThis, IRecordingSettings * *recordingSettings);

    nsresult (*GetPointingHIDType)(IMachine *pThis, PRUint32 *pointingHIDType);
    nsresult (*SetPointingHIDType)(IMachine *pThis, PRUint32 pointingHIDType);

    nsresult (*GetKeyboardHIDType)(IMachine *pThis, PRUint32 *keyboardHIDType);
    nsresult (*SetKeyboardHIDType)(IMachine *pThis, PRUint32 keyboardHIDType);

    nsresult (*GetSnapshotFolder)(IMachine *pThis, PRUnichar * *snapshotFolder);
    nsresult (*SetSnapshotFolder)(IMachine *pThis, PRUnichar * snapshotFolder);

    nsresult (*GetVRDEServer)(IMachine *pThis, IVRDEServer * *VRDEServer);

    nsresult (*GetEmulatedUSBCardReaderEnabled)(IMachine *pThis, PRBool *emulatedUSBCardReaderEnabled);
    nsresult (*SetEmulatedUSBCardReaderEnabled)(IMachine *pThis, PRBool emulatedUSBCardReaderEnabled);

    nsresult (*GetMediumAttachments)(IMachine *pThis, PRUint32 *mediumAttachmentsSize, IMediumAttachment * **mediumAttachments);

    nsresult (*GetUSBControllers)(IMachine *pThis, PRUint32 *USBControllersSize, IUSBController * **USBControllers);

    nsresult (*GetUSBDeviceFilters)(IMachine *pThis, IUSBDeviceFilters * *USBDeviceFilters);

    nsresult (*GetAudioSettings)(IMachine *pThis, IAudioSettings * *audioSettings);

    nsresult (*GetStorageControllers)(IMachine *pThis, PRUint32 *storageControllersSize, IStorageController * **storageControllers);

    nsresult (*GetSettingsFilePath)(IMachine *pThis, PRUnichar * *settingsFilePath);

    nsresult (*GetSettingsAuxFilePath)(IMachine *pThis, PRUnichar * *settingsAuxFilePath);

    nsresult (*GetSettingsModified)(IMachine *pThis, PRBool *settingsModified);

    nsresult (*GetSessionState)(IMachine *pThis, PRUint32 *sessionState);

    nsresult (*GetSessionName)(IMachine *pThis, PRUnichar * *sessionName);

    nsresult (*GetSessionPID)(IMachine *pThis, PRUint32 *sessionPID);

    nsresult (*GetState)(IMachine *pThis, PRUint32 *state);

    nsresult (*GetLastStateChange)(IMachine *pThis, PRInt64 *lastStateChange);

    nsresult (*GetStateFilePath)(IMachine *pThis, PRUnichar * *stateFilePath);

    nsresult (*GetLogFolder)(IMachine *pThis, PRUnichar * *logFolder);

    nsresult (*GetCurrentSnapshot)(IMachine *pThis, ISnapshot * *currentSnapshot);

    nsresult (*GetSnapshotCount)(IMachine *pThis, PRUint32 *snapshotCount);

    nsresult (*GetCurrentStateModified)(IMachine *pThis, PRBool *currentStateModified);

    nsresult (*GetSharedFolders)(IMachine *pThis, PRUint32 *sharedFoldersSize, ISharedFolder * **sharedFolders);

    nsresult (*GetClipboardMode)(IMachine *pThis, PRUint32 *clipboardMode);
    nsresult (*SetClipboardMode)(IMachine *pThis, PRUint32 clipboardMode);

    nsresult (*GetClipboardFileTransfersEnabled)(IMachine *pThis, PRBool *clipboardFileTransfersEnabled);
    nsresult (*SetClipboardFileTransfersEnabled)(IMachine *pThis, PRBool clipboardFileTransfersEnabled);

    nsresult (*GetDnDMode)(IMachine *pThis, PRUint32 *dnDMode);
    nsresult (*SetDnDMode)(IMachine *pThis, PRUint32 dnDMode);

    nsresult (*GetTeleporterEnabled)(IMachine *pThis, PRBool *teleporterEnabled);
    nsresult (*SetTeleporterEnabled)(IMachine *pThis, PRBool teleporterEnabled);

    nsresult (*GetTeleporterPort)(IMachine *pThis, PRUint32 *teleporterPort);
    nsresult (*SetTeleporterPort)(IMachine *pThis, PRUint32 teleporterPort);

    nsresult (*GetTeleporterAddress)(IMachine *pThis, PRUnichar * *teleporterAddress);
    nsresult (*SetTeleporterAddress)(IMachine *pThis, PRUnichar * teleporterAddress);

    nsresult (*GetTeleporterPassword)(IMachine *pThis, PRUnichar * *teleporterPassword);
    nsresult (*SetTeleporterPassword)(IMachine *pThis, PRUnichar * teleporterPassword);

    nsresult (*GetParavirtProvider)(IMachine *pThis, PRUint32 *paravirtProvider);
    nsresult (*SetParavirtProvider)(IMachine *pThis, PRUint32 paravirtProvider);

    nsresult (*GetIOCacheEnabled)(IMachine *pThis, PRBool *IOCacheEnabled);
    nsresult (*SetIOCacheEnabled)(IMachine *pThis, PRBool IOCacheEnabled);

    nsresult (*GetIOCacheSize)(IMachine *pThis, PRUint32 *IOCacheSize);
    nsresult (*SetIOCacheSize)(IMachine *pThis, PRUint32 IOCacheSize);

    nsresult (*GetPCIDeviceAssignments)(IMachine *pThis, PRUint32 *PCIDeviceAssignmentsSize, IPCIDeviceAttachment * **PCIDeviceAssignments);

    nsresult (*GetBandwidthControl)(IMachine *pThis, IBandwidthControl * *bandwidthControl);

    nsresult (*GetTracingEnabled)(IMachine *pThis, PRBool *tracingEnabled);
    nsresult (*SetTracingEnabled)(IMachine *pThis, PRBool tracingEnabled);

    nsresult (*GetTracingConfig)(IMachine *pThis, PRUnichar * *tracingConfig);
    nsresult (*SetTracingConfig)(IMachine *pThis, PRUnichar * tracingConfig);

    nsresult (*GetAllowTracingToAccessVM)(IMachine *pThis, PRBool *allowTracingToAccessVM);
    nsresult (*SetAllowTracingToAccessVM)(IMachine *pThis, PRBool allowTracingToAccessVM);

    nsresult (*GetAutostartEnabled)(IMachine *pThis, PRBool *autostartEnabled);
    nsresult (*SetAutostartEnabled)(IMachine *pThis, PRBool autostartEnabled);

    nsresult (*GetAutostartDelay)(IMachine *pThis, PRUint32 *autostartDelay);
    nsresult (*SetAutostartDelay)(IMachine *pThis, PRUint32 autostartDelay);

    nsresult (*GetAutostopType)(IMachine *pThis, PRUint32 *autostopType);
    nsresult (*SetAutostopType)(IMachine *pThis, PRUint32 autostopType);

    nsresult (*GetDefaultFrontend)(IMachine *pThis, PRUnichar * *defaultFrontend);
    nsresult (*SetDefaultFrontend)(IMachine *pThis, PRUnichar * defaultFrontend);

    nsresult (*GetUSBProxyAvailable)(IMachine *pThis, PRBool *USBProxyAvailable);

    nsresult (*GetVMProcessPriority)(IMachine *pThis, PRUint32 *VMProcessPriority);
    nsresult (*SetVMProcessPriority)(IMachine *pThis, PRUint32 VMProcessPriority);

    nsresult (*GetVMExecutionEngine)(IMachine *pThis, PRUint32 *VMExecutionEngine);
    nsresult (*SetVMExecutionEngine)(IMachine *pThis, PRUint32 VMExecutionEngine);

    nsresult (*GetParavirtDebug)(IMachine *pThis, PRUnichar * *paravirtDebug);
    nsresult (*SetParavirtDebug)(IMachine *pThis, PRUnichar * paravirtDebug);

    nsresult (*GetCPUProfile)(IMachine *pThis, PRUnichar * *CPUProfile);
    nsresult (*SetCPUProfile)(IMachine *pThis, PRUnichar * CPUProfile);

    nsresult (*GetStateKeyId)(IMachine *pThis, PRUnichar * *stateKeyId);

    nsresult (*GetStateKeyStore)(IMachine *pThis, PRUnichar * *stateKeyStore);

    nsresult (*GetLogKeyId)(IMachine *pThis, PRUnichar * *logKeyId);

    nsresult (*GetLogKeyStore)(IMachine *pThis, PRUnichar * *logKeyStore);

    nsresult (*GetGuestDebugControl)(IMachine *pThis, IGuestDebugControl * *guestDebugControl);

    nsresult (*GetInternalAndReservedAttribute1IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IMachine)(IMachine *pThis, PRUint32 *reserved);

    nsresult (*LockMachine)(
        IMachine *pThis,
        ISession * session,
        PRUint32 lockType
    );

    nsresult (*LaunchVMProcess)(
        IMachine *pThis,
        ISession * session,
        PRUnichar * name,
        PRUint32 environmentChangesSize,
        PRUnichar ** environmentChanges,
        IProgress * * progress
    );

    nsresult (*SetBootOrder)(
        IMachine *pThis,
        PRUint32 position,
        PRUint32 device
    );

    nsresult (*GetBootOrder)(
        IMachine *pThis,
        PRUint32 position,
        PRUint32 * device
    );

    nsresult (*AttachDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRUint32 type,
        IMedium * medium
    );

    nsresult (*AttachDeviceWithoutMedium)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRUint32 type
    );

    nsresult (*DetachDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device
    );

    nsresult (*PassthroughDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool passthrough
    );

    nsresult (*TemporaryEjectDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool temporaryEject
    );

    nsresult (*NonRotationalDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool nonRotational
    );

    nsresult (*SetAutoDiscardForDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool discard
    );

    nsresult (*SetHotPluggableForDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool hotPluggable
    );

    nsresult (*SetBandwidthGroupForDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        IBandwidthGroup * bandwidthGroup
    );

    nsresult (*SetNoBandwidthGroupForDevice)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device
    );

    nsresult (*UnmountMedium)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        PRBool force
    );

    nsresult (*MountMedium)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        IMedium * medium,
        PRBool force
    );

    nsresult (*GetMedium)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        IMedium * * medium
    );

    nsresult (*GetMediumAttachmentsOfController)(
        IMachine *pThis,
        PRUnichar * name,
        PRUint32 *mediumAttachmentsSize,
        IMediumAttachment *** mediumAttachments
    );

    nsresult (*GetMediumAttachment)(
        IMachine *pThis,
        PRUnichar * name,
        PRInt32 controllerPort,
        PRInt32 device,
        IMediumAttachment * * attachment
    );

    nsresult (*AttachHostPCIDevice)(
        IMachine *pThis,
        PRInt32 hostAddress,
        PRInt32 desiredGuestAddress,
        PRBool tryToUnbind
    );

    nsresult (*DetachHostPCIDevice)(
        IMachine *pThis,
        PRInt32 hostAddress
    );

    nsresult (*GetNetworkAdapter)(
        IMachine *pThis,
        PRUint32 slot,
        INetworkAdapter * * adapter
    );

    nsresult (*AddStorageController)(
        IMachine *pThis,
        PRUnichar * name,
        PRUint32 connectionType,
        IStorageController * * controller
    );

    nsresult (*GetStorageControllerByName)(
        IMachine *pThis,
        PRUnichar * name,
        IStorageController * * storageController
    );

    nsresult (*GetStorageControllerByInstance)(
        IMachine *pThis,
        PRUint32 connectionType,
        PRUint32 instance,
        IStorageController * * storageController
    );

    nsresult (*RemoveStorageController)(
        IMachine *pThis,
        PRUnichar * name
    );

    nsresult (*SetStorageControllerBootable)(
        IMachine *pThis,
        PRUnichar * name,
        PRBool bootable
    );

    nsresult (*AddUSBController)(
        IMachine *pThis,
        PRUnichar * name,
        PRUint32 type,
        IUSBController * * controller
    );

    nsresult (*RemoveUSBController)(
        IMachine *pThis,
        PRUnichar * name
    );

    nsresult (*GetUSBControllerByName)(
        IMachine *pThis,
        PRUnichar * name,
        IUSBController * * controller
    );

    nsresult (*GetUSBControllerCountByType)(
        IMachine *pThis,
        PRUint32 type,
        PRUint32 * controllers
    );

    nsresult (*GetSerialPort)(
        IMachine *pThis,
        PRUint32 slot,
        ISerialPort * * port
    );

    nsresult (*GetParallelPort)(
        IMachine *pThis,
        PRUint32 slot,
        IParallelPort * * port
    );

    nsresult (*GetExtraDataKeys)(
        IMachine *pThis,
        PRUint32 *keysSize,
        PRUnichar *** keys
    );

    nsresult (*GetExtraData)(
        IMachine *pThis,
        PRUnichar * key,
        PRUnichar * * value
    );

    nsresult (*SetExtraData)(
        IMachine *pThis,
        PRUnichar * key,
        PRUnichar * value
    );

    nsresult (*SetSettingsFilePath)(
        IMachine *pThis,
        PRUnichar * settingsFilePath,
        IProgress * * progress
    );

    nsresult (*SaveSettings)(IMachine *pThis );

    nsresult (*DiscardSettings)(IMachine *pThis );

    nsresult (*Unregister)(
        IMachine *pThis,
        PRUint32 cleanupMode,
        PRUint32 *mediaSize,
        IMedium *** media
    );

    nsresult (*DeleteConfig)(
        IMachine *pThis,
        PRUint32 mediaSize,
        IMedium ** media,
        IProgress * * progress
    );

    nsresult (*ExportTo)(
        IMachine *pThis,
        IAppliance * appliance,
        PRUnichar * location,
        IVirtualSystemDescription * * description
    );

    nsresult (*FindSnapshot)(
        IMachine *pThis,
        PRUnichar * nameOrId,
        ISnapshot * * snapshot
    );

    nsresult (*CreateSharedFolder)(
        IMachine *pThis,
        PRUnichar * name,
        PRUnichar * hostPath,
        PRBool writable,
        PRBool automount,
        PRUnichar * autoMountPoint
    );

    nsresult (*RemoveSharedFolder)(
        IMachine *pThis,
        PRUnichar * name
    );

    nsresult (*CanShowConsoleWindow)(
        IMachine *pThis,
        PRBool * canShow
    );

    nsresult (*ShowConsoleWindow)(
        IMachine *pThis,
        PRInt64 * winId
    );

    nsresult (*GetGuestProperty)(
        IMachine *pThis,
        PRUnichar * name,
        PRUnichar * * value,
        PRInt64 * timestamp,
        PRUnichar * * flags
    );

    nsresult (*GetGuestPropertyValue)(
        IMachine *pThis,
        PRUnichar * property,
        PRUnichar * * value
    );

    nsresult (*GetGuestPropertyTimestamp)(
        IMachine *pThis,
        PRUnichar * property,
        PRInt64 * value
    );

    nsresult (*SetGuestProperty)(
        IMachine *pThis,
        PRUnichar * property,
        PRUnichar * value,
        PRUnichar * flags
    );

    nsresult (*SetGuestPropertyValue)(
        IMachine *pThis,
        PRUnichar * property,
        PRUnichar * value
    );

    nsresult (*DeleteGuestProperty)(
        IMachine *pThis,
        PRUnichar * name
    );

    nsresult (*EnumerateGuestProperties)(
        IMachine *pThis,
        PRUnichar * patterns,
        PRUint32 *namesSize,
        PRUnichar *** names,
        PRUint32 *valuesSize,
        PRUnichar *** values,
        PRUint32 *timestampsSize,
        PRInt64** timestamps,
        PRUint32 *flagsSize,
        PRUnichar *** flags
    );

    nsresult (*QuerySavedGuestScreenInfo)(
        IMachine *pThis,
        PRUint32 screenId,
        PRUint32 * originX,
        PRUint32 * originY,
        PRUint32 * width,
        PRUint32 * height,
        PRBool * enabled
    );

    nsresult (*ReadSavedThumbnailToArray)(
        IMachine *pThis,
        PRUint32 screenId,
        PRUint32 bitmapFormat,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*QuerySavedScreenshotInfo)(
        IMachine *pThis,
        PRUint32 screenId,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 *bitmapFormatsSize,
        PRUint32** bitmapFormats
    );

    nsresult (*ReadSavedScreenshotToArray)(
        IMachine *pThis,
        PRUint32 screenId,
        PRUint32 bitmapFormat,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*HotPlugCPU)(
        IMachine *pThis,
        PRUint32 cpu
    );

    nsresult (*HotUnplugCPU)(
        IMachine *pThis,
        PRUint32 cpu
    );

    nsresult (*GetCPUStatus)(
        IMachine *pThis,
        PRUint32 cpu,
        PRBool * attached
    );

    nsresult (*GetEffectiveParavirtProvider)(
        IMachine *pThis,
        PRUint32 * paravirtProvider
    );

    nsresult (*QueryLogFilename)(
        IMachine *pThis,
        PRUint32 idx,
        PRUnichar * * filename
    );

    nsresult (*ReadLog)(
        IMachine *pThis,
        PRUint32 idx,
        PRInt64 offset,
        PRInt64 size,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*CloneTo)(
        IMachine *pThis,
        IMachine * target,
        PRUint32 mode,
        PRUint32 optionsSize,
        PRUint32* options,
        IProgress * * progress
    );

    nsresult (*MoveTo)(
        IMachine *pThis,
        PRUnichar * folder,
        PRUnichar * type,
        IProgress * * progress
    );

    nsresult (*SaveState)(
        IMachine *pThis,
        IProgress * * progress
    );

    nsresult (*AdoptSavedState)(
        IMachine *pThis,
        PRUnichar * savedStateFile
    );

    nsresult (*DiscardSavedState)(
        IMachine *pThis,
        PRBool fRemoveFile
    );

    nsresult (*TakeSnapshot)(
        IMachine *pThis,
        PRUnichar * name,
        PRUnichar * description,
        PRBool pause,
        PRUnichar * * id,
        IProgress * * progress
    );

    nsresult (*DeleteSnapshot)(
        IMachine *pThis,
        PRUnichar * id,
        IProgress * * progress
    );

    nsresult (*DeleteSnapshotAndAllChildren)(
        IMachine *pThis,
        PRUnichar * id,
        IProgress * * progress
    );

    nsresult (*DeleteSnapshotRange)(
        IMachine *pThis,
        PRUnichar * startId,
        PRUnichar * endId,
        IProgress * * progress
    );

    nsresult (*RestoreSnapshot)(
        IMachine *pThis,
        ISnapshot * snapshot,
        IProgress * * progress
    );

    nsresult (*ApplyDefaults)(
        IMachine *pThis,
        PRUnichar * flags
    );

    nsresult (*ChangeEncryption)(
        IMachine *pThis,
        PRUnichar * currentPassword,
        PRUnichar * cipher,
        PRUnichar * newPassword,
        PRUnichar * newPasswordId,
        PRBool force,
        IProgress * * progress
    );

    nsresult (*GetEncryptionSettings)(
        IMachine *pThis,
        PRUnichar * * cipher,
        PRUnichar * * passwordId
    );

    nsresult (*CheckEncryptionPassword)(
        IMachine *pThis,
        PRUnichar * password
    );

    nsresult (*AddEncryptionPassword)(
        IMachine *pThis,
        PRUnichar * id,
        PRUnichar * password
    );

    nsresult (*AddEncryptionPasswords)(
        IMachine *pThis,
        PRUint32 idsSize,
        PRUnichar ** ids,
        PRUint32 passwordsSize,
        PRUnichar ** passwords
    );

    nsresult (*RemoveEncryptionPassword)(
        IMachine *pThis,
        PRUnichar * id
    );

    nsresult (*ClearAllEncryptionPasswords)(IMachine *pThis );

    nsresult (*InternalAndReservedMethod1IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod2IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod3IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod4IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod5IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod6IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod7IMachine)(IMachine *pThis);

    nsresult (*InternalAndReservedMethod8IMachine)(IMachine *pThis);

};
#define IMachine_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IMachine_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IMachine_Release(p) ((p)->lpVtbl->Release(p))
#define IMachine_get_Parent(p, aParent) ((p)->lpVtbl->GetParent(p, aParent))
#define IMachine_GetParent(p, aParent) ((p)->lpVtbl->GetParent(p, aParent))
#define IMachine_get_Icon(p, aIcon) ((p)->lpVtbl->GetIcon(p, aIcon))
#define IMachine_GetIcon(p, aIcon) ((p)->lpVtbl->GetIcon(p, aIcon))
#define IMachine_put_Icon(p, aIcon) ((p)->lpVtbl->SetIcon(p, aIcon))
#define IMachine_SetIcon(p, aIcon) ((p)->lpVtbl->SetIcon(p, aIcon))
#define IMachine_get_Accessible(p, aAccessible) ((p)->lpVtbl->GetAccessible(p, aAccessible))
#define IMachine_GetAccessible(p, aAccessible) ((p)->lpVtbl->GetAccessible(p, aAccessible))
#define IMachine_get_AccessError(p, aAccessError) ((p)->lpVtbl->GetAccessError(p, aAccessError))
#define IMachine_GetAccessError(p, aAccessError) ((p)->lpVtbl->GetAccessError(p, aAccessError))
#define IMachine_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IMachine_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IMachine_put_Name(p, aName) ((p)->lpVtbl->SetName(p, aName))
#define IMachine_SetName(p, aName) ((p)->lpVtbl->SetName(p, aName))
#define IMachine_get_Description(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define IMachine_GetDescription(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define IMachine_put_Description(p, aDescription) ((p)->lpVtbl->SetDescription(p, aDescription))
#define IMachine_SetDescription(p, aDescription) ((p)->lpVtbl->SetDescription(p, aDescription))
#define IMachine_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IMachine_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IMachine_get_Groups(p, aGroups) ((p)->lpVtbl->GetGroups(p, aGroups))
#define IMachine_GetGroups(p, aGroups) ((p)->lpVtbl->GetGroups(p, aGroups))
#define IMachine_put_Groups(p, aGroups) ((p)->lpVtbl->SetGroups(p, aGroups))
#define IMachine_SetGroups(p, aGroups) ((p)->lpVtbl->SetGroups(p, aGroups))
#define IMachine_get_OSTypeId(p, aOSTypeId) ((p)->lpVtbl->GetOSTypeId(p, aOSTypeId))
#define IMachine_GetOSTypeId(p, aOSTypeId) ((p)->lpVtbl->GetOSTypeId(p, aOSTypeId))
#define IMachine_put_OSTypeId(p, aOSTypeId) ((p)->lpVtbl->SetOSTypeId(p, aOSTypeId))
#define IMachine_SetOSTypeId(p, aOSTypeId) ((p)->lpVtbl->SetOSTypeId(p, aOSTypeId))
#define IMachine_get_HardwareVersion(p, aHardwareVersion) ((p)->lpVtbl->GetHardwareVersion(p, aHardwareVersion))
#define IMachine_GetHardwareVersion(p, aHardwareVersion) ((p)->lpVtbl->GetHardwareVersion(p, aHardwareVersion))
#define IMachine_put_HardwareVersion(p, aHardwareVersion) ((p)->lpVtbl->SetHardwareVersion(p, aHardwareVersion))
#define IMachine_SetHardwareVersion(p, aHardwareVersion) ((p)->lpVtbl->SetHardwareVersion(p, aHardwareVersion))
#define IMachine_get_HardwareUUID(p, aHardwareUUID) ((p)->lpVtbl->GetHardwareUUID(p, aHardwareUUID))
#define IMachine_GetHardwareUUID(p, aHardwareUUID) ((p)->lpVtbl->GetHardwareUUID(p, aHardwareUUID))
#define IMachine_put_HardwareUUID(p, aHardwareUUID) ((p)->lpVtbl->SetHardwareUUID(p, aHardwareUUID))
#define IMachine_SetHardwareUUID(p, aHardwareUUID) ((p)->lpVtbl->SetHardwareUUID(p, aHardwareUUID))
#define IMachine_get_CPUCount(p, aCPUCount) ((p)->lpVtbl->GetCPUCount(p, aCPUCount))
#define IMachine_GetCPUCount(p, aCPUCount) ((p)->lpVtbl->GetCPUCount(p, aCPUCount))
#define IMachine_put_CPUCount(p, aCPUCount) ((p)->lpVtbl->SetCPUCount(p, aCPUCount))
#define IMachine_SetCPUCount(p, aCPUCount) ((p)->lpVtbl->SetCPUCount(p, aCPUCount))
#define IMachine_get_CPUHotPlugEnabled(p, aCPUHotPlugEnabled) ((p)->lpVtbl->GetCPUHotPlugEnabled(p, aCPUHotPlugEnabled))
#define IMachine_GetCPUHotPlugEnabled(p, aCPUHotPlugEnabled) ((p)->lpVtbl->GetCPUHotPlugEnabled(p, aCPUHotPlugEnabled))
#define IMachine_put_CPUHotPlugEnabled(p, aCPUHotPlugEnabled) ((p)->lpVtbl->SetCPUHotPlugEnabled(p, aCPUHotPlugEnabled))
#define IMachine_SetCPUHotPlugEnabled(p, aCPUHotPlugEnabled) ((p)->lpVtbl->SetCPUHotPlugEnabled(p, aCPUHotPlugEnabled))
#define IMachine_get_CPUExecutionCap(p, aCPUExecutionCap) ((p)->lpVtbl->GetCPUExecutionCap(p, aCPUExecutionCap))
#define IMachine_GetCPUExecutionCap(p, aCPUExecutionCap) ((p)->lpVtbl->GetCPUExecutionCap(p, aCPUExecutionCap))
#define IMachine_put_CPUExecutionCap(p, aCPUExecutionCap) ((p)->lpVtbl->SetCPUExecutionCap(p, aCPUExecutionCap))
#define IMachine_SetCPUExecutionCap(p, aCPUExecutionCap) ((p)->lpVtbl->SetCPUExecutionCap(p, aCPUExecutionCap))
#define IMachine_get_CPUIDPortabilityLevel(p, aCPUIDPortabilityLevel) ((p)->lpVtbl->GetCPUIDPortabilityLevel(p, aCPUIDPortabilityLevel))
#define IMachine_GetCPUIDPortabilityLevel(p, aCPUIDPortabilityLevel) ((p)->lpVtbl->GetCPUIDPortabilityLevel(p, aCPUIDPortabilityLevel))
#define IMachine_put_CPUIDPortabilityLevel(p, aCPUIDPortabilityLevel) ((p)->lpVtbl->SetCPUIDPortabilityLevel(p, aCPUIDPortabilityLevel))
#define IMachine_SetCPUIDPortabilityLevel(p, aCPUIDPortabilityLevel) ((p)->lpVtbl->SetCPUIDPortabilityLevel(p, aCPUIDPortabilityLevel))
#define IMachine_get_MemorySize(p, aMemorySize) ((p)->lpVtbl->GetMemorySize(p, aMemorySize))
#define IMachine_GetMemorySize(p, aMemorySize) ((p)->lpVtbl->GetMemorySize(p, aMemorySize))
#define IMachine_put_MemorySize(p, aMemorySize) ((p)->lpVtbl->SetMemorySize(p, aMemorySize))
#define IMachine_SetMemorySize(p, aMemorySize) ((p)->lpVtbl->SetMemorySize(p, aMemorySize))
#define IMachine_get_MemoryBalloonSize(p, aMemoryBalloonSize) ((p)->lpVtbl->GetMemoryBalloonSize(p, aMemoryBalloonSize))
#define IMachine_GetMemoryBalloonSize(p, aMemoryBalloonSize) ((p)->lpVtbl->GetMemoryBalloonSize(p, aMemoryBalloonSize))
#define IMachine_put_MemoryBalloonSize(p, aMemoryBalloonSize) ((p)->lpVtbl->SetMemoryBalloonSize(p, aMemoryBalloonSize))
#define IMachine_SetMemoryBalloonSize(p, aMemoryBalloonSize) ((p)->lpVtbl->SetMemoryBalloonSize(p, aMemoryBalloonSize))
#define IMachine_get_PageFusionEnabled(p, aPageFusionEnabled) ((p)->lpVtbl->GetPageFusionEnabled(p, aPageFusionEnabled))
#define IMachine_GetPageFusionEnabled(p, aPageFusionEnabled) ((p)->lpVtbl->GetPageFusionEnabled(p, aPageFusionEnabled))
#define IMachine_put_PageFusionEnabled(p, aPageFusionEnabled) ((p)->lpVtbl->SetPageFusionEnabled(p, aPageFusionEnabled))
#define IMachine_SetPageFusionEnabled(p, aPageFusionEnabled) ((p)->lpVtbl->SetPageFusionEnabled(p, aPageFusionEnabled))
#define IMachine_get_GraphicsAdapter(p, aGraphicsAdapter) ((p)->lpVtbl->GetGraphicsAdapter(p, aGraphicsAdapter))
#define IMachine_GetGraphicsAdapter(p, aGraphicsAdapter) ((p)->lpVtbl->GetGraphicsAdapter(p, aGraphicsAdapter))
#define IMachine_get_Platform(p, aPlatform) ((p)->lpVtbl->GetPlatform(p, aPlatform))
#define IMachine_GetPlatform(p, aPlatform) ((p)->lpVtbl->GetPlatform(p, aPlatform))
#define IMachine_get_FirmwareSettings(p, aFirmwareSettings) ((p)->lpVtbl->GetFirmwareSettings(p, aFirmwareSettings))
#define IMachine_GetFirmwareSettings(p, aFirmwareSettings) ((p)->lpVtbl->GetFirmwareSettings(p, aFirmwareSettings))
#define IMachine_get_TrustedPlatformModule(p, aTrustedPlatformModule) ((p)->lpVtbl->GetTrustedPlatformModule(p, aTrustedPlatformModule))
#define IMachine_GetTrustedPlatformModule(p, aTrustedPlatformModule) ((p)->lpVtbl->GetTrustedPlatformModule(p, aTrustedPlatformModule))
#define IMachine_get_NonVolatileStore(p, aNonVolatileStore) ((p)->lpVtbl->GetNonVolatileStore(p, aNonVolatileStore))
#define IMachine_GetNonVolatileStore(p, aNonVolatileStore) ((p)->lpVtbl->GetNonVolatileStore(p, aNonVolatileStore))
#define IMachine_get_RecordingSettings(p, aRecordingSettings) ((p)->lpVtbl->GetRecordingSettings(p, aRecordingSettings))
#define IMachine_GetRecordingSettings(p, aRecordingSettings) ((p)->lpVtbl->GetRecordingSettings(p, aRecordingSettings))
#define IMachine_get_PointingHIDType(p, aPointingHIDType) ((p)->lpVtbl->GetPointingHIDType(p, aPointingHIDType))
#define IMachine_GetPointingHIDType(p, aPointingHIDType) ((p)->lpVtbl->GetPointingHIDType(p, aPointingHIDType))
#define IMachine_put_PointingHIDType(p, aPointingHIDType) ((p)->lpVtbl->SetPointingHIDType(p, aPointingHIDType))
#define IMachine_SetPointingHIDType(p, aPointingHIDType) ((p)->lpVtbl->SetPointingHIDType(p, aPointingHIDType))
#define IMachine_get_KeyboardHIDType(p, aKeyboardHIDType) ((p)->lpVtbl->GetKeyboardHIDType(p, aKeyboardHIDType))
#define IMachine_GetKeyboardHIDType(p, aKeyboardHIDType) ((p)->lpVtbl->GetKeyboardHIDType(p, aKeyboardHIDType))
#define IMachine_put_KeyboardHIDType(p, aKeyboardHIDType) ((p)->lpVtbl->SetKeyboardHIDType(p, aKeyboardHIDType))
#define IMachine_SetKeyboardHIDType(p, aKeyboardHIDType) ((p)->lpVtbl->SetKeyboardHIDType(p, aKeyboardHIDType))
#define IMachine_get_SnapshotFolder(p, aSnapshotFolder) ((p)->lpVtbl->GetSnapshotFolder(p, aSnapshotFolder))
#define IMachine_GetSnapshotFolder(p, aSnapshotFolder) ((p)->lpVtbl->GetSnapshotFolder(p, aSnapshotFolder))
#define IMachine_put_SnapshotFolder(p, aSnapshotFolder) ((p)->lpVtbl->SetSnapshotFolder(p, aSnapshotFolder))
#define IMachine_SetSnapshotFolder(p, aSnapshotFolder) ((p)->lpVtbl->SetSnapshotFolder(p, aSnapshotFolder))
#define IMachine_get_VRDEServer(p, aVRDEServer) ((p)->lpVtbl->GetVRDEServer(p, aVRDEServer))
#define IMachine_GetVRDEServer(p, aVRDEServer) ((p)->lpVtbl->GetVRDEServer(p, aVRDEServer))
#define IMachine_get_EmulatedUSBCardReaderEnabled(p, aEmulatedUSBCardReaderEnabled) ((p)->lpVtbl->GetEmulatedUSBCardReaderEnabled(p, aEmulatedUSBCardReaderEnabled))
#define IMachine_GetEmulatedUSBCardReaderEnabled(p, aEmulatedUSBCardReaderEnabled) ((p)->lpVtbl->GetEmulatedUSBCardReaderEnabled(p, aEmulatedUSBCardReaderEnabled))
#define IMachine_put_EmulatedUSBCardReaderEnabled(p, aEmulatedUSBCardReaderEnabled) ((p)->lpVtbl->SetEmulatedUSBCardReaderEnabled(p, aEmulatedUSBCardReaderEnabled))
#define IMachine_SetEmulatedUSBCardReaderEnabled(p, aEmulatedUSBCardReaderEnabled) ((p)->lpVtbl->SetEmulatedUSBCardReaderEnabled(p, aEmulatedUSBCardReaderEnabled))
#define IMachine_get_MediumAttachments(p, aMediumAttachments) ((p)->lpVtbl->GetMediumAttachments(p, aMediumAttachments))
#define IMachine_GetMediumAttachments(p, aMediumAttachments) ((p)->lpVtbl->GetMediumAttachments(p, aMediumAttachments))
#define IMachine_get_USBControllers(p, aUSBControllers) ((p)->lpVtbl->GetUSBControllers(p, aUSBControllers))
#define IMachine_GetUSBControllers(p, aUSBControllers) ((p)->lpVtbl->GetUSBControllers(p, aUSBControllers))
#define IMachine_get_USBDeviceFilters(p, aUSBDeviceFilters) ((p)->lpVtbl->GetUSBDeviceFilters(p, aUSBDeviceFilters))
#define IMachine_GetUSBDeviceFilters(p, aUSBDeviceFilters) ((p)->lpVtbl->GetUSBDeviceFilters(p, aUSBDeviceFilters))
#define IMachine_get_AudioSettings(p, aAudioSettings) ((p)->lpVtbl->GetAudioSettings(p, aAudioSettings))
#define IMachine_GetAudioSettings(p, aAudioSettings) ((p)->lpVtbl->GetAudioSettings(p, aAudioSettings))
#define IMachine_get_StorageControllers(p, aStorageControllers) ((p)->lpVtbl->GetStorageControllers(p, aStorageControllers))
#define IMachine_GetStorageControllers(p, aStorageControllers) ((p)->lpVtbl->GetStorageControllers(p, aStorageControllers))
#define IMachine_get_SettingsFilePath(p, aSettingsFilePath) ((p)->lpVtbl->GetSettingsFilePath(p, aSettingsFilePath))
#define IMachine_GetSettingsFilePath(p, aSettingsFilePath) ((p)->lpVtbl->GetSettingsFilePath(p, aSettingsFilePath))
#define IMachine_get_SettingsAuxFilePath(p, aSettingsAuxFilePath) ((p)->lpVtbl->GetSettingsAuxFilePath(p, aSettingsAuxFilePath))
#define IMachine_GetSettingsAuxFilePath(p, aSettingsAuxFilePath) ((p)->lpVtbl->GetSettingsAuxFilePath(p, aSettingsAuxFilePath))
#define IMachine_get_SettingsModified(p, aSettingsModified) ((p)->lpVtbl->GetSettingsModified(p, aSettingsModified))
#define IMachine_GetSettingsModified(p, aSettingsModified) ((p)->lpVtbl->GetSettingsModified(p, aSettingsModified))
#define IMachine_get_SessionState(p, aSessionState) ((p)->lpVtbl->GetSessionState(p, aSessionState))
#define IMachine_GetSessionState(p, aSessionState) ((p)->lpVtbl->GetSessionState(p, aSessionState))
#define IMachine_get_SessionName(p, aSessionName) ((p)->lpVtbl->GetSessionName(p, aSessionName))
#define IMachine_GetSessionName(p, aSessionName) ((p)->lpVtbl->GetSessionName(p, aSessionName))
#define IMachine_get_SessionPID(p, aSessionPID) ((p)->lpVtbl->GetSessionPID(p, aSessionPID))
#define IMachine_GetSessionPID(p, aSessionPID) ((p)->lpVtbl->GetSessionPID(p, aSessionPID))
#define IMachine_get_State(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IMachine_GetState(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IMachine_get_LastStateChange(p, aLastStateChange) ((p)->lpVtbl->GetLastStateChange(p, aLastStateChange))
#define IMachine_GetLastStateChange(p, aLastStateChange) ((p)->lpVtbl->GetLastStateChange(p, aLastStateChange))
#define IMachine_get_StateFilePath(p, aStateFilePath) ((p)->lpVtbl->GetStateFilePath(p, aStateFilePath))
#define IMachine_GetStateFilePath(p, aStateFilePath) ((p)->lpVtbl->GetStateFilePath(p, aStateFilePath))
#define IMachine_get_LogFolder(p, aLogFolder) ((p)->lpVtbl->GetLogFolder(p, aLogFolder))
#define IMachine_GetLogFolder(p, aLogFolder) ((p)->lpVtbl->GetLogFolder(p, aLogFolder))
#define IMachine_get_CurrentSnapshot(p, aCurrentSnapshot) ((p)->lpVtbl->GetCurrentSnapshot(p, aCurrentSnapshot))
#define IMachine_GetCurrentSnapshot(p, aCurrentSnapshot) ((p)->lpVtbl->GetCurrentSnapshot(p, aCurrentSnapshot))
#define IMachine_get_SnapshotCount(p, aSnapshotCount) ((p)->lpVtbl->GetSnapshotCount(p, aSnapshotCount))
#define IMachine_GetSnapshotCount(p, aSnapshotCount) ((p)->lpVtbl->GetSnapshotCount(p, aSnapshotCount))
#define IMachine_get_CurrentStateModified(p, aCurrentStateModified) ((p)->lpVtbl->GetCurrentStateModified(p, aCurrentStateModified))
#define IMachine_GetCurrentStateModified(p, aCurrentStateModified) ((p)->lpVtbl->GetCurrentStateModified(p, aCurrentStateModified))
#define IMachine_get_SharedFolders(p, aSharedFolders) ((p)->lpVtbl->GetSharedFolders(p, aSharedFolders))
#define IMachine_GetSharedFolders(p, aSharedFolders) ((p)->lpVtbl->GetSharedFolders(p, aSharedFolders))
#define IMachine_get_ClipboardMode(p, aClipboardMode) ((p)->lpVtbl->GetClipboardMode(p, aClipboardMode))
#define IMachine_GetClipboardMode(p, aClipboardMode) ((p)->lpVtbl->GetClipboardMode(p, aClipboardMode))
#define IMachine_put_ClipboardMode(p, aClipboardMode) ((p)->lpVtbl->SetClipboardMode(p, aClipboardMode))
#define IMachine_SetClipboardMode(p, aClipboardMode) ((p)->lpVtbl->SetClipboardMode(p, aClipboardMode))
#define IMachine_get_ClipboardFileTransfersEnabled(p, aClipboardFileTransfersEnabled) ((p)->lpVtbl->GetClipboardFileTransfersEnabled(p, aClipboardFileTransfersEnabled))
#define IMachine_GetClipboardFileTransfersEnabled(p, aClipboardFileTransfersEnabled) ((p)->lpVtbl->GetClipboardFileTransfersEnabled(p, aClipboardFileTransfersEnabled))
#define IMachine_put_ClipboardFileTransfersEnabled(p, aClipboardFileTransfersEnabled) ((p)->lpVtbl->SetClipboardFileTransfersEnabled(p, aClipboardFileTransfersEnabled))
#define IMachine_SetClipboardFileTransfersEnabled(p, aClipboardFileTransfersEnabled) ((p)->lpVtbl->SetClipboardFileTransfersEnabled(p, aClipboardFileTransfersEnabled))
#define IMachine_get_DnDMode(p, aDnDMode) ((p)->lpVtbl->GetDnDMode(p, aDnDMode))
#define IMachine_GetDnDMode(p, aDnDMode) ((p)->lpVtbl->GetDnDMode(p, aDnDMode))
#define IMachine_put_DnDMode(p, aDnDMode) ((p)->lpVtbl->SetDnDMode(p, aDnDMode))
#define IMachine_SetDnDMode(p, aDnDMode) ((p)->lpVtbl->SetDnDMode(p, aDnDMode))
#define IMachine_get_TeleporterEnabled(p, aTeleporterEnabled) ((p)->lpVtbl->GetTeleporterEnabled(p, aTeleporterEnabled))
#define IMachine_GetTeleporterEnabled(p, aTeleporterEnabled) ((p)->lpVtbl->GetTeleporterEnabled(p, aTeleporterEnabled))
#define IMachine_put_TeleporterEnabled(p, aTeleporterEnabled) ((p)->lpVtbl->SetTeleporterEnabled(p, aTeleporterEnabled))
#define IMachine_SetTeleporterEnabled(p, aTeleporterEnabled) ((p)->lpVtbl->SetTeleporterEnabled(p, aTeleporterEnabled))
#define IMachine_get_TeleporterPort(p, aTeleporterPort) ((p)->lpVtbl->GetTeleporterPort(p, aTeleporterPort))
#define IMachine_GetTeleporterPort(p, aTeleporterPort) ((p)->lpVtbl->GetTeleporterPort(p, aTeleporterPort))
#define IMachine_put_TeleporterPort(p, aTeleporterPort) ((p)->lpVtbl->SetTeleporterPort(p, aTeleporterPort))
#define IMachine_SetTeleporterPort(p, aTeleporterPort) ((p)->lpVtbl->SetTeleporterPort(p, aTeleporterPort))
#define IMachine_get_TeleporterAddress(p, aTeleporterAddress) ((p)->lpVtbl->GetTeleporterAddress(p, aTeleporterAddress))
#define IMachine_GetTeleporterAddress(p, aTeleporterAddress) ((p)->lpVtbl->GetTeleporterAddress(p, aTeleporterAddress))
#define IMachine_put_TeleporterAddress(p, aTeleporterAddress) ((p)->lpVtbl->SetTeleporterAddress(p, aTeleporterAddress))
#define IMachine_SetTeleporterAddress(p, aTeleporterAddress) ((p)->lpVtbl->SetTeleporterAddress(p, aTeleporterAddress))
#define IMachine_get_TeleporterPassword(p, aTeleporterPassword) ((p)->lpVtbl->GetTeleporterPassword(p, aTeleporterPassword))
#define IMachine_GetTeleporterPassword(p, aTeleporterPassword) ((p)->lpVtbl->GetTeleporterPassword(p, aTeleporterPassword))
#define IMachine_put_TeleporterPassword(p, aTeleporterPassword) ((p)->lpVtbl->SetTeleporterPassword(p, aTeleporterPassword))
#define IMachine_SetTeleporterPassword(p, aTeleporterPassword) ((p)->lpVtbl->SetTeleporterPassword(p, aTeleporterPassword))
#define IMachine_get_ParavirtProvider(p, aParavirtProvider) ((p)->lpVtbl->GetParavirtProvider(p, aParavirtProvider))
#define IMachine_GetParavirtProvider(p, aParavirtProvider) ((p)->lpVtbl->GetParavirtProvider(p, aParavirtProvider))
#define IMachine_put_ParavirtProvider(p, aParavirtProvider) ((p)->lpVtbl->SetParavirtProvider(p, aParavirtProvider))
#define IMachine_SetParavirtProvider(p, aParavirtProvider) ((p)->lpVtbl->SetParavirtProvider(p, aParavirtProvider))
#define IMachine_get_IOCacheEnabled(p, aIOCacheEnabled) ((p)->lpVtbl->GetIOCacheEnabled(p, aIOCacheEnabled))
#define IMachine_GetIOCacheEnabled(p, aIOCacheEnabled) ((p)->lpVtbl->GetIOCacheEnabled(p, aIOCacheEnabled))
#define IMachine_put_IOCacheEnabled(p, aIOCacheEnabled) ((p)->lpVtbl->SetIOCacheEnabled(p, aIOCacheEnabled))
#define IMachine_SetIOCacheEnabled(p, aIOCacheEnabled) ((p)->lpVtbl->SetIOCacheEnabled(p, aIOCacheEnabled))
#define IMachine_get_IOCacheSize(p, aIOCacheSize) ((p)->lpVtbl->GetIOCacheSize(p, aIOCacheSize))
#define IMachine_GetIOCacheSize(p, aIOCacheSize) ((p)->lpVtbl->GetIOCacheSize(p, aIOCacheSize))
#define IMachine_put_IOCacheSize(p, aIOCacheSize) ((p)->lpVtbl->SetIOCacheSize(p, aIOCacheSize))
#define IMachine_SetIOCacheSize(p, aIOCacheSize) ((p)->lpVtbl->SetIOCacheSize(p, aIOCacheSize))
#define IMachine_get_PCIDeviceAssignments(p, aPCIDeviceAssignments) ((p)->lpVtbl->GetPCIDeviceAssignments(p, aPCIDeviceAssignments))
#define IMachine_GetPCIDeviceAssignments(p, aPCIDeviceAssignments) ((p)->lpVtbl->GetPCIDeviceAssignments(p, aPCIDeviceAssignments))
#define IMachine_get_BandwidthControl(p, aBandwidthControl) ((p)->lpVtbl->GetBandwidthControl(p, aBandwidthControl))
#define IMachine_GetBandwidthControl(p, aBandwidthControl) ((p)->lpVtbl->GetBandwidthControl(p, aBandwidthControl))
#define IMachine_get_TracingEnabled(p, aTracingEnabled) ((p)->lpVtbl->GetTracingEnabled(p, aTracingEnabled))
#define IMachine_GetTracingEnabled(p, aTracingEnabled) ((p)->lpVtbl->GetTracingEnabled(p, aTracingEnabled))
#define IMachine_put_TracingEnabled(p, aTracingEnabled) ((p)->lpVtbl->SetTracingEnabled(p, aTracingEnabled))
#define IMachine_SetTracingEnabled(p, aTracingEnabled) ((p)->lpVtbl->SetTracingEnabled(p, aTracingEnabled))
#define IMachine_get_TracingConfig(p, aTracingConfig) ((p)->lpVtbl->GetTracingConfig(p, aTracingConfig))
#define IMachine_GetTracingConfig(p, aTracingConfig) ((p)->lpVtbl->GetTracingConfig(p, aTracingConfig))
#define IMachine_put_TracingConfig(p, aTracingConfig) ((p)->lpVtbl->SetTracingConfig(p, aTracingConfig))
#define IMachine_SetTracingConfig(p, aTracingConfig) ((p)->lpVtbl->SetTracingConfig(p, aTracingConfig))
#define IMachine_get_AllowTracingToAccessVM(p, aAllowTracingToAccessVM) ((p)->lpVtbl->GetAllowTracingToAccessVM(p, aAllowTracingToAccessVM))
#define IMachine_GetAllowTracingToAccessVM(p, aAllowTracingToAccessVM) ((p)->lpVtbl->GetAllowTracingToAccessVM(p, aAllowTracingToAccessVM))
#define IMachine_put_AllowTracingToAccessVM(p, aAllowTracingToAccessVM) ((p)->lpVtbl->SetAllowTracingToAccessVM(p, aAllowTracingToAccessVM))
#define IMachine_SetAllowTracingToAccessVM(p, aAllowTracingToAccessVM) ((p)->lpVtbl->SetAllowTracingToAccessVM(p, aAllowTracingToAccessVM))
#define IMachine_get_AutostartEnabled(p, aAutostartEnabled) ((p)->lpVtbl->GetAutostartEnabled(p, aAutostartEnabled))
#define IMachine_GetAutostartEnabled(p, aAutostartEnabled) ((p)->lpVtbl->GetAutostartEnabled(p, aAutostartEnabled))
#define IMachine_put_AutostartEnabled(p, aAutostartEnabled) ((p)->lpVtbl->SetAutostartEnabled(p, aAutostartEnabled))
#define IMachine_SetAutostartEnabled(p, aAutostartEnabled) ((p)->lpVtbl->SetAutostartEnabled(p, aAutostartEnabled))
#define IMachine_get_AutostartDelay(p, aAutostartDelay) ((p)->lpVtbl->GetAutostartDelay(p, aAutostartDelay))
#define IMachine_GetAutostartDelay(p, aAutostartDelay) ((p)->lpVtbl->GetAutostartDelay(p, aAutostartDelay))
#define IMachine_put_AutostartDelay(p, aAutostartDelay) ((p)->lpVtbl->SetAutostartDelay(p, aAutostartDelay))
#define IMachine_SetAutostartDelay(p, aAutostartDelay) ((p)->lpVtbl->SetAutostartDelay(p, aAutostartDelay))
#define IMachine_get_AutostopType(p, aAutostopType) ((p)->lpVtbl->GetAutostopType(p, aAutostopType))
#define IMachine_GetAutostopType(p, aAutostopType) ((p)->lpVtbl->GetAutostopType(p, aAutostopType))
#define IMachine_put_AutostopType(p, aAutostopType) ((p)->lpVtbl->SetAutostopType(p, aAutostopType))
#define IMachine_SetAutostopType(p, aAutostopType) ((p)->lpVtbl->SetAutostopType(p, aAutostopType))
#define IMachine_get_DefaultFrontend(p, aDefaultFrontend) ((p)->lpVtbl->GetDefaultFrontend(p, aDefaultFrontend))
#define IMachine_GetDefaultFrontend(p, aDefaultFrontend) ((p)->lpVtbl->GetDefaultFrontend(p, aDefaultFrontend))
#define IMachine_put_DefaultFrontend(p, aDefaultFrontend) ((p)->lpVtbl->SetDefaultFrontend(p, aDefaultFrontend))
#define IMachine_SetDefaultFrontend(p, aDefaultFrontend) ((p)->lpVtbl->SetDefaultFrontend(p, aDefaultFrontend))
#define IMachine_get_USBProxyAvailable(p, aUSBProxyAvailable) ((p)->lpVtbl->GetUSBProxyAvailable(p, aUSBProxyAvailable))
#define IMachine_GetUSBProxyAvailable(p, aUSBProxyAvailable) ((p)->lpVtbl->GetUSBProxyAvailable(p, aUSBProxyAvailable))
#define IMachine_get_VMProcessPriority(p, aVMProcessPriority) ((p)->lpVtbl->GetVMProcessPriority(p, aVMProcessPriority))
#define IMachine_GetVMProcessPriority(p, aVMProcessPriority) ((p)->lpVtbl->GetVMProcessPriority(p, aVMProcessPriority))
#define IMachine_put_VMProcessPriority(p, aVMProcessPriority) ((p)->lpVtbl->SetVMProcessPriority(p, aVMProcessPriority))
#define IMachine_SetVMProcessPriority(p, aVMProcessPriority) ((p)->lpVtbl->SetVMProcessPriority(p, aVMProcessPriority))
#define IMachine_get_VMExecutionEngine(p, aVMExecutionEngine) ((p)->lpVtbl->GetVMExecutionEngine(p, aVMExecutionEngine))
#define IMachine_GetVMExecutionEngine(p, aVMExecutionEngine) ((p)->lpVtbl->GetVMExecutionEngine(p, aVMExecutionEngine))
#define IMachine_put_VMExecutionEngine(p, aVMExecutionEngine) ((p)->lpVtbl->SetVMExecutionEngine(p, aVMExecutionEngine))
#define IMachine_SetVMExecutionEngine(p, aVMExecutionEngine) ((p)->lpVtbl->SetVMExecutionEngine(p, aVMExecutionEngine))
#define IMachine_get_ParavirtDebug(p, aParavirtDebug) ((p)->lpVtbl->GetParavirtDebug(p, aParavirtDebug))
#define IMachine_GetParavirtDebug(p, aParavirtDebug) ((p)->lpVtbl->GetParavirtDebug(p, aParavirtDebug))
#define IMachine_put_ParavirtDebug(p, aParavirtDebug) ((p)->lpVtbl->SetParavirtDebug(p, aParavirtDebug))
#define IMachine_SetParavirtDebug(p, aParavirtDebug) ((p)->lpVtbl->SetParavirtDebug(p, aParavirtDebug))
#define IMachine_get_CPUProfile(p, aCPUProfile) ((p)->lpVtbl->GetCPUProfile(p, aCPUProfile))
#define IMachine_GetCPUProfile(p, aCPUProfile) ((p)->lpVtbl->GetCPUProfile(p, aCPUProfile))
#define IMachine_put_CPUProfile(p, aCPUProfile) ((p)->lpVtbl->SetCPUProfile(p, aCPUProfile))
#define IMachine_SetCPUProfile(p, aCPUProfile) ((p)->lpVtbl->SetCPUProfile(p, aCPUProfile))
#define IMachine_get_StateKeyId(p, aStateKeyId) ((p)->lpVtbl->GetStateKeyId(p, aStateKeyId))
#define IMachine_GetStateKeyId(p, aStateKeyId) ((p)->lpVtbl->GetStateKeyId(p, aStateKeyId))
#define IMachine_get_StateKeyStore(p, aStateKeyStore) ((p)->lpVtbl->GetStateKeyStore(p, aStateKeyStore))
#define IMachine_GetStateKeyStore(p, aStateKeyStore) ((p)->lpVtbl->GetStateKeyStore(p, aStateKeyStore))
#define IMachine_get_LogKeyId(p, aLogKeyId) ((p)->lpVtbl->GetLogKeyId(p, aLogKeyId))
#define IMachine_GetLogKeyId(p, aLogKeyId) ((p)->lpVtbl->GetLogKeyId(p, aLogKeyId))
#define IMachine_get_LogKeyStore(p, aLogKeyStore) ((p)->lpVtbl->GetLogKeyStore(p, aLogKeyStore))
#define IMachine_GetLogKeyStore(p, aLogKeyStore) ((p)->lpVtbl->GetLogKeyStore(p, aLogKeyStore))
#define IMachine_get_GuestDebugControl(p, aGuestDebugControl) ((p)->lpVtbl->GetGuestDebugControl(p, aGuestDebugControl))
#define IMachine_GetGuestDebugControl(p, aGuestDebugControl) ((p)->lpVtbl->GetGuestDebugControl(p, aGuestDebugControl))
#define IMachine_LockMachine(p, aSession, aLockType) ((p)->lpVtbl->LockMachine(p, aSession, aLockType))
#define IMachine_LaunchVMProcess(p, aSession, aName, aEnvironmentChanges, aProgress) ((p)->lpVtbl->LaunchVMProcess(p, aSession, aName, aEnvironmentChanges, aProgress))
#define IMachine_SetBootOrder(p, aPosition, aDevice) ((p)->lpVtbl->SetBootOrder(p, aPosition, aDevice))
#define IMachine_GetBootOrder(p, aPosition, aDevice) ((p)->lpVtbl->GetBootOrder(p, aPosition, aDevice))
#define IMachine_AttachDevice(p, aName, aControllerPort, aDevice, aType, aMedium) ((p)->lpVtbl->AttachDevice(p, aName, aControllerPort, aDevice, aType, aMedium))
#define IMachine_AttachDeviceWithoutMedium(p, aName, aControllerPort, aDevice, aType) ((p)->lpVtbl->AttachDeviceWithoutMedium(p, aName, aControllerPort, aDevice, aType))
#define IMachine_DetachDevice(p, aName, aControllerPort, aDevice) ((p)->lpVtbl->DetachDevice(p, aName, aControllerPort, aDevice))
#define IMachine_PassthroughDevice(p, aName, aControllerPort, aDevice, aPassthrough) ((p)->lpVtbl->PassthroughDevice(p, aName, aControllerPort, aDevice, aPassthrough))
#define IMachine_TemporaryEjectDevice(p, aName, aControllerPort, aDevice, aTemporaryEject) ((p)->lpVtbl->TemporaryEjectDevice(p, aName, aControllerPort, aDevice, aTemporaryEject))
#define IMachine_NonRotationalDevice(p, aName, aControllerPort, aDevice, aNonRotational) ((p)->lpVtbl->NonRotationalDevice(p, aName, aControllerPort, aDevice, aNonRotational))
#define IMachine_SetAutoDiscardForDevice(p, aName, aControllerPort, aDevice, aDiscard) ((p)->lpVtbl->SetAutoDiscardForDevice(p, aName, aControllerPort, aDevice, aDiscard))
#define IMachine_SetHotPluggableForDevice(p, aName, aControllerPort, aDevice, aHotPluggable) ((p)->lpVtbl->SetHotPluggableForDevice(p, aName, aControllerPort, aDevice, aHotPluggable))
#define IMachine_SetBandwidthGroupForDevice(p, aName, aControllerPort, aDevice, aBandwidthGroup) ((p)->lpVtbl->SetBandwidthGroupForDevice(p, aName, aControllerPort, aDevice, aBandwidthGroup))
#define IMachine_SetNoBandwidthGroupForDevice(p, aName, aControllerPort, aDevice) ((p)->lpVtbl->SetNoBandwidthGroupForDevice(p, aName, aControllerPort, aDevice))
#define IMachine_UnmountMedium(p, aName, aControllerPort, aDevice, aForce) ((p)->lpVtbl->UnmountMedium(p, aName, aControllerPort, aDevice, aForce))
#define IMachine_MountMedium(p, aName, aControllerPort, aDevice, aMedium, aForce) ((p)->lpVtbl->MountMedium(p, aName, aControllerPort, aDevice, aMedium, aForce))
#define IMachine_GetMedium(p, aName, aControllerPort, aDevice, aMedium) ((p)->lpVtbl->GetMedium(p, aName, aControllerPort, aDevice, aMedium))
#define IMachine_GetMediumAttachmentsOfController(p, aName, aMediumAttachments) ((p)->lpVtbl->GetMediumAttachmentsOfController(p, aName, aMediumAttachments))
#define IMachine_GetMediumAttachment(p, aName, aControllerPort, aDevice, aAttachment) ((p)->lpVtbl->GetMediumAttachment(p, aName, aControllerPort, aDevice, aAttachment))
#define IMachine_AttachHostPCIDevice(p, aHostAddress, aDesiredGuestAddress, aTryToUnbind) ((p)->lpVtbl->AttachHostPCIDevice(p, aHostAddress, aDesiredGuestAddress, aTryToUnbind))
#define IMachine_DetachHostPCIDevice(p, aHostAddress) ((p)->lpVtbl->DetachHostPCIDevice(p, aHostAddress))
#define IMachine_GetNetworkAdapter(p, aSlot, aAdapter) ((p)->lpVtbl->GetNetworkAdapter(p, aSlot, aAdapter))
#define IMachine_AddStorageController(p, aName, aConnectionType, aController) ((p)->lpVtbl->AddStorageController(p, aName, aConnectionType, aController))
#define IMachine_GetStorageControllerByName(p, aName, aStorageController) ((p)->lpVtbl->GetStorageControllerByName(p, aName, aStorageController))
#define IMachine_GetStorageControllerByInstance(p, aConnectionType, aInstance, aStorageController) ((p)->lpVtbl->GetStorageControllerByInstance(p, aConnectionType, aInstance, aStorageController))
#define IMachine_RemoveStorageController(p, aName) ((p)->lpVtbl->RemoveStorageController(p, aName))
#define IMachine_SetStorageControllerBootable(p, aName, aBootable) ((p)->lpVtbl->SetStorageControllerBootable(p, aName, aBootable))
#define IMachine_AddUSBController(p, aName, aType, aController) ((p)->lpVtbl->AddUSBController(p, aName, aType, aController))
#define IMachine_RemoveUSBController(p, aName) ((p)->lpVtbl->RemoveUSBController(p, aName))
#define IMachine_GetUSBControllerByName(p, aName, aController) ((p)->lpVtbl->GetUSBControllerByName(p, aName, aController))
#define IMachine_GetUSBControllerCountByType(p, aType, aControllers) ((p)->lpVtbl->GetUSBControllerCountByType(p, aType, aControllers))
#define IMachine_GetSerialPort(p, aSlot, aPort) ((p)->lpVtbl->GetSerialPort(p, aSlot, aPort))
#define IMachine_GetParallelPort(p, aSlot, aPort) ((p)->lpVtbl->GetParallelPort(p, aSlot, aPort))
#define IMachine_GetExtraDataKeys(p, aKeys) ((p)->lpVtbl->GetExtraDataKeys(p, aKeys))
#define IMachine_GetExtraData(p, aKey, aValue) ((p)->lpVtbl->GetExtraData(p, aKey, aValue))
#define IMachine_SetExtraData(p, aKey, aValue) ((p)->lpVtbl->SetExtraData(p, aKey, aValue))
#define IMachine_SetSettingsFilePath(p, aSettingsFilePath, aProgress) ((p)->lpVtbl->SetSettingsFilePath(p, aSettingsFilePath, aProgress))
#define IMachine_SaveSettings(p) ((p)->lpVtbl->SaveSettings(p))
#define IMachine_DiscardSettings(p) ((p)->lpVtbl->DiscardSettings(p))
#define IMachine_Unregister(p, aCleanupMode, aMedia) ((p)->lpVtbl->Unregister(p, aCleanupMode, aMedia))
#define IMachine_DeleteConfig(p, aMedia, aProgress) ((p)->lpVtbl->DeleteConfig(p, aMedia, aProgress))
#define IMachine_ExportTo(p, aAppliance, aLocation, aDescription) ((p)->lpVtbl->ExportTo(p, aAppliance, aLocation, aDescription))
#define IMachine_FindSnapshot(p, aNameOrId, aSnapshot) ((p)->lpVtbl->FindSnapshot(p, aNameOrId, aSnapshot))
#define IMachine_CreateSharedFolder(p, aName, aHostPath, aWritable, aAutomount, aAutoMountPoint) ((p)->lpVtbl->CreateSharedFolder(p, aName, aHostPath, aWritable, aAutomount, aAutoMountPoint))
#define IMachine_RemoveSharedFolder(p, aName) ((p)->lpVtbl->RemoveSharedFolder(p, aName))
#define IMachine_CanShowConsoleWindow(p, aCanShow) ((p)->lpVtbl->CanShowConsoleWindow(p, aCanShow))
#define IMachine_ShowConsoleWindow(p, aWinId) ((p)->lpVtbl->ShowConsoleWindow(p, aWinId))
#define IMachine_GetGuestProperty(p, aName, aValue, aTimestamp, aFlags) ((p)->lpVtbl->GetGuestProperty(p, aName, aValue, aTimestamp, aFlags))
#define IMachine_GetGuestPropertyValue(p, aProperty, aValue) ((p)->lpVtbl->GetGuestPropertyValue(p, aProperty, aValue))
#define IMachine_GetGuestPropertyTimestamp(p, aProperty, aValue) ((p)->lpVtbl->GetGuestPropertyTimestamp(p, aProperty, aValue))
#define IMachine_SetGuestProperty(p, aProperty, aValue, aFlags) ((p)->lpVtbl->SetGuestProperty(p, aProperty, aValue, aFlags))
#define IMachine_SetGuestPropertyValue(p, aProperty, aValue) ((p)->lpVtbl->SetGuestPropertyValue(p, aProperty, aValue))
#define IMachine_DeleteGuestProperty(p, aName) ((p)->lpVtbl->DeleteGuestProperty(p, aName))
#define IMachine_EnumerateGuestProperties(p, aPatterns, aNames, aValues, aTimestamps, aFlags) ((p)->lpVtbl->EnumerateGuestProperties(p, aPatterns, aNames, aValues, aTimestamps, aFlags))
#define IMachine_QuerySavedGuestScreenInfo(p, aScreenId, aOriginX, aOriginY, aWidth, aHeight, aEnabled) ((p)->lpVtbl->QuerySavedGuestScreenInfo(p, aScreenId, aOriginX, aOriginY, aWidth, aHeight, aEnabled))
#define IMachine_ReadSavedThumbnailToArray(p, aScreenId, aBitmapFormat, aWidth, aHeight, aData) ((p)->lpVtbl->ReadSavedThumbnailToArray(p, aScreenId, aBitmapFormat, aWidth, aHeight, aData))
#define IMachine_QuerySavedScreenshotInfo(p, aScreenId, aWidth, aHeight, aBitmapFormats) ((p)->lpVtbl->QuerySavedScreenshotInfo(p, aScreenId, aWidth, aHeight, aBitmapFormats))
#define IMachine_ReadSavedScreenshotToArray(p, aScreenId, aBitmapFormat, aWidth, aHeight, aData) ((p)->lpVtbl->ReadSavedScreenshotToArray(p, aScreenId, aBitmapFormat, aWidth, aHeight, aData))
#define IMachine_HotPlugCPU(p, aCpu) ((p)->lpVtbl->HotPlugCPU(p, aCpu))
#define IMachine_HotUnplugCPU(p, aCpu) ((p)->lpVtbl->HotUnplugCPU(p, aCpu))
#define IMachine_GetCPUStatus(p, aCpu, aAttached) ((p)->lpVtbl->GetCPUStatus(p, aCpu, aAttached))
#define IMachine_GetEffectiveParavirtProvider(p, aParavirtProvider) ((p)->lpVtbl->GetEffectiveParavirtProvider(p, aParavirtProvider))
#define IMachine_QueryLogFilename(p, aIdx, aFilename) ((p)->lpVtbl->QueryLogFilename(p, aIdx, aFilename))
#define IMachine_ReadLog(p, aIdx, aOffset, aSize, aData) ((p)->lpVtbl->ReadLog(p, aIdx, aOffset, aSize, aData))
#define IMachine_CloneTo(p, aTarget, aMode, aOptions, aProgress) ((p)->lpVtbl->CloneTo(p, aTarget, aMode, aOptions, aProgress))
#define IMachine_MoveTo(p, aFolder, aType, aProgress) ((p)->lpVtbl->MoveTo(p, aFolder, aType, aProgress))
#define IMachine_SaveState(p, aProgress) ((p)->lpVtbl->SaveState(p, aProgress))
#define IMachine_AdoptSavedState(p, aSavedStateFile) ((p)->lpVtbl->AdoptSavedState(p, aSavedStateFile))
#define IMachine_DiscardSavedState(p, aFRemoveFile) ((p)->lpVtbl->DiscardSavedState(p, aFRemoveFile))
#define IMachine_TakeSnapshot(p, aName, aDescription, aPause, aId, aProgress) ((p)->lpVtbl->TakeSnapshot(p, aName, aDescription, aPause, aId, aProgress))
#define IMachine_DeleteSnapshot(p, aId, aProgress) ((p)->lpVtbl->DeleteSnapshot(p, aId, aProgress))
#define IMachine_DeleteSnapshotAndAllChildren(p, aId, aProgress) ((p)->lpVtbl->DeleteSnapshotAndAllChildren(p, aId, aProgress))
#define IMachine_DeleteSnapshotRange(p, aStartId, aEndId, aProgress) ((p)->lpVtbl->DeleteSnapshotRange(p, aStartId, aEndId, aProgress))
#define IMachine_RestoreSnapshot(p, aSnapshot, aProgress) ((p)->lpVtbl->RestoreSnapshot(p, aSnapshot, aProgress))
#define IMachine_ApplyDefaults(p, aFlags) ((p)->lpVtbl->ApplyDefaults(p, aFlags))
#define IMachine_ChangeEncryption(p, aCurrentPassword, aCipher, aNewPassword, aNewPasswordId, aForce, aProgress) ((p)->lpVtbl->ChangeEncryption(p, aCurrentPassword, aCipher, aNewPassword, aNewPasswordId, aForce, aProgress))
#define IMachine_GetEncryptionSettings(p, aCipher, aPasswordId) ((p)->lpVtbl->GetEncryptionSettings(p, aCipher, aPasswordId))
#define IMachine_CheckEncryptionPassword(p, aPassword) ((p)->lpVtbl->CheckEncryptionPassword(p, aPassword))
#define IMachine_AddEncryptionPassword(p, aId, aPassword) ((p)->lpVtbl->AddEncryptionPassword(p, aId, aPassword))
#define IMachine_AddEncryptionPasswords(p, aIds, aPasswords) ((p)->lpVtbl->AddEncryptionPasswords(p, aIds, aPasswords))
#define IMachine_RemoveEncryptionPassword(p, aId) ((p)->lpVtbl->RemoveEncryptionPassword(p, aId))
#define IMachine_ClearAllEncryptionPasswords(p) ((p)->lpVtbl->ClearAllEncryptionPasswords(p))
#endif /* VBOX_WITH_GLUE */

interface IMachine
{
#ifndef VBOX_WITH_GLUE
    struct IMachine_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IMachineVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IMachine declaration */


/* Start of struct IEmulatedUSB declaration */
#define IEMULATEDUSB_IID_STR "6e253ee8-477a-2497-6759-88b8292a5af0"
#define IEMULATEDUSB_IID { \
    0x6e253ee8, 0x477a, 0x2497, \
    { 0x67, 0x59, 0x88, 0xb8, 0x29, 0x2a, 0x5a, 0xf0 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IEmulatedUSB);
#ifndef VBOX_WITH_GLUE
struct IEmulatedUSB_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetWebcams)(IEmulatedUSB *pThis, PRUint32 *webcamsSize, PRUnichar * **webcams);

    nsresult (*GetInternalAndReservedAttribute1IEmulatedUSB)(IEmulatedUSB *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IEmulatedUSB)(IEmulatedUSB *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IEmulatedUSB)(IEmulatedUSB *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IEmulatedUSB)(IEmulatedUSB *pThis, PRUint32 *reserved);

    nsresult (*WebcamAttach)(
        IEmulatedUSB *pThis,
        PRUnichar * path,
        PRUnichar * settings
    );

    nsresult (*WebcamDetach)(
        IEmulatedUSB *pThis,
        PRUnichar * path
    );

    nsresult (*InternalAndReservedMethod1IEmulatedUSB)(IEmulatedUSB *pThis);

    nsresult (*InternalAndReservedMethod2IEmulatedUSB)(IEmulatedUSB *pThis);

    nsresult (*InternalAndReservedMethod3IEmulatedUSB)(IEmulatedUSB *pThis);

    nsresult (*InternalAndReservedMethod4IEmulatedUSB)(IEmulatedUSB *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IEmulatedUSBVtbl
{
    nsresult (*QueryInterface)(IEmulatedUSB *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IEmulatedUSB *pThis);
    nsrefcnt (*Release)(IEmulatedUSB *pThis);
    nsresult (*GetWebcams)(IEmulatedUSB *pThis, PRUint32 *webcamsSize, PRUnichar * **webcams);

    nsresult (*GetInternalAndReservedAttribute1IEmulatedUSB)(IEmulatedUSB *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IEmulatedUSB)(IEmulatedUSB *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IEmulatedUSB)(IEmulatedUSB *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IEmulatedUSB)(IEmulatedUSB *pThis, PRUint32 *reserved);

    nsresult (*WebcamAttach)(
        IEmulatedUSB *pThis,
        PRUnichar * path,
        PRUnichar * settings
    );

    nsresult (*WebcamDetach)(
        IEmulatedUSB *pThis,
        PRUnichar * path
    );

    nsresult (*InternalAndReservedMethod1IEmulatedUSB)(IEmulatedUSB *pThis);

    nsresult (*InternalAndReservedMethod2IEmulatedUSB)(IEmulatedUSB *pThis);

    nsresult (*InternalAndReservedMethod3IEmulatedUSB)(IEmulatedUSB *pThis);

    nsresult (*InternalAndReservedMethod4IEmulatedUSB)(IEmulatedUSB *pThis);

};
#define IEmulatedUSB_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IEmulatedUSB_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IEmulatedUSB_Release(p) ((p)->lpVtbl->Release(p))
#define IEmulatedUSB_get_Webcams(p, aWebcams) ((p)->lpVtbl->GetWebcams(p, aWebcams))
#define IEmulatedUSB_GetWebcams(p, aWebcams) ((p)->lpVtbl->GetWebcams(p, aWebcams))
#define IEmulatedUSB_WebcamAttach(p, aPath, aSettings) ((p)->lpVtbl->WebcamAttach(p, aPath, aSettings))
#define IEmulatedUSB_WebcamDetach(p, aPath) ((p)->lpVtbl->WebcamDetach(p, aPath))
#endif /* VBOX_WITH_GLUE */

interface IEmulatedUSB
{
#ifndef VBOX_WITH_GLUE
    struct IEmulatedUSB_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IEmulatedUSBVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IEmulatedUSB declaration */


/* Start of struct IVRDEServerInfo declaration */
#define IVRDESERVERINFO_IID_STR "c39ef4d6-7532-45e8-96da-eb5986ae76e4"
#define IVRDESERVERINFO_IID { \
    0xc39ef4d6, 0x7532, 0x45e8, \
    { 0x96, 0xda, 0xeb, 0x59, 0x86, 0xae, 0x76, 0xe4 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IVRDEServerInfo);
#ifndef VBOX_WITH_GLUE
struct IVRDEServerInfo_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetActive)(IVRDEServerInfo *pThis, PRBool *active);

    nsresult (*GetPort)(IVRDEServerInfo *pThis, PRInt32 *port);

    nsresult (*GetNumberOfClients)(IVRDEServerInfo *pThis, PRUint32 *numberOfClients);

    nsresult (*GetBeginTime)(IVRDEServerInfo *pThis, PRInt64 *beginTime);

    nsresult (*GetEndTime)(IVRDEServerInfo *pThis, PRInt64 *endTime);

    nsresult (*GetBytesSent)(IVRDEServerInfo *pThis, PRInt64 *bytesSent);

    nsresult (*GetBytesSentTotal)(IVRDEServerInfo *pThis, PRInt64 *bytesSentTotal);

    nsresult (*GetBytesReceived)(IVRDEServerInfo *pThis, PRInt64 *bytesReceived);

    nsresult (*GetBytesReceivedTotal)(IVRDEServerInfo *pThis, PRInt64 *bytesReceivedTotal);

    nsresult (*GetUser)(IVRDEServerInfo *pThis, PRUnichar * *user);

    nsresult (*GetDomain)(IVRDEServerInfo *pThis, PRUnichar * *domain);

    nsresult (*GetClientName)(IVRDEServerInfo *pThis, PRUnichar * *clientName);

    nsresult (*GetClientIP)(IVRDEServerInfo *pThis, PRUnichar * *clientIP);

    nsresult (*GetClientVersion)(IVRDEServerInfo *pThis, PRUint32 *clientVersion);

    nsresult (*GetEncryptionStyle)(IVRDEServerInfo *pThis, PRUint32 *encryptionStyle);

    nsresult (*GetInternalAndReservedAttribute1IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

};
#else /* VBOX_WITH_GLUE */
struct IVRDEServerInfoVtbl
{
    nsresult (*QueryInterface)(IVRDEServerInfo *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IVRDEServerInfo *pThis);
    nsrefcnt (*Release)(IVRDEServerInfo *pThis);
    nsresult (*GetActive)(IVRDEServerInfo *pThis, PRBool *active);

    nsresult (*GetPort)(IVRDEServerInfo *pThis, PRInt32 *port);

    nsresult (*GetNumberOfClients)(IVRDEServerInfo *pThis, PRUint32 *numberOfClients);

    nsresult (*GetBeginTime)(IVRDEServerInfo *pThis, PRInt64 *beginTime);

    nsresult (*GetEndTime)(IVRDEServerInfo *pThis, PRInt64 *endTime);

    nsresult (*GetBytesSent)(IVRDEServerInfo *pThis, PRInt64 *bytesSent);

    nsresult (*GetBytesSentTotal)(IVRDEServerInfo *pThis, PRInt64 *bytesSentTotal);

    nsresult (*GetBytesReceived)(IVRDEServerInfo *pThis, PRInt64 *bytesReceived);

    nsresult (*GetBytesReceivedTotal)(IVRDEServerInfo *pThis, PRInt64 *bytesReceivedTotal);

    nsresult (*GetUser)(IVRDEServerInfo *pThis, PRUnichar * *user);

    nsresult (*GetDomain)(IVRDEServerInfo *pThis, PRUnichar * *domain);

    nsresult (*GetClientName)(IVRDEServerInfo *pThis, PRUnichar * *clientName);

    nsresult (*GetClientIP)(IVRDEServerInfo *pThis, PRUnichar * *clientIP);

    nsresult (*GetClientVersion)(IVRDEServerInfo *pThis, PRUint32 *clientVersion);

    nsresult (*GetEncryptionStyle)(IVRDEServerInfo *pThis, PRUint32 *encryptionStyle);

    nsresult (*GetInternalAndReservedAttribute1IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IVRDEServerInfo)(IVRDEServerInfo *pThis, PRUint32 *reserved);

};
#define IVRDEServerInfo_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IVRDEServerInfo_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IVRDEServerInfo_Release(p) ((p)->lpVtbl->Release(p))
#define IVRDEServerInfo_get_Active(p, aActive) ((p)->lpVtbl->GetActive(p, aActive))
#define IVRDEServerInfo_GetActive(p, aActive) ((p)->lpVtbl->GetActive(p, aActive))
#define IVRDEServerInfo_get_Port(p, aPort) ((p)->lpVtbl->GetPort(p, aPort))
#define IVRDEServerInfo_GetPort(p, aPort) ((p)->lpVtbl->GetPort(p, aPort))
#define IVRDEServerInfo_get_NumberOfClients(p, aNumberOfClients) ((p)->lpVtbl->GetNumberOfClients(p, aNumberOfClients))
#define IVRDEServerInfo_GetNumberOfClients(p, aNumberOfClients) ((p)->lpVtbl->GetNumberOfClients(p, aNumberOfClients))
#define IVRDEServerInfo_get_BeginTime(p, aBeginTime) ((p)->lpVtbl->GetBeginTime(p, aBeginTime))
#define IVRDEServerInfo_GetBeginTime(p, aBeginTime) ((p)->lpVtbl->GetBeginTime(p, aBeginTime))
#define IVRDEServerInfo_get_EndTime(p, aEndTime) ((p)->lpVtbl->GetEndTime(p, aEndTime))
#define IVRDEServerInfo_GetEndTime(p, aEndTime) ((p)->lpVtbl->GetEndTime(p, aEndTime))
#define IVRDEServerInfo_get_BytesSent(p, aBytesSent) ((p)->lpVtbl->GetBytesSent(p, aBytesSent))
#define IVRDEServerInfo_GetBytesSent(p, aBytesSent) ((p)->lpVtbl->GetBytesSent(p, aBytesSent))
#define IVRDEServerInfo_get_BytesSentTotal(p, aBytesSentTotal) ((p)->lpVtbl->GetBytesSentTotal(p, aBytesSentTotal))
#define IVRDEServerInfo_GetBytesSentTotal(p, aBytesSentTotal) ((p)->lpVtbl->GetBytesSentTotal(p, aBytesSentTotal))
#define IVRDEServerInfo_get_BytesReceived(p, aBytesReceived) ((p)->lpVtbl->GetBytesReceived(p, aBytesReceived))
#define IVRDEServerInfo_GetBytesReceived(p, aBytesReceived) ((p)->lpVtbl->GetBytesReceived(p, aBytesReceived))
#define IVRDEServerInfo_get_BytesReceivedTotal(p, aBytesReceivedTotal) ((p)->lpVtbl->GetBytesReceivedTotal(p, aBytesReceivedTotal))
#define IVRDEServerInfo_GetBytesReceivedTotal(p, aBytesReceivedTotal) ((p)->lpVtbl->GetBytesReceivedTotal(p, aBytesReceivedTotal))
#define IVRDEServerInfo_get_User(p, aUser) ((p)->lpVtbl->GetUser(p, aUser))
#define IVRDEServerInfo_GetUser(p, aUser) ((p)->lpVtbl->GetUser(p, aUser))
#define IVRDEServerInfo_get_Domain(p, aDomain) ((p)->lpVtbl->GetDomain(p, aDomain))
#define IVRDEServerInfo_GetDomain(p, aDomain) ((p)->lpVtbl->GetDomain(p, aDomain))
#define IVRDEServerInfo_get_ClientName(p, aClientName) ((p)->lpVtbl->GetClientName(p, aClientName))
#define IVRDEServerInfo_GetClientName(p, aClientName) ((p)->lpVtbl->GetClientName(p, aClientName))
#define IVRDEServerInfo_get_ClientIP(p, aClientIP) ((p)->lpVtbl->GetClientIP(p, aClientIP))
#define IVRDEServerInfo_GetClientIP(p, aClientIP) ((p)->lpVtbl->GetClientIP(p, aClientIP))
#define IVRDEServerInfo_get_ClientVersion(p, aClientVersion) ((p)->lpVtbl->GetClientVersion(p, aClientVersion))
#define IVRDEServerInfo_GetClientVersion(p, aClientVersion) ((p)->lpVtbl->GetClientVersion(p, aClientVersion))
#define IVRDEServerInfo_get_EncryptionStyle(p, aEncryptionStyle) ((p)->lpVtbl->GetEncryptionStyle(p, aEncryptionStyle))
#define IVRDEServerInfo_GetEncryptionStyle(p, aEncryptionStyle) ((p)->lpVtbl->GetEncryptionStyle(p, aEncryptionStyle))
#endif /* VBOX_WITH_GLUE */

interface IVRDEServerInfo
{
#ifndef VBOX_WITH_GLUE
    struct IVRDEServerInfo_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IVRDEServerInfoVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IVRDEServerInfo declaration */


/* Start of struct IConsole declaration */
#define ICONSOLE_IID_STR "6ac83d89-6ee7-4e33-8ae6-b257b2e81be8"
#define ICONSOLE_IID { \
    0x6ac83d89, 0x6ee7, 0x4e33, \
    { 0x8a, 0xe6, 0xb2, 0x57, 0xb2, 0xe8, 0x1b, 0xe8 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IConsole);
#ifndef VBOX_WITH_GLUE
struct IConsole_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetMachine)(IConsole *pThis, IMachine * *machine);

    nsresult (*GetState)(IConsole *pThis, PRUint32 *state);

    nsresult (*GetGuest)(IConsole *pThis, IGuest * *guest);

    nsresult (*GetKeyboard)(IConsole *pThis, IKeyboard * *keyboard);

    nsresult (*GetMouse)(IConsole *pThis, IMouse * *mouse);

    nsresult (*GetDisplay)(IConsole *pThis, IDisplay * *display);

    nsresult (*GetDebugger)(IConsole *pThis, IMachineDebugger * *debugger);

    nsresult (*GetUSBDevices)(IConsole *pThis, PRUint32 *USBDevicesSize, IUSBDevice * **USBDevices);

    nsresult (*GetRemoteUSBDevices)(IConsole *pThis, PRUint32 *remoteUSBDevicesSize, IHostUSBDevice * **remoteUSBDevices);

    nsresult (*GetSharedFolders)(IConsole *pThis, PRUint32 *sharedFoldersSize, ISharedFolder * **sharedFolders);

    nsresult (*GetVRDEServerInfo)(IConsole *pThis, IVRDEServerInfo * *VRDEServerInfo);

    nsresult (*GetEventSource)(IConsole *pThis, IEventSource * *eventSource);

    nsresult (*GetAttachedPCIDevices)(IConsole *pThis, PRUint32 *attachedPCIDevicesSize, IPCIDeviceAttachment * **attachedPCIDevices);

    nsresult (*GetUseHostClipboard)(IConsole *pThis, PRBool *useHostClipboard);
    nsresult (*SetUseHostClipboard)(IConsole *pThis, PRBool useHostClipboard);

    nsresult (*GetEmulatedUSB)(IConsole *pThis, IEmulatedUSB * *emulatedUSB);

    nsresult (*GetInternalAndReservedAttribute1IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*PowerUp)(
        IConsole *pThis,
        IProgress * * progress
    );

    nsresult (*PowerUpPaused)(
        IConsole *pThis,
        IProgress * * progress
    );

    nsresult (*PowerDown)(
        IConsole *pThis,
        IProgress * * progress
    );

    nsresult (*Reset)(IConsole *pThis );

    nsresult (*Pause)(IConsole *pThis );

    nsresult (*Resume)(IConsole *pThis );

    nsresult (*PowerButton)(IConsole *pThis );

    nsresult (*SleepButton)(IConsole *pThis );

    nsresult (*GetPowerButtonHandled)(
        IConsole *pThis,
        PRBool * handled
    );

    nsresult (*GetGuestEnteredACPIMode)(
        IConsole *pThis,
        PRBool * entered
    );

    nsresult (*GetDeviceActivity)(
        IConsole *pThis,
        PRUint32 typeSize,
        PRUint32* type,
        PRUint32 *activitySize,
        PRUint32** activity
    );

    nsresult (*AttachUSBDevice)(
        IConsole *pThis,
        PRUnichar * id,
        PRUnichar * captureFilename
    );

    nsresult (*DetachUSBDevice)(
        IConsole *pThis,
        PRUnichar * id,
        IUSBDevice * * device
    );

    nsresult (*FindUSBDeviceByAddress)(
        IConsole *pThis,
        PRUnichar * name,
        IUSBDevice * * device
    );

    nsresult (*FindUSBDeviceById)(
        IConsole *pThis,
        PRUnichar * id,
        IUSBDevice * * device
    );

    nsresult (*CreateSharedFolder)(
        IConsole *pThis,
        PRUnichar * name,
        PRUnichar * hostPath,
        PRBool writable,
        PRBool automount,
        PRUnichar * autoMountPoint
    );

    nsresult (*RemoveSharedFolder)(
        IConsole *pThis,
        PRUnichar * name
    );

    nsresult (*Teleport)(
        IConsole *pThis,
        PRUnichar * hostname,
        PRUint32 tcpport,
        PRUnichar * password,
        PRUint32 maxDowntime,
        IProgress * * progress
    );

    nsresult (*AddEncryptionPassword)(
        IConsole *pThis,
        PRUnichar * id,
        PRUnichar * password,
        PRBool clearOnSuspend
    );

    nsresult (*AddEncryptionPasswords)(
        IConsole *pThis,
        PRUint32 idsSize,
        PRUnichar ** ids,
        PRUint32 passwordsSize,
        PRUnichar ** passwords,
        PRBool clearOnSuspend
    );

    nsresult (*RemoveEncryptionPassword)(
        IConsole *pThis,
        PRUnichar * id
    );

    nsresult (*ClearAllEncryptionPasswords)(IConsole *pThis );

    nsresult (*InternalAndReservedMethod1IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod2IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod3IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod4IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod5IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod6IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod7IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod8IConsole)(IConsole *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IConsoleVtbl
{
    nsresult (*QueryInterface)(IConsole *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IConsole *pThis);
    nsrefcnt (*Release)(IConsole *pThis);
    nsresult (*GetMachine)(IConsole *pThis, IMachine * *machine);

    nsresult (*GetState)(IConsole *pThis, PRUint32 *state);

    nsresult (*GetGuest)(IConsole *pThis, IGuest * *guest);

    nsresult (*GetKeyboard)(IConsole *pThis, IKeyboard * *keyboard);

    nsresult (*GetMouse)(IConsole *pThis, IMouse * *mouse);

    nsresult (*GetDisplay)(IConsole *pThis, IDisplay * *display);

    nsresult (*GetDebugger)(IConsole *pThis, IMachineDebugger * *debugger);

    nsresult (*GetUSBDevices)(IConsole *pThis, PRUint32 *USBDevicesSize, IUSBDevice * **USBDevices);

    nsresult (*GetRemoteUSBDevices)(IConsole *pThis, PRUint32 *remoteUSBDevicesSize, IHostUSBDevice * **remoteUSBDevices);

    nsresult (*GetSharedFolders)(IConsole *pThis, PRUint32 *sharedFoldersSize, ISharedFolder * **sharedFolders);

    nsresult (*GetVRDEServerInfo)(IConsole *pThis, IVRDEServerInfo * *VRDEServerInfo);

    nsresult (*GetEventSource)(IConsole *pThis, IEventSource * *eventSource);

    nsresult (*GetAttachedPCIDevices)(IConsole *pThis, PRUint32 *attachedPCIDevicesSize, IPCIDeviceAttachment * **attachedPCIDevices);

    nsresult (*GetUseHostClipboard)(IConsole *pThis, PRBool *useHostClipboard);
    nsresult (*SetUseHostClipboard)(IConsole *pThis, PRBool useHostClipboard);

    nsresult (*GetEmulatedUSB)(IConsole *pThis, IEmulatedUSB * *emulatedUSB);

    nsresult (*GetInternalAndReservedAttribute1IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IConsole)(IConsole *pThis, PRUint32 *reserved);

    nsresult (*PowerUp)(
        IConsole *pThis,
        IProgress * * progress
    );

    nsresult (*PowerUpPaused)(
        IConsole *pThis,
        IProgress * * progress
    );

    nsresult (*PowerDown)(
        IConsole *pThis,
        IProgress * * progress
    );

    nsresult (*Reset)(IConsole *pThis );

    nsresult (*Pause)(IConsole *pThis );

    nsresult (*Resume)(IConsole *pThis );

    nsresult (*PowerButton)(IConsole *pThis );

    nsresult (*SleepButton)(IConsole *pThis );

    nsresult (*GetPowerButtonHandled)(
        IConsole *pThis,
        PRBool * handled
    );

    nsresult (*GetGuestEnteredACPIMode)(
        IConsole *pThis,
        PRBool * entered
    );

    nsresult (*GetDeviceActivity)(
        IConsole *pThis,
        PRUint32 typeSize,
        PRUint32* type,
        PRUint32 *activitySize,
        PRUint32** activity
    );

    nsresult (*AttachUSBDevice)(
        IConsole *pThis,
        PRUnichar * id,
        PRUnichar * captureFilename
    );

    nsresult (*DetachUSBDevice)(
        IConsole *pThis,
        PRUnichar * id,
        IUSBDevice * * device
    );

    nsresult (*FindUSBDeviceByAddress)(
        IConsole *pThis,
        PRUnichar * name,
        IUSBDevice * * device
    );

    nsresult (*FindUSBDeviceById)(
        IConsole *pThis,
        PRUnichar * id,
        IUSBDevice * * device
    );

    nsresult (*CreateSharedFolder)(
        IConsole *pThis,
        PRUnichar * name,
        PRUnichar * hostPath,
        PRBool writable,
        PRBool automount,
        PRUnichar * autoMountPoint
    );

    nsresult (*RemoveSharedFolder)(
        IConsole *pThis,
        PRUnichar * name
    );

    nsresult (*Teleport)(
        IConsole *pThis,
        PRUnichar * hostname,
        PRUint32 tcpport,
        PRUnichar * password,
        PRUint32 maxDowntime,
        IProgress * * progress
    );

    nsresult (*AddEncryptionPassword)(
        IConsole *pThis,
        PRUnichar * id,
        PRUnichar * password,
        PRBool clearOnSuspend
    );

    nsresult (*AddEncryptionPasswords)(
        IConsole *pThis,
        PRUint32 idsSize,
        PRUnichar ** ids,
        PRUint32 passwordsSize,
        PRUnichar ** passwords,
        PRBool clearOnSuspend
    );

    nsresult (*RemoveEncryptionPassword)(
        IConsole *pThis,
        PRUnichar * id
    );

    nsresult (*ClearAllEncryptionPasswords)(IConsole *pThis );

    nsresult (*InternalAndReservedMethod1IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod2IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod3IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod4IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod5IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod6IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod7IConsole)(IConsole *pThis);

    nsresult (*InternalAndReservedMethod8IConsole)(IConsole *pThis);

};
#define IConsole_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IConsole_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IConsole_Release(p) ((p)->lpVtbl->Release(p))
#define IConsole_get_Machine(p, aMachine) ((p)->lpVtbl->GetMachine(p, aMachine))
#define IConsole_GetMachine(p, aMachine) ((p)->lpVtbl->GetMachine(p, aMachine))
#define IConsole_get_State(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IConsole_GetState(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IConsole_get_Guest(p, aGuest) ((p)->lpVtbl->GetGuest(p, aGuest))
#define IConsole_GetGuest(p, aGuest) ((p)->lpVtbl->GetGuest(p, aGuest))
#define IConsole_get_Keyboard(p, aKeyboard) ((p)->lpVtbl->GetKeyboard(p, aKeyboard))
#define IConsole_GetKeyboard(p, aKeyboard) ((p)->lpVtbl->GetKeyboard(p, aKeyboard))
#define IConsole_get_Mouse(p, aMouse) ((p)->lpVtbl->GetMouse(p, aMouse))
#define IConsole_GetMouse(p, aMouse) ((p)->lpVtbl->GetMouse(p, aMouse))
#define IConsole_get_Display(p, aDisplay) ((p)->lpVtbl->GetDisplay(p, aDisplay))
#define IConsole_GetDisplay(p, aDisplay) ((p)->lpVtbl->GetDisplay(p, aDisplay))
#define IConsole_get_Debugger(p, aDebugger) ((p)->lpVtbl->GetDebugger(p, aDebugger))
#define IConsole_GetDebugger(p, aDebugger) ((p)->lpVtbl->GetDebugger(p, aDebugger))
#define IConsole_get_USBDevices(p, aUSBDevices) ((p)->lpVtbl->GetUSBDevices(p, aUSBDevices))
#define IConsole_GetUSBDevices(p, aUSBDevices) ((p)->lpVtbl->GetUSBDevices(p, aUSBDevices))
#define IConsole_get_RemoteUSBDevices(p, aRemoteUSBDevices) ((p)->lpVtbl->GetRemoteUSBDevices(p, aRemoteUSBDevices))
#define IConsole_GetRemoteUSBDevices(p, aRemoteUSBDevices) ((p)->lpVtbl->GetRemoteUSBDevices(p, aRemoteUSBDevices))
#define IConsole_get_SharedFolders(p, aSharedFolders) ((p)->lpVtbl->GetSharedFolders(p, aSharedFolders))
#define IConsole_GetSharedFolders(p, aSharedFolders) ((p)->lpVtbl->GetSharedFolders(p, aSharedFolders))
#define IConsole_get_VRDEServerInfo(p, aVRDEServerInfo) ((p)->lpVtbl->GetVRDEServerInfo(p, aVRDEServerInfo))
#define IConsole_GetVRDEServerInfo(p, aVRDEServerInfo) ((p)->lpVtbl->GetVRDEServerInfo(p, aVRDEServerInfo))
#define IConsole_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IConsole_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IConsole_get_AttachedPCIDevices(p, aAttachedPCIDevices) ((p)->lpVtbl->GetAttachedPCIDevices(p, aAttachedPCIDevices))
#define IConsole_GetAttachedPCIDevices(p, aAttachedPCIDevices) ((p)->lpVtbl->GetAttachedPCIDevices(p, aAttachedPCIDevices))
#define IConsole_get_UseHostClipboard(p, aUseHostClipboard) ((p)->lpVtbl->GetUseHostClipboard(p, aUseHostClipboard))
#define IConsole_GetUseHostClipboard(p, aUseHostClipboard) ((p)->lpVtbl->GetUseHostClipboard(p, aUseHostClipboard))
#define IConsole_put_UseHostClipboard(p, aUseHostClipboard) ((p)->lpVtbl->SetUseHostClipboard(p, aUseHostClipboard))
#define IConsole_SetUseHostClipboard(p, aUseHostClipboard) ((p)->lpVtbl->SetUseHostClipboard(p, aUseHostClipboard))
#define IConsole_get_EmulatedUSB(p, aEmulatedUSB) ((p)->lpVtbl->GetEmulatedUSB(p, aEmulatedUSB))
#define IConsole_GetEmulatedUSB(p, aEmulatedUSB) ((p)->lpVtbl->GetEmulatedUSB(p, aEmulatedUSB))
#define IConsole_PowerUp(p, aProgress) ((p)->lpVtbl->PowerUp(p, aProgress))
#define IConsole_PowerUpPaused(p, aProgress) ((p)->lpVtbl->PowerUpPaused(p, aProgress))
#define IConsole_PowerDown(p, aProgress) ((p)->lpVtbl->PowerDown(p, aProgress))
#define IConsole_Reset(p) ((p)->lpVtbl->Reset(p))
#define IConsole_Pause(p) ((p)->lpVtbl->Pause(p))
#define IConsole_Resume(p) ((p)->lpVtbl->Resume(p))
#define IConsole_PowerButton(p) ((p)->lpVtbl->PowerButton(p))
#define IConsole_SleepButton(p) ((p)->lpVtbl->SleepButton(p))
#define IConsole_GetPowerButtonHandled(p, aHandled) ((p)->lpVtbl->GetPowerButtonHandled(p, aHandled))
#define IConsole_GetGuestEnteredACPIMode(p, aEntered) ((p)->lpVtbl->GetGuestEnteredACPIMode(p, aEntered))
#define IConsole_GetDeviceActivity(p, aType, aActivity) ((p)->lpVtbl->GetDeviceActivity(p, aType, aActivity))
#define IConsole_AttachUSBDevice(p, aId, aCaptureFilename) ((p)->lpVtbl->AttachUSBDevice(p, aId, aCaptureFilename))
#define IConsole_DetachUSBDevice(p, aId, aDevice) ((p)->lpVtbl->DetachUSBDevice(p, aId, aDevice))
#define IConsole_FindUSBDeviceByAddress(p, aName, aDevice) ((p)->lpVtbl->FindUSBDeviceByAddress(p, aName, aDevice))
#define IConsole_FindUSBDeviceById(p, aId, aDevice) ((p)->lpVtbl->FindUSBDeviceById(p, aId, aDevice))
#define IConsole_CreateSharedFolder(p, aName, aHostPath, aWritable, aAutomount, aAutoMountPoint) ((p)->lpVtbl->CreateSharedFolder(p, aName, aHostPath, aWritable, aAutomount, aAutoMountPoint))
#define IConsole_RemoveSharedFolder(p, aName) ((p)->lpVtbl->RemoveSharedFolder(p, aName))
#define IConsole_Teleport(p, aHostname, aTcpport, aPassword, aMaxDowntime, aProgress) ((p)->lpVtbl->Teleport(p, aHostname, aTcpport, aPassword, aMaxDowntime, aProgress))
#define IConsole_AddEncryptionPassword(p, aId, aPassword, aClearOnSuspend) ((p)->lpVtbl->AddEncryptionPassword(p, aId, aPassword, aClearOnSuspend))
#define IConsole_AddEncryptionPasswords(p, aIds, aPasswords, aClearOnSuspend) ((p)->lpVtbl->AddEncryptionPasswords(p, aIds, aPasswords, aClearOnSuspend))
#define IConsole_RemoveEncryptionPassword(p, aId) ((p)->lpVtbl->RemoveEncryptionPassword(p, aId))
#define IConsole_ClearAllEncryptionPasswords(p) ((p)->lpVtbl->ClearAllEncryptionPasswords(p))
#endif /* VBOX_WITH_GLUE */

interface IConsole
{
#ifndef VBOX_WITH_GLUE
    struct IConsole_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IConsoleVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IConsole declaration */


/* Start of struct IHostNetworkInterface declaration */
#define IHOSTNETWORKINTERFACE_IID_STR "455f8c45-44a0-a470-ba20-27890b96dba9"
#define IHOSTNETWORKINTERFACE_IID { \
    0x455f8c45, 0x44a0, 0xa470, \
    { 0xba, 0x20, 0x27, 0x89, 0x0b, 0x96, 0xdb, 0xa9 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IHostNetworkInterface);
#ifndef VBOX_WITH_GLUE
struct IHostNetworkInterface_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetName)(IHostNetworkInterface *pThis, PRUnichar * *name);

    nsresult (*GetShortName)(IHostNetworkInterface *pThis, PRUnichar * *shortName);

    nsresult (*GetId)(IHostNetworkInterface *pThis, PRUnichar * *id);

    nsresult (*GetNetworkName)(IHostNetworkInterface *pThis, PRUnichar * *networkName);

    nsresult (*GetDHCPEnabled)(IHostNetworkInterface *pThis, PRBool *DHCPEnabled);

    nsresult (*GetIPAddress)(IHostNetworkInterface *pThis, PRUnichar * *IPAddress);

    nsresult (*GetNetworkMask)(IHostNetworkInterface *pThis, PRUnichar * *networkMask);

    nsresult (*GetIPV6Supported)(IHostNetworkInterface *pThis, PRBool *IPV6Supported);

    nsresult (*GetIPV6Address)(IHostNetworkInterface *pThis, PRUnichar * *IPV6Address);

    nsresult (*GetIPV6NetworkMaskPrefixLength)(IHostNetworkInterface *pThis, PRUint32 *IPV6NetworkMaskPrefixLength);

    nsresult (*GetHardwareAddress)(IHostNetworkInterface *pThis, PRUnichar * *hardwareAddress);

    nsresult (*GetMediumType)(IHostNetworkInterface *pThis, PRUint32 *mediumType);

    nsresult (*GetStatus)(IHostNetworkInterface *pThis, PRUint32 *status);

    nsresult (*GetInterfaceType)(IHostNetworkInterface *pThis, PRUint32 *interfaceType);

    nsresult (*GetWireless)(IHostNetworkInterface *pThis, PRBool *wireless);

    nsresult (*GetInternalAndReservedAttribute1IHostNetworkInterface)(IHostNetworkInterface *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostNetworkInterface)(IHostNetworkInterface *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostNetworkInterface)(IHostNetworkInterface *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostNetworkInterface)(IHostNetworkInterface *pThis, PRUint32 *reserved);

    nsresult (*EnableStaticIPConfig)(
        IHostNetworkInterface *pThis,
        PRUnichar * IPAddress,
        PRUnichar * networkMask
    );

    nsresult (*EnableStaticIPConfigV6)(
        IHostNetworkInterface *pThis,
        PRUnichar * IPV6Address,
        PRUint32 IPV6NetworkMaskPrefixLength
    );

    nsresult (*EnableDynamicIPConfig)(IHostNetworkInterface *pThis );

    nsresult (*DHCPRediscover)(IHostNetworkInterface *pThis );

    nsresult (*InternalAndReservedMethod1IHostNetworkInterface)(IHostNetworkInterface *pThis);

    nsresult (*InternalAndReservedMethod2IHostNetworkInterface)(IHostNetworkInterface *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IHostNetworkInterfaceVtbl
{
    nsresult (*QueryInterface)(IHostNetworkInterface *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IHostNetworkInterface *pThis);
    nsrefcnt (*Release)(IHostNetworkInterface *pThis);
    nsresult (*GetName)(IHostNetworkInterface *pThis, PRUnichar * *name);

    nsresult (*GetShortName)(IHostNetworkInterface *pThis, PRUnichar * *shortName);

    nsresult (*GetId)(IHostNetworkInterface *pThis, PRUnichar * *id);

    nsresult (*GetNetworkName)(IHostNetworkInterface *pThis, PRUnichar * *networkName);

    nsresult (*GetDHCPEnabled)(IHostNetworkInterface *pThis, PRBool *DHCPEnabled);

    nsresult (*GetIPAddress)(IHostNetworkInterface *pThis, PRUnichar * *IPAddress);

    nsresult (*GetNetworkMask)(IHostNetworkInterface *pThis, PRUnichar * *networkMask);

    nsresult (*GetIPV6Supported)(IHostNetworkInterface *pThis, PRBool *IPV6Supported);

    nsresult (*GetIPV6Address)(IHostNetworkInterface *pThis, PRUnichar * *IPV6Address);

    nsresult (*GetIPV6NetworkMaskPrefixLength)(IHostNetworkInterface *pThis, PRUint32 *IPV6NetworkMaskPrefixLength);

    nsresult (*GetHardwareAddress)(IHostNetworkInterface *pThis, PRUnichar * *hardwareAddress);

    nsresult (*GetMediumType)(IHostNetworkInterface *pThis, PRUint32 *mediumType);

    nsresult (*GetStatus)(IHostNetworkInterface *pThis, PRUint32 *status);

    nsresult (*GetInterfaceType)(IHostNetworkInterface *pThis, PRUint32 *interfaceType);

    nsresult (*GetWireless)(IHostNetworkInterface *pThis, PRBool *wireless);

    nsresult (*GetInternalAndReservedAttribute1IHostNetworkInterface)(IHostNetworkInterface *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostNetworkInterface)(IHostNetworkInterface *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostNetworkInterface)(IHostNetworkInterface *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostNetworkInterface)(IHostNetworkInterface *pThis, PRUint32 *reserved);

    nsresult (*EnableStaticIPConfig)(
        IHostNetworkInterface *pThis,
        PRUnichar * IPAddress,
        PRUnichar * networkMask
    );

    nsresult (*EnableStaticIPConfigV6)(
        IHostNetworkInterface *pThis,
        PRUnichar * IPV6Address,
        PRUint32 IPV6NetworkMaskPrefixLength
    );

    nsresult (*EnableDynamicIPConfig)(IHostNetworkInterface *pThis );

    nsresult (*DHCPRediscover)(IHostNetworkInterface *pThis );

    nsresult (*InternalAndReservedMethod1IHostNetworkInterface)(IHostNetworkInterface *pThis);

    nsresult (*InternalAndReservedMethod2IHostNetworkInterface)(IHostNetworkInterface *pThis);

};
#define IHostNetworkInterface_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IHostNetworkInterface_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IHostNetworkInterface_Release(p) ((p)->lpVtbl->Release(p))
#define IHostNetworkInterface_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IHostNetworkInterface_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IHostNetworkInterface_get_ShortName(p, aShortName) ((p)->lpVtbl->GetShortName(p, aShortName))
#define IHostNetworkInterface_GetShortName(p, aShortName) ((p)->lpVtbl->GetShortName(p, aShortName))
#define IHostNetworkInterface_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IHostNetworkInterface_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IHostNetworkInterface_get_NetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define IHostNetworkInterface_GetNetworkName(p, aNetworkName) ((p)->lpVtbl->GetNetworkName(p, aNetworkName))
#define IHostNetworkInterface_get_DHCPEnabled(p, aDHCPEnabled) ((p)->lpVtbl->GetDHCPEnabled(p, aDHCPEnabled))
#define IHostNetworkInterface_GetDHCPEnabled(p, aDHCPEnabled) ((p)->lpVtbl->GetDHCPEnabled(p, aDHCPEnabled))
#define IHostNetworkInterface_get_IPAddress(p, aIPAddress) ((p)->lpVtbl->GetIPAddress(p, aIPAddress))
#define IHostNetworkInterface_GetIPAddress(p, aIPAddress) ((p)->lpVtbl->GetIPAddress(p, aIPAddress))
#define IHostNetworkInterface_get_NetworkMask(p, aNetworkMask) ((p)->lpVtbl->GetNetworkMask(p, aNetworkMask))
#define IHostNetworkInterface_GetNetworkMask(p, aNetworkMask) ((p)->lpVtbl->GetNetworkMask(p, aNetworkMask))
#define IHostNetworkInterface_get_IPV6Supported(p, aIPV6Supported) ((p)->lpVtbl->GetIPV6Supported(p, aIPV6Supported))
#define IHostNetworkInterface_GetIPV6Supported(p, aIPV6Supported) ((p)->lpVtbl->GetIPV6Supported(p, aIPV6Supported))
#define IHostNetworkInterface_get_IPV6Address(p, aIPV6Address) ((p)->lpVtbl->GetIPV6Address(p, aIPV6Address))
#define IHostNetworkInterface_GetIPV6Address(p, aIPV6Address) ((p)->lpVtbl->GetIPV6Address(p, aIPV6Address))
#define IHostNetworkInterface_get_IPV6NetworkMaskPrefixLength(p, aIPV6NetworkMaskPrefixLength) ((p)->lpVtbl->GetIPV6NetworkMaskPrefixLength(p, aIPV6NetworkMaskPrefixLength))
#define IHostNetworkInterface_GetIPV6NetworkMaskPrefixLength(p, aIPV6NetworkMaskPrefixLength) ((p)->lpVtbl->GetIPV6NetworkMaskPrefixLength(p, aIPV6NetworkMaskPrefixLength))
#define IHostNetworkInterface_get_HardwareAddress(p, aHardwareAddress) ((p)->lpVtbl->GetHardwareAddress(p, aHardwareAddress))
#define IHostNetworkInterface_GetHardwareAddress(p, aHardwareAddress) ((p)->lpVtbl->GetHardwareAddress(p, aHardwareAddress))
#define IHostNetworkInterface_get_MediumType(p, aMediumType) ((p)->lpVtbl->GetMediumType(p, aMediumType))
#define IHostNetworkInterface_GetMediumType(p, aMediumType) ((p)->lpVtbl->GetMediumType(p, aMediumType))
#define IHostNetworkInterface_get_Status(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IHostNetworkInterface_GetStatus(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IHostNetworkInterface_get_InterfaceType(p, aInterfaceType) ((p)->lpVtbl->GetInterfaceType(p, aInterfaceType))
#define IHostNetworkInterface_GetInterfaceType(p, aInterfaceType) ((p)->lpVtbl->GetInterfaceType(p, aInterfaceType))
#define IHostNetworkInterface_get_Wireless(p, aWireless) ((p)->lpVtbl->GetWireless(p, aWireless))
#define IHostNetworkInterface_GetWireless(p, aWireless) ((p)->lpVtbl->GetWireless(p, aWireless))
#define IHostNetworkInterface_EnableStaticIPConfig(p, aIPAddress, aNetworkMask) ((p)->lpVtbl->EnableStaticIPConfig(p, aIPAddress, aNetworkMask))
#define IHostNetworkInterface_EnableStaticIPConfigV6(p, aIPV6Address, aIPV6NetworkMaskPrefixLength) ((p)->lpVtbl->EnableStaticIPConfigV6(p, aIPV6Address, aIPV6NetworkMaskPrefixLength))
#define IHostNetworkInterface_EnableDynamicIPConfig(p) ((p)->lpVtbl->EnableDynamicIPConfig(p))
#define IHostNetworkInterface_DHCPRediscover(p) ((p)->lpVtbl->DHCPRediscover(p))
#endif /* VBOX_WITH_GLUE */

interface IHostNetworkInterface
{
#ifndef VBOX_WITH_GLUE
    struct IHostNetworkInterface_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IHostNetworkInterfaceVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IHostNetworkInterface declaration */


/* Start of struct IHostVideoInputDevice declaration */
#define IHOSTVIDEOINPUTDEVICE_IID_STR "e8c25d4d-ac97-4c16-b3e2-81bd8a57cc27"
#define IHOSTVIDEOINPUTDEVICE_IID { \
    0xe8c25d4d, 0xac97, 0x4c16, \
    { 0xb3, 0xe2, 0x81, 0xbd, 0x8a, 0x57, 0xcc, 0x27 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IHostVideoInputDevice);
#ifndef VBOX_WITH_GLUE
struct IHostVideoInputDevice_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetName)(IHostVideoInputDevice *pThis, PRUnichar * *name);

    nsresult (*GetPath)(IHostVideoInputDevice *pThis, PRUnichar * *path);

    nsresult (*GetAlias)(IHostVideoInputDevice *pThis, PRUnichar * *alias);

    nsresult (*GetInternalAndReservedAttribute1IHostVideoInputDevice)(IHostVideoInputDevice *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostVideoInputDevice)(IHostVideoInputDevice *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostVideoInputDevice)(IHostVideoInputDevice *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostVideoInputDevice)(IHostVideoInputDevice *pThis, PRUint32 *reserved);

};
#else /* VBOX_WITH_GLUE */
struct IHostVideoInputDeviceVtbl
{
    nsresult (*QueryInterface)(IHostVideoInputDevice *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IHostVideoInputDevice *pThis);
    nsrefcnt (*Release)(IHostVideoInputDevice *pThis);
    nsresult (*GetName)(IHostVideoInputDevice *pThis, PRUnichar * *name);

    nsresult (*GetPath)(IHostVideoInputDevice *pThis, PRUnichar * *path);

    nsresult (*GetAlias)(IHostVideoInputDevice *pThis, PRUnichar * *alias);

    nsresult (*GetInternalAndReservedAttribute1IHostVideoInputDevice)(IHostVideoInputDevice *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostVideoInputDevice)(IHostVideoInputDevice *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostVideoInputDevice)(IHostVideoInputDevice *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostVideoInputDevice)(IHostVideoInputDevice *pThis, PRUint32 *reserved);

};
#define IHostVideoInputDevice_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IHostVideoInputDevice_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IHostVideoInputDevice_Release(p) ((p)->lpVtbl->Release(p))
#define IHostVideoInputDevice_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IHostVideoInputDevice_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IHostVideoInputDevice_get_Path(p, aPath) ((p)->lpVtbl->GetPath(p, aPath))
#define IHostVideoInputDevice_GetPath(p, aPath) ((p)->lpVtbl->GetPath(p, aPath))
#define IHostVideoInputDevice_get_Alias(p, aAlias) ((p)->lpVtbl->GetAlias(p, aAlias))
#define IHostVideoInputDevice_GetAlias(p, aAlias) ((p)->lpVtbl->GetAlias(p, aAlias))
#endif /* VBOX_WITH_GLUE */

interface IHostVideoInputDevice
{
#ifndef VBOX_WITH_GLUE
    struct IHostVideoInputDevice_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IHostVideoInputDeviceVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IHostVideoInputDevice declaration */


/* Start of struct IUpdateAgent declaration */
#define IUPDATEAGENT_IID_STR "c4b1b5f4-8cdf-4923-9ef6-b92476a84109"
#define IUPDATEAGENT_IID { \
    0xc4b1b5f4, 0x8cdf, 0x4923, \
    { 0x9e, 0xf6, 0xb9, 0x24, 0x76, 0xa8, 0x41, 0x09 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IUpdateAgent);
#ifndef VBOX_WITH_GLUE
struct IUpdateAgent_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetName)(IUpdateAgent *pThis, PRUnichar * *name);

    nsresult (*GetEventSource)(IUpdateAgent *pThis, IEventSource * *eventSource);

    nsresult (*GetOrder)(IUpdateAgent *pThis, PRUint32 *order);

    nsresult (*GetDependsOn)(IUpdateAgent *pThis, PRUint32 *dependsOnSize, PRUnichar * **dependsOn);

    nsresult (*GetVersion)(IUpdateAgent *pThis, PRUnichar * *version);

    nsresult (*GetDownloadUrl)(IUpdateAgent *pThis, PRUnichar * *downloadUrl);

    nsresult (*GetWebUrl)(IUpdateAgent *pThis, PRUnichar * *webUrl);

    nsresult (*GetReleaseNotes)(IUpdateAgent *pThis, PRUnichar * *releaseNotes);

    nsresult (*GetEnabled)(IUpdateAgent *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IUpdateAgent *pThis, PRBool enabled);

    nsresult (*GetHidden)(IUpdateAgent *pThis, PRBool *hidden);

    nsresult (*GetState)(IUpdateAgent *pThis, PRUint32 *state);

    nsresult (*GetCheckFrequency)(IUpdateAgent *pThis, PRUint32 *checkFrequency);
    nsresult (*SetCheckFrequency)(IUpdateAgent *pThis, PRUint32 checkFrequency);

    nsresult (*GetChannel)(IUpdateAgent *pThis, PRUint32 *channel);
    nsresult (*SetChannel)(IUpdateAgent *pThis, PRUint32 channel);

    nsresult (*GetRepositoryURL)(IUpdateAgent *pThis, PRUnichar * *repositoryURL);
    nsresult (*SetRepositoryURL)(IUpdateAgent *pThis, PRUnichar * repositoryURL);

    nsresult (*GetLastCheckDate)(IUpdateAgent *pThis, PRUnichar * *lastCheckDate);

    nsresult (*GetCheckCount)(IUpdateAgent *pThis, PRUint32 *checkCount);

    nsresult (*GetIsCheckNeeded)(IUpdateAgent *pThis, PRBool *isCheckNeeded);

    nsresult (*GetSupportedChannels)(IUpdateAgent *pThis, PRUint32 *supportedChannelsSize, PRUint32 **supportedChannels);

    nsresult (*GetInternalAndReservedAttribute1IUpdateAgent)(IUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IUpdateAgent)(IUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IUpdateAgent)(IUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IUpdateAgent)(IUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*CheckFor)(
        IUpdateAgent *pThis,
        IProgress * * progress
    );

    nsresult (*Download)(
        IUpdateAgent *pThis,
        IProgress * * progress
    );

    nsresult (*Install)(
        IUpdateAgent *pThis,
        IProgress * * progress
    );

    nsresult (*Rollback)(IUpdateAgent *pThis );

    nsresult (*InternalAndReservedMethod1IUpdateAgent)(IUpdateAgent *pThis);

    nsresult (*InternalAndReservedMethod2IUpdateAgent)(IUpdateAgent *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IUpdateAgentVtbl
{
    nsresult (*QueryInterface)(IUpdateAgent *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IUpdateAgent *pThis);
    nsrefcnt (*Release)(IUpdateAgent *pThis);
    nsresult (*GetName)(IUpdateAgent *pThis, PRUnichar * *name);

    nsresult (*GetEventSource)(IUpdateAgent *pThis, IEventSource * *eventSource);

    nsresult (*GetOrder)(IUpdateAgent *pThis, PRUint32 *order);

    nsresult (*GetDependsOn)(IUpdateAgent *pThis, PRUint32 *dependsOnSize, PRUnichar * **dependsOn);

    nsresult (*GetVersion)(IUpdateAgent *pThis, PRUnichar * *version);

    nsresult (*GetDownloadUrl)(IUpdateAgent *pThis, PRUnichar * *downloadUrl);

    nsresult (*GetWebUrl)(IUpdateAgent *pThis, PRUnichar * *webUrl);

    nsresult (*GetReleaseNotes)(IUpdateAgent *pThis, PRUnichar * *releaseNotes);

    nsresult (*GetEnabled)(IUpdateAgent *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IUpdateAgent *pThis, PRBool enabled);

    nsresult (*GetHidden)(IUpdateAgent *pThis, PRBool *hidden);

    nsresult (*GetState)(IUpdateAgent *pThis, PRUint32 *state);

    nsresult (*GetCheckFrequency)(IUpdateAgent *pThis, PRUint32 *checkFrequency);
    nsresult (*SetCheckFrequency)(IUpdateAgent *pThis, PRUint32 checkFrequency);

    nsresult (*GetChannel)(IUpdateAgent *pThis, PRUint32 *channel);
    nsresult (*SetChannel)(IUpdateAgent *pThis, PRUint32 channel);

    nsresult (*GetRepositoryURL)(IUpdateAgent *pThis, PRUnichar * *repositoryURL);
    nsresult (*SetRepositoryURL)(IUpdateAgent *pThis, PRUnichar * repositoryURL);

    nsresult (*GetLastCheckDate)(IUpdateAgent *pThis, PRUnichar * *lastCheckDate);

    nsresult (*GetCheckCount)(IUpdateAgent *pThis, PRUint32 *checkCount);

    nsresult (*GetIsCheckNeeded)(IUpdateAgent *pThis, PRBool *isCheckNeeded);

    nsresult (*GetSupportedChannels)(IUpdateAgent *pThis, PRUint32 *supportedChannelsSize, PRUint32 **supportedChannels);

    nsresult (*GetInternalAndReservedAttribute1IUpdateAgent)(IUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IUpdateAgent)(IUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IUpdateAgent)(IUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IUpdateAgent)(IUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*CheckFor)(
        IUpdateAgent *pThis,
        IProgress * * progress
    );

    nsresult (*Download)(
        IUpdateAgent *pThis,
        IProgress * * progress
    );

    nsresult (*Install)(
        IUpdateAgent *pThis,
        IProgress * * progress
    );

    nsresult (*Rollback)(IUpdateAgent *pThis );

    nsresult (*InternalAndReservedMethod1IUpdateAgent)(IUpdateAgent *pThis);

    nsresult (*InternalAndReservedMethod2IUpdateAgent)(IUpdateAgent *pThis);

};
#define IUpdateAgent_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IUpdateAgent_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IUpdateAgent_Release(p) ((p)->lpVtbl->Release(p))
#define IUpdateAgent_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IUpdateAgent_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IUpdateAgent_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IUpdateAgent_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IUpdateAgent_get_Order(p, aOrder) ((p)->lpVtbl->GetOrder(p, aOrder))
#define IUpdateAgent_GetOrder(p, aOrder) ((p)->lpVtbl->GetOrder(p, aOrder))
#define IUpdateAgent_get_DependsOn(p, aDependsOn) ((p)->lpVtbl->GetDependsOn(p, aDependsOn))
#define IUpdateAgent_GetDependsOn(p, aDependsOn) ((p)->lpVtbl->GetDependsOn(p, aDependsOn))
#define IUpdateAgent_get_Version(p, aVersion) ((p)->lpVtbl->GetVersion(p, aVersion))
#define IUpdateAgent_GetVersion(p, aVersion) ((p)->lpVtbl->GetVersion(p, aVersion))
#define IUpdateAgent_get_DownloadUrl(p, aDownloadUrl) ((p)->lpVtbl->GetDownloadUrl(p, aDownloadUrl))
#define IUpdateAgent_GetDownloadUrl(p, aDownloadUrl) ((p)->lpVtbl->GetDownloadUrl(p, aDownloadUrl))
#define IUpdateAgent_get_WebUrl(p, aWebUrl) ((p)->lpVtbl->GetWebUrl(p, aWebUrl))
#define IUpdateAgent_GetWebUrl(p, aWebUrl) ((p)->lpVtbl->GetWebUrl(p, aWebUrl))
#define IUpdateAgent_get_ReleaseNotes(p, aReleaseNotes) ((p)->lpVtbl->GetReleaseNotes(p, aReleaseNotes))
#define IUpdateAgent_GetReleaseNotes(p, aReleaseNotes) ((p)->lpVtbl->GetReleaseNotes(p, aReleaseNotes))
#define IUpdateAgent_get_Enabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IUpdateAgent_GetEnabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IUpdateAgent_put_Enabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IUpdateAgent_SetEnabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IUpdateAgent_get_Hidden(p, aHidden) ((p)->lpVtbl->GetHidden(p, aHidden))
#define IUpdateAgent_GetHidden(p, aHidden) ((p)->lpVtbl->GetHidden(p, aHidden))
#define IUpdateAgent_get_State(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IUpdateAgent_GetState(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IUpdateAgent_get_CheckFrequency(p, aCheckFrequency) ((p)->lpVtbl->GetCheckFrequency(p, aCheckFrequency))
#define IUpdateAgent_GetCheckFrequency(p, aCheckFrequency) ((p)->lpVtbl->GetCheckFrequency(p, aCheckFrequency))
#define IUpdateAgent_put_CheckFrequency(p, aCheckFrequency) ((p)->lpVtbl->SetCheckFrequency(p, aCheckFrequency))
#define IUpdateAgent_SetCheckFrequency(p, aCheckFrequency) ((p)->lpVtbl->SetCheckFrequency(p, aCheckFrequency))
#define IUpdateAgent_get_Channel(p, aChannel) ((p)->lpVtbl->GetChannel(p, aChannel))
#define IUpdateAgent_GetChannel(p, aChannel) ((p)->lpVtbl->GetChannel(p, aChannel))
#define IUpdateAgent_put_Channel(p, aChannel) ((p)->lpVtbl->SetChannel(p, aChannel))
#define IUpdateAgent_SetChannel(p, aChannel) ((p)->lpVtbl->SetChannel(p, aChannel))
#define IUpdateAgent_get_RepositoryURL(p, aRepositoryURL) ((p)->lpVtbl->GetRepositoryURL(p, aRepositoryURL))
#define IUpdateAgent_GetRepositoryURL(p, aRepositoryURL) ((p)->lpVtbl->GetRepositoryURL(p, aRepositoryURL))
#define IUpdateAgent_put_RepositoryURL(p, aRepositoryURL) ((p)->lpVtbl->SetRepositoryURL(p, aRepositoryURL))
#define IUpdateAgent_SetRepositoryURL(p, aRepositoryURL) ((p)->lpVtbl->SetRepositoryURL(p, aRepositoryURL))
#define IUpdateAgent_get_LastCheckDate(p, aLastCheckDate) ((p)->lpVtbl->GetLastCheckDate(p, aLastCheckDate))
#define IUpdateAgent_GetLastCheckDate(p, aLastCheckDate) ((p)->lpVtbl->GetLastCheckDate(p, aLastCheckDate))
#define IUpdateAgent_get_CheckCount(p, aCheckCount) ((p)->lpVtbl->GetCheckCount(p, aCheckCount))
#define IUpdateAgent_GetCheckCount(p, aCheckCount) ((p)->lpVtbl->GetCheckCount(p, aCheckCount))
#define IUpdateAgent_get_IsCheckNeeded(p, aIsCheckNeeded) ((p)->lpVtbl->GetIsCheckNeeded(p, aIsCheckNeeded))
#define IUpdateAgent_GetIsCheckNeeded(p, aIsCheckNeeded) ((p)->lpVtbl->GetIsCheckNeeded(p, aIsCheckNeeded))
#define IUpdateAgent_get_SupportedChannels(p, aSupportedChannels) ((p)->lpVtbl->GetSupportedChannels(p, aSupportedChannels))
#define IUpdateAgent_GetSupportedChannels(p, aSupportedChannels) ((p)->lpVtbl->GetSupportedChannels(p, aSupportedChannels))
#define IUpdateAgent_CheckFor(p, aProgress) ((p)->lpVtbl->CheckFor(p, aProgress))
#define IUpdateAgent_Download(p, aProgress) ((p)->lpVtbl->Download(p, aProgress))
#define IUpdateAgent_Install(p, aProgress) ((p)->lpVtbl->Install(p, aProgress))
#define IUpdateAgent_Rollback(p) ((p)->lpVtbl->Rollback(p))
#endif /* VBOX_WITH_GLUE */

interface IUpdateAgent
{
#ifndef VBOX_WITH_GLUE
    struct IUpdateAgent_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IUpdateAgentVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IUpdateAgent declaration */


/* Start of struct IHostUpdateAgent declaration */
#define IHOSTUPDATEAGENT_IID_STR "d782dba7-cd4f-4ace-951a-58321c23e258"
#define IHOSTUPDATEAGENT_IID { \
    0xd782dba7, 0xcd4f, 0x4ace, \
    { 0x95, 0x1a, 0x58, 0x32, 0x1c, 0x23, 0xe2, 0x58 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IHostUpdateAgent);
#ifndef VBOX_WITH_GLUE
struct IHostUpdateAgent_vtbl
{
    struct IUpdateAgent_vtbl iupdateagent;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IHostUpdateAgent *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

    nsresult (*GetInternalAndReservedAttribute1IHostUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IHostUpdateAgent)(IHostUpdateAgent *pThis);

    nsresult (*InternalAndReservedMethod2IHostUpdateAgent)(IHostUpdateAgent *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IHostUpdateAgentVtbl
{
    nsresult (*QueryInterface)(IHostUpdateAgent *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IHostUpdateAgent *pThis);
    nsrefcnt (*Release)(IHostUpdateAgent *pThis);
    nsresult (*GetName)(IHostUpdateAgent *pThis, PRUnichar * *name);

    nsresult (*GetEventSource)(IHostUpdateAgent *pThis, IEventSource * *eventSource);

    nsresult (*GetOrder)(IHostUpdateAgent *pThis, PRUint32 *order);

    nsresult (*GetDependsOn)(IHostUpdateAgent *pThis, PRUint32 *dependsOnSize, PRUnichar * **dependsOn);

    nsresult (*GetVersion)(IHostUpdateAgent *pThis, PRUnichar * *version);

    nsresult (*GetDownloadUrl)(IHostUpdateAgent *pThis, PRUnichar * *downloadUrl);

    nsresult (*GetWebUrl)(IHostUpdateAgent *pThis, PRUnichar * *webUrl);

    nsresult (*GetReleaseNotes)(IHostUpdateAgent *pThis, PRUnichar * *releaseNotes);

    nsresult (*GetEnabled)(IHostUpdateAgent *pThis, PRBool *enabled);
    nsresult (*SetEnabled)(IHostUpdateAgent *pThis, PRBool enabled);

    nsresult (*GetHidden)(IHostUpdateAgent *pThis, PRBool *hidden);

    nsresult (*GetState)(IHostUpdateAgent *pThis, PRUint32 *state);

    nsresult (*GetCheckFrequency)(IHostUpdateAgent *pThis, PRUint32 *checkFrequency);
    nsresult (*SetCheckFrequency)(IHostUpdateAgent *pThis, PRUint32 checkFrequency);

    nsresult (*GetChannel)(IHostUpdateAgent *pThis, PRUint32 *channel);
    nsresult (*SetChannel)(IHostUpdateAgent *pThis, PRUint32 channel);

    nsresult (*GetRepositoryURL)(IHostUpdateAgent *pThis, PRUnichar * *repositoryURL);
    nsresult (*SetRepositoryURL)(IHostUpdateAgent *pThis, PRUnichar * repositoryURL);

    nsresult (*GetLastCheckDate)(IHostUpdateAgent *pThis, PRUnichar * *lastCheckDate);

    nsresult (*GetCheckCount)(IHostUpdateAgent *pThis, PRUint32 *checkCount);

    nsresult (*GetIsCheckNeeded)(IHostUpdateAgent *pThis, PRBool *isCheckNeeded);

    nsresult (*GetSupportedChannels)(IHostUpdateAgent *pThis, PRUint32 *supportedChannelsSize, PRUint32 **supportedChannels);

    nsresult (*GetInternalAndReservedAttribute1IUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*CheckFor)(
        IHostUpdateAgent *pThis,
        IProgress * * progress
    );

    nsresult (*Download)(
        IHostUpdateAgent *pThis,
        IProgress * * progress
    );

    nsresult (*Install)(
        IHostUpdateAgent *pThis,
        IProgress * * progress
    );

    nsresult (*Rollback)(IHostUpdateAgent *pThis );

    nsresult (*InternalAndReservedMethod1IUpdateAgent)(IHostUpdateAgent *pThis);

    nsresult (*InternalAndReservedMethod2IUpdateAgent)(IHostUpdateAgent *pThis);

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IHostUpdateAgent *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

    nsresult (*GetInternalAndReservedAttribute1IHostUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostUpdateAgent)(IHostUpdateAgent *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1IHostUpdateAgent)(IHostUpdateAgent *pThis);

    nsresult (*InternalAndReservedMethod2IHostUpdateAgent)(IHostUpdateAgent *pThis);

};
#define IHostUpdateAgent_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IHostUpdateAgent_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IHostUpdateAgent_Release(p) ((p)->lpVtbl->Release(p))
#define IHostUpdateAgent_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IHostUpdateAgent_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IHostUpdateAgent_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IHostUpdateAgent_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IHostUpdateAgent_get_Order(p, aOrder) ((p)->lpVtbl->GetOrder(p, aOrder))
#define IHostUpdateAgent_GetOrder(p, aOrder) ((p)->lpVtbl->GetOrder(p, aOrder))
#define IHostUpdateAgent_get_DependsOn(p, aDependsOn) ((p)->lpVtbl->GetDependsOn(p, aDependsOn))
#define IHostUpdateAgent_GetDependsOn(p, aDependsOn) ((p)->lpVtbl->GetDependsOn(p, aDependsOn))
#define IHostUpdateAgent_get_Version(p, aVersion) ((p)->lpVtbl->GetVersion(p, aVersion))
#define IHostUpdateAgent_GetVersion(p, aVersion) ((p)->lpVtbl->GetVersion(p, aVersion))
#define IHostUpdateAgent_get_DownloadUrl(p, aDownloadUrl) ((p)->lpVtbl->GetDownloadUrl(p, aDownloadUrl))
#define IHostUpdateAgent_GetDownloadUrl(p, aDownloadUrl) ((p)->lpVtbl->GetDownloadUrl(p, aDownloadUrl))
#define IHostUpdateAgent_get_WebUrl(p, aWebUrl) ((p)->lpVtbl->GetWebUrl(p, aWebUrl))
#define IHostUpdateAgent_GetWebUrl(p, aWebUrl) ((p)->lpVtbl->GetWebUrl(p, aWebUrl))
#define IHostUpdateAgent_get_ReleaseNotes(p, aReleaseNotes) ((p)->lpVtbl->GetReleaseNotes(p, aReleaseNotes))
#define IHostUpdateAgent_GetReleaseNotes(p, aReleaseNotes) ((p)->lpVtbl->GetReleaseNotes(p, aReleaseNotes))
#define IHostUpdateAgent_get_Enabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IHostUpdateAgent_GetEnabled(p, aEnabled) ((p)->lpVtbl->GetEnabled(p, aEnabled))
#define IHostUpdateAgent_put_Enabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IHostUpdateAgent_SetEnabled(p, aEnabled) ((p)->lpVtbl->SetEnabled(p, aEnabled))
#define IHostUpdateAgent_get_Hidden(p, aHidden) ((p)->lpVtbl->GetHidden(p, aHidden))
#define IHostUpdateAgent_GetHidden(p, aHidden) ((p)->lpVtbl->GetHidden(p, aHidden))
#define IHostUpdateAgent_get_State(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IHostUpdateAgent_GetState(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IHostUpdateAgent_get_CheckFrequency(p, aCheckFrequency) ((p)->lpVtbl->GetCheckFrequency(p, aCheckFrequency))
#define IHostUpdateAgent_GetCheckFrequency(p, aCheckFrequency) ((p)->lpVtbl->GetCheckFrequency(p, aCheckFrequency))
#define IHostUpdateAgent_put_CheckFrequency(p, aCheckFrequency) ((p)->lpVtbl->SetCheckFrequency(p, aCheckFrequency))
#define IHostUpdateAgent_SetCheckFrequency(p, aCheckFrequency) ((p)->lpVtbl->SetCheckFrequency(p, aCheckFrequency))
#define IHostUpdateAgent_get_Channel(p, aChannel) ((p)->lpVtbl->GetChannel(p, aChannel))
#define IHostUpdateAgent_GetChannel(p, aChannel) ((p)->lpVtbl->GetChannel(p, aChannel))
#define IHostUpdateAgent_put_Channel(p, aChannel) ((p)->lpVtbl->SetChannel(p, aChannel))
#define IHostUpdateAgent_SetChannel(p, aChannel) ((p)->lpVtbl->SetChannel(p, aChannel))
#define IHostUpdateAgent_get_RepositoryURL(p, aRepositoryURL) ((p)->lpVtbl->GetRepositoryURL(p, aRepositoryURL))
#define IHostUpdateAgent_GetRepositoryURL(p, aRepositoryURL) ((p)->lpVtbl->GetRepositoryURL(p, aRepositoryURL))
#define IHostUpdateAgent_put_RepositoryURL(p, aRepositoryURL) ((p)->lpVtbl->SetRepositoryURL(p, aRepositoryURL))
#define IHostUpdateAgent_SetRepositoryURL(p, aRepositoryURL) ((p)->lpVtbl->SetRepositoryURL(p, aRepositoryURL))
#define IHostUpdateAgent_get_LastCheckDate(p, aLastCheckDate) ((p)->lpVtbl->GetLastCheckDate(p, aLastCheckDate))
#define IHostUpdateAgent_GetLastCheckDate(p, aLastCheckDate) ((p)->lpVtbl->GetLastCheckDate(p, aLastCheckDate))
#define IHostUpdateAgent_get_CheckCount(p, aCheckCount) ((p)->lpVtbl->GetCheckCount(p, aCheckCount))
#define IHostUpdateAgent_GetCheckCount(p, aCheckCount) ((p)->lpVtbl->GetCheckCount(p, aCheckCount))
#define IHostUpdateAgent_get_IsCheckNeeded(p, aIsCheckNeeded) ((p)->lpVtbl->GetIsCheckNeeded(p, aIsCheckNeeded))
#define IHostUpdateAgent_GetIsCheckNeeded(p, aIsCheckNeeded) ((p)->lpVtbl->GetIsCheckNeeded(p, aIsCheckNeeded))
#define IHostUpdateAgent_get_SupportedChannels(p, aSupportedChannels) ((p)->lpVtbl->GetSupportedChannels(p, aSupportedChannels))
#define IHostUpdateAgent_GetSupportedChannels(p, aSupportedChannels) ((p)->lpVtbl->GetSupportedChannels(p, aSupportedChannels))
#define IHostUpdateAgent_CheckFor(p, aProgress) ((p)->lpVtbl->CheckFor(p, aProgress))
#define IHostUpdateAgent_Download(p, aProgress) ((p)->lpVtbl->Download(p, aProgress))
#define IHostUpdateAgent_Install(p, aProgress) ((p)->lpVtbl->Install(p, aProgress))
#define IHostUpdateAgent_Rollback(p) ((p)->lpVtbl->Rollback(p))
#define IHostUpdateAgent_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IHostUpdateAgent_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IHostUpdateAgent
{
#ifndef VBOX_WITH_GLUE
    struct IHostUpdateAgent_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IHostUpdateAgentVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IHostUpdateAgent declaration */


/* Start of struct IHostDrivePartition declaration */
#define IHOSTDRIVEPARTITION_IID_STR "4f529a14-ace3-407c-9c49-066e8e8027f0"
#define IHOSTDRIVEPARTITION_IID { \
    0x4f529a14, 0xace3, 0x407c, \
    { 0x9c, 0x49, 0x06, 0x6e, 0x8e, 0x80, 0x27, 0xf0 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IHostDrivePartition);
#ifndef VBOX_WITH_GLUE
struct IHostDrivePartition_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetNumber)(IHostDrivePartition *pThis, PRUint32 *number);

    nsresult (*GetSize)(IHostDrivePartition *pThis, PRInt64 *size);

    nsresult (*GetStart)(IHostDrivePartition *pThis, PRInt64 *start);

    nsresult (*GetType)(IHostDrivePartition *pThis, PRUint32 *type);

    nsresult (*GetActive)(IHostDrivePartition *pThis, PRBool *active);

    nsresult (*GetTypeMBR)(IHostDrivePartition *pThis, PRUint32 *typeMBR);

    nsresult (*GetStartCylinder)(IHostDrivePartition *pThis, PRUint32 *startCylinder);

    nsresult (*GetStartHead)(IHostDrivePartition *pThis, PRUint32 *startHead);

    nsresult (*GetStartSector)(IHostDrivePartition *pThis, PRUint32 *startSector);

    nsresult (*GetEndCylinder)(IHostDrivePartition *pThis, PRUint32 *endCylinder);

    nsresult (*GetEndHead)(IHostDrivePartition *pThis, PRUint32 *endHead);

    nsresult (*GetEndSector)(IHostDrivePartition *pThis, PRUint32 *endSector);

    nsresult (*GetTypeUuid)(IHostDrivePartition *pThis, PRUnichar * *typeUuid);

    nsresult (*GetUuid)(IHostDrivePartition *pThis, PRUnichar * *uuid);

    nsresult (*GetName)(IHostDrivePartition *pThis, PRUnichar * *name);

};
#else /* VBOX_WITH_GLUE */
struct IHostDrivePartitionVtbl
{
    nsresult (*QueryInterface)(IHostDrivePartition *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IHostDrivePartition *pThis);
    nsrefcnt (*Release)(IHostDrivePartition *pThis);
    nsresult (*GetNumber)(IHostDrivePartition *pThis, PRUint32 *number);

    nsresult (*GetSize)(IHostDrivePartition *pThis, PRInt64 *size);

    nsresult (*GetStart)(IHostDrivePartition *pThis, PRInt64 *start);

    nsresult (*GetType)(IHostDrivePartition *pThis, PRUint32 *type);

    nsresult (*GetActive)(IHostDrivePartition *pThis, PRBool *active);

    nsresult (*GetTypeMBR)(IHostDrivePartition *pThis, PRUint32 *typeMBR);

    nsresult (*GetStartCylinder)(IHostDrivePartition *pThis, PRUint32 *startCylinder);

    nsresult (*GetStartHead)(IHostDrivePartition *pThis, PRUint32 *startHead);

    nsresult (*GetStartSector)(IHostDrivePartition *pThis, PRUint32 *startSector);

    nsresult (*GetEndCylinder)(IHostDrivePartition *pThis, PRUint32 *endCylinder);

    nsresult (*GetEndHead)(IHostDrivePartition *pThis, PRUint32 *endHead);

    nsresult (*GetEndSector)(IHostDrivePartition *pThis, PRUint32 *endSector);

    nsresult (*GetTypeUuid)(IHostDrivePartition *pThis, PRUnichar * *typeUuid);

    nsresult (*GetUuid)(IHostDrivePartition *pThis, PRUnichar * *uuid);

    nsresult (*GetName)(IHostDrivePartition *pThis, PRUnichar * *name);

};
#define IHostDrivePartition_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IHostDrivePartition_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IHostDrivePartition_Release(p) ((p)->lpVtbl->Release(p))
#define IHostDrivePartition_get_Number(p, aNumber) ((p)->lpVtbl->GetNumber(p, aNumber))
#define IHostDrivePartition_GetNumber(p, aNumber) ((p)->lpVtbl->GetNumber(p, aNumber))
#define IHostDrivePartition_get_Size(p, aSize) ((p)->lpVtbl->GetSize(p, aSize))
#define IHostDrivePartition_GetSize(p, aSize) ((p)->lpVtbl->GetSize(p, aSize))
#define IHostDrivePartition_get_Start(p, aStart) ((p)->lpVtbl->GetStart(p, aStart))
#define IHostDrivePartition_GetStart(p, aStart) ((p)->lpVtbl->GetStart(p, aStart))
#define IHostDrivePartition_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IHostDrivePartition_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IHostDrivePartition_get_Active(p, aActive) ((p)->lpVtbl->GetActive(p, aActive))
#define IHostDrivePartition_GetActive(p, aActive) ((p)->lpVtbl->GetActive(p, aActive))
#define IHostDrivePartition_get_TypeMBR(p, aTypeMBR) ((p)->lpVtbl->GetTypeMBR(p, aTypeMBR))
#define IHostDrivePartition_GetTypeMBR(p, aTypeMBR) ((p)->lpVtbl->GetTypeMBR(p, aTypeMBR))
#define IHostDrivePartition_get_StartCylinder(p, aStartCylinder) ((p)->lpVtbl->GetStartCylinder(p, aStartCylinder))
#define IHostDrivePartition_GetStartCylinder(p, aStartCylinder) ((p)->lpVtbl->GetStartCylinder(p, aStartCylinder))
#define IHostDrivePartition_get_StartHead(p, aStartHead) ((p)->lpVtbl->GetStartHead(p, aStartHead))
#define IHostDrivePartition_GetStartHead(p, aStartHead) ((p)->lpVtbl->GetStartHead(p, aStartHead))
#define IHostDrivePartition_get_StartSector(p, aStartSector) ((p)->lpVtbl->GetStartSector(p, aStartSector))
#define IHostDrivePartition_GetStartSector(p, aStartSector) ((p)->lpVtbl->GetStartSector(p, aStartSector))
#define IHostDrivePartition_get_EndCylinder(p, aEndCylinder) ((p)->lpVtbl->GetEndCylinder(p, aEndCylinder))
#define IHostDrivePartition_GetEndCylinder(p, aEndCylinder) ((p)->lpVtbl->GetEndCylinder(p, aEndCylinder))
#define IHostDrivePartition_get_EndHead(p, aEndHead) ((p)->lpVtbl->GetEndHead(p, aEndHead))
#define IHostDrivePartition_GetEndHead(p, aEndHead) ((p)->lpVtbl->GetEndHead(p, aEndHead))
#define IHostDrivePartition_get_EndSector(p, aEndSector) ((p)->lpVtbl->GetEndSector(p, aEndSector))
#define IHostDrivePartition_GetEndSector(p, aEndSector) ((p)->lpVtbl->GetEndSector(p, aEndSector))
#define IHostDrivePartition_get_TypeUuid(p, aTypeUuid) ((p)->lpVtbl->GetTypeUuid(p, aTypeUuid))
#define IHostDrivePartition_GetTypeUuid(p, aTypeUuid) ((p)->lpVtbl->GetTypeUuid(p, aTypeUuid))
#define IHostDrivePartition_get_Uuid(p, aUuid) ((p)->lpVtbl->GetUuid(p, aUuid))
#define IHostDrivePartition_GetUuid(p, aUuid) ((p)->lpVtbl->GetUuid(p, aUuid))
#define IHostDrivePartition_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IHostDrivePartition_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#endif /* VBOX_WITH_GLUE */

interface IHostDrivePartition
{
#ifndef VBOX_WITH_GLUE
    struct IHostDrivePartition_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IHostDrivePartitionVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IHostDrivePartition declaration */


/* Start of struct IHostDrive declaration */
#define IHOSTDRIVE_IID_STR "70e2e0c3-332c-4d72-b822-2db16e2cb31b"
#define IHOSTDRIVE_IID { \
    0x70e2e0c3, 0x332c, 0x4d72, \
    { 0xb8, 0x22, 0x2d, 0xb1, 0x6e, 0x2c, 0xb3, 0x1b } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IHostDrive);
#ifndef VBOX_WITH_GLUE
struct IHostDrive_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetDrivePath)(IHostDrive *pThis, PRUnichar * *drivePath);

    nsresult (*GetPartitioningType)(IHostDrive *pThis, PRUint32 *partitioningType);

    nsresult (*GetUuid)(IHostDrive *pThis, PRUnichar * *uuid);

    nsresult (*GetSectorSize)(IHostDrive *pThis, PRUint32 *sectorSize);

    nsresult (*GetSize)(IHostDrive *pThis, PRInt64 *size);

    nsresult (*GetModel)(IHostDrive *pThis, PRUnichar * *model);

    nsresult (*GetPartitions)(IHostDrive *pThis, PRUint32 *partitionsSize, IHostDrivePartition * **partitions);

};
#else /* VBOX_WITH_GLUE */
struct IHostDriveVtbl
{
    nsresult (*QueryInterface)(IHostDrive *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IHostDrive *pThis);
    nsrefcnt (*Release)(IHostDrive *pThis);
    nsresult (*GetDrivePath)(IHostDrive *pThis, PRUnichar * *drivePath);

    nsresult (*GetPartitioningType)(IHostDrive *pThis, PRUint32 *partitioningType);

    nsresult (*GetUuid)(IHostDrive *pThis, PRUnichar * *uuid);

    nsresult (*GetSectorSize)(IHostDrive *pThis, PRUint32 *sectorSize);

    nsresult (*GetSize)(IHostDrive *pThis, PRInt64 *size);

    nsresult (*GetModel)(IHostDrive *pThis, PRUnichar * *model);

    nsresult (*GetPartitions)(IHostDrive *pThis, PRUint32 *partitionsSize, IHostDrivePartition * **partitions);

};
#define IHostDrive_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IHostDrive_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IHostDrive_Release(p) ((p)->lpVtbl->Release(p))
#define IHostDrive_get_DrivePath(p, aDrivePath) ((p)->lpVtbl->GetDrivePath(p, aDrivePath))
#define IHostDrive_GetDrivePath(p, aDrivePath) ((p)->lpVtbl->GetDrivePath(p, aDrivePath))
#define IHostDrive_get_PartitioningType(p, aPartitioningType) ((p)->lpVtbl->GetPartitioningType(p, aPartitioningType))
#define IHostDrive_GetPartitioningType(p, aPartitioningType) ((p)->lpVtbl->GetPartitioningType(p, aPartitioningType))
#define IHostDrive_get_Uuid(p, aUuid) ((p)->lpVtbl->GetUuid(p, aUuid))
#define IHostDrive_GetUuid(p, aUuid) ((p)->lpVtbl->GetUuid(p, aUuid))
#define IHostDrive_get_SectorSize(p, aSectorSize) ((p)->lpVtbl->GetSectorSize(p, aSectorSize))
#define IHostDrive_GetSectorSize(p, aSectorSize) ((p)->lpVtbl->GetSectorSize(p, aSectorSize))
#define IHostDrive_get_Size(p, aSize) ((p)->lpVtbl->GetSize(p, aSize))
#define IHostDrive_GetSize(p, aSize) ((p)->lpVtbl->GetSize(p, aSize))
#define IHostDrive_get_Model(p, aModel) ((p)->lpVtbl->GetModel(p, aModel))
#define IHostDrive_GetModel(p, aModel) ((p)->lpVtbl->GetModel(p, aModel))
#define IHostDrive_get_Partitions(p, aPartitions) ((p)->lpVtbl->GetPartitions(p, aPartitions))
#define IHostDrive_GetPartitions(p, aPartitions) ((p)->lpVtbl->GetPartitions(p, aPartitions))
#endif /* VBOX_WITH_GLUE */

interface IHostDrive
{
#ifndef VBOX_WITH_GLUE
    struct IHostDrive_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IHostDriveVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IHostDrive declaration */


/* Start of struct IHostX86 declaration */
#define IHOSTX86_IID_STR "50c97996-9cf8-417f-bd79-1e0471367cd3"
#define IHOSTX86_IID { \
    0x50c97996, 0x9cf8, 0x417f, \
    { 0xbd, 0x79, 0x1e, 0x04, 0x71, 0x36, 0x7c, 0xd3 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IHostX86);
#ifndef VBOX_WITH_GLUE
struct IHostX86_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetInternalAndReservedAttribute1IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetProcessorCPUIDLeaf)(
        IHostX86 *pThis,
        PRUint32 cpuId,
        PRUint32 leaf,
        PRUint32 subLeaf,
        PRUint32 * valEax,
        PRUint32 * valEbx,
        PRUint32 * valEcx,
        PRUint32 * valEdx
    );

    nsresult (*InternalAndReservedMethod1IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod2IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod3IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod4IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod5IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod6IHostX86)(IHostX86 *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IHostX86Vtbl
{
    nsresult (*QueryInterface)(IHostX86 *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IHostX86 *pThis);
    nsrefcnt (*Release)(IHostX86 *pThis);
    nsresult (*GetInternalAndReservedAttribute1IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IHostX86)(IHostX86 *pThis, PRUint32 *reserved);

    nsresult (*GetProcessorCPUIDLeaf)(
        IHostX86 *pThis,
        PRUint32 cpuId,
        PRUint32 leaf,
        PRUint32 subLeaf,
        PRUint32 * valEax,
        PRUint32 * valEbx,
        PRUint32 * valEcx,
        PRUint32 * valEdx
    );

    nsresult (*InternalAndReservedMethod1IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod2IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod3IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod4IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod5IHostX86)(IHostX86 *pThis);

    nsresult (*InternalAndReservedMethod6IHostX86)(IHostX86 *pThis);

};
#define IHostX86_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IHostX86_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IHostX86_Release(p) ((p)->lpVtbl->Release(p))
#define IHostX86_GetProcessorCPUIDLeaf(p, aCpuId, aLeaf, aSubLeaf, aValEax, aValEbx, aValEcx, aValEdx) ((p)->lpVtbl->GetProcessorCPUIDLeaf(p, aCpuId, aLeaf, aSubLeaf, aValEax, aValEbx, aValEcx, aValEdx))
#endif /* VBOX_WITH_GLUE */

interface IHostX86
{
#ifndef VBOX_WITH_GLUE
    struct IHostX86_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IHostX86Vtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IHostX86 declaration */


/* Start of struct IHost declaration */
#define IHOST_IID_STR "d5dcece0-b202-4416-a138-03502784cc07"
#define IHOST_IID { \
    0xd5dcece0, 0xb202, 0x4416, \
    { 0xa1, 0x38, 0x03, 0x50, 0x27, 0x84, 0xcc, 0x07 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IHost);
#ifndef VBOX_WITH_GLUE
struct IHost_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetArchitecture)(IHost *pThis, PRUint32 *architecture);

    nsresult (*GetX86)(IHost *pThis, IHostX86 * *x86);

    nsresult (*GetDVDDrives)(IHost *pThis, PRUint32 *DVDDrivesSize, IMedium * **DVDDrives);

    nsresult (*GetFloppyDrives)(IHost *pThis, PRUint32 *floppyDrivesSize, IMedium * **floppyDrives);

    nsresult (*GetAudioDevices)(IHost *pThis, PRUint32 *audioDevicesSize, IHostAudioDevice * **audioDevices);

    nsresult (*GetUSBDevices)(IHost *pThis, PRUint32 *USBDevicesSize, IHostUSBDevice * **USBDevices);

    nsresult (*GetUSBDeviceFilters)(IHost *pThis, PRUint32 *USBDeviceFiltersSize, IHostUSBDeviceFilter * **USBDeviceFilters);

    nsresult (*GetNetworkInterfaces)(IHost *pThis, PRUint32 *networkInterfacesSize, IHostNetworkInterface * **networkInterfaces);

    nsresult (*GetNameServers)(IHost *pThis, PRUint32 *nameServersSize, PRUnichar * **nameServers);

    nsresult (*GetDomainName)(IHost *pThis, PRUnichar * *domainName);

    nsresult (*GetSearchStrings)(IHost *pThis, PRUint32 *searchStringsSize, PRUnichar * **searchStrings);

    nsresult (*GetProcessorCount)(IHost *pThis, PRUint32 *processorCount);

    nsresult (*GetProcessorOnlineCount)(IHost *pThis, PRUint32 *processorOnlineCount);

    nsresult (*GetProcessorCoreCount)(IHost *pThis, PRUint32 *processorCoreCount);

    nsresult (*GetProcessorOnlineCoreCount)(IHost *pThis, PRUint32 *processorOnlineCoreCount);

    nsresult (*GetHostDrives)(IHost *pThis, PRUint32 *hostDrivesSize, IHostDrive * **hostDrives);

    nsresult (*GetMemorySize)(IHost *pThis, PRUint32 *memorySize);

    nsresult (*GetMemoryAvailable)(IHost *pThis, PRUint32 *memoryAvailable);

    nsresult (*GetOperatingSystem)(IHost *pThis, PRUnichar * *operatingSystem);

    nsresult (*GetOSVersion)(IHost *pThis, PRUnichar * *OSVersion);

    nsresult (*GetUTCTime)(IHost *pThis, PRInt64 *UTCTime);

    nsresult (*GetVideoInputDevices)(IHost *pThis, PRUint32 *videoInputDevicesSize, IHostVideoInputDevice * **videoInputDevices);

    nsresult (*GetUpdateHost)(IHost *pThis, IUpdateAgent * *updateHost);

    nsresult (*GetUpdateExtPack)(IHost *pThis, IUpdateAgent * *updateExtPack);

    nsresult (*GetUpdateGuestAdditions)(IHost *pThis, IUpdateAgent * *updateGuestAdditions);

    nsresult (*GetInternalAndReservedAttribute1IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetProcessorSpeed)(
        IHost *pThis,
        PRUint32 cpuId,
        PRUint32 * speed
    );

    nsresult (*GetProcessorFeature)(
        IHost *pThis,
        PRUint32 feature,
        PRBool * supported
    );

    nsresult (*GetProcessorDescription)(
        IHost *pThis,
        PRUint32 cpuId,
        PRUnichar * * description
    );

    nsresult (*CreateHostOnlyNetworkInterface)(
        IHost *pThis,
        IHostNetworkInterface * * hostInterface,
        IProgress * * progress
    );

    nsresult (*RemoveHostOnlyNetworkInterface)(
        IHost *pThis,
        PRUnichar * id,
        IProgress * * progress
    );

    nsresult (*CreateUSBDeviceFilter)(
        IHost *pThis,
        PRUnichar * name,
        IHostUSBDeviceFilter * * filter
    );

    nsresult (*InsertUSBDeviceFilter)(
        IHost *pThis,
        PRUint32 position,
        IHostUSBDeviceFilter * filter
    );

    nsresult (*RemoveUSBDeviceFilter)(
        IHost *pThis,
        PRUint32 position
    );

    nsresult (*FindHostDVDDrive)(
        IHost *pThis,
        PRUnichar * name,
        IMedium * * drive
    );

    nsresult (*FindHostFloppyDrive)(
        IHost *pThis,
        PRUnichar * name,
        IMedium * * drive
    );

    nsresult (*FindHostNetworkInterfaceByName)(
        IHost *pThis,
        PRUnichar * name,
        IHostNetworkInterface * * networkInterface
    );

    nsresult (*FindHostNetworkInterfaceById)(
        IHost *pThis,
        PRUnichar * id,
        IHostNetworkInterface * * networkInterface
    );

    nsresult (*FindHostNetworkInterfacesOfType)(
        IHost *pThis,
        PRUint32 type,
        PRUint32 *networkInterfacesSize,
        IHostNetworkInterface *** networkInterfaces
    );

    nsresult (*FindUSBDeviceById)(
        IHost *pThis,
        PRUnichar * id,
        IHostUSBDevice * * device
    );

    nsresult (*FindUSBDeviceByAddress)(
        IHost *pThis,
        PRUnichar * name,
        IHostUSBDevice * * device
    );

    nsresult (*GenerateMACAddress)(
        IHost *pThis,
        PRUnichar * * address
    );

    nsresult (*AddUSBDeviceSource)(
        IHost *pThis,
        PRUnichar * backend,
        PRUnichar * id,
        PRUnichar * address,
        PRUint32 propertyNamesSize,
        PRUnichar ** propertyNames,
        PRUint32 propertyValuesSize,
        PRUnichar ** propertyValues
    );

    nsresult (*RemoveUSBDeviceSource)(
        IHost *pThis,
        PRUnichar * id
    );

    nsresult (*IsExecutionEngineSupported)(
        IHost *pThis,
        PRUint32 cpuArchitecture,
        PRUint32 executionEngine,
        PRBool * isSupported
    );

    nsresult (*InternalAndReservedMethod1IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod2IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod3IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod4IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod5IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod6IHost)(IHost *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IHostVtbl
{
    nsresult (*QueryInterface)(IHost *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IHost *pThis);
    nsrefcnt (*Release)(IHost *pThis);
    nsresult (*GetArchitecture)(IHost *pThis, PRUint32 *architecture);

    nsresult (*GetX86)(IHost *pThis, IHostX86 * *x86);

    nsresult (*GetDVDDrives)(IHost *pThis, PRUint32 *DVDDrivesSize, IMedium * **DVDDrives);

    nsresult (*GetFloppyDrives)(IHost *pThis, PRUint32 *floppyDrivesSize, IMedium * **floppyDrives);

    nsresult (*GetAudioDevices)(IHost *pThis, PRUint32 *audioDevicesSize, IHostAudioDevice * **audioDevices);

    nsresult (*GetUSBDevices)(IHost *pThis, PRUint32 *USBDevicesSize, IHostUSBDevice * **USBDevices);

    nsresult (*GetUSBDeviceFilters)(IHost *pThis, PRUint32 *USBDeviceFiltersSize, IHostUSBDeviceFilter * **USBDeviceFilters);

    nsresult (*GetNetworkInterfaces)(IHost *pThis, PRUint32 *networkInterfacesSize, IHostNetworkInterface * **networkInterfaces);

    nsresult (*GetNameServers)(IHost *pThis, PRUint32 *nameServersSize, PRUnichar * **nameServers);

    nsresult (*GetDomainName)(IHost *pThis, PRUnichar * *domainName);

    nsresult (*GetSearchStrings)(IHost *pThis, PRUint32 *searchStringsSize, PRUnichar * **searchStrings);

    nsresult (*GetProcessorCount)(IHost *pThis, PRUint32 *processorCount);

    nsresult (*GetProcessorOnlineCount)(IHost *pThis, PRUint32 *processorOnlineCount);

    nsresult (*GetProcessorCoreCount)(IHost *pThis, PRUint32 *processorCoreCount);

    nsresult (*GetProcessorOnlineCoreCount)(IHost *pThis, PRUint32 *processorOnlineCoreCount);

    nsresult (*GetHostDrives)(IHost *pThis, PRUint32 *hostDrivesSize, IHostDrive * **hostDrives);

    nsresult (*GetMemorySize)(IHost *pThis, PRUint32 *memorySize);

    nsresult (*GetMemoryAvailable)(IHost *pThis, PRUint32 *memoryAvailable);

    nsresult (*GetOperatingSystem)(IHost *pThis, PRUnichar * *operatingSystem);

    nsresult (*GetOSVersion)(IHost *pThis, PRUnichar * *OSVersion);

    nsresult (*GetUTCTime)(IHost *pThis, PRInt64 *UTCTime);

    nsresult (*GetVideoInputDevices)(IHost *pThis, PRUint32 *videoInputDevicesSize, IHostVideoInputDevice * **videoInputDevices);

    nsresult (*GetUpdateHost)(IHost *pThis, IUpdateAgent * *updateHost);

    nsresult (*GetUpdateExtPack)(IHost *pThis, IUpdateAgent * *updateExtPack);

    nsresult (*GetUpdateGuestAdditions)(IHost *pThis, IUpdateAgent * *updateGuestAdditions);

    nsresult (*GetInternalAndReservedAttribute1IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IHost)(IHost *pThis, PRUint32 *reserved);

    nsresult (*GetProcessorSpeed)(
        IHost *pThis,
        PRUint32 cpuId,
        PRUint32 * speed
    );

    nsresult (*GetProcessorFeature)(
        IHost *pThis,
        PRUint32 feature,
        PRBool * supported
    );

    nsresult (*GetProcessorDescription)(
        IHost *pThis,
        PRUint32 cpuId,
        PRUnichar * * description
    );

    nsresult (*CreateHostOnlyNetworkInterface)(
        IHost *pThis,
        IHostNetworkInterface * * hostInterface,
        IProgress * * progress
    );

    nsresult (*RemoveHostOnlyNetworkInterface)(
        IHost *pThis,
        PRUnichar * id,
        IProgress * * progress
    );

    nsresult (*CreateUSBDeviceFilter)(
        IHost *pThis,
        PRUnichar * name,
        IHostUSBDeviceFilter * * filter
    );

    nsresult (*InsertUSBDeviceFilter)(
        IHost *pThis,
        PRUint32 position,
        IHostUSBDeviceFilter * filter
    );

    nsresult (*RemoveUSBDeviceFilter)(
        IHost *pThis,
        PRUint32 position
    );

    nsresult (*FindHostDVDDrive)(
        IHost *pThis,
        PRUnichar * name,
        IMedium * * drive
    );

    nsresult (*FindHostFloppyDrive)(
        IHost *pThis,
        PRUnichar * name,
        IMedium * * drive
    );

    nsresult (*FindHostNetworkInterfaceByName)(
        IHost *pThis,
        PRUnichar * name,
        IHostNetworkInterface * * networkInterface
    );

    nsresult (*FindHostNetworkInterfaceById)(
        IHost *pThis,
        PRUnichar * id,
        IHostNetworkInterface * * networkInterface
    );

    nsresult (*FindHostNetworkInterfacesOfType)(
        IHost *pThis,
        PRUint32 type,
        PRUint32 *networkInterfacesSize,
        IHostNetworkInterface *** networkInterfaces
    );

    nsresult (*FindUSBDeviceById)(
        IHost *pThis,
        PRUnichar * id,
        IHostUSBDevice * * device
    );

    nsresult (*FindUSBDeviceByAddress)(
        IHost *pThis,
        PRUnichar * name,
        IHostUSBDevice * * device
    );

    nsresult (*GenerateMACAddress)(
        IHost *pThis,
        PRUnichar * * address
    );

    nsresult (*AddUSBDeviceSource)(
        IHost *pThis,
        PRUnichar * backend,
        PRUnichar * id,
        PRUnichar * address,
        PRUint32 propertyNamesSize,
        PRUnichar ** propertyNames,
        PRUint32 propertyValuesSize,
        PRUnichar ** propertyValues
    );

    nsresult (*RemoveUSBDeviceSource)(
        IHost *pThis,
        PRUnichar * id
    );

    nsresult (*IsExecutionEngineSupported)(
        IHost *pThis,
        PRUint32 cpuArchitecture,
        PRUint32 executionEngine,
        PRBool * isSupported
    );

    nsresult (*InternalAndReservedMethod1IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod2IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod3IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod4IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod5IHost)(IHost *pThis);

    nsresult (*InternalAndReservedMethod6IHost)(IHost *pThis);

};
#define IHost_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IHost_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IHost_Release(p) ((p)->lpVtbl->Release(p))
#define IHost_get_Architecture(p, aArchitecture) ((p)->lpVtbl->GetArchitecture(p, aArchitecture))
#define IHost_GetArchitecture(p, aArchitecture) ((p)->lpVtbl->GetArchitecture(p, aArchitecture))
#define IHost_get_X86(p, aX86) ((p)->lpVtbl->GetX86(p, aX86))
#define IHost_GetX86(p, aX86) ((p)->lpVtbl->GetX86(p, aX86))
#define IHost_get_DVDDrives(p, aDVDDrives) ((p)->lpVtbl->GetDVDDrives(p, aDVDDrives))
#define IHost_GetDVDDrives(p, aDVDDrives) ((p)->lpVtbl->GetDVDDrives(p, aDVDDrives))
#define IHost_get_FloppyDrives(p, aFloppyDrives) ((p)->lpVtbl->GetFloppyDrives(p, aFloppyDrives))
#define IHost_GetFloppyDrives(p, aFloppyDrives) ((p)->lpVtbl->GetFloppyDrives(p, aFloppyDrives))
#define IHost_get_AudioDevices(p, aAudioDevices) ((p)->lpVtbl->GetAudioDevices(p, aAudioDevices))
#define IHost_GetAudioDevices(p, aAudioDevices) ((p)->lpVtbl->GetAudioDevices(p, aAudioDevices))
#define IHost_get_USBDevices(p, aUSBDevices) ((p)->lpVtbl->GetUSBDevices(p, aUSBDevices))
#define IHost_GetUSBDevices(p, aUSBDevices) ((p)->lpVtbl->GetUSBDevices(p, aUSBDevices))
#define IHost_get_USBDeviceFilters(p, aUSBDeviceFilters) ((p)->lpVtbl->GetUSBDeviceFilters(p, aUSBDeviceFilters))
#define IHost_GetUSBDeviceFilters(p, aUSBDeviceFilters) ((p)->lpVtbl->GetUSBDeviceFilters(p, aUSBDeviceFilters))
#define IHost_get_NetworkInterfaces(p, aNetworkInterfaces) ((p)->lpVtbl->GetNetworkInterfaces(p, aNetworkInterfaces))
#define IHost_GetNetworkInterfaces(p, aNetworkInterfaces) ((p)->lpVtbl->GetNetworkInterfaces(p, aNetworkInterfaces))
#define IHost_get_NameServers(p, aNameServers) ((p)->lpVtbl->GetNameServers(p, aNameServers))
#define IHost_GetNameServers(p, aNameServers) ((p)->lpVtbl->GetNameServers(p, aNameServers))
#define IHost_get_DomainName(p, aDomainName) ((p)->lpVtbl->GetDomainName(p, aDomainName))
#define IHost_GetDomainName(p, aDomainName) ((p)->lpVtbl->GetDomainName(p, aDomainName))
#define IHost_get_SearchStrings(p, aSearchStrings) ((p)->lpVtbl->GetSearchStrings(p, aSearchStrings))
#define IHost_GetSearchStrings(p, aSearchStrings) ((p)->lpVtbl->GetSearchStrings(p, aSearchStrings))
#define IHost_get_ProcessorCount(p, aProcessorCount) ((p)->lpVtbl->GetProcessorCount(p, aProcessorCount))
#define IHost_GetProcessorCount(p, aProcessorCount) ((p)->lpVtbl->GetProcessorCount(p, aProcessorCount))
#define IHost_get_ProcessorOnlineCount(p, aProcessorOnlineCount) ((p)->lpVtbl->GetProcessorOnlineCount(p, aProcessorOnlineCount))
#define IHost_GetProcessorOnlineCount(p, aProcessorOnlineCount) ((p)->lpVtbl->GetProcessorOnlineCount(p, aProcessorOnlineCount))
#define IHost_get_ProcessorCoreCount(p, aProcessorCoreCount) ((p)->lpVtbl->GetProcessorCoreCount(p, aProcessorCoreCount))
#define IHost_GetProcessorCoreCount(p, aProcessorCoreCount) ((p)->lpVtbl->GetProcessorCoreCount(p, aProcessorCoreCount))
#define IHost_get_ProcessorOnlineCoreCount(p, aProcessorOnlineCoreCount) ((p)->lpVtbl->GetProcessorOnlineCoreCount(p, aProcessorOnlineCoreCount))
#define IHost_GetProcessorOnlineCoreCount(p, aProcessorOnlineCoreCount) ((p)->lpVtbl->GetProcessorOnlineCoreCount(p, aProcessorOnlineCoreCount))
#define IHost_get_HostDrives(p, aHostDrives) ((p)->lpVtbl->GetHostDrives(p, aHostDrives))
#define IHost_GetHostDrives(p, aHostDrives) ((p)->lpVtbl->GetHostDrives(p, aHostDrives))
#define IHost_get_MemorySize(p, aMemorySize) ((p)->lpVtbl->GetMemorySize(p, aMemorySize))
#define IHost_GetMemorySize(p, aMemorySize) ((p)->lpVtbl->GetMemorySize(p, aMemorySize))
#define IHost_get_MemoryAvailable(p, aMemoryAvailable) ((p)->lpVtbl->GetMemoryAvailable(p, aMemoryAvailable))
#define IHost_GetMemoryAvailable(p, aMemoryAvailable) ((p)->lpVtbl->GetMemoryAvailable(p, aMemoryAvailable))
#define IHost_get_OperatingSystem(p, aOperatingSystem) ((p)->lpVtbl->GetOperatingSystem(p, aOperatingSystem))
#define IHost_GetOperatingSystem(p, aOperatingSystem) ((p)->lpVtbl->GetOperatingSystem(p, aOperatingSystem))
#define IHost_get_OSVersion(p, aOSVersion) ((p)->lpVtbl->GetOSVersion(p, aOSVersion))
#define IHost_GetOSVersion(p, aOSVersion) ((p)->lpVtbl->GetOSVersion(p, aOSVersion))
#define IHost_get_UTCTime(p, aUTCTime) ((p)->lpVtbl->GetUTCTime(p, aUTCTime))
#define IHost_GetUTCTime(p, aUTCTime) ((p)->lpVtbl->GetUTCTime(p, aUTCTime))
#define IHost_get_VideoInputDevices(p, aVideoInputDevices) ((p)->lpVtbl->GetVideoInputDevices(p, aVideoInputDevices))
#define IHost_GetVideoInputDevices(p, aVideoInputDevices) ((p)->lpVtbl->GetVideoInputDevices(p, aVideoInputDevices))
#define IHost_get_UpdateHost(p, aUpdateHost) ((p)->lpVtbl->GetUpdateHost(p, aUpdateHost))
#define IHost_GetUpdateHost(p, aUpdateHost) ((p)->lpVtbl->GetUpdateHost(p, aUpdateHost))
#define IHost_get_UpdateExtPack(p, aUpdateExtPack) ((p)->lpVtbl->GetUpdateExtPack(p, aUpdateExtPack))
#define IHost_GetUpdateExtPack(p, aUpdateExtPack) ((p)->lpVtbl->GetUpdateExtPack(p, aUpdateExtPack))
#define IHost_get_UpdateGuestAdditions(p, aUpdateGuestAdditions) ((p)->lpVtbl->GetUpdateGuestAdditions(p, aUpdateGuestAdditions))
#define IHost_GetUpdateGuestAdditions(p, aUpdateGuestAdditions) ((p)->lpVtbl->GetUpdateGuestAdditions(p, aUpdateGuestAdditions))
#define IHost_GetProcessorSpeed(p, aCpuId, aSpeed) ((p)->lpVtbl->GetProcessorSpeed(p, aCpuId, aSpeed))
#define IHost_GetProcessorFeature(p, aFeature, aSupported) ((p)->lpVtbl->GetProcessorFeature(p, aFeature, aSupported))
#define IHost_GetProcessorDescription(p, aCpuId, aDescription) ((p)->lpVtbl->GetProcessorDescription(p, aCpuId, aDescription))
#define IHost_CreateHostOnlyNetworkInterface(p, aHostInterface, aProgress) ((p)->lpVtbl->CreateHostOnlyNetworkInterface(p, aHostInterface, aProgress))
#define IHost_RemoveHostOnlyNetworkInterface(p, aId, aProgress) ((p)->lpVtbl->RemoveHostOnlyNetworkInterface(p, aId, aProgress))
#define IHost_CreateUSBDeviceFilter(p, aName, aFilter) ((p)->lpVtbl->CreateUSBDeviceFilter(p, aName, aFilter))
#define IHost_InsertUSBDeviceFilter(p, aPosition, aFilter) ((p)->lpVtbl->InsertUSBDeviceFilter(p, aPosition, aFilter))
#define IHost_RemoveUSBDeviceFilter(p, aPosition) ((p)->lpVtbl->RemoveUSBDeviceFilter(p, aPosition))
#define IHost_FindHostDVDDrive(p, aName, aDrive) ((p)->lpVtbl->FindHostDVDDrive(p, aName, aDrive))
#define IHost_FindHostFloppyDrive(p, aName, aDrive) ((p)->lpVtbl->FindHostFloppyDrive(p, aName, aDrive))
#define IHost_FindHostNetworkInterfaceByName(p, aName, aNetworkInterface) ((p)->lpVtbl->FindHostNetworkInterfaceByName(p, aName, aNetworkInterface))
#define IHost_FindHostNetworkInterfaceById(p, aId, aNetworkInterface) ((p)->lpVtbl->FindHostNetworkInterfaceById(p, aId, aNetworkInterface))
#define IHost_FindHostNetworkInterfacesOfType(p, aType, aNetworkInterfaces) ((p)->lpVtbl->FindHostNetworkInterfacesOfType(p, aType, aNetworkInterfaces))
#define IHost_FindUSBDeviceById(p, aId, aDevice) ((p)->lpVtbl->FindUSBDeviceById(p, aId, aDevice))
#define IHost_FindUSBDeviceByAddress(p, aName, aDevice) ((p)->lpVtbl->FindUSBDeviceByAddress(p, aName, aDevice))
#define IHost_GenerateMACAddress(p, aAddress) ((p)->lpVtbl->GenerateMACAddress(p, aAddress))
#define IHost_AddUSBDeviceSource(p, aBackend, aId, aAddress, aPropertyNames, aPropertyValues) ((p)->lpVtbl->AddUSBDeviceSource(p, aBackend, aId, aAddress, aPropertyNames, aPropertyValues))
#define IHost_RemoveUSBDeviceSource(p, aId) ((p)->lpVtbl->RemoveUSBDeviceSource(p, aId))
#define IHost_IsExecutionEngineSupported(p, aCpuArchitecture, aExecutionEngine, aIsSupported) ((p)->lpVtbl->IsExecutionEngineSupported(p, aCpuArchitecture, aExecutionEngine, aIsSupported))
#endif /* VBOX_WITH_GLUE */

interface IHost
{
#ifndef VBOX_WITH_GLUE
    struct IHost_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IHostVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IHost declaration */


/* Start of struct ICPUProfile declaration */
#define ICPUPROFILE_IID_STR "b7fda727-7a08-46ee-8dd8-f8d7308b519c"
#define ICPUPROFILE_IID { \
    0xb7fda727, 0x7a08, 0x46ee, \
    { 0x8d, 0xd8, 0xf8, 0xd7, 0x30, 0x8b, 0x51, 0x9c } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_ICPUProfile);
#ifndef VBOX_WITH_GLUE
struct ICPUProfile_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetName)(ICPUProfile *pThis, PRUnichar * *name);

    nsresult (*GetFullName)(ICPUProfile *pThis, PRUnichar * *fullName);

    nsresult (*GetArchitecture)(ICPUProfile *pThis, PRUint32 *architecture);

    nsresult (*GetInternalAndReservedAttribute1ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1ICPUProfile)(ICPUProfile *pThis);

    nsresult (*InternalAndReservedMethod2ICPUProfile)(ICPUProfile *pThis);

    nsresult (*InternalAndReservedMethod3ICPUProfile)(ICPUProfile *pThis);

    nsresult (*InternalAndReservedMethod4ICPUProfile)(ICPUProfile *pThis);

};
#else /* VBOX_WITH_GLUE */
struct ICPUProfileVtbl
{
    nsresult (*QueryInterface)(ICPUProfile *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(ICPUProfile *pThis);
    nsrefcnt (*Release)(ICPUProfile *pThis);
    nsresult (*GetName)(ICPUProfile *pThis, PRUnichar * *name);

    nsresult (*GetFullName)(ICPUProfile *pThis, PRUnichar * *fullName);

    nsresult (*GetArchitecture)(ICPUProfile *pThis, PRUint32 *architecture);

    nsresult (*GetInternalAndReservedAttribute1ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ICPUProfile)(ICPUProfile *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1ICPUProfile)(ICPUProfile *pThis);

    nsresult (*InternalAndReservedMethod2ICPUProfile)(ICPUProfile *pThis);

    nsresult (*InternalAndReservedMethod3ICPUProfile)(ICPUProfile *pThis);

    nsresult (*InternalAndReservedMethod4ICPUProfile)(ICPUProfile *pThis);

};
#define ICPUProfile_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define ICPUProfile_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define ICPUProfile_Release(p) ((p)->lpVtbl->Release(p))
#define ICPUProfile_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define ICPUProfile_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define ICPUProfile_get_FullName(p, aFullName) ((p)->lpVtbl->GetFullName(p, aFullName))
#define ICPUProfile_GetFullName(p, aFullName) ((p)->lpVtbl->GetFullName(p, aFullName))
#define ICPUProfile_get_Architecture(p, aArchitecture) ((p)->lpVtbl->GetArchitecture(p, aArchitecture))
#define ICPUProfile_GetArchitecture(p, aArchitecture) ((p)->lpVtbl->GetArchitecture(p, aArchitecture))
#endif /* VBOX_WITH_GLUE */

interface ICPUProfile
{
#ifndef VBOX_WITH_GLUE
    struct ICPUProfile_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct ICPUProfileVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct ICPUProfile declaration */


/* Start of struct IPlatformProperties declaration */
#define IPLATFORMPROPERTIES_IID_STR "5bae19d0-ca40-4ca2-a485-c8065190bbe5"
#define IPLATFORMPROPERTIES_IID { \
    0x5bae19d0, 0xca40, 0x4ca2, \
    { 0xa4, 0x85, 0xc8, 0x06, 0x51, 0x90, 0xbb, 0xe5 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IPlatformProperties);
#ifndef VBOX_WITH_GLUE
struct IPlatformProperties_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetRawModeSupported)(IPlatformProperties *pThis, PRBool *rawModeSupported);

    nsresult (*GetExclusiveHwVirt)(IPlatformProperties *pThis, PRBool *exclusiveHwVirt);
    nsresult (*SetExclusiveHwVirt)(IPlatformProperties *pThis, PRBool exclusiveHwVirt);

    nsresult (*GetSerialPortCount)(IPlatformProperties *pThis, PRUint32 *serialPortCount);

    nsresult (*GetParallelPortCount)(IPlatformProperties *pThis, PRUint32 *parallelPortCount);

    nsresult (*GetMaxBootPosition)(IPlatformProperties *pThis, PRUint32 *maxBootPosition);

    nsresult (*GetSupportedParavirtProviders)(IPlatformProperties *pThis, PRUint32 *supportedParavirtProvidersSize, PRUint32 **supportedParavirtProviders);

    nsresult (*GetSupportedFirmwareTypes)(IPlatformProperties *pThis, PRUint32 *supportedFirmwareTypesSize, PRUint32 **supportedFirmwareTypes);

    nsresult (*GetSupportedGuestOSTypes)(IPlatformProperties *pThis, PRUint32 *supportedGuestOSTypesSize, IGuestOSType * **supportedGuestOSTypes);

    nsresult (*GetSupportedGfxControllerTypes)(IPlatformProperties *pThis, PRUint32 *supportedGfxControllerTypesSize, PRUint32 **supportedGfxControllerTypes);

    nsresult (*GetSupportedNetAdpPromiscModePols)(IPlatformProperties *pThis, PRUint32 *supportedNetAdpPromiscModePolsSize, PRUint32 **supportedNetAdpPromiscModePols);

    nsresult (*GetSupportedNetworkAdapterTypes)(IPlatformProperties *pThis, PRUint32 *supportedNetworkAdapterTypesSize, PRUint32 **supportedNetworkAdapterTypes);

    nsresult (*GetSupportedUartTypes)(IPlatformProperties *pThis, PRUint32 *supportedUartTypesSize, PRUint32 **supportedUartTypes);

    nsresult (*GetSupportedUSBControllerTypes)(IPlatformProperties *pThis, PRUint32 *supportedUSBControllerTypesSize, PRUint32 **supportedUSBControllerTypes);

    nsresult (*GetSupportedAudioControllerTypes)(IPlatformProperties *pThis, PRUint32 *supportedAudioControllerTypesSize, PRUint32 **supportedAudioControllerTypes);

    nsresult (*GetSupportedBootDevices)(IPlatformProperties *pThis, PRUint32 *supportedBootDevicesSize, PRUint32 **supportedBootDevices);

    nsresult (*GetSupportedStorageBuses)(IPlatformProperties *pThis, PRUint32 *supportedStorageBusesSize, PRUint32 **supportedStorageBuses);

    nsresult (*GetSupportedStorageControllerTypes)(IPlatformProperties *pThis, PRUint32 *supportedStorageControllerTypesSize, PRUint32 **supportedStorageControllerTypes);

    nsresult (*GetSupportedChipsetTypes)(IPlatformProperties *pThis, PRUint32 *supportedChipsetTypesSize, PRUint32 **supportedChipsetTypes);

    nsresult (*GetSupportedIommuTypes)(IPlatformProperties *pThis, PRUint32 *supportedIommuTypesSize, PRUint32 **supportedIommuTypes);

    nsresult (*GetSupportedTpmTypes)(IPlatformProperties *pThis, PRUint32 *supportedTpmTypesSize, PRUint32 **supportedTpmTypes);

    nsresult (*GetInternalAndReservedAttribute1IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetMaxNetworkAdapters)(
        IPlatformProperties *pThis,
        PRUint32 chipset,
        PRUint32 * maxNetworkAdapters
    );

    nsresult (*GetMaxNetworkAdaptersOfType)(
        IPlatformProperties *pThis,
        PRUint32 chipset,
        PRUint32 type,
        PRUint32 * maxNetworkAdapters
    );

    nsresult (*GetMaxDevicesPerPortForStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 bus,
        PRUint32 * maxDevicesPerPort
    );

    nsresult (*GetMinPortCountForStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 bus,
        PRUint32 * minPortCount
    );

    nsresult (*GetMaxPortCountForStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 bus,
        PRUint32 * maxPortCount
    );

    nsresult (*GetMaxInstancesOfStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 chipset,
        PRUint32 bus,
        PRUint32 * maxInstances
    );

    nsresult (*GetSupportedVRAMRange)(
        IPlatformProperties *pThis,
        PRUint32 graphicsControllerType,
        PRBool accelerate3DEnabled,
        PRUint32 * minMB,
        PRUint32 * maxMB,
        PRUint32 * strideSizeMB
    );

    nsresult (*GetSupportedGfxFeaturesForType)(
        IPlatformProperties *pThis,
        PRUint32 graphicsControllerType,
        PRUint32 *supportedControllerFeaturesSize,
        PRUint32** supportedControllerFeatures
    );

    nsresult (*GetDeviceTypesForStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 bus,
        PRUint32 *deviceTypesSize,
        PRUint32** deviceTypes
    );

    nsresult (*GetStorageBusForControllerType)(
        IPlatformProperties *pThis,
        PRUint32 storageControllerType,
        PRUint32 * storageBus
    );

    nsresult (*GetStorageControllerTypesForBus)(
        IPlatformProperties *pThis,
        PRUint32 storageBus,
        PRUint32 *storageControllerTypeSize,
        PRUint32** storageControllerType
    );

    nsresult (*GetStorageControllerHotplugCapable)(
        IPlatformProperties *pThis,
        PRUint32 controllerType,
        PRBool * hotplugCapable
    );

    nsresult (*GetMaxInstancesOfUSBControllerType)(
        IPlatformProperties *pThis,
        PRUint32 chipset,
        PRUint32 type,
        PRUint32 * maxInstances
    );

    nsresult (*InternalAndReservedMethod1IPlatformProperties)(IPlatformProperties *pThis);

    nsresult (*InternalAndReservedMethod2IPlatformProperties)(IPlatformProperties *pThis);

    nsresult (*InternalAndReservedMethod3IPlatformProperties)(IPlatformProperties *pThis);

    nsresult (*InternalAndReservedMethod4IPlatformProperties)(IPlatformProperties *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IPlatformPropertiesVtbl
{
    nsresult (*QueryInterface)(IPlatformProperties *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IPlatformProperties *pThis);
    nsrefcnt (*Release)(IPlatformProperties *pThis);
    nsresult (*GetRawModeSupported)(IPlatformProperties *pThis, PRBool *rawModeSupported);

    nsresult (*GetExclusiveHwVirt)(IPlatformProperties *pThis, PRBool *exclusiveHwVirt);
    nsresult (*SetExclusiveHwVirt)(IPlatformProperties *pThis, PRBool exclusiveHwVirt);

    nsresult (*GetSerialPortCount)(IPlatformProperties *pThis, PRUint32 *serialPortCount);

    nsresult (*GetParallelPortCount)(IPlatformProperties *pThis, PRUint32 *parallelPortCount);

    nsresult (*GetMaxBootPosition)(IPlatformProperties *pThis, PRUint32 *maxBootPosition);

    nsresult (*GetSupportedParavirtProviders)(IPlatformProperties *pThis, PRUint32 *supportedParavirtProvidersSize, PRUint32 **supportedParavirtProviders);

    nsresult (*GetSupportedFirmwareTypes)(IPlatformProperties *pThis, PRUint32 *supportedFirmwareTypesSize, PRUint32 **supportedFirmwareTypes);

    nsresult (*GetSupportedGuestOSTypes)(IPlatformProperties *pThis, PRUint32 *supportedGuestOSTypesSize, IGuestOSType * **supportedGuestOSTypes);

    nsresult (*GetSupportedGfxControllerTypes)(IPlatformProperties *pThis, PRUint32 *supportedGfxControllerTypesSize, PRUint32 **supportedGfxControllerTypes);

    nsresult (*GetSupportedNetAdpPromiscModePols)(IPlatformProperties *pThis, PRUint32 *supportedNetAdpPromiscModePolsSize, PRUint32 **supportedNetAdpPromiscModePols);

    nsresult (*GetSupportedNetworkAdapterTypes)(IPlatformProperties *pThis, PRUint32 *supportedNetworkAdapterTypesSize, PRUint32 **supportedNetworkAdapterTypes);

    nsresult (*GetSupportedUartTypes)(IPlatformProperties *pThis, PRUint32 *supportedUartTypesSize, PRUint32 **supportedUartTypes);

    nsresult (*GetSupportedUSBControllerTypes)(IPlatformProperties *pThis, PRUint32 *supportedUSBControllerTypesSize, PRUint32 **supportedUSBControllerTypes);

    nsresult (*GetSupportedAudioControllerTypes)(IPlatformProperties *pThis, PRUint32 *supportedAudioControllerTypesSize, PRUint32 **supportedAudioControllerTypes);

    nsresult (*GetSupportedBootDevices)(IPlatformProperties *pThis, PRUint32 *supportedBootDevicesSize, PRUint32 **supportedBootDevices);

    nsresult (*GetSupportedStorageBuses)(IPlatformProperties *pThis, PRUint32 *supportedStorageBusesSize, PRUint32 **supportedStorageBuses);

    nsresult (*GetSupportedStorageControllerTypes)(IPlatformProperties *pThis, PRUint32 *supportedStorageControllerTypesSize, PRUint32 **supportedStorageControllerTypes);

    nsresult (*GetSupportedChipsetTypes)(IPlatformProperties *pThis, PRUint32 *supportedChipsetTypesSize, PRUint32 **supportedChipsetTypes);

    nsresult (*GetSupportedIommuTypes)(IPlatformProperties *pThis, PRUint32 *supportedIommuTypesSize, PRUint32 **supportedIommuTypes);

    nsresult (*GetSupportedTpmTypes)(IPlatformProperties *pThis, PRUint32 *supportedTpmTypesSize, PRUint32 **supportedTpmTypes);

    nsresult (*GetInternalAndReservedAttribute1IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IPlatformProperties)(IPlatformProperties *pThis, PRUint32 *reserved);

    nsresult (*GetMaxNetworkAdapters)(
        IPlatformProperties *pThis,
        PRUint32 chipset,
        PRUint32 * maxNetworkAdapters
    );

    nsresult (*GetMaxNetworkAdaptersOfType)(
        IPlatformProperties *pThis,
        PRUint32 chipset,
        PRUint32 type,
        PRUint32 * maxNetworkAdapters
    );

    nsresult (*GetMaxDevicesPerPortForStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 bus,
        PRUint32 * maxDevicesPerPort
    );

    nsresult (*GetMinPortCountForStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 bus,
        PRUint32 * minPortCount
    );

    nsresult (*GetMaxPortCountForStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 bus,
        PRUint32 * maxPortCount
    );

    nsresult (*GetMaxInstancesOfStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 chipset,
        PRUint32 bus,
        PRUint32 * maxInstances
    );

    nsresult (*GetSupportedVRAMRange)(
        IPlatformProperties *pThis,
        PRUint32 graphicsControllerType,
        PRBool accelerate3DEnabled,
        PRUint32 * minMB,
        PRUint32 * maxMB,
        PRUint32 * strideSizeMB
    );

    nsresult (*GetSupportedGfxFeaturesForType)(
        IPlatformProperties *pThis,
        PRUint32 graphicsControllerType,
        PRUint32 *supportedControllerFeaturesSize,
        PRUint32** supportedControllerFeatures
    );

    nsresult (*GetDeviceTypesForStorageBus)(
        IPlatformProperties *pThis,
        PRUint32 bus,
        PRUint32 *deviceTypesSize,
        PRUint32** deviceTypes
    );

    nsresult (*GetStorageBusForControllerType)(
        IPlatformProperties *pThis,
        PRUint32 storageControllerType,
        PRUint32 * storageBus
    );

    nsresult (*GetStorageControllerTypesForBus)(
        IPlatformProperties *pThis,
        PRUint32 storageBus,
        PRUint32 *storageControllerTypeSize,
        PRUint32** storageControllerType
    );

    nsresult (*GetStorageControllerHotplugCapable)(
        IPlatformProperties *pThis,
        PRUint32 controllerType,
        PRBool * hotplugCapable
    );

    nsresult (*GetMaxInstancesOfUSBControllerType)(
        IPlatformProperties *pThis,
        PRUint32 chipset,
        PRUint32 type,
        PRUint32 * maxInstances
    );

    nsresult (*InternalAndReservedMethod1IPlatformProperties)(IPlatformProperties *pThis);

    nsresult (*InternalAndReservedMethod2IPlatformProperties)(IPlatformProperties *pThis);

    nsresult (*InternalAndReservedMethod3IPlatformProperties)(IPlatformProperties *pThis);

    nsresult (*InternalAndReservedMethod4IPlatformProperties)(IPlatformProperties *pThis);

};
#define IPlatformProperties_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IPlatformProperties_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IPlatformProperties_Release(p) ((p)->lpVtbl->Release(p))
#define IPlatformProperties_get_RawModeSupported(p, aRawModeSupported) ((p)->lpVtbl->GetRawModeSupported(p, aRawModeSupported))
#define IPlatformProperties_GetRawModeSupported(p, aRawModeSupported) ((p)->lpVtbl->GetRawModeSupported(p, aRawModeSupported))
#define IPlatformProperties_get_ExclusiveHwVirt(p, aExclusiveHwVirt) ((p)->lpVtbl->GetExclusiveHwVirt(p, aExclusiveHwVirt))
#define IPlatformProperties_GetExclusiveHwVirt(p, aExclusiveHwVirt) ((p)->lpVtbl->GetExclusiveHwVirt(p, aExclusiveHwVirt))
#define IPlatformProperties_put_ExclusiveHwVirt(p, aExclusiveHwVirt) ((p)->lpVtbl->SetExclusiveHwVirt(p, aExclusiveHwVirt))
#define IPlatformProperties_SetExclusiveHwVirt(p, aExclusiveHwVirt) ((p)->lpVtbl->SetExclusiveHwVirt(p, aExclusiveHwVirt))
#define IPlatformProperties_get_SerialPortCount(p, aSerialPortCount) ((p)->lpVtbl->GetSerialPortCount(p, aSerialPortCount))
#define IPlatformProperties_GetSerialPortCount(p, aSerialPortCount) ((p)->lpVtbl->GetSerialPortCount(p, aSerialPortCount))
#define IPlatformProperties_get_ParallelPortCount(p, aParallelPortCount) ((p)->lpVtbl->GetParallelPortCount(p, aParallelPortCount))
#define IPlatformProperties_GetParallelPortCount(p, aParallelPortCount) ((p)->lpVtbl->GetParallelPortCount(p, aParallelPortCount))
#define IPlatformProperties_get_MaxBootPosition(p, aMaxBootPosition) ((p)->lpVtbl->GetMaxBootPosition(p, aMaxBootPosition))
#define IPlatformProperties_GetMaxBootPosition(p, aMaxBootPosition) ((p)->lpVtbl->GetMaxBootPosition(p, aMaxBootPosition))
#define IPlatformProperties_get_SupportedParavirtProviders(p, aSupportedParavirtProviders) ((p)->lpVtbl->GetSupportedParavirtProviders(p, aSupportedParavirtProviders))
#define IPlatformProperties_GetSupportedParavirtProviders(p, aSupportedParavirtProviders) ((p)->lpVtbl->GetSupportedParavirtProviders(p, aSupportedParavirtProviders))
#define IPlatformProperties_get_SupportedFirmwareTypes(p, aSupportedFirmwareTypes) ((p)->lpVtbl->GetSupportedFirmwareTypes(p, aSupportedFirmwareTypes))
#define IPlatformProperties_GetSupportedFirmwareTypes(p, aSupportedFirmwareTypes) ((p)->lpVtbl->GetSupportedFirmwareTypes(p, aSupportedFirmwareTypes))
#define IPlatformProperties_get_SupportedGuestOSTypes(p, aSupportedGuestOSTypes) ((p)->lpVtbl->GetSupportedGuestOSTypes(p, aSupportedGuestOSTypes))
#define IPlatformProperties_GetSupportedGuestOSTypes(p, aSupportedGuestOSTypes) ((p)->lpVtbl->GetSupportedGuestOSTypes(p, aSupportedGuestOSTypes))
#define IPlatformProperties_get_SupportedGfxControllerTypes(p, aSupportedGfxControllerTypes) ((p)->lpVtbl->GetSupportedGfxControllerTypes(p, aSupportedGfxControllerTypes))
#define IPlatformProperties_GetSupportedGfxControllerTypes(p, aSupportedGfxControllerTypes) ((p)->lpVtbl->GetSupportedGfxControllerTypes(p, aSupportedGfxControllerTypes))
#define IPlatformProperties_get_SupportedNetAdpPromiscModePols(p, aSupportedNetAdpPromiscModePols) ((p)->lpVtbl->GetSupportedNetAdpPromiscModePols(p, aSupportedNetAdpPromiscModePols))
#define IPlatformProperties_GetSupportedNetAdpPromiscModePols(p, aSupportedNetAdpPromiscModePols) ((p)->lpVtbl->GetSupportedNetAdpPromiscModePols(p, aSupportedNetAdpPromiscModePols))
#define IPlatformProperties_get_SupportedNetworkAdapterTypes(p, aSupportedNetworkAdapterTypes) ((p)->lpVtbl->GetSupportedNetworkAdapterTypes(p, aSupportedNetworkAdapterTypes))
#define IPlatformProperties_GetSupportedNetworkAdapterTypes(p, aSupportedNetworkAdapterTypes) ((p)->lpVtbl->GetSupportedNetworkAdapterTypes(p, aSupportedNetworkAdapterTypes))
#define IPlatformProperties_get_SupportedUartTypes(p, aSupportedUartTypes) ((p)->lpVtbl->GetSupportedUartTypes(p, aSupportedUartTypes))
#define IPlatformProperties_GetSupportedUartTypes(p, aSupportedUartTypes) ((p)->lpVtbl->GetSupportedUartTypes(p, aSupportedUartTypes))
#define IPlatformProperties_get_SupportedUSBControllerTypes(p, aSupportedUSBControllerTypes) ((p)->lpVtbl->GetSupportedUSBControllerTypes(p, aSupportedUSBControllerTypes))
#define IPlatformProperties_GetSupportedUSBControllerTypes(p, aSupportedUSBControllerTypes) ((p)->lpVtbl->GetSupportedUSBControllerTypes(p, aSupportedUSBControllerTypes))
#define IPlatformProperties_get_SupportedAudioControllerTypes(p, aSupportedAudioControllerTypes) ((p)->lpVtbl->GetSupportedAudioControllerTypes(p, aSupportedAudioControllerTypes))
#define IPlatformProperties_GetSupportedAudioControllerTypes(p, aSupportedAudioControllerTypes) ((p)->lpVtbl->GetSupportedAudioControllerTypes(p, aSupportedAudioControllerTypes))
#define IPlatformProperties_get_SupportedBootDevices(p, aSupportedBootDevices) ((p)->lpVtbl->GetSupportedBootDevices(p, aSupportedBootDevices))
#define IPlatformProperties_GetSupportedBootDevices(p, aSupportedBootDevices) ((p)->lpVtbl->GetSupportedBootDevices(p, aSupportedBootDevices))
#define IPlatformProperties_get_SupportedStorageBuses(p, aSupportedStorageBuses) ((p)->lpVtbl->GetSupportedStorageBuses(p, aSupportedStorageBuses))
#define IPlatformProperties_GetSupportedStorageBuses(p, aSupportedStorageBuses) ((p)->lpVtbl->GetSupportedStorageBuses(p, aSupportedStorageBuses))
#define IPlatformProperties_get_SupportedStorageControllerTypes(p, aSupportedStorageControllerTypes) ((p)->lpVtbl->GetSupportedStorageControllerTypes(p, aSupportedStorageControllerTypes))
#define IPlatformProperties_GetSupportedStorageControllerTypes(p, aSupportedStorageControllerTypes) ((p)->lpVtbl->GetSupportedStorageControllerTypes(p, aSupportedStorageControllerTypes))
#define IPlatformProperties_get_SupportedChipsetTypes(p, aSupportedChipsetTypes) ((p)->lpVtbl->GetSupportedChipsetTypes(p, aSupportedChipsetTypes))
#define IPlatformProperties_GetSupportedChipsetTypes(p, aSupportedChipsetTypes) ((p)->lpVtbl->GetSupportedChipsetTypes(p, aSupportedChipsetTypes))
#define IPlatformProperties_get_SupportedIommuTypes(p, aSupportedIommuTypes) ((p)->lpVtbl->GetSupportedIommuTypes(p, aSupportedIommuTypes))
#define IPlatformProperties_GetSupportedIommuTypes(p, aSupportedIommuTypes) ((p)->lpVtbl->GetSupportedIommuTypes(p, aSupportedIommuTypes))
#define IPlatformProperties_get_SupportedTpmTypes(p, aSupportedTpmTypes) ((p)->lpVtbl->GetSupportedTpmTypes(p, aSupportedTpmTypes))
#define IPlatformProperties_GetSupportedTpmTypes(p, aSupportedTpmTypes) ((p)->lpVtbl->GetSupportedTpmTypes(p, aSupportedTpmTypes))
#define IPlatformProperties_GetMaxNetworkAdapters(p, aChipset, aMaxNetworkAdapters) ((p)->lpVtbl->GetMaxNetworkAdapters(p, aChipset, aMaxNetworkAdapters))
#define IPlatformProperties_GetMaxNetworkAdaptersOfType(p, aChipset, aType, aMaxNetworkAdapters) ((p)->lpVtbl->GetMaxNetworkAdaptersOfType(p, aChipset, aType, aMaxNetworkAdapters))
#define IPlatformProperties_GetMaxDevicesPerPortForStorageBus(p, aBus, aMaxDevicesPerPort) ((p)->lpVtbl->GetMaxDevicesPerPortForStorageBus(p, aBus, aMaxDevicesPerPort))
#define IPlatformProperties_GetMinPortCountForStorageBus(p, aBus, aMinPortCount) ((p)->lpVtbl->GetMinPortCountForStorageBus(p, aBus, aMinPortCount))
#define IPlatformProperties_GetMaxPortCountForStorageBus(p, aBus, aMaxPortCount) ((p)->lpVtbl->GetMaxPortCountForStorageBus(p, aBus, aMaxPortCount))
#define IPlatformProperties_GetMaxInstancesOfStorageBus(p, aChipset, aBus, aMaxInstances) ((p)->lpVtbl->GetMaxInstancesOfStorageBus(p, aChipset, aBus, aMaxInstances))
#define IPlatformProperties_GetSupportedVRAMRange(p, aGraphicsControllerType, aAccelerate3DEnabled, aMinMB, aMaxMB, aStrideSizeMB) ((p)->lpVtbl->GetSupportedVRAMRange(p, aGraphicsControllerType, aAccelerate3DEnabled, aMinMB, aMaxMB, aStrideSizeMB))
#define IPlatformProperties_GetSupportedGfxFeaturesForType(p, aGraphicsControllerType, aSupportedControllerFeatures) ((p)->lpVtbl->GetSupportedGfxFeaturesForType(p, aGraphicsControllerType, aSupportedControllerFeatures))
#define IPlatformProperties_GetDeviceTypesForStorageBus(p, aBus, aDeviceTypes) ((p)->lpVtbl->GetDeviceTypesForStorageBus(p, aBus, aDeviceTypes))
#define IPlatformProperties_GetStorageBusForControllerType(p, aStorageControllerType, aStorageBus) ((p)->lpVtbl->GetStorageBusForControllerType(p, aStorageControllerType, aStorageBus))
#define IPlatformProperties_GetStorageControllerTypesForBus(p, aStorageBus, aStorageControllerType) ((p)->lpVtbl->GetStorageControllerTypesForBus(p, aStorageBus, aStorageControllerType))
#define IPlatformProperties_GetStorageControllerHotplugCapable(p, aControllerType, aHotplugCapable) ((p)->lpVtbl->GetStorageControllerHotplugCapable(p, aControllerType, aHotplugCapable))
#define IPlatformProperties_GetMaxInstancesOfUSBControllerType(p, aChipset, aType, aMaxInstances) ((p)->lpVtbl->GetMaxInstancesOfUSBControllerType(p, aChipset, aType, aMaxInstances))
#endif /* VBOX_WITH_GLUE */

interface IPlatformProperties
{
#ifndef VBOX_WITH_GLUE
    struct IPlatformProperties_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IPlatformPropertiesVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IPlatformProperties declaration */


/* Start of struct ISystemProperties declaration */
#define ISYSTEMPROPERTIES_IID_STR "925084b0-625f-422f-a67d-0ede1880a56c"
#define ISYSTEMPROPERTIES_IID { \
    0x925084b0, 0x625f, 0x422f, \
    { 0xa6, 0x7d, 0x0e, 0xde, 0x18, 0x80, 0xa5, 0x6c } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_ISystemProperties);
#ifndef VBOX_WITH_GLUE
struct ISystemProperties_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetPlatform)(ISystemProperties *pThis, IPlatformProperties * *platform);

    nsresult (*GetMinGuestRAM)(ISystemProperties *pThis, PRUint32 *minGuestRAM);

    nsresult (*GetMaxGuestRAM)(ISystemProperties *pThis, PRUint32 *maxGuestRAM);

    nsresult (*GetMinGuestVRAM)(ISystemProperties *pThis, PRUint32 *minGuestVRAM);

    nsresult (*GetMaxGuestVRAM)(ISystemProperties *pThis, PRUint32 *maxGuestVRAM);

    nsresult (*GetMinGuestCPUCount)(ISystemProperties *pThis, PRUint32 *minGuestCPUCount);

    nsresult (*GetMaxGuestCPUCount)(ISystemProperties *pThis, PRUint32 *maxGuestCPUCount);

    nsresult (*GetMaxGuestMonitors)(ISystemProperties *pThis, PRUint32 *maxGuestMonitors);

    nsresult (*GetInfoVDSize)(ISystemProperties *pThis, PRInt64 *infoVDSize);

    nsresult (*GetDefaultMachineFolder)(ISystemProperties *pThis, PRUnichar * *defaultMachineFolder);
    nsresult (*SetDefaultMachineFolder)(ISystemProperties *pThis, PRUnichar * defaultMachineFolder);

    nsresult (*GetLoggingLevel)(ISystemProperties *pThis, PRUnichar * *loggingLevel);
    nsresult (*SetLoggingLevel)(ISystemProperties *pThis, PRUnichar * loggingLevel);

    nsresult (*GetMediumFormats)(ISystemProperties *pThis, PRUint32 *mediumFormatsSize, IMediumFormat * **mediumFormats);

    nsresult (*GetDefaultHardDiskFormat)(ISystemProperties *pThis, PRUnichar * *defaultHardDiskFormat);
    nsresult (*SetDefaultHardDiskFormat)(ISystemProperties *pThis, PRUnichar * defaultHardDiskFormat);

    nsresult (*GetFreeDiskSpaceWarning)(ISystemProperties *pThis, PRInt64 *freeDiskSpaceWarning);
    nsresult (*SetFreeDiskSpaceWarning)(ISystemProperties *pThis, PRInt64 freeDiskSpaceWarning);

    nsresult (*GetFreeDiskSpacePercentWarning)(ISystemProperties *pThis, PRUint32 *freeDiskSpacePercentWarning);
    nsresult (*SetFreeDiskSpacePercentWarning)(ISystemProperties *pThis, PRUint32 freeDiskSpacePercentWarning);

    nsresult (*GetFreeDiskSpaceError)(ISystemProperties *pThis, PRInt64 *freeDiskSpaceError);
    nsresult (*SetFreeDiskSpaceError)(ISystemProperties *pThis, PRInt64 freeDiskSpaceError);

    nsresult (*GetFreeDiskSpacePercentError)(ISystemProperties *pThis, PRUint32 *freeDiskSpacePercentError);
    nsresult (*SetFreeDiskSpacePercentError)(ISystemProperties *pThis, PRUint32 freeDiskSpacePercentError);

    nsresult (*GetVRDEAuthLibrary)(ISystemProperties *pThis, PRUnichar * *VRDEAuthLibrary);
    nsresult (*SetVRDEAuthLibrary)(ISystemProperties *pThis, PRUnichar * VRDEAuthLibrary);

    nsresult (*GetWebServiceAuthLibrary)(ISystemProperties *pThis, PRUnichar * *webServiceAuthLibrary);
    nsresult (*SetWebServiceAuthLibrary)(ISystemProperties *pThis, PRUnichar * webServiceAuthLibrary);

    nsresult (*GetDefaultVRDEExtPack)(ISystemProperties *pThis, PRUnichar * *defaultVRDEExtPack);
    nsresult (*SetDefaultVRDEExtPack)(ISystemProperties *pThis, PRUnichar * defaultVRDEExtPack);

    nsresult (*GetDefaultCryptoExtPack)(ISystemProperties *pThis, PRUnichar * *defaultCryptoExtPack);
    nsresult (*SetDefaultCryptoExtPack)(ISystemProperties *pThis, PRUnichar * defaultCryptoExtPack);

    nsresult (*GetLogHistoryCount)(ISystemProperties *pThis, PRUint32 *logHistoryCount);
    nsresult (*SetLogHistoryCount)(ISystemProperties *pThis, PRUint32 logHistoryCount);

    nsresult (*GetDefaultAudioDriver)(ISystemProperties *pThis, PRUint32 *defaultAudioDriver);

    nsresult (*GetAutostartDatabasePath)(ISystemProperties *pThis, PRUnichar * *autostartDatabasePath);
    nsresult (*SetAutostartDatabasePath)(ISystemProperties *pThis, PRUnichar * autostartDatabasePath);

    nsresult (*GetDefaultAdditionsISO)(ISystemProperties *pThis, PRUnichar * *defaultAdditionsISO);
    nsresult (*SetDefaultAdditionsISO)(ISystemProperties *pThis, PRUnichar * defaultAdditionsISO);

    nsresult (*GetDefaultFrontend)(ISystemProperties *pThis, PRUnichar * *defaultFrontend);
    nsresult (*SetDefaultFrontend)(ISystemProperties *pThis, PRUnichar * defaultFrontend);

    nsresult (*GetScreenShotFormats)(ISystemProperties *pThis, PRUint32 *screenShotFormatsSize, PRUint32 **screenShotFormats);

    nsresult (*GetProxyMode)(ISystemProperties *pThis, PRUint32 *proxyMode);
    nsresult (*SetProxyMode)(ISystemProperties *pThis, PRUint32 proxyMode);

    nsresult (*GetProxyURL)(ISystemProperties *pThis, PRUnichar * *proxyURL);
    nsresult (*SetProxyURL)(ISystemProperties *pThis, PRUnichar * proxyURL);

    nsresult (*GetSupportedPlatformArchitectures)(ISystemProperties *pThis, PRUint32 *supportedPlatformArchitecturesSize, PRUint32 **supportedPlatformArchitectures);

    nsresult (*GetSupportedClipboardModes)(ISystemProperties *pThis, PRUint32 *supportedClipboardModesSize, PRUint32 **supportedClipboardModes);

    nsresult (*GetSupportedDnDModes)(ISystemProperties *pThis, PRUint32 *supportedDnDModesSize, PRUint32 **supportedDnDModes);

    nsresult (*GetSupportedPointingHIDTypes)(ISystemProperties *pThis, PRUint32 *supportedPointingHIDTypesSize, PRUint32 **supportedPointingHIDTypes);

    nsresult (*GetSupportedKeyboardHIDTypes)(ISystemProperties *pThis, PRUint32 *supportedKeyboardHIDTypesSize, PRUint32 **supportedKeyboardHIDTypes);

    nsresult (*GetSupportedVFSTypes)(ISystemProperties *pThis, PRUint32 *supportedVFSTypesSize, PRUint32 **supportedVFSTypes);

    nsresult (*GetSupportedImportOptions)(ISystemProperties *pThis, PRUint32 *supportedImportOptionsSize, PRUint32 **supportedImportOptions);

    nsresult (*GetSupportedExportOptions)(ISystemProperties *pThis, PRUint32 *supportedExportOptionsSize, PRUint32 **supportedExportOptions);

    nsresult (*GetSupportedGraphicsFeatures)(ISystemProperties *pThis, PRUint32 *supportedGraphicsFeaturesSize, PRUint32 **supportedGraphicsFeatures);

    nsresult (*GetSupportedRecordingFeatures)(ISystemProperties *pThis, PRUint32 *supportedRecordingFeaturesSize, PRUint32 **supportedRecordingFeatures);

    nsresult (*GetSupportedRecordingAudioCodecs)(ISystemProperties *pThis, PRUint32 *supportedRecordingAudioCodecsSize, PRUint32 **supportedRecordingAudioCodecs);

    nsresult (*GetSupportedRecordingVideoCodecs)(ISystemProperties *pThis, PRUint32 *supportedRecordingVideoCodecsSize, PRUint32 **supportedRecordingVideoCodecs);

    nsresult (*GetSupportedRecordingVSModes)(ISystemProperties *pThis, PRUint32 *supportedRecordingVSModesSize, PRUint32 **supportedRecordingVSModes);

    nsresult (*GetSupportedRecordingARCModes)(ISystemProperties *pThis, PRUint32 *supportedRecordingARCModesSize, PRUint32 **supportedRecordingARCModes);

    nsresult (*GetSupportedRecordingVRCModes)(ISystemProperties *pThis, PRUint32 *supportedRecordingVRCModesSize, PRUint32 **supportedRecordingVRCModes);

    nsresult (*GetSupportedCloneOptions)(ISystemProperties *pThis, PRUint32 *supportedCloneOptionsSize, PRUint32 **supportedCloneOptions);

    nsresult (*GetSupportedAutostopTypes)(ISystemProperties *pThis, PRUint32 *supportedAutostopTypesSize, PRUint32 **supportedAutostopTypes);

    nsresult (*GetSupportedVMProcPriorities)(ISystemProperties *pThis, PRUint32 *supportedVMProcPrioritiesSize, PRUint32 **supportedVMProcPriorities);

    nsresult (*GetSupportedNetworkAttachmentTypes)(ISystemProperties *pThis, PRUint32 *supportedNetworkAttachmentTypesSize, PRUint32 **supportedNetworkAttachmentTypes);

    nsresult (*GetSupportedPortModes)(ISystemProperties *pThis, PRUint32 *supportedPortModesSize, PRUint32 **supportedPortModes);

    nsresult (*GetSupportedAudioDriverTypes)(ISystemProperties *pThis, PRUint32 *supportedAudioDriverTypesSize, PRUint32 **supportedAudioDriverTypes);

    nsresult (*GetLanguageId)(ISystemProperties *pThis, PRUnichar * *languageId);
    nsresult (*SetLanguageId)(ISystemProperties *pThis, PRUnichar * languageId);

    nsresult (*GetInternalAndReservedAttribute1ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetDefaultIoCacheSettingForStorageController)(
        ISystemProperties *pThis,
        PRUint32 controllerType,
        PRBool * enabled
    );

    nsresult (*GetCPUProfiles)(
        ISystemProperties *pThis,
        PRUint32 architecture,
        PRUnichar * namePattern,
        PRUint32 *profilesSize,
        ICPUProfile *** profiles
    );

    nsresult (*GetExecutionEnginesForVmCpuArchitecture)(
        ISystemProperties *pThis,
        PRUint32 cpuArchitecture,
        PRUint32 *executionEngineSize,
        PRUint32** executionEngine
    );

    nsresult (*InternalAndReservedMethod1ISystemProperties)(ISystemProperties *pThis);

    nsresult (*InternalAndReservedMethod2ISystemProperties)(ISystemProperties *pThis);

    nsresult (*InternalAndReservedMethod3ISystemProperties)(ISystemProperties *pThis);

    nsresult (*InternalAndReservedMethod4ISystemProperties)(ISystemProperties *pThis);

};
#else /* VBOX_WITH_GLUE */
struct ISystemPropertiesVtbl
{
    nsresult (*QueryInterface)(ISystemProperties *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(ISystemProperties *pThis);
    nsrefcnt (*Release)(ISystemProperties *pThis);
    nsresult (*GetPlatform)(ISystemProperties *pThis, IPlatformProperties * *platform);

    nsresult (*GetMinGuestRAM)(ISystemProperties *pThis, PRUint32 *minGuestRAM);

    nsresult (*GetMaxGuestRAM)(ISystemProperties *pThis, PRUint32 *maxGuestRAM);

    nsresult (*GetMinGuestVRAM)(ISystemProperties *pThis, PRUint32 *minGuestVRAM);

    nsresult (*GetMaxGuestVRAM)(ISystemProperties *pThis, PRUint32 *maxGuestVRAM);

    nsresult (*GetMinGuestCPUCount)(ISystemProperties *pThis, PRUint32 *minGuestCPUCount);

    nsresult (*GetMaxGuestCPUCount)(ISystemProperties *pThis, PRUint32 *maxGuestCPUCount);

    nsresult (*GetMaxGuestMonitors)(ISystemProperties *pThis, PRUint32 *maxGuestMonitors);

    nsresult (*GetInfoVDSize)(ISystemProperties *pThis, PRInt64 *infoVDSize);

    nsresult (*GetDefaultMachineFolder)(ISystemProperties *pThis, PRUnichar * *defaultMachineFolder);
    nsresult (*SetDefaultMachineFolder)(ISystemProperties *pThis, PRUnichar * defaultMachineFolder);

    nsresult (*GetLoggingLevel)(ISystemProperties *pThis, PRUnichar * *loggingLevel);
    nsresult (*SetLoggingLevel)(ISystemProperties *pThis, PRUnichar * loggingLevel);

    nsresult (*GetMediumFormats)(ISystemProperties *pThis, PRUint32 *mediumFormatsSize, IMediumFormat * **mediumFormats);

    nsresult (*GetDefaultHardDiskFormat)(ISystemProperties *pThis, PRUnichar * *defaultHardDiskFormat);
    nsresult (*SetDefaultHardDiskFormat)(ISystemProperties *pThis, PRUnichar * defaultHardDiskFormat);

    nsresult (*GetFreeDiskSpaceWarning)(ISystemProperties *pThis, PRInt64 *freeDiskSpaceWarning);
    nsresult (*SetFreeDiskSpaceWarning)(ISystemProperties *pThis, PRInt64 freeDiskSpaceWarning);

    nsresult (*GetFreeDiskSpacePercentWarning)(ISystemProperties *pThis, PRUint32 *freeDiskSpacePercentWarning);
    nsresult (*SetFreeDiskSpacePercentWarning)(ISystemProperties *pThis, PRUint32 freeDiskSpacePercentWarning);

    nsresult (*GetFreeDiskSpaceError)(ISystemProperties *pThis, PRInt64 *freeDiskSpaceError);
    nsresult (*SetFreeDiskSpaceError)(ISystemProperties *pThis, PRInt64 freeDiskSpaceError);

    nsresult (*GetFreeDiskSpacePercentError)(ISystemProperties *pThis, PRUint32 *freeDiskSpacePercentError);
    nsresult (*SetFreeDiskSpacePercentError)(ISystemProperties *pThis, PRUint32 freeDiskSpacePercentError);

    nsresult (*GetVRDEAuthLibrary)(ISystemProperties *pThis, PRUnichar * *VRDEAuthLibrary);
    nsresult (*SetVRDEAuthLibrary)(ISystemProperties *pThis, PRUnichar * VRDEAuthLibrary);

    nsresult (*GetWebServiceAuthLibrary)(ISystemProperties *pThis, PRUnichar * *webServiceAuthLibrary);
    nsresult (*SetWebServiceAuthLibrary)(ISystemProperties *pThis, PRUnichar * webServiceAuthLibrary);

    nsresult (*GetDefaultVRDEExtPack)(ISystemProperties *pThis, PRUnichar * *defaultVRDEExtPack);
    nsresult (*SetDefaultVRDEExtPack)(ISystemProperties *pThis, PRUnichar * defaultVRDEExtPack);

    nsresult (*GetDefaultCryptoExtPack)(ISystemProperties *pThis, PRUnichar * *defaultCryptoExtPack);
    nsresult (*SetDefaultCryptoExtPack)(ISystemProperties *pThis, PRUnichar * defaultCryptoExtPack);

    nsresult (*GetLogHistoryCount)(ISystemProperties *pThis, PRUint32 *logHistoryCount);
    nsresult (*SetLogHistoryCount)(ISystemProperties *pThis, PRUint32 logHistoryCount);

    nsresult (*GetDefaultAudioDriver)(ISystemProperties *pThis, PRUint32 *defaultAudioDriver);

    nsresult (*GetAutostartDatabasePath)(ISystemProperties *pThis, PRUnichar * *autostartDatabasePath);
    nsresult (*SetAutostartDatabasePath)(ISystemProperties *pThis, PRUnichar * autostartDatabasePath);

    nsresult (*GetDefaultAdditionsISO)(ISystemProperties *pThis, PRUnichar * *defaultAdditionsISO);
    nsresult (*SetDefaultAdditionsISO)(ISystemProperties *pThis, PRUnichar * defaultAdditionsISO);

    nsresult (*GetDefaultFrontend)(ISystemProperties *pThis, PRUnichar * *defaultFrontend);
    nsresult (*SetDefaultFrontend)(ISystemProperties *pThis, PRUnichar * defaultFrontend);

    nsresult (*GetScreenShotFormats)(ISystemProperties *pThis, PRUint32 *screenShotFormatsSize, PRUint32 **screenShotFormats);

    nsresult (*GetProxyMode)(ISystemProperties *pThis, PRUint32 *proxyMode);
    nsresult (*SetProxyMode)(ISystemProperties *pThis, PRUint32 proxyMode);

    nsresult (*GetProxyURL)(ISystemProperties *pThis, PRUnichar * *proxyURL);
    nsresult (*SetProxyURL)(ISystemProperties *pThis, PRUnichar * proxyURL);

    nsresult (*GetSupportedPlatformArchitectures)(ISystemProperties *pThis, PRUint32 *supportedPlatformArchitecturesSize, PRUint32 **supportedPlatformArchitectures);

    nsresult (*GetSupportedClipboardModes)(ISystemProperties *pThis, PRUint32 *supportedClipboardModesSize, PRUint32 **supportedClipboardModes);

    nsresult (*GetSupportedDnDModes)(ISystemProperties *pThis, PRUint32 *supportedDnDModesSize, PRUint32 **supportedDnDModes);

    nsresult (*GetSupportedPointingHIDTypes)(ISystemProperties *pThis, PRUint32 *supportedPointingHIDTypesSize, PRUint32 **supportedPointingHIDTypes);

    nsresult (*GetSupportedKeyboardHIDTypes)(ISystemProperties *pThis, PRUint32 *supportedKeyboardHIDTypesSize, PRUint32 **supportedKeyboardHIDTypes);

    nsresult (*GetSupportedVFSTypes)(ISystemProperties *pThis, PRUint32 *supportedVFSTypesSize, PRUint32 **supportedVFSTypes);

    nsresult (*GetSupportedImportOptions)(ISystemProperties *pThis, PRUint32 *supportedImportOptionsSize, PRUint32 **supportedImportOptions);

    nsresult (*GetSupportedExportOptions)(ISystemProperties *pThis, PRUint32 *supportedExportOptionsSize, PRUint32 **supportedExportOptions);

    nsresult (*GetSupportedGraphicsFeatures)(ISystemProperties *pThis, PRUint32 *supportedGraphicsFeaturesSize, PRUint32 **supportedGraphicsFeatures);

    nsresult (*GetSupportedRecordingFeatures)(ISystemProperties *pThis, PRUint32 *supportedRecordingFeaturesSize, PRUint32 **supportedRecordingFeatures);

    nsresult (*GetSupportedRecordingAudioCodecs)(ISystemProperties *pThis, PRUint32 *supportedRecordingAudioCodecsSize, PRUint32 **supportedRecordingAudioCodecs);

    nsresult (*GetSupportedRecordingVideoCodecs)(ISystemProperties *pThis, PRUint32 *supportedRecordingVideoCodecsSize, PRUint32 **supportedRecordingVideoCodecs);

    nsresult (*GetSupportedRecordingVSModes)(ISystemProperties *pThis, PRUint32 *supportedRecordingVSModesSize, PRUint32 **supportedRecordingVSModes);

    nsresult (*GetSupportedRecordingARCModes)(ISystemProperties *pThis, PRUint32 *supportedRecordingARCModesSize, PRUint32 **supportedRecordingARCModes);

    nsresult (*GetSupportedRecordingVRCModes)(ISystemProperties *pThis, PRUint32 *supportedRecordingVRCModesSize, PRUint32 **supportedRecordingVRCModes);

    nsresult (*GetSupportedCloneOptions)(ISystemProperties *pThis, PRUint32 *supportedCloneOptionsSize, PRUint32 **supportedCloneOptions);

    nsresult (*GetSupportedAutostopTypes)(ISystemProperties *pThis, PRUint32 *supportedAutostopTypesSize, PRUint32 **supportedAutostopTypes);

    nsresult (*GetSupportedVMProcPriorities)(ISystemProperties *pThis, PRUint32 *supportedVMProcPrioritiesSize, PRUint32 **supportedVMProcPriorities);

    nsresult (*GetSupportedNetworkAttachmentTypes)(ISystemProperties *pThis, PRUint32 *supportedNetworkAttachmentTypesSize, PRUint32 **supportedNetworkAttachmentTypes);

    nsresult (*GetSupportedPortModes)(ISystemProperties *pThis, PRUint32 *supportedPortModesSize, PRUint32 **supportedPortModes);

    nsresult (*GetSupportedAudioDriverTypes)(ISystemProperties *pThis, PRUint32 *supportedAudioDriverTypesSize, PRUint32 **supportedAudioDriverTypes);

    nsresult (*GetLanguageId)(ISystemProperties *pThis, PRUnichar * *languageId);
    nsresult (*SetLanguageId)(ISystemProperties *pThis, PRUnichar * languageId);

    nsresult (*GetInternalAndReservedAttribute1ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16ISystemProperties)(ISystemProperties *pThis, PRUint32 *reserved);

    nsresult (*GetDefaultIoCacheSettingForStorageController)(
        ISystemProperties *pThis,
        PRUint32 controllerType,
        PRBool * enabled
    );

    nsresult (*GetCPUProfiles)(
        ISystemProperties *pThis,
        PRUint32 architecture,
        PRUnichar * namePattern,
        PRUint32 *profilesSize,
        ICPUProfile *** profiles
    );

    nsresult (*GetExecutionEnginesForVmCpuArchitecture)(
        ISystemProperties *pThis,
        PRUint32 cpuArchitecture,
        PRUint32 *executionEngineSize,
        PRUint32** executionEngine
    );

    nsresult (*InternalAndReservedMethod1ISystemProperties)(ISystemProperties *pThis);

    nsresult (*InternalAndReservedMethod2ISystemProperties)(ISystemProperties *pThis);

    nsresult (*InternalAndReservedMethod3ISystemProperties)(ISystemProperties *pThis);

    nsresult (*InternalAndReservedMethod4ISystemProperties)(ISystemProperties *pThis);

};
#define ISystemProperties_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define ISystemProperties_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define ISystemProperties_Release(p) ((p)->lpVtbl->Release(p))
#define ISystemProperties_get_Platform(p, aPlatform) ((p)->lpVtbl->GetPlatform(p, aPlatform))
#define ISystemProperties_GetPlatform(p, aPlatform) ((p)->lpVtbl->GetPlatform(p, aPlatform))
#define ISystemProperties_get_MinGuestRAM(p, aMinGuestRAM) ((p)->lpVtbl->GetMinGuestRAM(p, aMinGuestRAM))
#define ISystemProperties_GetMinGuestRAM(p, aMinGuestRAM) ((p)->lpVtbl->GetMinGuestRAM(p, aMinGuestRAM))
#define ISystemProperties_get_MaxGuestRAM(p, aMaxGuestRAM) ((p)->lpVtbl->GetMaxGuestRAM(p, aMaxGuestRAM))
#define ISystemProperties_GetMaxGuestRAM(p, aMaxGuestRAM) ((p)->lpVtbl->GetMaxGuestRAM(p, aMaxGuestRAM))
#define ISystemProperties_get_MinGuestVRAM(p, aMinGuestVRAM) ((p)->lpVtbl->GetMinGuestVRAM(p, aMinGuestVRAM))
#define ISystemProperties_GetMinGuestVRAM(p, aMinGuestVRAM) ((p)->lpVtbl->GetMinGuestVRAM(p, aMinGuestVRAM))
#define ISystemProperties_get_MaxGuestVRAM(p, aMaxGuestVRAM) ((p)->lpVtbl->GetMaxGuestVRAM(p, aMaxGuestVRAM))
#define ISystemProperties_GetMaxGuestVRAM(p, aMaxGuestVRAM) ((p)->lpVtbl->GetMaxGuestVRAM(p, aMaxGuestVRAM))
#define ISystemProperties_get_MinGuestCPUCount(p, aMinGuestCPUCount) ((p)->lpVtbl->GetMinGuestCPUCount(p, aMinGuestCPUCount))
#define ISystemProperties_GetMinGuestCPUCount(p, aMinGuestCPUCount) ((p)->lpVtbl->GetMinGuestCPUCount(p, aMinGuestCPUCount))
#define ISystemProperties_get_MaxGuestCPUCount(p, aMaxGuestCPUCount) ((p)->lpVtbl->GetMaxGuestCPUCount(p, aMaxGuestCPUCount))
#define ISystemProperties_GetMaxGuestCPUCount(p, aMaxGuestCPUCount) ((p)->lpVtbl->GetMaxGuestCPUCount(p, aMaxGuestCPUCount))
#define ISystemProperties_get_MaxGuestMonitors(p, aMaxGuestMonitors) ((p)->lpVtbl->GetMaxGuestMonitors(p, aMaxGuestMonitors))
#define ISystemProperties_GetMaxGuestMonitors(p, aMaxGuestMonitors) ((p)->lpVtbl->GetMaxGuestMonitors(p, aMaxGuestMonitors))
#define ISystemProperties_get_InfoVDSize(p, aInfoVDSize) ((p)->lpVtbl->GetInfoVDSize(p, aInfoVDSize))
#define ISystemProperties_GetInfoVDSize(p, aInfoVDSize) ((p)->lpVtbl->GetInfoVDSize(p, aInfoVDSize))
#define ISystemProperties_get_DefaultMachineFolder(p, aDefaultMachineFolder) ((p)->lpVtbl->GetDefaultMachineFolder(p, aDefaultMachineFolder))
#define ISystemProperties_GetDefaultMachineFolder(p, aDefaultMachineFolder) ((p)->lpVtbl->GetDefaultMachineFolder(p, aDefaultMachineFolder))
#define ISystemProperties_put_DefaultMachineFolder(p, aDefaultMachineFolder) ((p)->lpVtbl->SetDefaultMachineFolder(p, aDefaultMachineFolder))
#define ISystemProperties_SetDefaultMachineFolder(p, aDefaultMachineFolder) ((p)->lpVtbl->SetDefaultMachineFolder(p, aDefaultMachineFolder))
#define ISystemProperties_get_LoggingLevel(p, aLoggingLevel) ((p)->lpVtbl->GetLoggingLevel(p, aLoggingLevel))
#define ISystemProperties_GetLoggingLevel(p, aLoggingLevel) ((p)->lpVtbl->GetLoggingLevel(p, aLoggingLevel))
#define ISystemProperties_put_LoggingLevel(p, aLoggingLevel) ((p)->lpVtbl->SetLoggingLevel(p, aLoggingLevel))
#define ISystemProperties_SetLoggingLevel(p, aLoggingLevel) ((p)->lpVtbl->SetLoggingLevel(p, aLoggingLevel))
#define ISystemProperties_get_MediumFormats(p, aMediumFormats) ((p)->lpVtbl->GetMediumFormats(p, aMediumFormats))
#define ISystemProperties_GetMediumFormats(p, aMediumFormats) ((p)->lpVtbl->GetMediumFormats(p, aMediumFormats))
#define ISystemProperties_get_DefaultHardDiskFormat(p, aDefaultHardDiskFormat) ((p)->lpVtbl->GetDefaultHardDiskFormat(p, aDefaultHardDiskFormat))
#define ISystemProperties_GetDefaultHardDiskFormat(p, aDefaultHardDiskFormat) ((p)->lpVtbl->GetDefaultHardDiskFormat(p, aDefaultHardDiskFormat))
#define ISystemProperties_put_DefaultHardDiskFormat(p, aDefaultHardDiskFormat) ((p)->lpVtbl->SetDefaultHardDiskFormat(p, aDefaultHardDiskFormat))
#define ISystemProperties_SetDefaultHardDiskFormat(p, aDefaultHardDiskFormat) ((p)->lpVtbl->SetDefaultHardDiskFormat(p, aDefaultHardDiskFormat))
#define ISystemProperties_get_FreeDiskSpaceWarning(p, aFreeDiskSpaceWarning) ((p)->lpVtbl->GetFreeDiskSpaceWarning(p, aFreeDiskSpaceWarning))
#define ISystemProperties_GetFreeDiskSpaceWarning(p, aFreeDiskSpaceWarning) ((p)->lpVtbl->GetFreeDiskSpaceWarning(p, aFreeDiskSpaceWarning))
#define ISystemProperties_put_FreeDiskSpaceWarning(p, aFreeDiskSpaceWarning) ((p)->lpVtbl->SetFreeDiskSpaceWarning(p, aFreeDiskSpaceWarning))
#define ISystemProperties_SetFreeDiskSpaceWarning(p, aFreeDiskSpaceWarning) ((p)->lpVtbl->SetFreeDiskSpaceWarning(p, aFreeDiskSpaceWarning))
#define ISystemProperties_get_FreeDiskSpacePercentWarning(p, aFreeDiskSpacePercentWarning) ((p)->lpVtbl->GetFreeDiskSpacePercentWarning(p, aFreeDiskSpacePercentWarning))
#define ISystemProperties_GetFreeDiskSpacePercentWarning(p, aFreeDiskSpacePercentWarning) ((p)->lpVtbl->GetFreeDiskSpacePercentWarning(p, aFreeDiskSpacePercentWarning))
#define ISystemProperties_put_FreeDiskSpacePercentWarning(p, aFreeDiskSpacePercentWarning) ((p)->lpVtbl->SetFreeDiskSpacePercentWarning(p, aFreeDiskSpacePercentWarning))
#define ISystemProperties_SetFreeDiskSpacePercentWarning(p, aFreeDiskSpacePercentWarning) ((p)->lpVtbl->SetFreeDiskSpacePercentWarning(p, aFreeDiskSpacePercentWarning))
#define ISystemProperties_get_FreeDiskSpaceError(p, aFreeDiskSpaceError) ((p)->lpVtbl->GetFreeDiskSpaceError(p, aFreeDiskSpaceError))
#define ISystemProperties_GetFreeDiskSpaceError(p, aFreeDiskSpaceError) ((p)->lpVtbl->GetFreeDiskSpaceError(p, aFreeDiskSpaceError))
#define ISystemProperties_put_FreeDiskSpaceError(p, aFreeDiskSpaceError) ((p)->lpVtbl->SetFreeDiskSpaceError(p, aFreeDiskSpaceError))
#define ISystemProperties_SetFreeDiskSpaceError(p, aFreeDiskSpaceError) ((p)->lpVtbl->SetFreeDiskSpaceError(p, aFreeDiskSpaceError))
#define ISystemProperties_get_FreeDiskSpacePercentError(p, aFreeDiskSpacePercentError) ((p)->lpVtbl->GetFreeDiskSpacePercentError(p, aFreeDiskSpacePercentError))
#define ISystemProperties_GetFreeDiskSpacePercentError(p, aFreeDiskSpacePercentError) ((p)->lpVtbl->GetFreeDiskSpacePercentError(p, aFreeDiskSpacePercentError))
#define ISystemProperties_put_FreeDiskSpacePercentError(p, aFreeDiskSpacePercentError) ((p)->lpVtbl->SetFreeDiskSpacePercentError(p, aFreeDiskSpacePercentError))
#define ISystemProperties_SetFreeDiskSpacePercentError(p, aFreeDiskSpacePercentError) ((p)->lpVtbl->SetFreeDiskSpacePercentError(p, aFreeDiskSpacePercentError))
#define ISystemProperties_get_VRDEAuthLibrary(p, aVRDEAuthLibrary) ((p)->lpVtbl->GetVRDEAuthLibrary(p, aVRDEAuthLibrary))
#define ISystemProperties_GetVRDEAuthLibrary(p, aVRDEAuthLibrary) ((p)->lpVtbl->GetVRDEAuthLibrary(p, aVRDEAuthLibrary))
#define ISystemProperties_put_VRDEAuthLibrary(p, aVRDEAuthLibrary) ((p)->lpVtbl->SetVRDEAuthLibrary(p, aVRDEAuthLibrary))
#define ISystemProperties_SetVRDEAuthLibrary(p, aVRDEAuthLibrary) ((p)->lpVtbl->SetVRDEAuthLibrary(p, aVRDEAuthLibrary))
#define ISystemProperties_get_WebServiceAuthLibrary(p, aWebServiceAuthLibrary) ((p)->lpVtbl->GetWebServiceAuthLibrary(p, aWebServiceAuthLibrary))
#define ISystemProperties_GetWebServiceAuthLibrary(p, aWebServiceAuthLibrary) ((p)->lpVtbl->GetWebServiceAuthLibrary(p, aWebServiceAuthLibrary))
#define ISystemProperties_put_WebServiceAuthLibrary(p, aWebServiceAuthLibrary) ((p)->lpVtbl->SetWebServiceAuthLibrary(p, aWebServiceAuthLibrary))
#define ISystemProperties_SetWebServiceAuthLibrary(p, aWebServiceAuthLibrary) ((p)->lpVtbl->SetWebServiceAuthLibrary(p, aWebServiceAuthLibrary))
#define ISystemProperties_get_DefaultVRDEExtPack(p, aDefaultVRDEExtPack) ((p)->lpVtbl->GetDefaultVRDEExtPack(p, aDefaultVRDEExtPack))
#define ISystemProperties_GetDefaultVRDEExtPack(p, aDefaultVRDEExtPack) ((p)->lpVtbl->GetDefaultVRDEExtPack(p, aDefaultVRDEExtPack))
#define ISystemProperties_put_DefaultVRDEExtPack(p, aDefaultVRDEExtPack) ((p)->lpVtbl->SetDefaultVRDEExtPack(p, aDefaultVRDEExtPack))
#define ISystemProperties_SetDefaultVRDEExtPack(p, aDefaultVRDEExtPack) ((p)->lpVtbl->SetDefaultVRDEExtPack(p, aDefaultVRDEExtPack))
#define ISystemProperties_get_DefaultCryptoExtPack(p, aDefaultCryptoExtPack) ((p)->lpVtbl->GetDefaultCryptoExtPack(p, aDefaultCryptoExtPack))
#define ISystemProperties_GetDefaultCryptoExtPack(p, aDefaultCryptoExtPack) ((p)->lpVtbl->GetDefaultCryptoExtPack(p, aDefaultCryptoExtPack))
#define ISystemProperties_put_DefaultCryptoExtPack(p, aDefaultCryptoExtPack) ((p)->lpVtbl->SetDefaultCryptoExtPack(p, aDefaultCryptoExtPack))
#define ISystemProperties_SetDefaultCryptoExtPack(p, aDefaultCryptoExtPack) ((p)->lpVtbl->SetDefaultCryptoExtPack(p, aDefaultCryptoExtPack))
#define ISystemProperties_get_LogHistoryCount(p, aLogHistoryCount) ((p)->lpVtbl->GetLogHistoryCount(p, aLogHistoryCount))
#define ISystemProperties_GetLogHistoryCount(p, aLogHistoryCount) ((p)->lpVtbl->GetLogHistoryCount(p, aLogHistoryCount))
#define ISystemProperties_put_LogHistoryCount(p, aLogHistoryCount) ((p)->lpVtbl->SetLogHistoryCount(p, aLogHistoryCount))
#define ISystemProperties_SetLogHistoryCount(p, aLogHistoryCount) ((p)->lpVtbl->SetLogHistoryCount(p, aLogHistoryCount))
#define ISystemProperties_get_DefaultAudioDriver(p, aDefaultAudioDriver) ((p)->lpVtbl->GetDefaultAudioDriver(p, aDefaultAudioDriver))
#define ISystemProperties_GetDefaultAudioDriver(p, aDefaultAudioDriver) ((p)->lpVtbl->GetDefaultAudioDriver(p, aDefaultAudioDriver))
#define ISystemProperties_get_AutostartDatabasePath(p, aAutostartDatabasePath) ((p)->lpVtbl->GetAutostartDatabasePath(p, aAutostartDatabasePath))
#define ISystemProperties_GetAutostartDatabasePath(p, aAutostartDatabasePath) ((p)->lpVtbl->GetAutostartDatabasePath(p, aAutostartDatabasePath))
#define ISystemProperties_put_AutostartDatabasePath(p, aAutostartDatabasePath) ((p)->lpVtbl->SetAutostartDatabasePath(p, aAutostartDatabasePath))
#define ISystemProperties_SetAutostartDatabasePath(p, aAutostartDatabasePath) ((p)->lpVtbl->SetAutostartDatabasePath(p, aAutostartDatabasePath))
#define ISystemProperties_get_DefaultAdditionsISO(p, aDefaultAdditionsISO) ((p)->lpVtbl->GetDefaultAdditionsISO(p, aDefaultAdditionsISO))
#define ISystemProperties_GetDefaultAdditionsISO(p, aDefaultAdditionsISO) ((p)->lpVtbl->GetDefaultAdditionsISO(p, aDefaultAdditionsISO))
#define ISystemProperties_put_DefaultAdditionsISO(p, aDefaultAdditionsISO) ((p)->lpVtbl->SetDefaultAdditionsISO(p, aDefaultAdditionsISO))
#define ISystemProperties_SetDefaultAdditionsISO(p, aDefaultAdditionsISO) ((p)->lpVtbl->SetDefaultAdditionsISO(p, aDefaultAdditionsISO))
#define ISystemProperties_get_DefaultFrontend(p, aDefaultFrontend) ((p)->lpVtbl->GetDefaultFrontend(p, aDefaultFrontend))
#define ISystemProperties_GetDefaultFrontend(p, aDefaultFrontend) ((p)->lpVtbl->GetDefaultFrontend(p, aDefaultFrontend))
#define ISystemProperties_put_DefaultFrontend(p, aDefaultFrontend) ((p)->lpVtbl->SetDefaultFrontend(p, aDefaultFrontend))
#define ISystemProperties_SetDefaultFrontend(p, aDefaultFrontend) ((p)->lpVtbl->SetDefaultFrontend(p, aDefaultFrontend))
#define ISystemProperties_get_ScreenShotFormats(p, aScreenShotFormats) ((p)->lpVtbl->GetScreenShotFormats(p, aScreenShotFormats))
#define ISystemProperties_GetScreenShotFormats(p, aScreenShotFormats) ((p)->lpVtbl->GetScreenShotFormats(p, aScreenShotFormats))
#define ISystemProperties_get_ProxyMode(p, aProxyMode) ((p)->lpVtbl->GetProxyMode(p, aProxyMode))
#define ISystemProperties_GetProxyMode(p, aProxyMode) ((p)->lpVtbl->GetProxyMode(p, aProxyMode))
#define ISystemProperties_put_ProxyMode(p, aProxyMode) ((p)->lpVtbl->SetProxyMode(p, aProxyMode))
#define ISystemProperties_SetProxyMode(p, aProxyMode) ((p)->lpVtbl->SetProxyMode(p, aProxyMode))
#define ISystemProperties_get_ProxyURL(p, aProxyURL) ((p)->lpVtbl->GetProxyURL(p, aProxyURL))
#define ISystemProperties_GetProxyURL(p, aProxyURL) ((p)->lpVtbl->GetProxyURL(p, aProxyURL))
#define ISystemProperties_put_ProxyURL(p, aProxyURL) ((p)->lpVtbl->SetProxyURL(p, aProxyURL))
#define ISystemProperties_SetProxyURL(p, aProxyURL) ((p)->lpVtbl->SetProxyURL(p, aProxyURL))
#define ISystemProperties_get_SupportedPlatformArchitectures(p, aSupportedPlatformArchitectures) ((p)->lpVtbl->GetSupportedPlatformArchitectures(p, aSupportedPlatformArchitectures))
#define ISystemProperties_GetSupportedPlatformArchitectures(p, aSupportedPlatformArchitectures) ((p)->lpVtbl->GetSupportedPlatformArchitectures(p, aSupportedPlatformArchitectures))
#define ISystemProperties_get_SupportedClipboardModes(p, aSupportedClipboardModes) ((p)->lpVtbl->GetSupportedClipboardModes(p, aSupportedClipboardModes))
#define ISystemProperties_GetSupportedClipboardModes(p, aSupportedClipboardModes) ((p)->lpVtbl->GetSupportedClipboardModes(p, aSupportedClipboardModes))
#define ISystemProperties_get_SupportedDnDModes(p, aSupportedDnDModes) ((p)->lpVtbl->GetSupportedDnDModes(p, aSupportedDnDModes))
#define ISystemProperties_GetSupportedDnDModes(p, aSupportedDnDModes) ((p)->lpVtbl->GetSupportedDnDModes(p, aSupportedDnDModes))
#define ISystemProperties_get_SupportedPointingHIDTypes(p, aSupportedPointingHIDTypes) ((p)->lpVtbl->GetSupportedPointingHIDTypes(p, aSupportedPointingHIDTypes))
#define ISystemProperties_GetSupportedPointingHIDTypes(p, aSupportedPointingHIDTypes) ((p)->lpVtbl->GetSupportedPointingHIDTypes(p, aSupportedPointingHIDTypes))
#define ISystemProperties_get_SupportedKeyboardHIDTypes(p, aSupportedKeyboardHIDTypes) ((p)->lpVtbl->GetSupportedKeyboardHIDTypes(p, aSupportedKeyboardHIDTypes))
#define ISystemProperties_GetSupportedKeyboardHIDTypes(p, aSupportedKeyboardHIDTypes) ((p)->lpVtbl->GetSupportedKeyboardHIDTypes(p, aSupportedKeyboardHIDTypes))
#define ISystemProperties_get_SupportedVFSTypes(p, aSupportedVFSTypes) ((p)->lpVtbl->GetSupportedVFSTypes(p, aSupportedVFSTypes))
#define ISystemProperties_GetSupportedVFSTypes(p, aSupportedVFSTypes) ((p)->lpVtbl->GetSupportedVFSTypes(p, aSupportedVFSTypes))
#define ISystemProperties_get_SupportedImportOptions(p, aSupportedImportOptions) ((p)->lpVtbl->GetSupportedImportOptions(p, aSupportedImportOptions))
#define ISystemProperties_GetSupportedImportOptions(p, aSupportedImportOptions) ((p)->lpVtbl->GetSupportedImportOptions(p, aSupportedImportOptions))
#define ISystemProperties_get_SupportedExportOptions(p, aSupportedExportOptions) ((p)->lpVtbl->GetSupportedExportOptions(p, aSupportedExportOptions))
#define ISystemProperties_GetSupportedExportOptions(p, aSupportedExportOptions) ((p)->lpVtbl->GetSupportedExportOptions(p, aSupportedExportOptions))
#define ISystemProperties_get_SupportedGraphicsFeatures(p, aSupportedGraphicsFeatures) ((p)->lpVtbl->GetSupportedGraphicsFeatures(p, aSupportedGraphicsFeatures))
#define ISystemProperties_GetSupportedGraphicsFeatures(p, aSupportedGraphicsFeatures) ((p)->lpVtbl->GetSupportedGraphicsFeatures(p, aSupportedGraphicsFeatures))
#define ISystemProperties_get_SupportedRecordingFeatures(p, aSupportedRecordingFeatures) ((p)->lpVtbl->GetSupportedRecordingFeatures(p, aSupportedRecordingFeatures))
#define ISystemProperties_GetSupportedRecordingFeatures(p, aSupportedRecordingFeatures) ((p)->lpVtbl->GetSupportedRecordingFeatures(p, aSupportedRecordingFeatures))
#define ISystemProperties_get_SupportedRecordingAudioCodecs(p, aSupportedRecordingAudioCodecs) ((p)->lpVtbl->GetSupportedRecordingAudioCodecs(p, aSupportedRecordingAudioCodecs))
#define ISystemProperties_GetSupportedRecordingAudioCodecs(p, aSupportedRecordingAudioCodecs) ((p)->lpVtbl->GetSupportedRecordingAudioCodecs(p, aSupportedRecordingAudioCodecs))
#define ISystemProperties_get_SupportedRecordingVideoCodecs(p, aSupportedRecordingVideoCodecs) ((p)->lpVtbl->GetSupportedRecordingVideoCodecs(p, aSupportedRecordingVideoCodecs))
#define ISystemProperties_GetSupportedRecordingVideoCodecs(p, aSupportedRecordingVideoCodecs) ((p)->lpVtbl->GetSupportedRecordingVideoCodecs(p, aSupportedRecordingVideoCodecs))
#define ISystemProperties_get_SupportedRecordingVSModes(p, aSupportedRecordingVSModes) ((p)->lpVtbl->GetSupportedRecordingVSModes(p, aSupportedRecordingVSModes))
#define ISystemProperties_GetSupportedRecordingVSModes(p, aSupportedRecordingVSModes) ((p)->lpVtbl->GetSupportedRecordingVSModes(p, aSupportedRecordingVSModes))
#define ISystemProperties_get_SupportedRecordingARCModes(p, aSupportedRecordingARCModes) ((p)->lpVtbl->GetSupportedRecordingARCModes(p, aSupportedRecordingARCModes))
#define ISystemProperties_GetSupportedRecordingARCModes(p, aSupportedRecordingARCModes) ((p)->lpVtbl->GetSupportedRecordingARCModes(p, aSupportedRecordingARCModes))
#define ISystemProperties_get_SupportedRecordingVRCModes(p, aSupportedRecordingVRCModes) ((p)->lpVtbl->GetSupportedRecordingVRCModes(p, aSupportedRecordingVRCModes))
#define ISystemProperties_GetSupportedRecordingVRCModes(p, aSupportedRecordingVRCModes) ((p)->lpVtbl->GetSupportedRecordingVRCModes(p, aSupportedRecordingVRCModes))
#define ISystemProperties_get_SupportedCloneOptions(p, aSupportedCloneOptions) ((p)->lpVtbl->GetSupportedCloneOptions(p, aSupportedCloneOptions))
#define ISystemProperties_GetSupportedCloneOptions(p, aSupportedCloneOptions) ((p)->lpVtbl->GetSupportedCloneOptions(p, aSupportedCloneOptions))
#define ISystemProperties_get_SupportedAutostopTypes(p, aSupportedAutostopTypes) ((p)->lpVtbl->GetSupportedAutostopTypes(p, aSupportedAutostopTypes))
#define ISystemProperties_GetSupportedAutostopTypes(p, aSupportedAutostopTypes) ((p)->lpVtbl->GetSupportedAutostopTypes(p, aSupportedAutostopTypes))
#define ISystemProperties_get_SupportedVMProcPriorities(p, aSupportedVMProcPriorities) ((p)->lpVtbl->GetSupportedVMProcPriorities(p, aSupportedVMProcPriorities))
#define ISystemProperties_GetSupportedVMProcPriorities(p, aSupportedVMProcPriorities) ((p)->lpVtbl->GetSupportedVMProcPriorities(p, aSupportedVMProcPriorities))
#define ISystemProperties_get_SupportedNetworkAttachmentTypes(p, aSupportedNetworkAttachmentTypes) ((p)->lpVtbl->GetSupportedNetworkAttachmentTypes(p, aSupportedNetworkAttachmentTypes))
#define ISystemProperties_GetSupportedNetworkAttachmentTypes(p, aSupportedNetworkAttachmentTypes) ((p)->lpVtbl->GetSupportedNetworkAttachmentTypes(p, aSupportedNetworkAttachmentTypes))
#define ISystemProperties_get_SupportedPortModes(p, aSupportedPortModes) ((p)->lpVtbl->GetSupportedPortModes(p, aSupportedPortModes))
#define ISystemProperties_GetSupportedPortModes(p, aSupportedPortModes) ((p)->lpVtbl->GetSupportedPortModes(p, aSupportedPortModes))
#define ISystemProperties_get_SupportedAudioDriverTypes(p, aSupportedAudioDriverTypes) ((p)->lpVtbl->GetSupportedAudioDriverTypes(p, aSupportedAudioDriverTypes))
#define ISystemProperties_GetSupportedAudioDriverTypes(p, aSupportedAudioDriverTypes) ((p)->lpVtbl->GetSupportedAudioDriverTypes(p, aSupportedAudioDriverTypes))
#define ISystemProperties_get_LanguageId(p, aLanguageId) ((p)->lpVtbl->GetLanguageId(p, aLanguageId))
#define ISystemProperties_GetLanguageId(p, aLanguageId) ((p)->lpVtbl->GetLanguageId(p, aLanguageId))
#define ISystemProperties_put_LanguageId(p, aLanguageId) ((p)->lpVtbl->SetLanguageId(p, aLanguageId))
#define ISystemProperties_SetLanguageId(p, aLanguageId) ((p)->lpVtbl->SetLanguageId(p, aLanguageId))
#define ISystemProperties_GetDefaultIoCacheSettingForStorageController(p, aControllerType, aEnabled) ((p)->lpVtbl->GetDefaultIoCacheSettingForStorageController(p, aControllerType, aEnabled))
#define ISystemProperties_GetCPUProfiles(p, aArchitecture, aNamePattern, aProfiles) ((p)->lpVtbl->GetCPUProfiles(p, aArchitecture, aNamePattern, aProfiles))
#define ISystemProperties_GetExecutionEnginesForVmCpuArchitecture(p, aCpuArchitecture, aExecutionEngine) ((p)->lpVtbl->GetExecutionEnginesForVmCpuArchitecture(p, aCpuArchitecture, aExecutionEngine))
#endif /* VBOX_WITH_GLUE */

interface ISystemProperties
{
#ifndef VBOX_WITH_GLUE
    struct ISystemProperties_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct ISystemPropertiesVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct ISystemProperties declaration */


/* Start of struct IGuestOSType declaration */
#define IGUESTOSTYPE_IID_STR "ceb482fc-41b9-42a8-8538-9835ea33b6f2"
#define IGUESTOSTYPE_IID { \
    0xceb482fc, 0x41b9, 0x42a8, \
    { 0x85, 0x38, 0x98, 0x35, 0xea, 0x33, 0xb6, 0xf2 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestOSType);
#ifndef VBOX_WITH_GLUE
struct IGuestOSType_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetFamilyId)(IGuestOSType *pThis, PRUnichar * *familyId);

    nsresult (*GetFamilyDescription)(IGuestOSType *pThis, PRUnichar * *familyDescription);

    nsresult (*GetId)(IGuestOSType *pThis, PRUnichar * *id);

    nsresult (*GetSubtype)(IGuestOSType *pThis, PRUnichar * *subtype);

    nsresult (*GetDescription)(IGuestOSType *pThis, PRUnichar * *description);

    nsresult (*GetIs64Bit)(IGuestOSType *pThis, PRBool *is64Bit);

    nsresult (*GetPlatformArchitecture)(IGuestOSType *pThis, PRUint32 *platformArchitecture);

    nsresult (*GetRecommendedIOAPIC)(IGuestOSType *pThis, PRBool *recommendedIOAPIC);

    nsresult (*GetRecommendedVirtEx)(IGuestOSType *pThis, PRBool *recommendedVirtEx);

    nsresult (*GetRecommendedRAM)(IGuestOSType *pThis, PRUint32 *recommendedRAM);

    nsresult (*GetRecommendedGraphicsController)(IGuestOSType *pThis, PRUint32 *recommendedGraphicsController);

    nsresult (*GetRecommendedVRAM)(IGuestOSType *pThis, PRUint32 *recommendedVRAM);

    nsresult (*GetRecommended2DVideoAcceleration)(IGuestOSType *pThis, PRBool *recommended2DVideoAcceleration);

    nsresult (*GetRecommended3DAcceleration)(IGuestOSType *pThis, PRBool *recommended3DAcceleration);

    nsresult (*GetRecommendedHDD)(IGuestOSType *pThis, PRInt64 *recommendedHDD);

    nsresult (*GetAdapterType)(IGuestOSType *pThis, PRUint32 *adapterType);

    nsresult (*GetRecommendedPAE)(IGuestOSType *pThis, PRBool *recommendedPAE);

    nsresult (*GetRecommendedDVDStorageController)(IGuestOSType *pThis, PRUint32 *recommendedDVDStorageController);

    nsresult (*GetRecommendedDVDStorageBus)(IGuestOSType *pThis, PRUint32 *recommendedDVDStorageBus);

    nsresult (*GetRecommendedHDStorageController)(IGuestOSType *pThis, PRUint32 *recommendedHDStorageController);

    nsresult (*GetRecommendedHDStorageBus)(IGuestOSType *pThis, PRUint32 *recommendedHDStorageBus);

    nsresult (*GetRecommendedFirmware)(IGuestOSType *pThis, PRUint32 *recommendedFirmware);

    nsresult (*GetRecommendedUSBHID)(IGuestOSType *pThis, PRBool *recommendedUSBHID);

    nsresult (*GetRecommendedHPET)(IGuestOSType *pThis, PRBool *recommendedHPET);

    nsresult (*GetRecommendedUSBTablet)(IGuestOSType *pThis, PRBool *recommendedUSBTablet);

    nsresult (*GetRecommendedRTCUseUTC)(IGuestOSType *pThis, PRBool *recommendedRTCUseUTC);

    nsresult (*GetRecommendedChipset)(IGuestOSType *pThis, PRUint32 *recommendedChipset);

    nsresult (*GetRecommendedIommuType)(IGuestOSType *pThis, PRUint32 *recommendedIommuType);

    nsresult (*GetRecommendedAudioController)(IGuestOSType *pThis, PRUint32 *recommendedAudioController);

    nsresult (*GetRecommendedAudioCodec)(IGuestOSType *pThis, PRUint32 *recommendedAudioCodec);

    nsresult (*GetRecommendedFloppy)(IGuestOSType *pThis, PRBool *recommendedFloppy);

    nsresult (*GetRecommendedUSB)(IGuestOSType *pThis, PRBool *recommendedUSB);

    nsresult (*GetRecommendedUSB3)(IGuestOSType *pThis, PRBool *recommendedUSB3);

    nsresult (*GetRecommendedTFReset)(IGuestOSType *pThis, PRBool *recommendedTFReset);

    nsresult (*GetRecommendedX2APIC)(IGuestOSType *pThis, PRBool *recommendedX2APIC);

    nsresult (*GetRecommendedCPUCount)(IGuestOSType *pThis, PRUint32 *recommendedCPUCount);

    nsresult (*GetRecommendedTpmType)(IGuestOSType *pThis, PRUint32 *recommendedTpmType);

    nsresult (*GetRecommendedSecureBoot)(IGuestOSType *pThis, PRBool *recommendedSecureBoot);

    nsresult (*GetRecommendedWDDMGraphics)(IGuestOSType *pThis, PRBool *recommendedWDDMGraphics);

    nsresult (*GetGuestAdditionsInstallPackageName)(IGuestOSType *pThis, PRUnichar * *guestAdditionsInstallPackageName);

    nsresult (*GetInternalAndReservedAttribute1IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

};
#else /* VBOX_WITH_GLUE */
struct IGuestOSTypeVtbl
{
    nsresult (*QueryInterface)(IGuestOSType *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestOSType *pThis);
    nsrefcnt (*Release)(IGuestOSType *pThis);
    nsresult (*GetFamilyId)(IGuestOSType *pThis, PRUnichar * *familyId);

    nsresult (*GetFamilyDescription)(IGuestOSType *pThis, PRUnichar * *familyDescription);

    nsresult (*GetId)(IGuestOSType *pThis, PRUnichar * *id);

    nsresult (*GetSubtype)(IGuestOSType *pThis, PRUnichar * *subtype);

    nsresult (*GetDescription)(IGuestOSType *pThis, PRUnichar * *description);

    nsresult (*GetIs64Bit)(IGuestOSType *pThis, PRBool *is64Bit);

    nsresult (*GetPlatformArchitecture)(IGuestOSType *pThis, PRUint32 *platformArchitecture);

    nsresult (*GetRecommendedIOAPIC)(IGuestOSType *pThis, PRBool *recommendedIOAPIC);

    nsresult (*GetRecommendedVirtEx)(IGuestOSType *pThis, PRBool *recommendedVirtEx);

    nsresult (*GetRecommendedRAM)(IGuestOSType *pThis, PRUint32 *recommendedRAM);

    nsresult (*GetRecommendedGraphicsController)(IGuestOSType *pThis, PRUint32 *recommendedGraphicsController);

    nsresult (*GetRecommendedVRAM)(IGuestOSType *pThis, PRUint32 *recommendedVRAM);

    nsresult (*GetRecommended2DVideoAcceleration)(IGuestOSType *pThis, PRBool *recommended2DVideoAcceleration);

    nsresult (*GetRecommended3DAcceleration)(IGuestOSType *pThis, PRBool *recommended3DAcceleration);

    nsresult (*GetRecommendedHDD)(IGuestOSType *pThis, PRInt64 *recommendedHDD);

    nsresult (*GetAdapterType)(IGuestOSType *pThis, PRUint32 *adapterType);

    nsresult (*GetRecommendedPAE)(IGuestOSType *pThis, PRBool *recommendedPAE);

    nsresult (*GetRecommendedDVDStorageController)(IGuestOSType *pThis, PRUint32 *recommendedDVDStorageController);

    nsresult (*GetRecommendedDVDStorageBus)(IGuestOSType *pThis, PRUint32 *recommendedDVDStorageBus);

    nsresult (*GetRecommendedHDStorageController)(IGuestOSType *pThis, PRUint32 *recommendedHDStorageController);

    nsresult (*GetRecommendedHDStorageBus)(IGuestOSType *pThis, PRUint32 *recommendedHDStorageBus);

    nsresult (*GetRecommendedFirmware)(IGuestOSType *pThis, PRUint32 *recommendedFirmware);

    nsresult (*GetRecommendedUSBHID)(IGuestOSType *pThis, PRBool *recommendedUSBHID);

    nsresult (*GetRecommendedHPET)(IGuestOSType *pThis, PRBool *recommendedHPET);

    nsresult (*GetRecommendedUSBTablet)(IGuestOSType *pThis, PRBool *recommendedUSBTablet);

    nsresult (*GetRecommendedRTCUseUTC)(IGuestOSType *pThis, PRBool *recommendedRTCUseUTC);

    nsresult (*GetRecommendedChipset)(IGuestOSType *pThis, PRUint32 *recommendedChipset);

    nsresult (*GetRecommendedIommuType)(IGuestOSType *pThis, PRUint32 *recommendedIommuType);

    nsresult (*GetRecommendedAudioController)(IGuestOSType *pThis, PRUint32 *recommendedAudioController);

    nsresult (*GetRecommendedAudioCodec)(IGuestOSType *pThis, PRUint32 *recommendedAudioCodec);

    nsresult (*GetRecommendedFloppy)(IGuestOSType *pThis, PRBool *recommendedFloppy);

    nsresult (*GetRecommendedUSB)(IGuestOSType *pThis, PRBool *recommendedUSB);

    nsresult (*GetRecommendedUSB3)(IGuestOSType *pThis, PRBool *recommendedUSB3);

    nsresult (*GetRecommendedTFReset)(IGuestOSType *pThis, PRBool *recommendedTFReset);

    nsresult (*GetRecommendedX2APIC)(IGuestOSType *pThis, PRBool *recommendedX2APIC);

    nsresult (*GetRecommendedCPUCount)(IGuestOSType *pThis, PRUint32 *recommendedCPUCount);

    nsresult (*GetRecommendedTpmType)(IGuestOSType *pThis, PRUint32 *recommendedTpmType);

    nsresult (*GetRecommendedSecureBoot)(IGuestOSType *pThis, PRBool *recommendedSecureBoot);

    nsresult (*GetRecommendedWDDMGraphics)(IGuestOSType *pThis, PRBool *recommendedWDDMGraphics);

    nsresult (*GetGuestAdditionsInstallPackageName)(IGuestOSType *pThis, PRUnichar * *guestAdditionsInstallPackageName);

    nsresult (*GetInternalAndReservedAttribute1IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IGuestOSType)(IGuestOSType *pThis, PRUint32 *reserved);

};
#define IGuestOSType_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestOSType_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestOSType_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestOSType_get_FamilyId(p, aFamilyId) ((p)->lpVtbl->GetFamilyId(p, aFamilyId))
#define IGuestOSType_GetFamilyId(p, aFamilyId) ((p)->lpVtbl->GetFamilyId(p, aFamilyId))
#define IGuestOSType_get_FamilyDescription(p, aFamilyDescription) ((p)->lpVtbl->GetFamilyDescription(p, aFamilyDescription))
#define IGuestOSType_GetFamilyDescription(p, aFamilyDescription) ((p)->lpVtbl->GetFamilyDescription(p, aFamilyDescription))
#define IGuestOSType_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IGuestOSType_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IGuestOSType_get_Subtype(p, aSubtype) ((p)->lpVtbl->GetSubtype(p, aSubtype))
#define IGuestOSType_GetSubtype(p, aSubtype) ((p)->lpVtbl->GetSubtype(p, aSubtype))
#define IGuestOSType_get_Description(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define IGuestOSType_GetDescription(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define IGuestOSType_get_Is64Bit(p, aIs64Bit) ((p)->lpVtbl->GetIs64Bit(p, aIs64Bit))
#define IGuestOSType_GetIs64Bit(p, aIs64Bit) ((p)->lpVtbl->GetIs64Bit(p, aIs64Bit))
#define IGuestOSType_get_PlatformArchitecture(p, aPlatformArchitecture) ((p)->lpVtbl->GetPlatformArchitecture(p, aPlatformArchitecture))
#define IGuestOSType_GetPlatformArchitecture(p, aPlatformArchitecture) ((p)->lpVtbl->GetPlatformArchitecture(p, aPlatformArchitecture))
#define IGuestOSType_get_RecommendedIOAPIC(p, aRecommendedIOAPIC) ((p)->lpVtbl->GetRecommendedIOAPIC(p, aRecommendedIOAPIC))
#define IGuestOSType_GetRecommendedIOAPIC(p, aRecommendedIOAPIC) ((p)->lpVtbl->GetRecommendedIOAPIC(p, aRecommendedIOAPIC))
#define IGuestOSType_get_RecommendedVirtEx(p, aRecommendedVirtEx) ((p)->lpVtbl->GetRecommendedVirtEx(p, aRecommendedVirtEx))
#define IGuestOSType_GetRecommendedVirtEx(p, aRecommendedVirtEx) ((p)->lpVtbl->GetRecommendedVirtEx(p, aRecommendedVirtEx))
#define IGuestOSType_get_RecommendedRAM(p, aRecommendedRAM) ((p)->lpVtbl->GetRecommendedRAM(p, aRecommendedRAM))
#define IGuestOSType_GetRecommendedRAM(p, aRecommendedRAM) ((p)->lpVtbl->GetRecommendedRAM(p, aRecommendedRAM))
#define IGuestOSType_get_RecommendedGraphicsController(p, aRecommendedGraphicsController) ((p)->lpVtbl->GetRecommendedGraphicsController(p, aRecommendedGraphicsController))
#define IGuestOSType_GetRecommendedGraphicsController(p, aRecommendedGraphicsController) ((p)->lpVtbl->GetRecommendedGraphicsController(p, aRecommendedGraphicsController))
#define IGuestOSType_get_RecommendedVRAM(p, aRecommendedVRAM) ((p)->lpVtbl->GetRecommendedVRAM(p, aRecommendedVRAM))
#define IGuestOSType_GetRecommendedVRAM(p, aRecommendedVRAM) ((p)->lpVtbl->GetRecommendedVRAM(p, aRecommendedVRAM))
#define IGuestOSType_get_Recommended2DVideoAcceleration(p, aRecommended2DVideoAcceleration) ((p)->lpVtbl->GetRecommended2DVideoAcceleration(p, aRecommended2DVideoAcceleration))
#define IGuestOSType_GetRecommended2DVideoAcceleration(p, aRecommended2DVideoAcceleration) ((p)->lpVtbl->GetRecommended2DVideoAcceleration(p, aRecommended2DVideoAcceleration))
#define IGuestOSType_get_Recommended3DAcceleration(p, aRecommended3DAcceleration) ((p)->lpVtbl->GetRecommended3DAcceleration(p, aRecommended3DAcceleration))
#define IGuestOSType_GetRecommended3DAcceleration(p, aRecommended3DAcceleration) ((p)->lpVtbl->GetRecommended3DAcceleration(p, aRecommended3DAcceleration))
#define IGuestOSType_get_RecommendedHDD(p, aRecommendedHDD) ((p)->lpVtbl->GetRecommendedHDD(p, aRecommendedHDD))
#define IGuestOSType_GetRecommendedHDD(p, aRecommendedHDD) ((p)->lpVtbl->GetRecommendedHDD(p, aRecommendedHDD))
#define IGuestOSType_get_AdapterType(p, aAdapterType) ((p)->lpVtbl->GetAdapterType(p, aAdapterType))
#define IGuestOSType_GetAdapterType(p, aAdapterType) ((p)->lpVtbl->GetAdapterType(p, aAdapterType))
#define IGuestOSType_get_RecommendedPAE(p, aRecommendedPAE) ((p)->lpVtbl->GetRecommendedPAE(p, aRecommendedPAE))
#define IGuestOSType_GetRecommendedPAE(p, aRecommendedPAE) ((p)->lpVtbl->GetRecommendedPAE(p, aRecommendedPAE))
#define IGuestOSType_get_RecommendedDVDStorageController(p, aRecommendedDVDStorageController) ((p)->lpVtbl->GetRecommendedDVDStorageController(p, aRecommendedDVDStorageController))
#define IGuestOSType_GetRecommendedDVDStorageController(p, aRecommendedDVDStorageController) ((p)->lpVtbl->GetRecommendedDVDStorageController(p, aRecommendedDVDStorageController))
#define IGuestOSType_get_RecommendedDVDStorageBus(p, aRecommendedDVDStorageBus) ((p)->lpVtbl->GetRecommendedDVDStorageBus(p, aRecommendedDVDStorageBus))
#define IGuestOSType_GetRecommendedDVDStorageBus(p, aRecommendedDVDStorageBus) ((p)->lpVtbl->GetRecommendedDVDStorageBus(p, aRecommendedDVDStorageBus))
#define IGuestOSType_get_RecommendedHDStorageController(p, aRecommendedHDStorageController) ((p)->lpVtbl->GetRecommendedHDStorageController(p, aRecommendedHDStorageController))
#define IGuestOSType_GetRecommendedHDStorageController(p, aRecommendedHDStorageController) ((p)->lpVtbl->GetRecommendedHDStorageController(p, aRecommendedHDStorageController))
#define IGuestOSType_get_RecommendedHDStorageBus(p, aRecommendedHDStorageBus) ((p)->lpVtbl->GetRecommendedHDStorageBus(p, aRecommendedHDStorageBus))
#define IGuestOSType_GetRecommendedHDStorageBus(p, aRecommendedHDStorageBus) ((p)->lpVtbl->GetRecommendedHDStorageBus(p, aRecommendedHDStorageBus))
#define IGuestOSType_get_RecommendedFirmware(p, aRecommendedFirmware) ((p)->lpVtbl->GetRecommendedFirmware(p, aRecommendedFirmware))
#define IGuestOSType_GetRecommendedFirmware(p, aRecommendedFirmware) ((p)->lpVtbl->GetRecommendedFirmware(p, aRecommendedFirmware))
#define IGuestOSType_get_RecommendedUSBHID(p, aRecommendedUSBHID) ((p)->lpVtbl->GetRecommendedUSBHID(p, aRecommendedUSBHID))
#define IGuestOSType_GetRecommendedUSBHID(p, aRecommendedUSBHID) ((p)->lpVtbl->GetRecommendedUSBHID(p, aRecommendedUSBHID))
#define IGuestOSType_get_RecommendedHPET(p, aRecommendedHPET) ((p)->lpVtbl->GetRecommendedHPET(p, aRecommendedHPET))
#define IGuestOSType_GetRecommendedHPET(p, aRecommendedHPET) ((p)->lpVtbl->GetRecommendedHPET(p, aRecommendedHPET))
#define IGuestOSType_get_RecommendedUSBTablet(p, aRecommendedUSBTablet) ((p)->lpVtbl->GetRecommendedUSBTablet(p, aRecommendedUSBTablet))
#define IGuestOSType_GetRecommendedUSBTablet(p, aRecommendedUSBTablet) ((p)->lpVtbl->GetRecommendedUSBTablet(p, aRecommendedUSBTablet))
#define IGuestOSType_get_RecommendedRTCUseUTC(p, aRecommendedRTCUseUTC) ((p)->lpVtbl->GetRecommendedRTCUseUTC(p, aRecommendedRTCUseUTC))
#define IGuestOSType_GetRecommendedRTCUseUTC(p, aRecommendedRTCUseUTC) ((p)->lpVtbl->GetRecommendedRTCUseUTC(p, aRecommendedRTCUseUTC))
#define IGuestOSType_get_RecommendedChipset(p, aRecommendedChipset) ((p)->lpVtbl->GetRecommendedChipset(p, aRecommendedChipset))
#define IGuestOSType_GetRecommendedChipset(p, aRecommendedChipset) ((p)->lpVtbl->GetRecommendedChipset(p, aRecommendedChipset))
#define IGuestOSType_get_RecommendedIommuType(p, aRecommendedIommuType) ((p)->lpVtbl->GetRecommendedIommuType(p, aRecommendedIommuType))
#define IGuestOSType_GetRecommendedIommuType(p, aRecommendedIommuType) ((p)->lpVtbl->GetRecommendedIommuType(p, aRecommendedIommuType))
#define IGuestOSType_get_RecommendedAudioController(p, aRecommendedAudioController) ((p)->lpVtbl->GetRecommendedAudioController(p, aRecommendedAudioController))
#define IGuestOSType_GetRecommendedAudioController(p, aRecommendedAudioController) ((p)->lpVtbl->GetRecommendedAudioController(p, aRecommendedAudioController))
#define IGuestOSType_get_RecommendedAudioCodec(p, aRecommendedAudioCodec) ((p)->lpVtbl->GetRecommendedAudioCodec(p, aRecommendedAudioCodec))
#define IGuestOSType_GetRecommendedAudioCodec(p, aRecommendedAudioCodec) ((p)->lpVtbl->GetRecommendedAudioCodec(p, aRecommendedAudioCodec))
#define IGuestOSType_get_RecommendedFloppy(p, aRecommendedFloppy) ((p)->lpVtbl->GetRecommendedFloppy(p, aRecommendedFloppy))
#define IGuestOSType_GetRecommendedFloppy(p, aRecommendedFloppy) ((p)->lpVtbl->GetRecommendedFloppy(p, aRecommendedFloppy))
#define IGuestOSType_get_RecommendedUSB(p, aRecommendedUSB) ((p)->lpVtbl->GetRecommendedUSB(p, aRecommendedUSB))
#define IGuestOSType_GetRecommendedUSB(p, aRecommendedUSB) ((p)->lpVtbl->GetRecommendedUSB(p, aRecommendedUSB))
#define IGuestOSType_get_RecommendedUSB3(p, aRecommendedUSB3) ((p)->lpVtbl->GetRecommendedUSB3(p, aRecommendedUSB3))
#define IGuestOSType_GetRecommendedUSB3(p, aRecommendedUSB3) ((p)->lpVtbl->GetRecommendedUSB3(p, aRecommendedUSB3))
#define IGuestOSType_get_RecommendedTFReset(p, aRecommendedTFReset) ((p)->lpVtbl->GetRecommendedTFReset(p, aRecommendedTFReset))
#define IGuestOSType_GetRecommendedTFReset(p, aRecommendedTFReset) ((p)->lpVtbl->GetRecommendedTFReset(p, aRecommendedTFReset))
#define IGuestOSType_get_RecommendedX2APIC(p, aRecommendedX2APIC) ((p)->lpVtbl->GetRecommendedX2APIC(p, aRecommendedX2APIC))
#define IGuestOSType_GetRecommendedX2APIC(p, aRecommendedX2APIC) ((p)->lpVtbl->GetRecommendedX2APIC(p, aRecommendedX2APIC))
#define IGuestOSType_get_RecommendedCPUCount(p, aRecommendedCPUCount) ((p)->lpVtbl->GetRecommendedCPUCount(p, aRecommendedCPUCount))
#define IGuestOSType_GetRecommendedCPUCount(p, aRecommendedCPUCount) ((p)->lpVtbl->GetRecommendedCPUCount(p, aRecommendedCPUCount))
#define IGuestOSType_get_RecommendedTpmType(p, aRecommendedTpmType) ((p)->lpVtbl->GetRecommendedTpmType(p, aRecommendedTpmType))
#define IGuestOSType_GetRecommendedTpmType(p, aRecommendedTpmType) ((p)->lpVtbl->GetRecommendedTpmType(p, aRecommendedTpmType))
#define IGuestOSType_get_RecommendedSecureBoot(p, aRecommendedSecureBoot) ((p)->lpVtbl->GetRecommendedSecureBoot(p, aRecommendedSecureBoot))
#define IGuestOSType_GetRecommendedSecureBoot(p, aRecommendedSecureBoot) ((p)->lpVtbl->GetRecommendedSecureBoot(p, aRecommendedSecureBoot))
#define IGuestOSType_get_RecommendedWDDMGraphics(p, aRecommendedWDDMGraphics) ((p)->lpVtbl->GetRecommendedWDDMGraphics(p, aRecommendedWDDMGraphics))
#define IGuestOSType_GetRecommendedWDDMGraphics(p, aRecommendedWDDMGraphics) ((p)->lpVtbl->GetRecommendedWDDMGraphics(p, aRecommendedWDDMGraphics))
#define IGuestOSType_get_GuestAdditionsInstallPackageName(p, aGuestAdditionsInstallPackageName) ((p)->lpVtbl->GetGuestAdditionsInstallPackageName(p, aGuestAdditionsInstallPackageName))
#define IGuestOSType_GetGuestAdditionsInstallPackageName(p, aGuestAdditionsInstallPackageName) ((p)->lpVtbl->GetGuestAdditionsInstallPackageName(p, aGuestAdditionsInstallPackageName))
#endif /* VBOX_WITH_GLUE */

interface IGuestOSType
{
#ifndef VBOX_WITH_GLUE
    struct IGuestOSType_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestOSTypeVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestOSType declaration */


/* Start of struct IAdditionsFacility declaration */
#define IADDITIONSFACILITY_IID_STR "f2f7fae4-4a06-81fc-a916-78b2da1fa0e5"
#define IADDITIONSFACILITY_IID { \
    0xf2f7fae4, 0x4a06, 0x81fc, \
    { 0xa9, 0x16, 0x78, 0xb2, 0xda, 0x1f, 0xa0, 0xe5 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IAdditionsFacility);
#ifndef VBOX_WITH_GLUE
struct IAdditionsFacility_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetClassType)(IAdditionsFacility *pThis, PRUint32 *classType);

    nsresult (*GetLastUpdated)(IAdditionsFacility *pThis, PRInt64 *lastUpdated);

    nsresult (*GetName)(IAdditionsFacility *pThis, PRUnichar * *name);

    nsresult (*GetStatus)(IAdditionsFacility *pThis, PRUint32 *status);

    nsresult (*GetType)(IAdditionsFacility *pThis, PRUint32 *type);

    nsresult (*GetInternalAndReservedAttribute1IAdditionsFacility)(IAdditionsFacility *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IAdditionsFacility)(IAdditionsFacility *pThis, PRUint32 *reserved);

};
#else /* VBOX_WITH_GLUE */
struct IAdditionsFacilityVtbl
{
    nsresult (*QueryInterface)(IAdditionsFacility *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IAdditionsFacility *pThis);
    nsrefcnt (*Release)(IAdditionsFacility *pThis);
    nsresult (*GetClassType)(IAdditionsFacility *pThis, PRUint32 *classType);

    nsresult (*GetLastUpdated)(IAdditionsFacility *pThis, PRInt64 *lastUpdated);

    nsresult (*GetName)(IAdditionsFacility *pThis, PRUnichar * *name);

    nsresult (*GetStatus)(IAdditionsFacility *pThis, PRUint32 *status);

    nsresult (*GetType)(IAdditionsFacility *pThis, PRUint32 *type);

    nsresult (*GetInternalAndReservedAttribute1IAdditionsFacility)(IAdditionsFacility *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IAdditionsFacility)(IAdditionsFacility *pThis, PRUint32 *reserved);

};
#define IAdditionsFacility_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IAdditionsFacility_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IAdditionsFacility_Release(p) ((p)->lpVtbl->Release(p))
#define IAdditionsFacility_get_ClassType(p, aClassType) ((p)->lpVtbl->GetClassType(p, aClassType))
#define IAdditionsFacility_GetClassType(p, aClassType) ((p)->lpVtbl->GetClassType(p, aClassType))
#define IAdditionsFacility_get_LastUpdated(p, aLastUpdated) ((p)->lpVtbl->GetLastUpdated(p, aLastUpdated))
#define IAdditionsFacility_GetLastUpdated(p, aLastUpdated) ((p)->lpVtbl->GetLastUpdated(p, aLastUpdated))
#define IAdditionsFacility_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IAdditionsFacility_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IAdditionsFacility_get_Status(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IAdditionsFacility_GetStatus(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IAdditionsFacility_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IAdditionsFacility_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#endif /* VBOX_WITH_GLUE */

interface IAdditionsFacility
{
#ifndef VBOX_WITH_GLUE
    struct IAdditionsFacility_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IAdditionsFacilityVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IAdditionsFacility declaration */


/* Start of struct IDnDBase declaration */
#define IDNDBASE_IID_STR "00727A73-000A-4C4A-006D-E7D300351186"
#define IDNDBASE_IID { \
    0x00727A73, 0x000A, 0x4C4A, \
    { 0x00, 0x6D, 0xE7, 0xD3, 0x00, 0x35, 0x11, 0x86 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDnDBase);
#ifndef VBOX_WITH_GLUE
struct IDnDBase_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetFormats)(IDnDBase *pThis, PRUint32 *formatsSize, PRUnichar * **formats);

    nsresult (*GetInternalAndReservedAttribute1IDnDBase)(IDnDBase *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDBase)(IDnDBase *pThis, PRUint32 *reserved);

    nsresult (*IsFormatSupported)(
        IDnDBase *pThis,
        PRUnichar * format,
        PRBool * supported
    );

    nsresult (*AddFormats)(
        IDnDBase *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*RemoveFormats)(
        IDnDBase *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*InternalAndReservedMethod1IDnDBase)(IDnDBase *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDnDBaseVtbl
{
    nsresult (*QueryInterface)(IDnDBase *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDnDBase *pThis);
    nsrefcnt (*Release)(IDnDBase *pThis);
    nsresult (*GetFormats)(IDnDBase *pThis, PRUint32 *formatsSize, PRUnichar * **formats);

    nsresult (*GetInternalAndReservedAttribute1IDnDBase)(IDnDBase *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDBase)(IDnDBase *pThis, PRUint32 *reserved);

    nsresult (*IsFormatSupported)(
        IDnDBase *pThis,
        PRUnichar * format,
        PRBool * supported
    );

    nsresult (*AddFormats)(
        IDnDBase *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*RemoveFormats)(
        IDnDBase *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*InternalAndReservedMethod1IDnDBase)(IDnDBase *pThis);

};
#define IDnDBase_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDnDBase_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDnDBase_Release(p) ((p)->lpVtbl->Release(p))
#define IDnDBase_get_Formats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IDnDBase_GetFormats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IDnDBase_IsFormatSupported(p, aFormat, aSupported) ((p)->lpVtbl->IsFormatSupported(p, aFormat, aSupported))
#define IDnDBase_AddFormats(p, aFormats) ((p)->lpVtbl->AddFormats(p, aFormats))
#define IDnDBase_RemoveFormats(p, aFormats) ((p)->lpVtbl->RemoveFormats(p, aFormats))
#endif /* VBOX_WITH_GLUE */

interface IDnDBase
{
#ifndef VBOX_WITH_GLUE
    struct IDnDBase_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDnDBaseVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDnDBase declaration */


/* Start of struct IDnDSource declaration */
#define IDNDSOURCE_IID_STR "d23a9ca3-42da-c94b-8aec-21968e08355d"
#define IDNDSOURCE_IID { \
    0xd23a9ca3, 0x42da, 0xc94b, \
    { 0x8a, 0xec, 0x21, 0x96, 0x8e, 0x08, 0x35, 0x5d } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDnDSource);
#ifndef VBOX_WITH_GLUE
struct IDnDSource_vtbl
{
    struct IDnDBase_vtbl idndbase;

    nsresult (*GetInternalAndReservedAttribute1IDnDSource)(IDnDSource *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDSource)(IDnDSource *pThis, PRUint32 *reserved);

    nsresult (*DragIsPending)(
        IDnDSource *pThis,
        PRUint32 screenId,
        PRUint32 *formatsSize,
        PRUnichar *** formats,
        PRUint32 *allowedActionsSize,
        PRUint32** allowedActions,
        PRUint32 * defaultAction
    );

    nsresult (*Drop)(
        IDnDSource *pThis,
        PRUnichar * format,
        PRUint32 action,
        IProgress * * progress
    );

    nsresult (*ReceiveData)(
        IDnDSource *pThis,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*InternalAndReservedMethod1IDnDSource)(IDnDSource *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDnDSourceVtbl
{
    nsresult (*QueryInterface)(IDnDSource *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDnDSource *pThis);
    nsrefcnt (*Release)(IDnDSource *pThis);
    nsresult (*GetFormats)(IDnDSource *pThis, PRUint32 *formatsSize, PRUnichar * **formats);

    nsresult (*GetInternalAndReservedAttribute1IDnDBase)(IDnDSource *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDBase)(IDnDSource *pThis, PRUint32 *reserved);

    nsresult (*IsFormatSupported)(
        IDnDSource *pThis,
        PRUnichar * format,
        PRBool * supported
    );

    nsresult (*AddFormats)(
        IDnDSource *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*RemoveFormats)(
        IDnDSource *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*InternalAndReservedMethod1IDnDBase)(IDnDSource *pThis);

    nsresult (*GetInternalAndReservedAttribute1IDnDSource)(IDnDSource *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDSource)(IDnDSource *pThis, PRUint32 *reserved);

    nsresult (*DragIsPending)(
        IDnDSource *pThis,
        PRUint32 screenId,
        PRUint32 *formatsSize,
        PRUnichar *** formats,
        PRUint32 *allowedActionsSize,
        PRUint32** allowedActions,
        PRUint32 * defaultAction
    );

    nsresult (*Drop)(
        IDnDSource *pThis,
        PRUnichar * format,
        PRUint32 action,
        IProgress * * progress
    );

    nsresult (*ReceiveData)(
        IDnDSource *pThis,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*InternalAndReservedMethod1IDnDSource)(IDnDSource *pThis);

};
#define IDnDSource_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDnDSource_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDnDSource_Release(p) ((p)->lpVtbl->Release(p))
#define IDnDSource_get_Formats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IDnDSource_GetFormats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IDnDSource_IsFormatSupported(p, aFormat, aSupported) ((p)->lpVtbl->IsFormatSupported(p, aFormat, aSupported))
#define IDnDSource_AddFormats(p, aFormats) ((p)->lpVtbl->AddFormats(p, aFormats))
#define IDnDSource_RemoveFormats(p, aFormats) ((p)->lpVtbl->RemoveFormats(p, aFormats))
#define IDnDSource_DragIsPending(p, aScreenId, aFormats, aAllowedActions, aDefaultAction) ((p)->lpVtbl->DragIsPending(p, aScreenId, aFormats, aAllowedActions, aDefaultAction))
#define IDnDSource_Drop(p, aFormat, aAction, aProgress) ((p)->lpVtbl->Drop(p, aFormat, aAction, aProgress))
#define IDnDSource_ReceiveData(p, aData) ((p)->lpVtbl->ReceiveData(p, aData))
#endif /* VBOX_WITH_GLUE */

interface IDnDSource
{
#ifndef VBOX_WITH_GLUE
    struct IDnDSource_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDnDSourceVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDnDSource declaration */


/* Start of struct IGuestDnDSource declaration */
#define IGUESTDNDSOURCE_IID_STR "dedfb5d9-4c1b-edf7-fdf3-c1be6827dc28"
#define IGUESTDNDSOURCE_IID { \
    0xdedfb5d9, 0x4c1b, 0xedf7, \
    { 0xfd, 0xf3, 0xc1, 0xbe, 0x68, 0x27, 0xdc, 0x28 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestDnDSource);
#ifndef VBOX_WITH_GLUE
struct IGuestDnDSource_vtbl
{
    struct IDnDSource_vtbl idndsource;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestDnDSource *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#else /* VBOX_WITH_GLUE */
struct IGuestDnDSourceVtbl
{
    nsresult (*QueryInterface)(IGuestDnDSource *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestDnDSource *pThis);
    nsrefcnt (*Release)(IGuestDnDSource *pThis);
    nsresult (*GetFormats)(IGuestDnDSource *pThis, PRUint32 *formatsSize, PRUnichar * **formats);

    nsresult (*GetInternalAndReservedAttribute1IDnDBase)(IGuestDnDSource *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDBase)(IGuestDnDSource *pThis, PRUint32 *reserved);

    nsresult (*IsFormatSupported)(
        IGuestDnDSource *pThis,
        PRUnichar * format,
        PRBool * supported
    );

    nsresult (*AddFormats)(
        IGuestDnDSource *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*RemoveFormats)(
        IGuestDnDSource *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*InternalAndReservedMethod1IDnDBase)(IGuestDnDSource *pThis);

    nsresult (*GetInternalAndReservedAttribute1IDnDSource)(IGuestDnDSource *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDSource)(IGuestDnDSource *pThis, PRUint32 *reserved);

    nsresult (*DragIsPending)(
        IGuestDnDSource *pThis,
        PRUint32 screenId,
        PRUint32 *formatsSize,
        PRUnichar *** formats,
        PRUint32 *allowedActionsSize,
        PRUint32** allowedActions,
        PRUint32 * defaultAction
    );

    nsresult (*Drop)(
        IGuestDnDSource *pThis,
        PRUnichar * format,
        PRUint32 action,
        IProgress * * progress
    );

    nsresult (*ReceiveData)(
        IGuestDnDSource *pThis,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*InternalAndReservedMethod1IDnDSource)(IGuestDnDSource *pThis);

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestDnDSource *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#define IGuestDnDSource_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestDnDSource_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestDnDSource_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestDnDSource_get_Formats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IGuestDnDSource_GetFormats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IGuestDnDSource_IsFormatSupported(p, aFormat, aSupported) ((p)->lpVtbl->IsFormatSupported(p, aFormat, aSupported))
#define IGuestDnDSource_AddFormats(p, aFormats) ((p)->lpVtbl->AddFormats(p, aFormats))
#define IGuestDnDSource_RemoveFormats(p, aFormats) ((p)->lpVtbl->RemoveFormats(p, aFormats))
#define IGuestDnDSource_DragIsPending(p, aScreenId, aFormats, aAllowedActions, aDefaultAction) ((p)->lpVtbl->DragIsPending(p, aScreenId, aFormats, aAllowedActions, aDefaultAction))
#define IGuestDnDSource_Drop(p, aFormat, aAction, aProgress) ((p)->lpVtbl->Drop(p, aFormat, aAction, aProgress))
#define IGuestDnDSource_ReceiveData(p, aData) ((p)->lpVtbl->ReceiveData(p, aData))
#define IGuestDnDSource_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IGuestDnDSource_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IGuestDnDSource
{
#ifndef VBOX_WITH_GLUE
    struct IGuestDnDSource_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestDnDSourceVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestDnDSource declaration */


/* Start of struct IDnDTarget declaration */
#define IDNDTARGET_IID_STR "ff5befc3-4ba3-7903-2aa4-43988ba11554"
#define IDNDTARGET_IID { \
    0xff5befc3, 0x4ba3, 0x7903, \
    { 0x2a, 0xa4, 0x43, 0x98, 0x8b, 0xa1, 0x15, 0x54 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDnDTarget);
#ifndef VBOX_WITH_GLUE
struct IDnDTarget_vtbl
{
    struct IDnDBase_vtbl idndbase;

    nsresult (*GetInternalAndReservedAttribute1IDnDTarget)(IDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDTarget)(IDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*Enter)(
        IDnDTarget *pThis,
        PRUint32 screenId,
        PRUint32 y,
        PRUint32 x,
        PRUint32 defaultAction,
        PRUint32 allowedActionsSize,
        PRUint32* allowedActions,
        PRUint32 formatsSize,
        PRUnichar ** formats,
        PRUint32 * resultAction
    );

    nsresult (*Move)(
        IDnDTarget *pThis,
        PRUint32 screenId,
        PRUint32 x,
        PRUint32 y,
        PRUint32 defaultAction,
        PRUint32 allowedActionsSize,
        PRUint32* allowedActions,
        PRUint32 formatsSize,
        PRUnichar ** formats,
        PRUint32 * resultAction
    );

    nsresult (*Leave)(
        IDnDTarget *pThis,
        PRUint32 screenId
    );

    nsresult (*Drop)(
        IDnDTarget *pThis,
        PRUint32 screenId,
        PRUint32 x,
        PRUint32 y,
        PRUint32 defaultAction,
        PRUint32 allowedActionsSize,
        PRUint32* allowedActions,
        PRUint32 formatsSize,
        PRUnichar ** formats,
        PRUnichar * * format,
        PRUint32 * resultAction
    );

    nsresult (*SendData)(
        IDnDTarget *pThis,
        PRUint32 screenId,
        PRUnichar * format,
        PRUint32 dataSize,
        PRUint8* data,
        IProgress * * progress
    );

    nsresult (*Cancel)(
        IDnDTarget *pThis,
        PRBool * veto
    );

    nsresult (*InternalAndReservedMethod1IDnDTarget)(IDnDTarget *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDnDTargetVtbl
{
    nsresult (*QueryInterface)(IDnDTarget *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDnDTarget *pThis);
    nsrefcnt (*Release)(IDnDTarget *pThis);
    nsresult (*GetFormats)(IDnDTarget *pThis, PRUint32 *formatsSize, PRUnichar * **formats);

    nsresult (*GetInternalAndReservedAttribute1IDnDBase)(IDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDBase)(IDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*IsFormatSupported)(
        IDnDTarget *pThis,
        PRUnichar * format,
        PRBool * supported
    );

    nsresult (*AddFormats)(
        IDnDTarget *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*RemoveFormats)(
        IDnDTarget *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*InternalAndReservedMethod1IDnDBase)(IDnDTarget *pThis);

    nsresult (*GetInternalAndReservedAttribute1IDnDTarget)(IDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDTarget)(IDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*Enter)(
        IDnDTarget *pThis,
        PRUint32 screenId,
        PRUint32 y,
        PRUint32 x,
        PRUint32 defaultAction,
        PRUint32 allowedActionsSize,
        PRUint32* allowedActions,
        PRUint32 formatsSize,
        PRUnichar ** formats,
        PRUint32 * resultAction
    );

    nsresult (*Move)(
        IDnDTarget *pThis,
        PRUint32 screenId,
        PRUint32 x,
        PRUint32 y,
        PRUint32 defaultAction,
        PRUint32 allowedActionsSize,
        PRUint32* allowedActions,
        PRUint32 formatsSize,
        PRUnichar ** formats,
        PRUint32 * resultAction
    );

    nsresult (*Leave)(
        IDnDTarget *pThis,
        PRUint32 screenId
    );

    nsresult (*Drop)(
        IDnDTarget *pThis,
        PRUint32 screenId,
        PRUint32 x,
        PRUint32 y,
        PRUint32 defaultAction,
        PRUint32 allowedActionsSize,
        PRUint32* allowedActions,
        PRUint32 formatsSize,
        PRUnichar ** formats,
        PRUnichar * * format,
        PRUint32 * resultAction
    );

    nsresult (*SendData)(
        IDnDTarget *pThis,
        PRUint32 screenId,
        PRUnichar * format,
        PRUint32 dataSize,
        PRUint8* data,
        IProgress * * progress
    );

    nsresult (*Cancel)(
        IDnDTarget *pThis,
        PRBool * veto
    );

    nsresult (*InternalAndReservedMethod1IDnDTarget)(IDnDTarget *pThis);

};
#define IDnDTarget_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDnDTarget_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDnDTarget_Release(p) ((p)->lpVtbl->Release(p))
#define IDnDTarget_get_Formats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IDnDTarget_GetFormats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IDnDTarget_IsFormatSupported(p, aFormat, aSupported) ((p)->lpVtbl->IsFormatSupported(p, aFormat, aSupported))
#define IDnDTarget_AddFormats(p, aFormats) ((p)->lpVtbl->AddFormats(p, aFormats))
#define IDnDTarget_RemoveFormats(p, aFormats) ((p)->lpVtbl->RemoveFormats(p, aFormats))
#define IDnDTarget_Enter(p, aScreenId, aY, aX, aDefaultAction, aAllowedActions, aFormats, aResultAction) ((p)->lpVtbl->Enter(p, aScreenId, aY, aX, aDefaultAction, aAllowedActions, aFormats, aResultAction))
#define IDnDTarget_Move(p, aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aResultAction) ((p)->lpVtbl->Move(p, aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aResultAction))
#define IDnDTarget_Leave(p, aScreenId) ((p)->lpVtbl->Leave(p, aScreenId))
#define IDnDTarget_Drop(p, aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aFormat, aResultAction) ((p)->lpVtbl->Drop(p, aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aFormat, aResultAction))
#define IDnDTarget_SendData(p, aScreenId, aFormat, aData, aProgress) ((p)->lpVtbl->SendData(p, aScreenId, aFormat, aData, aProgress))
#define IDnDTarget_Cancel(p, aVeto) ((p)->lpVtbl->Cancel(p, aVeto))
#endif /* VBOX_WITH_GLUE */

interface IDnDTarget
{
#ifndef VBOX_WITH_GLUE
    struct IDnDTarget_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDnDTargetVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDnDTarget declaration */


/* Start of struct IGuestDnDTarget declaration */
#define IGUESTDNDTARGET_IID_STR "50ce4b51-0ff7-46b7-a138-3c6e5ac946b4"
#define IGUESTDNDTARGET_IID { \
    0x50ce4b51, 0x0ff7, 0x46b7, \
    { 0xa1, 0x38, 0x3c, 0x6e, 0x5a, 0xc9, 0x46, 0xb4 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestDnDTarget);
#ifndef VBOX_WITH_GLUE
struct IGuestDnDTarget_vtbl
{
    struct IDnDTarget_vtbl idndtarget;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestDnDTarget *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#else /* VBOX_WITH_GLUE */
struct IGuestDnDTargetVtbl
{
    nsresult (*QueryInterface)(IGuestDnDTarget *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestDnDTarget *pThis);
    nsrefcnt (*Release)(IGuestDnDTarget *pThis);
    nsresult (*GetFormats)(IGuestDnDTarget *pThis, PRUint32 *formatsSize, PRUnichar * **formats);

    nsresult (*GetInternalAndReservedAttribute1IDnDBase)(IGuestDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDBase)(IGuestDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*IsFormatSupported)(
        IGuestDnDTarget *pThis,
        PRUnichar * format,
        PRBool * supported
    );

    nsresult (*AddFormats)(
        IGuestDnDTarget *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*RemoveFormats)(
        IGuestDnDTarget *pThis,
        PRUint32 formatsSize,
        PRUnichar ** formats
    );

    nsresult (*InternalAndReservedMethod1IDnDBase)(IGuestDnDTarget *pThis);

    nsresult (*GetInternalAndReservedAttribute1IDnDTarget)(IGuestDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDnDTarget)(IGuestDnDTarget *pThis, PRUint32 *reserved);

    nsresult (*Enter)(
        IGuestDnDTarget *pThis,
        PRUint32 screenId,
        PRUint32 y,
        PRUint32 x,
        PRUint32 defaultAction,
        PRUint32 allowedActionsSize,
        PRUint32* allowedActions,
        PRUint32 formatsSize,
        PRUnichar ** formats,
        PRUint32 * resultAction
    );

    nsresult (*Move)(
        IGuestDnDTarget *pThis,
        PRUint32 screenId,
        PRUint32 x,
        PRUint32 y,
        PRUint32 defaultAction,
        PRUint32 allowedActionsSize,
        PRUint32* allowedActions,
        PRUint32 formatsSize,
        PRUnichar ** formats,
        PRUint32 * resultAction
    );

    nsresult (*Leave)(
        IGuestDnDTarget *pThis,
        PRUint32 screenId
    );

    nsresult (*Drop)(
        IGuestDnDTarget *pThis,
        PRUint32 screenId,
        PRUint32 x,
        PRUint32 y,
        PRUint32 defaultAction,
        PRUint32 allowedActionsSize,
        PRUint32* allowedActions,
        PRUint32 formatsSize,
        PRUnichar ** formats,
        PRUnichar * * format,
        PRUint32 * resultAction
    );

    nsresult (*SendData)(
        IGuestDnDTarget *pThis,
        PRUint32 screenId,
        PRUnichar * format,
        PRUint32 dataSize,
        PRUint8* data,
        IProgress * * progress
    );

    nsresult (*Cancel)(
        IGuestDnDTarget *pThis,
        PRBool * veto
    );

    nsresult (*InternalAndReservedMethod1IDnDTarget)(IGuestDnDTarget *pThis);

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestDnDTarget *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#define IGuestDnDTarget_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestDnDTarget_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestDnDTarget_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestDnDTarget_get_Formats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IGuestDnDTarget_GetFormats(p, aFormats) ((p)->lpVtbl->GetFormats(p, aFormats))
#define IGuestDnDTarget_IsFormatSupported(p, aFormat, aSupported) ((p)->lpVtbl->IsFormatSupported(p, aFormat, aSupported))
#define IGuestDnDTarget_AddFormats(p, aFormats) ((p)->lpVtbl->AddFormats(p, aFormats))
#define IGuestDnDTarget_RemoveFormats(p, aFormats) ((p)->lpVtbl->RemoveFormats(p, aFormats))
#define IGuestDnDTarget_Enter(p, aScreenId, aY, aX, aDefaultAction, aAllowedActions, aFormats, aResultAction) ((p)->lpVtbl->Enter(p, aScreenId, aY, aX, aDefaultAction, aAllowedActions, aFormats, aResultAction))
#define IGuestDnDTarget_Move(p, aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aResultAction) ((p)->lpVtbl->Move(p, aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aResultAction))
#define IGuestDnDTarget_Leave(p, aScreenId) ((p)->lpVtbl->Leave(p, aScreenId))
#define IGuestDnDTarget_Drop(p, aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aFormat, aResultAction) ((p)->lpVtbl->Drop(p, aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aFormat, aResultAction))
#define IGuestDnDTarget_SendData(p, aScreenId, aFormat, aData, aProgress) ((p)->lpVtbl->SendData(p, aScreenId, aFormat, aData, aProgress))
#define IGuestDnDTarget_Cancel(p, aVeto) ((p)->lpVtbl->Cancel(p, aVeto))
#define IGuestDnDTarget_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IGuestDnDTarget_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IGuestDnDTarget
{
#ifndef VBOX_WITH_GLUE
    struct IGuestDnDTarget_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestDnDTargetVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestDnDTarget declaration */


/* Start of struct IGuestSession declaration */
#define IGUESTSESSION_IID_STR "8b2b6773-8b5a-4cd2-95f8-38faf73913e1"
#define IGUESTSESSION_IID { \
    0x8b2b6773, 0x8b5a, 0x4cd2, \
    { 0x95, 0xf8, 0x38, 0xfa, 0xf7, 0x39, 0x13, 0xe1 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestSession);
#ifndef VBOX_WITH_GLUE
struct IGuestSession_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetUser)(IGuestSession *pThis, PRUnichar * *user);

    nsresult (*GetDomain)(IGuestSession *pThis, PRUnichar * *domain);

    nsresult (*GetName)(IGuestSession *pThis, PRUnichar * *name);

    nsresult (*GetId)(IGuestSession *pThis, PRUint32 *id);

    nsresult (*GetTimeout)(IGuestSession *pThis, PRUint32 *timeout);
    nsresult (*SetTimeout)(IGuestSession *pThis, PRUint32 timeout);

    nsresult (*GetProtocolVersion)(IGuestSession *pThis, PRUint32 *protocolVersion);

    nsresult (*GetStatus)(IGuestSession *pThis, PRUint32 *status);

    nsresult (*GetEnvironmentChanges)(IGuestSession *pThis, PRUint32 *environmentChangesSize, PRUnichar * **environmentChanges);
    nsresult (*SetEnvironmentChanges)(IGuestSession *pThis, PRUint32 environmentChangesSize, PRUnichar * *environmentChanges);

    nsresult (*GetEnvironmentBase)(IGuestSession *pThis, PRUint32 *environmentBaseSize, PRUnichar * **environmentBase);

    nsresult (*GetProcesses)(IGuestSession *pThis, PRUint32 *processesSize, IGuestProcess * **processes);

    nsresult (*GetPathStyle)(IGuestSession *pThis, PRUint32 *pathStyle);

    nsresult (*GetCurrentDirectory)(IGuestSession *pThis, PRUnichar * *currentDirectory);
    nsresult (*SetCurrentDirectory)(IGuestSession *pThis, PRUnichar * currentDirectory);

    nsresult (*GetUserHome)(IGuestSession *pThis, PRUnichar * *userHome);

    nsresult (*GetUserDocuments)(IGuestSession *pThis, PRUnichar * *userDocuments);

    nsresult (*GetMountPoints)(IGuestSession *pThis, PRUint32 *mountPointsSize, PRUnichar * **mountPoints);

    nsresult (*GetDirectories)(IGuestSession *pThis, PRUint32 *directoriesSize, IGuestDirectory * **directories);

    nsresult (*GetFiles)(IGuestSession *pThis, PRUint32 *filesSize, IGuestFile * **files);

    nsresult (*GetEventSource)(IGuestSession *pThis, IEventSource * *eventSource);

    nsresult (*GetInternalAndReservedAttribute1IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*Close)(IGuestSession *pThis );

    nsresult (*CopyFromGuest)(
        IGuestSession *pThis,
        PRUint32 sourcesSize,
        PRUnichar ** sources,
        PRUint32 filtersSize,
        PRUnichar ** filters,
        PRUint32 flagsSize,
        PRUnichar ** flags,
        PRUnichar * destination,
        IProgress * * progress
    );

    nsresult (*CopyToGuest)(
        IGuestSession *pThis,
        PRUint32 sourcesSize,
        PRUnichar ** sources,
        PRUint32 filtersSize,
        PRUnichar ** filters,
        PRUint32 flagsSize,
        PRUnichar ** flags,
        PRUnichar * destination,
        IProgress * * progress
    );

    nsresult (*DirectoryCopy)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*DirectoryCopyFromGuest)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*DirectoryCopyToGuest)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*DirectoryCreate)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUint32 mode,
        PRUint32 flagsSize,
        PRUint32* flags
    );

    nsresult (*DirectoryCreateTemp)(
        IGuestSession *pThis,
        PRUnichar * templateName,
        PRUint32 mode,
        PRUnichar * path,
        PRBool secure,
        PRUnichar * * directory
    );

    nsresult (*DirectoryExists)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRBool * exists
    );

    nsresult (*DirectoryOpen)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUnichar * filter,
        PRUint32 flagsSize,
        PRUint32* flags,
        IGuestDirectory * * directory
    );

    nsresult (*DirectoryRemove)(
        IGuestSession *pThis,
        PRUnichar * path
    );

    nsresult (*DirectoryRemoveRecursive)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*EnvironmentScheduleSet)(
        IGuestSession *pThis,
        PRUnichar * name,
        PRUnichar * value
    );

    nsresult (*EnvironmentScheduleUnset)(
        IGuestSession *pThis,
        PRUnichar * name
    );

    nsresult (*EnvironmentGetBaseVariable)(
        IGuestSession *pThis,
        PRUnichar * name,
        PRUnichar * * value
    );

    nsresult (*EnvironmentDoesBaseVariableExist)(
        IGuestSession *pThis,
        PRUnichar * name,
        PRBool * exists
    );

    nsresult (*FileCopy)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FileCopyFromGuest)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FileCopyToGuest)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FileCreateTemp)(
        IGuestSession *pThis,
        PRUnichar * templateName,
        PRUint32 mode,
        PRUnichar * path,
        PRBool secure,
        IGuestFile * * file
    );

    nsresult (*FileExists)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRBool * exists
    );

    nsresult (*FileOpen)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUint32 accessMode,
        PRUint32 openAction,
        PRUint32 creationMode,
        IGuestFile * * file
    );

    nsresult (*FileOpenEx)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUint32 accessMode,
        PRUint32 openAction,
        PRUint32 sharingMode,
        PRUint32 creationMode,
        PRUint32 flagsSize,
        PRUint32* flags,
        IGuestFile * * file
    );

    nsresult (*FileQuerySize)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRInt64 * size
    );

    nsresult (*FsObjExists)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRBool * exists
    );

    nsresult (*FsObjQueryInfo)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        IGuestFsObjInfo * * info
    );

    nsresult (*FsObjRemove)(
        IGuestSession *pThis,
        PRUnichar * path
    );

    nsresult (*FsObjRemoveArray)(
        IGuestSession *pThis,
        PRUint32 pathSize,
        PRUnichar ** path,
        IProgress * * progress
    );

    nsresult (*FsObjRename)(
        IGuestSession *pThis,
        PRUnichar * oldPath,
        PRUnichar * newPath,
        PRUint32 flagsSize,
        PRUint32* flags
    );

    nsresult (*FsObjMove)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FsObjMoveArray)(
        IGuestSession *pThis,
        PRUint32 sourceSize,
        PRUnichar ** source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FsObjCopyArray)(
        IGuestSession *pThis,
        PRUint32 sourceSize,
        PRUnichar ** source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FsObjSetACL)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRUnichar * acl,
        PRUint32 mode
    );

    nsresult (*FsQueryFreeSpace)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRInt64 * freeSpace
    );

    nsresult (*FsQueryInfo)(
        IGuestSession *pThis,
        PRUnichar * path,
        IGuestFsInfo * * info
    );

    nsresult (*ProcessCreate)(
        IGuestSession *pThis,
        PRUnichar * executable,
        PRUint32 argumentsSize,
        PRUnichar ** arguments,
        PRUnichar * cwd,
        PRUint32 environmentChangesSize,
        PRUnichar ** environmentChanges,
        PRUint32 flagsSize,
        PRUint32* flags,
        PRUint32 timeoutMS,
        IGuestProcess * * guestProcess
    );

    nsresult (*ProcessCreateEx)(
        IGuestSession *pThis,
        PRUnichar * executable,
        PRUint32 argumentsSize,
        PRUnichar ** arguments,
        PRUnichar * cwd,
        PRUint32 environmentChangesSize,
        PRUnichar ** environmentChanges,
        PRUint32 flagsSize,
        PRUint32* flags,
        PRUint32 timeoutMS,
        PRUint32 priority,
        PRUint32 affinitySize,
        PRInt32* affinity,
        IGuestProcess * * guestProcess
    );

    nsresult (*ProcessGet)(
        IGuestSession *pThis,
        PRUint32 pid,
        IGuestProcess * * guestProcess
    );

    nsresult (*SymlinkCreate)(
        IGuestSession *pThis,
        PRUnichar * symlink,
        PRUnichar * target,
        PRUint32 type
    );

    nsresult (*SymlinkExists)(
        IGuestSession *pThis,
        PRUnichar * symlink,
        PRBool * exists
    );

    nsresult (*SymlinkRead)(
        IGuestSession *pThis,
        PRUnichar * symlink,
        PRUint32 flagsSize,
        PRUint32* flags,
        PRUnichar * * target
    );

    nsresult (*WaitFor)(
        IGuestSession *pThis,
        PRUint32 waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*WaitForArray)(
        IGuestSession *pThis,
        PRUint32 waitForSize,
        PRUint32* waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*InternalAndReservedMethod1IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod2IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod3IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod4IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod5IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod6IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod7IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod8IGuestSession)(IGuestSession *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IGuestSessionVtbl
{
    nsresult (*QueryInterface)(IGuestSession *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestSession *pThis);
    nsrefcnt (*Release)(IGuestSession *pThis);
    nsresult (*GetUser)(IGuestSession *pThis, PRUnichar * *user);

    nsresult (*GetDomain)(IGuestSession *pThis, PRUnichar * *domain);

    nsresult (*GetName)(IGuestSession *pThis, PRUnichar * *name);

    nsresult (*GetId)(IGuestSession *pThis, PRUint32 *id);

    nsresult (*GetTimeout)(IGuestSession *pThis, PRUint32 *timeout);
    nsresult (*SetTimeout)(IGuestSession *pThis, PRUint32 timeout);

    nsresult (*GetProtocolVersion)(IGuestSession *pThis, PRUint32 *protocolVersion);

    nsresult (*GetStatus)(IGuestSession *pThis, PRUint32 *status);

    nsresult (*GetEnvironmentChanges)(IGuestSession *pThis, PRUint32 *environmentChangesSize, PRUnichar * **environmentChanges);
    nsresult (*SetEnvironmentChanges)(IGuestSession *pThis, PRUint32 environmentChangesSize, PRUnichar * *environmentChanges);

    nsresult (*GetEnvironmentBase)(IGuestSession *pThis, PRUint32 *environmentBaseSize, PRUnichar * **environmentBase);

    nsresult (*GetProcesses)(IGuestSession *pThis, PRUint32 *processesSize, IGuestProcess * **processes);

    nsresult (*GetPathStyle)(IGuestSession *pThis, PRUint32 *pathStyle);

    nsresult (*GetCurrentDirectory)(IGuestSession *pThis, PRUnichar * *currentDirectory);
    nsresult (*SetCurrentDirectory)(IGuestSession *pThis, PRUnichar * currentDirectory);

    nsresult (*GetUserHome)(IGuestSession *pThis, PRUnichar * *userHome);

    nsresult (*GetUserDocuments)(IGuestSession *pThis, PRUnichar * *userDocuments);

    nsresult (*GetMountPoints)(IGuestSession *pThis, PRUint32 *mountPointsSize, PRUnichar * **mountPoints);

    nsresult (*GetDirectories)(IGuestSession *pThis, PRUint32 *directoriesSize, IGuestDirectory * **directories);

    nsresult (*GetFiles)(IGuestSession *pThis, PRUint32 *filesSize, IGuestFile * **files);

    nsresult (*GetEventSource)(IGuestSession *pThis, IEventSource * *eventSource);

    nsresult (*GetInternalAndReservedAttribute1IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IGuestSession)(IGuestSession *pThis, PRUint32 *reserved);

    nsresult (*Close)(IGuestSession *pThis );

    nsresult (*CopyFromGuest)(
        IGuestSession *pThis,
        PRUint32 sourcesSize,
        PRUnichar ** sources,
        PRUint32 filtersSize,
        PRUnichar ** filters,
        PRUint32 flagsSize,
        PRUnichar ** flags,
        PRUnichar * destination,
        IProgress * * progress
    );

    nsresult (*CopyToGuest)(
        IGuestSession *pThis,
        PRUint32 sourcesSize,
        PRUnichar ** sources,
        PRUint32 filtersSize,
        PRUnichar ** filters,
        PRUint32 flagsSize,
        PRUnichar ** flags,
        PRUnichar * destination,
        IProgress * * progress
    );

    nsresult (*DirectoryCopy)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*DirectoryCopyFromGuest)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*DirectoryCopyToGuest)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*DirectoryCreate)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUint32 mode,
        PRUint32 flagsSize,
        PRUint32* flags
    );

    nsresult (*DirectoryCreateTemp)(
        IGuestSession *pThis,
        PRUnichar * templateName,
        PRUint32 mode,
        PRUnichar * path,
        PRBool secure,
        PRUnichar * * directory
    );

    nsresult (*DirectoryExists)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRBool * exists
    );

    nsresult (*DirectoryOpen)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUnichar * filter,
        PRUint32 flagsSize,
        PRUint32* flags,
        IGuestDirectory * * directory
    );

    nsresult (*DirectoryRemove)(
        IGuestSession *pThis,
        PRUnichar * path
    );

    nsresult (*DirectoryRemoveRecursive)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*EnvironmentScheduleSet)(
        IGuestSession *pThis,
        PRUnichar * name,
        PRUnichar * value
    );

    nsresult (*EnvironmentScheduleUnset)(
        IGuestSession *pThis,
        PRUnichar * name
    );

    nsresult (*EnvironmentGetBaseVariable)(
        IGuestSession *pThis,
        PRUnichar * name,
        PRUnichar * * value
    );

    nsresult (*EnvironmentDoesBaseVariableExist)(
        IGuestSession *pThis,
        PRUnichar * name,
        PRBool * exists
    );

    nsresult (*FileCopy)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FileCopyFromGuest)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FileCopyToGuest)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FileCreateTemp)(
        IGuestSession *pThis,
        PRUnichar * templateName,
        PRUint32 mode,
        PRUnichar * path,
        PRBool secure,
        IGuestFile * * file
    );

    nsresult (*FileExists)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRBool * exists
    );

    nsresult (*FileOpen)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUint32 accessMode,
        PRUint32 openAction,
        PRUint32 creationMode,
        IGuestFile * * file
    );

    nsresult (*FileOpenEx)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRUint32 accessMode,
        PRUint32 openAction,
        PRUint32 sharingMode,
        PRUint32 creationMode,
        PRUint32 flagsSize,
        PRUint32* flags,
        IGuestFile * * file
    );

    nsresult (*FileQuerySize)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRInt64 * size
    );

    nsresult (*FsObjExists)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRBool * exists
    );

    nsresult (*FsObjQueryInfo)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        IGuestFsObjInfo * * info
    );

    nsresult (*FsObjRemove)(
        IGuestSession *pThis,
        PRUnichar * path
    );

    nsresult (*FsObjRemoveArray)(
        IGuestSession *pThis,
        PRUint32 pathSize,
        PRUnichar ** path,
        IProgress * * progress
    );

    nsresult (*FsObjRename)(
        IGuestSession *pThis,
        PRUnichar * oldPath,
        PRUnichar * newPath,
        PRUint32 flagsSize,
        PRUint32* flags
    );

    nsresult (*FsObjMove)(
        IGuestSession *pThis,
        PRUnichar * source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FsObjMoveArray)(
        IGuestSession *pThis,
        PRUint32 sourceSize,
        PRUnichar ** source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FsObjCopyArray)(
        IGuestSession *pThis,
        PRUint32 sourceSize,
        PRUnichar ** source,
        PRUnichar * destination,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*FsObjSetACL)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRBool followSymlinks,
        PRUnichar * acl,
        PRUint32 mode
    );

    nsresult (*FsQueryFreeSpace)(
        IGuestSession *pThis,
        PRUnichar * path,
        PRInt64 * freeSpace
    );

    nsresult (*FsQueryInfo)(
        IGuestSession *pThis,
        PRUnichar * path,
        IGuestFsInfo * * info
    );

    nsresult (*ProcessCreate)(
        IGuestSession *pThis,
        PRUnichar * executable,
        PRUint32 argumentsSize,
        PRUnichar ** arguments,
        PRUnichar * cwd,
        PRUint32 environmentChangesSize,
        PRUnichar ** environmentChanges,
        PRUint32 flagsSize,
        PRUint32* flags,
        PRUint32 timeoutMS,
        IGuestProcess * * guestProcess
    );

    nsresult (*ProcessCreateEx)(
        IGuestSession *pThis,
        PRUnichar * executable,
        PRUint32 argumentsSize,
        PRUnichar ** arguments,
        PRUnichar * cwd,
        PRUint32 environmentChangesSize,
        PRUnichar ** environmentChanges,
        PRUint32 flagsSize,
        PRUint32* flags,
        PRUint32 timeoutMS,
        PRUint32 priority,
        PRUint32 affinitySize,
        PRInt32* affinity,
        IGuestProcess * * guestProcess
    );

    nsresult (*ProcessGet)(
        IGuestSession *pThis,
        PRUint32 pid,
        IGuestProcess * * guestProcess
    );

    nsresult (*SymlinkCreate)(
        IGuestSession *pThis,
        PRUnichar * symlink,
        PRUnichar * target,
        PRUint32 type
    );

    nsresult (*SymlinkExists)(
        IGuestSession *pThis,
        PRUnichar * symlink,
        PRBool * exists
    );

    nsresult (*SymlinkRead)(
        IGuestSession *pThis,
        PRUnichar * symlink,
        PRUint32 flagsSize,
        PRUint32* flags,
        PRUnichar * * target
    );

    nsresult (*WaitFor)(
        IGuestSession *pThis,
        PRUint32 waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*WaitForArray)(
        IGuestSession *pThis,
        PRUint32 waitForSize,
        PRUint32* waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*InternalAndReservedMethod1IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod2IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod3IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod4IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod5IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod6IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod7IGuestSession)(IGuestSession *pThis);

    nsresult (*InternalAndReservedMethod8IGuestSession)(IGuestSession *pThis);

};
#define IGuestSession_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestSession_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestSession_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestSession_get_User(p, aUser) ((p)->lpVtbl->GetUser(p, aUser))
#define IGuestSession_GetUser(p, aUser) ((p)->lpVtbl->GetUser(p, aUser))
#define IGuestSession_get_Domain(p, aDomain) ((p)->lpVtbl->GetDomain(p, aDomain))
#define IGuestSession_GetDomain(p, aDomain) ((p)->lpVtbl->GetDomain(p, aDomain))
#define IGuestSession_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IGuestSession_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IGuestSession_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IGuestSession_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IGuestSession_get_Timeout(p, aTimeout) ((p)->lpVtbl->GetTimeout(p, aTimeout))
#define IGuestSession_GetTimeout(p, aTimeout) ((p)->lpVtbl->GetTimeout(p, aTimeout))
#define IGuestSession_put_Timeout(p, aTimeout) ((p)->lpVtbl->SetTimeout(p, aTimeout))
#define IGuestSession_SetTimeout(p, aTimeout) ((p)->lpVtbl->SetTimeout(p, aTimeout))
#define IGuestSession_get_ProtocolVersion(p, aProtocolVersion) ((p)->lpVtbl->GetProtocolVersion(p, aProtocolVersion))
#define IGuestSession_GetProtocolVersion(p, aProtocolVersion) ((p)->lpVtbl->GetProtocolVersion(p, aProtocolVersion))
#define IGuestSession_get_Status(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IGuestSession_GetStatus(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IGuestSession_get_EnvironmentChanges(p, aEnvironmentChanges) ((p)->lpVtbl->GetEnvironmentChanges(p, aEnvironmentChanges))
#define IGuestSession_GetEnvironmentChanges(p, aEnvironmentChanges) ((p)->lpVtbl->GetEnvironmentChanges(p, aEnvironmentChanges))
#define IGuestSession_put_EnvironmentChanges(p, aEnvironmentChanges) ((p)->lpVtbl->SetEnvironmentChanges(p, aEnvironmentChanges))
#define IGuestSession_SetEnvironmentChanges(p, aEnvironmentChanges) ((p)->lpVtbl->SetEnvironmentChanges(p, aEnvironmentChanges))
#define IGuestSession_get_EnvironmentBase(p, aEnvironmentBase) ((p)->lpVtbl->GetEnvironmentBase(p, aEnvironmentBase))
#define IGuestSession_GetEnvironmentBase(p, aEnvironmentBase) ((p)->lpVtbl->GetEnvironmentBase(p, aEnvironmentBase))
#define IGuestSession_get_Processes(p, aProcesses) ((p)->lpVtbl->GetProcesses(p, aProcesses))
#define IGuestSession_GetProcesses(p, aProcesses) ((p)->lpVtbl->GetProcesses(p, aProcesses))
#define IGuestSession_get_PathStyle(p, aPathStyle) ((p)->lpVtbl->GetPathStyle(p, aPathStyle))
#define IGuestSession_GetPathStyle(p, aPathStyle) ((p)->lpVtbl->GetPathStyle(p, aPathStyle))
#define IGuestSession_get_CurrentDirectory(p, aCurrentDirectory) ((p)->lpVtbl->GetCurrentDirectory(p, aCurrentDirectory))
#define IGuestSession_GetCurrentDirectory(p, aCurrentDirectory) ((p)->lpVtbl->GetCurrentDirectory(p, aCurrentDirectory))
#define IGuestSession_put_CurrentDirectory(p, aCurrentDirectory) ((p)->lpVtbl->SetCurrentDirectory(p, aCurrentDirectory))
#define IGuestSession_SetCurrentDirectory(p, aCurrentDirectory) ((p)->lpVtbl->SetCurrentDirectory(p, aCurrentDirectory))
#define IGuestSession_get_UserHome(p, aUserHome) ((p)->lpVtbl->GetUserHome(p, aUserHome))
#define IGuestSession_GetUserHome(p, aUserHome) ((p)->lpVtbl->GetUserHome(p, aUserHome))
#define IGuestSession_get_UserDocuments(p, aUserDocuments) ((p)->lpVtbl->GetUserDocuments(p, aUserDocuments))
#define IGuestSession_GetUserDocuments(p, aUserDocuments) ((p)->lpVtbl->GetUserDocuments(p, aUserDocuments))
#define IGuestSession_get_MountPoints(p, aMountPoints) ((p)->lpVtbl->GetMountPoints(p, aMountPoints))
#define IGuestSession_GetMountPoints(p, aMountPoints) ((p)->lpVtbl->GetMountPoints(p, aMountPoints))
#define IGuestSession_get_Directories(p, aDirectories) ((p)->lpVtbl->GetDirectories(p, aDirectories))
#define IGuestSession_GetDirectories(p, aDirectories) ((p)->lpVtbl->GetDirectories(p, aDirectories))
#define IGuestSession_get_Files(p, aFiles) ((p)->lpVtbl->GetFiles(p, aFiles))
#define IGuestSession_GetFiles(p, aFiles) ((p)->lpVtbl->GetFiles(p, aFiles))
#define IGuestSession_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuestSession_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuestSession_Close(p) ((p)->lpVtbl->Close(p))
#define IGuestSession_CopyFromGuest(p, aSources, aFilters, aFlags, aDestination, aProgress) ((p)->lpVtbl->CopyFromGuest(p, aSources, aFilters, aFlags, aDestination, aProgress))
#define IGuestSession_CopyToGuest(p, aSources, aFilters, aFlags, aDestination, aProgress) ((p)->lpVtbl->CopyToGuest(p, aSources, aFilters, aFlags, aDestination, aProgress))
#define IGuestSession_DirectoryCopy(p, aSource, aDestination, aFlags, aProgress) ((p)->lpVtbl->DirectoryCopy(p, aSource, aDestination, aFlags, aProgress))
#define IGuestSession_DirectoryCopyFromGuest(p, aSource, aDestination, aFlags, aProgress) ((p)->lpVtbl->DirectoryCopyFromGuest(p, aSource, aDestination, aFlags, aProgress))
#define IGuestSession_DirectoryCopyToGuest(p, aSource, aDestination, aFlags, aProgress) ((p)->lpVtbl->DirectoryCopyToGuest(p, aSource, aDestination, aFlags, aProgress))
#define IGuestSession_DirectoryCreate(p, aPath, aMode, aFlags) ((p)->lpVtbl->DirectoryCreate(p, aPath, aMode, aFlags))
#define IGuestSession_DirectoryCreateTemp(p, aTemplateName, aMode, aPath, aSecure, aDirectory) ((p)->lpVtbl->DirectoryCreateTemp(p, aTemplateName, aMode, aPath, aSecure, aDirectory))
#define IGuestSession_DirectoryExists(p, aPath, aFollowSymlinks, aExists) ((p)->lpVtbl->DirectoryExists(p, aPath, aFollowSymlinks, aExists))
#define IGuestSession_DirectoryOpen(p, aPath, aFilter, aFlags, aDirectory) ((p)->lpVtbl->DirectoryOpen(p, aPath, aFilter, aFlags, aDirectory))
#define IGuestSession_DirectoryRemove(p, aPath) ((p)->lpVtbl->DirectoryRemove(p, aPath))
#define IGuestSession_DirectoryRemoveRecursive(p, aPath, aFlags, aProgress) ((p)->lpVtbl->DirectoryRemoveRecursive(p, aPath, aFlags, aProgress))
#define IGuestSession_EnvironmentScheduleSet(p, aName, aValue) ((p)->lpVtbl->EnvironmentScheduleSet(p, aName, aValue))
#define IGuestSession_EnvironmentScheduleUnset(p, aName) ((p)->lpVtbl->EnvironmentScheduleUnset(p, aName))
#define IGuestSession_EnvironmentGetBaseVariable(p, aName, aValue) ((p)->lpVtbl->EnvironmentGetBaseVariable(p, aName, aValue))
#define IGuestSession_EnvironmentDoesBaseVariableExist(p, aName, aExists) ((p)->lpVtbl->EnvironmentDoesBaseVariableExist(p, aName, aExists))
#define IGuestSession_FileCopy(p, aSource, aDestination, aFlags, aProgress) ((p)->lpVtbl->FileCopy(p, aSource, aDestination, aFlags, aProgress))
#define IGuestSession_FileCopyFromGuest(p, aSource, aDestination, aFlags, aProgress) ((p)->lpVtbl->FileCopyFromGuest(p, aSource, aDestination, aFlags, aProgress))
#define IGuestSession_FileCopyToGuest(p, aSource, aDestination, aFlags, aProgress) ((p)->lpVtbl->FileCopyToGuest(p, aSource, aDestination, aFlags, aProgress))
#define IGuestSession_FileCreateTemp(p, aTemplateName, aMode, aPath, aSecure, aFile) ((p)->lpVtbl->FileCreateTemp(p, aTemplateName, aMode, aPath, aSecure, aFile))
#define IGuestSession_FileExists(p, aPath, aFollowSymlinks, aExists) ((p)->lpVtbl->FileExists(p, aPath, aFollowSymlinks, aExists))
#define IGuestSession_FileOpen(p, aPath, aAccessMode, aOpenAction, aCreationMode, aFile) ((p)->lpVtbl->FileOpen(p, aPath, aAccessMode, aOpenAction, aCreationMode, aFile))
#define IGuestSession_FileOpenEx(p, aPath, aAccessMode, aOpenAction, aSharingMode, aCreationMode, aFlags, aFile) ((p)->lpVtbl->FileOpenEx(p, aPath, aAccessMode, aOpenAction, aSharingMode, aCreationMode, aFlags, aFile))
#define IGuestSession_FileQuerySize(p, aPath, aFollowSymlinks, aSize) ((p)->lpVtbl->FileQuerySize(p, aPath, aFollowSymlinks, aSize))
#define IGuestSession_FsObjExists(p, aPath, aFollowSymlinks, aExists) ((p)->lpVtbl->FsObjExists(p, aPath, aFollowSymlinks, aExists))
#define IGuestSession_FsObjQueryInfo(p, aPath, aFollowSymlinks, aInfo) ((p)->lpVtbl->FsObjQueryInfo(p, aPath, aFollowSymlinks, aInfo))
#define IGuestSession_FsObjRemove(p, aPath) ((p)->lpVtbl->FsObjRemove(p, aPath))
#define IGuestSession_FsObjRemoveArray(p, aPath, aProgress) ((p)->lpVtbl->FsObjRemoveArray(p, aPath, aProgress))
#define IGuestSession_FsObjRename(p, aOldPath, aNewPath, aFlags) ((p)->lpVtbl->FsObjRename(p, aOldPath, aNewPath, aFlags))
#define IGuestSession_FsObjMove(p, aSource, aDestination, aFlags, aProgress) ((p)->lpVtbl->FsObjMove(p, aSource, aDestination, aFlags, aProgress))
#define IGuestSession_FsObjMoveArray(p, aSource, aDestination, aFlags, aProgress) ((p)->lpVtbl->FsObjMoveArray(p, aSource, aDestination, aFlags, aProgress))
#define IGuestSession_FsObjCopyArray(p, aSource, aDestination, aFlags, aProgress) ((p)->lpVtbl->FsObjCopyArray(p, aSource, aDestination, aFlags, aProgress))
#define IGuestSession_FsObjSetACL(p, aPath, aFollowSymlinks, aAcl, aMode) ((p)->lpVtbl->FsObjSetACL(p, aPath, aFollowSymlinks, aAcl, aMode))
#define IGuestSession_FsQueryFreeSpace(p, aPath, aFreeSpace) ((p)->lpVtbl->FsQueryFreeSpace(p, aPath, aFreeSpace))
#define IGuestSession_FsQueryInfo(p, aPath, aInfo) ((p)->lpVtbl->FsQueryInfo(p, aPath, aInfo))
#define IGuestSession_ProcessCreate(p, aExecutable, aArguments, aCwd, aEnvironmentChanges, aFlags, aTimeoutMS, aGuestProcess) ((p)->lpVtbl->ProcessCreate(p, aExecutable, aArguments, aCwd, aEnvironmentChanges, aFlags, aTimeoutMS, aGuestProcess))
#define IGuestSession_ProcessCreateEx(p, aExecutable, aArguments, aCwd, aEnvironmentChanges, aFlags, aTimeoutMS, aPriority, aAffinity, aGuestProcess) ((p)->lpVtbl->ProcessCreateEx(p, aExecutable, aArguments, aCwd, aEnvironmentChanges, aFlags, aTimeoutMS, aPriority, aAffinity, aGuestProcess))
#define IGuestSession_ProcessGet(p, aPid, aGuestProcess) ((p)->lpVtbl->ProcessGet(p, aPid, aGuestProcess))
#define IGuestSession_SymlinkCreate(p, aSymlink, aTarget, aType) ((p)->lpVtbl->SymlinkCreate(p, aSymlink, aTarget, aType))
#define IGuestSession_SymlinkExists(p, aSymlink, aExists) ((p)->lpVtbl->SymlinkExists(p, aSymlink, aExists))
#define IGuestSession_SymlinkRead(p, aSymlink, aFlags, aTarget) ((p)->lpVtbl->SymlinkRead(p, aSymlink, aFlags, aTarget))
#define IGuestSession_WaitFor(p, aWaitFor, aTimeoutMS, aReason) ((p)->lpVtbl->WaitFor(p, aWaitFor, aTimeoutMS, aReason))
#define IGuestSession_WaitForArray(p, aWaitFor, aTimeoutMS, aReason) ((p)->lpVtbl->WaitForArray(p, aWaitFor, aTimeoutMS, aReason))
#endif /* VBOX_WITH_GLUE */

interface IGuestSession
{
#ifndef VBOX_WITH_GLUE
    struct IGuestSession_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestSessionVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestSession declaration */


/* Start of struct IProcess declaration */
#define IPROCESS_IID_STR "bc68370c-8a02-45f3-a07d-a67aa72756aa"
#define IPROCESS_IID { \
    0xbc68370c, 0x8a02, 0x45f3, \
    { 0xa0, 0x7d, 0xa6, 0x7a, 0xa7, 0x27, 0x56, 0xaa } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IProcess);
#ifndef VBOX_WITH_GLUE
struct IProcess_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetArguments)(IProcess *pThis, PRUint32 *argumentsSize, PRUnichar * **arguments);

    nsresult (*GetEnvironment)(IProcess *pThis, PRUint32 *environmentSize, PRUnichar * **environment);

    nsresult (*GetEventSource)(IProcess *pThis, IEventSource * *eventSource);

    nsresult (*GetExecutablePath)(IProcess *pThis, PRUnichar * *executablePath);

    nsresult (*GetExitCode)(IProcess *pThis, PRInt32 *exitCode);

    nsresult (*GetName)(IProcess *pThis, PRUnichar * *name);

    nsresult (*GetPID)(IProcess *pThis, PRUint32 *PID);

    nsresult (*GetStatus)(IProcess *pThis, PRUint32 *status);

    nsresult (*GetInternalAndReservedAttribute1IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*WaitFor)(
        IProcess *pThis,
        PRUint32 waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*WaitForArray)(
        IProcess *pThis,
        PRUint32 waitForSize,
        PRUint32* waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*Read)(
        IProcess *pThis,
        PRUint32 handle,
        PRUint32 toRead,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*Write)(
        IProcess *pThis,
        PRUint32 handle,
        PRUint32 flags,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*WriteArray)(
        IProcess *pThis,
        PRUint32 handle,
        PRUint32 flagsSize,
        PRUint32* flags,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*Terminate)(IProcess *pThis );

    nsresult (*InternalAndReservedMethod1IProcess)(IProcess *pThis);

    nsresult (*InternalAndReservedMethod2IProcess)(IProcess *pThis);

    nsresult (*InternalAndReservedMethod3IProcess)(IProcess *pThis);

    nsresult (*InternalAndReservedMethod4IProcess)(IProcess *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IProcessVtbl
{
    nsresult (*QueryInterface)(IProcess *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IProcess *pThis);
    nsrefcnt (*Release)(IProcess *pThis);
    nsresult (*GetArguments)(IProcess *pThis, PRUint32 *argumentsSize, PRUnichar * **arguments);

    nsresult (*GetEnvironment)(IProcess *pThis, PRUint32 *environmentSize, PRUnichar * **environment);

    nsresult (*GetEventSource)(IProcess *pThis, IEventSource * *eventSource);

    nsresult (*GetExecutablePath)(IProcess *pThis, PRUnichar * *executablePath);

    nsresult (*GetExitCode)(IProcess *pThis, PRInt32 *exitCode);

    nsresult (*GetName)(IProcess *pThis, PRUnichar * *name);

    nsresult (*GetPID)(IProcess *pThis, PRUint32 *PID);

    nsresult (*GetStatus)(IProcess *pThis, PRUint32 *status);

    nsresult (*GetInternalAndReservedAttribute1IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IProcess)(IProcess *pThis, PRUint32 *reserved);

    nsresult (*WaitFor)(
        IProcess *pThis,
        PRUint32 waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*WaitForArray)(
        IProcess *pThis,
        PRUint32 waitForSize,
        PRUint32* waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*Read)(
        IProcess *pThis,
        PRUint32 handle,
        PRUint32 toRead,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*Write)(
        IProcess *pThis,
        PRUint32 handle,
        PRUint32 flags,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*WriteArray)(
        IProcess *pThis,
        PRUint32 handle,
        PRUint32 flagsSize,
        PRUint32* flags,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*Terminate)(IProcess *pThis );

    nsresult (*InternalAndReservedMethod1IProcess)(IProcess *pThis);

    nsresult (*InternalAndReservedMethod2IProcess)(IProcess *pThis);

    nsresult (*InternalAndReservedMethod3IProcess)(IProcess *pThis);

    nsresult (*InternalAndReservedMethod4IProcess)(IProcess *pThis);

};
#define IProcess_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IProcess_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IProcess_Release(p) ((p)->lpVtbl->Release(p))
#define IProcess_get_Arguments(p, aArguments) ((p)->lpVtbl->GetArguments(p, aArguments))
#define IProcess_GetArguments(p, aArguments) ((p)->lpVtbl->GetArguments(p, aArguments))
#define IProcess_get_Environment(p, aEnvironment) ((p)->lpVtbl->GetEnvironment(p, aEnvironment))
#define IProcess_GetEnvironment(p, aEnvironment) ((p)->lpVtbl->GetEnvironment(p, aEnvironment))
#define IProcess_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IProcess_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IProcess_get_ExecutablePath(p, aExecutablePath) ((p)->lpVtbl->GetExecutablePath(p, aExecutablePath))
#define IProcess_GetExecutablePath(p, aExecutablePath) ((p)->lpVtbl->GetExecutablePath(p, aExecutablePath))
#define IProcess_get_ExitCode(p, aExitCode) ((p)->lpVtbl->GetExitCode(p, aExitCode))
#define IProcess_GetExitCode(p, aExitCode) ((p)->lpVtbl->GetExitCode(p, aExitCode))
#define IProcess_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IProcess_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IProcess_get_PID(p, aPID) ((p)->lpVtbl->GetPID(p, aPID))
#define IProcess_GetPID(p, aPID) ((p)->lpVtbl->GetPID(p, aPID))
#define IProcess_get_Status(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IProcess_GetStatus(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IProcess_WaitFor(p, aWaitFor, aTimeoutMS, aReason) ((p)->lpVtbl->WaitFor(p, aWaitFor, aTimeoutMS, aReason))
#define IProcess_WaitForArray(p, aWaitFor, aTimeoutMS, aReason) ((p)->lpVtbl->WaitForArray(p, aWaitFor, aTimeoutMS, aReason))
#define IProcess_Read(p, aHandle, aToRead, aTimeoutMS, aData) ((p)->lpVtbl->Read(p, aHandle, aToRead, aTimeoutMS, aData))
#define IProcess_Write(p, aHandle, aFlags, aData, aTimeoutMS, aWritten) ((p)->lpVtbl->Write(p, aHandle, aFlags, aData, aTimeoutMS, aWritten))
#define IProcess_WriteArray(p, aHandle, aFlags, aData, aTimeoutMS, aWritten) ((p)->lpVtbl->WriteArray(p, aHandle, aFlags, aData, aTimeoutMS, aWritten))
#define IProcess_Terminate(p) ((p)->lpVtbl->Terminate(p))
#endif /* VBOX_WITH_GLUE */

interface IProcess
{
#ifndef VBOX_WITH_GLUE
    struct IProcess_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IProcessVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IProcess declaration */


/* Start of struct IGuestProcess declaration */
#define IGUESTPROCESS_IID_STR "35cf4b3f-4453-4f3e-c9b8-5686939c80b6"
#define IGUESTPROCESS_IID { \
    0x35cf4b3f, 0x4453, 0x4f3e, \
    { 0xc9, 0xb8, 0x56, 0x86, 0x93, 0x9c, 0x80, 0xb6 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestProcess);
#ifndef VBOX_WITH_GLUE
struct IGuestProcess_vtbl
{
    struct IProcess_vtbl iprocess;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestProcess *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#else /* VBOX_WITH_GLUE */
struct IGuestProcessVtbl
{
    nsresult (*QueryInterface)(IGuestProcess *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestProcess *pThis);
    nsrefcnt (*Release)(IGuestProcess *pThis);
    nsresult (*GetArguments)(IGuestProcess *pThis, PRUint32 *argumentsSize, PRUnichar * **arguments);

    nsresult (*GetEnvironment)(IGuestProcess *pThis, PRUint32 *environmentSize, PRUnichar * **environment);

    nsresult (*GetEventSource)(IGuestProcess *pThis, IEventSource * *eventSource);

    nsresult (*GetExecutablePath)(IGuestProcess *pThis, PRUnichar * *executablePath);

    nsresult (*GetExitCode)(IGuestProcess *pThis, PRInt32 *exitCode);

    nsresult (*GetName)(IGuestProcess *pThis, PRUnichar * *name);

    nsresult (*GetPID)(IGuestProcess *pThis, PRUint32 *PID);

    nsresult (*GetStatus)(IGuestProcess *pThis, PRUint32 *status);

    nsresult (*GetInternalAndReservedAttribute1IProcess)(IGuestProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IProcess)(IGuestProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IProcess)(IGuestProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IProcess)(IGuestProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IProcess)(IGuestProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IProcess)(IGuestProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IProcess)(IGuestProcess *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IProcess)(IGuestProcess *pThis, PRUint32 *reserved);

    nsresult (*WaitFor)(
        IGuestProcess *pThis,
        PRUint32 waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*WaitForArray)(
        IGuestProcess *pThis,
        PRUint32 waitForSize,
        PRUint32* waitFor,
        PRUint32 timeoutMS,
        PRUint32 * reason
    );

    nsresult (*Read)(
        IGuestProcess *pThis,
        PRUint32 handle,
        PRUint32 toRead,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*Write)(
        IGuestProcess *pThis,
        PRUint32 handle,
        PRUint32 flags,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*WriteArray)(
        IGuestProcess *pThis,
        PRUint32 handle,
        PRUint32 flagsSize,
        PRUint32* flags,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*Terminate)(IGuestProcess *pThis );

    nsresult (*InternalAndReservedMethod1IProcess)(IGuestProcess *pThis);

    nsresult (*InternalAndReservedMethod2IProcess)(IGuestProcess *pThis);

    nsresult (*InternalAndReservedMethod3IProcess)(IGuestProcess *pThis);

    nsresult (*InternalAndReservedMethod4IProcess)(IGuestProcess *pThis);

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestProcess *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#define IGuestProcess_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestProcess_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestProcess_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestProcess_get_Arguments(p, aArguments) ((p)->lpVtbl->GetArguments(p, aArguments))
#define IGuestProcess_GetArguments(p, aArguments) ((p)->lpVtbl->GetArguments(p, aArguments))
#define IGuestProcess_get_Environment(p, aEnvironment) ((p)->lpVtbl->GetEnvironment(p, aEnvironment))
#define IGuestProcess_GetEnvironment(p, aEnvironment) ((p)->lpVtbl->GetEnvironment(p, aEnvironment))
#define IGuestProcess_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuestProcess_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuestProcess_get_ExecutablePath(p, aExecutablePath) ((p)->lpVtbl->GetExecutablePath(p, aExecutablePath))
#define IGuestProcess_GetExecutablePath(p, aExecutablePath) ((p)->lpVtbl->GetExecutablePath(p, aExecutablePath))
#define IGuestProcess_get_ExitCode(p, aExitCode) ((p)->lpVtbl->GetExitCode(p, aExitCode))
#define IGuestProcess_GetExitCode(p, aExitCode) ((p)->lpVtbl->GetExitCode(p, aExitCode))
#define IGuestProcess_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IGuestProcess_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IGuestProcess_get_PID(p, aPID) ((p)->lpVtbl->GetPID(p, aPID))
#define IGuestProcess_GetPID(p, aPID) ((p)->lpVtbl->GetPID(p, aPID))
#define IGuestProcess_get_Status(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IGuestProcess_GetStatus(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IGuestProcess_WaitFor(p, aWaitFor, aTimeoutMS, aReason) ((p)->lpVtbl->WaitFor(p, aWaitFor, aTimeoutMS, aReason))
#define IGuestProcess_WaitForArray(p, aWaitFor, aTimeoutMS, aReason) ((p)->lpVtbl->WaitForArray(p, aWaitFor, aTimeoutMS, aReason))
#define IGuestProcess_Read(p, aHandle, aToRead, aTimeoutMS, aData) ((p)->lpVtbl->Read(p, aHandle, aToRead, aTimeoutMS, aData))
#define IGuestProcess_Write(p, aHandle, aFlags, aData, aTimeoutMS, aWritten) ((p)->lpVtbl->Write(p, aHandle, aFlags, aData, aTimeoutMS, aWritten))
#define IGuestProcess_WriteArray(p, aHandle, aFlags, aData, aTimeoutMS, aWritten) ((p)->lpVtbl->WriteArray(p, aHandle, aFlags, aData, aTimeoutMS, aWritten))
#define IGuestProcess_Terminate(p) ((p)->lpVtbl->Terminate(p))
#define IGuestProcess_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IGuestProcess_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IGuestProcess
{
#ifndef VBOX_WITH_GLUE
    struct IGuestProcess_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestProcessVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestProcess declaration */


/* Start of struct IDirectory declaration */
#define IDIRECTORY_IID_STR "a508e094-bf24-4eca-80c6-467766a1e4c0"
#define IDIRECTORY_IID { \
    0xa508e094, 0xbf24, 0x4eca, \
    { 0x80, 0xc6, 0x46, 0x77, 0x66, 0xa1, 0xe4, 0xc0 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDirectory);
#ifndef VBOX_WITH_GLUE
struct IDirectory_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetDirectoryName)(IDirectory *pThis, PRUnichar * *directoryName);

    nsresult (*GetEventSource)(IDirectory *pThis, IEventSource * *eventSource);

    nsresult (*GetFilter)(IDirectory *pThis, PRUnichar * *filter);

    nsresult (*GetId)(IDirectory *pThis, PRUint32 *id);

    nsresult (*GetStatus)(IDirectory *pThis, PRUint32 *status);

    nsresult (*GetInternalAndReservedAttribute1IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*Close)(IDirectory *pThis );

    nsresult (*List)(
        IDirectory *pThis,
        PRUint32 maxEntries,
        PRUint32 *objInfoSize,
        IFsObjInfo *** objInfo
    );

    nsresult (*Read)(
        IDirectory *pThis,
        IFsObjInfo * * objInfo
    );

    nsresult (*Rewind)(IDirectory *pThis );

    nsresult (*InternalAndReservedMethod1IDirectory)(IDirectory *pThis);

    nsresult (*InternalAndReservedMethod2IDirectory)(IDirectory *pThis);

    nsresult (*InternalAndReservedMethod3IDirectory)(IDirectory *pThis);

    nsresult (*InternalAndReservedMethod4IDirectory)(IDirectory *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDirectoryVtbl
{
    nsresult (*QueryInterface)(IDirectory *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDirectory *pThis);
    nsrefcnt (*Release)(IDirectory *pThis);
    nsresult (*GetDirectoryName)(IDirectory *pThis, PRUnichar * *directoryName);

    nsresult (*GetEventSource)(IDirectory *pThis, IEventSource * *eventSource);

    nsresult (*GetFilter)(IDirectory *pThis, PRUnichar * *filter);

    nsresult (*GetId)(IDirectory *pThis, PRUint32 *id);

    nsresult (*GetStatus)(IDirectory *pThis, PRUint32 *status);

    nsresult (*GetInternalAndReservedAttribute1IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDirectory)(IDirectory *pThis, PRUint32 *reserved);

    nsresult (*Close)(IDirectory *pThis );

    nsresult (*List)(
        IDirectory *pThis,
        PRUint32 maxEntries,
        PRUint32 *objInfoSize,
        IFsObjInfo *** objInfo
    );

    nsresult (*Read)(
        IDirectory *pThis,
        IFsObjInfo * * objInfo
    );

    nsresult (*Rewind)(IDirectory *pThis );

    nsresult (*InternalAndReservedMethod1IDirectory)(IDirectory *pThis);

    nsresult (*InternalAndReservedMethod2IDirectory)(IDirectory *pThis);

    nsresult (*InternalAndReservedMethod3IDirectory)(IDirectory *pThis);

    nsresult (*InternalAndReservedMethod4IDirectory)(IDirectory *pThis);

};
#define IDirectory_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDirectory_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDirectory_Release(p) ((p)->lpVtbl->Release(p))
#define IDirectory_get_DirectoryName(p, aDirectoryName) ((p)->lpVtbl->GetDirectoryName(p, aDirectoryName))
#define IDirectory_GetDirectoryName(p, aDirectoryName) ((p)->lpVtbl->GetDirectoryName(p, aDirectoryName))
#define IDirectory_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IDirectory_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IDirectory_get_Filter(p, aFilter) ((p)->lpVtbl->GetFilter(p, aFilter))
#define IDirectory_GetFilter(p, aFilter) ((p)->lpVtbl->GetFilter(p, aFilter))
#define IDirectory_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IDirectory_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IDirectory_get_Status(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IDirectory_GetStatus(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IDirectory_Close(p) ((p)->lpVtbl->Close(p))
#define IDirectory_List(p, aMaxEntries, aObjInfo) ((p)->lpVtbl->List(p, aMaxEntries, aObjInfo))
#define IDirectory_Read(p, aObjInfo) ((p)->lpVtbl->Read(p, aObjInfo))
#define IDirectory_Rewind(p) ((p)->lpVtbl->Rewind(p))
#endif /* VBOX_WITH_GLUE */

interface IDirectory
{
#ifndef VBOX_WITH_GLUE
    struct IDirectory_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDirectoryVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDirectory declaration */


/* Start of struct IGuestDirectory declaration */
#define IGUESTDIRECTORY_IID_STR "cc830458-4974-a19c-4dc6-cc98c2269626"
#define IGUESTDIRECTORY_IID { \
    0xcc830458, 0x4974, 0xa19c, \
    { 0x4d, 0xc6, 0xcc, 0x98, 0xc2, 0x26, 0x96, 0x26 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestDirectory);
#ifndef VBOX_WITH_GLUE
struct IGuestDirectory_vtbl
{
    struct IDirectory_vtbl idirectory;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestDirectory *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#else /* VBOX_WITH_GLUE */
struct IGuestDirectoryVtbl
{
    nsresult (*QueryInterface)(IGuestDirectory *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestDirectory *pThis);
    nsrefcnt (*Release)(IGuestDirectory *pThis);
    nsresult (*GetDirectoryName)(IGuestDirectory *pThis, PRUnichar * *directoryName);

    nsresult (*GetEventSource)(IGuestDirectory *pThis, IEventSource * *eventSource);

    nsresult (*GetFilter)(IGuestDirectory *pThis, PRUnichar * *filter);

    nsresult (*GetId)(IGuestDirectory *pThis, PRUint32 *id);

    nsresult (*GetStatus)(IGuestDirectory *pThis, PRUint32 *status);

    nsresult (*GetInternalAndReservedAttribute1IDirectory)(IGuestDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDirectory)(IGuestDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDirectory)(IGuestDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDirectory)(IGuestDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDirectory)(IGuestDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDirectory)(IGuestDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDirectory)(IGuestDirectory *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDirectory)(IGuestDirectory *pThis, PRUint32 *reserved);

    nsresult (*Close)(IGuestDirectory *pThis );

    nsresult (*List)(
        IGuestDirectory *pThis,
        PRUint32 maxEntries,
        PRUint32 *objInfoSize,
        IFsObjInfo *** objInfo
    );

    nsresult (*Read)(
        IGuestDirectory *pThis,
        IFsObjInfo * * objInfo
    );

    nsresult (*Rewind)(IGuestDirectory *pThis );

    nsresult (*InternalAndReservedMethod1IDirectory)(IGuestDirectory *pThis);

    nsresult (*InternalAndReservedMethod2IDirectory)(IGuestDirectory *pThis);

    nsresult (*InternalAndReservedMethod3IDirectory)(IGuestDirectory *pThis);

    nsresult (*InternalAndReservedMethod4IDirectory)(IGuestDirectory *pThis);

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestDirectory *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#define IGuestDirectory_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestDirectory_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestDirectory_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestDirectory_get_DirectoryName(p, aDirectoryName) ((p)->lpVtbl->GetDirectoryName(p, aDirectoryName))
#define IGuestDirectory_GetDirectoryName(p, aDirectoryName) ((p)->lpVtbl->GetDirectoryName(p, aDirectoryName))
#define IGuestDirectory_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuestDirectory_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuestDirectory_get_Filter(p, aFilter) ((p)->lpVtbl->GetFilter(p, aFilter))
#define IGuestDirectory_GetFilter(p, aFilter) ((p)->lpVtbl->GetFilter(p, aFilter))
#define IGuestDirectory_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IGuestDirectory_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IGuestDirectory_get_Status(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IGuestDirectory_GetStatus(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IGuestDirectory_Close(p) ((p)->lpVtbl->Close(p))
#define IGuestDirectory_List(p, aMaxEntries, aObjInfo) ((p)->lpVtbl->List(p, aMaxEntries, aObjInfo))
#define IGuestDirectory_Read(p, aObjInfo) ((p)->lpVtbl->Read(p, aObjInfo))
#define IGuestDirectory_Rewind(p) ((p)->lpVtbl->Rewind(p))
#define IGuestDirectory_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IGuestDirectory_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IGuestDirectory
{
#ifndef VBOX_WITH_GLUE
    struct IGuestDirectory_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestDirectoryVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestDirectory declaration */


/* Start of struct IFile declaration */
#define IFILE_IID_STR "59a235ac-2f1a-4d6c-81fc-e3fa843f49ae"
#define IFILE_IID { \
    0x59a235ac, 0x2f1a, 0x4d6c, \
    { 0x81, 0xfc, 0xe3, 0xfa, 0x84, 0x3f, 0x49, 0xae } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IFile);
#ifndef VBOX_WITH_GLUE
struct IFile_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetEventSource)(IFile *pThis, IEventSource * *eventSource);

    nsresult (*GetId)(IFile *pThis, PRUint32 *id);

    nsresult (*GetInitialSize)(IFile *pThis, PRInt64 *initialSize);

    nsresult (*GetOffset)(IFile *pThis, PRInt64 *offset);

    nsresult (*GetStatus)(IFile *pThis, PRUint32 *status);

    nsresult (*GetFilename)(IFile *pThis, PRUnichar * *filename);

    nsresult (*GetCreationMode)(IFile *pThis, PRUint32 *creationMode);

    nsresult (*GetOpenAction)(IFile *pThis, PRUint32 *openAction);

    nsresult (*GetAccessMode)(IFile *pThis, PRUint32 *accessMode);

    nsresult (*GetInternalAndReservedAttribute1IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*Close)(IFile *pThis );

    nsresult (*QueryInfo)(
        IFile *pThis,
        IFsObjInfo * * objInfo
    );

    nsresult (*QuerySize)(
        IFile *pThis,
        PRInt64 * size
    );

    nsresult (*Read)(
        IFile *pThis,
        PRUint32 toRead,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*ReadAt)(
        IFile *pThis,
        PRInt64 offset,
        PRUint32 toRead,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*Seek)(
        IFile *pThis,
        PRInt64 offset,
        PRUint32 whence,
        PRInt64 * newOffset
    );

    nsresult (*SetACL)(
        IFile *pThis,
        PRUnichar * acl,
        PRUint32 mode
    );

    nsresult (*SetSize)(
        IFile *pThis,
        PRInt64 size
    );

    nsresult (*Write)(
        IFile *pThis,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*WriteAt)(
        IFile *pThis,
        PRInt64 offset,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*InternalAndReservedMethod1IFile)(IFile *pThis);

    nsresult (*InternalAndReservedMethod2IFile)(IFile *pThis);

    nsresult (*InternalAndReservedMethod3IFile)(IFile *pThis);

    nsresult (*InternalAndReservedMethod4IFile)(IFile *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IFileVtbl
{
    nsresult (*QueryInterface)(IFile *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IFile *pThis);
    nsrefcnt (*Release)(IFile *pThis);
    nsresult (*GetEventSource)(IFile *pThis, IEventSource * *eventSource);

    nsresult (*GetId)(IFile *pThis, PRUint32 *id);

    nsresult (*GetInitialSize)(IFile *pThis, PRInt64 *initialSize);

    nsresult (*GetOffset)(IFile *pThis, PRInt64 *offset);

    nsresult (*GetStatus)(IFile *pThis, PRUint32 *status);

    nsresult (*GetFilename)(IFile *pThis, PRUnichar * *filename);

    nsresult (*GetCreationMode)(IFile *pThis, PRUint32 *creationMode);

    nsresult (*GetOpenAction)(IFile *pThis, PRUint32 *openAction);

    nsresult (*GetAccessMode)(IFile *pThis, PRUint32 *accessMode);

    nsresult (*GetInternalAndReservedAttribute1IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFile)(IFile *pThis, PRUint32 *reserved);

    nsresult (*Close)(IFile *pThis );

    nsresult (*QueryInfo)(
        IFile *pThis,
        IFsObjInfo * * objInfo
    );

    nsresult (*QuerySize)(
        IFile *pThis,
        PRInt64 * size
    );

    nsresult (*Read)(
        IFile *pThis,
        PRUint32 toRead,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*ReadAt)(
        IFile *pThis,
        PRInt64 offset,
        PRUint32 toRead,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*Seek)(
        IFile *pThis,
        PRInt64 offset,
        PRUint32 whence,
        PRInt64 * newOffset
    );

    nsresult (*SetACL)(
        IFile *pThis,
        PRUnichar * acl,
        PRUint32 mode
    );

    nsresult (*SetSize)(
        IFile *pThis,
        PRInt64 size
    );

    nsresult (*Write)(
        IFile *pThis,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*WriteAt)(
        IFile *pThis,
        PRInt64 offset,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*InternalAndReservedMethod1IFile)(IFile *pThis);

    nsresult (*InternalAndReservedMethod2IFile)(IFile *pThis);

    nsresult (*InternalAndReservedMethod3IFile)(IFile *pThis);

    nsresult (*InternalAndReservedMethod4IFile)(IFile *pThis);

};
#define IFile_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IFile_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IFile_Release(p) ((p)->lpVtbl->Release(p))
#define IFile_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IFile_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IFile_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IFile_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IFile_get_InitialSize(p, aInitialSize) ((p)->lpVtbl->GetInitialSize(p, aInitialSize))
#define IFile_GetInitialSize(p, aInitialSize) ((p)->lpVtbl->GetInitialSize(p, aInitialSize))
#define IFile_get_Offset(p, aOffset) ((p)->lpVtbl->GetOffset(p, aOffset))
#define IFile_GetOffset(p, aOffset) ((p)->lpVtbl->GetOffset(p, aOffset))
#define IFile_get_Status(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IFile_GetStatus(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IFile_get_Filename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IFile_GetFilename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IFile_get_CreationMode(p, aCreationMode) ((p)->lpVtbl->GetCreationMode(p, aCreationMode))
#define IFile_GetCreationMode(p, aCreationMode) ((p)->lpVtbl->GetCreationMode(p, aCreationMode))
#define IFile_get_OpenAction(p, aOpenAction) ((p)->lpVtbl->GetOpenAction(p, aOpenAction))
#define IFile_GetOpenAction(p, aOpenAction) ((p)->lpVtbl->GetOpenAction(p, aOpenAction))
#define IFile_get_AccessMode(p, aAccessMode) ((p)->lpVtbl->GetAccessMode(p, aAccessMode))
#define IFile_GetAccessMode(p, aAccessMode) ((p)->lpVtbl->GetAccessMode(p, aAccessMode))
#define IFile_Close(p) ((p)->lpVtbl->Close(p))
#define IFile_QueryInfo(p, aObjInfo) ((p)->lpVtbl->QueryInfo(p, aObjInfo))
#define IFile_QuerySize(p, aSize) ((p)->lpVtbl->QuerySize(p, aSize))
#define IFile_Read(p, aToRead, aTimeoutMS, aData) ((p)->lpVtbl->Read(p, aToRead, aTimeoutMS, aData))
#define IFile_ReadAt(p, aOffset, aToRead, aTimeoutMS, aData) ((p)->lpVtbl->ReadAt(p, aOffset, aToRead, aTimeoutMS, aData))
#define IFile_Seek(p, aOffset, aWhence, aNewOffset) ((p)->lpVtbl->Seek(p, aOffset, aWhence, aNewOffset))
#define IFile_SetACL(p, aAcl, aMode) ((p)->lpVtbl->SetACL(p, aAcl, aMode))
#define IFile_SetSize(p, aSize) ((p)->lpVtbl->SetSize(p, aSize))
#define IFile_Write(p, aData, aTimeoutMS, aWritten) ((p)->lpVtbl->Write(p, aData, aTimeoutMS, aWritten))
#define IFile_WriteAt(p, aOffset, aData, aTimeoutMS, aWritten) ((p)->lpVtbl->WriteAt(p, aOffset, aData, aTimeoutMS, aWritten))
#endif /* VBOX_WITH_GLUE */

interface IFile
{
#ifndef VBOX_WITH_GLUE
    struct IFile_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IFileVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IFile declaration */


/* Start of struct IGuestFile declaration */
#define IGUESTFILE_IID_STR "92f21dc0-44de-1653-b717-2ebf0ca9b664"
#define IGUESTFILE_IID { \
    0x92f21dc0, 0x44de, 0x1653, \
    { 0xb7, 0x17, 0x2e, 0xbf, 0x0c, 0xa9, 0xb6, 0x64 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestFile);
#ifndef VBOX_WITH_GLUE
struct IGuestFile_vtbl
{
    struct IFile_vtbl ifile;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestFile *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#else /* VBOX_WITH_GLUE */
struct IGuestFileVtbl
{
    nsresult (*QueryInterface)(IGuestFile *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestFile *pThis);
    nsrefcnt (*Release)(IGuestFile *pThis);
    nsresult (*GetEventSource)(IGuestFile *pThis, IEventSource * *eventSource);

    nsresult (*GetId)(IGuestFile *pThis, PRUint32 *id);

    nsresult (*GetInitialSize)(IGuestFile *pThis, PRInt64 *initialSize);

    nsresult (*GetOffset)(IGuestFile *pThis, PRInt64 *offset);

    nsresult (*GetStatus)(IGuestFile *pThis, PRUint32 *status);

    nsresult (*GetFilename)(IGuestFile *pThis, PRUnichar * *filename);

    nsresult (*GetCreationMode)(IGuestFile *pThis, PRUint32 *creationMode);

    nsresult (*GetOpenAction)(IGuestFile *pThis, PRUint32 *openAction);

    nsresult (*GetAccessMode)(IGuestFile *pThis, PRUint32 *accessMode);

    nsresult (*GetInternalAndReservedAttribute1IFile)(IGuestFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFile)(IGuestFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFile)(IGuestFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFile)(IGuestFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFile)(IGuestFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFile)(IGuestFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFile)(IGuestFile *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFile)(IGuestFile *pThis, PRUint32 *reserved);

    nsresult (*Close)(IGuestFile *pThis );

    nsresult (*QueryInfo)(
        IGuestFile *pThis,
        IFsObjInfo * * objInfo
    );

    nsresult (*QuerySize)(
        IGuestFile *pThis,
        PRInt64 * size
    );

    nsresult (*Read)(
        IGuestFile *pThis,
        PRUint32 toRead,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*ReadAt)(
        IGuestFile *pThis,
        PRInt64 offset,
        PRUint32 toRead,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*Seek)(
        IGuestFile *pThis,
        PRInt64 offset,
        PRUint32 whence,
        PRInt64 * newOffset
    );

    nsresult (*SetACL)(
        IGuestFile *pThis,
        PRUnichar * acl,
        PRUint32 mode
    );

    nsresult (*SetSize)(
        IGuestFile *pThis,
        PRInt64 size
    );

    nsresult (*Write)(
        IGuestFile *pThis,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*WriteAt)(
        IGuestFile *pThis,
        PRInt64 offset,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 timeoutMS,
        PRUint32 * written
    );

    nsresult (*InternalAndReservedMethod1IFile)(IGuestFile *pThis);

    nsresult (*InternalAndReservedMethod2IFile)(IGuestFile *pThis);

    nsresult (*InternalAndReservedMethod3IFile)(IGuestFile *pThis);

    nsresult (*InternalAndReservedMethod4IFile)(IGuestFile *pThis);

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestFile *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#define IGuestFile_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestFile_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestFile_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestFile_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuestFile_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuestFile_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IGuestFile_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IGuestFile_get_InitialSize(p, aInitialSize) ((p)->lpVtbl->GetInitialSize(p, aInitialSize))
#define IGuestFile_GetInitialSize(p, aInitialSize) ((p)->lpVtbl->GetInitialSize(p, aInitialSize))
#define IGuestFile_get_Offset(p, aOffset) ((p)->lpVtbl->GetOffset(p, aOffset))
#define IGuestFile_GetOffset(p, aOffset) ((p)->lpVtbl->GetOffset(p, aOffset))
#define IGuestFile_get_Status(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IGuestFile_GetStatus(p, aStatus) ((p)->lpVtbl->GetStatus(p, aStatus))
#define IGuestFile_get_Filename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IGuestFile_GetFilename(p, aFilename) ((p)->lpVtbl->GetFilename(p, aFilename))
#define IGuestFile_get_CreationMode(p, aCreationMode) ((p)->lpVtbl->GetCreationMode(p, aCreationMode))
#define IGuestFile_GetCreationMode(p, aCreationMode) ((p)->lpVtbl->GetCreationMode(p, aCreationMode))
#define IGuestFile_get_OpenAction(p, aOpenAction) ((p)->lpVtbl->GetOpenAction(p, aOpenAction))
#define IGuestFile_GetOpenAction(p, aOpenAction) ((p)->lpVtbl->GetOpenAction(p, aOpenAction))
#define IGuestFile_get_AccessMode(p, aAccessMode) ((p)->lpVtbl->GetAccessMode(p, aAccessMode))
#define IGuestFile_GetAccessMode(p, aAccessMode) ((p)->lpVtbl->GetAccessMode(p, aAccessMode))
#define IGuestFile_Close(p) ((p)->lpVtbl->Close(p))
#define IGuestFile_QueryInfo(p, aObjInfo) ((p)->lpVtbl->QueryInfo(p, aObjInfo))
#define IGuestFile_QuerySize(p, aSize) ((p)->lpVtbl->QuerySize(p, aSize))
#define IGuestFile_Read(p, aToRead, aTimeoutMS, aData) ((p)->lpVtbl->Read(p, aToRead, aTimeoutMS, aData))
#define IGuestFile_ReadAt(p, aOffset, aToRead, aTimeoutMS, aData) ((p)->lpVtbl->ReadAt(p, aOffset, aToRead, aTimeoutMS, aData))
#define IGuestFile_Seek(p, aOffset, aWhence, aNewOffset) ((p)->lpVtbl->Seek(p, aOffset, aWhence, aNewOffset))
#define IGuestFile_SetACL(p, aAcl, aMode) ((p)->lpVtbl->SetACL(p, aAcl, aMode))
#define IGuestFile_SetSize(p, aSize) ((p)->lpVtbl->SetSize(p, aSize))
#define IGuestFile_Write(p, aData, aTimeoutMS, aWritten) ((p)->lpVtbl->Write(p, aData, aTimeoutMS, aWritten))
#define IGuestFile_WriteAt(p, aOffset, aData, aTimeoutMS, aWritten) ((p)->lpVtbl->WriteAt(p, aOffset, aData, aTimeoutMS, aWritten))
#define IGuestFile_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IGuestFile_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IGuestFile
{
#ifndef VBOX_WITH_GLUE
    struct IGuestFile_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestFileVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestFile declaration */


/* Start of struct IFsInfo declaration */
#define IFSINFO_IID_STR "3db2ab1a-6cf7-42f1-8bf5-e1c0553e0b30"
#define IFSINFO_IID { \
    0x3db2ab1a, 0x6cf7, 0x42f1, \
    { 0x8b, 0xf5, 0xe1, 0xc0, 0x55, 0x3e, 0x0b, 0x30 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IFsInfo);
#ifndef VBOX_WITH_GLUE
struct IFsInfo_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetFreeSize)(IFsInfo *pThis, PRInt64 *freeSize);

    nsresult (*GetTotalSize)(IFsInfo *pThis, PRInt64 *totalSize);

    nsresult (*GetBlockSize)(IFsInfo *pThis, PRUint32 *blockSize);

    nsresult (*GetSectorSize)(IFsInfo *pThis, PRUint32 *sectorSize);

    nsresult (*GetSerialNumber)(IFsInfo *pThis, PRUint32 *serialNumber);

    nsresult (*GetIsRemote)(IFsInfo *pThis, PRBool *isRemote);

    nsresult (*GetIsCaseSensitive)(IFsInfo *pThis, PRBool *isCaseSensitive);

    nsresult (*GetIsReadOnly)(IFsInfo *pThis, PRBool *isReadOnly);

    nsresult (*GetIsCompressed)(IFsInfo *pThis, PRBool *isCompressed);

    nsresult (*GetSupportsFileCompression)(IFsInfo *pThis, PRBool *supportsFileCompression);

    nsresult (*GetMaxComponent)(IFsInfo *pThis, PRUint32 *maxComponent);

    nsresult (*GetType)(IFsInfo *pThis, PRUnichar * *type);

    nsresult (*GetLabel)(IFsInfo *pThis, PRUnichar * *label);

    nsresult (*GetMountPoint)(IFsInfo *pThis, PRUnichar * *mountPoint);

    nsresult (*GetInternalAndReservedAttribute1IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

};
#else /* VBOX_WITH_GLUE */
struct IFsInfoVtbl
{
    nsresult (*QueryInterface)(IFsInfo *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IFsInfo *pThis);
    nsrefcnt (*Release)(IFsInfo *pThis);
    nsresult (*GetFreeSize)(IFsInfo *pThis, PRInt64 *freeSize);

    nsresult (*GetTotalSize)(IFsInfo *pThis, PRInt64 *totalSize);

    nsresult (*GetBlockSize)(IFsInfo *pThis, PRUint32 *blockSize);

    nsresult (*GetSectorSize)(IFsInfo *pThis, PRUint32 *sectorSize);

    nsresult (*GetSerialNumber)(IFsInfo *pThis, PRUint32 *serialNumber);

    nsresult (*GetIsRemote)(IFsInfo *pThis, PRBool *isRemote);

    nsresult (*GetIsCaseSensitive)(IFsInfo *pThis, PRBool *isCaseSensitive);

    nsresult (*GetIsReadOnly)(IFsInfo *pThis, PRBool *isReadOnly);

    nsresult (*GetIsCompressed)(IFsInfo *pThis, PRBool *isCompressed);

    nsresult (*GetSupportsFileCompression)(IFsInfo *pThis, PRBool *supportsFileCompression);

    nsresult (*GetMaxComponent)(IFsInfo *pThis, PRUint32 *maxComponent);

    nsresult (*GetType)(IFsInfo *pThis, PRUnichar * *type);

    nsresult (*GetLabel)(IFsInfo *pThis, PRUnichar * *label);

    nsresult (*GetMountPoint)(IFsInfo *pThis, PRUnichar * *mountPoint);

    nsresult (*GetInternalAndReservedAttribute1IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFsInfo)(IFsInfo *pThis, PRUint32 *reserved);

};
#define IFsInfo_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IFsInfo_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IFsInfo_Release(p) ((p)->lpVtbl->Release(p))
#define IFsInfo_get_FreeSize(p, aFreeSize) ((p)->lpVtbl->GetFreeSize(p, aFreeSize))
#define IFsInfo_GetFreeSize(p, aFreeSize) ((p)->lpVtbl->GetFreeSize(p, aFreeSize))
#define IFsInfo_get_TotalSize(p, aTotalSize) ((p)->lpVtbl->GetTotalSize(p, aTotalSize))
#define IFsInfo_GetTotalSize(p, aTotalSize) ((p)->lpVtbl->GetTotalSize(p, aTotalSize))
#define IFsInfo_get_BlockSize(p, aBlockSize) ((p)->lpVtbl->GetBlockSize(p, aBlockSize))
#define IFsInfo_GetBlockSize(p, aBlockSize) ((p)->lpVtbl->GetBlockSize(p, aBlockSize))
#define IFsInfo_get_SectorSize(p, aSectorSize) ((p)->lpVtbl->GetSectorSize(p, aSectorSize))
#define IFsInfo_GetSectorSize(p, aSectorSize) ((p)->lpVtbl->GetSectorSize(p, aSectorSize))
#define IFsInfo_get_SerialNumber(p, aSerialNumber) ((p)->lpVtbl->GetSerialNumber(p, aSerialNumber))
#define IFsInfo_GetSerialNumber(p, aSerialNumber) ((p)->lpVtbl->GetSerialNumber(p, aSerialNumber))
#define IFsInfo_get_IsRemote(p, aIsRemote) ((p)->lpVtbl->GetIsRemote(p, aIsRemote))
#define IFsInfo_GetIsRemote(p, aIsRemote) ((p)->lpVtbl->GetIsRemote(p, aIsRemote))
#define IFsInfo_get_IsCaseSensitive(p, aIsCaseSensitive) ((p)->lpVtbl->GetIsCaseSensitive(p, aIsCaseSensitive))
#define IFsInfo_GetIsCaseSensitive(p, aIsCaseSensitive) ((p)->lpVtbl->GetIsCaseSensitive(p, aIsCaseSensitive))
#define IFsInfo_get_IsReadOnly(p, aIsReadOnly) ((p)->lpVtbl->GetIsReadOnly(p, aIsReadOnly))
#define IFsInfo_GetIsReadOnly(p, aIsReadOnly) ((p)->lpVtbl->GetIsReadOnly(p, aIsReadOnly))
#define IFsInfo_get_IsCompressed(p, aIsCompressed) ((p)->lpVtbl->GetIsCompressed(p, aIsCompressed))
#define IFsInfo_GetIsCompressed(p, aIsCompressed) ((p)->lpVtbl->GetIsCompressed(p, aIsCompressed))
#define IFsInfo_get_SupportsFileCompression(p, aSupportsFileCompression) ((p)->lpVtbl->GetSupportsFileCompression(p, aSupportsFileCompression))
#define IFsInfo_GetSupportsFileCompression(p, aSupportsFileCompression) ((p)->lpVtbl->GetSupportsFileCompression(p, aSupportsFileCompression))
#define IFsInfo_get_MaxComponent(p, aMaxComponent) ((p)->lpVtbl->GetMaxComponent(p, aMaxComponent))
#define IFsInfo_GetMaxComponent(p, aMaxComponent) ((p)->lpVtbl->GetMaxComponent(p, aMaxComponent))
#define IFsInfo_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IFsInfo_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IFsInfo_get_Label(p, aLabel) ((p)->lpVtbl->GetLabel(p, aLabel))
#define IFsInfo_GetLabel(p, aLabel) ((p)->lpVtbl->GetLabel(p, aLabel))
#define IFsInfo_get_MountPoint(p, aMountPoint) ((p)->lpVtbl->GetMountPoint(p, aMountPoint))
#define IFsInfo_GetMountPoint(p, aMountPoint) ((p)->lpVtbl->GetMountPoint(p, aMountPoint))
#endif /* VBOX_WITH_GLUE */

interface IFsInfo
{
#ifndef VBOX_WITH_GLUE
    struct IFsInfo_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IFsInfoVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IFsInfo declaration */


/* Start of struct IFsObjInfo declaration */
#define IFSOBJINFO_IID_STR "081fc833-c6fa-430e-6020-6a505d086387"
#define IFSOBJINFO_IID { \
    0x081fc833, 0xc6fa, 0x430e, \
    { 0x60, 0x20, 0x6a, 0x50, 0x5d, 0x08, 0x63, 0x87 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IFsObjInfo);
#ifndef VBOX_WITH_GLUE
struct IFsObjInfo_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetName)(IFsObjInfo *pThis, PRUnichar * *name);

    nsresult (*GetType)(IFsObjInfo *pThis, PRUint32 *type);

    nsresult (*GetFileAttributes)(IFsObjInfo *pThis, PRUnichar * *fileAttributes);

    nsresult (*GetObjectSize)(IFsObjInfo *pThis, PRInt64 *objectSize);

    nsresult (*GetAllocatedSize)(IFsObjInfo *pThis, PRInt64 *allocatedSize);

    nsresult (*GetAccessTime)(IFsObjInfo *pThis, PRInt64 *accessTime);

    nsresult (*GetBirthTime)(IFsObjInfo *pThis, PRInt64 *birthTime);

    nsresult (*GetChangeTime)(IFsObjInfo *pThis, PRInt64 *changeTime);

    nsresult (*GetModificationTime)(IFsObjInfo *pThis, PRInt64 *modificationTime);

    nsresult (*GetUID)(IFsObjInfo *pThis, PRInt32 *UID);

    nsresult (*GetUserName)(IFsObjInfo *pThis, PRUnichar * *userName);

    nsresult (*GetGID)(IFsObjInfo *pThis, PRInt32 *GID);

    nsresult (*GetGroupName)(IFsObjInfo *pThis, PRUnichar * *groupName);

    nsresult (*GetNodeId)(IFsObjInfo *pThis, PRInt64 *nodeId);

    nsresult (*GetNodeIdDevice)(IFsObjInfo *pThis, PRUint32 *nodeIdDevice);

    nsresult (*GetHardLinks)(IFsObjInfo *pThis, PRUint32 *hardLinks);

    nsresult (*GetDeviceNumber)(IFsObjInfo *pThis, PRUint32 *deviceNumber);

    nsresult (*GetGenerationId)(IFsObjInfo *pThis, PRUint32 *generationId);

    nsresult (*GetUserFlags)(IFsObjInfo *pThis, PRUint32 *userFlags);

    nsresult (*GetInternalAndReservedAttribute1IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

};
#else /* VBOX_WITH_GLUE */
struct IFsObjInfoVtbl
{
    nsresult (*QueryInterface)(IFsObjInfo *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IFsObjInfo *pThis);
    nsrefcnt (*Release)(IFsObjInfo *pThis);
    nsresult (*GetName)(IFsObjInfo *pThis, PRUnichar * *name);

    nsresult (*GetType)(IFsObjInfo *pThis, PRUint32 *type);

    nsresult (*GetFileAttributes)(IFsObjInfo *pThis, PRUnichar * *fileAttributes);

    nsresult (*GetObjectSize)(IFsObjInfo *pThis, PRInt64 *objectSize);

    nsresult (*GetAllocatedSize)(IFsObjInfo *pThis, PRInt64 *allocatedSize);

    nsresult (*GetAccessTime)(IFsObjInfo *pThis, PRInt64 *accessTime);

    nsresult (*GetBirthTime)(IFsObjInfo *pThis, PRInt64 *birthTime);

    nsresult (*GetChangeTime)(IFsObjInfo *pThis, PRInt64 *changeTime);

    nsresult (*GetModificationTime)(IFsObjInfo *pThis, PRInt64 *modificationTime);

    nsresult (*GetUID)(IFsObjInfo *pThis, PRInt32 *UID);

    nsresult (*GetUserName)(IFsObjInfo *pThis, PRUnichar * *userName);

    nsresult (*GetGID)(IFsObjInfo *pThis, PRInt32 *GID);

    nsresult (*GetGroupName)(IFsObjInfo *pThis, PRUnichar * *groupName);

    nsresult (*GetNodeId)(IFsObjInfo *pThis, PRInt64 *nodeId);

    nsresult (*GetNodeIdDevice)(IFsObjInfo *pThis, PRUint32 *nodeIdDevice);

    nsresult (*GetHardLinks)(IFsObjInfo *pThis, PRUint32 *hardLinks);

    nsresult (*GetDeviceNumber)(IFsObjInfo *pThis, PRUint32 *deviceNumber);

    nsresult (*GetGenerationId)(IFsObjInfo *pThis, PRUint32 *generationId);

    nsresult (*GetUserFlags)(IFsObjInfo *pThis, PRUint32 *userFlags);

    nsresult (*GetInternalAndReservedAttribute1IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFsObjInfo)(IFsObjInfo *pThis, PRUint32 *reserved);

};
#define IFsObjInfo_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IFsObjInfo_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IFsObjInfo_Release(p) ((p)->lpVtbl->Release(p))
#define IFsObjInfo_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IFsObjInfo_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IFsObjInfo_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IFsObjInfo_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IFsObjInfo_get_FileAttributes(p, aFileAttributes) ((p)->lpVtbl->GetFileAttributes(p, aFileAttributes))
#define IFsObjInfo_GetFileAttributes(p, aFileAttributes) ((p)->lpVtbl->GetFileAttributes(p, aFileAttributes))
#define IFsObjInfo_get_ObjectSize(p, aObjectSize) ((p)->lpVtbl->GetObjectSize(p, aObjectSize))
#define IFsObjInfo_GetObjectSize(p, aObjectSize) ((p)->lpVtbl->GetObjectSize(p, aObjectSize))
#define IFsObjInfo_get_AllocatedSize(p, aAllocatedSize) ((p)->lpVtbl->GetAllocatedSize(p, aAllocatedSize))
#define IFsObjInfo_GetAllocatedSize(p, aAllocatedSize) ((p)->lpVtbl->GetAllocatedSize(p, aAllocatedSize))
#define IFsObjInfo_get_AccessTime(p, aAccessTime) ((p)->lpVtbl->GetAccessTime(p, aAccessTime))
#define IFsObjInfo_GetAccessTime(p, aAccessTime) ((p)->lpVtbl->GetAccessTime(p, aAccessTime))
#define IFsObjInfo_get_BirthTime(p, aBirthTime) ((p)->lpVtbl->GetBirthTime(p, aBirthTime))
#define IFsObjInfo_GetBirthTime(p, aBirthTime) ((p)->lpVtbl->GetBirthTime(p, aBirthTime))
#define IFsObjInfo_get_ChangeTime(p, aChangeTime) ((p)->lpVtbl->GetChangeTime(p, aChangeTime))
#define IFsObjInfo_GetChangeTime(p, aChangeTime) ((p)->lpVtbl->GetChangeTime(p, aChangeTime))
#define IFsObjInfo_get_ModificationTime(p, aModificationTime) ((p)->lpVtbl->GetModificationTime(p, aModificationTime))
#define IFsObjInfo_GetModificationTime(p, aModificationTime) ((p)->lpVtbl->GetModificationTime(p, aModificationTime))
#define IFsObjInfo_get_UID(p, aUID) ((p)->lpVtbl->GetUID(p, aUID))
#define IFsObjInfo_GetUID(p, aUID) ((p)->lpVtbl->GetUID(p, aUID))
#define IFsObjInfo_get_UserName(p, aUserName) ((p)->lpVtbl->GetUserName(p, aUserName))
#define IFsObjInfo_GetUserName(p, aUserName) ((p)->lpVtbl->GetUserName(p, aUserName))
#define IFsObjInfo_get_GID(p, aGID) ((p)->lpVtbl->GetGID(p, aGID))
#define IFsObjInfo_GetGID(p, aGID) ((p)->lpVtbl->GetGID(p, aGID))
#define IFsObjInfo_get_GroupName(p, aGroupName) ((p)->lpVtbl->GetGroupName(p, aGroupName))
#define IFsObjInfo_GetGroupName(p, aGroupName) ((p)->lpVtbl->GetGroupName(p, aGroupName))
#define IFsObjInfo_get_NodeId(p, aNodeId) ((p)->lpVtbl->GetNodeId(p, aNodeId))
#define IFsObjInfo_GetNodeId(p, aNodeId) ((p)->lpVtbl->GetNodeId(p, aNodeId))
#define IFsObjInfo_get_NodeIdDevice(p, aNodeIdDevice) ((p)->lpVtbl->GetNodeIdDevice(p, aNodeIdDevice))
#define IFsObjInfo_GetNodeIdDevice(p, aNodeIdDevice) ((p)->lpVtbl->GetNodeIdDevice(p, aNodeIdDevice))
#define IFsObjInfo_get_HardLinks(p, aHardLinks) ((p)->lpVtbl->GetHardLinks(p, aHardLinks))
#define IFsObjInfo_GetHardLinks(p, aHardLinks) ((p)->lpVtbl->GetHardLinks(p, aHardLinks))
#define IFsObjInfo_get_DeviceNumber(p, aDeviceNumber) ((p)->lpVtbl->GetDeviceNumber(p, aDeviceNumber))
#define IFsObjInfo_GetDeviceNumber(p, aDeviceNumber) ((p)->lpVtbl->GetDeviceNumber(p, aDeviceNumber))
#define IFsObjInfo_get_GenerationId(p, aGenerationId) ((p)->lpVtbl->GetGenerationId(p, aGenerationId))
#define IFsObjInfo_GetGenerationId(p, aGenerationId) ((p)->lpVtbl->GetGenerationId(p, aGenerationId))
#define IFsObjInfo_get_UserFlags(p, aUserFlags) ((p)->lpVtbl->GetUserFlags(p, aUserFlags))
#define IFsObjInfo_GetUserFlags(p, aUserFlags) ((p)->lpVtbl->GetUserFlags(p, aUserFlags))
#endif /* VBOX_WITH_GLUE */

interface IFsObjInfo
{
#ifndef VBOX_WITH_GLUE
    struct IFsObjInfo_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IFsObjInfoVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IFsObjInfo declaration */


/* Start of struct IGuestFsInfo declaration */
#define IGUESTFSINFO_IID_STR "726eaca9-091e-41b4-bca6-355efe864107"
#define IGUESTFSINFO_IID { \
    0x726eaca9, 0x091e, 0x41b4, \
    { 0xbc, 0xa6, 0x35, 0x5e, 0xfe, 0x86, 0x41, 0x07 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestFsInfo);
#ifndef VBOX_WITH_GLUE
struct IGuestFsInfo_vtbl
{
    struct IFsInfo_vtbl ifsinfo;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestFsInfo *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#else /* VBOX_WITH_GLUE */
struct IGuestFsInfoVtbl
{
    nsresult (*QueryInterface)(IGuestFsInfo *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestFsInfo *pThis);
    nsrefcnt (*Release)(IGuestFsInfo *pThis);
    nsresult (*GetFreeSize)(IGuestFsInfo *pThis, PRInt64 *freeSize);

    nsresult (*GetTotalSize)(IGuestFsInfo *pThis, PRInt64 *totalSize);

    nsresult (*GetBlockSize)(IGuestFsInfo *pThis, PRUint32 *blockSize);

    nsresult (*GetSectorSize)(IGuestFsInfo *pThis, PRUint32 *sectorSize);

    nsresult (*GetSerialNumber)(IGuestFsInfo *pThis, PRUint32 *serialNumber);

    nsresult (*GetIsRemote)(IGuestFsInfo *pThis, PRBool *isRemote);

    nsresult (*GetIsCaseSensitive)(IGuestFsInfo *pThis, PRBool *isCaseSensitive);

    nsresult (*GetIsReadOnly)(IGuestFsInfo *pThis, PRBool *isReadOnly);

    nsresult (*GetIsCompressed)(IGuestFsInfo *pThis, PRBool *isCompressed);

    nsresult (*GetSupportsFileCompression)(IGuestFsInfo *pThis, PRBool *supportsFileCompression);

    nsresult (*GetMaxComponent)(IGuestFsInfo *pThis, PRUint32 *maxComponent);

    nsresult (*GetType)(IGuestFsInfo *pThis, PRUnichar * *type);

    nsresult (*GetLabel)(IGuestFsInfo *pThis, PRUnichar * *label);

    nsresult (*GetMountPoint)(IGuestFsInfo *pThis, PRUnichar * *mountPoint);

    nsresult (*GetInternalAndReservedAttribute1IFsInfo)(IGuestFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFsInfo)(IGuestFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFsInfo)(IGuestFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFsInfo)(IGuestFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFsInfo)(IGuestFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFsInfo)(IGuestFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFsInfo)(IGuestFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFsInfo)(IGuestFsInfo *pThis, PRUint32 *reserved);

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestFsInfo *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#define IGuestFsInfo_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestFsInfo_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestFsInfo_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestFsInfo_get_FreeSize(p, aFreeSize) ((p)->lpVtbl->GetFreeSize(p, aFreeSize))
#define IGuestFsInfo_GetFreeSize(p, aFreeSize) ((p)->lpVtbl->GetFreeSize(p, aFreeSize))
#define IGuestFsInfo_get_TotalSize(p, aTotalSize) ((p)->lpVtbl->GetTotalSize(p, aTotalSize))
#define IGuestFsInfo_GetTotalSize(p, aTotalSize) ((p)->lpVtbl->GetTotalSize(p, aTotalSize))
#define IGuestFsInfo_get_BlockSize(p, aBlockSize) ((p)->lpVtbl->GetBlockSize(p, aBlockSize))
#define IGuestFsInfo_GetBlockSize(p, aBlockSize) ((p)->lpVtbl->GetBlockSize(p, aBlockSize))
#define IGuestFsInfo_get_SectorSize(p, aSectorSize) ((p)->lpVtbl->GetSectorSize(p, aSectorSize))
#define IGuestFsInfo_GetSectorSize(p, aSectorSize) ((p)->lpVtbl->GetSectorSize(p, aSectorSize))
#define IGuestFsInfo_get_SerialNumber(p, aSerialNumber) ((p)->lpVtbl->GetSerialNumber(p, aSerialNumber))
#define IGuestFsInfo_GetSerialNumber(p, aSerialNumber) ((p)->lpVtbl->GetSerialNumber(p, aSerialNumber))
#define IGuestFsInfo_get_IsRemote(p, aIsRemote) ((p)->lpVtbl->GetIsRemote(p, aIsRemote))
#define IGuestFsInfo_GetIsRemote(p, aIsRemote) ((p)->lpVtbl->GetIsRemote(p, aIsRemote))
#define IGuestFsInfo_get_IsCaseSensitive(p, aIsCaseSensitive) ((p)->lpVtbl->GetIsCaseSensitive(p, aIsCaseSensitive))
#define IGuestFsInfo_GetIsCaseSensitive(p, aIsCaseSensitive) ((p)->lpVtbl->GetIsCaseSensitive(p, aIsCaseSensitive))
#define IGuestFsInfo_get_IsReadOnly(p, aIsReadOnly) ((p)->lpVtbl->GetIsReadOnly(p, aIsReadOnly))
#define IGuestFsInfo_GetIsReadOnly(p, aIsReadOnly) ((p)->lpVtbl->GetIsReadOnly(p, aIsReadOnly))
#define IGuestFsInfo_get_IsCompressed(p, aIsCompressed) ((p)->lpVtbl->GetIsCompressed(p, aIsCompressed))
#define IGuestFsInfo_GetIsCompressed(p, aIsCompressed) ((p)->lpVtbl->GetIsCompressed(p, aIsCompressed))
#define IGuestFsInfo_get_SupportsFileCompression(p, aSupportsFileCompression) ((p)->lpVtbl->GetSupportsFileCompression(p, aSupportsFileCompression))
#define IGuestFsInfo_GetSupportsFileCompression(p, aSupportsFileCompression) ((p)->lpVtbl->GetSupportsFileCompression(p, aSupportsFileCompression))
#define IGuestFsInfo_get_MaxComponent(p, aMaxComponent) ((p)->lpVtbl->GetMaxComponent(p, aMaxComponent))
#define IGuestFsInfo_GetMaxComponent(p, aMaxComponent) ((p)->lpVtbl->GetMaxComponent(p, aMaxComponent))
#define IGuestFsInfo_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IGuestFsInfo_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IGuestFsInfo_get_Label(p, aLabel) ((p)->lpVtbl->GetLabel(p, aLabel))
#define IGuestFsInfo_GetLabel(p, aLabel) ((p)->lpVtbl->GetLabel(p, aLabel))
#define IGuestFsInfo_get_MountPoint(p, aMountPoint) ((p)->lpVtbl->GetMountPoint(p, aMountPoint))
#define IGuestFsInfo_GetMountPoint(p, aMountPoint) ((p)->lpVtbl->GetMountPoint(p, aMountPoint))
#define IGuestFsInfo_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IGuestFsInfo_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IGuestFsInfo
{
#ifndef VBOX_WITH_GLUE
    struct IGuestFsInfo_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestFsInfoVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestFsInfo declaration */


/* Start of struct IGuestFsObjInfo declaration */
#define IGUESTFSOBJINFO_IID_STR "6620db85-44e0-ca69-e9e0-d4907ceccbe5"
#define IGUESTFSOBJINFO_IID { \
    0x6620db85, 0x44e0, 0xca69, \
    { 0xe9, 0xe0, 0xd4, 0x90, 0x7c, 0xec, 0xcb, 0xe5 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestFsObjInfo);
#ifndef VBOX_WITH_GLUE
struct IGuestFsObjInfo_vtbl
{
    struct IFsObjInfo_vtbl ifsobjinfo;

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestFsObjInfo *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#else /* VBOX_WITH_GLUE */
struct IGuestFsObjInfoVtbl
{
    nsresult (*QueryInterface)(IGuestFsObjInfo *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestFsObjInfo *pThis);
    nsrefcnt (*Release)(IGuestFsObjInfo *pThis);
    nsresult (*GetName)(IGuestFsObjInfo *pThis, PRUnichar * *name);

    nsresult (*GetType)(IGuestFsObjInfo *pThis, PRUint32 *type);

    nsresult (*GetFileAttributes)(IGuestFsObjInfo *pThis, PRUnichar * *fileAttributes);

    nsresult (*GetObjectSize)(IGuestFsObjInfo *pThis, PRInt64 *objectSize);

    nsresult (*GetAllocatedSize)(IGuestFsObjInfo *pThis, PRInt64 *allocatedSize);

    nsresult (*GetAccessTime)(IGuestFsObjInfo *pThis, PRInt64 *accessTime);

    nsresult (*GetBirthTime)(IGuestFsObjInfo *pThis, PRInt64 *birthTime);

    nsresult (*GetChangeTime)(IGuestFsObjInfo *pThis, PRInt64 *changeTime);

    nsresult (*GetModificationTime)(IGuestFsObjInfo *pThis, PRInt64 *modificationTime);

    nsresult (*GetUID)(IGuestFsObjInfo *pThis, PRInt32 *UID);

    nsresult (*GetUserName)(IGuestFsObjInfo *pThis, PRUnichar * *userName);

    nsresult (*GetGID)(IGuestFsObjInfo *pThis, PRInt32 *GID);

    nsresult (*GetGroupName)(IGuestFsObjInfo *pThis, PRUnichar * *groupName);

    nsresult (*GetNodeId)(IGuestFsObjInfo *pThis, PRInt64 *nodeId);

    nsresult (*GetNodeIdDevice)(IGuestFsObjInfo *pThis, PRUint32 *nodeIdDevice);

    nsresult (*GetHardLinks)(IGuestFsObjInfo *pThis, PRUint32 *hardLinks);

    nsresult (*GetDeviceNumber)(IGuestFsObjInfo *pThis, PRUint32 *deviceNumber);

    nsresult (*GetGenerationId)(IGuestFsObjInfo *pThis, PRUint32 *generationId);

    nsresult (*GetUserFlags)(IGuestFsObjInfo *pThis, PRUint32 *userFlags);

    nsresult (*GetInternalAndReservedAttribute1IFsObjInfo)(IGuestFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IFsObjInfo)(IGuestFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IFsObjInfo)(IGuestFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IFsObjInfo)(IGuestFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IFsObjInfo)(IGuestFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IFsObjInfo)(IGuestFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IFsObjInfo)(IGuestFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IFsObjInfo)(IGuestFsObjInfo *pThis, PRUint32 *reserved);

    nsresult (*GetMidlDoesNotLikeEmptyInterfaces)(IGuestFsObjInfo *pThis, PRBool *midlDoesNotLikeEmptyInterfaces);

};
#define IGuestFsObjInfo_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestFsObjInfo_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestFsObjInfo_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestFsObjInfo_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IGuestFsObjInfo_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IGuestFsObjInfo_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IGuestFsObjInfo_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IGuestFsObjInfo_get_FileAttributes(p, aFileAttributes) ((p)->lpVtbl->GetFileAttributes(p, aFileAttributes))
#define IGuestFsObjInfo_GetFileAttributes(p, aFileAttributes) ((p)->lpVtbl->GetFileAttributes(p, aFileAttributes))
#define IGuestFsObjInfo_get_ObjectSize(p, aObjectSize) ((p)->lpVtbl->GetObjectSize(p, aObjectSize))
#define IGuestFsObjInfo_GetObjectSize(p, aObjectSize) ((p)->lpVtbl->GetObjectSize(p, aObjectSize))
#define IGuestFsObjInfo_get_AllocatedSize(p, aAllocatedSize) ((p)->lpVtbl->GetAllocatedSize(p, aAllocatedSize))
#define IGuestFsObjInfo_GetAllocatedSize(p, aAllocatedSize) ((p)->lpVtbl->GetAllocatedSize(p, aAllocatedSize))
#define IGuestFsObjInfo_get_AccessTime(p, aAccessTime) ((p)->lpVtbl->GetAccessTime(p, aAccessTime))
#define IGuestFsObjInfo_GetAccessTime(p, aAccessTime) ((p)->lpVtbl->GetAccessTime(p, aAccessTime))
#define IGuestFsObjInfo_get_BirthTime(p, aBirthTime) ((p)->lpVtbl->GetBirthTime(p, aBirthTime))
#define IGuestFsObjInfo_GetBirthTime(p, aBirthTime) ((p)->lpVtbl->GetBirthTime(p, aBirthTime))
#define IGuestFsObjInfo_get_ChangeTime(p, aChangeTime) ((p)->lpVtbl->GetChangeTime(p, aChangeTime))
#define IGuestFsObjInfo_GetChangeTime(p, aChangeTime) ((p)->lpVtbl->GetChangeTime(p, aChangeTime))
#define IGuestFsObjInfo_get_ModificationTime(p, aModificationTime) ((p)->lpVtbl->GetModificationTime(p, aModificationTime))
#define IGuestFsObjInfo_GetModificationTime(p, aModificationTime) ((p)->lpVtbl->GetModificationTime(p, aModificationTime))
#define IGuestFsObjInfo_get_UID(p, aUID) ((p)->lpVtbl->GetUID(p, aUID))
#define IGuestFsObjInfo_GetUID(p, aUID) ((p)->lpVtbl->GetUID(p, aUID))
#define IGuestFsObjInfo_get_UserName(p, aUserName) ((p)->lpVtbl->GetUserName(p, aUserName))
#define IGuestFsObjInfo_GetUserName(p, aUserName) ((p)->lpVtbl->GetUserName(p, aUserName))
#define IGuestFsObjInfo_get_GID(p, aGID) ((p)->lpVtbl->GetGID(p, aGID))
#define IGuestFsObjInfo_GetGID(p, aGID) ((p)->lpVtbl->GetGID(p, aGID))
#define IGuestFsObjInfo_get_GroupName(p, aGroupName) ((p)->lpVtbl->GetGroupName(p, aGroupName))
#define IGuestFsObjInfo_GetGroupName(p, aGroupName) ((p)->lpVtbl->GetGroupName(p, aGroupName))
#define IGuestFsObjInfo_get_NodeId(p, aNodeId) ((p)->lpVtbl->GetNodeId(p, aNodeId))
#define IGuestFsObjInfo_GetNodeId(p, aNodeId) ((p)->lpVtbl->GetNodeId(p, aNodeId))
#define IGuestFsObjInfo_get_NodeIdDevice(p, aNodeIdDevice) ((p)->lpVtbl->GetNodeIdDevice(p, aNodeIdDevice))
#define IGuestFsObjInfo_GetNodeIdDevice(p, aNodeIdDevice) ((p)->lpVtbl->GetNodeIdDevice(p, aNodeIdDevice))
#define IGuestFsObjInfo_get_HardLinks(p, aHardLinks) ((p)->lpVtbl->GetHardLinks(p, aHardLinks))
#define IGuestFsObjInfo_GetHardLinks(p, aHardLinks) ((p)->lpVtbl->GetHardLinks(p, aHardLinks))
#define IGuestFsObjInfo_get_DeviceNumber(p, aDeviceNumber) ((p)->lpVtbl->GetDeviceNumber(p, aDeviceNumber))
#define IGuestFsObjInfo_GetDeviceNumber(p, aDeviceNumber) ((p)->lpVtbl->GetDeviceNumber(p, aDeviceNumber))
#define IGuestFsObjInfo_get_GenerationId(p, aGenerationId) ((p)->lpVtbl->GetGenerationId(p, aGenerationId))
#define IGuestFsObjInfo_GetGenerationId(p, aGenerationId) ((p)->lpVtbl->GetGenerationId(p, aGenerationId))
#define IGuestFsObjInfo_get_UserFlags(p, aUserFlags) ((p)->lpVtbl->GetUserFlags(p, aUserFlags))
#define IGuestFsObjInfo_GetUserFlags(p, aUserFlags) ((p)->lpVtbl->GetUserFlags(p, aUserFlags))
#define IGuestFsObjInfo_get_MidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#define IGuestFsObjInfo_GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces) ((p)->lpVtbl->GetMidlDoesNotLikeEmptyInterfaces(p, aMidlDoesNotLikeEmptyInterfaces))
#endif /* VBOX_WITH_GLUE */

interface IGuestFsObjInfo
{
#ifndef VBOX_WITH_GLUE
    struct IGuestFsObjInfo_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestFsObjInfoVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestFsObjInfo declaration */


/* Start of struct IGuest declaration */
#define IGUEST_IID_STR "00892186-A4AF-4627-B21F-FC561CE4473C"
#define IGUEST_IID { \
    0x00892186, 0xA4AF, 0x4627, \
    { 0xB2, 0x1F, 0xFC, 0x56, 0x1C, 0xE4, 0x47, 0x3C } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuest);
#ifndef VBOX_WITH_GLUE
struct IGuest_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetOSTypeId)(IGuest *pThis, PRUnichar * *OSTypeId);

    nsresult (*GetAdditionsRunLevel)(IGuest *pThis, PRUint32 *additionsRunLevel);

    nsresult (*GetAdditionsVersion)(IGuest *pThis, PRUnichar * *additionsVersion);

    nsresult (*GetAdditionsRevision)(IGuest *pThis, PRUint32 *additionsRevision);

    nsresult (*GetDnDSource)(IGuest *pThis, IGuestDnDSource * *dnDSource);

    nsresult (*GetDnDTarget)(IGuest *pThis, IGuestDnDTarget * *dnDTarget);

    nsresult (*GetEventSource)(IGuest *pThis, IEventSource * *eventSource);

    nsresult (*GetFacilities)(IGuest *pThis, PRUint32 *facilitiesSize, IAdditionsFacility * **facilities);

    nsresult (*GetSessions)(IGuest *pThis, PRUint32 *sessionsSize, IGuestSession * **sessions);

    nsresult (*GetMemoryBalloonSize)(IGuest *pThis, PRUint32 *memoryBalloonSize);
    nsresult (*SetMemoryBalloonSize)(IGuest *pThis, PRUint32 memoryBalloonSize);

    nsresult (*GetStatisticsUpdateInterval)(IGuest *pThis, PRUint32 *statisticsUpdateInterval);
    nsresult (*SetStatisticsUpdateInterval)(IGuest *pThis, PRUint32 statisticsUpdateInterval);

    nsresult (*GetInternalAndReservedAttribute1IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*InternalGetStatistics)(
        IGuest *pThis,
        PRUint32 * cpuUser,
        PRUint32 * cpuKernel,
        PRUint32 * cpuIdle,
        PRUint32 * memTotal,
        PRUint32 * memFree,
        PRUint32 * memBalloon,
        PRUint32 * memShared,
        PRUint32 * memCache,
        PRUint32 * pagedTotal,
        PRUint32 * memAllocTotal,
        PRUint32 * memFreeTotal,
        PRUint32 * memBalloonTotal,
        PRUint32 * memSharedTotal
    );

    nsresult (*GetFacilityStatus)(
        IGuest *pThis,
        PRUint32 facility,
        PRInt64 * timestamp,
        PRUint32 * status
    );

    nsresult (*GetAdditionsStatus)(
        IGuest *pThis,
        PRUint32 level,
        PRBool * active
    );

    nsresult (*SetCredentials)(
        IGuest *pThis,
        PRUnichar * userName,
        PRUnichar * password,
        PRUnichar * domain,
        PRBool allowInteractiveLogon
    );

    nsresult (*CreateSession)(
        IGuest *pThis,
        PRUnichar * user,
        PRUnichar * password,
        PRUnichar * domain,
        PRUnichar * sessionName,
        IGuestSession * * guestSession
    );

    nsresult (*FindSession)(
        IGuest *pThis,
        PRUnichar * sessionName,
        PRUint32 *sessionsSize,
        IGuestSession *** sessions
    );

    nsresult (*Shutdown)(
        IGuest *pThis,
        PRUint32 flagsSize,
        PRUint32* flags
    );

    nsresult (*UpdateGuestAdditions)(
        IGuest *pThis,
        PRUnichar * source,
        PRUint32 argumentsSize,
        PRUnichar ** arguments,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*InternalAndReservedMethod1IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod2IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod3IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod4IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod5IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod6IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod7IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod8IGuest)(IGuest *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IGuestVtbl
{
    nsresult (*QueryInterface)(IGuest *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuest *pThis);
    nsrefcnt (*Release)(IGuest *pThis);
    nsresult (*GetOSTypeId)(IGuest *pThis, PRUnichar * *OSTypeId);

    nsresult (*GetAdditionsRunLevel)(IGuest *pThis, PRUint32 *additionsRunLevel);

    nsresult (*GetAdditionsVersion)(IGuest *pThis, PRUnichar * *additionsVersion);

    nsresult (*GetAdditionsRevision)(IGuest *pThis, PRUint32 *additionsRevision);

    nsresult (*GetDnDSource)(IGuest *pThis, IGuestDnDSource * *dnDSource);

    nsresult (*GetDnDTarget)(IGuest *pThis, IGuestDnDTarget * *dnDTarget);

    nsresult (*GetEventSource)(IGuest *pThis, IEventSource * *eventSource);

    nsresult (*GetFacilities)(IGuest *pThis, PRUint32 *facilitiesSize, IAdditionsFacility * **facilities);

    nsresult (*GetSessions)(IGuest *pThis, PRUint32 *sessionsSize, IGuestSession * **sessions);

    nsresult (*GetMemoryBalloonSize)(IGuest *pThis, PRUint32 *memoryBalloonSize);
    nsresult (*SetMemoryBalloonSize)(IGuest *pThis, PRUint32 memoryBalloonSize);

    nsresult (*GetStatisticsUpdateInterval)(IGuest *pThis, PRUint32 *statisticsUpdateInterval);
    nsresult (*SetStatisticsUpdateInterval)(IGuest *pThis, PRUint32 statisticsUpdateInterval);

    nsresult (*GetInternalAndReservedAttribute1IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IGuest)(IGuest *pThis, PRUint32 *reserved);

    nsresult (*InternalGetStatistics)(
        IGuest *pThis,
        PRUint32 * cpuUser,
        PRUint32 * cpuKernel,
        PRUint32 * cpuIdle,
        PRUint32 * memTotal,
        PRUint32 * memFree,
        PRUint32 * memBalloon,
        PRUint32 * memShared,
        PRUint32 * memCache,
        PRUint32 * pagedTotal,
        PRUint32 * memAllocTotal,
        PRUint32 * memFreeTotal,
        PRUint32 * memBalloonTotal,
        PRUint32 * memSharedTotal
    );

    nsresult (*GetFacilityStatus)(
        IGuest *pThis,
        PRUint32 facility,
        PRInt64 * timestamp,
        PRUint32 * status
    );

    nsresult (*GetAdditionsStatus)(
        IGuest *pThis,
        PRUint32 level,
        PRBool * active
    );

    nsresult (*SetCredentials)(
        IGuest *pThis,
        PRUnichar * userName,
        PRUnichar * password,
        PRUnichar * domain,
        PRBool allowInteractiveLogon
    );

    nsresult (*CreateSession)(
        IGuest *pThis,
        PRUnichar * user,
        PRUnichar * password,
        PRUnichar * domain,
        PRUnichar * sessionName,
        IGuestSession * * guestSession
    );

    nsresult (*FindSession)(
        IGuest *pThis,
        PRUnichar * sessionName,
        PRUint32 *sessionsSize,
        IGuestSession *** sessions
    );

    nsresult (*Shutdown)(
        IGuest *pThis,
        PRUint32 flagsSize,
        PRUint32* flags
    );

    nsresult (*UpdateGuestAdditions)(
        IGuest *pThis,
        PRUnichar * source,
        PRUint32 argumentsSize,
        PRUnichar ** arguments,
        PRUint32 flagsSize,
        PRUint32* flags,
        IProgress * * progress
    );

    nsresult (*InternalAndReservedMethod1IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod2IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod3IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod4IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod5IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod6IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod7IGuest)(IGuest *pThis);

    nsresult (*InternalAndReservedMethod8IGuest)(IGuest *pThis);

};
#define IGuest_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuest_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuest_Release(p) ((p)->lpVtbl->Release(p))
#define IGuest_get_OSTypeId(p, aOSTypeId) ((p)->lpVtbl->GetOSTypeId(p, aOSTypeId))
#define IGuest_GetOSTypeId(p, aOSTypeId) ((p)->lpVtbl->GetOSTypeId(p, aOSTypeId))
#define IGuest_get_AdditionsRunLevel(p, aAdditionsRunLevel) ((p)->lpVtbl->GetAdditionsRunLevel(p, aAdditionsRunLevel))
#define IGuest_GetAdditionsRunLevel(p, aAdditionsRunLevel) ((p)->lpVtbl->GetAdditionsRunLevel(p, aAdditionsRunLevel))
#define IGuest_get_AdditionsVersion(p, aAdditionsVersion) ((p)->lpVtbl->GetAdditionsVersion(p, aAdditionsVersion))
#define IGuest_GetAdditionsVersion(p, aAdditionsVersion) ((p)->lpVtbl->GetAdditionsVersion(p, aAdditionsVersion))
#define IGuest_get_AdditionsRevision(p, aAdditionsRevision) ((p)->lpVtbl->GetAdditionsRevision(p, aAdditionsRevision))
#define IGuest_GetAdditionsRevision(p, aAdditionsRevision) ((p)->lpVtbl->GetAdditionsRevision(p, aAdditionsRevision))
#define IGuest_get_DnDSource(p, aDnDSource) ((p)->lpVtbl->GetDnDSource(p, aDnDSource))
#define IGuest_GetDnDSource(p, aDnDSource) ((p)->lpVtbl->GetDnDSource(p, aDnDSource))
#define IGuest_get_DnDTarget(p, aDnDTarget) ((p)->lpVtbl->GetDnDTarget(p, aDnDTarget))
#define IGuest_GetDnDTarget(p, aDnDTarget) ((p)->lpVtbl->GetDnDTarget(p, aDnDTarget))
#define IGuest_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuest_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IGuest_get_Facilities(p, aFacilities) ((p)->lpVtbl->GetFacilities(p, aFacilities))
#define IGuest_GetFacilities(p, aFacilities) ((p)->lpVtbl->GetFacilities(p, aFacilities))
#define IGuest_get_Sessions(p, aSessions) ((p)->lpVtbl->GetSessions(p, aSessions))
#define IGuest_GetSessions(p, aSessions) ((p)->lpVtbl->GetSessions(p, aSessions))
#define IGuest_get_MemoryBalloonSize(p, aMemoryBalloonSize) ((p)->lpVtbl->GetMemoryBalloonSize(p, aMemoryBalloonSize))
#define IGuest_GetMemoryBalloonSize(p, aMemoryBalloonSize) ((p)->lpVtbl->GetMemoryBalloonSize(p, aMemoryBalloonSize))
#define IGuest_put_MemoryBalloonSize(p, aMemoryBalloonSize) ((p)->lpVtbl->SetMemoryBalloonSize(p, aMemoryBalloonSize))
#define IGuest_SetMemoryBalloonSize(p, aMemoryBalloonSize) ((p)->lpVtbl->SetMemoryBalloonSize(p, aMemoryBalloonSize))
#define IGuest_get_StatisticsUpdateInterval(p, aStatisticsUpdateInterval) ((p)->lpVtbl->GetStatisticsUpdateInterval(p, aStatisticsUpdateInterval))
#define IGuest_GetStatisticsUpdateInterval(p, aStatisticsUpdateInterval) ((p)->lpVtbl->GetStatisticsUpdateInterval(p, aStatisticsUpdateInterval))
#define IGuest_put_StatisticsUpdateInterval(p, aStatisticsUpdateInterval) ((p)->lpVtbl->SetStatisticsUpdateInterval(p, aStatisticsUpdateInterval))
#define IGuest_SetStatisticsUpdateInterval(p, aStatisticsUpdateInterval) ((p)->lpVtbl->SetStatisticsUpdateInterval(p, aStatisticsUpdateInterval))
#define IGuest_InternalGetStatistics(p, aCpuUser, aCpuKernel, aCpuIdle, aMemTotal, aMemFree, aMemBalloon, aMemShared, aMemCache, aPagedTotal, aMemAllocTotal, aMemFreeTotal, aMemBalloonTotal, aMemSharedTotal) ((p)->lpVtbl->InternalGetStatistics(p, aCpuUser, aCpuKernel, aCpuIdle, aMemTotal, aMemFree, aMemBalloon, aMemShared, aMemCache, aPagedTotal, aMemAllocTotal, aMemFreeTotal, aMemBalloonTotal, aMemSharedTotal))
#define IGuest_GetFacilityStatus(p, aFacility, aTimestamp, aStatus) ((p)->lpVtbl->GetFacilityStatus(p, aFacility, aTimestamp, aStatus))
#define IGuest_GetAdditionsStatus(p, aLevel, aActive) ((p)->lpVtbl->GetAdditionsStatus(p, aLevel, aActive))
#define IGuest_SetCredentials(p, aUserName, aPassword, aDomain, aAllowInteractiveLogon) ((p)->lpVtbl->SetCredentials(p, aUserName, aPassword, aDomain, aAllowInteractiveLogon))
#define IGuest_CreateSession(p, aUser, aPassword, aDomain, aSessionName, aGuestSession) ((p)->lpVtbl->CreateSession(p, aUser, aPassword, aDomain, aSessionName, aGuestSession))
#define IGuest_FindSession(p, aSessionName, aSessions) ((p)->lpVtbl->FindSession(p, aSessionName, aSessions))
#define IGuest_Shutdown(p, aFlags) ((p)->lpVtbl->Shutdown(p, aFlags))
#define IGuest_UpdateGuestAdditions(p, aSource, aArguments, aFlags, aProgress) ((p)->lpVtbl->UpdateGuestAdditions(p, aSource, aArguments, aFlags, aProgress))
#endif /* VBOX_WITH_GLUE */

interface IGuest
{
#ifndef VBOX_WITH_GLUE
    struct IGuest_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuest declaration */


/* Start of struct IProgress declaration */
#define IPROGRESS_IID_STR "d7b98d2b-30e8-447e-99cb-e31becae6ae4"
#define IPROGRESS_IID { \
    0xd7b98d2b, 0x30e8, 0x447e, \
    { 0x99, 0xcb, 0xe3, 0x1b, 0xec, 0xae, 0x6a, 0xe4 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IProgress);
#ifndef VBOX_WITH_GLUE
struct IProgress_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetId)(IProgress *pThis, PRUnichar * *id);

    nsresult (*GetDescription)(IProgress *pThis, PRUnichar * *description);

    nsresult (*GetInitiator)(IProgress *pThis, nsISupports * *initiator);

    nsresult (*GetCancelable)(IProgress *pThis, PRBool *cancelable);

    nsresult (*GetPercent)(IProgress *pThis, PRUint32 *percent);

    nsresult (*GetTimeRemaining)(IProgress *pThis, PRInt32 *timeRemaining);

    nsresult (*GetCompleted)(IProgress *pThis, PRBool *completed);

    nsresult (*GetCanceled)(IProgress *pThis, PRBool *canceled);

    nsresult (*GetResultCode)(IProgress *pThis, PRInt32 *resultCode);

    nsresult (*GetErrorInfo)(IProgress *pThis, IVirtualBoxErrorInfo * *errorInfo);

    nsresult (*GetOperationCount)(IProgress *pThis, PRUint32 *operationCount);

    nsresult (*GetOperation)(IProgress *pThis, PRUint32 *operation);

    nsresult (*GetOperationDescription)(IProgress *pThis, PRUnichar * *operationDescription);

    nsresult (*GetOperationPercent)(IProgress *pThis, PRUint32 *operationPercent);

    nsresult (*GetOperationWeight)(IProgress *pThis, PRUint32 *operationWeight);

    nsresult (*GetTimeout)(IProgress *pThis, PRUint32 *timeout);
    nsresult (*SetTimeout)(IProgress *pThis, PRUint32 timeout);

    nsresult (*GetEventSource)(IProgress *pThis, IEventSource * *eventSource);

    nsresult (*GetInternalAndReservedAttribute1IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*WaitForCompletion)(
        IProgress *pThis,
        PRInt32 timeout
    );

    nsresult (*WaitForOperationCompletion)(
        IProgress *pThis,
        PRUint32 operation,
        PRInt32 timeout
    );

    nsresult (*Cancel)(IProgress *pThis );

    nsresult (*InternalAndReservedMethod1IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod2IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod3IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod4IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod5IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod6IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod7IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod8IProgress)(IProgress *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IProgressVtbl
{
    nsresult (*QueryInterface)(IProgress *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IProgress *pThis);
    nsrefcnt (*Release)(IProgress *pThis);
    nsresult (*GetId)(IProgress *pThis, PRUnichar * *id);

    nsresult (*GetDescription)(IProgress *pThis, PRUnichar * *description);

    nsresult (*GetInitiator)(IProgress *pThis, nsISupports * *initiator);

    nsresult (*GetCancelable)(IProgress *pThis, PRBool *cancelable);

    nsresult (*GetPercent)(IProgress *pThis, PRUint32 *percent);

    nsresult (*GetTimeRemaining)(IProgress *pThis, PRInt32 *timeRemaining);

    nsresult (*GetCompleted)(IProgress *pThis, PRBool *completed);

    nsresult (*GetCanceled)(IProgress *pThis, PRBool *canceled);

    nsresult (*GetResultCode)(IProgress *pThis, PRInt32 *resultCode);

    nsresult (*GetErrorInfo)(IProgress *pThis, IVirtualBoxErrorInfo * *errorInfo);

    nsresult (*GetOperationCount)(IProgress *pThis, PRUint32 *operationCount);

    nsresult (*GetOperation)(IProgress *pThis, PRUint32 *operation);

    nsresult (*GetOperationDescription)(IProgress *pThis, PRUnichar * *operationDescription);

    nsresult (*GetOperationPercent)(IProgress *pThis, PRUint32 *operationPercent);

    nsresult (*GetOperationWeight)(IProgress *pThis, PRUint32 *operationWeight);

    nsresult (*GetTimeout)(IProgress *pThis, PRUint32 *timeout);
    nsresult (*SetTimeout)(IProgress *pThis, PRUint32 timeout);

    nsresult (*GetEventSource)(IProgress *pThis, IEventSource * *eventSource);

    nsresult (*GetInternalAndReservedAttribute1IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IProgress)(IProgress *pThis, PRUint32 *reserved);

    nsresult (*WaitForCompletion)(
        IProgress *pThis,
        PRInt32 timeout
    );

    nsresult (*WaitForOperationCompletion)(
        IProgress *pThis,
        PRUint32 operation,
        PRInt32 timeout
    );

    nsresult (*Cancel)(IProgress *pThis );

    nsresult (*InternalAndReservedMethod1IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod2IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod3IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod4IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod5IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod6IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod7IProgress)(IProgress *pThis);

    nsresult (*InternalAndReservedMethod8IProgress)(IProgress *pThis);

};
#define IProgress_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IProgress_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IProgress_Release(p) ((p)->lpVtbl->Release(p))
#define IProgress_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IProgress_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IProgress_get_Description(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define IProgress_GetDescription(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define IProgress_get_Initiator(p, aInitiator) ((p)->lpVtbl->GetInitiator(p, aInitiator))
#define IProgress_GetInitiator(p, aInitiator) ((p)->lpVtbl->GetInitiator(p, aInitiator))
#define IProgress_get_Cancelable(p, aCancelable) ((p)->lpVtbl->GetCancelable(p, aCancelable))
#define IProgress_GetCancelable(p, aCancelable) ((p)->lpVtbl->GetCancelable(p, aCancelable))
#define IProgress_get_Percent(p, aPercent) ((p)->lpVtbl->GetPercent(p, aPercent))
#define IProgress_GetPercent(p, aPercent) ((p)->lpVtbl->GetPercent(p, aPercent))
#define IProgress_get_TimeRemaining(p, aTimeRemaining) ((p)->lpVtbl->GetTimeRemaining(p, aTimeRemaining))
#define IProgress_GetTimeRemaining(p, aTimeRemaining) ((p)->lpVtbl->GetTimeRemaining(p, aTimeRemaining))
#define IProgress_get_Completed(p, aCompleted) ((p)->lpVtbl->GetCompleted(p, aCompleted))
#define IProgress_GetCompleted(p, aCompleted) ((p)->lpVtbl->GetCompleted(p, aCompleted))
#define IProgress_get_Canceled(p, aCanceled) ((p)->lpVtbl->GetCanceled(p, aCanceled))
#define IProgress_GetCanceled(p, aCanceled) ((p)->lpVtbl->GetCanceled(p, aCanceled))
#define IProgress_get_ResultCode(p, aResultCode) ((p)->lpVtbl->GetResultCode(p, aResultCode))
#define IProgress_GetResultCode(p, aResultCode) ((p)->lpVtbl->GetResultCode(p, aResultCode))
#define IProgress_get_ErrorInfo(p, aErrorInfo) ((p)->lpVtbl->GetErrorInfo(p, aErrorInfo))
#define IProgress_GetErrorInfo(p, aErrorInfo) ((p)->lpVtbl->GetErrorInfo(p, aErrorInfo))
#define IProgress_get_OperationCount(p, aOperationCount) ((p)->lpVtbl->GetOperationCount(p, aOperationCount))
#define IProgress_GetOperationCount(p, aOperationCount) ((p)->lpVtbl->GetOperationCount(p, aOperationCount))
#define IProgress_get_Operation(p, aOperation) ((p)->lpVtbl->GetOperation(p, aOperation))
#define IProgress_GetOperation(p, aOperation) ((p)->lpVtbl->GetOperation(p, aOperation))
#define IProgress_get_OperationDescription(p, aOperationDescription) ((p)->lpVtbl->GetOperationDescription(p, aOperationDescription))
#define IProgress_GetOperationDescription(p, aOperationDescription) ((p)->lpVtbl->GetOperationDescription(p, aOperationDescription))
#define IProgress_get_OperationPercent(p, aOperationPercent) ((p)->lpVtbl->GetOperationPercent(p, aOperationPercent))
#define IProgress_GetOperationPercent(p, aOperationPercent) ((p)->lpVtbl->GetOperationPercent(p, aOperationPercent))
#define IProgress_get_OperationWeight(p, aOperationWeight) ((p)->lpVtbl->GetOperationWeight(p, aOperationWeight))
#define IProgress_GetOperationWeight(p, aOperationWeight) ((p)->lpVtbl->GetOperationWeight(p, aOperationWeight))
#define IProgress_get_Timeout(p, aTimeout) ((p)->lpVtbl->GetTimeout(p, aTimeout))
#define IProgress_GetTimeout(p, aTimeout) ((p)->lpVtbl->GetTimeout(p, aTimeout))
#define IProgress_put_Timeout(p, aTimeout) ((p)->lpVtbl->SetTimeout(p, aTimeout))
#define IProgress_SetTimeout(p, aTimeout) ((p)->lpVtbl->SetTimeout(p, aTimeout))
#define IProgress_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IProgress_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IProgress_WaitForCompletion(p, aTimeout) ((p)->lpVtbl->WaitForCompletion(p, aTimeout))
#define IProgress_WaitForOperationCompletion(p, aOperation, aTimeout) ((p)->lpVtbl->WaitForOperationCompletion(p, aOperation, aTimeout))
#define IProgress_Cancel(p) ((p)->lpVtbl->Cancel(p))
#endif /* VBOX_WITH_GLUE */

interface IProgress
{
#ifndef VBOX_WITH_GLUE
    struct IProgress_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IProgressVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IProgress declaration */


/* Start of struct ISnapshot declaration */
#define ISNAPSHOT_IID_STR "6cc49055-dad4-4496-85cf-3f76bcb3b5fa"
#define ISNAPSHOT_IID { \
    0x6cc49055, 0xdad4, 0x4496, \
    { 0x85, 0xcf, 0x3f, 0x76, 0xbc, 0xb3, 0xb5, 0xfa } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_ISnapshot);
#ifndef VBOX_WITH_GLUE
struct ISnapshot_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetId)(ISnapshot *pThis, PRUnichar * *id);

    nsresult (*GetName)(ISnapshot *pThis, PRUnichar * *name);
    nsresult (*SetName)(ISnapshot *pThis, PRUnichar * name);

    nsresult (*GetDescription)(ISnapshot *pThis, PRUnichar * *description);
    nsresult (*SetDescription)(ISnapshot *pThis, PRUnichar * description);

    nsresult (*GetTimeStamp)(ISnapshot *pThis, PRInt64 *timeStamp);

    nsresult (*GetOnline)(ISnapshot *pThis, PRBool *online);

    nsresult (*GetMachine)(ISnapshot *pThis, IMachine * *machine);

    nsresult (*GetParent)(ISnapshot *pThis, ISnapshot * *parent);

    nsresult (*GetChildren)(ISnapshot *pThis, PRUint32 *childrenSize, ISnapshot * **children);

    nsresult (*GetChildrenCount)(ISnapshot *pThis, PRUint32 *childrenCount);

    nsresult (*GetInternalAndReservedAttribute1ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1ISnapshot)(ISnapshot *pThis);

    nsresult (*InternalAndReservedMethod2ISnapshot)(ISnapshot *pThis);

    nsresult (*InternalAndReservedMethod3ISnapshot)(ISnapshot *pThis);

    nsresult (*InternalAndReservedMethod4ISnapshot)(ISnapshot *pThis);

};
#else /* VBOX_WITH_GLUE */
struct ISnapshotVtbl
{
    nsresult (*QueryInterface)(ISnapshot *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(ISnapshot *pThis);
    nsrefcnt (*Release)(ISnapshot *pThis);
    nsresult (*GetId)(ISnapshot *pThis, PRUnichar * *id);

    nsresult (*GetName)(ISnapshot *pThis, PRUnichar * *name);
    nsresult (*SetName)(ISnapshot *pThis, PRUnichar * name);

    nsresult (*GetDescription)(ISnapshot *pThis, PRUnichar * *description);
    nsresult (*SetDescription)(ISnapshot *pThis, PRUnichar * description);

    nsresult (*GetTimeStamp)(ISnapshot *pThis, PRInt64 *timeStamp);

    nsresult (*GetOnline)(ISnapshot *pThis, PRBool *online);

    nsresult (*GetMachine)(ISnapshot *pThis, IMachine * *machine);

    nsresult (*GetParent)(ISnapshot *pThis, ISnapshot * *parent);

    nsresult (*GetChildren)(ISnapshot *pThis, PRUint32 *childrenSize, ISnapshot * **children);

    nsresult (*GetChildrenCount)(ISnapshot *pThis, PRUint32 *childrenCount);

    nsresult (*GetInternalAndReservedAttribute1ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8ISnapshot)(ISnapshot *pThis, PRUint32 *reserved);

    nsresult (*InternalAndReservedMethod1ISnapshot)(ISnapshot *pThis);

    nsresult (*InternalAndReservedMethod2ISnapshot)(ISnapshot *pThis);

    nsresult (*InternalAndReservedMethod3ISnapshot)(ISnapshot *pThis);

    nsresult (*InternalAndReservedMethod4ISnapshot)(ISnapshot *pThis);

};
#define ISnapshot_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define ISnapshot_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define ISnapshot_Release(p) ((p)->lpVtbl->Release(p))
#define ISnapshot_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define ISnapshot_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define ISnapshot_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define ISnapshot_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define ISnapshot_put_Name(p, aName) ((p)->lpVtbl->SetName(p, aName))
#define ISnapshot_SetName(p, aName) ((p)->lpVtbl->SetName(p, aName))
#define ISnapshot_get_Description(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define ISnapshot_GetDescription(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define ISnapshot_put_Description(p, aDescription) ((p)->lpVtbl->SetDescription(p, aDescription))
#define ISnapshot_SetDescription(p, aDescription) ((p)->lpVtbl->SetDescription(p, aDescription))
#define ISnapshot_get_TimeStamp(p, aTimeStamp) ((p)->lpVtbl->GetTimeStamp(p, aTimeStamp))
#define ISnapshot_GetTimeStamp(p, aTimeStamp) ((p)->lpVtbl->GetTimeStamp(p, aTimeStamp))
#define ISnapshot_get_Online(p, aOnline) ((p)->lpVtbl->GetOnline(p, aOnline))
#define ISnapshot_GetOnline(p, aOnline) ((p)->lpVtbl->GetOnline(p, aOnline))
#define ISnapshot_get_Machine(p, aMachine) ((p)->lpVtbl->GetMachine(p, aMachine))
#define ISnapshot_GetMachine(p, aMachine) ((p)->lpVtbl->GetMachine(p, aMachine))
#define ISnapshot_get_Parent(p, aParent) ((p)->lpVtbl->GetParent(p, aParent))
#define ISnapshot_GetParent(p, aParent) ((p)->lpVtbl->GetParent(p, aParent))
#define ISnapshot_get_Children(p, aChildren) ((p)->lpVtbl->GetChildren(p, aChildren))
#define ISnapshot_GetChildren(p, aChildren) ((p)->lpVtbl->GetChildren(p, aChildren))
#define ISnapshot_get_ChildrenCount(p, aChildrenCount) ((p)->lpVtbl->GetChildrenCount(p, aChildrenCount))
#define ISnapshot_GetChildrenCount(p, aChildrenCount) ((p)->lpVtbl->GetChildrenCount(p, aChildrenCount))
#endif /* VBOX_WITH_GLUE */

interface ISnapshot
{
#ifndef VBOX_WITH_GLUE
    struct ISnapshot_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct ISnapshotVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct ISnapshot declaration */


/* Start of struct IMediumAttachment declaration */
#define IMEDIUMATTACHMENT_IID_STR "8d095cb0-0126-43e0-b05d-326e74abb356"
#define IMEDIUMATTACHMENT_IID { \
    0x8d095cb0, 0x0126, 0x43e0, \
    { 0xb0, 0x5d, 0x32, 0x6e, 0x74, 0xab, 0xb3, 0x56 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IMediumAttachment);
#ifndef VBOX_WITH_GLUE
struct IMediumAttachment_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetMachine)(IMediumAttachment *pThis, IMachine * *machine);

    nsresult (*GetMedium)(IMediumAttachment *pThis, IMedium * *medium);

    nsresult (*GetController)(IMediumAttachment *pThis, PRUnichar * *controller);

    nsresult (*GetPort)(IMediumAttachment *pThis, PRInt32 *port);

    nsresult (*GetDevice)(IMediumAttachment *pThis, PRInt32 *device);

    nsresult (*GetType)(IMediumAttachment *pThis, PRUint32 *type);

    nsresult (*GetPassthrough)(IMediumAttachment *pThis, PRBool *passthrough);

    nsresult (*GetTemporaryEject)(IMediumAttachment *pThis, PRBool *temporaryEject);

    nsresult (*GetIsEjected)(IMediumAttachment *pThis, PRBool *isEjected);

    nsresult (*GetNonRotational)(IMediumAttachment *pThis, PRBool *nonRotational);

    nsresult (*GetDiscard)(IMediumAttachment *pThis, PRBool *discard);

    nsresult (*GetHotPluggable)(IMediumAttachment *pThis, PRBool *hotPluggable);

    nsresult (*GetBandwidthGroup)(IMediumAttachment *pThis, IBandwidthGroup * *bandwidthGroup);

    nsresult (*GetInternalAndReservedAttribute1IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

};
#else /* VBOX_WITH_GLUE */
struct IMediumAttachmentVtbl
{
    nsresult (*QueryInterface)(IMediumAttachment *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IMediumAttachment *pThis);
    nsrefcnt (*Release)(IMediumAttachment *pThis);
    nsresult (*GetMachine)(IMediumAttachment *pThis, IMachine * *machine);

    nsresult (*GetMedium)(IMediumAttachment *pThis, IMedium * *medium);

    nsresult (*GetController)(IMediumAttachment *pThis, PRUnichar * *controller);

    nsresult (*GetPort)(IMediumAttachment *pThis, PRInt32 *port);

    nsresult (*GetDevice)(IMediumAttachment *pThis, PRInt32 *device);

    nsresult (*GetType)(IMediumAttachment *pThis, PRUint32 *type);

    nsresult (*GetPassthrough)(IMediumAttachment *pThis, PRBool *passthrough);

    nsresult (*GetTemporaryEject)(IMediumAttachment *pThis, PRBool *temporaryEject);

    nsresult (*GetIsEjected)(IMediumAttachment *pThis, PRBool *isEjected);

    nsresult (*GetNonRotational)(IMediumAttachment *pThis, PRBool *nonRotational);

    nsresult (*GetDiscard)(IMediumAttachment *pThis, PRBool *discard);

    nsresult (*GetHotPluggable)(IMediumAttachment *pThis, PRBool *hotPluggable);

    nsresult (*GetBandwidthGroup)(IMediumAttachment *pThis, IBandwidthGroup * *bandwidthGroup);

    nsresult (*GetInternalAndReservedAttribute1IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IMediumAttachment)(IMediumAttachment *pThis, PRUint32 *reserved);

};
#define IMediumAttachment_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IMediumAttachment_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IMediumAttachment_Release(p) ((p)->lpVtbl->Release(p))
#define IMediumAttachment_get_Machine(p, aMachine) ((p)->lpVtbl->GetMachine(p, aMachine))
#define IMediumAttachment_GetMachine(p, aMachine) ((p)->lpVtbl->GetMachine(p, aMachine))
#define IMediumAttachment_get_Medium(p, aMedium) ((p)->lpVtbl->GetMedium(p, aMedium))
#define IMediumAttachment_GetMedium(p, aMedium) ((p)->lpVtbl->GetMedium(p, aMedium))
#define IMediumAttachment_get_Controller(p, aController) ((p)->lpVtbl->GetController(p, aController))
#define IMediumAttachment_GetController(p, aController) ((p)->lpVtbl->GetController(p, aController))
#define IMediumAttachment_get_Port(p, aPort) ((p)->lpVtbl->GetPort(p, aPort))
#define IMediumAttachment_GetPort(p, aPort) ((p)->lpVtbl->GetPort(p, aPort))
#define IMediumAttachment_get_Device(p, aDevice) ((p)->lpVtbl->GetDevice(p, aDevice))
#define IMediumAttachment_GetDevice(p, aDevice) ((p)->lpVtbl->GetDevice(p, aDevice))
#define IMediumAttachment_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IMediumAttachment_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IMediumAttachment_get_Passthrough(p, aPassthrough) ((p)->lpVtbl->GetPassthrough(p, aPassthrough))
#define IMediumAttachment_GetPassthrough(p, aPassthrough) ((p)->lpVtbl->GetPassthrough(p, aPassthrough))
#define IMediumAttachment_get_TemporaryEject(p, aTemporaryEject) ((p)->lpVtbl->GetTemporaryEject(p, aTemporaryEject))
#define IMediumAttachment_GetTemporaryEject(p, aTemporaryEject) ((p)->lpVtbl->GetTemporaryEject(p, aTemporaryEject))
#define IMediumAttachment_get_IsEjected(p, aIsEjected) ((p)->lpVtbl->GetIsEjected(p, aIsEjected))
#define IMediumAttachment_GetIsEjected(p, aIsEjected) ((p)->lpVtbl->GetIsEjected(p, aIsEjected))
#define IMediumAttachment_get_NonRotational(p, aNonRotational) ((p)->lpVtbl->GetNonRotational(p, aNonRotational))
#define IMediumAttachment_GetNonRotational(p, aNonRotational) ((p)->lpVtbl->GetNonRotational(p, aNonRotational))
#define IMediumAttachment_get_Discard(p, aDiscard) ((p)->lpVtbl->GetDiscard(p, aDiscard))
#define IMediumAttachment_GetDiscard(p, aDiscard) ((p)->lpVtbl->GetDiscard(p, aDiscard))
#define IMediumAttachment_get_HotPluggable(p, aHotPluggable) ((p)->lpVtbl->GetHotPluggable(p, aHotPluggable))
#define IMediumAttachment_GetHotPluggable(p, aHotPluggable) ((p)->lpVtbl->GetHotPluggable(p, aHotPluggable))
#define IMediumAttachment_get_BandwidthGroup(p, aBandwidthGroup) ((p)->lpVtbl->GetBandwidthGroup(p, aBandwidthGroup))
#define IMediumAttachment_GetBandwidthGroup(p, aBandwidthGroup) ((p)->lpVtbl->GetBandwidthGroup(p, aBandwidthGroup))
#endif /* VBOX_WITH_GLUE */

interface IMediumAttachment
{
#ifndef VBOX_WITH_GLUE
    struct IMediumAttachment_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IMediumAttachmentVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IMediumAttachment declaration */


/* Start of struct IMedium declaration */
#define IMEDIUM_IID_STR "7d510820-a678-4730-a862-818dcd3fbed0"
#define IMEDIUM_IID { \
    0x7d510820, 0xa678, 0x4730, \
    { 0xa8, 0x62, 0x81, 0x8d, 0xcd, 0x3f, 0xbe, 0xd0 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IMedium);
#ifndef VBOX_WITH_GLUE
struct IMedium_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetId)(IMedium *pThis, PRUnichar * *id);

    nsresult (*GetDescription)(IMedium *pThis, PRUnichar * *description);
    nsresult (*SetDescription)(IMedium *pThis, PRUnichar * description);

    nsresult (*GetState)(IMedium *pThis, PRUint32 *state);

    nsresult (*GetVariant)(IMedium *pThis, PRUint32 *variantSize, PRUint32 **variant);

    nsresult (*GetLocation)(IMedium *pThis, PRUnichar * *location);
    nsresult (*SetLocation)(IMedium *pThis, PRUnichar * location);

    nsresult (*GetName)(IMedium *pThis, PRUnichar * *name);

    nsresult (*GetDeviceType)(IMedium *pThis, PRUint32 *deviceType);

    nsresult (*GetHostDrive)(IMedium *pThis, PRBool *hostDrive);

    nsresult (*GetSize)(IMedium *pThis, PRInt64 *size);

    nsresult (*GetFormat)(IMedium *pThis, PRUnichar * *format);

    nsresult (*GetMediumFormat)(IMedium *pThis, IMediumFormat * *mediumFormat);

    nsresult (*GetType)(IMedium *pThis, PRUint32 *type);
    nsresult (*SetType)(IMedium *pThis, PRUint32 type);

    nsresult (*GetAllowedTypes)(IMedium *pThis, PRUint32 *allowedTypesSize, PRUint32 **allowedTypes);

    nsresult (*GetParent)(IMedium *pThis, IMedium * *parent);

    nsresult (*GetChildren)(IMedium *pThis, PRUint32 *childrenSize, IMedium * **children);

    nsresult (*GetBase)(IMedium *pThis, IMedium * *base);

    nsresult (*GetReadOnly)(IMedium *pThis, PRBool *readOnly);

    nsresult (*GetLogicalSize)(IMedium *pThis, PRInt64 *logicalSize);

    nsresult (*GetAutoReset)(IMedium *pThis, PRBool *autoReset);
    nsresult (*SetAutoReset)(IMedium *pThis, PRBool autoReset);

    nsresult (*GetLastAccessError)(IMedium *pThis, PRUnichar * *lastAccessError);

    nsresult (*GetMachineIds)(IMedium *pThis, PRUint32 *machineIdsSize, PRUnichar * **machineIds);

    nsresult (*GetInternalAndReservedAttribute1IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*SetIds)(
        IMedium *pThis,
        PRBool setImageId,
        PRUnichar * imageId,
        PRBool setParentId,
        PRUnichar * parentId
    );

    nsresult (*RefreshState)(
        IMedium *pThis,
        PRUint32 * state
    );

    nsresult (*GetSnapshotIds)(
        IMedium *pThis,
        PRUnichar * machineId,
        PRUint32 *snapshotIdsSize,
        PRUnichar *** snapshotIds
    );

    nsresult (*LockRead)(
        IMedium *pThis,
        IToken * * token
    );

    nsresult (*LockWrite)(
        IMedium *pThis,
        IToken * * token
    );

    nsresult (*Close)(IMedium *pThis );

    nsresult (*GetProperty)(
        IMedium *pThis,
        PRUnichar * name,
        PRUnichar * * value
    );

    nsresult (*SetProperty)(
        IMedium *pThis,
        PRUnichar * name,
        PRUnichar * value
    );

    nsresult (*GetProperties)(
        IMedium *pThis,
        PRUnichar * names,
        PRUint32 *returnNamesSize,
        PRUnichar *** returnNames,
        PRUint32 *returnValuesSize,
        PRUnichar *** returnValues
    );

    nsresult (*SetProperties)(
        IMedium *pThis,
        PRUint32 namesSize,
        PRUnichar ** names,
        PRUint32 valuesSize,
        PRUnichar ** values
    );

    nsresult (*CreateBaseStorage)(
        IMedium *pThis,
        PRInt64 logicalSize,
        PRUint32 variantSize,
        PRUint32* variant,
        IProgress * * progress
    );

    nsresult (*DeleteStorage)(
        IMedium *pThis,
        IProgress * * progress
    );

    nsresult (*CreateDiffStorage)(
        IMedium *pThis,
        IMedium * target,
        PRUint32 variantSize,
        PRUint32* variant,
        IProgress * * progress
    );

    nsresult (*MergeTo)(
        IMedium *pThis,
        IMedium * target,
        IProgress * * progress
    );

    nsresult (*CloneTo)(
        IMedium *pThis,
        IMedium * target,
        PRUint32 variantSize,
        PRUint32* variant,
        IMedium * parent,
        IProgress * * progress
    );

    nsresult (*CloneToBase)(
        IMedium *pThis,
        IMedium * target,
        PRUint32 variantSize,
        PRUint32* variant,
        IProgress * * progress
    );

    nsresult (*MoveTo)(
        IMedium *pThis,
        PRUnichar * location,
        IProgress * * progress
    );

    nsresult (*Compact)(
        IMedium *pThis,
        IProgress * * progress
    );

    nsresult (*Resize)(
        IMedium *pThis,
        PRInt64 logicalSize,
        IProgress * * progress
    );

    nsresult (*Reset)(
        IMedium *pThis,
        IProgress * * progress
    );

    nsresult (*ChangeEncryption)(
        IMedium *pThis,
        PRUnichar * currentPassword,
        PRUnichar * cipher,
        PRUnichar * newPassword,
        PRUnichar * newPasswordId,
        IProgress * * progress
    );

    nsresult (*GetEncryptionSettings)(
        IMedium *pThis,
        PRUnichar * * cipher,
        PRUnichar * * passwordId
    );

    nsresult (*CheckEncryptionPassword)(
        IMedium *pThis,
        PRUnichar * password
    );

    nsresult (*OpenForIO)(
        IMedium *pThis,
        PRBool writable,
        PRUnichar * password,
        IMediumIO * * mediumIO
    );

    nsresult (*ResizeAndCloneTo)(
        IMedium *pThis,
        IMedium * target,
        PRInt64 logicalSize,
        PRUint32 variantSize,
        PRUint32* variant,
        IMedium * parent,
        IProgress * * progress
    );

    nsresult (*InternalAndReservedMethod1IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod2IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod3IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod4IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod5IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod6IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod7IMedium)(IMedium *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IMediumVtbl
{
    nsresult (*QueryInterface)(IMedium *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IMedium *pThis);
    nsrefcnt (*Release)(IMedium *pThis);
    nsresult (*GetId)(IMedium *pThis, PRUnichar * *id);

    nsresult (*GetDescription)(IMedium *pThis, PRUnichar * *description);
    nsresult (*SetDescription)(IMedium *pThis, PRUnichar * description);

    nsresult (*GetState)(IMedium *pThis, PRUint32 *state);

    nsresult (*GetVariant)(IMedium *pThis, PRUint32 *variantSize, PRUint32 **variant);

    nsresult (*GetLocation)(IMedium *pThis, PRUnichar * *location);
    nsresult (*SetLocation)(IMedium *pThis, PRUnichar * location);

    nsresult (*GetName)(IMedium *pThis, PRUnichar * *name);

    nsresult (*GetDeviceType)(IMedium *pThis, PRUint32 *deviceType);

    nsresult (*GetHostDrive)(IMedium *pThis, PRBool *hostDrive);

    nsresult (*GetSize)(IMedium *pThis, PRInt64 *size);

    nsresult (*GetFormat)(IMedium *pThis, PRUnichar * *format);

    nsresult (*GetMediumFormat)(IMedium *pThis, IMediumFormat * *mediumFormat);

    nsresult (*GetType)(IMedium *pThis, PRUint32 *type);
    nsresult (*SetType)(IMedium *pThis, PRUint32 type);

    nsresult (*GetAllowedTypes)(IMedium *pThis, PRUint32 *allowedTypesSize, PRUint32 **allowedTypes);

    nsresult (*GetParent)(IMedium *pThis, IMedium * *parent);

    nsresult (*GetChildren)(IMedium *pThis, PRUint32 *childrenSize, IMedium * **children);

    nsresult (*GetBase)(IMedium *pThis, IMedium * *base);

    nsresult (*GetReadOnly)(IMedium *pThis, PRBool *readOnly);

    nsresult (*GetLogicalSize)(IMedium *pThis, PRInt64 *logicalSize);

    nsresult (*GetAutoReset)(IMedium *pThis, PRBool *autoReset);
    nsresult (*SetAutoReset)(IMedium *pThis, PRBool autoReset);

    nsresult (*GetLastAccessError)(IMedium *pThis, PRUnichar * *lastAccessError);

    nsresult (*GetMachineIds)(IMedium *pThis, PRUint32 *machineIdsSize, PRUnichar * **machineIds);

    nsresult (*GetInternalAndReservedAttribute1IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IMedium)(IMedium *pThis, PRUint32 *reserved);

    nsresult (*SetIds)(
        IMedium *pThis,
        PRBool setImageId,
        PRUnichar * imageId,
        PRBool setParentId,
        PRUnichar * parentId
    );

    nsresult (*RefreshState)(
        IMedium *pThis,
        PRUint32 * state
    );

    nsresult (*GetSnapshotIds)(
        IMedium *pThis,
        PRUnichar * machineId,
        PRUint32 *snapshotIdsSize,
        PRUnichar *** snapshotIds
    );

    nsresult (*LockRead)(
        IMedium *pThis,
        IToken * * token
    );

    nsresult (*LockWrite)(
        IMedium *pThis,
        IToken * * token
    );

    nsresult (*Close)(IMedium *pThis );

    nsresult (*GetProperty)(
        IMedium *pThis,
        PRUnichar * name,
        PRUnichar * * value
    );

    nsresult (*SetProperty)(
        IMedium *pThis,
        PRUnichar * name,
        PRUnichar * value
    );

    nsresult (*GetProperties)(
        IMedium *pThis,
        PRUnichar * names,
        PRUint32 *returnNamesSize,
        PRUnichar *** returnNames,
        PRUint32 *returnValuesSize,
        PRUnichar *** returnValues
    );

    nsresult (*SetProperties)(
        IMedium *pThis,
        PRUint32 namesSize,
        PRUnichar ** names,
        PRUint32 valuesSize,
        PRUnichar ** values
    );

    nsresult (*CreateBaseStorage)(
        IMedium *pThis,
        PRInt64 logicalSize,
        PRUint32 variantSize,
        PRUint32* variant,
        IProgress * * progress
    );

    nsresult (*DeleteStorage)(
        IMedium *pThis,
        IProgress * * progress
    );

    nsresult (*CreateDiffStorage)(
        IMedium *pThis,
        IMedium * target,
        PRUint32 variantSize,
        PRUint32* variant,
        IProgress * * progress
    );

    nsresult (*MergeTo)(
        IMedium *pThis,
        IMedium * target,
        IProgress * * progress
    );

    nsresult (*CloneTo)(
        IMedium *pThis,
        IMedium * target,
        PRUint32 variantSize,
        PRUint32* variant,
        IMedium * parent,
        IProgress * * progress
    );

    nsresult (*CloneToBase)(
        IMedium *pThis,
        IMedium * target,
        PRUint32 variantSize,
        PRUint32* variant,
        IProgress * * progress
    );

    nsresult (*MoveTo)(
        IMedium *pThis,
        PRUnichar * location,
        IProgress * * progress
    );

    nsresult (*Compact)(
        IMedium *pThis,
        IProgress * * progress
    );

    nsresult (*Resize)(
        IMedium *pThis,
        PRInt64 logicalSize,
        IProgress * * progress
    );

    nsresult (*Reset)(
        IMedium *pThis,
        IProgress * * progress
    );

    nsresult (*ChangeEncryption)(
        IMedium *pThis,
        PRUnichar * currentPassword,
        PRUnichar * cipher,
        PRUnichar * newPassword,
        PRUnichar * newPasswordId,
        IProgress * * progress
    );

    nsresult (*GetEncryptionSettings)(
        IMedium *pThis,
        PRUnichar * * cipher,
        PRUnichar * * passwordId
    );

    nsresult (*CheckEncryptionPassword)(
        IMedium *pThis,
        PRUnichar * password
    );

    nsresult (*OpenForIO)(
        IMedium *pThis,
        PRBool writable,
        PRUnichar * password,
        IMediumIO * * mediumIO
    );

    nsresult (*ResizeAndCloneTo)(
        IMedium *pThis,
        IMedium * target,
        PRInt64 logicalSize,
        PRUint32 variantSize,
        PRUint32* variant,
        IMedium * parent,
        IProgress * * progress
    );

    nsresult (*InternalAndReservedMethod1IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod2IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod3IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod4IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod5IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod6IMedium)(IMedium *pThis);

    nsresult (*InternalAndReservedMethod7IMedium)(IMedium *pThis);

};
#define IMedium_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IMedium_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IMedium_Release(p) ((p)->lpVtbl->Release(p))
#define IMedium_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IMedium_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IMedium_get_Description(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define IMedium_GetDescription(p, aDescription) ((p)->lpVtbl->GetDescription(p, aDescription))
#define IMedium_put_Description(p, aDescription) ((p)->lpVtbl->SetDescription(p, aDescription))
#define IMedium_SetDescription(p, aDescription) ((p)->lpVtbl->SetDescription(p, aDescription))
#define IMedium_get_State(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IMedium_GetState(p, aState) ((p)->lpVtbl->GetState(p, aState))
#define IMedium_get_Variant(p, aVariant) ((p)->lpVtbl->GetVariant(p, aVariant))
#define IMedium_GetVariant(p, aVariant) ((p)->lpVtbl->GetVariant(p, aVariant))
#define IMedium_get_Location(p, aLocation) ((p)->lpVtbl->GetLocation(p, aLocation))
#define IMedium_GetLocation(p, aLocation) ((p)->lpVtbl->GetLocation(p, aLocation))
#define IMedium_put_Location(p, aLocation) ((p)->lpVtbl->SetLocation(p, aLocation))
#define IMedium_SetLocation(p, aLocation) ((p)->lpVtbl->SetLocation(p, aLocation))
#define IMedium_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IMedium_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IMedium_get_DeviceType(p, aDeviceType) ((p)->lpVtbl->GetDeviceType(p, aDeviceType))
#define IMedium_GetDeviceType(p, aDeviceType) ((p)->lpVtbl->GetDeviceType(p, aDeviceType))
#define IMedium_get_HostDrive(p, aHostDrive) ((p)->lpVtbl->GetHostDrive(p, aHostDrive))
#define IMedium_GetHostDrive(p, aHostDrive) ((p)->lpVtbl->GetHostDrive(p, aHostDrive))
#define IMedium_get_Size(p, aSize) ((p)->lpVtbl->GetSize(p, aSize))
#define IMedium_GetSize(p, aSize) ((p)->lpVtbl->GetSize(p, aSize))
#define IMedium_get_Format(p, aFormat) ((p)->lpVtbl->GetFormat(p, aFormat))
#define IMedium_GetFormat(p, aFormat) ((p)->lpVtbl->GetFormat(p, aFormat))
#define IMedium_get_MediumFormat(p, aMediumFormat) ((p)->lpVtbl->GetMediumFormat(p, aMediumFormat))
#define IMedium_GetMediumFormat(p, aMediumFormat) ((p)->lpVtbl->GetMediumFormat(p, aMediumFormat))
#define IMedium_get_Type(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IMedium_GetType(p, aType) ((p)->lpVtbl->GetType(p, aType))
#define IMedium_put_Type(p, aType) ((p)->lpVtbl->SetType(p, aType))
#define IMedium_SetType(p, aType) ((p)->lpVtbl->SetType(p, aType))
#define IMedium_get_AllowedTypes(p, aAllowedTypes) ((p)->lpVtbl->GetAllowedTypes(p, aAllowedTypes))
#define IMedium_GetAllowedTypes(p, aAllowedTypes) ((p)->lpVtbl->GetAllowedTypes(p, aAllowedTypes))
#define IMedium_get_Parent(p, aParent) ((p)->lpVtbl->GetParent(p, aParent))
#define IMedium_GetParent(p, aParent) ((p)->lpVtbl->GetParent(p, aParent))
#define IMedium_get_Children(p, aChildren) ((p)->lpVtbl->GetChildren(p, aChildren))
#define IMedium_GetChildren(p, aChildren) ((p)->lpVtbl->GetChildren(p, aChildren))
#define IMedium_get_Base(p, aBase) ((p)->lpVtbl->GetBase(p, aBase))
#define IMedium_GetBase(p, aBase) ((p)->lpVtbl->GetBase(p, aBase))
#define IMedium_get_ReadOnly(p, aReadOnly) ((p)->lpVtbl->GetReadOnly(p, aReadOnly))
#define IMedium_GetReadOnly(p, aReadOnly) ((p)->lpVtbl->GetReadOnly(p, aReadOnly))
#define IMedium_get_LogicalSize(p, aLogicalSize) ((p)->lpVtbl->GetLogicalSize(p, aLogicalSize))
#define IMedium_GetLogicalSize(p, aLogicalSize) ((p)->lpVtbl->GetLogicalSize(p, aLogicalSize))
#define IMedium_get_AutoReset(p, aAutoReset) ((p)->lpVtbl->GetAutoReset(p, aAutoReset))
#define IMedium_GetAutoReset(p, aAutoReset) ((p)->lpVtbl->GetAutoReset(p, aAutoReset))
#define IMedium_put_AutoReset(p, aAutoReset) ((p)->lpVtbl->SetAutoReset(p, aAutoReset))
#define IMedium_SetAutoReset(p, aAutoReset) ((p)->lpVtbl->SetAutoReset(p, aAutoReset))
#define IMedium_get_LastAccessError(p, aLastAccessError) ((p)->lpVtbl->GetLastAccessError(p, aLastAccessError))
#define IMedium_GetLastAccessError(p, aLastAccessError) ((p)->lpVtbl->GetLastAccessError(p, aLastAccessError))
#define IMedium_get_MachineIds(p, aMachineIds) ((p)->lpVtbl->GetMachineIds(p, aMachineIds))
#define IMedium_GetMachineIds(p, aMachineIds) ((p)->lpVtbl->GetMachineIds(p, aMachineIds))
#define IMedium_SetIds(p, aSetImageId, aImageId, aSetParentId, aParentId) ((p)->lpVtbl->SetIds(p, aSetImageId, aImageId, aSetParentId, aParentId))
#define IMedium_RefreshState(p, aState) ((p)->lpVtbl->RefreshState(p, aState))
#define IMedium_GetSnapshotIds(p, aMachineId, aSnapshotIds) ((p)->lpVtbl->GetSnapshotIds(p, aMachineId, aSnapshotIds))
#define IMedium_LockRead(p, aToken) ((p)->lpVtbl->LockRead(p, aToken))
#define IMedium_LockWrite(p, aToken) ((p)->lpVtbl->LockWrite(p, aToken))
#define IMedium_Close(p) ((p)->lpVtbl->Close(p))
#define IMedium_GetProperty(p, aName, aValue) ((p)->lpVtbl->GetProperty(p, aName, aValue))
#define IMedium_SetProperty(p, aName, aValue) ((p)->lpVtbl->SetProperty(p, aName, aValue))
#define IMedium_GetProperties(p, aNames, aReturnNames, aReturnValues) ((p)->lpVtbl->GetProperties(p, aNames, aReturnNames, aReturnValues))
#define IMedium_SetProperties(p, aNames, aValues) ((p)->lpVtbl->SetProperties(p, aNames, aValues))
#define IMedium_CreateBaseStorage(p, aLogicalSize, aVariant, aProgress) ((p)->lpVtbl->CreateBaseStorage(p, aLogicalSize, aVariant, aProgress))
#define IMedium_DeleteStorage(p, aProgress) ((p)->lpVtbl->DeleteStorage(p, aProgress))
#define IMedium_CreateDiffStorage(p, aTarget, aVariant, aProgress) ((p)->lpVtbl->CreateDiffStorage(p, aTarget, aVariant, aProgress))
#define IMedium_MergeTo(p, aTarget, aProgress) ((p)->lpVtbl->MergeTo(p, aTarget, aProgress))
#define IMedium_CloneTo(p, aTarget, aVariant, aParent, aProgress) ((p)->lpVtbl->CloneTo(p, aTarget, aVariant, aParent, aProgress))
#define IMedium_CloneToBase(p, aTarget, aVariant, aProgress) ((p)->lpVtbl->CloneToBase(p, aTarget, aVariant, aProgress))
#define IMedium_MoveTo(p, aLocation, aProgress) ((p)->lpVtbl->MoveTo(p, aLocation, aProgress))
#define IMedium_Compact(p, aProgress) ((p)->lpVtbl->Compact(p, aProgress))
#define IMedium_Resize(p, aLogicalSize, aProgress) ((p)->lpVtbl->Resize(p, aLogicalSize, aProgress))
#define IMedium_Reset(p, aProgress) ((p)->lpVtbl->Reset(p, aProgress))
#define IMedium_ChangeEncryption(p, aCurrentPassword, aCipher, aNewPassword, aNewPasswordId, aProgress) ((p)->lpVtbl->ChangeEncryption(p, aCurrentPassword, aCipher, aNewPassword, aNewPasswordId, aProgress))
#define IMedium_GetEncryptionSettings(p, aCipher, aPasswordId) ((p)->lpVtbl->GetEncryptionSettings(p, aCipher, aPasswordId))
#define IMedium_CheckEncryptionPassword(p, aPassword) ((p)->lpVtbl->CheckEncryptionPassword(p, aPassword))
#define IMedium_OpenForIO(p, aWritable, aPassword, aMediumIO) ((p)->lpVtbl->OpenForIO(p, aWritable, aPassword, aMediumIO))
#define IMedium_ResizeAndCloneTo(p, aTarget, aLogicalSize, aVariant, aParent, aProgress) ((p)->lpVtbl->ResizeAndCloneTo(p, aTarget, aLogicalSize, aVariant, aParent, aProgress))
#endif /* VBOX_WITH_GLUE */

interface IMedium
{
#ifndef VBOX_WITH_GLUE
    struct IMedium_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IMediumVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IMedium declaration */


/* Start of struct IMediumFormat declaration */
#define IMEDIUMFORMAT_IID_STR "11be93c7-a862-4dc9-8c89-bf4ba74a886a"
#define IMEDIUMFORMAT_IID { \
    0x11be93c7, 0xa862, 0x4dc9, \
    { 0x8c, 0x89, 0xbf, 0x4b, 0xa7, 0x4a, 0x88, 0x6a } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IMediumFormat);
#ifndef VBOX_WITH_GLUE
struct IMediumFormat_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetId)(IMediumFormat *pThis, PRUnichar * *id);

    nsresult (*GetName)(IMediumFormat *pThis, PRUnichar * *name);

    nsresult (*GetCapabilities)(IMediumFormat *pThis, PRUint32 *capabilitiesSize, PRUint32 **capabilities);

    nsresult (*GetInternalAndReservedAttribute1IMediumFormat)(IMediumFormat *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMediumFormat)(IMediumFormat *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMediumFormat)(IMediumFormat *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMediumFormat)(IMediumFormat *pThis, PRUint32 *reserved);

    nsresult (*DescribeFileExtensions)(
        IMediumFormat *pThis,
        PRUint32 *extensionsSize,
        PRUnichar *** extensions,
        PRUint32 *typesSize,
        PRUint32** types
    );

    nsresult (*DescribeProperties)(
        IMediumFormat *pThis,
        PRUint32 *namesSize,
        PRUnichar *** names,
        PRUint32 *descriptionsSize,
        PRUnichar *** descriptions,
        PRUint32 *typesSize,
        PRUint32** types,
        PRUint32 *flagsSize,
        PRUint32** flags,
        PRUint32 *defaultsSize,
        PRUnichar *** defaults
    );

    nsresult (*InternalAndReservedMethod1IMediumFormat)(IMediumFormat *pThis);

    nsresult (*InternalAndReservedMethod2IMediumFormat)(IMediumFormat *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IMediumFormatVtbl
{
    nsresult (*QueryInterface)(IMediumFormat *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IMediumFormat *pThis);
    nsrefcnt (*Release)(IMediumFormat *pThis);
    nsresult (*GetId)(IMediumFormat *pThis, PRUnichar * *id);

    nsresult (*GetName)(IMediumFormat *pThis, PRUnichar * *name);

    nsresult (*GetCapabilities)(IMediumFormat *pThis, PRUint32 *capabilitiesSize, PRUint32 **capabilities);

    nsresult (*GetInternalAndReservedAttribute1IMediumFormat)(IMediumFormat *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMediumFormat)(IMediumFormat *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMediumFormat)(IMediumFormat *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMediumFormat)(IMediumFormat *pThis, PRUint32 *reserved);

    nsresult (*DescribeFileExtensions)(
        IMediumFormat *pThis,
        PRUint32 *extensionsSize,
        PRUnichar *** extensions,
        PRUint32 *typesSize,
        PRUint32** types
    );

    nsresult (*DescribeProperties)(
        IMediumFormat *pThis,
        PRUint32 *namesSize,
        PRUnichar *** names,
        PRUint32 *descriptionsSize,
        PRUnichar *** descriptions,
        PRUint32 *typesSize,
        PRUint32** types,
        PRUint32 *flagsSize,
        PRUint32** flags,
        PRUint32 *defaultsSize,
        PRUnichar *** defaults
    );

    nsresult (*InternalAndReservedMethod1IMediumFormat)(IMediumFormat *pThis);

    nsresult (*InternalAndReservedMethod2IMediumFormat)(IMediumFormat *pThis);

};
#define IMediumFormat_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IMediumFormat_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IMediumFormat_Release(p) ((p)->lpVtbl->Release(p))
#define IMediumFormat_get_Id(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IMediumFormat_GetId(p, aId) ((p)->lpVtbl->GetId(p, aId))
#define IMediumFormat_get_Name(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IMediumFormat_GetName(p, aName) ((p)->lpVtbl->GetName(p, aName))
#define IMediumFormat_get_Capabilities(p, aCapabilities) ((p)->lpVtbl->GetCapabilities(p, aCapabilities))
#define IMediumFormat_GetCapabilities(p, aCapabilities) ((p)->lpVtbl->GetCapabilities(p, aCapabilities))
#define IMediumFormat_DescribeFileExtensions(p, aExtensions, aTypes) ((p)->lpVtbl->DescribeFileExtensions(p, aExtensions, aTypes))
#define IMediumFormat_DescribeProperties(p, aNames, aDescriptions, aTypes, aFlags, aDefaults) ((p)->lpVtbl->DescribeProperties(p, aNames, aDescriptions, aTypes, aFlags, aDefaults))
#endif /* VBOX_WITH_GLUE */

interface IMediumFormat
{
#ifndef VBOX_WITH_GLUE
    struct IMediumFormat_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IMediumFormatVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IMediumFormat declaration */


/* Start of struct IDataStream declaration */
#define IDATASTREAM_IID_STR "a338ed20-58d9-43ae-8b03-c1fd7088ef15"
#define IDATASTREAM_IID { \
    0xa338ed20, 0x58d9, 0x43ae, \
    { 0x8b, 0x03, 0xc1, 0xfd, 0x70, 0x88, 0xef, 0x15 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDataStream);
#ifndef VBOX_WITH_GLUE
struct IDataStream_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetReadSize)(IDataStream *pThis, PRUint32 *readSize);

    nsresult (*GetInternalAndReservedAttribute1IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*Read)(
        IDataStream *pThis,
        PRUint32 size,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*InternalAndReservedMethod1IDataStream)(IDataStream *pThis);

    nsresult (*InternalAndReservedMethod2IDataStream)(IDataStream *pThis);

    nsresult (*InternalAndReservedMethod3IDataStream)(IDataStream *pThis);

    nsresult (*InternalAndReservedMethod4IDataStream)(IDataStream *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDataStreamVtbl
{
    nsresult (*QueryInterface)(IDataStream *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDataStream *pThis);
    nsrefcnt (*Release)(IDataStream *pThis);
    nsresult (*GetReadSize)(IDataStream *pThis, PRUint32 *readSize);

    nsresult (*GetInternalAndReservedAttribute1IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDataStream)(IDataStream *pThis, PRUint32 *reserved);

    nsresult (*Read)(
        IDataStream *pThis,
        PRUint32 size,
        PRUint32 timeoutMS,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*InternalAndReservedMethod1IDataStream)(IDataStream *pThis);

    nsresult (*InternalAndReservedMethod2IDataStream)(IDataStream *pThis);

    nsresult (*InternalAndReservedMethod3IDataStream)(IDataStream *pThis);

    nsresult (*InternalAndReservedMethod4IDataStream)(IDataStream *pThis);

};
#define IDataStream_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDataStream_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDataStream_Release(p) ((p)->lpVtbl->Release(p))
#define IDataStream_get_ReadSize(p, aReadSize) ((p)->lpVtbl->GetReadSize(p, aReadSize))
#define IDataStream_GetReadSize(p, aReadSize) ((p)->lpVtbl->GetReadSize(p, aReadSize))
#define IDataStream_Read(p, aSize, aTimeoutMS, aData) ((p)->lpVtbl->Read(p, aSize, aTimeoutMS, aData))
#endif /* VBOX_WITH_GLUE */

interface IDataStream
{
#ifndef VBOX_WITH_GLUE
    struct IDataStream_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDataStreamVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDataStream declaration */


/* Start of struct IMediumIO declaration */
#define IMEDIUMIO_IID_STR "e4b301a9-5f86-4d65-ad1b-87ca284fb1c8"
#define IMEDIUMIO_IID { \
    0xe4b301a9, 0x5f86, 0x4d65, \
    { 0xad, 0x1b, 0x87, 0xca, 0x28, 0x4f, 0xb1, 0xc8 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IMediumIO);
#ifndef VBOX_WITH_GLUE
struct IMediumIO_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetMedium)(IMediumIO *pThis, IMedium * *medium);

    nsresult (*GetWritable)(IMediumIO *pThis, PRBool *writable);

    nsresult (*GetExplorer)(IMediumIO *pThis, IVFSExplorer * *explorer);

    nsresult (*GetInternalAndReservedAttribute1IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*Read)(
        IMediumIO *pThis,
        PRInt64 offset,
        PRUint32 size,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*Write)(
        IMediumIO *pThis,
        PRInt64 offset,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 * written
    );

    nsresult (*FormatFAT)(
        IMediumIO *pThis,
        PRBool quick
    );

    nsresult (*InitializePartitionTable)(
        IMediumIO *pThis,
        PRUint32 format,
        PRBool wholeDiskInOneEntry
    );

    nsresult (*ConvertToStream)(
        IMediumIO *pThis,
        PRUnichar * format,
        PRUint32 variantSize,
        PRUint32* variant,
        PRUint32 bufferSize,
        IDataStream * * stream,
        IProgress * * progress
    );

    nsresult (*Close)(IMediumIO *pThis );

    nsresult (*InternalAndReservedMethod1IMediumIO)(IMediumIO *pThis);

    nsresult (*InternalAndReservedMethod2IMediumIO)(IMediumIO *pThis);

    nsresult (*InternalAndReservedMethod3IMediumIO)(IMediumIO *pThis);

    nsresult (*InternalAndReservedMethod4IMediumIO)(IMediumIO *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IMediumIOVtbl
{
    nsresult (*QueryInterface)(IMediumIO *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IMediumIO *pThis);
    nsrefcnt (*Release)(IMediumIO *pThis);
    nsresult (*GetMedium)(IMediumIO *pThis, IMedium * *medium);

    nsresult (*GetWritable)(IMediumIO *pThis, PRBool *writable);

    nsresult (*GetExplorer)(IMediumIO *pThis, IVFSExplorer * *explorer);

    nsresult (*GetInternalAndReservedAttribute1IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IMediumIO)(IMediumIO *pThis, PRUint32 *reserved);

    nsresult (*Read)(
        IMediumIO *pThis,
        PRInt64 offset,
        PRUint32 size,
        PRUint32 *dataSize,
        PRUint8** data
    );

    nsresult (*Write)(
        IMediumIO *pThis,
        PRInt64 offset,
        PRUint32 dataSize,
        PRUint8* data,
        PRUint32 * written
    );

    nsresult (*FormatFAT)(
        IMediumIO *pThis,
        PRBool quick
    );

    nsresult (*InitializePartitionTable)(
        IMediumIO *pThis,
        PRUint32 format,
        PRBool wholeDiskInOneEntry
    );

    nsresult (*ConvertToStream)(
        IMediumIO *pThis,
        PRUnichar * format,
        PRUint32 variantSize,
        PRUint32* variant,
        PRUint32 bufferSize,
        IDataStream * * stream,
        IProgress * * progress
    );

    nsresult (*Close)(IMediumIO *pThis );

    nsresult (*InternalAndReservedMethod1IMediumIO)(IMediumIO *pThis);

    nsresult (*InternalAndReservedMethod2IMediumIO)(IMediumIO *pThis);

    nsresult (*InternalAndReservedMethod3IMediumIO)(IMediumIO *pThis);

    nsresult (*InternalAndReservedMethod4IMediumIO)(IMediumIO *pThis);

};
#define IMediumIO_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IMediumIO_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IMediumIO_Release(p) ((p)->lpVtbl->Release(p))
#define IMediumIO_get_Medium(p, aMedium) ((p)->lpVtbl->GetMedium(p, aMedium))
#define IMediumIO_GetMedium(p, aMedium) ((p)->lpVtbl->GetMedium(p, aMedium))
#define IMediumIO_get_Writable(p, aWritable) ((p)->lpVtbl->GetWritable(p, aWritable))
#define IMediumIO_GetWritable(p, aWritable) ((p)->lpVtbl->GetWritable(p, aWritable))
#define IMediumIO_get_Explorer(p, aExplorer) ((p)->lpVtbl->GetExplorer(p, aExplorer))
#define IMediumIO_GetExplorer(p, aExplorer) ((p)->lpVtbl->GetExplorer(p, aExplorer))
#define IMediumIO_Read(p, aOffset, aSize, aData) ((p)->lpVtbl->Read(p, aOffset, aSize, aData))
#define IMediumIO_Write(p, aOffset, aData, aWritten) ((p)->lpVtbl->Write(p, aOffset, aData, aWritten))
#define IMediumIO_FormatFAT(p, aQuick) ((p)->lpVtbl->FormatFAT(p, aQuick))
#define IMediumIO_InitializePartitionTable(p, aFormat, aWholeDiskInOneEntry) ((p)->lpVtbl->InitializePartitionTable(p, aFormat, aWholeDiskInOneEntry))
#define IMediumIO_ConvertToStream(p, aFormat, aVariant, aBufferSize, aStream, aProgress) ((p)->lpVtbl->ConvertToStream(p, aFormat, aVariant, aBufferSize, aStream, aProgress))
#define IMediumIO_Close(p) ((p)->lpVtbl->Close(p))
#endif /* VBOX_WITH_GLUE */

interface IMediumIO
{
#ifndef VBOX_WITH_GLUE
    struct IMediumIO_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IMediumIOVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IMediumIO declaration */


/* Start of struct IToken declaration */
#define ITOKEN_IID_STR "20479eaf-d8ed-44cf-85ac-c83a26c95a4d"
#define ITOKEN_IID { \
    0x20479eaf, 0xd8ed, 0x44cf, \
    { 0x85, 0xac, 0xc8, 0x3a, 0x26, 0xc9, 0x5a, 0x4d } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IToken);
#ifndef VBOX_WITH_GLUE
struct IToken_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetInternalAndReservedAttribute1IToken)(IToken *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IToken)(IToken *pThis, PRUint32 *reserved);

    nsresult (*Abandon)(IToken *pThis );

    nsresult (*Dummy)(IToken *pThis );

    nsresult (*InternalAndReservedMethod1IToken)(IToken *pThis);

};
#else /* VBOX_WITH_GLUE */
struct ITokenVtbl
{
    nsresult (*QueryInterface)(IToken *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IToken *pThis);
    nsrefcnt (*Release)(IToken *pThis);
    nsresult (*GetInternalAndReservedAttribute1IToken)(IToken *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IToken)(IToken *pThis, PRUint32 *reserved);

    nsresult (*Abandon)(IToken *pThis );

    nsresult (*Dummy)(IToken *pThis );

    nsresult (*InternalAndReservedMethod1IToken)(IToken *pThis);

};
#define IToken_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IToken_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IToken_Release(p) ((p)->lpVtbl->Release(p))
#define IToken_Abandon(p) ((p)->lpVtbl->Abandon(p))
#define IToken_Dummy(p) ((p)->lpVtbl->Dummy(p))
#endif /* VBOX_WITH_GLUE */

interface IToken
{
#ifndef VBOX_WITH_GLUE
    struct IToken_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct ITokenVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IToken declaration */


/* Start of struct IKeyboard declaration */
#define IKEYBOARD_IID_STR "755e6bdf-1640-41f9-bd74-3ef5fd653250"
#define IKEYBOARD_IID { \
    0x755e6bdf, 0x1640, 0x41f9, \
    { 0xbd, 0x74, 0x3e, 0xf5, 0xfd, 0x65, 0x32, 0x50 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IKeyboard);
#ifndef VBOX_WITH_GLUE
struct IKeyboard_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetKeyboardLEDs)(IKeyboard *pThis, PRUint32 *keyboardLEDsSize, PRUint32 **keyboardLEDs);

    nsresult (*GetEventSource)(IKeyboard *pThis, IEventSource * *eventSource);

    nsresult (*GetInternalAndReservedAttribute1IKeyboard)(IKeyboard *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IKeyboard)(IKeyboard *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IKeyboard)(IKeyboard *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IKeyboard)(IKeyboard *pThis, PRUint32 *reserved);

    nsresult (*PutScancode)(
        IKeyboard *pThis,
        PRInt32 scancode
    );

    nsresult (*PutScancodes)(
        IKeyboard *pThis,
        PRUint32 scancodesSize,
        PRInt32* scancodes,
        PRUint32 * codesStored
    );

    nsresult (*PutCAD)(IKeyboard *pThis );

    nsresult (*ReleaseKeys)(IKeyboard *pThis );

    nsresult (*PutUsageCode)(
        IKeyboard *pThis,
        PRInt32 usageCode,
        PRInt32 usagePage,
        PRBool keyRelease
    );

    nsresult (*InternalAndReservedMethod1IKeyboard)(IKeyboard *pThis);

    nsresult (*InternalAndReservedMethod2IKeyboard)(IKeyboard *pThis);

    nsresult (*InternalAndReservedMethod3IKeyboard)(IKeyboard *pThis);

    nsresult (*InternalAndReservedMethod4IKeyboard)(IKeyboard *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IKeyboardVtbl
{
    nsresult (*QueryInterface)(IKeyboard *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IKeyboard *pThis);
    nsrefcnt (*Release)(IKeyboard *pThis);
    nsresult (*GetKeyboardLEDs)(IKeyboard *pThis, PRUint32 *keyboardLEDsSize, PRUint32 **keyboardLEDs);

    nsresult (*GetEventSource)(IKeyboard *pThis, IEventSource * *eventSource);

    nsresult (*GetInternalAndReservedAttribute1IKeyboard)(IKeyboard *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IKeyboard)(IKeyboard *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IKeyboard)(IKeyboard *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IKeyboard)(IKeyboard *pThis, PRUint32 *reserved);

    nsresult (*PutScancode)(
        IKeyboard *pThis,
        PRInt32 scancode
    );

    nsresult (*PutScancodes)(
        IKeyboard *pThis,
        PRUint32 scancodesSize,
        PRInt32* scancodes,
        PRUint32 * codesStored
    );

    nsresult (*PutCAD)(IKeyboard *pThis );

    nsresult (*ReleaseKeys)(IKeyboard *pThis );

    nsresult (*PutUsageCode)(
        IKeyboard *pThis,
        PRInt32 usageCode,
        PRInt32 usagePage,
        PRBool keyRelease
    );

    nsresult (*InternalAndReservedMethod1IKeyboard)(IKeyboard *pThis);

    nsresult (*InternalAndReservedMethod2IKeyboard)(IKeyboard *pThis);

    nsresult (*InternalAndReservedMethod3IKeyboard)(IKeyboard *pThis);

    nsresult (*InternalAndReservedMethod4IKeyboard)(IKeyboard *pThis);

};
#define IKeyboard_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IKeyboard_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IKeyboard_Release(p) ((p)->lpVtbl->Release(p))
#define IKeyboard_get_KeyboardLEDs(p, aKeyboardLEDs) ((p)->lpVtbl->GetKeyboardLEDs(p, aKeyboardLEDs))
#define IKeyboard_GetKeyboardLEDs(p, aKeyboardLEDs) ((p)->lpVtbl->GetKeyboardLEDs(p, aKeyboardLEDs))
#define IKeyboard_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IKeyboard_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IKeyboard_PutScancode(p, aScancode) ((p)->lpVtbl->PutScancode(p, aScancode))
#define IKeyboard_PutScancodes(p, aScancodes, aCodesStored) ((p)->lpVtbl->PutScancodes(p, aScancodes, aCodesStored))
#define IKeyboard_PutCAD(p) ((p)->lpVtbl->PutCAD(p))
#define IKeyboard_ReleaseKeys(p) ((p)->lpVtbl->ReleaseKeys(p))
#define IKeyboard_PutUsageCode(p, aUsageCode, aUsagePage, aKeyRelease) ((p)->lpVtbl->PutUsageCode(p, aUsageCode, aUsagePage, aKeyRelease))
#endif /* VBOX_WITH_GLUE */

interface IKeyboard
{
#ifndef VBOX_WITH_GLUE
    struct IKeyboard_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IKeyboardVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IKeyboard declaration */


/* Start of struct IMousePointerShape declaration */
#define IMOUSEPOINTERSHAPE_IID_STR "1e775ea3-9070-4f9c-b0d5-53054496dbe0"
#define IMOUSEPOINTERSHAPE_IID { \
    0x1e775ea3, 0x9070, 0x4f9c, \
    { 0xb0, 0xd5, 0x53, 0x05, 0x44, 0x96, 0xdb, 0xe0 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IMousePointerShape);
#ifndef VBOX_WITH_GLUE
struct IMousePointerShape_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetVisible)(IMousePointerShape *pThis, PRBool *visible);

    nsresult (*GetAlpha)(IMousePointerShape *pThis, PRBool *alpha);

    nsresult (*GetHotX)(IMousePointerShape *pThis, PRUint32 *hotX);

    nsresult (*GetHotY)(IMousePointerShape *pThis, PRUint32 *hotY);

    nsresult (*GetWidth)(IMousePointerShape *pThis, PRUint32 *width);

    nsresult (*GetHeight)(IMousePointerShape *pThis, PRUint32 *height);

    nsresult (*GetShape)(IMousePointerShape *pThis, PRUint32 *shapeSize, PRUint8 **shape);

    nsresult (*GetInternalAndReservedAttribute1IMousePointerShape)(IMousePointerShape *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMousePointerShape)(IMousePointerShape *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMousePointerShape)(IMousePointerShape *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMousePointerShape)(IMousePointerShape *pThis, PRUint32 *reserved);

};
#else /* VBOX_WITH_GLUE */
struct IMousePointerShapeVtbl
{
    nsresult (*QueryInterface)(IMousePointerShape *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IMousePointerShape *pThis);
    nsrefcnt (*Release)(IMousePointerShape *pThis);
    nsresult (*GetVisible)(IMousePointerShape *pThis, PRBool *visible);

    nsresult (*GetAlpha)(IMousePointerShape *pThis, PRBool *alpha);

    nsresult (*GetHotX)(IMousePointerShape *pThis, PRUint32 *hotX);

    nsresult (*GetHotY)(IMousePointerShape *pThis, PRUint32 *hotY);

    nsresult (*GetWidth)(IMousePointerShape *pThis, PRUint32 *width);

    nsresult (*GetHeight)(IMousePointerShape *pThis, PRUint32 *height);

    nsresult (*GetShape)(IMousePointerShape *pThis, PRUint32 *shapeSize, PRUint8 **shape);

    nsresult (*GetInternalAndReservedAttribute1IMousePointerShape)(IMousePointerShape *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMousePointerShape)(IMousePointerShape *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMousePointerShape)(IMousePointerShape *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMousePointerShape)(IMousePointerShape *pThis, PRUint32 *reserved);

};
#define IMousePointerShape_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IMousePointerShape_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IMousePointerShape_Release(p) ((p)->lpVtbl->Release(p))
#define IMousePointerShape_get_Visible(p, aVisible) ((p)->lpVtbl->GetVisible(p, aVisible))
#define IMousePointerShape_GetVisible(p, aVisible) ((p)->lpVtbl->GetVisible(p, aVisible))
#define IMousePointerShape_get_Alpha(p, aAlpha) ((p)->lpVtbl->GetAlpha(p, aAlpha))
#define IMousePointerShape_GetAlpha(p, aAlpha) ((p)->lpVtbl->GetAlpha(p, aAlpha))
#define IMousePointerShape_get_HotX(p, aHotX) ((p)->lpVtbl->GetHotX(p, aHotX))
#define IMousePointerShape_GetHotX(p, aHotX) ((p)->lpVtbl->GetHotX(p, aHotX))
#define IMousePointerShape_get_HotY(p, aHotY) ((p)->lpVtbl->GetHotY(p, aHotY))
#define IMousePointerShape_GetHotY(p, aHotY) ((p)->lpVtbl->GetHotY(p, aHotY))
#define IMousePointerShape_get_Width(p, aWidth) ((p)->lpVtbl->GetWidth(p, aWidth))
#define IMousePointerShape_GetWidth(p, aWidth) ((p)->lpVtbl->GetWidth(p, aWidth))
#define IMousePointerShape_get_Height(p, aHeight) ((p)->lpVtbl->GetHeight(p, aHeight))
#define IMousePointerShape_GetHeight(p, aHeight) ((p)->lpVtbl->GetHeight(p, aHeight))
#define IMousePointerShape_get_Shape(p, aShape) ((p)->lpVtbl->GetShape(p, aShape))
#define IMousePointerShape_GetShape(p, aShape) ((p)->lpVtbl->GetShape(p, aShape))
#endif /* VBOX_WITH_GLUE */

interface IMousePointerShape
{
#ifndef VBOX_WITH_GLUE
    struct IMousePointerShape_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IMousePointerShapeVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IMousePointerShape declaration */


/* Start of struct IMouse declaration */
#define IMOUSE_IID_STR "25360a74-55e5-4f14-ac2a-f5cf8e62e4af"
#define IMOUSE_IID { \
    0x25360a74, 0x55e5, 0x4f14, \
    { 0xac, 0x2a, 0xf5, 0xcf, 0x8e, 0x62, 0xe4, 0xaf } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IMouse);
#ifndef VBOX_WITH_GLUE
struct IMouse_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetAbsoluteSupported)(IMouse *pThis, PRBool *absoluteSupported);

    nsresult (*GetRelativeSupported)(IMouse *pThis, PRBool *relativeSupported);

    nsresult (*GetTouchScreenSupported)(IMouse *pThis, PRBool *touchScreenSupported);

    nsresult (*GetTouchPadSupported)(IMouse *pThis, PRBool *touchPadSupported);

    nsresult (*GetNeedsHostCursor)(IMouse *pThis, PRBool *needsHostCursor);

    nsresult (*GetPointerShape)(IMouse *pThis, IMousePointerShape * *pointerShape);

    nsresult (*GetEventSource)(IMouse *pThis, IEventSource * *eventSource);

    nsresult (*GetInternalAndReservedAttribute1IMouse)(IMouse *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMouse)(IMouse *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMouse)(IMouse *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMouse)(IMouse *pThis, PRUint32 *reserved);

    nsresult (*PutMouseEvent)(
        IMouse *pThis,
        PRInt32 dx,
        PRInt32 dy,
        PRInt32 dz,
        PRInt32 dw,
        PRInt32 buttonState
    );

    nsresult (*PutMouseEventAbsolute)(
        IMouse *pThis,
        PRInt32 x,
        PRInt32 y,
        PRInt32 dz,
        PRInt32 dw,
        PRInt32 buttonState
    );

    nsresult (*PutEventMultiTouch)(
        IMouse *pThis,
        PRInt32 count,
        PRUint32 contactsSize,
        PRInt64* contacts,
        PRBool isTouchScreen,
        PRUint32 scanTime
    );

    nsresult (*PutEventMultiTouchString)(
        IMouse *pThis,
        PRInt32 count,
        PRUnichar * contacts,
        PRBool isTouchScreen,
        PRUint32 scanTime
    );

    nsresult (*InternalAndReservedMethod1IMouse)(IMouse *pThis);

    nsresult (*InternalAndReservedMethod2IMouse)(IMouse *pThis);

    nsresult (*InternalAndReservedMethod3IMouse)(IMouse *pThis);

    nsresult (*InternalAndReservedMethod4IMouse)(IMouse *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IMouseVtbl
{
    nsresult (*QueryInterface)(IMouse *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IMouse *pThis);
    nsrefcnt (*Release)(IMouse *pThis);
    nsresult (*GetAbsoluteSupported)(IMouse *pThis, PRBool *absoluteSupported);

    nsresult (*GetRelativeSupported)(IMouse *pThis, PRBool *relativeSupported);

    nsresult (*GetTouchScreenSupported)(IMouse *pThis, PRBool *touchScreenSupported);

    nsresult (*GetTouchPadSupported)(IMouse *pThis, PRBool *touchPadSupported);

    nsresult (*GetNeedsHostCursor)(IMouse *pThis, PRBool *needsHostCursor);

    nsresult (*GetPointerShape)(IMouse *pThis, IMousePointerShape * *pointerShape);

    nsresult (*GetEventSource)(IMouse *pThis, IEventSource * *eventSource);

    nsresult (*GetInternalAndReservedAttribute1IMouse)(IMouse *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IMouse)(IMouse *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IMouse)(IMouse *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IMouse)(IMouse *pThis, PRUint32 *reserved);

    nsresult (*PutMouseEvent)(
        IMouse *pThis,
        PRInt32 dx,
        PRInt32 dy,
        PRInt32 dz,
        PRInt32 dw,
        PRInt32 buttonState
    );

    nsresult (*PutMouseEventAbsolute)(
        IMouse *pThis,
        PRInt32 x,
        PRInt32 y,
        PRInt32 dz,
        PRInt32 dw,
        PRInt32 buttonState
    );

    nsresult (*PutEventMultiTouch)(
        IMouse *pThis,
        PRInt32 count,
        PRUint32 contactsSize,
        PRInt64* contacts,
        PRBool isTouchScreen,
        PRUint32 scanTime
    );

    nsresult (*PutEventMultiTouchString)(
        IMouse *pThis,
        PRInt32 count,
        PRUnichar * contacts,
        PRBool isTouchScreen,
        PRUint32 scanTime
    );

    nsresult (*InternalAndReservedMethod1IMouse)(IMouse *pThis);

    nsresult (*InternalAndReservedMethod2IMouse)(IMouse *pThis);

    nsresult (*InternalAndReservedMethod3IMouse)(IMouse *pThis);

    nsresult (*InternalAndReservedMethod4IMouse)(IMouse *pThis);

};
#define IMouse_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IMouse_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IMouse_Release(p) ((p)->lpVtbl->Release(p))
#define IMouse_get_AbsoluteSupported(p, aAbsoluteSupported) ((p)->lpVtbl->GetAbsoluteSupported(p, aAbsoluteSupported))
#define IMouse_GetAbsoluteSupported(p, aAbsoluteSupported) ((p)->lpVtbl->GetAbsoluteSupported(p, aAbsoluteSupported))
#define IMouse_get_RelativeSupported(p, aRelativeSupported) ((p)->lpVtbl->GetRelativeSupported(p, aRelativeSupported))
#define IMouse_GetRelativeSupported(p, aRelativeSupported) ((p)->lpVtbl->GetRelativeSupported(p, aRelativeSupported))
#define IMouse_get_TouchScreenSupported(p, aTouchScreenSupported) ((p)->lpVtbl->GetTouchScreenSupported(p, aTouchScreenSupported))
#define IMouse_GetTouchScreenSupported(p, aTouchScreenSupported) ((p)->lpVtbl->GetTouchScreenSupported(p, aTouchScreenSupported))
#define IMouse_get_TouchPadSupported(p, aTouchPadSupported) ((p)->lpVtbl->GetTouchPadSupported(p, aTouchPadSupported))
#define IMouse_GetTouchPadSupported(p, aTouchPadSupported) ((p)->lpVtbl->GetTouchPadSupported(p, aTouchPadSupported))
#define IMouse_get_NeedsHostCursor(p, aNeedsHostCursor) ((p)->lpVtbl->GetNeedsHostCursor(p, aNeedsHostCursor))
#define IMouse_GetNeedsHostCursor(p, aNeedsHostCursor) ((p)->lpVtbl->GetNeedsHostCursor(p, aNeedsHostCursor))
#define IMouse_get_PointerShape(p, aPointerShape) ((p)->lpVtbl->GetPointerShape(p, aPointerShape))
#define IMouse_GetPointerShape(p, aPointerShape) ((p)->lpVtbl->GetPointerShape(p, aPointerShape))
#define IMouse_get_EventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IMouse_GetEventSource(p, aEventSource) ((p)->lpVtbl->GetEventSource(p, aEventSource))
#define IMouse_PutMouseEvent(p, aDx, aDy, aDz, aDw, aButtonState) ((p)->lpVtbl->PutMouseEvent(p, aDx, aDy, aDz, aDw, aButtonState))
#define IMouse_PutMouseEventAbsolute(p, aX, aY, aDz, aDw, aButtonState) ((p)->lpVtbl->PutMouseEventAbsolute(p, aX, aY, aDz, aDw, aButtonState))
#define IMouse_PutEventMultiTouch(p, aCount, aContacts, aIsTouchScreen, aScanTime) ((p)->lpVtbl->PutEventMultiTouch(p, aCount, aContacts, aIsTouchScreen, aScanTime))
#define IMouse_PutEventMultiTouchString(p, aCount, aContacts, aIsTouchScreen, aScanTime) ((p)->lpVtbl->PutEventMultiTouchString(p, aCount, aContacts, aIsTouchScreen, aScanTime))
#endif /* VBOX_WITH_GLUE */

interface IMouse
{
#ifndef VBOX_WITH_GLUE
    struct IMouse_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IMouseVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IMouse declaration */


/* Start of struct IDisplaySourceBitmap declaration */
#define IDISPLAYSOURCEBITMAP_IID_STR "5094f67a-8084-11e9-b185-dbe296e54799"
#define IDISPLAYSOURCEBITMAP_IID { \
    0x5094f67a, 0x8084, 0x11e9, \
    { 0xb1, 0x85, 0xdb, 0xe2, 0x96, 0xe5, 0x47, 0x99 } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDisplaySourceBitmap);
#ifndef VBOX_WITH_GLUE
struct IDisplaySourceBitmap_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetScreenId)(IDisplaySourceBitmap *pThis, PRUint32 *screenId);

    nsresult (*QueryBitmapInfo)(
        IDisplaySourceBitmap *pThis,
        PRUint8 * * address,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 * bitsPerPixel,
        PRUint32 * bytesPerLine,
        PRUint32 * bitmapFormat
    );

};
#else /* VBOX_WITH_GLUE */
struct IDisplaySourceBitmapVtbl
{
    nsresult (*QueryInterface)(IDisplaySourceBitmap *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDisplaySourceBitmap *pThis);
    nsrefcnt (*Release)(IDisplaySourceBitmap *pThis);
    nsresult (*GetScreenId)(IDisplaySourceBitmap *pThis, PRUint32 *screenId);

    nsresult (*QueryBitmapInfo)(
        IDisplaySourceBitmap *pThis,
        PRUint8 * * address,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 * bitsPerPixel,
        PRUint32 * bytesPerLine,
        PRUint32 * bitmapFormat
    );

};
#define IDisplaySourceBitmap_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDisplaySourceBitmap_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDisplaySourceBitmap_Release(p) ((p)->lpVtbl->Release(p))
#define IDisplaySourceBitmap_get_ScreenId(p, aScreenId) ((p)->lpVtbl->GetScreenId(p, aScreenId))
#define IDisplaySourceBitmap_GetScreenId(p, aScreenId) ((p)->lpVtbl->GetScreenId(p, aScreenId))
#define IDisplaySourceBitmap_QueryBitmapInfo(p, aAddress, aWidth, aHeight, aBitsPerPixel, aBytesPerLine, aBitmapFormat) ((p)->lpVtbl->QueryBitmapInfo(p, aAddress, aWidth, aHeight, aBitsPerPixel, aBytesPerLine, aBitmapFormat))
#endif /* VBOX_WITH_GLUE */

interface IDisplaySourceBitmap
{
#ifndef VBOX_WITH_GLUE
    struct IDisplaySourceBitmap_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IDisplaySourceBitmapVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IDisplaySourceBitmap declaration */


/* Start of struct IFramebuffer declaration */
#define IFRAMEBUFFER_IID_STR "1e8d3f27-b45c-48ae-8b36-d35e83d207aa"
#define IFRAMEBUFFER_IID { \
    0x1e8d3f27, 0xb45c, 0x48ae, \
    { 0x8b, 0x36, 0xd3, 0x5e, 0x83, 0xd2, 0x07, 0xaa } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IFramebuffer);
#ifndef VBOX_WITH_GLUE
struct IFramebuffer_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetWidth)(IFramebuffer *pThis, PRUint32 *width);

    nsresult (*GetHeight)(IFramebuffer *pThis, PRUint32 *height);

    nsresult (*GetBitsPerPixel)(IFramebuffer *pThis, PRUint32 *bitsPerPixel);

    nsresult (*GetBytesPerLine)(IFramebuffer *pThis, PRUint32 *bytesPerLine);

    nsresult (*GetPixelFormat)(IFramebuffer *pThis, PRUint32 *pixelFormat);

    nsresult (*GetHeightReduction)(IFramebuffer *pThis, PRUint32 *heightReduction);

    nsresult (*GetOverlay)(IFramebuffer *pThis, IFramebufferOverlay * *overlay);

    nsresult (*GetWinId)(IFramebuffer *pThis, PRInt64 *winId);

    nsresult (*GetCapabilities)(IFramebuffer *pThis, PRUint32 *capabilitiesSize, PRUint32 **capabilities);

    nsresult (*NotifyUpdate)(
        IFramebuffer *pThis,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*NotifyUpdateImage)(
        IFramebuffer *pThis,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height,
        PRUint32 imageSize,
        PRUint8* image
    );

    nsresult (*NotifyChange)(
        IFramebuffer *pThis,
        PRUint32 screenId,
        PRUint32 xOrigin,
        PRUint32 yOrigin,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*VideoModeSupported)(
        IFramebuffer *pThis,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bpp,
        PRBool * supported
    );

    nsresult (*GetVisibleRegion)(
        IFramebuffer *pThis,
        PRUint8 * rectangles,
        PRUint32 count,
        PRUint32 * countCopied
    );

    nsresult (*SetVisibleRegion)(
        IFramebuffer *pThis,
        PRUint8 * rectangles,
        PRUint32 count
    );

    nsresult (*ProcessVHWACommand)(
        IFramebuffer *pThis,
        PRUint8 * command,
        PRInt32 enmCmd,
        PRBool fromGuest
    );

    nsresult (*Notify3DEvent)(
        IFramebuffer *pThis,
        PRUint32 type,
        PRUint32 dataSize,
        PRUint8* data
    );

};
#else /* VBOX_WITH_GLUE */
struct IFramebufferVtbl
{
    nsresult (*QueryInterface)(IFramebuffer *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IFramebuffer *pThis);
    nsrefcnt (*Release)(IFramebuffer *pThis);
    nsresult (*GetWidth)(IFramebuffer *pThis, PRUint32 *width);

    nsresult (*GetHeight)(IFramebuffer *pThis, PRUint32 *height);

    nsresult (*GetBitsPerPixel)(IFramebuffer *pThis, PRUint32 *bitsPerPixel);

    nsresult (*GetBytesPerLine)(IFramebuffer *pThis, PRUint32 *bytesPerLine);

    nsresult (*GetPixelFormat)(IFramebuffer *pThis, PRUint32 *pixelFormat);

    nsresult (*GetHeightReduction)(IFramebuffer *pThis, PRUint32 *heightReduction);

    nsresult (*GetOverlay)(IFramebuffer *pThis, IFramebufferOverlay * *overlay);

    nsresult (*GetWinId)(IFramebuffer *pThis, PRInt64 *winId);

    nsresult (*GetCapabilities)(IFramebuffer *pThis, PRUint32 *capabilitiesSize, PRUint32 **capabilities);

    nsresult (*NotifyUpdate)(
        IFramebuffer *pThis,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*NotifyUpdateImage)(
        IFramebuffer *pThis,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height,
        PRUint32 imageSize,
        PRUint8* image
    );

    nsresult (*NotifyChange)(
        IFramebuffer *pThis,
        PRUint32 screenId,
        PRUint32 xOrigin,
        PRUint32 yOrigin,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*VideoModeSupported)(
        IFramebuffer *pThis,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bpp,
        PRBool * supported
    );

    nsresult (*GetVisibleRegion)(
        IFramebuffer *pThis,
        PRUint8 * rectangles,
        PRUint32 count,
        PRUint32 * countCopied
    );

    nsresult (*SetVisibleRegion)(
        IFramebuffer *pThis,
        PRUint8 * rectangles,
        PRUint32 count
    );

    nsresult (*ProcessVHWACommand)(
        IFramebuffer *pThis,
        PRUint8 * command,
        PRInt32 enmCmd,
        PRBool fromGuest
    );

    nsresult (*Notify3DEvent)(
        IFramebuffer *pThis,
        PRUint32 type,
        PRUint32 dataSize,
        PRUint8* data
    );

};
#define IFramebuffer_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IFramebuffer_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IFramebuffer_Release(p) ((p)->lpVtbl->Release(p))
#define IFramebuffer_get_Width(p, aWidth) ((p)->lpVtbl->GetWidth(p, aWidth))
#define IFramebuffer_GetWidth(p, aWidth) ((p)->lpVtbl->GetWidth(p, aWidth))
#define IFramebuffer_get_Height(p, aHeight) ((p)->lpVtbl->GetHeight(p, aHeight))
#define IFramebuffer_GetHeight(p, aHeight) ((p)->lpVtbl->GetHeight(p, aHeight))
#define IFramebuffer_get_BitsPerPixel(p, aBitsPerPixel) ((p)->lpVtbl->GetBitsPerPixel(p, aBitsPerPixel))
#define IFramebuffer_GetBitsPerPixel(p, aBitsPerPixel) ((p)->lpVtbl->GetBitsPerPixel(p, aBitsPerPixel))
#define IFramebuffer_get_BytesPerLine(p, aBytesPerLine) ((p)->lpVtbl->GetBytesPerLine(p, aBytesPerLine))
#define IFramebuffer_GetBytesPerLine(p, aBytesPerLine) ((p)->lpVtbl->GetBytesPerLine(p, aBytesPerLine))
#define IFramebuffer_get_PixelFormat(p, aPixelFormat) ((p)->lpVtbl->GetPixelFormat(p, aPixelFormat))
#define IFramebuffer_GetPixelFormat(p, aPixelFormat) ((p)->lpVtbl->GetPixelFormat(p, aPixelFormat))
#define IFramebuffer_get_HeightReduction(p, aHeightReduction) ((p)->lpVtbl->GetHeightReduction(p, aHeightReduction))
#define IFramebuffer_GetHeightReduction(p, aHeightReduction) ((p)->lpVtbl->GetHeightReduction(p, aHeightReduction))
#define IFramebuffer_get_Overlay(p, aOverlay) ((p)->lpVtbl->GetOverlay(p, aOverlay))
#define IFramebuffer_GetOverlay(p, aOverlay) ((p)->lpVtbl->GetOverlay(p, aOverlay))
#define IFramebuffer_get_WinId(p, aWinId) ((p)->lpVtbl->GetWinId(p, aWinId))
#define IFramebuffer_GetWinId(p, aWinId) ((p)->lpVtbl->GetWinId(p, aWinId))
#define IFramebuffer_get_Capabilities(p, aCapabilities) ((p)->lpVtbl->GetCapabilities(p, aCapabilities))
#define IFramebuffer_GetCapabilities(p, aCapabilities) ((p)->lpVtbl->GetCapabilities(p, aCapabilities))
#define IFramebuffer_NotifyUpdate(p, aX, aY, aWidth, aHeight) ((p)->lpVtbl->NotifyUpdate(p, aX, aY, aWidth, aHeight))
#define IFramebuffer_NotifyUpdateImage(p, aX, aY, aWidth, aHeight, aImage) ((p)->lpVtbl->NotifyUpdateImage(p, aX, aY, aWidth, aHeight, aImage))
#define IFramebuffer_NotifyChange(p, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight) ((p)->lpVtbl->NotifyChange(p, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight))
#define IFramebuffer_VideoModeSupported(p, aWidth, aHeight, aBpp, aSupported) ((p)->lpVtbl->VideoModeSupported(p, aWidth, aHeight, aBpp, aSupported))
#define IFramebuffer_GetVisibleRegion(p, aRectangles, aCount, aCountCopied) ((p)->lpVtbl->GetVisibleRegion(p, aRectangles, aCount, aCountCopied))
#define IFramebuffer_SetVisibleRegion(p, aRectangles, aCount) ((p)->lpVtbl->SetVisibleRegion(p, aRectangles, aCount))
#define IFramebuffer_ProcessVHWACommand(p, aCommand, aEnmCmd, aFromGuest) ((p)->lpVtbl->ProcessVHWACommand(p, aCommand, aEnmCmd, aFromGuest))
#define IFramebuffer_Notify3DEvent(p, aType, aData) ((p)->lpVtbl->Notify3DEvent(p, aType, aData))
#endif /* VBOX_WITH_GLUE */

interface IFramebuffer
{
#ifndef VBOX_WITH_GLUE
    struct IFramebuffer_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IFramebufferVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IFramebuffer declaration */


/* Start of struct IFramebufferOverlay declaration */
#define IFRAMEBUFFEROVERLAY_IID_STR "af398a9a-6b76-4805-8fab-00a9dcf4732b"
#define IFRAMEBUFFEROVERLAY_IID { \
    0xaf398a9a, 0x6b76, 0x4805, \
    { 0x8f, 0xab, 0x00, 0xa9, 0xdc, 0xf4, 0x73, 0x2b } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IFramebufferOverlay);
#ifndef VBOX_WITH_GLUE
struct IFramebufferOverlay_vtbl
{
    struct IFramebuffer_vtbl iframebuffer;

    nsresult (*GetX)(IFramebufferOverlay *pThis, PRUint32 *x);

    nsresult (*GetY)(IFramebufferOverlay *pThis, PRUint32 *y);

    nsresult (*GetVisible)(IFramebufferOverlay *pThis, PRBool *visible);
    nsresult (*SetVisible)(IFramebufferOverlay *pThis, PRBool visible);

    nsresult (*GetAlpha)(IFramebufferOverlay *pThis, PRUint32 *alpha);
    nsresult (*SetAlpha)(IFramebufferOverlay *pThis, PRUint32 alpha);

    nsresult (*Move)(
        IFramebufferOverlay *pThis,
        PRUint32 x,
        PRUint32 y
    );

};
#else /* VBOX_WITH_GLUE */
struct IFramebufferOverlayVtbl
{
    nsresult (*QueryInterface)(IFramebufferOverlay *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IFramebufferOverlay *pThis);
    nsrefcnt (*Release)(IFramebufferOverlay *pThis);
    nsresult (*GetWidth)(IFramebufferOverlay *pThis, PRUint32 *width);

    nsresult (*GetHeight)(IFramebufferOverlay *pThis, PRUint32 *height);

    nsresult (*GetBitsPerPixel)(IFramebufferOverlay *pThis, PRUint32 *bitsPerPixel);

    nsresult (*GetBytesPerLine)(IFramebufferOverlay *pThis, PRUint32 *bytesPerLine);

    nsresult (*GetPixelFormat)(IFramebufferOverlay *pThis, PRUint32 *pixelFormat);

    nsresult (*GetHeightReduction)(IFramebufferOverlay *pThis, PRUint32 *heightReduction);

    nsresult (*GetOverlay)(IFramebufferOverlay *pThis, IFramebufferOverlay * *overlay);

    nsresult (*GetWinId)(IFramebufferOverlay *pThis, PRInt64 *winId);

    nsresult (*GetCapabilities)(IFramebufferOverlay *pThis, PRUint32 *capabilitiesSize, PRUint32 **capabilities);

    nsresult (*NotifyUpdate)(
        IFramebufferOverlay *pThis,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*NotifyUpdateImage)(
        IFramebufferOverlay *pThis,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height,
        PRUint32 imageSize,
        PRUint8* image
    );

    nsresult (*NotifyChange)(
        IFramebufferOverlay *pThis,
        PRUint32 screenId,
        PRUint32 xOrigin,
        PRUint32 yOrigin,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*VideoModeSupported)(
        IFramebufferOverlay *pThis,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bpp,
        PRBool * supported
    );

    nsresult (*GetVisibleRegion)(
        IFramebufferOverlay *pThis,
        PRUint8 * rectangles,
        PRUint32 count,
        PRUint32 * countCopied
    );

    nsresult (*SetVisibleRegion)(
        IFramebufferOverlay *pThis,
        PRUint8 * rectangles,
        PRUint32 count
    );

    nsresult (*ProcessVHWACommand)(
        IFramebufferOverlay *pThis,
        PRUint8 * command,
        PRInt32 enmCmd,
        PRBool fromGuest
    );

    nsresult (*Notify3DEvent)(
        IFramebufferOverlay *pThis,
        PRUint32 type,
        PRUint32 dataSize,
        PRUint8* data
    );

    nsresult (*GetX)(IFramebufferOverlay *pThis, PRUint32 *x);

    nsresult (*GetY)(IFramebufferOverlay *pThis, PRUint32 *y);

    nsresult (*GetVisible)(IFramebufferOverlay *pThis, PRBool *visible);
    nsresult (*SetVisible)(IFramebufferOverlay *pThis, PRBool visible);

    nsresult (*GetAlpha)(IFramebufferOverlay *pThis, PRUint32 *alpha);
    nsresult (*SetAlpha)(IFramebufferOverlay *pThis, PRUint32 alpha);

    nsresult (*Move)(
        IFramebufferOverlay *pThis,
        PRUint32 x,
        PRUint32 y
    );

};
#define IFramebufferOverlay_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IFramebufferOverlay_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IFramebufferOverlay_Release(p) ((p)->lpVtbl->Release(p))
#define IFramebufferOverlay_get_Width(p, aWidth) ((p)->lpVtbl->GetWidth(p, aWidth))
#define IFramebufferOverlay_GetWidth(p, aWidth) ((p)->lpVtbl->GetWidth(p, aWidth))
#define IFramebufferOverlay_get_Height(p, aHeight) ((p)->lpVtbl->GetHeight(p, aHeight))
#define IFramebufferOverlay_GetHeight(p, aHeight) ((p)->lpVtbl->GetHeight(p, aHeight))
#define IFramebufferOverlay_get_BitsPerPixel(p, aBitsPerPixel) ((p)->lpVtbl->GetBitsPerPixel(p, aBitsPerPixel))
#define IFramebufferOverlay_GetBitsPerPixel(p, aBitsPerPixel) ((p)->lpVtbl->GetBitsPerPixel(p, aBitsPerPixel))
#define IFramebufferOverlay_get_BytesPerLine(p, aBytesPerLine) ((p)->lpVtbl->GetBytesPerLine(p, aBytesPerLine))
#define IFramebufferOverlay_GetBytesPerLine(p, aBytesPerLine) ((p)->lpVtbl->GetBytesPerLine(p, aBytesPerLine))
#define IFramebufferOverlay_get_PixelFormat(p, aPixelFormat) ((p)->lpVtbl->GetPixelFormat(p, aPixelFormat))
#define IFramebufferOverlay_GetPixelFormat(p, aPixelFormat) ((p)->lpVtbl->GetPixelFormat(p, aPixelFormat))
#define IFramebufferOverlay_get_HeightReduction(p, aHeightReduction) ((p)->lpVtbl->GetHeightReduction(p, aHeightReduction))
#define IFramebufferOverlay_GetHeightReduction(p, aHeightReduction) ((p)->lpVtbl->GetHeightReduction(p, aHeightReduction))
#define IFramebufferOverlay_get_Overlay(p, aOverlay) ((p)->lpVtbl->GetOverlay(p, aOverlay))
#define IFramebufferOverlay_GetOverlay(p, aOverlay) ((p)->lpVtbl->GetOverlay(p, aOverlay))
#define IFramebufferOverlay_get_WinId(p, aWinId) ((p)->lpVtbl->GetWinId(p, aWinId))
#define IFramebufferOverlay_GetWinId(p, aWinId) ((p)->lpVtbl->GetWinId(p, aWinId))
#define IFramebufferOverlay_get_Capabilities(p, aCapabilities) ((p)->lpVtbl->GetCapabilities(p, aCapabilities))
#define IFramebufferOverlay_GetCapabilities(p, aCapabilities) ((p)->lpVtbl->GetCapabilities(p, aCapabilities))
#define IFramebufferOverlay_NotifyUpdate(p, aX, aY, aWidth, aHeight) ((p)->lpVtbl->NotifyUpdate(p, aX, aY, aWidth, aHeight))
#define IFramebufferOverlay_NotifyUpdateImage(p, aX, aY, aWidth, aHeight, aImage) ((p)->lpVtbl->NotifyUpdateImage(p, aX, aY, aWidth, aHeight, aImage))
#define IFramebufferOverlay_NotifyChange(p, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight) ((p)->lpVtbl->NotifyChange(p, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight))
#define IFramebufferOverlay_VideoModeSupported(p, aWidth, aHeight, aBpp, aSupported) ((p)->lpVtbl->VideoModeSupported(p, aWidth, aHeight, aBpp, aSupported))
#define IFramebufferOverlay_GetVisibleRegion(p, aRectangles, aCount, aCountCopied) ((p)->lpVtbl->GetVisibleRegion(p, aRectangles, aCount, aCountCopied))
#define IFramebufferOverlay_SetVisibleRegion(p, aRectangles, aCount) ((p)->lpVtbl->SetVisibleRegion(p, aRectangles, aCount))
#define IFramebufferOverlay_ProcessVHWACommand(p, aCommand, aEnmCmd, aFromGuest) ((p)->lpVtbl->ProcessVHWACommand(p, aCommand, aEnmCmd, aFromGuest))
#define IFramebufferOverlay_Notify3DEvent(p, aType, aData) ((p)->lpVtbl->Notify3DEvent(p, aType, aData))
#define IFramebufferOverlay_get_X(p, aX) ((p)->lpVtbl->GetX(p, aX))
#define IFramebufferOverlay_GetX(p, aX) ((p)->lpVtbl->GetX(p, aX))
#define IFramebufferOverlay_get_Y(p, aY) ((p)->lpVtbl->GetY(p, aY))
#define IFramebufferOverlay_GetY(p, aY) ((p)->lpVtbl->GetY(p, aY))
#define IFramebufferOverlay_get_Visible(p, aVisible) ((p)->lpVtbl->GetVisible(p, aVisible))
#define IFramebufferOverlay_GetVisible(p, aVisible) ((p)->lpVtbl->GetVisible(p, aVisible))
#define IFramebufferOverlay_put_Visible(p, aVisible) ((p)->lpVtbl->SetVisible(p, aVisible))
#define IFramebufferOverlay_SetVisible(p, aVisible) ((p)->lpVtbl->SetVisible(p, aVisible))
#define IFramebufferOverlay_get_Alpha(p, aAlpha) ((p)->lpVtbl->GetAlpha(p, aAlpha))
#define IFramebufferOverlay_GetAlpha(p, aAlpha) ((p)->lpVtbl->GetAlpha(p, aAlpha))
#define IFramebufferOverlay_put_Alpha(p, aAlpha) ((p)->lpVtbl->SetAlpha(p, aAlpha))
#define IFramebufferOverlay_SetAlpha(p, aAlpha) ((p)->lpVtbl->SetAlpha(p, aAlpha))
#define IFramebufferOverlay_Move(p, aX, aY) ((p)->lpVtbl->Move(p, aX, aY))
#endif /* VBOX_WITH_GLUE */

interface IFramebufferOverlay
{
#ifndef VBOX_WITH_GLUE
    struct IFramebufferOverlay_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IFramebufferOverlayVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IFramebufferOverlay declaration */


/* Start of struct IGuestScreenInfo declaration */
#define IGUESTSCREENINFO_IID_STR "6b2f98f8-9641-4397-854a-040439d0114b"
#define IGUESTSCREENINFO_IID { \
    0x6b2f98f8, 0x9641, 0x4397, \
    { 0x85, 0x4a, 0x04, 0x04, 0x39, 0xd0, 0x11, 0x4b } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IGuestScreenInfo);
#ifndef VBOX_WITH_GLUE
struct IGuestScreenInfo_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetScreenId)(IGuestScreenInfo *pThis, PRUint32 *screenId);

    nsresult (*GetGuestMonitorStatus)(IGuestScreenInfo *pThis, PRUint32 *guestMonitorStatus);

    nsresult (*GetPrimary)(IGuestScreenInfo *pThis, PRBool *primary);

    nsresult (*GetOrigin)(IGuestScreenInfo *pThis, PRBool *origin);

    nsresult (*GetOriginX)(IGuestScreenInfo *pThis, PRInt32 *originX);

    nsresult (*GetOriginY)(IGuestScreenInfo *pThis, PRInt32 *originY);

    nsresult (*GetWidth)(IGuestScreenInfo *pThis, PRUint32 *width);

    nsresult (*GetHeight)(IGuestScreenInfo *pThis, PRUint32 *height);

    nsresult (*GetBitsPerPixel)(IGuestScreenInfo *pThis, PRUint32 *bitsPerPixel);

    nsresult (*GetExtendedInfo)(IGuestScreenInfo *pThis, PRUnichar * *extendedInfo);

};
#else /* VBOX_WITH_GLUE */
struct IGuestScreenInfoVtbl
{
    nsresult (*QueryInterface)(IGuestScreenInfo *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IGuestScreenInfo *pThis);
    nsrefcnt (*Release)(IGuestScreenInfo *pThis);
    nsresult (*GetScreenId)(IGuestScreenInfo *pThis, PRUint32 *screenId);

    nsresult (*GetGuestMonitorStatus)(IGuestScreenInfo *pThis, PRUint32 *guestMonitorStatus);

    nsresult (*GetPrimary)(IGuestScreenInfo *pThis, PRBool *primary);

    nsresult (*GetOrigin)(IGuestScreenInfo *pThis, PRBool *origin);

    nsresult (*GetOriginX)(IGuestScreenInfo *pThis, PRInt32 *originX);

    nsresult (*GetOriginY)(IGuestScreenInfo *pThis, PRInt32 *originY);

    nsresult (*GetWidth)(IGuestScreenInfo *pThis, PRUint32 *width);

    nsresult (*GetHeight)(IGuestScreenInfo *pThis, PRUint32 *height);

    nsresult (*GetBitsPerPixel)(IGuestScreenInfo *pThis, PRUint32 *bitsPerPixel);

    nsresult (*GetExtendedInfo)(IGuestScreenInfo *pThis, PRUnichar * *extendedInfo);

};
#define IGuestScreenInfo_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IGuestScreenInfo_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IGuestScreenInfo_Release(p) ((p)->lpVtbl->Release(p))
#define IGuestScreenInfo_get_ScreenId(p, aScreenId) ((p)->lpVtbl->GetScreenId(p, aScreenId))
#define IGuestScreenInfo_GetScreenId(p, aScreenId) ((p)->lpVtbl->GetScreenId(p, aScreenId))
#define IGuestScreenInfo_get_GuestMonitorStatus(p, aGuestMonitorStatus) ((p)->lpVtbl->GetGuestMonitorStatus(p, aGuestMonitorStatus))
#define IGuestScreenInfo_GetGuestMonitorStatus(p, aGuestMonitorStatus) ((p)->lpVtbl->GetGuestMonitorStatus(p, aGuestMonitorStatus))
#define IGuestScreenInfo_get_Primary(p, aPrimary) ((p)->lpVtbl->GetPrimary(p, aPrimary))
#define IGuestScreenInfo_GetPrimary(p, aPrimary) ((p)->lpVtbl->GetPrimary(p, aPrimary))
#define IGuestScreenInfo_get_Origin(p, aOrigin) ((p)->lpVtbl->GetOrigin(p, aOrigin))
#define IGuestScreenInfo_GetOrigin(p, aOrigin) ((p)->lpVtbl->GetOrigin(p, aOrigin))
#define IGuestScreenInfo_get_OriginX(p, aOriginX) ((p)->lpVtbl->GetOriginX(p, aOriginX))
#define IGuestScreenInfo_GetOriginX(p, aOriginX) ((p)->lpVtbl->GetOriginX(p, aOriginX))
#define IGuestScreenInfo_get_OriginY(p, aOriginY) ((p)->lpVtbl->GetOriginY(p, aOriginY))
#define IGuestScreenInfo_GetOriginY(p, aOriginY) ((p)->lpVtbl->GetOriginY(p, aOriginY))
#define IGuestScreenInfo_get_Width(p, aWidth) ((p)->lpVtbl->GetWidth(p, aWidth))
#define IGuestScreenInfo_GetWidth(p, aWidth) ((p)->lpVtbl->GetWidth(p, aWidth))
#define IGuestScreenInfo_get_Height(p, aHeight) ((p)->lpVtbl->GetHeight(p, aHeight))
#define IGuestScreenInfo_GetHeight(p, aHeight) ((p)->lpVtbl->GetHeight(p, aHeight))
#define IGuestScreenInfo_get_BitsPerPixel(p, aBitsPerPixel) ((p)->lpVtbl->GetBitsPerPixel(p, aBitsPerPixel))
#define IGuestScreenInfo_GetBitsPerPixel(p, aBitsPerPixel) ((p)->lpVtbl->GetBitsPerPixel(p, aBitsPerPixel))
#define IGuestScreenInfo_get_ExtendedInfo(p, aExtendedInfo) ((p)->lpVtbl->GetExtendedInfo(p, aExtendedInfo))
#define IGuestScreenInfo_GetExtendedInfo(p, aExtendedInfo) ((p)->lpVtbl->GetExtendedInfo(p, aExtendedInfo))
#endif /* VBOX_WITH_GLUE */

interface IGuestScreenInfo
{
#ifndef VBOX_WITH_GLUE
    struct IGuestScreenInfo_vtbl *vtbl;
#else /* VBOX_WITH_GLUE */
    CONST_VTBL struct IGuestScreenInfoVtbl *lpVtbl;
#endif /* VBOX_WITH_GLUE */
};
/* End of struct IGuestScreenInfo declaration */


/* Start of struct IDisplay declaration */
#define IDISPLAY_IID_STR "4680b2de-8690-11e9-b83d-5719e53cf1de"
#define IDISPLAY_IID { \
    0x4680b2de, 0x8690, 0x11e9, \
    { 0xb8, 0x3d, 0x57, 0x19, 0xe5, 0x3c, 0xf1, 0xde } \
}
/* COM compatibility */
VBOX_EXTERN_CONST(nsIID, IID_IDisplay);
#ifndef VBOX_WITH_GLUE
struct IDisplay_vtbl
{
    struct nsISupports_vtbl nsisupports;

    nsresult (*GetGuestScreenLayout)(IDisplay *pThis, PRUint32 *guestScreenLayoutSize, IGuestScreenInfo * **guestScreenLayout);

    nsresult (*GetInternalAndReservedAttribute1IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetScreenResolution)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 * bitsPerPixel,
        PRInt32 * xOrigin,
        PRInt32 * yOrigin,
        PRUint32 * guestMonitorStatus
    );

    nsresult (*AttachFramebuffer)(
        IDisplay *pThis,
        PRUint32 screenId,
        IFramebuffer * framebuffer,
        PRUnichar * * id
    );

    nsresult (*DetachFramebuffer)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUnichar * id
    );

    nsresult (*QueryFramebuffer)(
        IDisplay *pThis,
        PRUint32 screenId,
        IFramebuffer * * framebuffer
    );

    nsresult (*SetVideoModeHint)(
        IDisplay *pThis,
        PRUint32 display,
        PRBool enabled,
        PRBool changeOrigin,
        PRInt32 originX,
        PRInt32 originY,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bitsPerPixel,
        PRBool notify
    );

    nsresult (*GetVideoModeHint)(
        IDisplay *pThis,
        PRUint32 display,
        PRBool * enabled,
        PRBool * changeOrigin,
        PRInt32 * originX,
        PRInt32 * originY,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 * bitsPerPixel
    );

    nsresult (*SetSeamlessMode)(
        IDisplay *pThis,
        PRBool enabled
    );

    nsresult (*TakeScreenShot)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint8 * address,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bitmapFormat
    );

    nsresult (*TakeScreenShotToArray)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bitmapFormat,
        PRUint32 *screenDataSize,
        PRUint8** screenData
    );

    nsresult (*DrawToScreen)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint8 * address,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*InvalidateAndUpdate)(IDisplay *pThis );

    nsresult (*InvalidateAndUpdateScreen)(
        IDisplay *pThis,
        PRUint32 screenId
    );

    nsresult (*CompleteVHWACommand)(
        IDisplay *pThis,
        PRUint8 * command
    );

    nsresult (*ViewportChanged)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*QuerySourceBitmap)(
        IDisplay *pThis,
        PRUint32 screenId,
        IDisplaySourceBitmap * * displaySourceBitmap
    );

    nsresult (*NotifyScaleFactorChange)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint32 u32ScaleFactorWMultiplied,
        PRUint32 u32ScaleFactorHMultiplied
    );

    nsresult (*NotifyHiDPIOutputPolicyChange)(
        IDisplay *pThis,
        PRBool fUnscaledHiDPI
    );

    nsresult (*SetScreenLayout)(
        IDisplay *pThis,
        PRUint32 screenLayoutMode,
        PRUint32 guestScreenInfoSize,
        IGuestScreenInfo ** guestScreenInfo
    );

    nsresult (*DetachScreens)(
        IDisplay *pThis,
        PRUint32 screenIdsSize,
        PRInt32* screenIds
    );

    nsresult (*CreateGuestScreenInfo)(
        IDisplay *pThis,
        PRUint32 display,
        PRUint32 status,
        PRBool primary,
        PRBool changeOrigin,
        PRInt32 originX,
        PRInt32 originY,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bitsPerPixel,
        IGuestScreenInfo * * guestScreenInfo
    );

    nsresult (*InternalAndReservedMethod1IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod2IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod3IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod4IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod5IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod6IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod7IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod8IDisplay)(IDisplay *pThis);

};
#else /* VBOX_WITH_GLUE */
struct IDisplayVtbl
{
    nsresult (*QueryInterface)(IDisplay *pThis, const nsID *iid, void **resultp);
    nsrefcnt (*AddRef)(IDisplay *pThis);
    nsrefcnt (*Release)(IDisplay *pThis);
    nsresult (*GetGuestScreenLayout)(IDisplay *pThis, PRUint32 *guestScreenLayoutSize, IGuestScreenInfo * **guestScreenLayout);

    nsresult (*GetInternalAndReservedAttribute1IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute2IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute3IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute4IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute5IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute6IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute7IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute8IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute9IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute10IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute11IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute12IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute13IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute14IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute15IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetInternalAndReservedAttribute16IDisplay)(IDisplay *pThis, PRUint32 *reserved);

    nsresult (*GetScreenResolution)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 * bitsPerPixel,
        PRInt32 * xOrigin,
        PRInt32 * yOrigin,
        PRUint32 * guestMonitorStatus
    );

    nsresult (*AttachFramebuffer)(
        IDisplay *pThis,
        PRUint32 screenId,
        IFramebuffer * framebuffer,
        PRUnichar * * id
    );

    nsresult (*DetachFramebuffer)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUnichar * id
    );

    nsresult (*QueryFramebuffer)(
        IDisplay *pThis,
        PRUint32 screenId,
        IFramebuffer * * framebuffer
    );

    nsresult (*SetVideoModeHint)(
        IDisplay *pThis,
        PRUint32 display,
        PRBool enabled,
        PRBool changeOrigin,
        PRInt32 originX,
        PRInt32 originY,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bitsPerPixel,
        PRBool notify
    );

    nsresult (*GetVideoModeHint)(
        IDisplay *pThis,
        PRUint32 display,
        PRBool * enabled,
        PRBool * changeOrigin,
        PRInt32 * originX,
        PRInt32 * originY,
        PRUint32 * width,
        PRUint32 * height,
        PRUint32 * bitsPerPixel
    );

    nsresult (*SetSeamlessMode)(
        IDisplay *pThis,
        PRBool enabled
    );

    nsresult (*TakeScreenShot)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint8 * address,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bitmapFormat
    );

    nsresult (*TakeScreenShotToArray)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bitmapFormat,
        PRUint32 *screenDataSize,
        PRUint8** screenData
    );

    nsresult (*DrawToScreen)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint8 * address,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*InvalidateAndUpdate)(IDisplay *pThis );

    nsresult (*InvalidateAndUpdateScreen)(
        IDisplay *pThis,
        PRUint32 screenId
    );

    nsresult (*CompleteVHWACommand)(
        IDisplay *pThis,
        PRUint8 * command
    );

    nsresult (*ViewportChanged)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint32 x,
        PRUint32 y,
        PRUint32 width,
        PRUint32 height
    );

    nsresult (*QuerySourceBitmap)(
        IDisplay *pThis,
        PRUint32 screenId,
        IDisplaySourceBitmap * * displaySourceBitmap
    );

    nsresult (*NotifyScaleFactorChange)(
        IDisplay *pThis,
        PRUint32 screenId,
        PRUint32 u32ScaleFactorWMultiplied,
        PRUint32 u32ScaleFactorHMultiplied
    );

    nsresult (*NotifyHiDPIOutputPolicyChange)(
        IDisplay *pThis,
        PRBool fUnscaledHiDPI
    );

    nsresult (*SetScreenLayout)(
        IDisplay *pThis,
        PRUint32 screenLayoutMode,
        PRUint32 guestScreenInfoSize,
        IGuestScreenInfo ** guestScreenInfo
    );

    nsresult (*DetachScreens)(
        IDisplay *pThis,
        PRUint32 screenIdsSize,
        PRInt32* screenIds
    );

    nsresult (*CreateGuestScreenInfo)(
        IDisplay *pThis,
        PRUint32 display,
        PRUint32 status,
        PRBool primary,
        PRBool changeOrigin,
        PRInt32 originX,
        PRInt32 originY,
        PRUint32 width,
        PRUint32 height,
        PRUint32 bitsPerPixel,
        IGuestScreenInfo * * guestScreenInfo
    );

    nsresult (*InternalAndReservedMethod1IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod2IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod3IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod4IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod5IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod6IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod7IDisplay)(IDisplay *pThis);

    nsresult (*InternalAndReservedMethod8IDisplay)(IDisplay *pThis);

};
#define IDisplay_QueryInterface(p, iid, resultp) ((p)->lpVtbl->QueryInterface(p, iid, resultp))
#define IDisplay_AddRef(p) ((p)->lpVtbl->AddRef(p))
#define IDisplay_Release(p) ((p)->lpVtbl->Release(p))
#define IDisplay_get_GuestScreenLayout(p, aGuestScreenLayout) ((p)->lpVtbl->GetGuestScreenLayout(p, aGuestScreenLayout))
#define IDisplay_GetGuestScreenLayout(p, aGuestScreenLayout) ((p)->lpVtbl->GetGuestScreenLayout(p, aGuestScreenLayout))
#define IDisplay_GetScreenResolution(p, aScreenId, aWidth, aHeight, aBitsPerPixel, aXOrigin, aYOrigin, aGuestMonitorStatus) ((p)->lpVtbl->GetScreenResolution(p, aScreenId, aWidth, aHeight, aBitsPerPixel, aXOrigin, aYOrigin, aGuestMonitorStatus))
#define IDisplay_AttachFramebuffer(p, aScreenId, aFramebuffer, aId) ((p)->lpVtbl->AttachFramebuffer(p, aScreenId, aFramebuffer, aId))
#define IDisplay_DetachFramebuffer(p, aScreenId, aId) ((p)->lpVtbl->DetachFramebuffer(p, aScreenId, aId))
#define IDisplay_QueryFramebuffer(p, aScreenId, aFramebuffer) ((p)->lpVtbl->QueryFramebuffer(p, aScreenId, aFramebuffer))
#define IDisplay_SetVideoModeHint(p, aDisplay, aEnabled, aChangeOrigin, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, aNotify) ((p)->lpVtbl->SetVideoModeHint(p, aDisplay, aEnabled, aChangeOrigin, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, aNotify))
#define IDisplay_GetVideoModeHint(p, aDisplay, aEnabled, aChangeOrigin, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel) ((p)->lpVtbl->GetVideoModeHint(p, aDisplay, aEnabled, aChangeOrigin, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel))
#define IDisplay_SetSeamlessMode(p, aEnabled) ((p)->lpVtbl->SetSeamlessMode(p, aEnabled))
#define IDisplay_TakeScreenShot(p, aScreenId, aAddress, aWidth, aHeight, aBitmapFormat) ((p)->lpVtbl->TakeScreenShot(p, aScreenId, aAddress, aWidth, aHeight, aBitmapFormat))
#define IDisplay_TakeScreenShotToArray(p, aScreenId, aWidth, aHeight, aBitmapFormat, aScreenData) ((p)->lpVtbl->TakeScreenShotToArray(p, aScreenId, aWidth, aHeight, aBitmapFormat, aScreenData))
#define IDisplay_DrawToScreen(p, aScreenId, aAddress, aX, aY, aWidth, aHeight) ((p)->lpVtbl->DrawToScreen(p, aScreenId, aAddress, aX, aY, aWidth, aHeight))
#define IDisplay_InvalidateAndUpdate(p) ((p)->lpVtbl->InvalidateAndUpdate(p))
#define IDisplay_InvalidateAndUpdateScreen(p, aScreenId) ((p)->lpVtbl->InvalidateAndUpdateScreen(p, aScreenId))
#define IDisplay_CompleteVHWACommand(p, aCommand) ((p)->lpVtbl->CompleteVHWACommand(p, aCommand))
#define IDisplay_ViewportChanged(p, aScreenId, aX, aY, aWidth, aHeight) ((p)->lpVtbl->ViewportChanged(p, aScreenId, aX, aY, aWidth, aHeight))
#define IDisplay_QuerySourceBitmap(p, aScreenId, aDisplaySourceBitmap) ((p)->lpVtbl->QuerySourceBitmap(p, aScreenId, aDisplaySourceBitmap))
#define IDisplay_NotifyScaleFactorChange(p, aScreenId, aU32ScaleFactorWMultiplied, aU32ScaleFactorHMultiplied) ((p)->lpVtbl->NotifyScaleFactorChange(p, aScreenId, aU32ScaleFactorWMultiplied, aU32ScaleFactorHMultiplied))
#define IDisplay_NotifyHiDPIOutputPolicyChange(p, aFUnscaledHiDPI) ((p)->lpVtbl->NotifyHiDPIOutputPolicyChange(p, aFUnscaledHiDPI))
#define IDisplay_SetScreenLayout(p, aScreenLayoutMode, aGuestScreenInfo) ((p)->lpVtbl->SetScreenLayout(p, aScreenLayoutMode, aGuestScreenInfo))
#define IDisplay_DetachScreens(p, aScreenIds) ((p)->lpVtbl->DetachScreens(p, aScreenIds))
#define IDisplay_CreateGuestSc