
package org.virtualbox_7_1.jaxws;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for MetricType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="MetricType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Invalid"/>
 *     &lt;enumeration value="CpuUtilization"/>
 *     &lt;enumeration value="MemoryUtilization"/>
 *     &lt;enumeration value="DiskBytesRead"/>
 *     &lt;enumeration value="DiskBytesWritten"/>
 *     &lt;enumeration value="NetworksBytesIn"/>
 *     &lt;enumeration value="NetworksBytesOut"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "MetricType")
@XmlEnum
public enum MetricType {

    @XmlEnumValue("Invalid")
    INVALID("Invalid"),
    @XmlEnumValue("CpuUtilization")
    CPU_UTILIZATION("CpuUtilization"),
    @XmlEnumValue("MemoryUtilization")
    MEMORY_UTILIZATION("MemoryUtilization"),
    @XmlEnumValue("DiskBytesRead")
    DISK_BYTES_READ("DiskBytesRead"),
    @XmlEnumValue("DiskBytesWritten")
    DISK_BYTES_WRITTEN("DiskBytesWritten"),
    @XmlEnumValue("NetworksBytesIn")
    NETWORKS_BYTES_IN("NetworksBytesIn"),
    @XmlEnumValue("NetworksBytesOut")
    NETWORKS_BYTES_OUT("NetworksBytesOut");
    private final String value;

    MetricType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MetricType fromValue(String v) {
        for (MetricType c: MetricType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
